package q02b.exe.seguridad.beans;



import java.util.ArrayList;

//import java.util.HashMap;

//import java.util.Iterator;

//import java.util.Map;



import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import q02b.exe.seguridad.dataobjects.Q02bSeguridadDataBaseDAO;

import q02b.exe.seguridad.valueobjects.Q02bUsuario;

//import q02b.exe.utils.Q02bConstantes;

import q02b.exe.arquitectura.beans.Q02bBaseBean;

//import q02b.exe.arquitectura.utils.crypto.Q02bEncrypt;





public class Q02bSeguridadBean extends Q02bBaseBean{



	private static final long serialVersionUID = 3394757413314128326L;

	protected Q02bSeguridadDataBaseDAO daoSeguridad = null;

	

	 /** Constructor vacio */

    public Q02bSeguridadBean() {

        super();

    }

    

    /**

     * Mtodo que llama a un DAO para obtener un usuario a partir de su identificador.

     * @param idUsuario identificador de usuario.

     * @return Q02bUsuario con los datos del usuario encontrado.

     * @throws Exception   

     */  

    public Q02bUsuario obtenerUsuario (String dniUsuario) throws Exception {   	 

    	boolean error = false;

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuario: entrando "

      					+ "idUsuario: " + dniUsuario);

      		} 

			abrirConexion();			

			this.daoSeguridad = new Q02bSeguridadDataBaseDAO(this.getConn());

			Q02bUsuario usuario = this.daoSeguridad.obtenerUsuario(dniUsuario);

			return usuario;

    	}catch(Exception ex){  

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuario: " + sw.getBuffer ().toString());

	        throw ex;                     

    	}finally{

 		    try{

 		    	this.daoSeguridad.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuario: error liberando recursos");

	   	   	   }  

 		    }  		  

 		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuario: saliendo.");

	   		}

    	}

    }

    

    

    /**

     * Mtodo que llama a un DAO para obtener un usuario a partir de su identificador.

     * @param idUsuario identificador de usuario.

     * @return Q02bUsuario con los datos del usuario encontrado.

     * @throws Exception   

     */ 

    public ArrayList obtenerPlazos (Q02bUsuario usuario, int anyo) throws Exception {   	 

    	boolean error = false;

    	ArrayList listaPlazos = new ArrayList();

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuario: entrando "

      					+ "idUsuario: " + usuario.getDni() + "-provincia: " + usuario.getDescProvincia() + "-municipio: " + usuario.getDescMunicipio() ) ;

      		} 

			abrirConexion();			

			this.daoSeguridad = new Q02bSeguridadDataBaseDAO(this.getConn());

			listaPlazos = this.daoSeguridad.obtenerPlazos(anyo, usuario.getNiProvincia(), usuario.getNiMunicipio());

			return listaPlazos;

    	}catch(Exception ex){  

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuario: " + sw.getBuffer ().toString());

	        throw ex;                     

    	}finally{

 		    try{

 		    	this.daoSeguridad.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuario: error liberando recursos");

	   	   	   }  

 		    }  		  

 		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuario: saliendo.");

	   		}

    	}

    }

    

    /**

     * Mtodo que llama a un DAO para obtener el estado de un mdulo a partir de un proceso (pe:carpeta agentes)

     * @param nombreProcMnto identificador de proceso

     * @return boolean activo/inactivo.(0-activo , 1-inactivo)

     * @throws Exception   

     */  

    public String obtenerEstadoModulo(String nombreProcMnto) throws Exception {   	 

    	boolean error = false;    	

    	String estadoModulo=null;

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerEstadoModulo: entrando "

      					+ "nombreProcMnto: " + nombreProcMnto);

      		} 

			abrirConexion();			

			this.daoSeguridad = new Q02bSeguridadDataBaseDAO(this.getConn());

			estadoModulo= this.daoSeguridad.obtenerEstadoModulo(nombreProcMnto);

			return estadoModulo;

    	}catch(Exception ex){  

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerEstadoModulo: " + sw.getBuffer ().toString());

	        throw ex;                     

    	}finally{

 		    try{

 		    	this.daoSeguridad.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerEstadoModulo: error liberando recursos");

	   	   	   }  

 		    }  		  

 		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerEstadoModulo: saliendo.");

	   		}

    	}

    }

    

    

    

     /**

     * Mtodo que llama a un DAO comprobar si el usuario tiene permisos

     * @param niUsuario identificador de usuario

     * @param nombreProcMnto identificador de proceso

     * @return boolean activo/inactivo.(0-activo , 1-inactivo)

     * @throws Exception   

     */  

    public boolean esProcesoPermitido(String niUsuario,String nombreProcMnto) throws Exception {   	 

    	boolean error = false;    	

    	//String proceso=null;

    	boolean esPermitido=false;

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":esProcesoPermitido: entrando "

      					+ "usuario: " + niUsuario + "nombreProcMnto: " + nombreProcMnto);

      		} 

			abrirConexion();			

			this.daoSeguridad = new Q02bSeguridadDataBaseDAO(this.getConn());

			esPermitido= this.daoSeguridad.esProcesoPermitido(niUsuario,nombreProcMnto);

						

			return esPermitido;

    	}catch(Exception ex){  

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":esProcesoPermitido: " + sw.getBuffer ().toString());

	        throw ex;                     

    	}finally{

 		    try{

 		    	this.daoSeguridad.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":esProcesoPermitido: error liberando recursos");

	   	   	   }  

 		    }  		  

 		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":esProcesoPermitido: saliendo.");

	   		}

    	}

    }

    

    /**

     * Mtodo que llama a un DAO para comprobar si un usuario tiene acceso a un proceso.

     * @param niUsuario nmero interno del usuario en bbdd.

     * @param rutaProceso Ruta del proceso a ejecutar.

     * @return nmero interno del proceso en caso de existir, -1 en caso contrario.

     * @throws Exception

     */

    /*public long esProcesoPermitido(String niUsuario, String rutaProceso) throws Exception{

    	boolean error = false;

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":esProcesoPermitido: entrando "

      					+ "niUsuario: " + niUsuario);

      		}

    		abrirConexion();			

			this.daoSeguridad = new Q02bSeguridadDataBaseDAO(this.getConn());

			return this.daoSeguridad.esProcesoPermitido(niUsuario, rutaProceso);

    	}catch(Exception ex){

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":esProcesoPermitido: " + sw.getBuffer ().toString());

	        throw ex;                     

    	}finally{

 		    try{

 		    	this.daoSeguridad.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":esProcesoPermitido: error liberando recursos");

	   	   	   }  

 		    }  		  

 		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":esProcesoPermitido: saliendo");

	   		}

    	}

    }*/

    

   

}