package q02b.exe.roles.dataobjects;



import java.sql.Connection;

import java.sql.PreparedStatement;

import java.sql.ResultSet;

import java.util.ArrayList;



import q02b.exe.arquitectura.dataobjects.Q02bDataBaseDAO;

import q02b.exe.comun.valueobjects.Q02bCodigoValor;

import q02b.exe.roles.valueobjects.Q02bRoles;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ021FS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ021GS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ021HS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ021KS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ021LS00;

import q02b.exe.utils.Q02bFormatData;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;



public class Q02bRolesDataBaseDAO extends Q02bDataBaseDAO {

	private static final long serialVersionUID = -8520551641771839103L;



	private static Q70Traza tr = Q70Traza.getSingleton();



	private static final String COMPONENTE = "DAO_ACCESO_DATOS";



	public Q02bRolesDataBaseDAO() {

		super();

	}



	public Q02bRolesDataBaseDAO(Connection conn) {

		super(conn);

	}



	public void rellenaFiltroRoles(Q02bRoles rolFiltro, Q02bTablaBDQ021GS00 tablaRoles) throws Exception {

		// Definicin de variables que no se van a modificar

		final String TRACE_METODO = ":rellenaFiltroRoles:";

		StringBuffer addWhere = new StringBuffer();

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ TRACE_METODO + " entrando");

			}

			if (rolFiltro != null) {

				if (!Q02bFormatData.esVacio(rolFiltro.getCodigo())) {

					 addWhere.append(" AND ( (TRANSLATE(UPPER(");

		             addWhere.append(Q02bTablaBDQ021GS00.NOMCOLUMN_Q021GT00_COD);

		             addWhere.append("),'','AEIOUAEIOU')) LIKE  '%");

		             addWhere.append(Q02bFormatData.convertirMaysculaSinAcento(rolFiltro.getCodigo()));

		             addWhere.append("%' ) ");

				}

				if (!Q02bFormatData.esVacio(rolFiltro.getDescripcion())) {

					addWhere.append(" AND ( (TRANSLATE(UPPER(");

		             addWhere.append(Q02bTablaBDQ021GS00.NOMCOLUMN_Q021GT00_DESC);

		             addWhere.append("),'','AEIOUAEIOU')) LIKE  '%");

		             addWhere.append(Q02bFormatData.convertirMaysculaSinAcento(rolFiltro.getDescripcion()));

		             addWhere.append("%' ) ");

				}

				tablaRoles.setOrderBy(tablaRoles.NOMCOLUMN_Q021GT00_COD);

				tablaRoles.setAditionalWhere(addWhere.toString());

			}

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ TRACE_METODO + sw.getBuffer().toString());

			throw ex;

		} finally {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ TRACE_METODO + " saliendo");

			}

		}

	}// fin rellenaFiltroRoles



	private ArrayList rellenaVOsRoles(ResultSet rs) throws Exception {

		Q02bRoles roles;

		ArrayList listaRoles = new ArrayList();

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":rellenaVOsRoles: entrando");

			}

			while (rs.next()) {

				// se cargan en el objeto roles los datos recuperados

				roles = new Q02bRoles();

				rellenarVORoles(roles, rs);

				listaRoles.add(roles);

			}

			return listaRoles;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":rellenaVOsRoles: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":rellenaVOsRoles: saliendo");

			}

		}

	}// fin rellenaVOsRoles(rs)



	private void rellenarVORoles(Q02bRoles roles, ResultSet rs) throws Exception {

		try {

			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName()	+ ":rellenarVORoles: Hay Datos");

			roles.setCodigo(rs.getString(Q02bTablaBDQ021GS00.COLUMN_Q021GT00_COD));

			roles.setDescripcion(rs.getString(Q02bTablaBDQ021GS00.COLUMN_Q021GT00_DESC));

			roles.setIdRol(rs.getString(Q02bTablaBDQ021GS00.COLUMN_Q021GT00_NI));

		} catch (Exception e) {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":rellenarVORoles: error " + e.getMessage());

			}

		}

	} // fin rellenaVOsRoles(roles, rs)



	private int dameSeqIdRol(Q02bTablaBDQ021GS00 tablaRoles) throws Exception {

		int idRol = 1;

		ResultSet rs = null;

		PreparedStatement prepStmt = null;

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":dameSeqIdRoles: entrando");

			}

			StringBuffer query = new StringBuffer(" SELECT Q021GQ00.NEXTVAL FROM DUAL ");

			prepStmt = this.getConnection().prepareStatement(query.toString());

			rs = prepStmt.executeQuery();

			tablaRoles.addResultSet(rs);

			tablaRoles.addStatement(prepStmt);

			if (rs.next()) {

				idRol = rs.getInt(1);

			}

			return idRol;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":dameSeqIdRoles: " + sw.getBuffer().toString());

			throw ex;

		}

	}// dameSegIdRoles



	public void rellenaDatosRoles(Q02bRoles rol,	Q02bTablaBDQ021GS00 tablaRoles) throws Exception {

		// se definen objetos necesarios.

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":rellenaDatosRoles: entrando");

			}

			// se aaden los datos

			tablaRoles.setQ021GT00_NI(Q02bFormatData.checkLongNull(rol.getIdRol()));

			tablaRoles.setQ021GT00_COD(Q02bFormatData.checkStringNull(rol.getCodigo()));

			tablaRoles.setQ021GT00_DESC(Q02bFormatData.checkStringNull(rol.getDescripcion()));  

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":rellenaDatosRoles: "+ sw.getBuffer().toString());

			throw ex;

		} finally {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":rellenaDatosRoles: saliendo = "+ tablaRoles.getQ021GT00_NI());

			}

		}

	}// rellenaDatosRoles



	public ArrayList getRoles(Q02bRoles rol) throws Exception {

		// se instancian los objetos necesarios para realizar la consulta.

		Q02bTablaBDQ021GS00 tablaRoles = null;

		ResultSet rs = null;

		ArrayList listaRoles = new ArrayList();



		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":getRoles: entrando");

			}



			// se instancia la clase del tablas bd a llamar pasandole la conexion

			tablaRoles = new Q02bTablaBDQ021GS00(this.getConnection());



			// se aade la where

			this.rellenaFiltroRoles(rol, tablaRoles);



			// se realiza la select

			rs = tablaRoles.select();

			// aadimos el cursos para luego poder liberarlo ( en el freeResources)

			tablaRoles.addResultSet(rs);

			// se trata el resultado obtenido aadiendolo a la lista de salida

			listaRoles = this.rellenaVOsRoles(rs);



			return listaRoles;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":getRoles: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				// liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet

				tablaRoles.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":getRoles: error liberando recursos.");

				}

			}

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":getRoles: saliendo.");

			}

		}

	}// fin getRoles



	/**

	 * Funcin que inserta los datos del rol pasado como parmetro en la BBDD

	 * 

	 * @param roles - Datos del rol a insertar

	 * @throws Exception

	 */

	public void insertarRoles(Q02bRoles rol) throws Exception {

		int idRoles = 0;

		Q02bTablaBDQ021GS00 tablaRoles = null;

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":insertarRoles: entrando");

			}

			// se crea el objeto de tablasBD

			tablaRoles = new Q02bTablaBDQ021GS00(this.getConnection());

			// primero recuperamos el nmero interno que le corresponde

			idRoles = dameSeqIdRol(tablaRoles);

			rol.setIdRol(Integer.toString(idRoles));

			// se aaden los datos a insertar

			this.rellenaDatosRoles(rol, tablaRoles);

			tablaRoles.setUSER(new Long(this.getUser()));

			

			// se realiza la insert

			tablaRoles.insert();

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":insertarRoles: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				tablaRoles.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE,Q70TraceLevel.ERROR,this.getClass().getName()+ ":insertarRoles: error liberando recursos");

				}

			}

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":insertarRoles: saliendo");

			}

		}

	} // insertarRoles



	/**

	 * Mtodo que dado el nmero interno del rol recupera de la BBDD

	 * los datos de dicho rol

	 * @param idRol

	 * @return

	 */

	public Q02bRoles obtenerRol(String idRol) throws Exception {

		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":obtenerRol , ** dao idRol= "+ idRol + "  ** entrando");

		}



		// se crean los objetos necesarios para realizar la select.

		Q02bTablaBDQ021GS00 Q02bTablaBDQ021GS00obj = null;

		Q02bRoles rolBD = null;

		ResultSet rs = null;

		try {

			if (idRol != null) {

				Q02bTablaBDQ021GS00obj = new Q02bTablaBDQ021GS00(this.getConnection());



				// se pone el filtro

				Q02bTablaBDQ021GS00obj.setQ021GT00_NI_WHERE(new Long(idRol));



				rs = Q02bTablaBDQ021GS00obj.select();

				Q02bTablaBDQ021GS00obj.addResultSet(rs);

				rolBD = new Q02bRoles();

				if (rs.next()) {

					this.rellenarVORoles(rolBD, rs);

				}

			}

			return rolBD;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":obtenerRol: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				Q02bTablaBDQ021GS00obj.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":obtenerRol: error liberando recursos");

				}

			}

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":obtenerRol: saliendo");

			}

		}

	}// fin obtenerRol



	/**

	 * Funcin que borra el rol pasado como parmetro de la BBDD

	 * @param idRol - nmero interno del rol a borrar

	 * @throws Exception

	 */

	public void borrarRoles(String idRol) throws Exception {

		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":borrarRoles: entrando");

		}

		Q02bTablaBDQ021GS00 Q02bTablaBDQ021GS00obj = null;

		try {

			// se crean los objetos necesarios

			Q02bTablaBDQ021GS00obj = new Q02bTablaBDQ021GS00(this.getConnection());



			// segmento tecnico

			//Q02bTablaBDQ021GS00obj.setUser(this.getUser());



			// se pone el filtro para la delete

			Q02bTablaBDQ021GS00obj.setQ021GT00_NI_WHERE(new Long(idRol));



			// se lanza el delete

			Q02bTablaBDQ021GS00obj.delete();

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":borrarRoles: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				Q02bTablaBDQ021GS00obj.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":borrarRoles: error liberando recursos");

				}

			}

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":borrarRoles: saliendo");

			}

		}

	}// fin borrarRoles



	/**

	 * Funcin que modifica los datos del roles pasado como parmetro en la BBDD

	 * 

	 * @param roles - Datos del roles a modificar

	 * @throws Exception

	 */

	public void modificarRoles(Q02bRoles rol) throws Exception {



		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":modificarRoles: entrando");

		}

		// Se instancian los objetos necesarios.

		Q02bTablaBDQ021GS00 Q02bTablaBDQ021GS00obj = null;

		try {

			// se crea el objeto de tablasBD

			Q02bTablaBDQ021GS00obj = new Q02bTablaBDQ021GS00(this.getConnection());



			// segmento tecnico

			// Q02bTablaBDQ021GS00obj.setUser(this.getUser());



			rellenaDatosRoles(rol, Q02bTablaBDQ021GS00obj);

			Q02bTablaBDQ021GS00obj.setQ021GT00_NI_WHERE(new Long(rol.getIdRol()));



			// se realiza la update

			Q02bTablaBDQ021GS00obj.update();

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":modificarRoles: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				Q02bTablaBDQ021GS00obj.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":modificarRoles: error liberando recursos");

				}

			}

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":modificarRoles: saliendo");

			}

		}

	} // fin modificarRoles



	//--------------------Rol-Proceso-----------------------------------------//

	

	 /**

     * Mtodo que asigna un proceso a un rol.

     * @param niRol

     * @param niProceso

     * @throws Exception

     */

    public void insertarProcesoRol(String idRol, String idProceso) throws Exception{

    	Q02bTablaBDQ021LS00 tablaBDRolesProcesos = null;

    	try{

	    	if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarProcesoRol: entrando");

	   		}

	    	tablaBDRolesProcesos = new Q02bTablaBDQ021LS00(this.getConnection());



         	//se aaden los datos a insertar

	    	tablaBDRolesProcesos.setQ021GT00_NI(new Long(idRol));

	    	tablaBDRolesProcesos.setQ021FT00_NI(new Long(idProceso));

      		

      		//se realiza la insert

	    	tablaBDRolesProcesos.insert();

      			      		

     	}catch(Exception ex){   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarProcesoRol: " + sw.getBuffer ().toString());

     		throw ex;

     	}finally{

     		try{

     			tablaBDRolesProcesos.freeResourcesNotConnection();	

     		}catch(Exception ex){

     			if (tr.isTraceActive()){

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarProcesoRol: error liberando recursos");

 		   	   	}  

 			}  		

 			if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarProcesoRol: saliendo");                

            }       	

     	}	

    }//fin insertarProcesoRol

    

    /**

     * Mtodo que devuelve una lista con los procesos asignados a un rol.

     * @param idRol nmero interno del rol.

     * @return ArrayList con la lista de procesos encontrados

     * @throws Exception

     */

    public ArrayList obtenerProcesosSeleccionados(String idRol) throws Exception{

    	Q02bTablaBDQ021LS00 tablaBDRolesProcesos = null;

    	Q02bTablaBDQ021FS00 tablaBDProcesos = null;

    	ResultSet rs = null;

    	ResultSet rs2 = null;

    	ArrayList listaProcesosSeleccionados = new ArrayList();

    	

    	try{

	    	if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerProcesosSeleccionados: entrando");

	   		}

	    	tablaBDRolesProcesos = new Q02bTablaBDQ021LS00(this.getConnection());

	    	tablaBDProcesos = new Q02bTablaBDQ021FS00(this.getConnection());

	    		    	

	    	tablaBDRolesProcesos.setDistinct(Q02bTablaBDQ021LS00.NOMCOLUMN_Q021FT00_NI);  	

	    	

	    	tablaBDRolesProcesos.setQ021GT00_NI_WHERE(new Long(idRol));

	    	

	    	rs = tablaBDRolesProcesos.selectDistinct();

	    	

      		while (rs.next()){

      			tablaBDProcesos.setQ021FT00_NI_WHERE(new Long(rs.getString(Q02bTablaBDQ021LS00.NOMCOLUMN_Q021FT00_NI)));

    	    	rs2 = tablaBDProcesos.select();

    	    	if (rs2.next()) {

    	    		Q02bCodigoValor proceso = new Q02bCodigoValor (rs2.getString(Q02bTablaBDQ021FS00.NOMCOLUMN_Q021FT00_NI),

      					rs2.getString(Q02bTablaBDQ021FS00.NOMCOLUMN_Q021FT00_DESC));

    	    		listaProcesosSeleccionados.add(proceso);

    	    	}

      		}	

      		return listaProcesosSeleccionados;

     	}catch(Exception ex){   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerProcesosSeleccionados: " + sw.getBuffer ().toString());

     		throw ex;

     	}finally{

     		try{

     			tablaBDRolesProcesos.freeResourcesNotConnection();	

     		}catch(Exception ex){

     			if (tr.isTraceActive()){

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerProcesosSeleccionados: error liberando recursos");

 		   	   	}  

 			}  		

 			if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerProcesosSeleccionados: saliendo");                

            }       	

     	}	

    }

    

    /**

     * Mtodo que borra los procesos asignados a un rol determinado.

     * @param idRol

     * @throws Exception

     */

    public void borrarProcesosRol(String idRol) throws Exception{

    	Q02bTablaBDQ021LS00 tablaBDRolesProcesos = null;

    	try{

	    	if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarRolesProceso: entrando");

	   		}

	    	tablaBDRolesProcesos = new Q02bTablaBDQ021LS00(this.getConnection());



	    	tablaBDRolesProcesos.setQ021GT00_NI_WHERE(new Long(idRol));

      		

      		//se realiza la delete

	    	tablaBDRolesProcesos.delete();

      			      		

     	}catch(Exception ex){   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarRolesProceso: " + sw.getBuffer ().toString());

     		throw ex;

     	}finally{

     		try{

     			tablaBDRolesProcesos.freeResourcesNotConnection();	

     		}catch(Exception ex){

     			if (tr.isTraceActive()){

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarRolesProceso: error liberando recursos");

 		   	   	}  

 			}  		

 			if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarRolesProceso: saliendo");                

            }       	

     	}	

    }//fin borrarProcesosRol

    

    /**

     * Mtodo que borra los roles asignados a un proceso determinado.

     * @param idProceso

     * @throws Exception

     */

    public void borrarRolProceso(String idProceso, String idRol) throws Exception{

    	Q02bTablaBDQ021LS00 tablaBDRolesProcesos = null;

    	try{

	    	if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarRolesProceso: entrando");

	   		}

	    	tablaBDRolesProcesos = new Q02bTablaBDQ021LS00(this.getConnection());



	    	tablaBDRolesProcesos.setQ021FT00_NI_WHERE(new Long(idProceso));

	    	tablaBDRolesProcesos.setQ021GT00_NI_WHERE(new Long(idRol));

      		

      		//se realiza la delete

	    	tablaBDRolesProcesos.delete();

     	}catch(Exception ex){   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarRolesProceso: " + sw.getBuffer ().toString());

     		throw ex;

     	}finally{

     		try{

     			tablaBDRolesProcesos.freeResourcesNotConnection();	

     		}catch(Exception ex){

     			if (tr.isTraceActive()){

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarRolesProceso: error liberando recursos");

 		   	   	}  

 			}  		

 			if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarRolesProceso: saliendo");                

            }       	

     	}	

    }

    

	//--------------------Rol-Grupo-------------------------------------------//

    /**

     * Mtodo que asigna un grupo a un rol.

     * @param niRol

     * @param niGrupo

     * @throws Exception

     */

    public void insertarGrupoRol(String idRol, String idGrupo) throws Exception{

    	Q02bTablaBDQ021KS00 tablaBDGruposRoles = null;

    	try{

	    	if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarGrupoRol: entrando");

	   		}

	    	tablaBDGruposRoles = new Q02bTablaBDQ021KS00(this.getConnection());



         	//se aaden los datos a insertar

	    	tablaBDGruposRoles.setQ021GT00_NI(new Long(idRol));

	    	tablaBDGruposRoles.setQ021HT00_NI(new Long(idGrupo));

      		

      		//se realiza la insert

	    	tablaBDGruposRoles.insert();

      			      		

     	}catch(Exception ex){   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarGrupoRol: " + sw.getBuffer ().toString());

     		throw ex;

     	}finally{

     		try{

     			tablaBDGruposRoles.freeResourcesNotConnection();	

     		}catch(Exception ex){

     			if (tr.isTraceActive()){

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarGrupoRol: error liberando recursos");

 		   	   	}  

 			}  		

 			if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarGrupoRol: saliendo");                

            }       	

     	}	

    }

    

    /**

     * Mtodo que devuelve una lista con los grupos asignados a un rol.

     * @param idRol nmero interno del rol.

     * @return ArrayList con la lista de grupos encontrados

     * @throws Exception

     */

    public ArrayList obtenerGruposSeleccionados(String idRol) throws Exception{

    	Q02bTablaBDQ021KS00 tablaBDGruposRoles = null;

    	Q02bTablaBDQ021HS00 tablaBDGrupos = null;

    	ResultSet rs = null;

    	ResultSet rs2 = null;

    	ArrayList listaGruposSeleccionados = new ArrayList();

    	

    	try{

	    	if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGruposSeleccionados: entrando");

	   		}

	    	tablaBDGruposRoles = new Q02bTablaBDQ021KS00(this.getConnection());

	    	tablaBDGrupos = new Q02bTablaBDQ021HS00(this.getConnection());

	    		    	

	    	tablaBDGruposRoles.setDistinct(Q02bTablaBDQ021KS00.NOMCOLUMN_Q021HT00_NI);	

	    	

	    	tablaBDGruposRoles.setQ021GT00_NI_WHERE(new Long(idRol));

	    	

	    	rs = tablaBDGruposRoles.select();

	    	

      		while (rs.next()){

      			tablaBDGrupos.setQ021HT00_NI_WHERE(new Long(rs.getString(Q02bTablaBDQ021KS00.NOMCOLUMN_Q021HT00_NI)));

    	    	rs2 = tablaBDGrupos.select();

    	    	if (rs2.next()) {

    	    		Q02bCodigoValor grupo = new Q02bCodigoValor (rs2.getString(Q02bTablaBDQ021HS00.NOMCOLUMN_Q021HT00_NI),

      					rs2.getString(Q02bTablaBDQ021HS00.NOMCOLUMN_Q021HT00_DESC));

    	    		listaGruposSeleccionados.add(grupo);

    	    	}

      		}

      		return listaGruposSeleccionados;

     	}catch(Exception ex){   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGruposSeleccionados: " + sw.getBuffer ().toString());

     		throw ex;

     	}finally{

     		try{

     			tablaBDGruposRoles.freeResourcesNotConnection();	

     		}catch(Exception ex){

     			if (tr.isTraceActive()){

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGruposSeleccionados: error liberando recursos");

 		   	   	}  

 			}  		

 			if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGruposSeleccionados: saliendo");                

            }       	

     	}	

    }

    

    /**

     * Mtodo que devuelve una lista con los grupos no asignados a un rol.

     * @param idRol nmero interno del rol.

     * @return ArrayList con la lista de grupos encontrados

     * @throws Exception

     */

    public ArrayList obtenerGruposNoSeleccionados(String idRol) throws Exception{

    	Q02bTablaBDQ021KS00 tablaBDGruposRoles = null;

    	Q02bTablaBDQ021HS00 tablaBDGrupos = null;

    	ResultSet rs = null;

    	ArrayList listaGruposNoSeleccionados = new ArrayList();

    	

    	try{

	    	if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGruposNoSeleccionados: entrando");

	   		}

	    	tablaBDGruposRoles = new Q02bTablaBDQ021KS00(this.getConnection());

	    	tablaBDGrupos = new Q02bTablaBDQ021HS00(this.getConnection());

	    		    	

	    	tablaBDGrupos.setDistinct(Q02bTablaBDQ021KS00.NOMCOLUMN_Q021HT00_NI);

	    	

	    	StringBuffer where = new StringBuffer();

	    	

	    	where.append(Q02bTablaBDQ021KS00.NOMCOLUMN_Q021HT00_NI).append(" NOT IN (SELECT ").

	    	append(Q02bTablaBDQ021KS00.NOMCOLUMN_Q021HT00_NI).append(" FROM ").

	    	append(tablaBDGruposRoles.getTableFrom()).append(" WHERE ").

	    	append(Q02bTablaBDQ021KS00.NOMCOLUMN_Q021GT00_NI).append("=").append(idRol).append(")");

	    	

	    	rs = tablaBDGrupos.selectDistinct(where.toString());

	    	

      		while (rs.next()){

      			tablaBDGrupos.setQ021HT00_NI_WHERE(new Long(rs.getString(Q02bTablaBDQ021KS00.NOMCOLUMN_Q021HT00_NI)));

      			ResultSet rs2 = tablaBDGrupos.select();

				tablaBDGrupos.addResultSet(rs2);

				if (rs2.next()) {

	      			Q02bCodigoValor grupo = new Q02bCodigoValor (rs2.getString(Q02bTablaBDQ021HS00.NOMCOLUMN_Q021HT00_NI),

	      					rs2.getString(Q02bTablaBDQ021HS00.NOMCOLUMN_Q021HT00_DESC));

	      			listaGruposNoSeleccionados.add(grupo);

				}

      		}

      		

      		return listaGruposNoSeleccionados;

     	}catch(Exception ex){   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGruposNoSeleccionados: " + sw.getBuffer ().toString());

     		throw ex;

     	}finally{

     		try{

     			tablaBDGruposRoles.freeResourcesNotConnection();

     			tablaBDGrupos.freeResourcesNotConnection();	

     		}catch(Exception ex){

     			if (tr.isTraceActive()){

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGruposNoSeleccionados: error liberando recursos");

 		   	   	}  

 			}  		

 			if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGruposNoSeleccionados: saliendo");                

            }       	

     	}	

    }

    

    /**

     * Mtodo que borra los grupos asignados a un rol determinado.

     * @param idRol

     * @throws Exception

     */

    public void borrarGruposRol(String idRol) throws Exception{

    	Q02bTablaBDQ021KS00 tablaBDGruposRoles = null;

    	try{

	    	if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarRolesProceso: entrando");

	   		}

	    	tablaBDGruposRoles = new Q02bTablaBDQ021KS00(this.getConnection());



	    	tablaBDGruposRoles.setQ021GT00_NI_WHERE(new Long(idRol));

      		

      		//se realiza la delete

	    	tablaBDGruposRoles.delete();

      			      		

     	}catch(Exception ex){   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarRolesProceso: " + sw.getBuffer ().toString());

     		throw ex;

     	}finally{

     		try{

     			tablaBDGruposRoles.freeResourcesNotConnection();	

     		}catch(Exception ex){

     			if (tr.isTraceActive()){

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarRolesProceso: error liberando recursos");

 		   	   	}  

 			}  		

 			if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarRolesProceso: saliendo");                

            }       	

     	}	

    }//fin borrarRolesProceso

}

