package q02b.exe.roles.beans;



import java.util.ArrayList;



import q02b.exe.arquitectura.beans.Q02bBaseBean;

import q02b.exe.comun.valueobjects.Q02bCodigoValor;

import q02b.exe.roles.dataobjects.Q02bRolesDataBaseDAO;

import q02b.exe.roles.valueobjects.Q02bRoles;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;



public class Q02bRolesBean extends Q02bBaseBean {

	private static final long serialVersionUID = 5474311672836163390L;



	protected Q02bRolesDataBaseDAO daoRoles = null;



	final static String LISTA_PROCESOS = "listaRoles";



	/** Constructor vacio */

	public Q02bRolesBean() {

		super();

	}



	/**

	 * Funcin que recupera los roles

	 * @return listaRoles - Listado de roles obtenidos

	 * @throws Exception

	 */

	public ArrayList obtenerRoles(Q02bRoles rol) throws Exception {

		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":obtenerRoles: entrando.");

		}

		ArrayList listaRoles = new ArrayList();

		boolean error = false;



		try {

			// se abre la conexin

			abrirConexion();

			// se instancia el dao pasandole la conexin

			daoRoles = new Q02bRolesDataBaseDAO(this.getConn());



			// Segmento tecnico

			// daoRoles.setUser(this.getAutenticador().getUser());

			// daoRoles.setIdioma(this.getAutenticador().getIdioma());



			listaRoles = daoRoles.getRoles(rol);

			return listaRoles;

		} catch (Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":obtenerRoles: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				daoRoles.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE,Q70TraceLevel.ERROR,this.getClass().getName()+ ":obtenerRoles: error liberando recursos");

				}

			}

			// se cierra la conexin

			cerrarConexion(error);

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":obtenerRoles: saliendo.");

			}

		}

	} // fin obtenerRoles



	/**

	 * Funcin que inserta los datos del rol pasado como parmetro en la BBDD

	 * @param rol - Datos del rol a insertar

	 * @throws Exception

	 */

	public void insertarRoles(Q02bRoles rol) throws Exception {

		boolean error = false;

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":insertarRoles: entrando");

			}

			// se abre la conexin

			abrirConexion();



			// se instancia el dao pasandole la conexin

			daoRoles = new Q02bRolesDataBaseDAO(this.getConn());

			

			// se pasan los parmetros de usuario e idioma

			daoRoles.setUser(this.autenticador.getUser());

			daoRoles.setIdioma(this.autenticador.getIdioma());



			// se llama la metodo del DAO que realiza la insert

			daoRoles.insertarRoles(rol);

			

			ArrayList listaProcesos = rol.getListaProcesosSeleccionados();

			ArrayList listaGrupos = rol.getListaGruposSeleccionados();

			

			//insertamos los procesos asignados al rol

			for (int i=0;i<listaProcesos.size();i++){

				daoRoles.insertarProcesoRol(rol.getIdRol(),(String) listaProcesos.get(i));

			}

			

			// insertamos los grupos asignados al rol

			for (int i=0;i<listaGrupos.size();i++){

				daoRoles.insertarGrupoRol(rol.getIdRol(),(String)listaGrupos.get(i));

			}

		} catch (Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":insertarRoles: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				daoRoles.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE,Q70TraceLevel.ERROR,this.getClass().getName()+ ":insertarRoles: error liberando recursos");

				}

			}

			// se cierra la conexin

			cerrarConexion(error);

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":insertarRoles: saliendo.");

			}

		}

	}// fin insertarRoles



	/**

	 * Mtodo que dado el nmero interno del rol recupera de la BBDD los datos de dicho rol.

	 * @param idRol

	 * @return rol

	 */

	public Q02bRoles obtenerRolModificacion(String idRol) throws Exception {

		boolean error = false;

		Q02bRoles rol = null;

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":obtenerRol, ** idRoles bean="	+ idRol + " *** entrando");

			}



			// se abre la conexin

			abrirConexion();



			// se instancia el dao pasandole la conexin

			daoRoles = new Q02bRolesDataBaseDAO(this.getConn());



			// Segmento tecnico

			daoRoles.setUser(this.getAutenticador().getUser());

			daoRoles.setIdioma(this.getAutenticador().getIdioma());



			// se llama al mtodo del dao que recupera el roles

			rol = daoRoles.obtenerRol(idRol);



			//Obtenemos los grupos seleccionados para el rol

			rol.setListaGruposSeleccionados(daoRoles.obtenerGruposSeleccionados(idRol));

			

			// Obtenemos los procesos seleccionados para el rol

			rol.setListaProcesosSeleccionados(daoRoles.obtenerProcesosSeleccionados(idRol));

			

			// Obtenemos los grupos no seleccionados

			rol.setListaGrupos(daoRoles.obtenerGruposNoSeleccionados(idRol));

			

			// se devuelve el roles recuperado

			return rol;

		} catch (Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":obtenerRol: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				daoRoles.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":obtenerRol: error liberando recursos");

				}

			}

			// se cierra la conexin

			cerrarConexion(error);

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":obtenerRol: saliendo.");

			}

		}

	}// fin obtenerRolModificacion

	

	/**

	 * Mtodo que dado el nmero interno del rol recupera de la BBDD los datos de dicho rol.

	 * @param idRol

	 * @return rol

	 */

	public Q02bRoles obtenerRolConsulta(String idRol) throws Exception {

		boolean error = false;

		Q02bRoles rol = null;

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":obtenerRol, ** idRoles bean="	+ idRol + " *** entrando");

			}



			// se abre la conexin

			abrirConexion();



			// se instancia el dao pasandole la conexin

			daoRoles = new Q02bRolesDataBaseDAO(this.getConn());



			// Segmento tecnico

			daoRoles.setUser(this.getAutenticador().getUser());

			daoRoles.setIdioma(this.getAutenticador().getIdioma());



			// se llama al mtodo del dao que recupera el roles

			rol = daoRoles.obtenerRol(idRol);



			//Obtenemos los grupos seleccionados para el rol

			rol.setListaGruposSeleccionados(daoRoles.obtenerGruposSeleccionados(idRol));

			

			// Obtenemos los procesos seleccionados para el rol

			rol.setListaProcesosSeleccionados(daoRoles.obtenerProcesosSeleccionados(idRol));

					

			// se devuelve el roles recuperado

			return rol;

		} catch (Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":obtenerRol: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				daoRoles.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":obtenerRol: error liberando recursos");

				}

			}

			// se cierra la conexin

			cerrarConexion(error);

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":obtenerRol: saliendo.");

			}

		}

	}// fin obtenerRolConsulta



	/**

	 * Funcin que borra el rol pasado como parmetro de la BBDD

	 * @param idRol - nmero interno del rol a borrar

	 * @throws Exception

	 */

	public void borrarRoles(String idRol) throws Exception {

		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":borrarRoles: entrando");

		}

		boolean error = false;

		try {

			// se abre la conexin

			abrirConexion();



			// se instancia el dao pasandole la conexin

			daoRoles = new Q02bRolesDataBaseDAO(this.getConn());



			// Segmento tecnico

			daoRoles.setUser(this.getAutenticador().getUser());

			daoRoles.setIdioma(this.getAutenticador().getIdioma());



			//se borran los Procesos asignados a ese rol 

			daoRoles.borrarProcesosRol(idRol);

			//se borran los Grupos asignados a ese rol

			daoRoles.borrarGruposRol(idRol);

			//se borra el proceso

			daoRoles.borrarRoles(idRol);

		} catch (Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":borrarRoles: " + sw.getBuffer().toString());

			throw ex;



		} finally {

			try {

				daoRoles.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":borrarRoles: error liberando recursos");

				}

			}

			// se cierra la conexin

			cerrarConexion(error);

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":borrarRoles: saliendo.");

			}

		}

	}// fin borrarRoles



	/**

	 * Funcin que modifica los datos del rol pasado como parmetro en la BBDD

	 * @param rol - Datos del rol a modificar

	 * @throws Exception

	 */

	public void modificarRoles(Q02bRoles rol) throws Exception {

		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":modificarRoles: entrando");

		}

		boolean error = false;

		try {

			// se abre la conexin

			abrirConexion();

			// se instancia el dao pasandole la conexin

			daoRoles = new Q02bRolesDataBaseDAO(this.getConn());



			// Segmento tecnico

			daoRoles.setUser(this.getAutenticador().getUser());

			daoRoles.setIdioma(this.getAutenticador().getIdioma());



			// se llama al metodo del DAO que realiza la update

			daoRoles.modificarRoles(rol);

			

			//modificamos los procesos asignados al rol

			this.modificarProcesosRol(rol.getIdRol(),rol.getListaProcesosSeleccionados());

			

			// modificamos los grupos asignados al rol:

			ArrayList listaGrupos = rol.getListaGruposSeleccionados();

			

			// Primero eliminamos los que tena asignados

			daoRoles.borrarGruposRol(rol.getIdRol());			

			

			// Ahora insertamos los nuevos

			for (int i=0;i<listaGrupos.size();i++){

				daoRoles.insertarGrupoRol(rol.getIdRol(),(String)listaGrupos.get(i));

			}

		} catch (Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":modificarRoles: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				daoRoles.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":modificarRoles: error liberando recursos");

				}

			}

			// se cierra la conexin

			cerrarConexion(error);

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":modificarRoles: saliendo.");

			}

		}

	}// modificarRoles

	

	

	//	--------------------Rol-Proceso-----------------------------------------//

	/**

     * Mtodo que llama a un DAO para modificar los procesos para un rol determinado

     * @param niRol nmero interno del rol en bbdd.

     * @param listaProcesos ArrayList con los nmeros internos de cada proceso.

     * @throws Exception

     */

    private void modificarProcesosRol(String idRol, ArrayList listaProcesos) throws Exception {

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarProcesosRol: entrando");

      		}

    		daoRoles = new Q02bRolesDataBaseDAO(this.getConn());

    		daoRoles.setUser(this.autenticador.getUser());

			daoRoles.setIdioma(this.autenticador.getIdioma());

			ArrayList listaProcesosBD = daoRoles.obtenerProcesosSeleccionados(idRol);

			

			//vamos a recorre la lista de la BD y por cada uno vamos a comprobar si sigue estando vigente o no

			for (int i=0; i < listaProcesosBD.size(); i++){

				Q02bCodigoValor proceso = (Q02bCodigoValor)listaProcesosBD.get(i);

				String idProcesoBD = proceso.getCodigo();

				/*ahora miramos si este est en los nuevos

					 - si: lo dejamos

					 - no: hay que borrarlo, de la tabla Roles-Proceso			 

				*/

				

				if ( !listaProcesos.contains(idProcesoBD)) {

					//no existe:hay que borrarlo

					daoRoles.borrarRolProceso(idProcesoBD, idRol);

					//tambin lo quitamos de la lista de nuevos para que al final solo queden los que no estn dados de alta					

				}else{

					//si est incluido, as que lo quitamos para que no lo de de alta

					listaProcesos.remove(idProcesoBD);

				}

			}

			// Ahora insertamos los nuevos (hemos quitado los que ya estaban)

			for (int i=0;i<listaProcesos.size();i++){

				daoRoles.insertarProcesoRol(idRol,(String)listaProcesos.get(i));				

			}

    	}catch(Exception ex){

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarProcesosRol: " + sw.getBuffer ().toString());

	        throw ex;                     

    	}finally{

 		    try{

 		    	daoRoles.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarProcesosRol: error liberando recursos");

	   	   	   }  

 		    }  		  	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarProcesosRol: saliendo.");

	   		}

    	}

    }



}