package q02b.exe.resultados.dataobjects;



import java.sql.Connection;

import java.sql.PreparedStatement;

import java.sql.ResultSet;

import java.util.ArrayList;



//import q02b.exe.arquitectura.dataobjects.Q02bDAOException;

import q02b.exe.arquitectura.dataobjects.Q02bDataBaseDAO;

//import q02b.exe.cuestionarioVAPM.valueobjects.Q02bCuestionarioVAPM;

//import q02b.exe.cuestionarioVAPM.valueobjects.Q02bCuestionarioVAPMFiltro;

//import q02b.exe.cuestionariosSMAnu.valueobjects.Q02bCuestionarioSM;

//import q02b.exe.cuestionariosSMAnu.valueobjects.Q02bCuestionarioSMFiltro;

//import q02b.exe.cuestionariosVTMAnu.valueobjects.Q02bCuestionarioVTMAnu;

//import q02b.exe.cuestionariosVTMAnu.valueobjects.Q02bCuestionarioVTMAnuFiltro;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022AS00;

//import q02b.exe.oficinasMunicipales.valueobjects.Q02bOficinasMunicipales;

//import q02b.exe.plazos.valueobjects.Q02bPlazos;

import q02b.exe.resultados.valueobjects.Q02bResultados;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022BS00;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022AV00;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022AS00;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022AS01V01;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022CS00;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022DS00;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022DS01V02;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022ES01V02;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022GS00;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022ES00;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022HS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022LS00;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022HS01V01;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022LS01V01;

//import q02b.exe.utils.Q02bConstantes;

import q02b.exe.utils.Q02bFormatData;

//import q02b.exe.utils.Q02bAplicationUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

//import es.ejie.frmk.listeners.base.Q70ListenerUtils;

//import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

//import q02b.exe.utils.oracle.Q02bBDUtilidades;







public class Q02bResultadosDataBaseDAO extends Q02bDataBaseDAO{

	private static final long serialVersionUID = -8520551641771839103L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "DAO_ACCESO_DATOS";

	//private static final String RECURSOS_RESULTADOS = "q02brecursosCuestionarios";



	public Q02bResultadosDataBaseDAO() {

        super();                

    }



    

    public Q02bResultadosDataBaseDAO(Connection conn) {

    	super(conn);     

    }

    

    // -------------------- INI - OBTENER LISTA ----------------

    /**

     * Devuelve una lista de resultados

     * segun un filtro y a traves de un vista

     * @param filtro - Q02bResultados

     * @return ArrayList de Q02bResultadosLista

     * @throws Exception

     * @see Q02bResultados

     * @see Q02bResultadosLista

     * @see Q02bTablaBDQ022LS01V01

     * @generated

     */

    public ArrayList obtenerListaResultados(Q02bResultados filtro)

        throws Exception {

        final String TRACE_METODO = nombreClaseSinPackage +

            ":obtenerListaOficinasMunicipales";



        if (tr.isTraceActive()) {

            tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +

                ": entrando");

        }



        //se instancian los objetos necesarios para realizar la consulta.	

        java.sql.ResultSet rs = null; // result set

        ArrayList lista = new ArrayList(); // lista de VO

        Q02bTablaBDQ022LS01V01 objTBD = null; // Objeto TablasBD de vista

        Q02bResultados regVO = null; // VO

        String colPK = "";



        try {

            //se instancia la clase del tablasBD a llamar pasandole la conexion

            objTBD = new Q02bTablaBDQ022LS01V01(this.getConnection());

            //se carga el filtro de la where con los datos de entrada.

            this.asignarFiltroResultados(objTBD, filtro);

            //Se indica el order by de las columnas	

            objTBD.setOrderBy(Q02bTablaBDQ022LS01V01.NOMCOLUMN_NORA_T17_PROVINCIA_DS + ", "  + Q02bTablaBDQ022LS01V01.NOMCOLUMN_NORA_T17_MUNICIPIO_DS);



            // se asignan los campos de auditoria

            //objTBD.setAuditUser(new Long(this.getUser()));

            //se realiza la select

            rs = objTBD.select();

            objTBD.addResultSet(rs);



            //se trata el resultado obtenido a?adiendolo a la lista de salida

            while (rs.next()) {

                regVO = new Q02bResultados();

                //se cargan en el objeto los datos recuperados            	 

                regVO.setIdResul(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022LT00_ID_RESUL));



                regVO.setIdProvincia(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022LT00_PROV));



                regVO.setIdMunicipio(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022LT00_MUNI));



                regVO.setOtraFormaRecogida(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022LT00_OTRF));



                regVO.setHojaResumen(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022LT00_NRESPH));



                regVO.setVtm(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022LT00_NRESPV));



                regVO.setSueloMunicipal(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022LT00_NRESPS));



                regVO.setAlquiler(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022LT00_NRESPA));



                regVO.setNingunLOM(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022LT00_NRESPT));



                regVO.setParteLOM(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022LT00_NRESPP));



                regVO.setObservaciones(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022LT00_OBSHR));



                regVO.setIdOficina(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022HT00_ID_OFI));



                regVO.setFormaCapturaInfo(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_NI_FORMA));



                regVO.setResulEncuesta(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_NI_RESUL_ENC));



                regVO.setSituacionInspeccion(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_NI_SITU_INSP));



                regVO.setResultadoInspeccion(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_NI_RESUL_INSP));



                regVO.setDenomProvincia(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_NORA_T17_PROVINCIA_DS));



                regVO.setDenomMunicipio(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_NORA_T17_MUNICIPIO_DS));

                

                regVO.setDescripOficina(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022HT00_DESC));

                

                regVO.setDescripOficinaEus(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022HT00_DESC_EUS));

                

                regVO.setCodForma(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_COD_FORMA));

                

                regVO.setDescripForma(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_DESC_FORMA));

                

                regVO.setDescripFormaEus(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_DESCE_FORMA));

                

                regVO.setCodResulEnc(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_COD_RESUL_ENC));

                

                regVO.setDescResulEnc(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_DESC_RESUL_ENC));

                

                regVO.setDescResulEncEus(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_DESCE_RESUL_ENC));

                

                regVO.setCodSituInsp(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_COD_SITU_INSP));

                

                regVO.setDescSituInsp(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_DESC_SITU_INSP));

                

                regVO.setDescSituInspEus(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_DESCE_SITU_INSP));

                

                regVO.setCodResulInsp(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_COD_RESUL_INSP));

                

                regVO.setDescResulInsp(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_DESC_RESUL_INSP));

                

                regVO.setDescResulInspEus(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_DESCE_RESUL_INSP));

                

                

                regVO.setColumnaPK(colPK);

                lista.add(regVO);

            }

        } catch (Exception ex) {

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR,

                TRACE_METODO + ": " + sw.getBuffer().toString());

            throw ex;

        } finally {

            try {

                objTBD.freeResourcesNotConnection();

            } catch (Exception ex) {

                if (tr.isTraceActive()) {

                    tr.trace(COMPONENTE, Q70TraceLevel.ERROR,

                        TRACE_METODO + ": error liberando recursos");

                }

            }



            if (tr.isTraceActive()) {

                tr.trace(COMPONENTE, Q70TraceLevel.INFO,

                    TRACE_METODO + ": saliendo");

            }

        }



        return lista;

    }



    // -------------------- FIN - OBTENER LISTA	 --------------------- 

    

    // -------------------- INI - ASIGNARFILTRO ------------------------

    /**

     * M?todo que se invoca desde dentro del DAO para asignar el filtro

     * al objeto TablasBD

     * @param filtro - ResultadosFiltro

     * @param vista - Q02bTablaBDQ022LS01V01

     * @throws Exception

     * @see ResultadosFiltro

     * @see Q02bTablaBDQ022LS01V01

     * @generated

     */

    private void asignarFiltroResultados(Q02bTablaBDQ022LS01V01 vista,Q02bResultados filtro) throws Exception {

        final String TRACE_METODO = nombreClaseSinPackage +

            ":asignarFiltroResultados";



        if (tr.isTraceActive()) {

            tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +

                ": entrando");

        }



        if (filtro != null) {

            // Inicializacion del filtro

            StringBuffer addWhere = new StringBuffer();

            

            if (!Q02bFormatData.esVacio(filtro.getIdProvincia())) {

                vista.setQ022LT00_PROV_WHERE(filtro.getIdProvincia());

            }



            if (!Q02bFormatData.esVacio(filtro.getIdMunicipio())) {

                vista.setQ022LT00_MUNI_WHERE(filtro.getIdMunicipio());

            }

            

            if (!Q02bFormatData.esVacio(filtro.getIdOficina())) {

                vista.setQ022HT00_ID_OFI_WHERE(Integer.parseInt(filtro.getIdOficina()));

            }

            

            if (!Q02bFormatData.esVacio(filtro.getFormaCapturaInfo())) {

                vista.setQ022YT00_NI_FORMA_WHERE(Integer.parseInt(filtro.getFormaCapturaInfo()));

            }

            

            if (!Q02bFormatData.esVacio(filtro.getResulEncuesta())) {

                vista.setQ022YT00_NI_RESUL_ENC_WHERE(Integer.parseInt(filtro.getResulEncuesta()));

            }

            

            if (!Q02bFormatData.esVacio(filtro.getHojaResumen())) {

                vista.setQ022LT00_NRESPH_WHERE("1");

            }

            

            if (!Q02bFormatData.esVacio(filtro.getVtm())) {

                vista.setQ022LT00_NRESPV_WHERE("1");

            }

            

            if (!Q02bFormatData.esVacio(filtro.getSueloMunicipal())) {

                vista.setQ022LT00_NRESPS_WHERE("1");

            }

            

            if (!Q02bFormatData.esVacio(filtro.getAlquiler())) {

                vista.setQ022LT00_NRESPA_WHERE("1");

            }

            

            if (!Q02bFormatData.esVacio(filtro.getNingunLOM())) {

                vista.setQ022LT00_NRESPT_WHERE("1");

            }

            

            if (!Q02bFormatData.esVacio(filtro.getParteLOM())) {

                vista.setQ022LT00_NRESPP_WHERE("1");

            }

            

            if (!Q02bFormatData.esVacio(filtro.getSituacionInspeccion())) {

                vista.setQ022YT00_NI_SITU_INSP_WHERE(Integer.parseInt(filtro.getSituacionInspeccion()));

            }

            

            if (!Q02bFormatData.esVacio(filtro.getResultadoInspeccion())) {

                vista.setQ022YT00_NI_RESUL_INSP_WHERE(Integer.parseInt(filtro.getResultadoInspeccion()));

            }

                      

                      

                                    

            //Se a?ade el aditional where al tablasBD

            vista.setAditionalWhere(addWhere.toString());

        }



        if (tr.isTraceActive()) {

            tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +

                ": saliendo");

        }

    }



    // -------------------- FIN - ASIGNARFILTRO ----------------------

    

    /**

     * Funcin que inserta los datos del resultado pasado como parmetro en la BBDD

     * @param resultado - Datos del resultado a insertar 

     * @throws Exception

     */

    public void insertarResultados(Q02bResultados resultado) throws Exception {

   	int niResultado = 0; 

   	Q02bTablaBDQ022LS00 tablaResultados=null;

      	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarResultados: entrando");

	    	}

	    	//se crea el objeto de tablasBD

	    	tablaResultados = new Q02bTablaBDQ022LS00(this.getConnection());

     		//primero recuperamos el nmero interno que le corresponde

   	   		niResultado = dameSeqNiResultado(tablaResultados);

   	   		resultado.setIdResul(Integer.toString(niResultado));      	

     		//se aaden los datos a insertar

        	this.rellenaDatosResultados(resultado, tablaResultados);         	         

     		//se realiza la insert

        	tablaResultados.insert();

    	}

    	catch(Exception ex)

    	{   	   

    		java.io.StringWriter sw = new java.io.StringWriter();

    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

    		ex.printStackTrace(pw);

    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarResultados: " + sw.getBuffer ().toString());

    		throw ex;

    	}

    	finally

    	{

    		try

    		{

    			tablaResultados.freeResourcesNotConnection();	

    		}

    		catch(Exception ex)

    		{

    			if (tr.isTraceActive())

    			{

    				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarResultados: error liberando recursos");

		   	   }  

		}  		

		if (tr.isTraceActive())

		{

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarResultados: saliendo");                

   		}       	

    	}

    } //insertarResultados

    

    private int dameSeqNiResultado(Q02bTablaBDQ022LS00 tablaResultados) throws Exception 

    {

    	int niResultado=1;

    	ResultSet rs = null;

      	PreparedStatement prepStmt =null;	

    	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameSeqNiResultado: entrando");

	    	}

	    	StringBuffer query = new StringBuffer(" SELECT Q022LQ00.NEXTVAL FROM DUAL ");

        	prepStmt = this.getConnection().prepareStatement(query.toString());         	

        	rs = prepStmt.executeQuery();

        	tablaResultados.addResultSet(rs);

        	tablaResultados.addStatement(prepStmt);        	

        	if (rs.next()){

        		niResultado = rs.getInt(1);

        		

        	}	         	

        	return niResultado;

       }

	        catch(Exception ex)

    	        {   	   

    		java.io.StringWriter sw = new java.io.StringWriter();

    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

    		ex.printStackTrace(pw);

    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameSeqNiResultado: " + sw.getBuffer ().toString());

    		throw ex;

    	      }

    }//dameSeqNiResultado

    

    public void rellenaDatosResultados(Q02bResultados resultado,Q02bTablaBDQ022LS00 tablaResultados) throws Exception {

       	//se definen objetos necesarios.

       	try{

   	    	if (tr.isTraceActive())

   	    	{

   	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosResultados: entrando");

   	    	}         	         

        	//se aaden los datos

   	    	tablaResultados.setQ022LT00_ID_RESUL(Q02bFormatData.checkIntegerNull(resultado.getIdResul()));

   	    	tablaResultados.setQ022LT00_PROV(Q02bFormatData.checkStringNull(resultado.getIdProvincia()));

   	    	tablaResultados.setQ022LT00_MUNI(Q02bFormatData.checkStringNull(resultado.getIdMunicipio()));

   	    	tablaResultados.setQ022LT00_OTRF(Q02bFormatData.checkStringNull(resultado.getOtraFormaRecogida()));

   	    	tablaResultados.setQ022LT00_NRESPH(Q02bFormatData.checkStringNull(resultado.getHojaResumen()));

   	    	tablaResultados.setQ022LT00_NRESPV(Q02bFormatData.checkStringNull(resultado.getVtm()));

   	    	tablaResultados.setQ022LT00_NRESPS(Q02bFormatData.checkStringNull(resultado.getSueloMunicipal()));

   	    	tablaResultados.setQ022LT00_NRESPA(Q02bFormatData.checkStringNull(resultado.getAlquiler()));

   	    	tablaResultados.setQ022LT00_NRESPT(Q02bFormatData.checkStringNull(resultado.getNingunLOM()));

   	    	tablaResultados.setQ022LT00_NRESPP(Q02bFormatData.checkStringNull(resultado.getParteLOM()));

   	    	tablaResultados.setQ022LT00_OBSHR(Q02bFormatData.checkStringNull(resultado.getObservaciones()));

   	    	tablaResultados.setQ022HT00_ID_OFI(Q02bFormatData.checkIntegerNull(resultado.getIdOficina()));

   	    	tablaResultados.setQ022YT00_NI_FORMA(Q02bFormatData.checkLongNull(resultado.getFormaCapturaInfo()));

   	    	tablaResultados.setQ022YT00_NI_RESUL_ENC(Q02bFormatData.checkLongNull(resultado.getResulEncuesta()));

   	    	tablaResultados.setQ022YT00_NI_SITU_INSP(Q02bFormatData.checkLongNull(resultado.getSituacionInspeccion()));

   	    	tablaResultados.setQ022YT00_NI_RESUL_INSP(Q02bFormatData.checkLongNull(resultado.getResultadoInspeccion()));

   	    	  	    	   	    	

       	}catch(Exception ex){   	   

       		java.io.StringWriter sw = new java.io.StringWriter();

       		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

       		ex.printStackTrace(pw);

       		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaDatosResultados: " + sw.getBuffer ().toString());

       		throw ex;

       	}finally{    		

   			if (tr.isTraceActive()){

   				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosResultados: saliendo = " + tablaResultados.getQ022LT00_ID_RESUL());                

              }       	

       	}	

     }//rellenaDatosResultados

    

    /**

     * Mtodo que dado el nmero interno del resultado 

     * recupera de la BBDD los datos de dicho resultado

     * @param idResul

     * @return

     */

    public Q02bResultados obtenerResultado(String idResul)throws Exception {

  	  if (tr.isTraceActive()){

 		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerResultado , ** dao idOfi= "+  idResul + "  ** entrando");            

      }

  	  

  	  //se crean los objetos necesarios para realizar la select.

  	  Q02bTablaBDQ022LS01V01 Q02bTablaBDQ022LS01V01obj = null;

  	  Q02bResultados resultadoBD = null;

  	  ResultSet rs = null;   	  

        try{ 

          if (idResul!=null){           

        	  Q02bTablaBDQ022LS01V01obj = new Q02bTablaBDQ022LS01V01(this.getConnection());

          	

          	//se pone el filtro

        	  Q02bTablaBDQ022LS01V01obj.setQ022LT00_ID_RESUL_WHERE(new Integer(idResul));

        

          	rs = Q02bTablaBDQ022LS01V01obj.select();

          	Q02bTablaBDQ022LS01V01obj.addResultSet(rs);

          	resultadoBD = new Q02bResultados();

          	if (rs.next()){

          		resultadoBD = this.rellenarVO(resultadoBD,rs);

          	}

          }  

          return resultadoBD;

          }catch(Exception ex){           	   

                 java.io.StringWriter sw = new java.io.StringWriter();

                 java.io.PrintWriter pw = new java.io.PrintWriter(sw);

                 ex.printStackTrace(pw);

                 tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerResultado: " + sw.getBuffer ().toString());

                 throw ex;

          }finally{

       	   try{

       		Q02bTablaBDQ022LS01V01obj.freeResourcesNotConnection();	

  				}catch(Exception ex){

  	   			if (tr.isTraceActive()){

  	   				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerResultado: error liberando recursos");

  	   		   	   }  

  				}  	

           	  if (tr.isTraceActive()){

           		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerResultado: saliendo");                

                }            	 

          }	  

    }//fin obtenerResultado

    

    private Q02bResultados rellenarVO(Q02bResultados resultado, ResultSet rs) throws Exception{

    	try {

    		if (tr.isTraceActive()){

 		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenarVO: entrando");                

 		    } 

    		resultado.setIdResul(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022LT00_ID_RESUL));			

    		resultado.setIdProvincia(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022LT00_PROV));

    		resultado.setIdMunicipio(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022LT00_MUNI));

    		resultado.setOtraFormaRecogida(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022LT00_OTRF));

    		resultado.setHojaResumen(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022LT00_NRESPH));

    		resultado.setVtm(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022LT00_NRESPV));

    		resultado.setSueloMunicipal(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022LT00_NRESPS));

    		resultado.setAlquiler(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022LT00_NRESPA));

    		resultado.setNingunLOM(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022LT00_NRESPT));

    		resultado.setParteLOM(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022LT00_NRESPP));

    		resultado.setObservaciones(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022LT00_OBSHR));

    		resultado.setIdOficina(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022HT00_ID_OFI));

    		resultado.setFormaCapturaInfo(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_NI_FORMA));

    		resultado.setResulEncuesta(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_NI_RESUL_ENC));

    		resultado.setSituacionInspeccion(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_NI_SITU_INSP));

    		resultado.setResultadoInspeccion(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_NI_RESUL_INSP));

    		resultado.setDenomProvincia(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_NORA_T17_PROVINCIA_DS));

    		resultado.setDenomMunicipio(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_NORA_T17_MUNICIPIO_DS));

    		resultado.setDescripOficina(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022HT00_DESC));

    		resultado.setDescripOficinaEus(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022HT00_DESC_EUS));

    		resultado.setCodForma(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_COD_FORMA));

    		resultado.setDescripForma(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_DESC_FORMA));

    		resultado.setDescripFormaEus(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_DESCE_FORMA));             

    		resultado.setCodResulEnc(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_COD_RESUL_ENC));

    		resultado.setDescResulEnc(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_DESC_RESUL_ENC));

    		resultado.setDescResulEncEus(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_DESCE_RESUL_ENC));

    		resultado.setCodSituInsp(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_COD_SITU_INSP));

    		resultado.setDescSituInsp(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_DESC_SITU_INSP));

    		resultado.setDescSituInspEus(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_DESCE_SITU_INSP));

    		resultado.setCodResulInsp(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_COD_RESUL_INSP));

    		resultado.setDescResulInsp(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_DESC_RESUL_INSP));

    		resultado.setDescResulInspEus(rs.getString(Q02bTablaBDQ022LS01V01.NOMCOLUMN_Q022YT00_DESCE_RESUL_INSP));

    		

	    	return resultado;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

	  	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	  	       ex.printStackTrace(pw);

	  	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenarVO: " + sw.getBuffer ().toString());

	  	       throw ex;

		}

    	

    }

    

    /**

     * Funcin que modifica los datos del plazo pasado como parmetro en la BBDD

     * @param resultado - Datos del resultado a modificar

     * @throws Exception

     */

    public void modificarResultados(Q02bResultados resultado) throws Exception {



     	if (tr.isTraceActive()){

 		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarResultados: entrando");

     	}

     	//Se instancian los objetos necesarios.

     	Q02bTablaBDQ022LS00 Q02bTablaBDQ022LS00obj = null;    

        	 try

        	 {     

        	 	//se crea el objeto de tablasBD

       		Q02bTablaBDQ022LS00obj = new Q02bTablaBDQ022LS00(this.getConnection());

       		

       		       		  		

       		rellenaDatosResultados(resultado,Q02bTablaBDQ022LS00obj);

       		Q02bTablaBDQ022LS00obj.setQ022LT00_ID_RESUL_WHERE(Integer.parseInt(resultado.getIdResul()));

      		       		

       		//se realiza la update

       		Q02bTablaBDQ022LS00obj.update();

        	 }

        	 catch(Exception ex) {

        		java.io.StringWriter sw = new java.io.StringWriter();

        		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

        		ex.printStackTrace(pw);

        		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarResultados: " + sw.getBuffer ().toString());

             throw ex;

        	 }

        	 finally {     

        		 try {

        			 Q02bTablaBDQ022LS00obj.freeResourcesNotConnection();	

        		 }

        		 catch(Exception ex) {

        			 if (tr.isTraceActive()) {

        				 tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarResultados: error liberando recursos");

        			 }  

        		 }  		  

        		 if (tr.isTraceActive()) {

        			 	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarResultados: saliendo");                

                }             

        	 }     

    } // fin modificarResultados

    

    /**

     * Funcin que borra el resultado pasado como parmetro de la BBDD

     * @param idResul - nmero interno del resultado a borrar

     * @throws Exception

     */

    public void borrarResultado(String idResul) throws Exception {

     	if (tr.isTraceActive()){

     		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarResultado: entrando");

     	}

     	Q02bTablaBDQ022LS00 Q02bTablaBDQ022LS00obj = null;

       try{       	

       	//se crean los objetos necesarios

        	Q02bTablaBDQ022LS00obj = new Q02bTablaBDQ022LS00(this.getConnection());   

        	

       	// segmento tecnico

           Q02bTablaBDQ022LS00obj.setUser(this.getUser());

        	

        	//se pone el filtro para la delete

        	Q02bTablaBDQ022LS00obj.setQ022LT00_ID_RESUL_WHERE(Integer.parseInt(idResul));         	

        	

        	//se lanza el delete

         	Q02bTablaBDQ022LS00obj.delete();         	

        }

        catch(Exception ex)

        {

             java.io.StringWriter sw = new java.io.StringWriter();

             java.io.PrintWriter pw = new java.io.PrintWriter(sw);

             ex.printStackTrace(pw);

             tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarResultado: " + sw.getBuffer ().toString());

             throw ex;

        } 

        finally {

        	try{

        		Q02bTablaBDQ022LS00obj.freeResourcesNotConnection();	

        	}

        	catch(Exception ex) {

        		if (tr.isTraceActive()) {

        			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarResultado: error liberando recursos");

        		}  

        	}  		

        	if (tr.isTraceActive()) {

        		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarResultado: saliendo");                

           }     	   

        }

    }//fin borrarResultado

    

       

}

