package q02b.exe.procesos.dataobjects;



import java.sql.Connection;

import java.sql.PreparedStatement;

import java.sql.ResultSet;

import java.util.ArrayList;



import q02b.exe.arquitectura.dataobjects.Q02bDataBaseDAO;

import q02b.exe.comun.valueobjects.Q02bCodigoValor;

import q02b.exe.procesos.valueobjects.Q02bProcesos;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ021FS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ021FS01V01;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ021GS01V01;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ021LS00;

import q02b.exe.utils.Q02bFormatData;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;



public class Q02bProcesosDataBaseDAO extends Q02bDataBaseDAO {

	private static final long serialVersionUID = -8520551641771839103L;



	private static Q70Traza tr = Q70Traza.getSingleton();



	private static final String COMPONENTE = "DAO_ACCESO_DATOS";



	public Q02bProcesosDataBaseDAO() {

		super();

	}



	public Q02bProcesosDataBaseDAO(Connection conn) {

		super(conn);

	}



	public void rellenaFiltroProcesos(Q02bProcesos procesoFiltro, Q02bTablaBDQ021FS01V01 tablaProcesos) throws Exception {

		// Definicin de variables que no se van a modificar

		final String TRACE_METODO = ":rellenaFiltroProcesos:";

		StringBuffer addWhere = new StringBuffer();

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ TRACE_METODO + " entrando");

			}

			if (procesoFiltro != null) {

				if (!Q02bFormatData.esVacio(procesoFiltro.getCodProceso())) {

					 addWhere.append(" AND ( (TRANSLATE(UPPER(");

		             addWhere.append(Q02bTablaBDQ021FS01V01.NOMCOLUMN_Q021FT00_COD);

		             addWhere.append("),'','AEIOUAEIOU')) LIKE  '%");

		             addWhere.append(Q02bFormatData.convertirMaysculaSinAcento(procesoFiltro.getCodProceso()));

		             addWhere.append("%' ) ");

				}

				if (!Q02bFormatData.esVacio(procesoFiltro.getIdModulo())) {

					tablaProcesos.setQ021ET00_NI_WHERE(new Long(procesoFiltro.getIdModulo()));

				}

				tablaProcesos.setOrderBy(tablaProcesos.NOMCOLUMN_Q021FT00_COD);

				tablaProcesos.setAditionalWhere(addWhere.toString());

			}

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ TRACE_METODO + sw.getBuffer().toString());

			throw ex;

		} finally {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ TRACE_METODO + " saliendo");

			}

		}

	}// fin rellenaFiltroProcesos



	private ArrayList rellenaVOsProcesos(ResultSet rs) throws Exception {

		Q02bProcesos procesos;

		ArrayList listaProcesos = new ArrayList();

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":rellenaVOsProcesos: entrando");

			}

			while (rs.next()) {

				// se cargan en el objeto procesos los datos recuperados

				procesos = new Q02bProcesos();

				rellenarVOProcesos(procesos, rs);

				listaProcesos.add(procesos);

			}

			return listaProcesos;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":rellenaVOsProcesos: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":rellenaVOsProcesos: saliendo");

			}

		}

	}// fin rellenaVOsProcesos(rs)



	private void rellenarVOProcesos(Q02bProcesos procesos, ResultSet rs) throws Exception {

		try {

			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName()	+ ":rellenarVOProcesos: Hay Datos");

			procesos.setCodProceso(rs.getString(Q02bTablaBDQ021FS01V01.COLUMN_Q021FT00_COD));

			procesos.setIdProceso(rs.getString(Q02bTablaBDQ021FS01V01.COLUMN_Q021FT00_NI));

			procesos.setRuta(rs.getString(Q02bTablaBDQ021FS01V01.COLUMN_Q021FT00_RUTAP));

			procesos.setDescripcionEs(rs.getString(Q02bTablaBDQ021FS01V01.COLUMN_Q021FT00_DESC));

			procesos.setDescripcionEu(rs.getString(Q02bTablaBDQ021FS01V01.COLUMN_Q021FT00_DESC_EUS));

			procesos.setDescripcionMenu(rs.getString(Q02bTablaBDQ021FS01V01.COLUMN_Q021FT00_DESC_MENU));

			procesos.setIdModulo(rs.getString(Q02bTablaBDQ021FS01V01.COLUMN_Q021ET00_NI));

			procesos.setDescripcionModulo(rs.getString(Q02bTablaBDQ021FS01V01.COLUMN_Q021ET00_DESC));		

		} catch (Exception e) {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":rellenarVOProcesos: error " + e.getMessage());

			}

		}

	} // fin rellenaVOsProcesos(procesos, rs)



	private int dameSeqIdProceso(Q02bTablaBDQ021FS00 tablaProcesos) throws Exception {

		int idProceso = 1;

		ResultSet rs = null;

		PreparedStatement prepStmt = null;

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":dameSeqIdProcesos: entrando");

			}

			StringBuffer query = new StringBuffer(" SELECT Q021FQ00.NEXTVAL FROM DUAL ");

			prepStmt = this.getConnection().prepareStatement(query.toString());

			rs = prepStmt.executeQuery();

			tablaProcesos.addResultSet(rs);

			tablaProcesos.addStatement(prepStmt);

			if (rs.next()) {

				idProceso = rs.getInt(1);

			}

			return idProceso;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":dameSeqIdProcesos: " + sw.getBuffer().toString());

			throw ex;

		}

	}// dameSegIdProcesos



	public void rellenaDatosProcesos(Q02bProcesos proceso,	Q02bTablaBDQ021FS00 tablaProcesos) throws Exception {

		// se definen objetos necesarios.

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":rellenaDatosProcesos: entrando");

			}

			// se aaden los datos

			tablaProcesos.setQ021FT00_NI(Q02bFormatData.checkLongNull(proceso.getIdProceso()));

			tablaProcesos.setQ021ET00_NI(Q02bFormatData.checkLongNull(proceso.getIdModulo()));

			tablaProcesos.setQ021FT00_COD(Q02bFormatData.checkStringNull(proceso.getCodProceso()));

			tablaProcesos.setQ021FT00_DESC(Q02bFormatData.checkStringNull(proceso.getDescripcionEs()));

			tablaProcesos.setQ021FT00_DESC_EUS(Q02bFormatData.checkStringNull(proceso.getDescripcionEu()));

			tablaProcesos.setQ021FT00_DESC_MENU(Q02bFormatData.checkStringNull(proceso.getDescripcionMenu()));

			tablaProcesos.setQ021FT00_RUTAP(Q02bFormatData.checkStringNull(proceso.getRuta()));  

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":rellenaDatosProcesos: "+ sw.getBuffer().toString());

			throw ex;

		} finally {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":rellenaDatosProcesos: saliendo = "+ tablaProcesos.getQ021FT00_NI());

			}

		}

	}// rellenaDatosProcesos



	public ArrayList getProcesos(Q02bProcesos proceso) throws Exception {

		// se instancian los objetos necesarios para realizar la consulta.

		Q02bTablaBDQ021FS01V01 tablaProcesos = null;

		ResultSet rs = null;

		ArrayList listaProcesos = new ArrayList();



		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":getProcesos: entrando");

			}



			// se instancia la clase del tablas bd a llamar pasandole la conexion

			tablaProcesos = new Q02bTablaBDQ021FS01V01(this.getConnection());



			// se aade la where

			this.rellenaFiltroProcesos(proceso, tablaProcesos);



			// se realiza la select

			rs = tablaProcesos.select();

			// aadimos el cursos para luego poder liberarlo ( en el freeResources)

			tablaProcesos.addResultSet(rs);

			// se trata el resultado obtenido aadiendolo a la lista de salida

			listaProcesos = this.rellenaVOsProcesos(rs);



			return listaProcesos;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":getProcesos: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				// liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet

				tablaProcesos.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":getProcesos: error liberando recursos.");

				}

			}

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":getProcesos: saliendo.");

			}

		}

	}// fin getProcesos



	/**

	 * Funcin que inserta los datos del proceso pasado como parmetro en la BBDD

	 * 

	 * @param procesos - Datos del proceso a insertar

	 * @throws Exception

	 */

	public int insertarProcesos(Q02bProcesos proceso) throws Exception {

		int idProcesos = 0;

		Q02bTablaBDQ021FS00 tablaProcesos = null;

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":insertarProcesos: entrando");

			}

			// se crea el objeto de tablasBD

			tablaProcesos = new Q02bTablaBDQ021FS00(this.getConnection());

			// primero recuperamos el nmero interno que le corresponde

			idProcesos = dameSeqIdProceso(tablaProcesos);

			proceso.setIdProceso(Integer.toString(idProcesos));

			// se aaden los datos a insertar

			this.rellenaDatosProcesos(proceso, tablaProcesos);

			tablaProcesos.setUSER(new Long(this.getUser()));

			

			// se realiza la insert

			tablaProcesos.insert();

			return idProcesos;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":insertarProcesos: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				tablaProcesos.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE,Q70TraceLevel.ERROR,this.getClass().getName()+ ":insertarProcesos: error liberando recursos");

				}

			}

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":insertarProcesos: saliendo");

			}

		}

	} // insertarProcesos

	

	public Q02bProcesos obtenerProceso(String idProceso) throws Exception {

		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":obtenerProceso , ** dao idProceso= "+ idProceso + "  ** entrando");

		}



		// se crean los objetos necesarios para realizar la select.

		Q02bTablaBDQ021FS01V01 Q02bTablaBDQ021FS01V01obj = null;

		Q02bProcesos procesoBD = null;

		ResultSet rs = null;

		try {

			if (idProceso != null) {

				Q02bTablaBDQ021FS01V01obj = new Q02bTablaBDQ021FS01V01(this.getConnection());



				// se pone el filtro

				Q02bTablaBDQ021FS01V01obj.setQ021FT00_NI_WHERE(new Long(idProceso));



				rs = Q02bTablaBDQ021FS01V01obj.select();

				Q02bTablaBDQ021FS01V01obj.addResultSet(rs);

				procesoBD = new Q02bProcesos();

				if (rs.next()) {

					this.rellenarVOProcesos(procesoBD, rs);

				}

			}

			return procesoBD;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":obtenerProceso: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				Q02bTablaBDQ021FS01V01obj.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":obtenerProceso: error liberando recursos");

				}

			}

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":obtenerProceso: saliendo");

			}

		}

	}// fin obtenerProceso 



	/**

	 * Funcin que borra el proceso pasado como parmetro de la BBDD

	 * @param idProceso - nmero interno del proceso a borrar

	 * @throws Exception

	 */

	public void borrarProcesos(String idProceso) throws Exception {

		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":borrarProcesos: entrando");

		}

		Q02bTablaBDQ021FS00 Q02bTablaBDQ021FS00obj = null;

		try {

			// se crean los objetos necesarios

			Q02bTablaBDQ021FS00obj = new Q02bTablaBDQ021FS00(this.getConnection());



			// segmento tecnico

			//Q02bTablaBDQ021FS00obj.setUser(this.getUser());



			// se pone el filtro para la delete

			Q02bTablaBDQ021FS00obj.setQ021FT00_NI_WHERE(new Long(idProceso));



			// se lanza el delete

			Q02bTablaBDQ021FS00obj.delete();

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":borrarProcesos: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				Q02bTablaBDQ021FS00obj.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":borrarProcesos: error liberando recursos");

				}

			}

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":borrarProcesos: saliendo");

			}

		}

	}// fin borrarProcesos



	/**

	 * Funcin que modifica los datos del procesos pasado como parmetro en la BBDD

	 * 

	 * @param procesos - Datos del procesos a modificar

	 * @throws Exception

	 */

	public void modificarProcesos(Q02bProcesos proceso) throws Exception {



		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":modificarProcesos: entrando");

		}

		// Se instancian los objetos necesarios.

		Q02bTablaBDQ021FS00 Q02bTablaBDQ021FS00obj = null;

		try {

			// se crea el objeto de tablasBD

			Q02bTablaBDQ021FS00obj = new Q02bTablaBDQ021FS00(this.getConnection());



			// segmento tecnico

			// Q02bTablaBDQ021FS00obj.setUser(this.getUser());



			rellenaDatosProcesos(proceso, Q02bTablaBDQ021FS00obj);

			Q02bTablaBDQ021FS00obj.setQ021FT00_NI_WHERE(new Long(proceso.getIdProceso()));



			// se realiza la update

			Q02bTablaBDQ021FS00obj.update();

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":modificarProcesos: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				Q02bTablaBDQ021FS00obj.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":modificarProcesos: error liberando recursos");

				}

			}

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":modificarProcesos: saliendo");

			}

		}

	} // fin modificarProcesos



	//--------------------------------ROLES-PROCESO---------------------------------------------//

	/**

     * Mtodo que llama a un DAO para insertar los roles para un proceso determinado

     * @param idProceso nmero interno del proceso en bbdd.

     * @param listaRoles ArrayList con los nmeros internos de cada rol.

     * @throws Exception

     */

    public void insertarRolesProceso(int idProceso, ArrayList listaRoles) throws Exception {

    	Q02bTablaBDQ021LS00 tablaProcesosRoles = null;

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarRolesProceso: entrando");

      		}    		

    		tablaProcesosRoles = new Q02bTablaBDQ021LS00(this.getConnection());

    		//tablaProcesosRoles.setUSER(new Long(this.getUser()));

			for (int i=0;i<listaRoles.size();i++){

				tablaProcesosRoles.setQ021FT00_NI(new Long(idProceso));

		    	tablaProcesosRoles.setQ021GT00_NI(new Long((String) listaRoles.get(i)));

	      		

	      		//se realiza la insert

		    	tablaProcesosRoles.insert();

			}

    	}catch(Exception ex){

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarRolesProceso: " + sw.getBuffer ().toString());

	        throw ex;                     

    	}finally{

 		    try{

 		    	tablaProcesosRoles.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarProcesosRol: error liberando recursos");

	   	   	   }  

 		    }  		  	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarProcesosRol: saliendo.");

	   		}

    	}

    }

    

	/**

     * Mtodo que devuelve una lista con los roles no asignados a un proceso.

     * @param niProceso nmero interno del proceso.

     * @return ArrayList con la lista de roles encontrados

     * @throws Exception

     */

    public ArrayList obtenerRolesNoSeleccionados(String idProceso) throws Exception{

    	Q02bTablaBDQ021LS00 tablaBDRolesProcesos = null;

    	Q02bTablaBDQ021GS01V01 tablaBDRoles = null;

    	ResultSet rs = null;

    	ResultSet rs2 = null;

    	ArrayList listaRolesNoSeleccionados = new ArrayList();

    	

    	try{

	    	if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRolesNoSeleccionados: entrando");

	   		}

	    	tablaBDRolesProcesos = new Q02bTablaBDQ021LS00(this.getConnection());

	    	tablaBDRoles = new Q02bTablaBDQ021GS01V01(this.getConnection());	

	    	

	    	tablaBDRoles.setDistinct(Q02bTablaBDQ021LS00.NOMCOLUMN_Q021GT00_NI);

	    	

	    	StringBuffer where = new StringBuffer();

	    	

	    	where.append(Q02bTablaBDQ021LS00.NOMCOLUMN_Q021GT00_NI).append(" NOT IN (SELECT ").

	    	append(Q02bTablaBDQ021LS00.NOMCOLUMN_Q021GT00_NI).append(" FROM ").

	    	append(tablaBDRolesProcesos.getTableFrom()).append(" WHERE ").

	    	append(Q02bTablaBDQ021LS00.NOMCOLUMN_Q021FT00_NI).append("=").append(idProceso).append(")");

	    	

	    	rs = tablaBDRoles.selectDistinct(where.toString());

	    	

      		while (rs.next()){	

      			tablaBDRoles.setQ021GT00_NI_WHERE(new Long(rs.getString(Q02bTablaBDQ021LS00.NOMCOLUMN_Q021GT00_NI)));

				rs2 = tablaBDRoles.select();

				tablaBDRoles.addResultSet(rs2);

				if (rs2.next()) {

					Q02bCodigoValor rol = new Q02bCodigoValor (rs2.getString(Q02bTablaBDQ021GS01V01.NOMCOLUMN_Q021GT00_NI),

	      					rs2.getString(Q02bTablaBDQ021GS01V01.NOMCOLUMN_Q021GT00_DESC));

					listaRolesNoSeleccionados.add(rol);

				}

      		}

      		return listaRolesNoSeleccionados;

     	}catch(Exception ex){   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerRolesNoSeleccionados: " + sw.getBuffer ().toString());

     		throw ex;

     	}finally{

     		try{

     			tablaBDRolesProcesos.freeResourcesNotConnection();	

     		}catch(Exception ex){

     			if (tr.isTraceActive()){

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerRolesNoSeleccionados: error liberando recursos");

 		   	   	}  

 			}  		

 			if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRolesNoSeleccionados: saliendo");                

            }       	

     	}	

    }

    

    /**

     * Mtodo que devuelve una lista con los roles asignados a un proceso.

     * @param niProceso nmero interno del proceso.

     * @return ArrayList con la lista de roles encontrados

     * @throws Exception

     */

    public ArrayList obtenerRolesSeleccionados(String idProceso) throws Exception{

    	Q02bTablaBDQ021LS00 tablaBDRolesProcesos = null;

    	Q02bTablaBDQ021GS01V01 tablaBDRoles = null;

    	ResultSet rs = null;

    	ResultSet rs2 = null;

    	ArrayList listaRolesSeleccionados = new ArrayList();

    	

    	try{

	    	if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRolesSeleccionados: entrando");

	   		}

	    	tablaBDRolesProcesos = new Q02bTablaBDQ021LS00(this.getConnection());

	    		    	

	    	tablaBDRolesProcesos.setDistinct(Q02bTablaBDQ021LS00.NOMCOLUMN_Q021GT00_NI);



	    	tablaBDRolesProcesos.setQ021FT00_NI_WHERE(new Long(idProceso));

	    	

	    	rs = tablaBDRolesProcesos.selectDistinct();

	    	

      		while (rs.next()){

      			tablaBDRoles = new Q02bTablaBDQ021GS01V01(this.getConnection());	

      			tablaBDRoles.setQ021GT00_NI_WHERE(new Long(rs.getString(Q02bTablaBDQ021LS00.NOMCOLUMN_Q021GT00_NI)));

				rs2 = tablaBDRoles.select();

				tablaBDRoles.addResultSet(rs2);

				if (rs2.next()) {

					Q02bCodigoValor rol = new Q02bCodigoValor (rs2.getString(Q02bTablaBDQ021GS01V01.NOMCOLUMN_Q021GT00_NI),

	      					rs2.getString(Q02bTablaBDQ021GS01V01.NOMCOLUMN_Q021GT00_DESC));

					listaRolesSeleccionados.add(rol);

				}

      		}

      		

      		return listaRolesSeleccionados;

     	}catch(Exception ex){   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerRolesSeleccionados: " + sw.getBuffer ().toString());

     		throw ex;

     	}finally{

     		try{

     			tablaBDRolesProcesos.freeResourcesNotConnection();	

     		}catch(Exception ex){

     			if (tr.isTraceActive()){

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerRolesSeleccionados: error liberando recursos");

 		   	   	}  

 			}  		

 			if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerRolesSeleccionados: saliendo");                

            }       	

     	}	

    }    

    

    /**

     * Mtodo que borra los roles asignados a un proceso determinado.

     * @param niProceso

     * @throws Exception

     */

    public void borrarRolesProceso(String idProceso) throws Exception{

    	Q02bTablaBDQ021LS00 tablaBDRolesProcesos = null;

    	try{

	    	if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarRolesProceso: entrando");

	   		}

	    	tablaBDRolesProcesos = new Q02bTablaBDQ021LS00(this.getConnection());



	    	tablaBDRolesProcesos.setQ021FT00_NI_WHERE(new Long(idProceso));

      		

      		//se realiza la delete

	    	tablaBDRolesProcesos.delete();

      			      		

     	}catch(Exception ex){   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarRolesProceso: " + sw.getBuffer ().toString());

     		throw ex;

     	}finally{

     		try{

     			tablaBDRolesProcesos.freeResourcesNotConnection();	

     		}catch(Exception ex){

     			if (tr.isTraceActive()){

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarRolesProceso: error liberando recursos");

 		   	   	}  

 			}  		

 			if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarRolesProceso: saliendo");                

            }       	

     	}	

    }//fin borrarRolesProceso

    

    /**

     * Mtodo que asigna un proceso a un rol.

     * @param niRol

     * @param niProceso

     * @throws Exception

     */

    public void insertarProcesoRol(String idRol, String idProceso) throws Exception{

    	Q02bTablaBDQ021LS00 tablaBDRolesProcesos = null;

    	try{

	    	if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarProcesoRol: entrando");

	   		}

	    	tablaBDRolesProcesos = new Q02bTablaBDQ021LS00(this.getConnection());



         	//se aaden los datos a insertar

	    	tablaBDRolesProcesos.setQ021GT00_NI(new Long(idRol));

	    	tablaBDRolesProcesos.setQ021FT00_NI(new Long(idProceso));

      		

      		//se realiza la insert

	    	tablaBDRolesProcesos.insert();

      			      		

     	}catch(Exception ex){   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarProcesoRol: " + sw.getBuffer ().toString());

     		throw ex;

     	}finally{

     		try{

     			tablaBDRolesProcesos.freeResourcesNotConnection();	

     		}catch(Exception ex){

     			if (tr.isTraceActive()){

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarProcesoRol: error liberando recursos");

 		   	   	}  

 			}  		

 			if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarProcesoRol: saliendo");                

            }       	

     	}	

    }//fin insertarProcesoRol



}

