package q02b.exe.plazos.dataobjects;



import java.sql.Connection;

import java.sql.PreparedStatement;

import java.sql.ResultSet;

import java.util.ArrayList;



import q02b.exe.arquitectura.dataobjects.Q02bDataBaseDAO;

import q02b.exe.plazos.valueobjects.Q02bPlazos;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022AS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022AS01V01;

import q02b.exe.utils.Q02bConstantes;

import q02b.exe.utils.Q02bFormatData;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;







public class Q02bPlazosDataBaseDAO extends Q02bDataBaseDAO{

	private static final long serialVersionUID = -8520551641771839103L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "DAO_ACCESO_DATOS";



	public Q02bPlazosDataBaseDAO() {

        super();                

    }



    

    public Q02bPlazosDataBaseDAO(Connection conn) {

    	super(conn);     

    }



    public void rellenaFiltroPlazos(Q02bPlazos plazoFiltro, Q02bTablaBDQ022AS01V01 tablaPlazos) throws Exception {

		// Definición de variables que no se van a modificar

		final String TRACE_METODO = ":rellenaFiltroPlazos:";

		StringBuffer sbAditionalWhere=new StringBuffer(" ");

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ TRACE_METODO + " entrando");

			}

			if (plazoFiltro != null) {

				if (!Q02bFormatData.esVacio(plazoFiltro.getProvincia())) {

					if (plazoFiltro.getProvincia().equals("C.A.E.")){

						sbAditionalWhere= new StringBuffer("AND MUN_PROV IN (01, 48, 20)");

					} else {

					tablaPlazos.setMUN_PROV_WHERE(plazoFiltro.getProvincia());

				}

				}

				if (!Q02bFormatData.esVacio(plazoFiltro.getMunicipio())) {

					tablaPlazos.setMUN_MUNI_WHERE(plazoFiltro.getMunicipio());

				}

				if (!Q02bFormatData.esVacio(plazoFiltro.getAnyo())) {

					tablaPlazos.setQ022AT00_ANO_WHERE(Integer.parseInt(plazoFiltro.getAnyo()));

				}

				if (!Q02bFormatData.esVacio(plazoFiltro.getTipoCuestionario())) {

					tablaPlazos.setQ022NT00_CODIGO_WHERE(plazoFiltro.getTipoCuestionario());

				}

				 if (sbAditionalWhere != null){ 

					 tablaPlazos.setAditionalWhere(sbAditionalWhere.toString());
                 }
	    		

			}

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ TRACE_METODO + sw.getBuffer().toString());

			throw ex;

		} finally {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ TRACE_METODO + " saliendo");

			}

		}

	}// fin rellenaFiltroPlazos

    

    private ArrayList rellenaVOsPlazosVista( ResultSet rs ) throws Exception{

     	Q02bPlazos plazos;

     	ArrayList listaPlazos = new ArrayList();

     	try{

     		if (tr.isTraceActive()){

 		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOsPlazos: entrando");                

 		    } 

     		while (rs.next()){	 

 	        	//se cargan en el objeto cuestionario los datos recuperados

     			plazos = new Q02bPlazos();

     			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":rellenarVOsPlazos: Hay Datos");            

     			plazos = this.rellenarVO(plazos, rs); 

     			listaPlazos.add(plazos);

   			}  	  

     		return listaPlazos;

     	}catch(Exception ex){    	 	   

  	       java.io.StringWriter sw = new java.io.StringWriter();

  	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);

  	       ex.printStackTrace(pw);

  	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaVOsPlazos: " + sw.getBuffer ().toString());

  	       throw ex;

  		}finally{			 	

  			if (tr.isTraceActive()){

  		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOsPlazos: saliendo");                

  		    }    				

  		}

     }//fin rellenarVOsPlazosVista(rs) 

    

    private Q02bPlazos rellenarVO(Q02bPlazos plazos, ResultSet rs) throws Exception{

   	  		try{

   	  			if (tr.isTraceActive()){

 		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenarVO: entrando");                

   	  			}  

			plazos.setFechaAlta(Q02bFormatData.formatearFecha( Q02bFormatData.checkStringNull( rs.getString( Q02bTablaBDQ022AS01V01.NOMCOLUMN_Q022AT00_FEC_ALTA)), Q02bConstantes.FORMATO_FECHA_FORMAT_DATA, this.getIdioma()));

			plazos.setAnyo(rs.getString(Q02bTablaBDQ022AS01V01.COLUMN_Q022AT00_ANO));

	    	plazos.setFechaModificacion(Q02bFormatData.formatearFecha( Q02bFormatData.checkStringNull( rs.getString( Q02bTablaBDQ022AS01V01.NOMCOLUMN_Q022AT00_FEC_MOD)), Q02bConstantes.FORMATO_FECHA_FORMAT_DATA, this.getIdioma()));

	    	plazos.setMunicipio(rs.getString(Q02bTablaBDQ022AS01V01.NOMCOLUMN_MUN_MUNI));

	    	plazos.setNomMunicipio(rs.getString(Q02bTablaBDQ022AS01V01.COLUMN_MUNICIPIO_DS_O));

	    	if (Q02bFormatData.esVacio(plazos.getNomMunicipio())){

	    		plazos.setNomMunicipio("Todos");

	    	}

	    	plazos.setNomProvincia(rs.getString(Q02bTablaBDQ022AS01V01.COLUMN_PROVINCIA_DS_O));

	    	plazos.setNiPlazo(rs.getString(Q02bTablaBDQ022AS01V01.NOMCOLUMN_Q022AT00_NIPLAZO));

	    	plazos.setPlazo(rs.getString(Q02bTablaBDQ022AS01V01.NOMCOLUMN_Q022AT00_PLAZO));

	    	plazos.setProvincia(rs.getString(Q02bTablaBDQ022AS01V01.COLUMN_MUN_PROV));

	    	plazos.setTipoCuestionario(rs.getString(Q02bTablaBDQ022AS01V01.NOMCOLUMN_Q022NT00_CODIGO));

	    	plazos.setDescCuestionarioEs(rs.getString(Q02bTablaBDQ022AS01V01.NOMCOLUMN_Q022NT00_DESC_ES));

	    	plazos.setDescCuestionarioEu(rs.getString(Q02bTablaBDQ022AS01V01.NOMCOLUMN_Q022NT00_DESC_EU));

	    	plazos.setDias(rs.getString(Q02bTablaBDQ022AS01V01.NOMCOLUMN_Q022AT00_PLAZO_DIA));

	    	return plazos;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

	  	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	  	       ex.printStackTrace(pw);

	  	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenarVO: " + sw.getBuffer ().toString());

	  	       throw ex;

   	  		}  	

    	

   	  	}

     

     private int dameSeqNiPlazos(Q02bTablaBDQ022AS00 tablaPlazos) throws Exception 

     {

    	int niPlazo=1;

     	ResultSet rs = null;

       	PreparedStatement prepStmt =null;	

     	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameSeqNiPlazos: entrando");

	    	}

    		StringBuffer query = new StringBuffer(" SELECT Q022AQ00.NEXTVAL FROM DUAL ");

         	prepStmt = this.getConnection().prepareStatement(query.toString());         	

         	rs = prepStmt.executeQuery();

         	tablaPlazos.addResultSet(rs);

         	tablaPlazos.addStatement(prepStmt);        	

         	if (rs.next()){

         		niPlazo = rs.getInt(1);

         		

         	}	         	

         	return niPlazo;

        }

	        catch(Exception ex)

     	        {   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameSeqNiPlazo: " + sw.getBuffer ().toString());

     		throw ex;

     	      }

     }//dameSegNiPlazos

     

     public void rellenaDatosPlazos(Q02bPlazos plazo,Q02bTablaBDQ022AS00 tablaPlazos, boolean esAlta) throws Exception {

       	//se definen objetos necesarios.

       	try{

   	    	if (tr.isTraceActive())

   	    	{

   	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosPlazos: entrando");

   	    	}         	         

        	//se aaden los datos

   	    	tablaPlazos.setQ022AT00_ANO(Q02bFormatData.checkIntegerNull(plazo.getAnyo()));

   	    	tablaPlazos.setQ022AT00_NIPLAZO(Q02bFormatData.checkIntegerNull(plazo.getNiPlazo()));

   	    	if (!Q02bFormatData.esVacio(plazo.getPlazo())) {

   	    		tablaPlazos.setQ022AT00_PLAZO(Q02bFormatData.checkIntegerNull(plazo.getPlazo()));

   	    	} else {

   	    		tablaPlazos.setQ022AT00_PLAZO(0);

   	    	}

   	    	if (!Q02bFormatData.esVacio(plazo.getDias())) {

   	    		tablaPlazos.setQ022AT00_PLAZO_DIA(Q02bFormatData.checkIntegerNull(plazo.getDias()));

   	    	} else {

   	    		tablaPlazos.setQ022AT00_PLAZO_DIA(0);

   	    	}

   	    	tablaPlazos.setQ022NT00_CODIGO(Q02bFormatData.checkStringNull(plazo.getTipoCuestionario()));

   	    	tablaPlazos.setMUN_MUNI(Q02bFormatData.checkStringNull(plazo.getMunicipio()));

   	    	tablaPlazos.setMUN_PROV(Q02bFormatData.checkStringNull(plazo.getProvincia()));

   	    	if (esAlta){

   	    		tablaPlazos.setQ022AT00_FEC_ALTA(new java.util.Date(System.currentTimeMillis()));

   	    	} else {

   	    		tablaPlazos.setQ022AT00_FEC_MOD(new java.util.Date(System.currentTimeMillis()));

   	    	}

       	}catch(Exception ex){   	   

       		java.io.StringWriter sw = new java.io.StringWriter();

       		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

       		ex.printStackTrace(pw);

       		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaDatosPlazos: " + sw.getBuffer ().toString());

       		throw ex;

       	}finally{    		

   			if (tr.isTraceActive()){

   				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosPlazos: saliendo = " + tablaPlazos.getQ022AT00_NIPLAZO());                

              }       	

       	}	

     }//rellenaDatosPlazos 

     

    public ArrayList getPlazos(Q02bPlazos plazoFiltro) throws Exception {		

 		//se instancian los objetos necesarios para realizar la consulta.			

 		Q02bTablaBDQ022AS01V01 vistaPlazos=null;

 		ResultSet rs = null;

 		ArrayList listaPlazos = new ArrayList();

 		

 		try{

 	    	if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getPlazos: entrando");

 			}

 	    	

 	    	//se instancia la clase del tablas bd a llamar pasandole la conexion	    	

 	    	vistaPlazos = new Q02bTablaBDQ022AS01V01(this.getConnection());

 	    	

 	    	//se añade la where

			this.rellenaFiltroPlazos(plazoFiltro, vistaPlazos);

 	    	vistaPlazos.setOrderBy(Q02bTablaBDQ022AS01V01.NOMCOLUMN_Q022AT00_NIPLAZO + " DESC");

 	    	

 	    	//se realiza la select

 	    	rs = vistaPlazos.select();

 	    	//aadimos el cursos para luego poder liberarlo ( en el freeResources)

 	    	vistaPlazos.addResultSet(rs); 

 	    	//se trata el resultado obtenido aadiendolo a la lista de salida

 	    	listaPlazos = this.rellenaVOsPlazosVista(rs);

    	

 	    	return listaPlazos;    	

 		}catch(Exception ex){ 	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getPlazos: " + sw.getBuffer ().toString());

     		throw ex;

 		}finally{

 		 	try{

 		 		//liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet

 		 		vistaPlazos.freeResourcesNotConnection();	

 			 }catch(Exception ex)

 			 {

 			    if (tr.isTraceActive())

 			    {

 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getPlazos: error liberando recursos.");

 	   	   	    }  

 			 }  		 			

 			 if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getPlazos: saliendo.");                

 	         }   

 		}	

 	}//fin getPlazos

    

    /**

     * Mtodo que dado el nmero interno del plazo 

     * recupera de la BBDD los datos de dicho plazo

     * @param niPlazo

     * @return

     */

    public Q02bPlazos obtenerPlazo(String niPlazo)throws Exception

    {

  	  if (tr.isTraceActive()){

 		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazo , ** dao niPlazo= "+  niPlazo + "  ** entrando");            

      }

  	  

  	  //se crean los objetos necesarios para realizar la select.

  	  Q02bTablaBDQ022AS01V01 Q02bTablaBDQ022AS01V01obj = null;

  	  Q02bPlazos plazoBD = null;

  	  ResultSet rs = null;   	  

        try{ 

          if (niPlazo!=null){           

        	  Q02bTablaBDQ022AS01V01obj = new Q02bTablaBDQ022AS01V01(this.getConnection());

          	

          	//se pone el filtro

        	  Q02bTablaBDQ022AS01V01obj.setQ022AT00_NIPLAZO_WHERE(new Integer(niPlazo));

        

          	rs = Q02bTablaBDQ022AS01V01obj.select();

          	Q02bTablaBDQ022AS01V01obj.addResultSet(rs);

          	plazoBD = new Q02bPlazos();

          	if (rs.next()){

          		plazoBD = this.rellenarVO(plazoBD,rs);

          	}

          }  

          return plazoBD;

          }catch(Exception ex){           	   

                 java.io.StringWriter sw = new java.io.StringWriter();

                 java.io.PrintWriter pw = new java.io.PrintWriter(sw);

                 ex.printStackTrace(pw);

                 tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerPlazo: " + sw.getBuffer ().toString());

                 throw ex;

          }finally{

       	   try{

       		   Q02bTablaBDQ022AS01V01obj.freeResourcesNotConnection();	

  				}catch(Exception ex){

  	   			if (tr.isTraceActive()){

  	   				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerPlazo: error liberando recursos");

  	   		   	   }  

  				}  	

           	  if (tr.isTraceActive()){

           		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazo: saliendo");                

                }            	 

          }	  

    }//fin obtenerPlazo

     

     /**

      * Funcin que inserta los datos del plazo pasado como parmetro en la BBDD

      * @param plazo - Datos del plazo a insertar 

      * @throws Exception

      */

     public void insertarPlazos(Q02bPlazos plazo) throws Exception {

    	int niPlazo = 0; 

    	Q02bTablaBDQ022AS00 tablaPlazos=null;

       	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarPlazos: entrando");

	    	}

    		//se crea el objeto de tablasBD

	    	tablaPlazos = new Q02bTablaBDQ022AS00(this.getConnection());

      		//primero recuperamos el nmero interno que le corresponde

    	   	niPlazo = dameSeqNiPlazos(tablaPlazos);

         	plazo.setNiPlazo(Integer.toString(niPlazo));      	

      		//se aaden los datos a insertar

         	this.rellenaDatosPlazos(plazo, tablaPlazos,true);         	         

      		//se realiza la insert

      		tablaPlazos.insert();

     	}

     	catch(Exception ex)

     	{   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarPlazos: " + sw.getBuffer ().toString());

     		throw ex;

     	}

     	finally

     	{

     		try

     		{

     			tablaPlazos.freeResourcesNotConnection();	

     		}

     		catch(Exception ex)

     		{

     			if (tr.isTraceActive())

     			{

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarPlazos: error liberando recursos");

 		   	   }  

 		}  		

		if (tr.isTraceActive())

		{

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarPlazos: saliendo");                

    		}       	

     	}

     } //insertarPlazos    

      

     /**

      * Funcin que borra el plazo pasado como parmetro de la BBDD

      * @param niPlazo - nmero interno del plazo a borrar

      * @throws Exception

      */

     public void borrarPlazos(String niPlazo) throws Exception {

      	if (tr.isTraceActive()){

      		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarPlazos: entrando");

      	}

      	Q02bTablaBDQ022AS00 Q02bTablaBDQ022AS00obj = null;

        try{       	

        	//se crean los objetos necesarios

         	Q02bTablaBDQ022AS00obj = new Q02bTablaBDQ022AS00(this.getConnection());   

         	

        	// segmento tecnico

            Q02bTablaBDQ022AS00obj.setUser(this.getUser());

         	

         	//se pone el filtro para la delete

         	Q02bTablaBDQ022AS00obj.setQ022AT00_NIPLAZO_WHERE(Integer.parseInt(niPlazo));         	

         	

         	//se lanza el delete

          	Q02bTablaBDQ022AS00obj.delete();         	

         }

         catch(Exception ex)

         {

              java.io.StringWriter sw = new java.io.StringWriter();

              java.io.PrintWriter pw = new java.io.PrintWriter(sw);

              ex.printStackTrace(pw);

              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarPlazos: " + sw.getBuffer ().toString());

              throw ex;

         } 

         finally {

         	try{

         		Q02bTablaBDQ022AS00obj.freeResourcesNotConnection();	

         	}

         	catch(Exception ex) {

         		if (tr.isTraceActive()) {

         			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarPlazos: error liberando recursos");

         		}  

         	}  		

         	if (tr.isTraceActive()) {

         		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarPlazos: saliendo");                

            }     	   

         }

     }//fin borrarPlazos

     

     /**

      * Funcin que modifica los datos del plazo pasado como parmetro en la BBDD

      * @param plazo - Datos del plazo a modificar

      * @throws Exception

      */

     public void modificarPlazos(Q02bPlazos plazo) throws Exception {



      	if (tr.isTraceActive()){

  		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarPlazos: entrando");

      	}

      	//Se instancian los objetos necesarios.

      	Q02bTablaBDQ022AS00 Q02bTablaBDQ022AS00obj = null;    

         	 try

         	 {     

         	 	//se crea el objeto de tablasBD

        		Q02bTablaBDQ022AS00obj = new Q02bTablaBDQ022AS00(this.getConnection());

        		

        		//segmento tecnico

             	//Q02bTablaBDQ022AS00obj.setUser(this.getUser());

        		  		

        		rellenaDatosPlazos(plazo,Q02bTablaBDQ022AS00obj,false);

        		Q02bTablaBDQ022AS00obj.setQ022AT00_NIPLAZO_WHERE(Integer.parseInt(plazo.getNiPlazo()));

       		       		

        		//se realiza la update

        		Q02bTablaBDQ022AS00obj.update();

         	 }

         	 catch(Exception ex) {

         		java.io.StringWriter sw = new java.io.StringWriter();

         		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

         		ex.printStackTrace(pw);

         		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarPlazos: " + sw.getBuffer ().toString());

              throw ex;

         	 }

         	 finally {     

         		 try {

         			 Q02bTablaBDQ022AS00obj.freeResourcesNotConnection();	

         		 }

         		 catch(Exception ex) {

         			 if (tr.isTraceActive()) {

         				 tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarPlazos: error liberando recursos");

         			 }  

         		 }  		  

         		 if (tr.isTraceActive()) {

         			 	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarPlazos: saliendo");                

                 }             

         	 }     

     } // fin modificarPlazos

}

