package q02b.exe.operacioninterna;



import java.lang.Throwable;



import q02b.exe.comun.Q02bAplicException;

import q02b.exe.utils.Q02bFormatData;



import q02b.exe.utils.oracle.Q02bErrorMessages;

import q02b.exe.utils.oracle.Q02bBDUtilidades;



import java.sql.SQLException;



import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInterna;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaError;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaErrors;

import es.ejie.frmk.negocio.operacioninterna.Q70OperacionInternaException;



import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

 

public class Q02bOperacionInterna extends Q70OperacionInterna {

	

	protected static final String COMPONENTE 	= "OPERACION_INTERNA";	

	

	/**

	 * Mtodo que sobreescribe al del Framework para poder utilizar cualquier mensaje de error

	 */

    protected void processOIException(Q70ContextoEJIE q70contextoejie, Exception exception, Q70OperacionInternaErrors q70operacioninternaerrors)

        throws Exception

    {

    	//Variable que contendr el mensaje

    	String mensaje = null;

    	//Se obtiene la excepcin recogida por el Framework y se realiza un casting

    	//para acceder a mtodos que nos interese

    	Q70OperacionInternaException 	q	= (Q70OperacionInternaException)exception;

    	//Se obtiene el Throwable que lanz la excepcin

    	Throwable 						t 	= q.getPrimaryException();

    	//Si el Throwable es de la clase que nos interesa se obtiene el mensaje

    	if(t instanceof Q02bAplicException){

    		mensaje = t.getMessage();//Se obtiene el mensaje

    	} 

    	else if(t instanceof SQLException){

    		Q02bErrorMessages msqOracle = new Q02bErrorMessages();

        	mensaje = msqOracle.getMessage(Q02bBDUtilidades.dbConstraintViolation((SQLException)t));

        	//Si el mensaje no tiene valor quiere decir que no tiene variable que controlar

        	//y se obtiene el mensaje por defecto

        	if(Q02bFormatData.esVacio(mensaje)){

        		mensaje = getConfiguracion().getOiErrorKey();//Se obtiene el mensaje por defecto

        	}

    	}

    	else {

    		mensaje = getConfiguracion().getOiErrorKey();//Se obtiene el mensaje por defecto

    	}

    	//Se asigna el error si no se ha sobreescrito anteriormente debido a un error

    	//en un pre-processingmapping etc. (ej.Subida de documentos)

    	if(q70operacioninternaerrors.isEmpty()){

	    	//Se asigna el error

	    	q70operacioninternaerrors.add("OI_ERROR", new Q70OperacionInternaError(mensaje));

    	}

    }

	 

}

