package q02b.exe.oficinasMunicipales.dataobjects;



import java.sql.Connection;

import java.sql.PreparedStatement;

import java.sql.ResultSet;

import java.util.ArrayList;



//import q02b.exe.arquitectura.dataobjects.Q02bDAOException;

import q02b.exe.arquitectura.dataobjects.Q02bDataBaseDAO;

//import q02b.exe.cuestionarioVAPM.valueobjects.Q02bCuestionarioVAPM;

//import q02b.exe.cuestionarioVAPM.valueobjects.Q02bCuestionarioVAPMFiltro;

//import q02b.exe.cuestionariosSMAnu.valueobjects.Q02bCuestionarioSM;

//import q02b.exe.cuestionariosSMAnu.valueobjects.Q02bCuestionarioSMFiltro;

//import q02b.exe.cuestionariosVTMAnu.valueobjects.Q02bCuestionarioVTMAnu;

//import q02b.exe.cuestionariosVTMAnu.valueobjects.Q02bCuestionarioVTMAnuFiltro;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022AS00;

import q02b.exe.oficinasMunicipales.valueobjects.Q02bOficinasMunicipales;

//import q02b.exe.plazos.valueobjects.Q02bPlazos;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022BS00;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022AV00;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022AS00;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022AS01V01;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022CS00;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022DS00;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022ES01V02;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022GS00;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022ES00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022HS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022HS01V01;

//import q02b.exe.utils.Q02bConstantes;

import q02b.exe.utils.Q02bFormatData;

//import q02b.exe.utils.Q02bAplicationUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

//import es.ejie.frmk.listeners.base.Q70ListenerUtils;

//import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

//import q02b.exe.utils.oracle.Q02bBDUtilidades;







public class Q02bOficinasMunicipalesDataBaseDAO extends Q02bDataBaseDAO{

	private static final long serialVersionUID = -8520551641771839103L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "DAO_ACCESO_DATOS";

	//private static final String RECURSOS_OFICINAS_MUNICIPALES = "q02brecursosCuestionarios";



	public Q02bOficinasMunicipalesDataBaseDAO() {

        super();                

    }



    

    public Q02bOficinasMunicipalesDataBaseDAO(Connection conn) {

    	super(conn);     

    }

    

    // -------------------- INI - OBTENER LISTA ----------------

    /**

     * Devuelve una lista de CNAE2009

     * segun un filtro y a traves de un vista

     * @param filtro - Q02bOficinasMunicipales

     * @return ArrayList de Q02bOficinasMunicipalesLista

     * @throws Exception

     * @see Q02bOficinasMunicipales

     * @see Q02bOficinasMunicipalesLista

     * @see Q02bTablaBDQ022HS01V01

     * @generated

     */

    public ArrayList obtenerListaOficinasMunicipales(Q02bOficinasMunicipales filtro)

        throws Exception {

        final String TRACE_METODO = nombreClaseSinPackage +

            ":obtenerListaOficinasMunicipales";



        if (tr.isTraceActive()) {

            tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +

                ": entrando");

        }



        //se instancian los objetos necesarios para realizar la consulta.	

        java.sql.ResultSet rs = null; // result set

        ArrayList lista = new ArrayList(); // lista de VO

        Q02bTablaBDQ022HS01V01 objTBD = null; // Objeto TablasBD de vista

        Q02bOficinasMunicipales regVO = null; // VO

        String colPK = "";



        try {

            //se instancia la clase del tablasBD a llamar pasandole la conexion

            objTBD = new Q02bTablaBDQ022HS01V01(this.getConnection());

            //se carga el filtro de la where con los datos de entrada.

            this.asignarFiltroOficinasMunicipales(objTBD, filtro);

            //Se indica el order by de las columnas	

            objTBD.setOrderBy(Q02bTablaBDQ022HS01V01.NOMCOLUMN_NORA_T17_PROVINCIA_DS + ", "  + Q02bTablaBDQ022HS01V01.NOMCOLUMN_NORA_T17_MUNICIPIO_DS);



            // se asignan los campos de auditoria

            //objTBD.setAuditUser(new Long(this.getUser()));

            //se realiza la select

            rs = objTBD.select();

            objTBD.addResultSet(rs);



            //se trata el resultado obtenido a?adiendolo a la lista de salida

            while (rs.next()) {

                regVO = new Q02bOficinasMunicipales();

                //se cargan en el objeto los datos recuperados            	 

                regVO.setIdOfi(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_ID_OFI));



                regVO.setIdProvincia(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_PROV));



                regVO.setIdMunicipio(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_MUNI));



                regVO.setDescripcion(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_DESC));



                regVO.setDescripcionEus(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_DESC_EUS));



                regVO.setTipoVia(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_TVIA));



                regVO.setCalle(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_CALLE));



                regVO.setBloque(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_BLOQ));



                regVO.setNumero(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_NUME));



                regVO.setBis(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_BIS));



                regVO.setEscalera(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_ESCA));



                regVO.setPiso(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_PISO));



                regVO.setMano(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_MANO));



                regVO.setPuerta(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_PUER));



                regVO.setCodigoPostal(rs.getString(Q02bTablaBDQ022HS01V01.COLUMN_Q022HT00_CODP));



                regVO.setComplementoDireccion(rs.getString(Q02bTablaBDQ022HS01V01.COLUMN_Q022HT00_CDIR));



                regVO.setDepartamento(rs.getString(Q02bTablaBDQ022HS01V01.COLUMN_Q022HT00_DEPA));



                regVO.setEmail(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_EMAILD));



                regVO.setTelefono1(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_TELF1D));



                regVO.setTelefono2(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_TELF2D));



                regVO.setFax(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_FAXD));



                regVO.setWeb(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_WEB));



                regVO.setDenomProvincia(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_NORA_T17_PROVINCIA_DS));



                regVO.setDenomMunicipio(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_NORA_T17_MUNICIPIO_DS));

                

                regVO.setLocalizacion(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_NORA_T17_LOCALIZACION));



                



                regVO.setColumnaPK(colPK);

                lista.add(regVO);

            }

        } catch (Exception ex) {

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR,

                TRACE_METODO + ": " + sw.getBuffer().toString());

            throw ex;

        } finally {

            try {

                objTBD.freeResourcesNotConnection();

            } catch (Exception ex) {

                if (tr.isTraceActive()) {

                    tr.trace(COMPONENTE, Q70TraceLevel.ERROR,

                        TRACE_METODO + ": error liberando recursos");

                }

            }



            if (tr.isTraceActive()) {

                tr.trace(COMPONENTE, Q70TraceLevel.INFO,

                    TRACE_METODO + ": saliendo");

            }

        }



        return lista;

    }



    // -------------------- FIN - OBTENER LISTA	 --------------------- 

    

    // -------------------- INI - ASIGNARFILTRO ------------------------

    /**

     * M?todo que se invoca desde dentro del DAO para asignar el filtro

     * al objeto TablasBD

     * @param filtro - S99bCNAE2009Filtro

     * @param vista - S99bTablaBDS99DTSG2V01

     * @throws Exception

     * @see S99bCNAE2009Filtro

     * @see S99bTablaBDS99DTSG2V01

     * @generated

     */

    private void asignarFiltroOficinasMunicipales(Q02bTablaBDQ022HS01V01 vista,Q02bOficinasMunicipales filtro) throws Exception {

        final String TRACE_METODO = nombreClaseSinPackage +

            ":asignarFiltroOficinasMunicipales";



        if (tr.isTraceActive()) {

            tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +

                ": entrando");

        }



        if (filtro != null) {

            // Inicializacion del filtro

            StringBuffer addWhere = new StringBuffer();



            if (!Q02bFormatData.esVacio(filtro.getIdOfi())) {

                vista.setQ022HT00_ID_OFI_WHERE(Integer.parseInt(filtro.getIdOfi()));

            }



            if (!Q02bFormatData.esVacio(filtro.getIdProvincia())) {

                vista.setQ022HT00_PROV_WHERE(filtro.getIdProvincia());

            }



            if (!Q02bFormatData.esVacio(filtro.getIdMunicipio())) {

                vista.setQ022HT00_MUNI_WHERE(filtro.getIdMunicipio());

            }

            

            if (!Q02bFormatData.esVacio(filtro.getDescripcion())) {

                addWhere.append(" AND ( (TRANSLATE(UPPER(");

                addWhere.append(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_DESC);

                addWhere.append("),'','AEIOUAEIOU')) LIKE  '%");

                addWhere.append(Q02bFormatData.convertirMaysculaSinAcento(filtro.getDescripcion()));

                addWhere.append("%' ) ");

            }

            

            if (!Q02bFormatData.esVacio(filtro.getDescripcionEus())) {

                addWhere.append(" AND ( (TRANSLATE(UPPER(");

                addWhere.append(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_DESC_EUS);

                addWhere.append("),'','AEIOUAEIOU')) LIKE  '%");

                addWhere.append(Q02bFormatData.convertirMaysculaSinAcento(filtro.getDescripcionEus()));

                addWhere.append("%' ) ");

            }

            

            if (!Q02bFormatData.esVacio(filtro.getDepartamento())) {

                addWhere.append(" AND ( (TRANSLATE(UPPER(");

                addWhere.append(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_DEPA);

                addWhere.append("),'','AEIOUAEIOU')) LIKE  '%");

                addWhere.append(Q02bFormatData.convertirMaysculaSinAcento(filtro.getDepartamento()));

                addWhere.append("%' ) ");

            }           

                                    

            //Se a?ade el aditional where al tablasBD

            vista.setAditionalWhere(addWhere.toString());

        }



        if (tr.isTraceActive()) {

            tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +

                ": saliendo");

        }

    }



    // -------------------- FIN - ASIGNARFILTRO ----------------------

    

    /**

     * Funcin que inserta los datos de la oficina municipal pasada como parmetro en la BBDD

     * @param oficinaMunicipal - Datos de la oficina municipal a insertar 

     * @throws Exception

     */

    public void insertarOficinasMunicipales(Q02bOficinasMunicipales oficinaMunicipal) throws Exception {

   	int niOficinaMunicipal = 0; 

   	Q02bTablaBDQ022HS00 tablaOficinasMunicipales=null;

      	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarOficinasMunicipales: entrando");

	    	}

	    	//se crea el objeto de tablasBD

	    	tablaOficinasMunicipales = new Q02bTablaBDQ022HS00(this.getConnection());

     		//primero recuperamos el nmero interno que le corresponde

   	   		niOficinaMunicipal = dameSeqNiOficinaMunicipal(tablaOficinasMunicipales);

   	   		oficinaMunicipal.setIdOfi(Integer.toString(niOficinaMunicipal));      	

     		//se aaden los datos a insertar

        	this.rellenaDatosOficinasMunicipales(oficinaMunicipal, tablaOficinasMunicipales);         	         

     		//se realiza la insert

        	tablaOficinasMunicipales.insert();

    	}

    	catch(Exception ex)

    	{   	   

    		java.io.StringWriter sw = new java.io.StringWriter();

    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

    		ex.printStackTrace(pw);

    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarOficinasMunicipales: " + sw.getBuffer ().toString());

    		throw ex;

    	}

    	finally

    	{

    		try

    		{

    			tablaOficinasMunicipales.freeResourcesNotConnection();	

    		}

    		catch(Exception ex)

    		{

    			if (tr.isTraceActive())

    			{

    				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarOficinasMunicipales: error liberando recursos");

		   	   }  

		}  		

		if (tr.isTraceActive())

		{

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarOficinasMunicipales: saliendo");                

   		}       	

    	}

    } //insertarOficinasMunicipales

    

    private int dameSeqNiOficinaMunicipal(Q02bTablaBDQ022HS00 tablaOficinasMunicipales) throws Exception 

    {

    	int niOficinaMunicipal=1;

    	ResultSet rs = null;

      	PreparedStatement prepStmt =null;	

    	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameSeqNiOficinaMunicipal: entrando");

	    	}

	    	StringBuffer query = new StringBuffer(" SELECT Q022HQ00.NEXTVAL FROM DUAL ");

        	prepStmt = this.getConnection().prepareStatement(query.toString());         	

        	rs = prepStmt.executeQuery();

        	tablaOficinasMunicipales.addResultSet(rs);

        	tablaOficinasMunicipales.addStatement(prepStmt);        	

        	if (rs.next()){

        		niOficinaMunicipal = rs.getInt(1);

        		

        	}	         	

        	return niOficinaMunicipal;

       }

	        catch(Exception ex)

    	        {   	   

    		java.io.StringWriter sw = new java.io.StringWriter();

    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

    		ex.printStackTrace(pw);

    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameSeqNiOficinaMunicipal: " + sw.getBuffer ().toString());

    		throw ex;

    	      }

    }//dameSeqNiOficinaMunicipal

    

    public void rellenaDatosOficinasMunicipales(Q02bOficinasMunicipales oficinaMunicipal,Q02bTablaBDQ022HS00 tablaOficinasMunicipales) throws Exception {

       	//se definen objetos necesarios.

       	try{

   	    	if (tr.isTraceActive())

   	    	{

   	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosOficinasMunicipales: entrando");

   	    	}         	         

        	//se aaden los datos

   	    	tablaOficinasMunicipales.setQ022HT00_ID_OFI(Q02bFormatData.checkIntegerNull(oficinaMunicipal.getIdOfi()));

   	    	tablaOficinasMunicipales.setQ022HT00_PROV(Q02bFormatData.checkStringNull(oficinaMunicipal.getIdProvincia()));

   	    	tablaOficinasMunicipales.setQ022HT00_MUNI(Q02bFormatData.checkStringNull(oficinaMunicipal.getIdMunicipio()));

   	    	tablaOficinasMunicipales.setQ022HT00_DESC(Q02bFormatData.checkStringNull(oficinaMunicipal.getDescripcion()));

   	    	tablaOficinasMunicipales.setQ022HT00_DESC_EUS(Q02bFormatData.checkStringNull(oficinaMunicipal.getDescripcionEus()));

   	    	tablaOficinasMunicipales.setQ022HT00_TVIA(Q02bFormatData.checkStringNull(oficinaMunicipal.getTipoVia()));

   	    	tablaOficinasMunicipales.setQ022HT00_CALLE(Q02bFormatData.checkLongNull(oficinaMunicipal.getCalle()));

   	    	tablaOficinasMunicipales.setQ022HT00_BLOQ(Q02bFormatData.checkStringNull(oficinaMunicipal.getBloque()));

   	    	tablaOficinasMunicipales.setQ022HT00_NUME(Q02bFormatData.checkIntegerNull(oficinaMunicipal.getNumero()));

   	    	tablaOficinasMunicipales.setQ022HT00_BIS(Q02bFormatData.checkStringNull(oficinaMunicipal.getBis()));

   	    	tablaOficinasMunicipales.setQ022HT00_ESCA(Q02bFormatData.checkStringNull(oficinaMunicipal.getEscalera()));

   	    	tablaOficinasMunicipales.setQ022HT00_PISO(Q02bFormatData.checkStringNull(oficinaMunicipal.getPiso()));

   	    	tablaOficinasMunicipales.setQ022HT00_MANO(Q02bFormatData.checkStringNull(oficinaMunicipal.getMano()));

   	    	tablaOficinasMunicipales.setQ022HT00_PUER(Q02bFormatData.checkStringNull(oficinaMunicipal.getPuerta()));

   	    	tablaOficinasMunicipales.setQ022HT00_CODP(Q02bFormatData.checkStringNull(oficinaMunicipal.getCodigoPostal()));

   	    	tablaOficinasMunicipales.setQ022HT00_CDIR(Q02bFormatData.checkStringNull(oficinaMunicipal.getComplementoDireccion()));

   	    	tablaOficinasMunicipales.setQ022HT00_DEPA(Q02bFormatData.checkStringNull(oficinaMunicipal.getDepartamento()));

   	    	tablaOficinasMunicipales.setQ022HT00_EMAILD(Q02bFormatData.checkStringNull(oficinaMunicipal.getEmail()));

   	    	tablaOficinasMunicipales.setQ022HT00_TELF1D(Q02bFormatData.checkIntegerNull(oficinaMunicipal.getTelefono1()));

   	    	tablaOficinasMunicipales.setQ022HT00_TELF2D(Q02bFormatData.checkIntegerNull(oficinaMunicipal.getTelefono2()));

   	    	tablaOficinasMunicipales.setQ022HT00_FAXD(Q02bFormatData.checkIntegerNull(oficinaMunicipal.getFax()));

   	    	tablaOficinasMunicipales.setQ022HT00_WEB(Q02bFormatData.checkStringNull(oficinaMunicipal.getWeb()));   	    	   	    	

       	}catch(Exception ex){   	   

       		java.io.StringWriter sw = new java.io.StringWriter();

       		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

       		ex.printStackTrace(pw);

       		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaDatosOficinasMunicipales: " + sw.getBuffer ().toString());

       		throw ex;

       	}finally{    		

   			if (tr.isTraceActive()){

   				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosOficinasMunicipales: saliendo = " + tablaOficinasMunicipales.getQ022HT00_ID_OFI());                

              }       	

       	}	

     }//rellenaDatosOficinasMunicipales

    

    /**

     * Mtodo que dado el nmero interno de la oficinaMunicipal 

     * recupera de la BBDD los datos de dicho oficinaMunicipal

     * @param idOfi

     * @return

     */

    public Q02bOficinasMunicipales obtenerOficinaMunicipal(String idOfi)throws Exception {

  	  if (tr.isTraceActive()){

 		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerOficinaMunicipal , ** dao idOfi= "+  idOfi + "  ** entrando");            

      }

  	  

  	  //se crean los objetos necesarios para realizar la select.

  	  Q02bTablaBDQ022HS01V01 Q02bTablaBDQ022HS01V01obj = null;

  	  Q02bOficinasMunicipales oficinaMunicipalBD = null;

  	  ResultSet rs = null;   	  

        try{ 

          if (idOfi!=null){           

        	  Q02bTablaBDQ022HS01V01obj = new Q02bTablaBDQ022HS01V01(this.getConnection());

          	

          	//se pone el filtro

        	  Q02bTablaBDQ022HS01V01obj.setQ022HT00_ID_OFI_WHERE(new Integer(idOfi));

        

          	rs = Q02bTablaBDQ022HS01V01obj.select();

          	Q02bTablaBDQ022HS01V01obj.addResultSet(rs);

          	oficinaMunicipalBD = new Q02bOficinasMunicipales();

          	if (rs.next()){

          		oficinaMunicipalBD = this.rellenarVO(oficinaMunicipalBD,rs);

          	}

          }  

          return oficinaMunicipalBD;

          }catch(Exception ex){           	   

                 java.io.StringWriter sw = new java.io.StringWriter();

                 java.io.PrintWriter pw = new java.io.PrintWriter(sw);

                 ex.printStackTrace(pw);

                 tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerOficinaMunicipal: " + sw.getBuffer ().toString());

                 throw ex;

          }finally{

       	   try{

       		Q02bTablaBDQ022HS01V01obj.freeResourcesNotConnection();	

  				}catch(Exception ex){

  	   			if (tr.isTraceActive()){

  	   				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerOficinaMunicipal: error liberando recursos");

  	   		   	   }  

  				}  	

           	  if (tr.isTraceActive()){

           		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerOficinaMunicipal: saliendo");                

                }            	 

          }	  

    }//fin obtenerOficinaMunicipal

    

    private Q02bOficinasMunicipales rellenarVO(Q02bOficinasMunicipales oficinaMunicipal, ResultSet rs) throws Exception{

    	try {

    		if (tr.isTraceActive()){

 		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenarVO: entrando");                

 		    } 

    		oficinaMunicipal.setIdOfi(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_ID_OFI));			

    		oficinaMunicipal.setIdProvincia(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_PROV));

    		oficinaMunicipal.setIdMunicipio(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_MUNI));

    		oficinaMunicipal.setDescripcion(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_DESC));

    		oficinaMunicipal.setDescripcionEus(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_DESC_EUS));

    		oficinaMunicipal.setTipoVia(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_TVIA));

    		oficinaMunicipal.setCalle(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_CALLE));

    		oficinaMunicipal.setBloque(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_BLOQ));

    		oficinaMunicipal.setNumero(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_NUME));

    		oficinaMunicipal.setBis(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_BIS));

    		oficinaMunicipal.setEscalera(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_ESCA));

    		oficinaMunicipal.setPiso(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_PISO));

    		oficinaMunicipal.setMano(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_MANO));

    		oficinaMunicipal.setPuerta(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_PUER));

    		oficinaMunicipal.setCodigoPostal(rs.getString(Q02bTablaBDQ022HS01V01.COLUMN_Q022HT00_CODP));

    		oficinaMunicipal.setComplementoDireccion(rs.getString(Q02bTablaBDQ022HS01V01.COLUMN_Q022HT00_CDIR));

    		oficinaMunicipal.setDepartamento(rs.getString(Q02bTablaBDQ022HS01V01.COLUMN_Q022HT00_DEPA));

    		oficinaMunicipal.setEmail(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_EMAILD));

    		oficinaMunicipal.setTelefono1(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_TELF1D));

    		oficinaMunicipal.setTelefono2(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_TELF2D));

    		oficinaMunicipal.setFax(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_FAXD));

    		oficinaMunicipal.setWeb(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_Q022HT00_WEB));

    		oficinaMunicipal.setDenomProvincia(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_NORA_T17_PROVINCIA_DS));

    		oficinaMunicipal.setDenomMunicipio(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_NORA_T17_MUNICIPIO_DS));             

    		oficinaMunicipal.setLocalizacion(rs.getString(Q02bTablaBDQ022HS01V01.NOMCOLUMN_NORA_T17_LOCALIZACION));

    		

	    	return oficinaMunicipal;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

	  	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	  	       ex.printStackTrace(pw);

	  	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenarVO: " + sw.getBuffer ().toString());

	  	       throw ex;

		}

    	

    }

    

    /**

     * Funcin que modifica los datos del plazo pasado como parmetro en la BBDD

     * @param oficinaMunicipal - Datos del plazo a modificar

     * @throws Exception

     */

    public void modificarOficinasMunicipales(Q02bOficinasMunicipales oficinaMunicipal) throws Exception {



     	if (tr.isTraceActive()){

 		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarOficinasMunicipales: entrando");

     	}

     	//Se instancian los objetos necesarios.

     	Q02bTablaBDQ022HS00 Q02bTablaBDQ022HS00obj = null;    

        	 try

        	 {     

        	 	//se crea el objeto de tablasBD

       		Q02bTablaBDQ022HS00obj = new Q02bTablaBDQ022HS00(this.getConnection());

       		

       		//segmento tecnico

            	//Q02bTablaBDQ022AS00obj.setUser(this.getUser());

       		  		

       		rellenaDatosOficinasMunicipales(oficinaMunicipal,Q02bTablaBDQ022HS00obj);

       		Q02bTablaBDQ022HS00obj.setQ022HT00_ID_OFI_WHERE(Integer.parseInt(oficinaMunicipal.getIdOfi()));

      		       		

       		//se realiza la update

       		Q02bTablaBDQ022HS00obj.update();

        	 }

        	 catch(Exception ex) {

        		java.io.StringWriter sw = new java.io.StringWriter();

        		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

        		ex.printStackTrace(pw);

        		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarOficinasMunicipales: " + sw.getBuffer ().toString());

             throw ex;

        	 }

        	 finally {     

        		 try {

        			 Q02bTablaBDQ022HS00obj.freeResourcesNotConnection();	

        		 }

        		 catch(Exception ex) {

        			 if (tr.isTraceActive()) {

        				 tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarOficinasMunicipales: error liberando recursos");

        			 }  

        		 }  		  

        		 if (tr.isTraceActive()) {

        			 	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarOficinasMunicipales: saliendo");                

                }             

        	 }     

    } // fin modificarOficinasMunicipales

    

    /**

     * Funcin que borra la oficinaMunicipal pasado como parmetro de la BBDD

     * @param idOfi - nmero interno de la oficina municipal a borrar

     * @throws Exception

     */

    public void borrarOficinaMunicipal(String idOfi) throws Exception {

     	if (tr.isTraceActive()){

     		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarOficinaMunicipal: entrando");

     	}

     	Q02bTablaBDQ022HS00 Q02bTablaBDQ022HS00obj = null;

       try{       	

       	//se crean los objetos necesarios

        	Q02bTablaBDQ022HS00obj = new Q02bTablaBDQ022HS00(this.getConnection());   

        	

       	// segmento tecnico

           Q02bTablaBDQ022HS00obj.setUser(this.getUser());

        	

        	//se pone el filtro para la delete

        	Q02bTablaBDQ022HS00obj.setQ022HT00_ID_OFI_WHERE(Integer.parseInt(idOfi));         	

        	

        	//se lanza el delete

         	Q02bTablaBDQ022HS00obj.delete();         	

        }

        catch(Exception ex)

        {

             java.io.StringWriter sw = new java.io.StringWriter();

             java.io.PrintWriter pw = new java.io.PrintWriter(sw);

             ex.printStackTrace(pw);

             tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarOficinaMunicipal: " + sw.getBuffer ().toString());

             throw ex;

        } 

        finally {

        	try{

        		Q02bTablaBDQ022HS00obj.freeResourcesNotConnection();	

        	}

        	catch(Exception ex) {

        		if (tr.isTraceActive()) {

        			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarOficinaMunicipal: error liberando recursos");

        		}  

        	}  		

        	if (tr.isTraceActive()) {

        		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarOficinaMunicipal: saliendo");                

           }     	   

        }

    }//fin borrarOficinaMunicipal

    

       

}

