package q02b.exe.modulos.dataobjects;



import java.sql.Connection;

import java.sql.PreparedStatement;

import java.sql.ResultSet;

import java.util.ArrayList;



import q02b.exe.arquitectura.dataobjects.Q02bDataBaseDAO;

import q02b.exe.modulos.valueobjects.Q02bModulos;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ021ES00;

import q02b.exe.utils.Q02bConstantes;

import q02b.exe.utils.Q02bFormatData;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

import q02b.exe.utils.Q02bConstantes;







public class Q02bModulosDataBaseDAO extends Q02bDataBaseDAO{

	private static final long serialVersionUID = -8520551641771839103L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "DAO_ACCESO_DATOS";



	public Q02bModulosDataBaseDAO() {

        super();                

    }



    

    public Q02bModulosDataBaseDAO(Connection conn) {

    	super(conn);     

    }



    public void rellenaFiltroModulos(Q02bModulos moduloFiltro, Q02bTablaBDQ021ES00 tablaModulos) throws Exception {

		// Definición de variables que no se van a modificar

		final String TRACE_METODO = ":rellenaFiltroModulos:";

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ TRACE_METODO + " entrando");

			}

			if (moduloFiltro != null) {

			// Inicializacion del filtro

	            StringBuffer addWhere = new StringBuffer();

				if (!Q02bFormatData.esVacio(moduloFiltro.getCodModulo())) {

	                addWhere.append(" AND ( (TRANSLATE(UPPER(");

	                addWhere.append(Q02bTablaBDQ021ES00.NOMCOLUMN_Q021ET00_CODIGO);

	                addWhere.append("),'','AEIOUAEIOU')) LIKE  '%");

	                addWhere.append(Q02bFormatData.convertirMaysculaSinAcento(moduloFiltro.getCodModulo()));

	                addWhere.append("%' ) ");

	            }

				if (!Q02bFormatData.esVacio(moduloFiltro.getNombreModulo())) {

	                addWhere.append(" AND ( (TRANSLATE(UPPER(");

	                addWhere.append(Q02bTablaBDQ021ES00.NOMCOLUMN_Q021ET00_DESC);

	                addWhere.append("),'','AEIOUAEIOU')) LIKE  '%");

	                addWhere.append(Q02bFormatData.convertirMaysculaSinAcento(moduloFiltro.getNombreModulo()));

	                addWhere.append("%' ) ");

	            }

				

				  //Se a?ade el aditional where al tablasBD

	            tablaModulos.setAditionalWhere(addWhere.toString());

			}

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ TRACE_METODO + sw.getBuffer().toString());

			throw ex;

		} finally {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ TRACE_METODO + " saliendo");

			}

		}

	}// fin rellenaFiltroModulos

    

    private ArrayList rellenaVOsModulosTabla( ResultSet rs ) throws Exception{

     	Q02bModulos modulos;

     	ArrayList listaModulos = new ArrayList();

     	try{

     		if (tr.isTraceActive()){

 		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOsModulos: entrando");                

 		    } 

     		while (rs.next()){	 

 	        	//se cargan en el objeto cuestionario los datos recuperados

     			modulos = new Q02bModulos();

     			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":rellenarVOsModulos: Hay Datos");            

     			modulos = this.rellenarVO(modulos, rs); 

     			listaModulos.add(modulos);

   			}  	  

     		return listaModulos;

     	}catch(Exception ex){    	 	   

  	       java.io.StringWriter sw = new java.io.StringWriter();

  	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);

  	       ex.printStackTrace(pw);

  	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaVOsModulos: " + sw.getBuffer ().toString());

  	       throw ex;

  		}finally{			 	

  			if (tr.isTraceActive()){

  		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOsModulos: saliendo");                

  		    }    				

  		}

     }//fin rellenarVOsModulosTabla(rs) 

    

    private Q02bModulos rellenarVO(Q02bModulos modulos, ResultSet rs) throws Exception{

   	  		try{

   	  			if (tr.isTraceActive()){

 		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenarVO: entrando");                

   	  			} 

   	  		modulos.setIdModulo(rs.getString(Q02bTablaBDQ021ES00.NOMCOLUMN_Q021ET00_NI));

   	  		modulos.setCodModulo(rs.getString(Q02bTablaBDQ021ES00.NOMCOLUMN_Q021ET00_CODIGO));

   	  		modulos.setNombreModulo(rs.getString(Q02bTablaBDQ021ES00.NOMCOLUMN_Q021ET00_DESC));

   	  		modulos.setIndInactivo(rs.getString(Q02bTablaBDQ021ES00.NOMCOLUMN_Q021ET00_IND_INACTIVO ));

			

	    	return modulos;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

	  	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	  	       ex.printStackTrace(pw);

	  	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenarVO: " + sw.getBuffer ().toString());

	  	       throw ex;

   	  		}  	

    	

   	  	}

     

     private int dameSeqIdModulo(Q02bTablaBDQ021ES00 tablaModulos) throws Exception 

     {

    	int idModulo=1;

     	ResultSet rs = null;

       	PreparedStatement prepStmt =null;	

     	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameSeqIdModulo: entrando");

	    	}

    		StringBuffer query = new StringBuffer(" SELECT Q021EQ00.NEXTVAL FROM DUAL ");

         	prepStmt = this.getConnection().prepareStatement(query.toString());         	

         	rs = prepStmt.executeQuery();

         	tablaModulos.addResultSet(rs);

         	tablaModulos.addStatement(prepStmt);        	

         	if (rs.next()){

         		idModulo = rs.getInt(1);

         		

         	}	         	

         	return idModulo;

        }

	        catch(Exception ex)

     	        {   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameSeqIdModulo: " + sw.getBuffer ().toString());

     		throw ex;

     	      }

     }//dameSeqIdModulo

     

     public void rellenaDatosModulos(Q02bModulos modulo,Q02bTablaBDQ021ES00 tablaModulos) throws Exception {

       	//se definen objetos necesarios.

       	try{

   	    	if (tr.isTraceActive())

   	    	{

   	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosModulos: entrando");

   	    	}         	         

        	//se aaden los datos

   	    	tablaModulos.setQ021ET00_NI(Q02bFormatData.checkLongNull(modulo.getIdModulo()));   	    	

   	    	tablaModulos.setQ021ET00_CODIGO(Q02bFormatData.checkStringNull(modulo.getCodModulo()));

   	    	tablaModulos.setQ021ET00_DESC(Q02bFormatData.checkStringNull(modulo.getNombreModulo()));

   	    	tablaModulos.setQ021ET00_IND_INACTIVO(Integer.parseInt(Q02bConstantes.REGISTRO_ACTIVO));

   	    	tablaModulos.setUSER(new Long(this.getUser()));

   	    	

       	}catch(Exception ex){   	   

       		java.io.StringWriter sw = new java.io.StringWriter();

       		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

       		ex.printStackTrace(pw);

       		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaDatosModulos: " + sw.getBuffer ().toString());

       		throw ex;

       	}finally{    		

   			if (tr.isTraceActive()){

   				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosModulos: saliendo = " + tablaModulos.getQ021ET00_NI());                

              }       	

       	}	

     }//rellenaDatosModulos 

     

     public void rellenaDatosModulosModificar(Q02bModulos modulo,Q02bTablaBDQ021ES00 tablaModulos) throws Exception {

        	//se definen objetos necesarios.

        	try{

    	    	if (tr.isTraceActive())

    	    	{

    	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosModulosModificar: entrando");

    	    	}         	         

         	//se aaden los datos

    	    	tablaModulos.setQ021ET00_NI(Q02bFormatData.checkLongNull(modulo.getIdModulo()));   	    	

    	    	tablaModulos.setQ021ET00_CODIGO(Q02bFormatData.checkStringNull(modulo.getCodModulo()));

    	    	tablaModulos.setQ021ET00_DESC(Q02bFormatData.checkStringNull(modulo.getNombreModulo()));

    	    	//tablaModulos.setUSER(new Long(this.getUser()));

    	    	

        	}catch(Exception ex){   	   

        		java.io.StringWriter sw = new java.io.StringWriter();

        		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

        		ex.printStackTrace(pw);

        		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaDatosModulosModificar: " + sw.getBuffer ().toString());

        		throw ex;

        	}finally{    		

    			if (tr.isTraceActive()){

    				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosModulosModificar: saliendo = " + tablaModulos.getQ021ET00_NI());                

               }       	

        	}	

      }//rellenaDatosModulosModificar  

     

    public ArrayList obtenerModulos(Q02bModulos moduloFiltro) throws Exception {		

 		//se instancian los objetos necesarios para realizar la consulta.			

 		Q02bTablaBDQ021ES00 tablaModulos=null;

 		ResultSet rs = null;

 		ArrayList listaModulos = new ArrayList();

 		

 		try{

 	    	if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerModulos: entrando");

 			}

 	    	

 	    	//se instancia la clase del tablas bd a llamar pasandole la conexion	    	

 	    	tablaModulos = new Q02bTablaBDQ021ES00(this.getConnection());

 	    	

 	    	//se aade la where

			this.rellenaFiltroModulos(moduloFiltro, tablaModulos);

 	    	tablaModulos.setOrderBy(Q02bTablaBDQ021ES00.NOMCOLUMN_Q021ET00_NI + " DESC");

 	    	

 	    	//se realiza la select

 	    	rs = tablaModulos.select();

 	    	//aadimos el cursos para luego poder liberarlo ( en el freeResources)

 	    	tablaModulos.addResultSet(rs); 

 	    	//se trata el resultado obtenido aadiendolo a la lista de salida

 	    	listaModulos = this.rellenaVOsModulosTabla(rs);

    	

 	    	return listaModulos;    	

 		}catch(Exception ex){ 	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerModulos: " + sw.getBuffer ().toString());

     		throw ex;

 		}finally{

 		 	try{

 		 		//liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet

 		 		tablaModulos.freeResourcesNotConnection();	

 			 }catch(Exception ex)

 			 {

 			    if (tr.isTraceActive())

 			    {

 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerModulos: error liberando recursos.");

 	   	   	    }  

 			 }  		 			

 			 if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerModulos: saliendo.");                

 	         }   

 		}	

 	}//fin obtenerModulos

    

    /**

     * Mtodo que dado el nmero interno del modulo 

     * recupera de la BBDD los datos de dicho modulo

     * @param idModulo

     * @return

     */

    public Q02bModulos obtenerModulo(String idModulo)throws Exception

    {

  	  if (tr.isTraceActive()){

 		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazo , ** dao idModulo= "+  idModulo + "  ** entrando");            

      }

  	  

  	  //se crean los objetos necesarios para realizar la select.

  	  Q02bTablaBDQ021ES00 Q02bTablaBDQ021ES00obj = null;

  	  Q02bModulos moduloBD = null;

  	  ResultSet rs = null;   	  

        try{ 

          if (idModulo!=null){           

        	  Q02bTablaBDQ021ES00obj = new Q02bTablaBDQ021ES00(this.getConnection());

          	

          	//se pone el filtro

        	  Q02bTablaBDQ021ES00obj.setQ021ET00_NI_WHERE(new Long(idModulo));

        

          	rs = Q02bTablaBDQ021ES00obj.select();

          	Q02bTablaBDQ021ES00obj.addResultSet(rs);

          	moduloBD = new Q02bModulos();

          	if (rs.next()){

          		moduloBD = this.rellenarVO(moduloBD,rs);

          	}

          }  

          return moduloBD;

          }catch(Exception ex){           	   

                 java.io.StringWriter sw = new java.io.StringWriter();

                 java.io.PrintWriter pw = new java.io.PrintWriter(sw);

                 ex.printStackTrace(pw);

                 tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerModulo: " + sw.getBuffer ().toString());

                 throw ex;

          }finally{

       	   try{

       		   Q02bTablaBDQ021ES00obj.freeResourcesNotConnection();	

  				}catch(Exception ex){

  	   			if (tr.isTraceActive()){

  	   				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerModulo: error liberando recursos");

  	   		   	   }  

  				}  	

           	  if (tr.isTraceActive()){

           		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerModulo: saliendo");                

                }            	 

          }	  

    }//fin obtenerModulo

     

     /**

      * Funcin que inserta los datos del mdulo pasado como parmetro en la BBDD

      * @param plazo - Datos del mdulo a insertar 

      * @throws Exception

      */

     public void insertarModulos(Q02bModulos modulo) throws Exception {

    	int idModulo = 0; 

    	Q02bTablaBDQ021ES00 tablaModulos=null;

       	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarModulos: entrando");

	    	}

    		//se crea el objeto de tablasBD

	    	tablaModulos = new Q02bTablaBDQ021ES00(this.getConnection());

      		//primero recuperamos el nmero interno que le corresponde

    	   	idModulo = dameSeqIdModulo(tablaModulos);

         	modulo.setIdModulo(Integer.toString(idModulo));      	

      		//se aaden los datos a insertar

         	this.rellenaDatosModulos(modulo, tablaModulos);         	         

      		//se realiza la insert

      		tablaModulos.insert();

     	}

     	catch(Exception ex)

     	{   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarModulos: " + sw.getBuffer ().toString());

     		throw ex;

     	}

     	finally

     	{

     		try

     		{

     			tablaModulos.freeResourcesNotConnection();	

     		}

     		catch(Exception ex)

     		{

     			if (tr.isTraceActive())

     			{

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarModulos: error liberando recursos");

 		   	   }  

 		}  		

		if (tr.isTraceActive())

		{

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarModulos: saliendo");                

    		}       	

     	}

     } //insertarModulos    

      

     /**

      * Funcin que borra el mdulo pasado como parmetro de la BBDD

      * @param idModulo - nmero interno del mdulo a borrar

      * @throws Exception

      */

     public void borrarModulos(String idModulo) throws Exception {

      	if (tr.isTraceActive()){

      		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarModulos: entrando");

      	}

      	Q02bTablaBDQ021ES00 Q02bTablaBDQ021ES00obj = null;

        try{       	

        	//se crean los objetos necesarios

         	Q02bTablaBDQ021ES00obj = new Q02bTablaBDQ021ES00(this.getConnection());   

         	

        	// segmento tecnico

            Q02bTablaBDQ021ES00obj.setUser(this.getUser());

         	

         	//se pone el filtro para la delete

         	Q02bTablaBDQ021ES00obj.setQ021ET00_NI_WHERE(Integer.parseInt(idModulo));         	

         	

         	//se lanza el delete

          	Q02bTablaBDQ021ES00obj.delete();         	

         }

         catch(Exception ex)

         {

              java.io.StringWriter sw = new java.io.StringWriter();

              java.io.PrintWriter pw = new java.io.PrintWriter(sw);

              ex.printStackTrace(pw);

              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarModulos: " + sw.getBuffer ().toString());

              throw ex;

         } 

         finally {

         	try{

         		Q02bTablaBDQ021ES00obj.freeResourcesNotConnection();	

         	}

         	catch(Exception ex) {

         		if (tr.isTraceActive()) {

         			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarModulos: error liberando recursos");

         		}  

         	}  		

         	if (tr.isTraceActive()) {

         		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarModulos: saliendo");                

            }     	   

         }

     }//fin borrarModulos

     

     /**

      * Funcin que modifica los datos del mdulo pasado como parmetro en la BBDD

      * @param mdulo - Datos del mdulo a modificar

      * @throws Exception

      */

     public void modificarModulos(Q02bModulos modulo) throws Exception {



      	if (tr.isTraceActive()){

  		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarModulos: entrando");

      	}

      	//Se instancian los objetos necesarios.

      	Q02bTablaBDQ021ES00 Q02bTablaBDQ021ES00obj = null;    

         	 try

         	 {     

         	 	//se crea el objeto de tablasBD

        		Q02bTablaBDQ021ES00obj = new Q02bTablaBDQ021ES00(this.getConnection());

        		

        		//segmento tecnico

             	//Q02bTablaBDQ022AS00obj.setUser(this.getUser());

        		  		

        		rellenaDatosModulosModificar(modulo,Q02bTablaBDQ021ES00obj);

        		Q02bTablaBDQ021ES00obj.setQ021ET00_NI_WHERE(Integer.parseInt(modulo.getIdModulo()));

       		       		

        		//se realiza la update

        		Q02bTablaBDQ021ES00obj.update();

         	 }

         	 catch(Exception ex) {

         		java.io.StringWriter sw = new java.io.StringWriter();

         		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

         		ex.printStackTrace(pw);

         		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarModulos: " + sw.getBuffer ().toString());

              throw ex;

         	 }

         	 finally {     

         		 try {

         			 Q02bTablaBDQ021ES00obj.freeResourcesNotConnection();	

         		 }

         		 catch(Exception ex) {

         			 if (tr.isTraceActive()) {

         				 tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarModulos: error liberando recursos");

         			 }  

         		 }  		  

         		 if (tr.isTraceActive()) {

         			 	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarModulos: saliendo");                

                 }             

         	 }     

     } // fin modificarModulos

     

       

     /**

      * Funcin que activa el mdulo pasado como parmetro de la BBDD

      * @param idModulo - nmero interno del mdulo a borrar

      * @throws Exception

      */

     public void activarModulos(String idModulo) throws Exception {

      	if (tr.isTraceActive()){

      		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":activarModulos: entrando");

      	}

      	Q02bTablaBDQ021ES00 Q02bTablaBDQ021ES00obj = null;

        try{       	

        	//se crean los objetos necesarios

         	Q02bTablaBDQ021ES00obj = new Q02bTablaBDQ021ES00(this.getConnection());   

         	

        	// segmento tecnico

            Q02bTablaBDQ021ES00obj.setUser(this.getUser());

         	

         	//se pone el filtro para la delete

         	Q02bTablaBDQ021ES00obj.setQ021ET00_NI_WHERE(Integer.parseInt(idModulo));         	

         	Q02bTablaBDQ021ES00obj.setQ021ET00_IND_INACTIVO(new Integer(Q02bConstantes.REGISTRO_ACTIVO));

         	Q02bTablaBDQ021ES00obj.update();          	         	

         }

         catch(Exception ex)

         {

              java.io.StringWriter sw = new java.io.StringWriter();

              java.io.PrintWriter pw = new java.io.PrintWriter(sw);

              ex.printStackTrace(pw);

              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":activarModulos: " + sw.getBuffer ().toString());

              throw ex;

         } 

         finally {

         	try{

         		Q02bTablaBDQ021ES00obj.freeResourcesNotConnection();	

         	}

         	catch(Exception ex) {

         		if (tr.isTraceActive()) {

         			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":activarModulos: error liberando recursos");

         		}  

         	}  		

         	if (tr.isTraceActive()) {

         		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":activarModulos: saliendo");                

            }     	   

         }

     }//fin activarModulos

     

     /**

      * Funcin que desactiva el mdulo pasado como parmetro de la BBDD

      * @param idModulo - nmero interno del mdulo a borrar

      * @throws Exception

      */

     public void desactivarModulos(String idModulo) throws Exception {

      	if (tr.isTraceActive()){

      		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":desactivarModulos: entrando");

      	}

      	Q02bTablaBDQ021ES00 Q02bTablaBDQ021ES00obj = null;

        try{       	

        	//se crean los objetos necesarios

         	Q02bTablaBDQ021ES00obj = new Q02bTablaBDQ021ES00(this.getConnection());   

         	

        	// segmento tecnico

            Q02bTablaBDQ021ES00obj.setUser(this.getUser());

         	

         	//se pone el filtro para la delete

         	Q02bTablaBDQ021ES00obj.setQ021ET00_NI_WHERE(Integer.parseInt(idModulo));         	

         	Q02bTablaBDQ021ES00obj.setQ021ET00_IND_INACTIVO(new Integer(Q02bConstantes.REGISTRO_INACTIVO ));

         	Q02bTablaBDQ021ES00obj.update();          	         	

         }

         catch(Exception ex)

         {

              java.io.StringWriter sw = new java.io.StringWriter();

              java.io.PrintWriter pw = new java.io.PrintWriter(sw);

              ex.printStackTrace(pw);

              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":desactivarModulos: " + sw.getBuffer ().toString());

              throw ex;

         } 

         finally {

         	try{

         		Q02bTablaBDQ021ES00obj.freeResourcesNotConnection();	

         	}

         	catch(Exception ex) {

         		if (tr.isTraceActive()) {

         			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":desactivarModulos: error liberando recursos");

         		}  

         	}  		

         	if (tr.isTraceActive()) {

         		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":desactivarModulos: saliendo");                

            }     	   

         }

     }//fin activarModulos

     

     

}

