package q02b.exe.modulos.beans;



import java.util.ArrayList;



import q02b.exe.arquitectura.beans.Q02bBaseBean;

import q02b.exe.modulos.dataobjects.Q02bModulosDataBaseDAO;

import q02b.exe.modulos.valueobjects.Q02bModulos;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;



   

public class Q02bModulosBean extends Q02bBaseBean{

	private static final long serialVersionUID = 5474311672836163390L;

	protected Q02bModulosDataBaseDAO daoModulos = null;

	final static String	LISTA_PLAZOS = "listaModulos";

	

	/** Constructor vacio */

    public Q02bModulosBean() {

        super();

    }



    /**

     * Funcin que recupera los mdulos

     * @return listaModulos  -  Listado de mdulos obtenidos

     * @throws Exception

     */

	public ArrayList obtenerModulos(Q02bModulos filtroModulos) throws Exception 

	{

		 if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerModulos: entrando.");

	   		}  	  

		ArrayList listaModulos = new ArrayList();

		boolean error = false;

		

		try{

			//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoModulos = new Q02bModulosDataBaseDAO(this.getConn());				

			

			listaModulos = daoModulos.obtenerModulos(filtroModulos);

            return listaModulos;              

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter sw = new java.io.StringWriter();

          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerModulos: " + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoModulos.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerModulos: error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerModulos: saliendo.");

	   		}

 	  	}

 	  } //fin obtenerModulos 

	

	

	/**

     * Mtodo que dado el nmero interno del mdulo 

     * recupera de la BBDD los datos de dicho mdulo.

     * @param idModulo

     * @return Modulo

     */

	public Q02bModulos obtenerModulo(String idModulo)throws Exception{  	 

	    	boolean error = false;

	    	Q02bModulos modulo = null;

	  	  	try  	  {

	  	  		if (tr.isTraceActive()){

	  	  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerModulo, ** idModulo bean=" + idModulo + " *** entrando");                

	  	  		}

	  	  		

	  	  		//se abre la conexin

	  	  		abrirConexion();

	  	  		

	  	  		//se instancia el dao pasandole la conexin			

	  	  		daoModulos = new Q02bModulosDataBaseDAO(this.getConn());

	  	  		

	  	  		//Segmento tecnico 

	  			//daoPlazos.setUser(this.getAutenticador().getUser());

	  			//daoPlazos.setIdioma(this.getAutenticador().getIdioma());

	  			

	  	  		//se llama al mtodo del dao que recupera el plazo

	  	  		modulo = daoModulos.obtenerModulo(idModulo);

	  	  		

	  	  		//se devuelve el cuestionario recuperado

	  	  		return modulo;

	  	  }catch(Exception ex){

	  		  	error= true;

	  		  	java.io.StringWriter sw = new java.io.StringWriter();

	          	java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          	ex.printStackTrace(pw);

	          	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerModulo: " + sw.getBuffer ().toString());

	          	throw ex;                     

	 	  }finally{

	 		  	try{

	 		  		daoModulos.freeResourcesNotConnection();

	 		  	}catch(Exception ex){

				   if (tr.isTraceActive()){

					   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerModulo: error liberando recursos");

		   	   	   }  

	 		  	}  		 

	 		  	//se cierra la conexin  

	 		  	cerrarConexion(error);	       	

		        if (tr.isTraceActive()){

		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerModulo: saliendo.");

		   		}

	 	  }

	    }//fin obtenerModulo

	

	/**

     * Funcin que inserta los datos del mdulo pasado como parmetro en la BBDD

     * @param plazo - Datos del mdulo a insertar

     * @throws Exception

     */

      public void insertarModulos(Q02bModulos modulo) throws Exception {   	 

    	boolean error = false;

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarModulos: entrando");

      		}

	  		//se abre la conexin

			abrirConexion();

			

			//se instancia el dao pasandole la conexin			

			daoModulos = new Q02bModulosDataBaseDAO(this.getConn());

			

			//se pasan los parmetros de usuario e idioma

			daoModulos.setUser(this.autenticador.getUser());

			daoModulos.setIdioma(this.autenticador.getIdioma());

			

			//se llama la metodo del DAO que realiza la insert

			daoModulos.insertarModulos(modulo);

    	}catch(Exception ex){

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarModulos: " + sw.getBuffer ().toString());

	        throw ex;                     

 	  }finally{

 		    try{

 		    	daoModulos.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarModulos: error liberando recursos");

	   	   	   }  

 		    }  		 

 		  	//se cierra la conexin  

 		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarModulos: saliendo.");

	   		}

 	  }

    }//fin insertarModulos

      

      /**

       * Funcin que borra el mdulo pasado como parmetro de la BBDD 

       * @param idModulo - nmero interno del mdulo a borrar

       * @throws Exception

       */

    public void borrarModulos(String idModulo) throws Exception { 

    		if (tr.isTraceActive()){

  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarModulos: entrando");

    		}

    		boolean error = false;

    		try{

    			//se abre la conexin

    			abrirConexion();

   			

    			//se instancia el dao pasandole la conexin			

    			daoModulos = new Q02bModulosDataBaseDAO(this.getConn());

  			

    			//Segmento tecnico 

    			//daoPlazos.setUser(this.getAutenticador().getUser());

    			//daoPlazos.setIdioma(this.getAutenticador().getIdioma()); 



				daoModulos.borrarModulos(idModulo);   		 	  

    		}catch(Exception ex){

    			error= true;

    			java.io.StringWriter sw = new java.io.StringWriter();

    			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

    			ex.printStackTrace(pw);

    			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarModulos: " + sw.getBuffer ().toString());

    			throw ex;           

  	  

    		}finally{

    			try{

    				daoModulos.freeResourcesNotConnection();

    			}catch(Exception ex){

    				if (tr.isTraceActive()){

    					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarModulos: error liberando recursos");

  	   	   	   		}  

    			}  		 

   		  		//se cierra la conexin  

   		  		cerrarConexion(error);	       	

   		  		if (tr.isTraceActive()){

   		  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarModulos: saliendo.");

   		  		}

    		}

    }//fin borrarModulos

    

    /**

     * Funcin que modifica los datos del mdulo pasado como parmetro en la BBDD

     * @param mdulo - Datos del mdulo a modificar 

     * @throws Exception

     */

    public void modificarModulos(Q02bModulos modulo) throws Exception {

   	 if (tr.isTraceActive()){

  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarModulos: entrando");

  		}

   	 boolean error = false;

   	try{

   		//se abre la conexin

   		abrirConexion();

   		//se instancia el dao pasandole la conexin			

   		daoModulos = new Q02bModulosDataBaseDAO(this.getConn());

		

   		//Segmento tecnico 

		//daoPlazos.setUser(this.getAutenticador().getUser());

   		//daoPlazos.setIdioma(this.getAutenticador().getIdioma()); 



   		//se llamaa la metodo del DAO que realiza la update

   		daoModulos.modificarModulos(modulo);

   		    	

   	}catch(Exception ex){

		 error= true;

         java.io.StringWriter sw = new java.io.StringWriter();

         java.io.PrintWriter pw = new java.io.PrintWriter(sw);

         ex.printStackTrace(pw);

         tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarModulos: " + sw.getBuffer ().toString());

         throw ex;                     

	  }finally{

		 try{

			daoModulos.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarModulos: error liberando recursos");

	   	   	   }  

		   }  		 

		  	//se cierra la conexin  

		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarModulos: saliendo.");

	   		}

	  }

   }//modificarModulos

    

    

    /**

     * Funcin que activa el mdulo pasado como parmetro de la BBDD 

     * @param idModulo - nmero interno del mdulo a borrar

     * @throws Exception

     */

  public void activarModulos(String idModulo) throws Exception { 

  		if (tr.isTraceActive()){

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":activarModulos: entrando");

  		}

  		boolean error = false;

  		try{

  			//se abre la conexin

  			abrirConexion();

 			

  			//se instancia el dao pasandole la conexin			

  			daoModulos = new Q02bModulosDataBaseDAO(this.getConn());

			

  			//Segmento tecnico 

  			//daoPlazos.setUser(this.getAutenticador().getUser());

  			//daoPlazos.setIdioma(this.getAutenticador().getIdioma()); 



				daoModulos.activarModulos(idModulo);   		 	  

  		}catch(Exception ex){

  			error= true;

  			java.io.StringWriter sw = new java.io.StringWriter();

  			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

  			ex.printStackTrace(pw);

  			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":activarModulos: " + sw.getBuffer ().toString());

  			throw ex;           

	  

  		}finally{

  			try{

  				daoModulos.freeResourcesNotConnection();

  			}catch(Exception ex){

  				if (tr.isTraceActive()){

  					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":activarModulos: error liberando recursos");

	   	   	   		}  

  			}  		 

 		  		//se cierra la conexin  

 		  		cerrarConexion(error);	       	

 		  		if (tr.isTraceActive()){

 		  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":activarModulos: saliendo.");

 		  		}

  		}

  }//fin activarModulos

    

    

  /**

   * Funcin que desactiva el mdulo pasado como parmetro de la BBDD 

   * @param idModulo - nmero interno del mdulo a borrar

   * @throws Exception

   */

public void desactivarModulos(String idModulo) throws Exception { 

		if (tr.isTraceActive()){

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":desactivarModulos: entrando");

		}

		boolean error = false;

		try{

			//se abre la conexin

			abrirConexion();

			

			//se instancia el dao pasandole la conexin			

			daoModulos = new Q02bModulosDataBaseDAO(this.getConn());

			

			//Segmento tecnico 

			//daoPlazos.setUser(this.getAutenticador().getUser());

			//daoPlazos.setIdioma(this.getAutenticador().getIdioma()); 



				daoModulos.desactivarModulos(idModulo);   		 	  

		}catch(Exception ex){

			error= true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":desactivarModulos: " + sw.getBuffer ().toString());

			throw ex;           

	  

		}finally{

			try{

				daoModulos.freeResourcesNotConnection();

			}catch(Exception ex){

				if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":desactivarModulos: error liberando recursos");

	   	   	   		}  

			}  		 

		  		//se cierra la conexin  

		  		cerrarConexion(error);	       	

		  		if (tr.isTraceActive()){

		  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":desactivarModulos: saliendo.");

		  		}

		}

}//fin desactivarModulos

  

}