package q02b.exe.informantes.dataobjects;



import java.sql.Connection;

import java.sql.PreparedStatement;

import java.sql.ResultSet;

import java.util.ArrayList;



//import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

import q02b.exe.arquitectura.dataobjects.Q02bDataBaseDAO;

import q02b.exe.informantes.valueobjects.Q02bFiltroInformantes;

import q02b.exe.informantes.valueobjects.Q02bInformante;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022IS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022IS01V01;

//import q02b.exe.utils.Q02bConstantes;

import q02b.exe.utils.Q02bFormatData;



public class Q02bInformantesDataBaseDAO extends Q02bDataBaseDAO{



	private static final long serialVersionUID = -8520551641771839103L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "DAO_ACCESO_DATOS";

	

	public Q02bInformantesDataBaseDAO() {

        super();                

    }



    

    public Q02bInformantesDataBaseDAO(Connection conn) {

    	super(conn);     

    }

    

    

	    

	    /**

	     * Mtodo que devuelve el nmero de registros de la BBDD de la tabla de Informantes para una oficina concreta

	     * @return devuelve nmero de registros de la BBDD de la tabla de Informantes

	     * @throws Exception

	     */

	    public int getCountInformantes(Q02bFiltroInformantes filtroInformantesVO) throws Exception {    	    

	     	//se crean las objetos necesarios.

	     	int numReg = 0;

	     	ResultSet rs = null;       

	     	Q02bTablaBDQ022IS01V01 tabla022IS01V01 = null;	

	     	

	         try{

	         	if (tr.isTraceActive()){

	     			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCountInformantes: entrando");

	     		}

	         	//se instancia la clase del tablas bd a llamar pasandole la conexion        	

	         	tabla022IS01V01 = new Q02bTablaBDQ022IS01V01(this.getConnection());

	         	

	         	this.rellenaFiltroInformantes(filtroInformantesVO, tabla022IS01V01);

	         	

	         	//-----------------------------------------------------------------------------

	 	    	//ESTO HAY QUE QUITAR Y DESCOMENTAR LO ANTERIORRR; ESTO ES PARA PROBAR

	 	    	//-----------------------------------------------------------------------------

	 	    	//tablaQ022S00.setQ022IT00_ID_OFI_WHERE(1);

	 	    	//-----------------------------------------------------------------------------

	 	     	//se realiza la count

	         	rs = tabla022IS01V01.selectCount();       	

	         	tabla022IS01V01.addResultSet(rs);

	         	if (rs.next()){          		 

	         	 	 numReg =  rs.getInt(1);

	         	}

	         	return numReg;

	         }catch(Exception ex){

	             java.io.StringWriter sw = new java.io.StringWriter();

	             java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	             ex.printStackTrace(pw);

	             tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCountInformantes: " + sw.getBuffer ().toString());

	             throw ex;

	        }finally{

	     	   try{

	     		  tabla022IS01V01.freeResourcesNotConnection();	

	     	   }catch(Exception ex){

	 			   if (tr.isTraceActive()){

	 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCountInformantes: error liberando recursos");

	 	   	   	   }  

	 		   }  		

	     	   if (tr.isTraceActive()){

	     		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCountInformantes: saliendo");                

	            }           

	        }      

	     }//fin getCountInformantes()

    

	    /**

	     * Mtodo que devuelve un arraylist de objetos informante resultado de la consulta a bbdd

	     * @return listaInformantes - ArrayList arraylist de objetos informante

	     * @throws Exception

	     */

       public ArrayList getInformantes(Q02bFiltroInformantes filtroInformantesVO) throws Exception {		

	 		//se instancian los objetos necesarios para realizar la consulta.			

    	   	Q02bTablaBDQ022IS01V01 tabla022IS01V01 = null;

	 		ResultSet rs = null;

	 		ArrayList listaInformantes = new ArrayList();

	 		//Q02bInformante informanteVO;

	 		

	 		try{

	 	    	if (tr.isTraceActive()){

	 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getInformantes: entrando");

	 			}

	 	    	//se instancia la clase del tablas bd a llamar pasandole la conexion	    	

	 	    	tabla022IS01V01 = new Q02bTablaBDQ022IS01V01(this.getConnection());

	 	    

	 	    	this.rellenaFiltroInformantes(filtroInformantesVO, tabla022IS01V01);

	 	    	

	 	    	//se realiza la select

	 	    	rs = tabla022IS01V01.select();

	 	    	//aadimos el cursor para luego poder liberarlo (en el freeResources)

	 	    	tabla022IS01V01.addResultSet(rs); 

	 	    	//se trata el resultado obtenido aadiendolo a la lista de salida

	 	    	listaInformantes = this.rellenaVOsInformantes(rs);

	 	    	

	 	    	return listaInformantes;    	

	 		}catch(Exception ex){ 	   

	     		java.io.StringWriter sw = new java.io.StringWriter();

	     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	     		ex.printStackTrace(pw);

	     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getInformantes: " + sw.getBuffer ().toString());

	     		throw ex;

	 		}finally{

	 		 	try{

	 		 		//liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet

	 		 		tabla022IS01V01.freeResourcesNotConnection();	

	 			 }catch(Exception ex){

	 			    if (tr.isTraceActive()){

	 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getInformantes: error liberando recursos.");

	 	   	   	    }  

	 			 }  		 			

	 			 if (tr.isTraceActive()){

	 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getInformantes: saliendo.");                

	 	         }   

	 		}	

	 	}

       

       

       /**

	     * Mtodo que devuelve un objeto informante resultado de la consulta a bbdd

	     * @param  idInformante - String nmero interno del informante

	     * @return informanteVO - Q02bInformante Valueobject de informante con los datos del informante obtenido

	     * @throws Exception

	     */

       	public Q02bInformante getInformante(String idInformante) throws Exception {		

	 		//se instancian los objetos necesarios para realizar la consulta.			

       		Q02bTablaBDQ022IS01V01 tabla022IS01V01 = null;

	 		ResultSet rs = null;

	 		Q02bInformante informanteVO=null;

	 		

	 		try{

	 	    	if (tr.isTraceActive()){

	 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":Q02bInformante: entrando");

	 			}

	 	    	//se instancia la clase del tablas bd a llamar pasandole la conexion

	 	    	//se realiza la select

	 	    	tabla022IS01V01 = new Q02bTablaBDQ022IS01V01(this.getConnection());

	 	    	tabla022IS01V01.setQ022IT00_ID_INF_WHERE(Integer.parseInt(idInformante));

	 	    	rs = tabla022IS01V01.select();

	 	    	//aadimos el cursos para luego poder liberarlo ( en el freeResources)

	 	    	tabla022IS01V01.addResultSet(rs); 

	 	    	//se trata el resultado obtenido 

	 	    	informanteVO= new Q02bInformante();

	 	    	if(rs.next()){

	 	    		this.rellenarVOInformante(informanteVO, rs);
                }
	 	    	

	 	    	return informanteVO;    	

	 		}catch(Exception ex){ 	   

	     		java.io.StringWriter sw = new java.io.StringWriter();

	     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	     		ex.printStackTrace(pw);

	     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":Q02bInformante: " + sw.getBuffer ().toString());

	     		throw ex;

	 		}finally{

	 		 	try{

	 		 		//liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet

	 		 		tabla022IS01V01.freeResourcesNotConnection();	

	 			 }catch(Exception ex){

	 			    if (tr.isTraceActive()){

	 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":Q02bInformante: error liberando recursos.");

	 	   	   	    }  

	 			 }  		 			

	 			 if (tr.isTraceActive()){

	 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":Q02bInformante: saliendo.");                

	 	         }   

	 		}	

	 	}

    

       	

       	

        /**

	      * Mtodo que rellena el tablasBD con los datos del filtro de objeto que contiene

	      * los criterios de bsqueda introducidos por el usuario

	      * 

	      * @param filtroInformantesVO

	      * @param tablaBD

	      * 

	      * @throws Exception

	      */

	    public void rellenaFiltroInformantes(Q02bFiltroInformantes filtroInformantesVO, Q02bTablaBDQ022IS01V01 tabla022IS01V01)throws Exception

	    {

	     //Definicin de variables que no se van a modificar

	     final String TRACE_METODO = ":rellenaFiltroInformantes:";

	     StringBuffer additionalWhere=null;

	     

	    	try{

	    		if (tr.isTraceActive()){

			        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando");                

	    		} 

	    		if(filtroInformantesVO != null){

		    		additionalWhere = new StringBuffer();

		    		

		    		if(!Q02bFormatData.esNull(filtroInformantesVO.getDescripcion()).equals("")){

		    			additionalWhere = new StringBuffer(" AND TRANSLATE(UPPER(Q022HT00_DESC),'','AEIOUAEIOU') like '%' || ");

		    			additionalWhere.append("TRANSLATE(UPPER('").append(filtroInformantesVO.getDescripcion()).append("'),'','AEIOUAEIOU') || '%'");

		    		}

		    		if(!Q02bFormatData.esNull(filtroInformantesVO.getNombre()).equals("")){

		    			additionalWhere = new StringBuffer(" AND TRANSLATE(UPPER(Q022IT00_NOMB),'','AEIOUAEIOU') like '%' || ");

		    			additionalWhere.append("TRANSLATE(UPPER('").append(filtroInformantesVO.getNombre()).append("'),'','AEIOUAEIOU') || '%'");

		    		}

		    		if(!Q02bFormatData.esNull(filtroInformantesVO.getApellido1()).equals("")){

		    			additionalWhere = new StringBuffer(" AND TRANSLATE(UPPER(Q022IT00_APE1),'','AEIOUAEIOU') like '%' || ");

		    			additionalWhere.append("TRANSLATE(UPPER('").append(filtroInformantesVO.getApellido1()).append("'),'','AEIOUAEIOU') || '%'");

		    		}

		    	

		    		if(!Q02bFormatData.esNull(filtroInformantesVO.getIdOficina()).equals("")){

		    			tabla022IS01V01.setQ022IT00_ID_OFI_WHERE(Integer.parseInt(filtroInformantesVO.getIdOficina()));
                    }
		    		if(!Q02bFormatData.esNull(filtroInformantesVO.getCodProv()).equals("")){

		    			tabla022IS01V01.setQ022HT00_PROV_WHERE(filtroInformantesVO.getCodProv());
                    }
		    		if(!Q02bFormatData.esNull(filtroInformantesVO.getCodMuni()).equals("")){

		    			tabla022IS01V01.setQ022HT00_MUNI_WHERE(filtroInformantesVO.getCodMuni());
                    }
		    		if(!Q02bFormatData.esNull(filtroInformantesVO.getIndPrincipal()).equals("")){

		    			tabla022IS01V01.setQ022IT00_PRINCPL_WHERE(Integer.parseInt(filtroInformantesVO.getIndPrincipal()));
                    }
		    		

		    		if(!additionalWhere.toString().equals("")){

		    			tabla022IS01V01.setAditionalWhere(additionalWhere.toString());
                    }
		    		

		    		tabla022IS01V01.setOrderBy(" Q022IT00_APE1 ASC");

	    		}

		    }	    	

	    	catch(Exception ex){    	 	   

		       java.io.StringWriter sw = new java.io.StringWriter();

		       java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

		       ex.printStackTrace(pw);

		       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() 		+ TRACE_METODO + sw.getBuffer ().toString());

		       throw ex;

		}finally{			 	

			if (tr.isTraceActive()){

			        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() 	+ TRACE_METODO + " saliendo");                

			 }    				

		}

	    }//fin rellenaFiltroInformantes()

	    

	    

	    /**

	     * Mtodo que devuelve un arraylist de objetos informante resultado de la consulta a bbdd

	     * @param rs - ResultSet Resultado de la consulta a bbdd

	     * @return listaInformantes - ArrayList arraylist de objetos informante

	     * @throws Exception

	     */

	    private ArrayList rellenaVOsInformantes (ResultSet rs) throws Exception{

	     	Q02bInformante informanteVO;

	     	ArrayList listaInformantes = new ArrayList();

	     	try{

	     		if (tr.isTraceActive()){

	 		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOsInformantes: entrando");                

	 		    } 

	     		while (rs.next()){	 

	 	        	//se cargan en el objeto usuario los datos recuperados

	     			informanteVO = new Q02bInformante();

	     			rellenarVOInformante(informanteVO,rs);

	     			listaInformantes.add(informanteVO);

	   			}  	  

	     		return listaInformantes;

	     	}catch(Exception ex){    	 	   

	  	       java.io.StringWriter sw = new java.io.StringWriter();

	  	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	  	       ex.printStackTrace(pw);

	  	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaVOsInformantes: " + sw.getBuffer ().toString());

	  	       throw ex;

	  		}finally{			 	

	  			if (tr.isTraceActive()){

	  		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOsInformantes: saliendo");                

	  		    }    				

	  		}

	     } 

    

	    /**

	     * Mtodo que informa un valueobject de informante con los datos de informante obtenidos de la tabla de informantes

	     * @param informanteVO - Q02bInformante valueobject de informante que se va a informar

	     * @param rs - ResultSet Resultado de la consulta a bbdd

	     * @throws Exception

	     */

        private void rellenarVOInformante (Q02bInformante informanteVO, ResultSet rs) throws Exception

	    {

           	try{

			   	tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":rellenarVOUsuario: Hay Datos");

			   	

			   	String idiomaEs=q02b.exe.utils.Q02bConstantes.getString("idioma.es");

			   	

			   	informanteVO.setIdInformante(rs.getString(Q02bTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_ID_INF));

			   	informanteVO.setIdOficina(rs.getString(Q02bTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_ID_OFI));

			   	informanteVO.setNombre(rs.getString(Q02bTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_NOMB));

			   	informanteVO.setApellido1(rs.getString(Q02bTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_APE1));

			   	informanteVO.setApellido2(rs.getString(Q02bTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_APE2));

			   	informanteVO.setDni(rs.getString(Q02bTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_DNI));

			   	informanteVO.setTelefono1(rs.getString(Q02bTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_TELF1));

			   	informanteVO.setTelefono2(rs.getString(Q02bTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_TELF2));

			   	informanteVO.setFax(rs.getString(Q02bTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_FAX));

			   	informanteVO.setMail(rs.getString(Q02bTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_EMAIL));

			   	informanteVO.setCargo(rs.getString(Q02bTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_CARGO));

			   	informanteVO.setDepartamento(rs.getString(Q02bTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_DEPA));

			   	informanteVO.setFirma(rs.getString(Q02bTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_FELEC));

			   	informanteVO.setPrincipal(rs.getString(Q02bTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_PRINCPL));

			   	informanteVO.setDescProvincia(rs.getString(Q02bTablaBDQ022IS01V01.NOMCOLUMN_NORA_T17_PROVINCIA_DS));

			   	informanteVO.setDescMunicipio(rs.getString(Q02bTablaBDQ022IS01V01.NOMCOLUMN_NORA_T17_MUNICIPIO_DS));

			   	if(this.getIdioma().equals(idiomaEs)){

			   		informanteVO.setDescOficina(rs.getString(Q02bTablaBDQ022IS01V01.NOMCOLUMN_Q022HT00_DESC));
                }
			   	else{ informanteVO.setDescOficina(rs.getString(Q02bTablaBDQ022IS01V01.NOMCOLUMN_Q022HT00_DESC_EUS));}

			   	

			}

			catch (Exception e) {

			    if (tr.isTraceActive()){

			   	   	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenarVOUsuario: error "+ e.getMessage());

				}  

		    }  	

	    }

    

	    /**

	     * Mtodo que inserta un informante en la bbdd

	     * @param informanteVO - Q02bInformante valueobject de informante con los datos del informante

	     * @return idUsuario - String Nmero interno del informante

	     * @throws Exception

	     */

    	public String insertarInformante(Q02bInformante informanteVO) throws Exception {		

	 		

    		Q02bTablaBDQ022IS00 tablaQ022S00=null;

	    	int idInformante = 0;

	 		try{

	 			//StringBuffer data = new StringBuffer();

	 			

	 	    	if (tr.isTraceActive()){

	 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarInformante: entrando");

	 			}

	 	    	//se instancia la clase del tablas bd a llamar pasandole la conexion	    	

	 	    	tablaQ022S00 = new Q02bTablaBDQ022IS00(this.getConnection());

	 	    

	 	    	idInformante = dameSeqIdInformante(tablaQ022S00);

	 	    	

	 	    	tablaQ022S00.setQ022IT00_ID_INF(idInformante);

	 	    	tablaQ022S00.setQ022IT00_ID_OFI(Integer.parseInt(informanteVO.getIdOficina()));

	 	    	tablaQ022S00.setQ022IT00_NOMB(informanteVO.getNombre());

	 	    	tablaQ022S00.setQ022IT00_APE1(informanteVO.getApellido1());

	 	    	tablaQ022S00.setQ022IT00_APE2(informanteVO.getApellido2());

	 	    	tablaQ022S00.setQ022IT00_DNI(informanteVO.getDni());

	 	    	if(!Q02bFormatData.esNull(informanteVO.getTelefono1()).equals("")){

	 	    		tablaQ022S00.setQ022IT00_TELF1(Integer.parseInt(informanteVO.getTelefono1()));
                }
	 	    	if(!Q02bFormatData.esNull(informanteVO.getTelefono2()).equals("")){

	 	    		tablaQ022S00.setQ022IT00_TELF2(Integer.parseInt(informanteVO.getTelefono2()));
                }
	 	    	if(!Q02bFormatData.esNull(informanteVO.getFax()).equals("")){

	 	    		tablaQ022S00.setQ022IT00_FAX(Integer.parseInt(informanteVO.getFax()));
                }
	 	    	tablaQ022S00.setQ022IT00_CARGO(informanteVO.getCargo());

	 	    	tablaQ022S00.setQ022IT00_DEPA(informanteVO.getDepartamento());

	 	    	tablaQ022S00.setQ022IT00_EMAIL(informanteVO.getMail());

	 	    	if(!Q02bFormatData.esVacio(informanteVO.getFirma())){

	 	    		tablaQ022S00.setQ022IT00_FELEC(Integer.parseInt(informanteVO.getFirma()));
                }
	 	    	if(!Q02bFormatData.esVacio(informanteVO.getPrincipal())){

	 	    		tablaQ022S00.setQ022IT00_PRINCPL(Integer.parseInt(informanteVO.getPrincipal()));
                }
	 	    	tablaQ022S00.insert();

	 	    

	 	        return Integer.toString(idInformante);    	

	 		}catch(Exception ex){ 	   

	     		java.io.StringWriter sw = new java.io.StringWriter();

	     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	     		ex.printStackTrace(pw);

	     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarInformante: " + sw.getBuffer ().toString());

	     		throw ex;

	 		}finally{

	 		 	try{

	 		 		//liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet

	 		 		tablaQ022S00.freeResourcesNotConnection();	

	 			 }catch(Exception ex){

	 			    if (tr.isTraceActive()){

	 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarInformante: error liberando recursos.");

	 	   	   	    }  

	 			 }  		 			

	 			 if (tr.isTraceActive()){

	 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarInformante: saliendo.");                

	 	         }   

	 		}	

	 	}

	

    	/**

	     * Mtodo que modifica en la bbd el informante seleccionado en pantalla

	     * @param informanteVO - Q02bInformante valueobject de informante con los datos del informante

	     * @throws Exception

	     */

        public void modificarInformante(Q02bInformante informanteVO) throws Exception {		

	 		

        	Q02bTablaBDQ022IS00 tablaQ022S00=null;

	    	try{

	 			if (tr.isTraceActive()){

	 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarInformante: entrando");

	 			}

	 	    	//se instancia la clase del tablas bd a llamar pasandole la conexion	    	

	 			tablaQ022S00 = new Q02bTablaBDQ022IS00(this.getConnection());

	 	    

	 			tablaQ022S00.setQ022IT00_ID_OFI(Integer.parseInt(informanteVO.getIdOficina()));

	 			tablaQ022S00.setQ022IT00_NOMB(informanteVO.getNombre());

	 	    	tablaQ022S00.setQ022IT00_APE1(informanteVO.getApellido1());

	 	    	tablaQ022S00.setQ022IT00_APE2(informanteVO.getApellido2());

	 	    	tablaQ022S00.setQ022IT00_DNI(informanteVO.getDni());

	 	    	if(!Q02bFormatData.esNull(informanteVO.getTelefono1()).equals("")){

	 	    		tablaQ022S00.setQ022IT00_TELF1(Integer.parseInt(informanteVO.getTelefono1()));
                }
	 	    	if(!Q02bFormatData.esNull(informanteVO.getTelefono2()).equals("")){

	 	    		tablaQ022S00.setQ022IT00_TELF2(Integer.parseInt(informanteVO.getTelefono2()));
                }
	 	    	if(!Q02bFormatData.esNull(informanteVO.getFax()).equals("")){

	 	    		tablaQ022S00.setQ022IT00_FAX(Integer.parseInt(informanteVO.getFax()));
                }
	 	    	tablaQ022S00.setQ022IT00_CARGO(informanteVO.getCargo());

	 	    	tablaQ022S00.setQ022IT00_DEPA(informanteVO.getDepartamento());

	 	    	tablaQ022S00.setQ022IT00_EMAIL(informanteVO.getMail());

	 	    	if(!Q02bFormatData.esVacio(informanteVO.getFirma())){

	 	    		tablaQ022S00.setQ022IT00_FELEC(Integer.parseInt(informanteVO.getFirma()));
                }
	 	    	else{ tablaQ022S00.setQ022IT00_FELEC(null);}

	 	    	if(!Q02bFormatData.esVacio(informanteVO.getPrincipal())){

	 	    		tablaQ022S00.setQ022IT00_PRINCPL(Integer.parseInt(informanteVO.getPrincipal()));
                }
	 	    	else{ tablaQ022S00.setQ022IT00_PRINCPL(null);}

	 	    	tablaQ022S00.setQ022IT00_ID_INF_WHERE(Integer.parseInt(informanteVO.getIdInformante()));

		 		tablaQ022S00.update();

	 	    

	 	  }catch(Exception ex){ 	   

	     		java.io.StringWriter sw = new java.io.StringWriter();

	     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	     		ex.printStackTrace(pw);

	     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarInformante: " + sw.getBuffer ().toString());

	     		throw ex;

	 		}finally{

	 		 	try{

	 		 		//liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet

	 		 		tablaQ022S00.freeResourcesNotConnection();	

	 			 }catch(Exception ex){

	 			    if (tr.isTraceActive()){

	 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarInformante: error liberando recursos.");

	 	   	   	    }  

	 			 }  		 			

	 			 if (tr.isTraceActive()){

	 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarInformante: saliendo.");                

	 	         }   

	 		}	

	 	}

    

	    /**

	     * Mtodo que borra de la bbd el informante seleccionado en pantalla

	     * @param idInformante - String Nmero interno del informante

	     * @throws Exception

	     */

	    public void borrarInformante(String idInformante) throws Exception {		

			

	    	Q02bTablaBDQ022IS00 tablaQ022S00=null;

			try{

				

		    	if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarInformante: entrando");

				}

		    	//se instancia la clase del tablas bd a llamar pasandole la conexion	    	

		    	tablaQ022S00 = new Q02bTablaBDQ022IS00(this.getConnection());

		    

		    	tablaQ022S00.setQ022IT00_ID_INF_WHERE(Integer.parseInt(idInformante));

		    	tablaQ022S00.delete();

		    

		    }catch(Exception ex){ 	   

	 		java.io.StringWriter sw = new java.io.StringWriter();

	 		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	 		ex.printStackTrace(pw);

	 		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarInformante: " + sw.getBuffer ().toString());

	 		throw ex;

			}finally{

			 	try{

			 		//liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet

			 		tablaQ022S00.freeResourcesNotConnection();	

				 }catch(Exception ex){

				    if (tr.isTraceActive()){

					   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarInformante: error liberando recursos.");

		   	   	    }  

				 }  		 			

				 if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarInformante: saliendo.");                

		         }   

			}	

		}

	    

	    /**

	     * Mtodo que devuelve el siguiente nmero interno disponible (el mximo + 1) del informante

	     * @param tablaQ022S00 - Q02bTablaBDQ022FS00 tabla (de informantes) de la que se obtiene el nmero interno

	     * @return idInformante - int Nmero interno del informante 

	     * @throws Exception

	     */

	    private int dameSeqIdInformante(Q02bTablaBDQ022IS00 tablaQ022S00) throws Exception {

	   	 

	    	int idInformante=0;

	    	ResultSet rs = null;

	      	PreparedStatement prepStmt =null;	

	    	try{

		    	if (tr.isTraceActive()){

		    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameSeqIdInformante: entrando");

		    	}

	    		StringBuffer query = new StringBuffer(" SELECT Q022IQ00.NEXTVAL FROM DUAL ");

	         	prepStmt = this.getConnection().prepareStatement(query.toString());         	

	         	rs = prepStmt.executeQuery();

	         	tablaQ022S00.addResultSet(rs);

	         	tablaQ022S00.addStatement(prepStmt);        	

	         	if (rs.next()){

	         		idInformante = rs.getInt(1);

	         	}	         	

	         	return idInformante;

		     }catch(Exception ex){   	   

	    		java.io.StringWriter sw = new java.io.StringWriter();

	    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	    		ex.printStackTrace(pw);

	    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameSeqIdInformante: " + sw.getBuffer ().toString());

	    		throw ex;

	    	 }

	    }

}

