package q02b.exe.cuestionariosVTMAnu.dataobjects;



import java.sql.Connection;

import java.sql.PreparedStatement;

import java.sql.ResultSet;

import java.text.SimpleDateFormat;

import java.util.ArrayList;

import java.util.Calendar;

import java.util.Date;



import q02b.exe.arquitectura.dataobjects.Q02bDAOException;

import q02b.exe.arquitectura.dataobjects.Q02bDataBaseDAO;

//import q02b.exe.cuestionariosSMAnu.valueobjects.Q02bCuestionarioSMFiltro;

import q02b.exe.cuestionariosVTMAnu.valueobjects.Q02bCuestionarioVTMAnu;

import q02b.exe.cuestionariosVTMAnu.valueobjects.Q02bCuestionarioVTMAnuFiltro;

import q02b.exe.cuestionariosVTMAnu.valueobjects.Q02bCuestionarioVTMFiltro;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022BS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022CS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022DS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022DS01V02;

import q02b.exe.utils.Q02bConstantes;

import q02b.exe.utils.Q02bFormatData;

import q02b.exe.utils.oracle.Q02bBDUtilidades;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;







public class Q02bCuestionariosVTMAnuDataBaseDAO extends Q02bDataBaseDAO{

	private static final long serialVersionUID = -8520551641771839103L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "DAO_ACCESO_DATOS";

	private static final String RECURSOS_CUES_AYUN_MEN = "q02brecursosCuestionarios";



	public Q02bCuestionariosVTMAnuDataBaseDAO() {

        super();                

    }



    

    public Q02bCuestionariosVTMAnuDataBaseDAO(Connection conn) {

    	super(conn);     

    }

    

    public void cambiarComa(Q02bCuestionarioVTMAnu cuestionarioVTMAnu)

    {

    	

		if (cuestionarioVTMAnu.getPresupuesto()!=null){

			cuestionarioVTMAnu.setPresupuesto(cuestionarioVTMAnu.getPresupuesto().replace(',','.'));
        }
		if (cuestionarioVTMAnu.getPrecioMed()!=null){

			cuestionarioVTMAnu.setPrecioMed(cuestionarioVTMAnu.getPrecioMed().replace(',','.'));
        }
    }

    public void cambiarPunto(Q02bCuestionarioVTMAnu cuestionarioVTMAnu)

    {

    	

    	if (cuestionarioVTMAnu.getPresupuesto()!=null){

			cuestionarioVTMAnu.setPresupuesto(cuestionarioVTMAnu.getPresupuesto().replace('.',','));
        }
    	

    	if (cuestionarioVTMAnu.getPrecioMed()!=null){

			cuestionarioVTMAnu.setPrecioMed(cuestionarioVTMAnu.getPrecioMed().replace('.',','));
        }
    }

    

     /**

     * Mtodo que compone la where para hacer la consulta

     * @param 

     * @return where 

     * @throws Exception

     */

    /*public String componerFiltroCuestionarioVTMAnu() throws Exception {

    	StringBuffer where = new StringBuffer();

    	try{

    		if (tr.isTraceActive())

    		{

		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":componerFiltroCuestionarioVTMAnu: entrando");                

		} 

	    	where.append(Q02bTablaBDQ022DS00.NOMCOLUMN_Q022DT00_ID_CUES + " is not null" );    	

    		return where.toString();

    	}catch(Exception ex){    	 	   

	       java.io.StringWriter sw = new java.io.StringWriter();

	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	       ex.printStackTrace(pw);

	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":componerFiltroCuestionarioVTMAnu: " + sw.getBuffer ().toString());

	       throw ex;

		}finally{			 	

			if (tr.isTraceActive()){

		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":componerFiltroCuestionarioVTMAnu: saliendo");                

		    }    				

		}

    }*/

    

       

    private ArrayList rellenaVOsCuestionariosVTM ( ResultSet rs ) throws Exception{

    	Q02bCuestionarioVTMAnu cuestionarioVTM;

    	ArrayList listaCuestionariosVTM = new ArrayList();

    	try{

    		if (tr.isTraceActive()){

		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOsCuestionariosVTM: entrando");                

		    } 

    		while (rs.next()){	 

	        	//se cargan en el objeto cuestionario los datos recuperados

    			cuestionarioVTM = new Q02bCuestionarioVTMAnu();

    			rellenarVOCuestionarioVTMAnu(cuestionarioVTM,rs);

    			listaCuestionariosVTM.add(cuestionarioVTM);

			}  	  

    		return listaCuestionariosVTM;

    	}catch(Exception ex){    	 	   

 	       java.io.StringWriter sw = new java.io.StringWriter();

 	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);

 	       ex.printStackTrace(pw);

 	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaVOsCuestionariosVTM: " + sw.getBuffer ().toString());

 	       throw ex;

 		}finally{			 	

 			if (tr.isTraceActive()){

 		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOsCuestionariosVTM: saliendo");                

 		    }    				

 		}

    } 

    

    /**

     * Funcin que inserta los datos del cuestionarioVTMAnu pasada como parmetro en la BBDD

     * 

     * @param cuestionarioVTMAnu - Datos de la cuestionarioVTMAnu a insertar

     * 

     * @throws Exception

     */

    public void rellenaDatosCuestionarioVTMAnu( Q02bCuestionarioVTMAnu cuestionarioVTMAnu, Q02bTablaBDQ022DS00 tablaBDCuestionariosVTMAnu) throws Exception {

    	//se definen objetos necesarios.

    	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosCuestionarioVTMAnu: entrando");

	   	}         	         

     		//se aaden los datos

	    	tablaBDCuestionariosVTMAnu.setQ022BT00_ID_GRUPO(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnu.getNiGrupoCuesVTMAnu()));

	    	tablaBDCuestionariosVTMAnu.setQ022DT00_ID_CUES(Q02bFormatData.checkLongNull(cuestionarioVTMAnu.getNiCuesVTMAnu()));

	    	tablaBDCuestionariosVTMAnu.setQ022DT00_IDEN_LICEN(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getIdenLicen()));

	    	tablaBDCuestionariosVTMAnu.setQ022DT00_FEC_ENT(Q02bFormatData.parseDate(cuestionarioVTMAnu.getFecEnt()));

	    	tablaBDCuestionariosVTMAnu.setQ022DT00_ESTADO_LICEN(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getEstadoLicen()));

	    	tablaBDCuestionariosVTMAnu.setQ022DT00_CAUSA_BAJA(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getCausaBaja()));

	    	tablaBDCuestionariosVTMAnu.setQ022DT00_ENTI(Q02bFormatData.checkLongNull(cuestionarioVTMAnu.getEnti()));

	    	tablaBDCuestionariosVTMAnu.setQ022DT00_TVIA(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getTvia()));

	    	tablaBDCuestionariosVTMAnu.setQ022DT00_CALLE(Q02bFormatData.checkLongNull(cuestionarioVTMAnu.getCalle()));

	    	tablaBDCuestionariosVTMAnu.setQ022DT00_POR_CL_POR(Q02bFormatData.checkLongNull(cuestionarioVTMAnu.getPorClPor()));

	    	

	    	tablaBDCuestionariosVTMAnu.setQ022DT00_BLOQ(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getBloq()));	    	

	    	tablaBDCuestionariosVTMAnu.setQ022DT00_NUME(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnu.getNume()));

	    	tablaBDCuestionariosVTMAnu.setQ022DT00_BIS(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getBis()));

	    	tablaBDCuestionariosVTMAnu.setQ022DT00_CDIR(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getCdir()));

	    	

	    	tablaBDCuestionariosVTMAnu.setQ022DT00_RS_PROMO(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getRsPromo()));

	    	tablaBDCuestionariosVTMAnu.setQ022DT00_CIF_DNI(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getCifDni()));

	    	tablaBDCuestionariosVTMAnu.setQ022DT00_MUN_PROV(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getMunProv()));

	    	tablaBDCuestionariosVTMAnu.setQ022DT00_MUN_MUNI(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getMunMuni()));

	    	tablaBDCuestionariosVTMAnu.setQ022DT00_ENTI_PRO(Q02bFormatData.checkLongNull(cuestionarioVTMAnu.getEntiPro()));

			//tablaBDCuestionariosVTMAnu.setQ022DT00_FIRMADO((Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getFirmado()))==null?new Integer("0"):new Integer(cuestionarioVTMAnu.getFirmado()));

//comprobar regimen uso y guardarlo si es otro

			/*if (!cuestionarioVTMAnu.getRegUso().equals("")){

				if ((Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getRegUso()).equals(Q02bConstantes.getString("q02b.cuestionarios.VTMAnu.regOtro")))){

					tablaBDCuestionariosVTMAnu.setQ022DT00_OTRO_REGIMEN_USO(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getOtroRegUso()));

				}

				else{

					tablaBDCuestionariosVTMAnu.setQ022DT00_OTRO_REGIMEN_USO(Q02bFormatData.checkStringNull(""));

				}

			}*/

			tablaBDCuestionariosVTMAnu.setQ022DT00_TVIA_PRO(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getTviaPro()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_CALLE_PRO(Q02bFormatData.checkLongNull(cuestionarioVTMAnu.getCallePro()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_POR_CL_POR_PRO(Q02bFormatData.checkLongNull(cuestionarioVTMAnu.getPorClPorPro()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_BLOQ_PRO(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getBloqPro()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_NUME_PRO(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnu.getNumePro()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_BIS_PRO(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getBisPro()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_CDIR_PRO(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getCdirPro()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_TLF(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getTlf()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_MAIL(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getMail()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_FAX(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getFax()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_WEB(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getWeb()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_PRESUPUESTO(Q02bFormatData.checkDoubleNull(cuestionarioVTMAnu.getPresupuesto()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_F_INI(Q02bFormatData.parseDate(cuestionarioVTMAnu.getFIni()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_F_FIN(Q02bFormatData.parseDate(cuestionarioVTMAnu.getFFin()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_TIPO_OBRA(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getTipoObra()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_USO_RES(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getUsoRes()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_ACTIVIDAD(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getActividad()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_NVN(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnu.getNvn()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_NVR(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnu.getNvr()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_NVL(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnu.getNvl()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_NVVPO(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnu.getNvvpo()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_NVVS(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnu.getNvvs()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_NVPOT(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnu.getNvpot()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_NVALDOT(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnu.getNvaldot()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_NVREAL(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnu.getNvreal()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_NVVTMG(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnu.getNvvtmg()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_NVVTME(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnu.getNvvtme()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_NTOT(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnu.getNtot()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_NSP45(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnu.getNsp45()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_NSP75(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnu.getNsp75()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_NSP90(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnu.getNsp90()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_NSP120(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnu.getNsp120()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_NSPT(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnu.getNspt()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_PRINC_USO(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getPrincUso()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_PU_ESPECIF(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getPuEspecif()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_PRECIO_MED(Q02bFormatData.checkDoubleNull(cuestionarioVTMAnu.getPrecioMed()));

			tablaBDCuestionariosVTMAnu.setQ022DT00_OBS(Q02bFormatData.checkStringNull(cuestionarioVTMAnu.getObs()));

			

			

			

		

			



    	}catch(Exception ex){   	   

    		java.io.StringWriter sw = new java.io.StringWriter();

    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

    		ex.printStackTrace(pw);

    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaDatosCuestionarioVTMAnu: " + sw.getBuffer ().toString());

    		throw ex;

    	}finally{    		

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosCuestionarioVTMAnu: saliendo");                

           }       	

    	}	

    }  

    

	public ArrayList getSelectCuestionariosVTM(String niGrupoCuesVTM) throws Exception {		

		//se instancian los objetos necesarios para realizar la consulta.			

		Q02bTablaBDQ022DS01V02 vistaBDCuestionariosVTM = null;

		ResultSet rs = null;

		ArrayList listaCuestionariosVTM = new ArrayList();

		Q02bCuestionarioVTMAnu cuestionarioVTM;

		try{

	    	if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getSelectCuestionariosVTMAnu: entrando");

			}

	    	//se instancia la clase del tablas bd a llamar pasandole la conexion	    	

	    	vistaBDCuestionariosVTM = new Q02bTablaBDQ022DS01V02(this.getConnection());

	    	//rellenamos la where con los datos del filtro de usuarioTODO

	    	this.rellenaFiltroCuestionarioVTM(niGrupoCuesVTM, vistaBDCuestionariosVTM);	    	    	

	    	

	    	//se realiza la select

	    	rs = vistaBDCuestionariosVTM.select();

	    	

	    	//aadimos el cursos para luego poder liberarlo ( en el freeResources)

	    	vistaBDCuestionariosVTM.addResultSet(rs); 

	    	//se trata el resultado obtenido aadiendolo a la lista de salida

	    	listaCuestionariosVTM = this.rellenaVOsCuestionariosVTM(rs);

	    	for (int i=0; i < listaCuestionariosVTM.size(); i++)

	    	{

	    		cuestionarioVTM = (Q02bCuestionarioVTMAnu)listaCuestionariosVTM.get(i);	    			    		

    			this.cambiarPunto(cuestionarioVTM);	    			

    			listaCuestionariosVTM.set(i,cuestionarioVTM);	    		

	    	}

	    	return listaCuestionariosVTM;    	

		}catch(Exception ex){ 	   

    		java.io.StringWriter sw = new java.io.StringWriter();

    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

    		ex.printStackTrace(pw);

    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getSelectCuestionariosVTMAnu: " + sw.getBuffer ().toString());

    		throw ex;

		}finally{

		 	try{

		 		//liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet

		 		vistaBDCuestionariosVTM.freeResourcesNotConnection();	

			 }catch(Exception ex)

			 {

			    if (tr.isTraceActive())

			    {

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getSelectCuestionariosVTMAnu: error liberando recursos.");

	   	   	    }  

			 }  		 			

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getSelectCuestionariosVTMAnu: saliendo.");                

	         }   

		}	

	}

	/**

     * Mtodo que devuelve el nmero de registros de la BBDD de cuestionarios

     * 

     * 

     * 

     * @return devuelve nmero de registros de la BBDD de cuestionarios

     * 

     * @throws Exception

     */

    public int getCountCuestionariosVTM(String niGrupoCuesVTMAnu) throws Exception {    	    

    	//se crean las objetos necesarios.

    	int numReg = 0;

    	ResultSet rs = null;       

    	Q02bTablaBDQ022DS01V02 vistaBDCuestionariosVTM = null;	

        try{

        	if (tr.isTraceActive()){

    			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCountCuestionariosVTM: entrando");

    			

    		}

        	//se instancia la clase del tablas bd a llamar pasandole la conexion        	

        	vistaBDCuestionariosVTM = new Q02bTablaBDQ022DS01V02(this.getConnection());

                     //segmento tecnico

        	//tablaBDCuestionariosVTMAnu.setUser(this.getUser());

        	

        	//se carga el filtro de la where con los datos de entrada.TODO

        	this.rellenaFiltroCuestionarioVTM(niGrupoCuesVTMAnu,vistaBDCuestionariosVTM);        	

        	//se realiza la cout

        	rs = vistaBDCuestionariosVTM.selectCount();       	

        	

        	vistaBDCuestionariosVTM.addResultSet(rs);

        	//se recupera el resultado

        	if (rs.next()){          		 

        	 	 numReg =  rs.getInt(1);

        	}

        	return numReg;

        }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCountCuestionariosVTM: " + sw.getBuffer ().toString());

            throw ex;

       }finally{

    	   try{

    		   vistaBDCuestionariosVTM.freeResourcesNotConnection();	

    	   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCountCuestionariosVTM: error liberando recursos");

	   	   	   }  

		   }  		

    	   if (tr.isTraceActive()){

    		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCountCuestionariosVTM: saliendo");                

           }           

       }      

    }//fin getCountCuestionariosVTM()

    

    /**

	      * Mtodo que rellena el tablasBD con los datos del filtro de objeto que contiene

	      * el ni del objeto y el tipo de objeto

	      * 

	      * @param cuestionarioVTMAnuFiltro

	      * @param tablaBD

	      * 

	      * @throws Exception

	      */

	    public void rellenaFiltroCuestionarioVTM(String niGrupoCuesVTM,Q02bTablaBDQ022DS01V02 tablaBD)throws Exception

	    {

	     //Definicin de variables que no se van a modificar

	     final String TRACE_METODO = ":rellenaFiltroCuestionarioVTM:";

	    	try{

	    		if (tr.isTraceActive())

	    		{

			        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando");                

			} 

		    	/*if(cuestionarioVTMAnuFiltro!=null)

		    	{

		    		if (!Q02bFormatData.esVacio(cuestionarioVTMAnuFiltro.getCodProv())){

		    			tablaBD.setFCA02T00_CODPROVINC_WHERE(new Integer(cuestionarioVTMAnuFiltro.getCodProv()));

		    		}

		    		if (!Q02bFormatData.esVacio(cuestionarioVTMAnuFiltro.getCodMuni())){

		    			tablaBD.setFCA02T00_CODMUNICIP_WHERE(new Integer(cuestionarioVTMAnuFiltro.getCodMuni()));

		    		}

		    		if (!Q02bFormatData.esVacio(cuestionarioVTMAnuFiltro.getAno())){

		    			tablaBD.setQ022BT00_ANO_WHERE(new Integer(cuestionarioVTMAnuFiltro.getAno()));

		    		}*/

		    		if (!Q02bFormatData.esVacio(niGrupoCuesVTM)){

		    			tablaBD.setQ022BT00_ID_GRUPO_WHERE(new Integer(niGrupoCuesVTM));

		    		}	

		    		tablaBD.setOrderBy( "Q022DT00_ID_CUES DESC");

		    	//}	    	

	    	}catch(Exception ex)

	    	{    	 	   

		       java.io.StringWriter sw = new java.io.StringWriter();

		       java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);

		       ex.printStackTrace(pw);

		       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() 		+ TRACE_METODO + sw.getBuffer ().toString());

		       throw ex;

		}finally

		{			 	

			if (tr.isTraceActive())

			{

			        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() 	+ TRACE_METODO + " saliendo");                

			 }    				

		}

	    }//fin rellenaFiltroCuestionarioVTM()

    

       /**

      * Funcin que inserta los datos del cuestionario pasado como parmetro en la BBDD

      * 

      * @param cuestionarioVTMAnu - Datos de la cuestionario a insertar

      * 

      * @throws Exception

      */

     public String insertarCuestionarioVTMAnu(Q02bCuestionarioVTMAnu cuestionarioVTMAnu) throws Exception {

    	//se definen objetos necesarios.

    	int niCuestionarioVTMAnu=1;     	

       	Q02bTablaBDQ022DS00 tablaBDCuestionariosVTMAnu = null;

       	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioVTMAnu: entrando");

	   	}

    		//se crea el objeto de tablasBD

	    	tablaBDCuestionariosVTMAnu = new Q02bTablaBDQ022DS00(this.getConnection());

	    	

	    	this.cambiarComa(cuestionarioVTMAnu);

      		//primero recuperamos el nmero interno de contacto que le corresponde

	    	//-------------------------------------------------------------------------------------------------------------------------------------

	    	   	niCuestionarioVTMAnu = dameMaxNiCuesDeGrupo(cuestionarioVTMAnu.getNiGrupoCuesVTMAnu(),tablaBDCuestionariosVTMAnu);

	         	cuestionarioVTMAnu.setNiCuesVTMAnu(Integer.toString(niCuestionarioVTMAnu));   

	         	//tablaBDCuestionariosVTMAnu.reset();	         

	         	//----------------------------------------------------------------------         	

      		//se aaden los datos a insertar

         		this.rellenaDatosCuestionarioVTMAnu(cuestionarioVTMAnu, tablaBDCuestionariosVTMAnu);         	         

      		//se realiza la insert

      		tablaBDCuestionariosVTMAnu.insert();

      		//pediente de recuperar el numContacto

      		return cuestionarioVTMAnu.getNiCuesVTMAnu();

     	}

     	catch(Exception ex)

     	{   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarCuestionarioVTMAnu: " + sw.getBuffer ().toString());

     		throw ex;

     	}

     	finally

     	{

     		try

     		{

     			tablaBDCuestionariosVTMAnu.freeResourcesNotConnection();	

     		}

     		catch(Exception ex)

     		{

     			if (tr.isTraceActive())

     			{

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarCuestionarioVTMAnu: error liberando recursos");

 		   	   }  

 		}  		

		if (tr.isTraceActive())

		{

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioVTMAnu: saliendo");                

    		}       	

     	}

     }     

     

     

     /**

      * Funcin que borra el cuestionarioVTMAnu pasado como parmetro de la BBDD

      * 

      * @param niCuestionarioVTMAnu - nmero interno del cuestionarioVTMAnu a borrar

      * 

      * @throws Exception

      */

     public void borrarCuestionarioVTMAnu(String niCuestionarioVTMAnu,String niGrupoCuestionarioVTMAnu) throws Exception {

    	 

      	if (tr.isTraceActive())

      	{

  		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVTMAnu: entrando");

      	}

        

      	Q02bTablaBDQ022DS00 Q02bTablaBDQ022DS00obj = null;

        try{       	

        	//se crean los objetos necesarios

         	Q02bTablaBDQ022DS00obj = new Q02bTablaBDQ022DS00(this.getConnection());   

         	

        	// segmento tecnico

            //Q02bTablaBDQ022DS00obj.setUser(this.getUser());

         	

         	//se pone el filtro para la delete

         	Q02bTablaBDQ022DS00obj.setQ022DT00_ID_CUES_WHERE(Integer.parseInt(niCuestionarioVTMAnu));

         	Q02bTablaBDQ022DS00obj.setQ022BT00_ID_GRUPO_WHERE(Integer.parseInt(niGrupoCuestionarioVTMAnu));         	

         	

         	//se lanza el delete

          	Q02bTablaBDQ022DS00obj.delete();         	

         }

         catch(Exception ex)

         {

              java.io.StringWriter sw = new java.io.StringWriter();

              java.io.PrintWriter pw = new java.io.PrintWriter(sw);

              ex.printStackTrace(pw);

              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioVTMAnu: " + sw.getBuffer ().toString());

              throw ex;

         }finally

         {

         	try{

     		Q02bTablaBDQ022DS00obj.freeResourcesNotConnection();	

     	}

     	catch(Exception ex)

     	{

     		if (tr.isTraceActive())

     		{

     			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioVTMAnu: error liberando recursos");

     		}  

     	}  		

      	if (tr.isTraceActive())

      	{

      		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVTMAnu: saliendo");                

                     }     	   

         }

     }//fin borrarCuestionarioVTMAnu

     

     

     public void borrarGrupoCuestionarioVTMAnu(String niGrupoCuestionarioVTMAnu) throws Exception {



      	if (tr.isTraceActive())

        	{

    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarGrupoCuestionarioVTMAnu: entrando");

        	}

          	

        	//se crean los objetos necesarios

       	Q02bTablaBDQ022BS00 Q02bTablaBDQ022BS00obj = null;       

         try{       	

           	 //se crea el objeto de tablasBD

           	 Q02bTablaBDQ022BS00obj = new Q02bTablaBDQ022BS00(this.getConnection());

           

           	 // segmento tecnico

           	 //Q02bTablaBDQ022BS00obj.setUser(this.getUser());    	

           	

           	 //se pone el filtro para la delete

           	 Q02bTablaBDQ022BS00obj.setQ022BT00_ID_GRUPO_WHERE(Integer.parseInt(niGrupoCuestionarioVTMAnu));

            	

           	 //se lanza al delete

            	 Q02bTablaBDQ022BS00obj.delete();         	

           }

         catch(Exception ex)

           {

                java.io.StringWriter sw = new java.io.StringWriter();

                java.io.PrintWriter pw = new java.io.PrintWriter(sw);

                ex.printStackTrace(pw);

                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarGrupoCuestionarioVTMAnu: " + sw.getBuffer ().toString());

                throw ex;

           }

         finally

           {

           	try	{

           		Q02bTablaBDQ022BS00obj.freeResourcesNotConnection();	

           		}

           	catch(Exception ex)

           		{

           			if (tr.isTraceActive())

           				{

           				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarGrupoCuestionarioVTMAnu: error liberando recursos");

           				}  

           		}  		

           	if (tr.isTraceActive())

        			{

           			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarGrupoCuestionarioVTMAnu: saliendo");                

        			}     	   

           }

       }//fin borrarGrupoCuestionarioVTMAnu

     

     /**

      * Funcin que comprueba si un grupo de cuestionarios tiene cuestionariosVTMAnu asociados

      * 

      * @param niGrupoCuestionarioVTMAnu - nmero interno del grupo de cuestionarios a comprobar

      * @return true si tiene cuestionarios, false si no los tiene

      * @throws Exception

      */

     public boolean tieneCuestionariosVTMAnu(String niGrupoCuestionarioVTMAnu) throws Exception {



    	 

      	if (tr.isTraceActive())

      	{

  		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":tieneCuestionariosVTMAnu: entrando");

      	}

        java.sql.ResultSet rs = null;

        boolean retorno = false;

      	//se crean los objetos necesarios

     	Q02bTablaBDQ022DS00 Q02bTablaBDQ022DS00obj = null;       

          try{       	        	  

         	 //se crea el objeto de tablasBD

        	  Q02bTablaBDQ022DS00obj = new Q02bTablaBDQ022DS00(this.getConnection());    

         	//se pone el filtro para la select

        	  Q02bTablaBDQ022DS00obj.setQ022BT00_ID_GRUPO_WHERE(Integer.parseInt(niGrupoCuestionarioVTMAnu));        	  

         	

         	//se lanza la select

         	rs=Q02bTablaBDQ022DS00obj.select();

         	if(rs.next()){         		

         		retorno=true;

         	}

         	return retorno;

         }

         catch(Exception ex)

         {

              java.io.StringWriter sw = new java.io.StringWriter();

              java.io.PrintWriter pw = new java.io.PrintWriter(sw);

              ex.printStackTrace(pw);

              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":tieneCuestionariosVTMAnu: " + sw.getBuffer ().toString());

              throw ex;

         }finally

         {

         	try{

         		Q02bTablaBDQ022DS00obj.freeResourcesNotConnection();	

     	}

     	catch(Exception ex)

     	{

     		if (tr.isTraceActive())

     		{

     			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":tieneCuestionariosVTMAnu: error liberando recursos");

     		}  

     	}  		

      	if (tr.isTraceActive())

      	{

      		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":tieneCuestionariosVTMAnu: saliendo");                

                     }     	   

         }

     }//fin tieneCuestionariosVTMAnu



     /**

      * Funcin que modifica los datos del cuestionarioVTMAnu pasado como parmetro en la BBDD

      * 

      * @param cuestionarioVTMAnu - Datos de cuestionarioVTMAnu a modificar

      * 

      * @throws Exception

      */

     public void modificarCuestionarioVTMAnu(Q02bCuestionarioVTMAnu cuestionarioVTMAnu) throws Exception {



      	if (tr.isTraceActive()){

  		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVTMAnu: entrando");

  	}

      	//Se isntancian los objetos necesarios.

      	Q02bTablaBDQ022DS00 Q02bTablaBDQ022DS00obj = null;    

         	 try

         	 {     

         	 	//se crea el objeto de tablasBD

        		Q02bTablaBDQ022DS00obj = new Q02bTablaBDQ022DS00(this.getConnection());

        		//segmento tecnico

             		//Q02bTablaBDQ022DS00obj.setUser(this.getUser());

        		this.cambiarComa(cuestionarioVTMAnu);

        		

  		

        		rellenaDatosCuestionarioVTMAnu(cuestionarioVTMAnu,Q02bTablaBDQ022DS00obj);

       		Q02bTablaBDQ022DS00obj.setQ022DT00_ID_CUES_WHERE(Long.parseLong(cuestionarioVTMAnu.getNiCuesVTMAnu()));

       		Q02bTablaBDQ022DS00obj.setQ022BT00_ID_GRUPO_WHERE(Integer.parseInt(cuestionarioVTMAnu.getNiGrupoCuesVTMAnu()));



       		

       		//se realiza la update

       		Q02bTablaBDQ022DS00obj.update();

       		

         }

         catch(Exception ex)

         {

              java.io.StringWriter sw = new java.io.StringWriter();

              java.io.PrintWriter pw = new java.io.PrintWriter(sw);

              ex.printStackTrace(pw);

              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVTMAnu: " + sw.getBuffer ().toString());

              throw ex;

         }

         finally

         {     

         	try

         	{

    		Q02bTablaBDQ022DS00obj.freeResourcesNotConnection();	

    	}

    	catch(Exception ex)

    	{

		   if (tr.isTraceActive())

		   {

			   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVTMAnu: error liberando recursos");

   	   	   }  

    	}  		  

      	if (tr.isTraceActive())

      	{

      		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVTMAnu: saliendo");                

                      }             

         }     

     } // fin modificarCuestionarioVTMAnu



    

     /**

      * Mtodo que dado el nmero interno del cuestionarioVTMAnu recuperar de la BBDD

      * los datos de dicho cuestionarioVTMAnu.

      * @param niCuestionarioVTMAnu

      * @return

      */

     public Q02bCuestionarioVTMAnu obtenerCuestionarioVTMAnu(String niCuestionarioVTMAnu,String niGrupoCuestionarioVTMAnu)throws Exception

     {

   	  if (tr.isTraceActive()){

  		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVTMAnu , ** dao niCuestionarioVTMAnu= "+  niCuestionarioVTMAnu + ", niGrupoCuestionarioVTMAnu=" + niGrupoCuestionarioVTMAnu +"  ** entrando");            

         	}

   	  

   	  //se crean los objetos necesarios para ralizar la select.

   	  Q02bTablaBDQ022DS00 Q02bTablaBDQ022DS00obj = null;

   	  Q02bCuestionarioVTMAnu cuestionarioVTMAnuBD = null;

   	  ResultSet rs = null;   	  

         try{ 

           if (niCuestionarioVTMAnu!=null){           

           	Q02bTablaBDQ022DS00obj = new Q02bTablaBDQ022DS00(this.getConnection());

           	//se pone el filtro

           	

           	Q02bTablaBDQ022DS00obj.setQ022DT00_ID_CUES_WHERE(new Long(niCuestionarioVTMAnu));

           	Q02bTablaBDQ022DS00obj.setQ022BT00_ID_GRUPO_WHERE(new Integer(niGrupoCuestionarioVTMAnu));

         

           	rs = Q02bTablaBDQ022DS00obj.select();

           	Q02bTablaBDQ022DS00obj.addResultSet(rs); 

           	cuestionarioVTMAnuBD = tratarRs(rs);

        	cambiarPunto(cuestionarioVTMAnuBD);

           	

           }  

           return cuestionarioVTMAnuBD;

           

           }catch(Exception ex){           	   

                  java.io.StringWriter sw = new java.io.StringWriter();

                  java.io.PrintWriter pw = new java.io.PrintWriter(sw);

                  ex.printStackTrace(pw);

                  tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioVTMAnu: " + sw.getBuffer ().toString());

                  throw ex;

           }finally{

        	   try{

   	   			 Q02bTablaBDQ022DS00obj.freeResourcesNotConnection();	

   				}catch(Exception ex){

   	   			if (tr.isTraceActive()){

   	   				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioVTMAnu: error liberando recursos");

   	   		   	   }  

   				}  	

            	  if (tr.isTraceActive()){

            		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVTMAnu: saliendo");                

                 }            	 

           }	  

           

     }//fin obtenerCuestionarioVTMAnu





     private Q02bCuestionarioVTMAnu  tratarRs (ResultSet rs) throws Exception

     {

   	  

	  tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":tratarRs: entrando");           

	  Q02bCuestionarioVTMAnu cuestionarioVTMAnuBD = new Q02bCuestionarioVTMAnu();     

   	  if (rs.next())

   	  {	 

   		 tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":tratarRs: Hay registro");                

   		 try{

        		 	rellenarVOCuestionarioVTMAnu(cuestionarioVTMAnuBD,rs);

         		}catch (Exception e) {

	    		  if (tr.isTraceActive()){

	   	   		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":tratarRs: error "+ e.getMessage());

	   	   	}  

         		}  	

	}

	return cuestionarioVTMAnuBD;

     } 

     

     private void rellenarVOCuestionarioVTMAnu (Q02bCuestionarioVTMAnu cuestionarioVTMAnuBD, ResultSet rs) throws Exception

     {

     	try{

	     	tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":rellenarVOCuestionarioVTMAnu: Hay Datos");            

	     	cuestionarioVTMAnuBD.setNiGrupoCuesVTMAnu(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022BT00_ID_GRUPO));

	     	cuestionarioVTMAnuBD.setNiCuesVTMAnu(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_ID_CUES));

			cuestionarioVTMAnuBD.setIdenLicen(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_IDEN_LICEN));			

			cuestionarioVTMAnuBD.setFecEnt(Q02bFormatData.formatearFecha( Q02bFormatData.checkStringNull( rs.getString( Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_FEC_ENT)), Q02bConstantes.FORMATO_FECHA_FORMAT_DATA, this.getIdioma()));

			cuestionarioVTMAnuBD.setEstadoLicen(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_ESTADO_LICEN));

			cuestionarioVTMAnuBD.setCausaBaja(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_CAUSA_BAJA));

			cuestionarioVTMAnuBD.setEnti(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_ENTI));

			cuestionarioVTMAnuBD.setTvia(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_TVIA));

			cuestionarioVTMAnuBD.setCalle(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_CALLE));

			cuestionarioVTMAnuBD.setPorClPor(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_POR_CL_POR));

			cuestionarioVTMAnuBD.setBloq(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_BLOQ));

			cuestionarioVTMAnuBD.setNume(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NUME));

			cuestionarioVTMAnuBD.setBis(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_BIS));

			cuestionarioVTMAnuBD.setCdir(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_CDIR));

			cuestionarioVTMAnuBD.setRsPromo(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_RS_PROMO));

			cuestionarioVTMAnuBD.setCifDni(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_CIF_DNI));

			cuestionarioVTMAnuBD.setMunProv(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_MUN_PROV));

			cuestionarioVTMAnuBD.setMunMuni(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_MUN_MUNI));

			cuestionarioVTMAnuBD.setEntiPro(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_ENTI_PRO));

			cuestionarioVTMAnuBD.setTviaPro(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_TVIA_PRO));

			cuestionarioVTMAnuBD.setCallePro(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_CALLE_PRO));

			cuestionarioVTMAnuBD.setPorClPorPro(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_POR_CL_POR_PRO));

			cuestionarioVTMAnuBD.setBloqPro(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_BLOQ_PRO));

			cuestionarioVTMAnuBD.setNumePro(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NUME_PRO));

			cuestionarioVTMAnuBD.setBisPro(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_BIS_PRO));

			cuestionarioVTMAnuBD.setCdirPro(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_CDIR_PRO));

			cuestionarioVTMAnuBD.setTlf(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_TLF));

			cuestionarioVTMAnuBD.setMail(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_MAIL));

			cuestionarioVTMAnuBD.setFax(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_FAX));

			cuestionarioVTMAnuBD.setWeb(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_WEB));

			cuestionarioVTMAnuBD.setPresupuesto(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_PRESUPUESTO));

			cuestionarioVTMAnuBD.setFIni(Q02bFormatData.formatearFecha( Q02bFormatData.checkStringNull( rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_F_INI)),Q02bConstantes.FORMATO_FECHA_FORMAT_DATA, this.getIdioma()));

			cuestionarioVTMAnuBD.setFFin(Q02bFormatData.formatearFecha( Q02bFormatData.checkStringNull( rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_F_FIN)),Q02bConstantes.FORMATO_FECHA_FORMAT_DATA, this.getIdioma()));

			cuestionarioVTMAnuBD.setTipoObra(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_TIPO_OBRA));

			cuestionarioVTMAnuBD.setUsoRes(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_USO_RES));

			cuestionarioVTMAnuBD.setActividad(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_ACTIVIDAD));

			cuestionarioVTMAnuBD.setNvn(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NVN));

			cuestionarioVTMAnuBD.setNvr(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NVR));

			cuestionarioVTMAnuBD.setNvl(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NVL));

			cuestionarioVTMAnuBD.setNvvpo(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NVVPO));

			cuestionarioVTMAnuBD.setNvvs(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NVVS));

			cuestionarioVTMAnuBD.setNvpot(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NVPOT));

			cuestionarioVTMAnuBD.setNvaldot(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NVALDOT));

			cuestionarioVTMAnuBD.setNvreal(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NVREAL));

			cuestionarioVTMAnuBD.setNvvtmg(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NVVTMG));

			cuestionarioVTMAnuBD.setNvvtme(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NVVTME));

			cuestionarioVTMAnuBD.setNtot(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NTOT));

			cuestionarioVTMAnuBD.setNsp45(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NSP45));

			cuestionarioVTMAnuBD.setNsp75(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NSP75));

			cuestionarioVTMAnuBD.setNsp90(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NSP90));

			cuestionarioVTMAnuBD.setNsp120(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NSP120));

			cuestionarioVTMAnuBD.setNspt(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NSPT));

			cuestionarioVTMAnuBD.setPrincUso(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_PRINC_USO));

			cuestionarioVTMAnuBD.setPuEspecif(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_PU_ESPECIF));

			cuestionarioVTMAnuBD.setPrecioMed(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_PRECIO_MED));

			cuestionarioVTMAnuBD.setObs(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_OBS));

			cuestionarioVTMAnuBD.setLocalizacionObra(rs.getString(Q02bTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NORA_T17_LOCALIZACION));

	}

	catch (Exception e) 

	{

	    	if (tr.isTraceActive())

	    	{

	   	   	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenarVOCuestionarioVTMAnu: error "+ e.getMessage());

		}  

         	}  	

     }

     

      /**

      * Funcin que comprueba si para el municipio y ao hay algn registro en la tabla de Grupos de 

      * 

      * @param cuestionarioVTMAnu - Datos de la cuestionario a insertar

      * 

      * @throws Exception

      */

     public String altaModifGrupoCuestionariosVTMAnu(Q02bCuestionarioVTMAnuFiltro cuestionarioVTMAnuFiltro) throws Exception {

    	//se definen objetos necesarios. 	

    	 Q02bTablaBDQ022BS00 tablaBDGrupoCuestionariosVTMAnu = null;

       	//Q02bCuestionarioVTMAnuFiltro grupoCuestionarioVTMAnuBD = null;

       	String niGrupoCuesVTMAnu= null;

       	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVTMAnu: entrando");

	   	}

    		//se crea el objeto de tablasBD

	    	tablaBDGrupoCuestionariosVTMAnu = new Q02bTablaBDQ022BS00(this.getConnection());

      		this.obtenerGrupoCuestionariosVTMAnu(cuestionarioVTMAnuFiltro,tablaBDGrupoCuestionariosVTMAnu);

      		niGrupoCuesVTMAnu =cuestionarioVTMAnuFiltro.getNiGrupoCuesVTMAnu();

      		return niGrupoCuesVTMAnu;

     	}

     	catch(Exception ex)

     	{   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosVTMAnu: " + sw.getBuffer ().toString());

     		throw ex;

     	}

     	finally

     	{

     		try

     		{

     			tablaBDGrupoCuestionariosVTMAnu.freeResourcesNotConnection();	

     		}

     		catch(Exception ex)

     		{

     			if (tr.isTraceActive())

     			{

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosVTMAnu: error liberando recursos");

 		   	 }  

 		}  		

		if (tr.isTraceActive())

		{

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVTMAnu: saliendo");                

    		}       	

     	}

     }

     

      private void obtenerGrupoCuestionariosVTMAnu(Q02bCuestionarioVTMAnuFiltro cuestionarioVTMAnuFiltro,Q02bTablaBDQ022BS00 tablaBDGrupoCuestionariosVTMAnu) throws Exception 

     {

     	

     	ResultSet rs = null;

     	String niGrupoCuestionariosVTMAnu=null;

     	//String realizaActuacionBD=null;

     	//String realizaActuacion=null;

     	//boolean hayCuestionarios = false;

     	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGrupoCuestionariosVTMAnu: entrando");

	   	}

	   	tablaBDGrupoCuestionariosVTMAnu.setFCA02T00_CODPROVINC_WHERE(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnuFiltro.getCodProv()));

	   	tablaBDGrupoCuestionariosVTMAnu.setFCA02T00_CODMUNICIP_WHERE(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnuFiltro.getCodMuni()));

	   	tablaBDGrupoCuestionariosVTMAnu.setQ022BT00_ANO_WHERE(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnuFiltro.getAno()));

	   

		//if(!Q02bFormatData.esNullSinCero(cuestionarioVTMAnuFiltro.getModificarConcedidoLicen()).equals("1"))	

			tablaBDGrupoCuestionariosVTMAnu.setQ022BT00_MES_WHERE(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnuFiltro.getMes()));

	   

	   	

		rs=tablaBDGrupoCuestionariosVTMAnu.select();

	   	tablaBDGrupoCuestionariosVTMAnu.addResultSet(rs);

	   	if(rs.next())

	   	{

	   		//Si existe, se comprueba si el campo aplica tiene el mismo valor

	   		niGrupoCuestionariosVTMAnu =rs.getString(tablaBDGrupoCuestionariosVTMAnu.NOMCOLUMN_Q022BT00_ID_GRUPO);

	   		cuestionarioVTMAnuFiltro.setNiGrupoCuesVTMAnu(niGrupoCuestionariosVTMAnu);

	   		/*realizaActuacionBD= Q02bFormatData.esNull(rs.getString(tablaBDGrupoCuestionariosVTMAnu.NOMCOLUMN_Q022BT00_CONCEDIDO_LICEN));

	   		realizaActuacion = Q02bFormatData.esNull(cuestionarioVTMAnuFiltro.getRealizaActuacion());

	   		hayCuestionarios = this.obtenerNumCuestionarios(cuestionarioVTMAnuFiltro.getCodProv(),cuestionarioVTMAnuFiltro.getCodMuni(),cuestionarioVTMAnuFiltro.getAno(),cuestionarioVTMAnuFiltro.getMes());

			if(!realizaActuacionBD.equals(realizaActuacion) && !hayCuestionarios)

	   		{

	   			//Si en el Filtro se ha puesto que se realizan actuaciones, significaba que antes no, con lo que hay que modificar el registro en BD

	   			//Si antes si se realizaban y ahora no, se modifica tb el registro, y se anulan los cuestionarios de ese grupo mediante un trigger

	   			this.modificarLicenciaGrupoCuestionarioVTMAnu(cuestionarioVTMAnuFiltro,tablaBDGrupoCuestionariosVTMAnu);

	   		}*/

	   		

		}

		else

		{

			//Si no existe el grupo se da de alta

			niGrupoCuestionariosVTMAnu = this.insertarGrupoCuestionarioVTMAnu(cuestionarioVTMAnuFiltro,tablaBDGrupoCuestionariosVTMAnu);

			cuestionarioVTMAnuFiltro.setNiGrupoCuesVTMAnu(niGrupoCuestionariosVTMAnu);

		}

	        }

	        catch(Exception ex)

     	        {   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGrupoCuestionariosVTMAnu: " + sw.getBuffer ().toString());

     		throw ex;

     	      }

     }     

     

     public String insertarGrupoCuestionarioVTMAnu(Q02bCuestionarioVTMAnuFiltro cuestionarioVTMAnuFiltro,Q02bTablaBDQ022BS00 tablaBDGrupoCuestionariosVTMAnu) throws Exception {

    	//se definen objetos necesarios.

    	int niGrupoCuestionarioVTMAnu=1;     	

       	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarGrupoCuestionarioVTMAnu: entrando");

	   	}

	    	niGrupoCuestionarioVTMAnu = this.dameSeqNiDeGrupo(tablaBDGrupoCuestionariosVTMAnu);

	         	cuestionarioVTMAnuFiltro.setNiGrupoCuesVTMAnu(Integer.toString(niGrupoCuestionarioVTMAnu));   

	         	//tablaBDGrupoCuestionariosVTMAnu.reset();	         

	         	//----------------------------------------------------------------------         	

      		//se aaden los datos a insertar

         		this.rellenaDatosGrupoCuestionarioVTMAnu(cuestionarioVTMAnuFiltro, tablaBDGrupoCuestionariosVTMAnu);         	         

      		//se realiza la insert

      		tablaBDGrupoCuestionariosVTMAnu.insert();

      		//pediente de recuperar el numContacto

      		return cuestionarioVTMAnuFiltro.getNiGrupoCuesVTMAnu();

     	}

     	catch(Exception ex)

     	{   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarGrupoCuestionarioVTMAnu: " + sw.getBuffer ().toString());

     		throw ex;

     	}

   

     }

     

     public void  modificarLicenciaGrupoCuestionarioVTMAnu(Q02bCuestionarioVTMAnuFiltro cuestionarioVTMAnuFiltro,Q02bTablaBDQ022BS00 tablaBDGrupoCuestionariosVTMAnu) throws Exception {		

		try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarLicenciaGrupoCuestionarioVTMAnu: entrando");

	   	}

	   		//realizaActuacion = cuestionarioVTMAnuFiltro.getRealizaActuacion();

			tablaBDGrupoCuestionariosVTMAnu.setQ022BT00_ID_GRUPO_WHERE(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnuFiltro.getNiGrupoCuesVTMAnu()));

			tablaBDGrupoCuestionariosVTMAnu.setQ022BT00_CONCEDIDO_LICEN(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnuFiltro.getRealizaActuacion()));

			//tablaBDGrupoCuestionariosVTMAnu.setQ022CT00_REALIZA_ACTUACION(new Integer(realizaActuacion));

			tablaBDGrupoCuestionariosVTMAnu.update();



     	}

     	catch(Exception ex)

     	{   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarLicenciaGrupoCuestionarioVTMAnu: " + sw.getBuffer ().toString());

     		throw ex;

     	}

   

     }

     

     private int dameSeqNiDeGrupo(Q02bTablaBDQ022BS00 tablaBDGrupoCuestionariosVTMAnu) throws Exception 

     {

     	int niGrupoCuestionarioVTMAnu=1;

     	ResultSet rs = null;

       	PreparedStatement prepStmt =null;	

     	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameSeqNiDeGrupo: entrando");

	   	}

	   	

	   	StringBuffer query = new StringBuffer(" SELECT Q022BQ00.NEXTVAL FROM DUAL ");

	         	prepStmt = this.getConnection().prepareStatement(query.toString());         	

	         	rs = prepStmt.executeQuery();

	         	tablaBDGrupoCuestionariosVTMAnu.addResultSet(rs);

	         	tablaBDGrupoCuestionariosVTMAnu.addStatement(prepStmt);        	

	         	if (rs.next()){

	         		niGrupoCuestionarioVTMAnu = rs.getInt(1);

	         	}

	         	return niGrupoCuestionarioVTMAnu;

	        }

	        catch(Exception ex)

     	        {   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameSeqNiDeGrupo: " + sw.getBuffer ().toString());

     		throw ex;

     	      }

     }     

     

     private int dameMaxNiCuesDeGrupo(String niGrupoCuestionarioVTMAnu,Q02bTablaBDQ022DS00 tablaBDCuestionariosVTMAnu) throws Exception 

     {

     	int niCuestionarioVTMAnu=1;

     	ResultSet rs = null;	

     	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameMaxNiCuesDeGrupo: entrando");

	   	}

	   	

	   	tablaBDCuestionariosVTMAnu.setMax(tablaBDCuestionariosVTMAnu.NOMCOLUMN_Q022DT00_ID_CUES);

	   	

	         	tablaBDCuestionariosVTMAnu.setQ022BT00_ID_GRUPO_WHERE(new Integer(niGrupoCuestionarioVTMAnu));

	         	rs = tablaBDCuestionariosVTMAnu.selectMax();

	         	

	         	tablaBDCuestionariosVTMAnu.addResultSet(rs);     	

	         	if (rs.next()){

	         		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameMaxNiCuesDeGrupo: max Cuestionario para niGrupoCuesVTMAnu " + niGrupoCuestionarioVTMAnu+ " ="+ rs.getInt(1));

	         		niCuestionarioVTMAnu = rs.getInt(1) + 1;

	         	}

	         	return niCuestionarioVTMAnu;

	        }

	        catch(Exception ex)

     	        {   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameMaxNiCuesDeGrupo: " + sw.getBuffer ().toString());

     		throw ex;

     	      }

     }

     

      public void rellenaDatosGrupoCuestionarioVTMAnu( Q02bCuestionarioVTMAnuFiltro cuestionarioVTMAnuFiltro, Q02bTablaBDQ022BS00 tablaBDGrupoCuestionariosVTMAnu) throws Exception {

    	//se definen objetos necesarios.

    	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosGrupoCuestionarioVTMAnu: entrando");

	   	}         	         

     		//se aaden los datos

	    	tablaBDGrupoCuestionariosVTMAnu.setQ022BT00_ID_GRUPO(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnuFiltro.getNiGrupoCuesVTMAnu()));

	    	tablaBDGrupoCuestionariosVTMAnu.setQ022BT00_ANO(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnuFiltro.getAno()));

	    	tablaBDGrupoCuestionariosVTMAnu.setQ022BT00_MES(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnuFiltro.getMes()));

	    	tablaBDGrupoCuestionariosVTMAnu.setQ022BT00_CONCEDIDO_LICEN(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnuFiltro.getRealizaActuacion()));

	    	tablaBDGrupoCuestionariosVTMAnu.setFCA02T00_CODPROVINC(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnuFiltro.getCodProv()));

	    	tablaBDGrupoCuestionariosVTMAnu.setFCA02T00_CODMUNICIP(Q02bFormatData.checkIntegerNull(cuestionarioVTMAnuFiltro.getCodMuni()));

	    	tablaBDGrupoCuestionariosVTMAnu.setQ022BT00_OBSSU(Q02bFormatData.checkStringNull(cuestionarioVTMAnuFiltro.getObsVTM()));

			//tablaBDGrupoCuestionariosVTMAnu.setQ022CT00_TIPO_CUESTIONARIO(new Integer(Q02bConstantes.getString("q02b.cuestionarios.VTMAnu.tipoCuestionario")));



    	}catch(Exception ex){   	   

    		java.io.StringWriter sw = new java.io.StringWriter();

    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

    		ex.printStackTrace(pw);

    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaDatosGrupoCuestionarioVTMAnu: " + sw.getBuffer ().toString());

    		throw ex;

    	}finally{    		

			if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosGrupoCuestionarioVTMAnu: saliendo");                

           }       	

    	}	

    }  

    

     /**

      * Funcin que devuelve un string con los meses que le quedan por introducir para un municipio y ao determinados por los parmetros de entrada

      * 

      * @param codProv- Cdigo de la provincia

      * @param codMuni- Cdigo del municipio

      * @param ano- Ao

      * @param idioma- Idioma

      * 

      * @throws Exception

      */

     public String obtenerAnosSinActuacionesParaMuni(String codProv,String codMuni,String ano,String idioma) throws Exception {

    	//se definen objetos necesarios.

    	StringBuffer msgAnos = new StringBuffer();

    	int anno = Integer.parseInt(ano);

    	ResultSet rs = null;

    	java.util.Hashtable hashAnos = new java.util.Hashtable();

       	Q02bTablaBDQ022CS00 tablaBDGrupoCuestionariosVTMAnu = null;

       	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: entrando");

	   	}

	   	

	   	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: idioma="+ idioma);

	   

	   	/*if(Q70ListenerUtils.getApplicationProperty("IDIOMA_ES").equals(idioma))

	   	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: idioma ES");

	   		arrNombresMeses = Q02bAplicationUtils.mesesCas;

	   	}

	   	else if(Q70ListenerUtils.getApplicationProperty("IDIOMA_EU").equals(idioma))

	   	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: idioma EU");

	   		arrNombresMeses = Q02bAplicationUtils.mesesEus;

	   	}

	   	//Se carga el hashtable con los nombres de los  meses*/

	   

	   	for (int i = anno - 2; i <= anno + 2; i++)

	   	{

	   		hashAnos.put(Integer.toString(i),Integer.toString(i));

		}

    	tablaBDGrupoCuestionariosVTMAnu = new Q02bTablaBDQ022CS00(this.getConnection());

    	rs = this.dameAnosConCuesVTMAnu(codProv,codMuni,ano,tablaBDGrupoCuestionariosVTMAnu);

     	while (rs.next())

     	{

     		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: Hay cuestionarios VTM en el ao ****"+ rs.getString(1));

     		hashAnos.remove(rs.getString(1));

    	}

	        	

     	

		if(!hashAnos.isEmpty())

		{

    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni:Faltan cuestionarios de meter, xq el array hastable no est vacio ****");

    		//String mesesSinCues = "";

    		for (int i = anno - 2; i <= anno + 2; i++)

    		{

    			//Si el array de aos contiene el ao, es que falta de introducir datos, 

    			if(hashAnos.containsKey(Integer.toString(i+1)))

    			{

    				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni:Falta de introducir el ao  ******* ="+ i);

    				if(!msgAnos.equals("")){

    					msgAnos.append(", ");
                    }
    				msgAnos.append(hashAnos.get(Integer.toString(i+1)));

    			}

    		}

            String msgAnosAux = msgAnos.toString();
    		

    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni:Meses sin meter ******* ="+ msgAnos);
    		msgAnosAux = Q70GestorMensajesi18n.getSingleton().getMessage(RECURSOS_CUES_AYUN_MEN,"cuestionarios.VTMAnu.mesesFaltan",idioma) + msgAnosAux + ".";
    		msgAnos.append(msgAnosAux);
    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni:MSG = ****" + msgAnos);



    	}



      		return msgAnos.toString();

     	}

     	catch(Exception ex)

     	{   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: " + sw.getBuffer ().toString());

     		throw ex;

     	}

     	finally

     	{

     		try

     		{

     			tablaBDGrupoCuestionariosVTMAnu.freeResourcesNotConnection();	

     		}

     		catch(Exception ex)

     		{

     			if (tr.isTraceActive())

     			{

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: error liberando recursos");

 		   	   }  

 		}  		

		if (tr.isTraceActive())

		{

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: saliendo");                

    		}       	

     	}

     }

     

     private ResultSet dameAnosConCuesVTMAnu(String codProv,String codMuni,String ano ,Q02bTablaBDQ022CS00 tablaBDGrupoCuestionariosVTMAnu) throws Exception 

     {

     	ResultSet rs = null;	

     	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameAnosConCuesVTMAnu: entrando");

	   	}

	   	

	         	tablaBDGrupoCuestionariosVTMAnu.setMUN_PROV_WHERE(codProv);

	         	tablaBDGrupoCuestionariosVTMAnu.setMUN_MUNI_WHERE(codMuni);

	         	tablaBDGrupoCuestionariosVTMAnu.setQ022CT00_ANO_WHERE(new Integer(ano));

				//tablaBDGrupoCuestionariosVTMAnu.setQ022CT00_TIPO_CUESTIONARIO(new Integer(Q02bConstantes.getString("q02b.cuestionarios.VTMAnu.tipoCuestionario")));

	         	tablaBDGrupoCuestionariosVTMAnu.setAditionalWhere(" and  ( " + tablaBDGrupoCuestionariosVTMAnu.NOMCOLUMN_Q022CT00_REALIZA_ACTUACION + " = 0 or ( " +  tablaBDGrupoCuestionariosVTMAnu.NOMCOLUMN_Q022CT00_REALIZA_ACTUACION + " = 1 and " + tablaBDGrupoCuestionariosVTMAnu.NOMCOLUMN_Q022CT00_ID_GRUPO + " in (select distinct(" + tablaBDGrupoCuestionariosVTMAnu.NOMCOLUMN_Q022CT00_ID_GRUPO + ") from Q022DS00)))");

	         	rs = tablaBDGrupoCuestionariosVTMAnu.selectDistinct();

	         	tablaBDGrupoCuestionariosVTMAnu.addResultSet(rs);     	

	         	return rs;

	        }

	        catch(Exception ex)

     	        {   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameAnosConCuesVTMAnu: " + sw.getBuffer ().toString());

     		throw ex;

     	      }

     	      finally

     	      {

     	      	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameAnosConCuesVTMAnu: saliendo");

	   	}

     	      }

     }

     

      /**

      * Funcin que devuelve el campo Concede Licencias para un municipio,ao y mes determinados por los parmetros de entrada

      * 

      * @param codProv- Cdigo de la provincia

      * @param codMuni- Cdigo del municipio

      * @param ano- Ao

      * @param mes- Mes

      * @throws Exception

      */

     public String obtenerCamporRealizaActuacionDeGrupoConMuniAno(String codProv,String codMuni,String ano) throws Exception {

    	//se definen objetos necesarios.

    	String realizaActuacion = null;

    	ResultSet rs = null;

       	Q02bTablaBDQ022CS00 tablaBDGrupoCuestionariosVTMAnu = null;

       	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCamporRealizaActuacionDeGrupoConMuniAno: entrando");

	   	}

	   	

	    	tablaBDGrupoCuestionariosVTMAnu = new Q02bTablaBDQ022CS00(this.getConnection());

	    	rs = this.dameRsGrupoCues(codProv,codMuni,ano,tablaBDGrupoCuestionariosVTMAnu);

				if (rs.next())

	         	{

	         		realizaActuacion = rs.getString(tablaBDGrupoCuestionariosVTMAnu.NOMCOLUMN_Q022CT00_REALIZA_ACTUACION);

	         		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCamporRealizaActuacionDeGrupoConMuniAno: entrando");

	        	}

      		return Q02bFormatData.esNullSinCero(realizaActuacion);

     	}

     	catch(Exception ex)

     	{   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCamporRealizaActuacionDeGrupoConMuniAno: " + sw.getBuffer ().toString());

     		throw ex;

     	}

     	finally

     	{

     		try

     		{

     			tablaBDGrupoCuestionariosVTMAnu.freeResourcesNotConnection();	

     		}

     		catch(Exception ex)

     		{

     			if (tr.isTraceActive())

     			{

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCamporRealizaActuacionDeGrupoConMuniAno: error liberando recursos");

 		   	   }  

 		}  		

		if (tr.isTraceActive())

		{

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCamporRealizaActuacionDeGrupoConMuniAno: saliendo");                

    		}       	

     	}

     }

     

     private ResultSet dameRsGrupoCues(String codProv,String codMuni,String ano , Q02bTablaBDQ022CS00 tablaBDGrupoCuestionariosVTMAnu) throws Exception 

     {

     	ResultSet rs = null;	

     	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameRsGrupoCues: entrando");

	   	}

	   	

	         	tablaBDGrupoCuestionariosVTMAnu.setMUN_PROV_WHERE(codProv);

	         	tablaBDGrupoCuestionariosVTMAnu.setMUN_MUNI_WHERE(codMuni);

	         	tablaBDGrupoCuestionariosVTMAnu.setQ022CT00_ANO_WHERE(new Integer(ano));

				//tablaBDGrupoCuestionariosVTMAnu.setQ022CT00_TIPO_CUESTIONARIO_WHERE(new Integer(Q02bConstantes.getString("q02b.cuestionarios.VTMAnu.tipoCuestionario")));

	         	rs = tablaBDGrupoCuestionariosVTMAnu.select();

	         	tablaBDGrupoCuestionariosVTMAnu.addResultSet(rs);     	

	         	return rs;

	        }

	        catch(Exception ex)

     	        {   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameRsGrupoCues: " + sw.getBuffer ().toString());

     		throw ex;

     	      }

     	      finally

     	      {

     	      	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameRsGrupoCues: saliendo");

	   	}

     	      }

     }

     

      /**

      * Funcin que modifica la firma del grupo de cuestionarios pasado como parmetro

      * 

      * @param cuestionarioVTMAnu - Datos de cuestionarioVTMAnu a modificar

      * 

      * @throws Exception

      */

     public void guardarFirmaGrupoCuestionariosVTMAnu(String niGrupoCuesVTMAnu,String xmlFirmaGrupoCuestionariosVTMAnu) throws Exception {  



      	if (tr.isTraceActive()){

  		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu: entrando");

  	}

      	//Se instancian los objetos necesarios.

      	StringBuffer queryClob= new StringBuffer();

      	Q02bTablaBDQ022CS00 Q02bTablaBDQ022CS00obj = null;    

         	 try

         	 {     

         	 	//se crea el objeto de tablasBD

        		Q02bTablaBDQ022CS00obj = new Q02bTablaBDQ022CS00(this.getConnection());

        		//segmento tecnico

             		//Q02bTablaBDQ022DS00obj.setUser(this.getUser());

  		

       		Q02bTablaBDQ022CS00obj.setQ022CT00_ID_GRUPO_WHERE(new Integer(niGrupoCuesVTMAnu));

       		//Este campo se actualiza de forma especial, con una select for update de este campo

       		//Q02bTablaBDQ022CS00obj.setQ022CT00_XML_FIRMADO(xmlFirmaGrupoCuestionariosVTMAnu);

       		//Q02bTablaBDQ022CS00obj.setQ022CT00_FEC_FIRMA(new java.util.Date(System.currentTimeMillis()));

       		//De momento el usuario lo metemos vacio

       		//Q02bTablaBDQ022CS00obj.setQ022CT00_USER_FIRMA();

       		//se realiza la update

       		Q02bTablaBDQ022CS00obj.update();

       		

       		//Se realiza la query de los CLOB

	    	//queryClob.append("SELECT ").append(Q02bTablaBDQ022CS00obj.NOMCOLUMN_Q022CT00_XML_FIRMADO).append(" FROM  Q022CS00 WHERE ").append(Q02bTablaBDQ022CS00obj.NOMCOLUMN_Q022CT00_ID_GRUPO).append(" = " ).append(niGrupoCuesVTMAnu).append(" FOR UPDATE");

	    	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu->queryClob="+ queryClob.toString());

	    	//Se inserta el Clob

	    	Q02bBDUtilidades.insertClob(xmlFirmaGrupoCuestionariosVTMAnu,queryClob.toString(),this.getConnection());

       		

         }

         catch(Exception ex)

         {

              java.io.StringWriter sw = new java.io.StringWriter();

              java.io.PrintWriter pw = new java.io.PrintWriter(sw);

              ex.printStackTrace(pw);

              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu: " + sw.getBuffer ().toString());

              throw ex;

         }

         finally

         {     

         	try

         	{

    		Q02bTablaBDQ022CS00obj.freeResourcesNotConnection();	

    	}

    	catch(Exception ex)

    	{

		   if (tr.isTraceActive())

		   {

			   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu: error liberando recursos");

   	   	   }  

    	}  		  

      	if (tr.isTraceActive())

      	{

      		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu: saliendo");                

                      }             

         }     

     } // fin guardarFirmaGrupoCuestionariosVTMAnu

     

     

     /**

      * Funcin que borra el cuestionarioVTMAnu pasado como parmetro de la BBDD

      * 

      * @param niCuestionarioVTMAnu - nmero interno del cuestionarioVTMAnu a borrar

      * 

      * @throws Exception

      */

     public void borrarTodosCuestionarioVTMAnu(String niGrupoCuestionarioVTMAnu) throws Exception {



    	 

      	if (tr.isTraceActive())

      	{

  		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarTodosCuestionarioVTMAnu: entrando");

  	}

        	

      	//se crean los objetos necesarios

     	Q02bTablaBDQ022DS00 Q02bTablaBDQ022DS00obj = null;       

          try{    

        	  

        	  Calendar calendar = Calendar.getInstance();

  	        

        	  //String fecha = new SimpleDateFormat( "dd/MM/yyyy hh:mm:ss",new java.util.Locale("es")).format(new Date(calendar.getTimeInMillis()));

         	 //se crea el objeto de tablasBD

         	 Q02bTablaBDQ022DS00obj = new Q02bTablaBDQ022DS00(this.getConnection());

                      // segmento tecnico

                      //Q02bTablaBDQ022DS00obj.setUser(this.getUser());    	

         	//se pone el filtro para la delete

         	//Q02bTablaBDQ022DS00obj.setQ022DT00_ID_CUES_WHERE(Long.parseLong(niCuestionarioVTMAnu));

         	Q02bTablaBDQ022DS00obj.setQ022BT00_ID_GRUPO_WHERE(Integer.parseInt(niGrupoCuestionarioVTMAnu));         	

         	

         	//se lanza al delete

          	Q02bTablaBDQ022DS00obj.update();         	

         }

         catch(Exception ex)

         {

              java.io.StringWriter sw = new java.io.StringWriter();

              java.io.PrintWriter pw = new java.io.PrintWriter(sw);

              ex.printStackTrace(pw);

              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarTodosCuestionarioVTMAnu: " + sw.getBuffer ().toString());

              throw ex;

         }finally

         {

         	try{

     		Q02bTablaBDQ022DS00obj.freeResourcesNotConnection();	

     	}

     	catch(Exception ex)

     	{

     		if (tr.isTraceActive())

     		{

     			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarTodosCuestionarioVTMAnu: error liberando recursos");

     		}  

     	}  		

      	if (tr.isTraceActive())

      	{

      		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarTodosCuestionarioVTMAnu: saliendo");                

                     }     	   

         }

     }//fin borrarTodosCuestionarioVTMAnu 

     

     public void  modificarDatosFirmaGrupoCuestionarioVTMMen(String niGrupoCuestionarioVTMAnu) throws Exception {

    	 

    	 Q02bTablaBDQ022BS00 tablaBDGrupoCuestionariosVTMMen = null;

      	try{

 	    	if (tr.isTraceActive())

 	    	{

 	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarDatosFirmaGrupoCuestionarioVTMMen: entrando");

 	   	}

 	    	tablaBDGrupoCuestionariosVTMMen = new Q02bTablaBDQ022BS00(this.getConnection());

 	    	

 	    	tablaBDGrupoCuestionariosVTMMen.setQ022BT00_ID_GRUPO_WHERE(Integer.parseInt(niGrupoCuestionarioVTMAnu));

 	    	

 	    	tablaBDGrupoCuestionariosVTMMen.setQ022BT00_FEC_FIRMA(null);

 	    	

 	    		

 	    	StringBuffer queryClob= new StringBuffer();

 	    	

 	    	queryClob.append("SELECT ").append(tablaBDGrupoCuestionariosVTMMen.NOMCOLUMN_Q022BT00_XML_FIRMADO).append(" FROM  Q022BS00 WHERE ").append(tablaBDGrupoCuestionariosVTMMen.NOMCOLUMN_Q022BT00_ID_GRUPO).append(" = " ).append(Integer.parseInt(niGrupoCuestionarioVTMAnu)).append(" FOR UPDATE");

 	    		    	

 	    	Q02bBDUtilidades.insertClob(" ",queryClob.toString(),this.getConnection());

 	    	

 	    	tablaBDGrupoCuestionariosVTMMen.setQ022BT00_USER_FIRMA(null);

 	    	

 	    	tablaBDGrupoCuestionariosVTMMen.update();



    	}

    	catch(Exception ex)

    	{   	   

    		java.io.StringWriter sw = new java.io.StringWriter();

    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

    		ex.printStackTrace(pw);

    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarDatosFirmaGrupoCuestionarioVTMMen: " + sw.getBuffer ().toString());

    		throw ex;

    	}

  

    }

     

     /**

      * Funcin que devuelve el campo Concede Licencias para un municipio,ao y mes determinados por los parmetros de entrada

      * 

      * @param codProv- Cdigo de la provincia

      * @param codMuni- Cdigo del municipio

      * @param ano- Ao

      * @param mes- Mes

      * @throws Exception

      */

     public boolean obtenerNumCuestionarios(String codProv,String codMuni,String ano,String mes) throws Exception {

    	//se definen objetos necesarios.

    	boolean hayCuestionarios = false;

    	ResultSet rs = null;

       	Q02bTablaBDQ022BS00 tablaBDGrupoCuestionariosVTM = null;

       	Q02bTablaBDQ022DS00 tablaBDCuestionariosVTM = null;

       	int numero = -1;

       	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNumCuestionarios: entrando");

	   	}

	   	

	    	tablaBDGrupoCuestionariosVTM = new Q02bTablaBDQ022BS00(this.getConnection());

	    	tablaBDCuestionariosVTM = new Q02bTablaBDQ022DS00(this.getConnection());

	    	

	    	//hacer un metodo nuevo

	    	rs = this.dameRsNumCues(codProv,codMuni,ano,mes,tablaBDGrupoCuestionariosVTM,tablaBDCuestionariosVTM);

	        if (rs.next())

	        {

	        	numero = rs.getInt(1);

	        	if (numero > 0)

	        	{

	        		hayCuestionarios = true;

	        	}

	        	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNumCuestionarios: entrando");

	        }

	        	

      		return hayCuestionarios;

     	}

     	catch(Exception ex)

     	{   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerNumCuestionarios: " + sw.getBuffer ().toString());

     		throw ex;

     	}

     	finally

     	{

     		try

     		{

     			tablaBDGrupoCuestionariosVTM.freeResourcesNotConnection();	

     		}

     		catch(Exception ex)

     		{

     			if (tr.isTraceActive())

     			{

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoConcedeLicenDeGrupoConMuniAnoYMes: error liberando recursos");

 		   	   }  

 		}  		

		if (tr.isTraceActive())

		{

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoConcedeLicenDeGrupoConMuniAnoYMes: saliendo");                

    		}       	

     	}

     }

     

     private ResultSet dameRsNumCues(String codProv,String codMuni,String ano ,String mes,Q02bTablaBDQ022BS00 tablaBDGrupoCuestionariosVTM,Q02bTablaBDQ022DS00 tablaBDCuestionariosVTM) throws Exception 

     {

     	ResultSet rs = null;	

     	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameRsNumCues: entrando");

	   	}

	    	

	    	tablaBDCuestionariosVTM.setAditionalWhere("AND " + tablaBDCuestionariosVTM.NOMCOLUMN_Q022BT00_ID_GRUPO + " in (select " + tablaBDGrupoCuestionariosVTM.NOMCOLUMN_Q022BT00_ID_GRUPO + " from Q022BS00 where " + tablaBDGrupoCuestionariosVTM.NOMCOLUMN_Q022BT00_ANO + " = " + ano + " and " + tablaBDGrupoCuestionariosVTM.NOMCOLUMN_Q022BT00_MES + " = " + mes + " and " + tablaBDGrupoCuestionariosVTM.NOMCOLUMN_FCA02T00_CODPROVINC + " = " + codProv + " and " + tablaBDGrupoCuestionariosVTM.NOMCOLUMN_FCA02T00_CODMUNICIP + " = " + codMuni + " )");

	    	rs = tablaBDCuestionariosVTM.selectCount();

	    	tablaBDCuestionariosVTM.addResultSet(rs);     	

	        return rs;

	     }

	        catch(Exception ex)

     	        {   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameRsNumCues: " + sw.getBuffer ().toString());

     		throw ex;

     	      }

     	      finally

     	      {

     	      	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameRsGrupoCues: saliendo");

	   	}

     	      }

     }

     

     public int getNumCuestionariosOM(String territorio, String  municipio, String  anyoReferencia, String  mesReferencia) throws Exception 

     {

    	int numCuestionariosOM=0;

    	ResultSet rs = null;

       	PreparedStatement prepStmt =null;	

       	StringBuffer query = null;

     	try{

	    	if (tr.isTraceActive()){

	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosOM: entrando");

	    	}

	    	query = new StringBuffer("SELECT COUNT(*) FROM Q022DS01V01 WHERE");

        	query.append(" Q022BT00_ANO=").append(anyoReferencia);

        	query.append(" AND FCA02T00_CODPROVINC='").append(territorio).append("'");

        	query.append(" AND FCA02T00_CODMUNICIP='").append(municipio).append("'");

        	if(!Q02bFormatData.esNull(mesReferencia).equals("")){ //Si se llama desde la portada SM 2008, l mes no vendr informado

        		query.append(" AND Q022BT00_MES=").append(mesReferencia);
            }
        	prepStmt = this.getConnection().prepareStatement(query.toString());

        	

   	 		rs = prepStmt.executeQuery(); 

   	 		if(rs.next()){

   	 			numCuestionariosOM = rs.getInt(1);

   	 		}

	        if (tr.isTraceActive()){

		    	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosOM: saliendo");

		    }

	        return numCuestionariosOM;

	       }catch(Exception ex){   	   

	     		java.io.StringWriter sw = new java.io.StringWriter();

	     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	     		ex.printStackTrace(pw);

	     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosOM: " + sw.getBuffer ().toString());

	     		throw ex;

     	    }finally{ 

	    	   try{

	    		   if (rs!=null){

	    			   rs.close();
                   }
	       		   if (prepStmt!=null){

	       			   prepStmt.close();
                   }
	          }catch(Exception ex){

	        	  java.io.StringWriter sw = new java.io.StringWriter();

		          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

		          ex.printStackTrace(pw);

		          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: " + sw.getBuffer ().toString());

		          throw new Q02bDAOException(ex);

	          }

	       }

	 }

     

     public String getConcedidoGrupoCuesVTM(String territorio, String  municipio, String  anyoReferencia, String  mesReferencia) throws Exception 

     {

    	String concedidoLicenInicial="";

    	ResultSet rs = null;

       	PreparedStatement prepStmt =null;	

       	StringBuffer query = null;

     	try{

	    	if (tr.isTraceActive()){

	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getConcedidoGrupoCuesVTM: entrando");

	    	}

	    	query = new StringBuffer("SELECT Q022BT00_CONCEDIDO_LICEN FROM Q022BS00 WHERE");

        	query.append(" Q022BT00_ANO=").append(anyoReferencia);

        	query.append(" AND FCA02T00_CODPROVINC='").append(territorio).append("'");

        	query.append(" AND FCA02T00_CODMUNICIP='").append(municipio).append("'");	  

        	if(!Q02bFormatData.esNull(mesReferencia).equals("")){ //Si se llama desde la portada SM 2008, l mes no vendr informado

        		query.append(" AND Q022BT00_MES=").append(mesReferencia);
            }
        	prepStmt = this.getConnection().prepareStatement(query.toString());

        	

   	 		rs = prepStmt.executeQuery(); 

   	 		if(rs.next()){

   	 		concedidoLicenInicial = rs.getString(1);

   	 		}

	        if (tr.isTraceActive()){

		    	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getConcedidoGrupoCuesVTM: saliendo");

		    }

	        return concedidoLicenInicial;

	       }catch(Exception ex){   	   

	     		java.io.StringWriter sw = new java.io.StringWriter();

	     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	     		ex.printStackTrace(pw);

	     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getConcedidoGrupoCuesVTM: " + sw.getBuffer ().toString());

	     		throw ex;

     	    }finally{ 

	    	   try{

	    		   if (rs!=null){

	    			   rs.close();
                   }
	       		   if (prepStmt!=null){

	       			   prepStmt.close();
                   }
	          }catch(Exception ex){

	        	  java.io.StringWriter sw = new java.io.StringWriter();

		          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

		          ex.printStackTrace(pw);

		          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getConcedidoGrupoCuesVTM: " + sw.getBuffer ().toString());

		          throw new Q02bDAOException(ex);

	          }

     	    }

     }

     

     

     public void  modificarGrupoCuestionariosVTM(String niGrupoCuesVTM, String valorRealizaActu, String mes, String obs) throws Exception {

    	 Q02bTablaBDQ022BS00 tablaBDGrupoCuestionariosVTM = null;

    	 Q02bTablaBDQ022DS00 tablaBDCuestionariosVTM = null;

    	 try{

	    	if (tr.isTraceActive()){

	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarGrupoCuestionariosVTM: entrando");

	    	}

	    	tablaBDGrupoCuestionariosVTM = new Q02bTablaBDQ022BS00(this.getConnection());

	    	tablaBDCuestionariosVTM = new Q02bTablaBDQ022DS00(this.getConnection());

	    	

	    	if(valorRealizaActu.equals("0")){//Hay que borrar los cuestionarios rellenados de cuando se respondio que SI se haban concedido licencias

	    		tablaBDCuestionariosVTM.setQ022BT00_ID_GRUPO_WHERE(Q02bFormatData.checkIntegerNull(niGrupoCuesVTM));

	    		tablaBDCuestionariosVTM.delete();

	    	}

	    	//Modificamos el grupo

	    	tablaBDGrupoCuestionariosVTM.setQ022BT00_ID_GRUPO_WHERE(Q02bFormatData.checkIntegerNull(niGrupoCuesVTM));

	    	tablaBDGrupoCuestionariosVTM.setQ022BT00_CONCEDIDO_LICEN(Q02bFormatData.checkIntegerNull(valorRealizaActu));

	    	//tablaBDGrupoCuestionariosVTM.setQ22BT00_MES(Integer.parseInt(mes));

	    	if(valorRealizaActu.equals("0")){

	    		tablaBDGrupoCuestionariosVTM.setQ022BT00_OBSSU(obs);
            }
	    	else{

	    		tablaBDGrupoCuestionariosVTM.setQ022BT00_OBSSU(null);
            }
	    	tablaBDGrupoCuestionariosVTM.update();



     	}

     	catch(Exception ex){   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarGrupoCuestionariosVTM: " + sw.getBuffer ().toString());

     		throw ex;

     	}

     	finally{

    		try{

    			tablaBDGrupoCuestionariosVTM.freeResourcesNotConnection();	

    		}

    		catch(Exception ex){

    			if (tr.isTraceActive()){

    				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarGrupoCuestionariosVTM: error liberando recursos");

		   	}  

		}

     }

   }

     

     

     

     public String obtenerIdGrupoCuestionariosVTM(Q02bCuestionarioVTMFiltro cuestionariosVTMFiltro) throws Exception 

     {

     	ResultSet rs = null;

     	String idGrupo=null;

     	Q02bTablaBDQ022BS00 tablaBDGrupoCuestionariosVTM = null;

     	try{

 		    	if (tr.isTraceActive()){

 		    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerIdGrupoCuestionariosSM: entrando");

 		    	}

 		    	tablaBDGrupoCuestionariosVTM = new Q02bTablaBDQ022BS00(this.getConnection());

 		    	tablaBDGrupoCuestionariosVTM.addColumnSelect(Q02bTablaBDQ022BS00.NOMCOLUMN_Q022BT00_ID_GRUPO);

 		    	tablaBDGrupoCuestionariosVTM.setQ022BT00_ANO_WHERE(Q02bFormatData.checkIntegerNull(cuestionariosVTMFiltro.getAno()));

 		    	tablaBDGrupoCuestionariosVTM.setFCA02T00_CODPROVINC_WHERE(Q02bFormatData.checkIntegerNull(cuestionariosVTMFiltro.getCodProv()));

 		    	tablaBDGrupoCuestionariosVTM.setFCA02T00_CODMUNICIP_WHERE(Q02bFormatData.checkIntegerNull(cuestionariosVTMFiltro.getCodMuni()));

 		    	tablaBDGrupoCuestionariosVTM.setQ022BT00_CONCEDIDO_LICEN_WHERE(1);

 			   	tablaBDGrupoCuestionariosVTM.setQ022BT00_MES_WHERE(Q02bFormatData.checkIntegerNull(cuestionariosVTMFiltro.getMes()));

 			   	

 			   	rs=tablaBDGrupoCuestionariosVTM.select();

 			   tablaBDGrupoCuestionariosVTM.addResultSet(rs);

 			   	if(rs.next()){

 			   		idGrupo =rs.getString(tablaBDGrupoCuestionariosVTM.NOMCOLUMN_Q022BT00_ID_GRUPO);

 			   	}

 			   	if (tr.isTraceActive()){

 		    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerIdGrupoCuestionariosSM: saliendo");

 		    	}

 			   	return idGrupo;

 		 } catch(Exception ex){   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerIdGrupoCuestionariosSM: " + sw.getBuffer ().toString());

     		throw ex;

     	  }finally{

       		try{

       			tablaBDGrupoCuestionariosVTM.freeResourcesNotConnection();	

       		}

       		catch(Exception ex){

       			if (tr.isTraceActive()){

       				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerIdGrupoCuestionariosSM: error liberando recursos");

   		   	 }  

       		}

     	 }

     }

     

     public String getNiGrupoCuesVTM(String territorio, String municipio, String anyoReferencia, String mesReferencia) throws Exception

 	{

 		//se definen objetos necesarios. 	

       	Q02bTablaBDQ022BS00 tablaBDGrupoCuestionariosVTMAnu = null;

       	int niGrupoCuesVTMAnu = 0;

       	String resultado = "";

       	ResultSet rs = null;

       	

       	try{

 	    	if (tr.isTraceActive())

 	    	{

 	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNiGrupoCuesVTM: entrando");

 	   	}

    		//se crea el objeto de tablasBD

 	    	

 	    	tablaBDGrupoCuestionariosVTMAnu = new Q02bTablaBDQ022BS00(this.getConnection());

      		

 	    	

 	    	tablaBDGrupoCuestionariosVTMAnu.setQ022BT00_ANO_WHERE(Integer.parseInt(anyoReferencia));

 		   	tablaBDGrupoCuestionariosVTMAnu.setFCA02T00_CODPROVINC_WHERE(Integer.parseInt(territorio));

 		   	tablaBDGrupoCuestionariosVTMAnu.setFCA02T00_CODMUNICIP_WHERE(Integer.parseInt(municipio));

 		   	tablaBDGrupoCuestionariosVTMAnu.setQ022BT00_MES_WHERE(Integer.parseInt(mesReferencia));

 	   	

 		   	rs=tablaBDGrupoCuestionariosVTMAnu.select();

 		   	tablaBDGrupoCuestionariosVTMAnu.addResultSet(rs);

 		   	if (rs.next()){

 		   		niGrupoCuesVTMAnu = rs.getInt(1);

          	}	 

 		    if (niGrupoCuesVTMAnu==0){

 		    	resultado="";

 		    }

 		    else {

       			resultado = Integer.toString(niGrupoCuesVTMAnu);;

 		    }

      		return resultado;

     	}

     	catch(Exception ex)

     	{   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNiGrupoCuesVTM: " + sw.getBuffer ().toString());

     		throw ex;

     	}

     	finally

     	{

     		try

     		{

     			tablaBDGrupoCuestionariosVTMAnu.freeResourcesNotConnection();	

     		}

     		catch(Exception ex)

     		{

     			if (tr.isTraceActive())

     			{

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNiGrupoCuesVTM: error liberando recursos");

 		   	 }  

 		}  		

 		if (tr.isTraceActive())

 		{

 			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNiGrupoCuesVTM: saliendo");                

    		}       	

     	}

 	}

     

     

    public int getNumCuestionariosVTM(String niGrupoCuestionarioVTMAnu) throws Exception 

     {

    	int numCuestionariosVTM=0;

    	ResultSet rs = null;

       	PreparedStatement prepStmt =null;	

       	StringBuffer query = null;

     	try{

	    	if (tr.isTraceActive())

	    		{

	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosVTM: entrando");

	    		}

	    	query = new StringBuffer("SELECT COUNT(*) FROM Q022DS00 WHERE");

        	query.append(" Q022BT00_ID_GRUPO =").append(niGrupoCuestionarioVTMAnu);

        	prepStmt = this.getConnection().prepareStatement(query.toString());

        	rs = prepStmt.executeQuery(); 

   	 		if(rs.next())

   	 			{

   	 				numCuestionariosVTM = rs.getInt(1);

   	 			}

		   	if (tr.isTraceActive())

		   		{

		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosVTM: saliendo");

		   		}

	        return numCuestionariosVTM;

	       }

     	catch(Exception ex){   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosVTM: " + sw.getBuffer ().toString());

     		throw ex;

     	    }

     	finally{ 

     		try{

     			if (rs!=null){

     				rs.close();
                }
     			if (prepStmt!=null){

     				prepStmt.close();
                }
	         }

     		catch(Exception ex){

		    	  java.io.StringWriter sw = new java.io.StringWriter();

		          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

		          ex.printStackTrace(pw);

		          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosVTM: " + sw.getBuffer ().toString());

		          throw new Q02bDAOException(ex);

	         }

     	}

	 }//fin getNumCuestionariosVTM 

     

}



