package q02b.exe.cuestionariosSMAnu.launcher;



import javax.servlet.http.HttpServletRequest;

import javax.servlet.http.HttpServletResponse;

//import javax.servlet.http.HttpSession;

import javax.servlet.jsp.PageContext;



import q02b.exe.arquitectura.beans.Q02bBaseBean;

import q02b.exe.arquitectura.dataobjects.Q02bDAOException;

import q02b.exe.arquitectura.webCommon.beans.Q02bProcessLauncherBean;

import q02b.exe.arquitectura.webCommon.utils.gdtp.Q02bGenericDataTransferProtocol;



//import q02b.exe.comun.Q02bAutenticador;



//import q02b.exe.utils.Q02bConstantes;

//import q02b.exe.utils.Q02bFormatData;



import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;

//import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;



//import java.util.ArrayList;

//import java.util.HashMap; 



//import q02b.exe.cuestionariosAyunMen.beans.Q02bCuestionariosAyunMenBean;

import q02b.exe.cuestionariosSMAnu.beans.Q02bCuestionariosSMBean;



public class Q02bCuestionariosSMLauncher extends Q02bBaseBean implements Q02bProcessLauncherBean {

	/**

	 * 

	 */

	private static final long serialVersionUID = 1677342344158205416L;

	/** Objeto tablaBD usado para buscar en base de datos */

	//protected TablaBDWWHISPLA tablaHISPLA=null;



	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "DAO_CUESTIONARIOS_SM_ANU_ACCESO_DATOS";

	

	//Q70ContextoEJIE q70contextoejie = (Q70ContextoEJIE)request.getSession().getAttribute("contexto");

	//ArrayList listaCues= (ArrayList)q70contextoejie.get("listaCuestionariosSMAnu");

	

	//private  String user = ""; 

	/**

     *  Constructor vaco

     */



	 /* (non-Javadoc)

     * @see com.bbk.arquitectura.webCommon.beans.ProcessLauncherBean#initProcessLauncherBean(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)

     */

    public void initProcessLauncherBean(HttpServletRequest request, HttpServletResponse response) throws Q02bDAOException {

		init(request,response);



    }



	/* (non-Javadoc)

     * @see com.bbk.arquitectura.webCommon.beans.ProcessLauncherBean#initProcessLauncherBean(javax.servlet.jsp.PageContext)

     */

    public void initProcessLauncherBean(PageContext context) throws Q02bDAOException {

    	this.request = (HttpServletRequest)context.getRequest();

    	this.response =(HttpServletResponse)context.getResponse(); 	

    }



	 public Q02bGenericDataTransferProtocol launch() throws Exception {

    	try{	       

	            if (tr.isTraceActive())

	            {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":launch: entrando");

	             }

	            String proceso = getParametro("METHOD");

	            if (proceso.equals("getAnosMesesPendientes"))

	            {

	            	return this.getAnosMesesPendientes();

	            }

	            else if (proceso.equals("obtenerCampoPrevSueloDeGrupoConMuniAnoMes"))

	            {

	            	return this.obtenerCampoPrevSueloDeGrupoConMuniAnoMes();

	            }

	            else if (proceso.equals("guardarFirmaCuestionariosSMAnu"))

	            {

	            	return this.guardarFirmaCuestionariosSMAnu();

	            }	           

	            return null;

    	}

    	catch(Exception e)

    	{

	           return this.processException(e);

        	}

     }

     

     /**

    * Mtodo que llama al Bean de CuestionariosSMAnu que obtiene el campo Prevision Suelo para el grupo del municipio y ao seleccionados

    * @return 

    * @throws Exception

    */

   public Q02bGenericDataTransferProtocol obtenerCampoPrevSueloDeGrupoConMuniAnoMes() throws Exception {

    	

    	if (tr.isTraceActive())

    	{

		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoPrevSueloDeGrupoConMuniAnoMes: entrando");

	}

    	

    	Q02bGenericDataTransferProtocol result = new Q02bGenericDataTransferProtocol(); 

    	Q02bCuestionariosSMBean beanCuestionariosSMAnu = new Q02bCuestionariosSMBean();

    	

        try{ 

        

        	String codProv = ((String)getMapaDatos().get("codProv"));

        	String codMuni = ((String)getMapaDatos().get("codMuni"));

        	String ano = ((String)getMapaDatos().get("ano"));

        	String mes = ((String)getMapaDatos().get("mes"));

        	String tipoCuestionario = ((String)getMapaDatos().get("tipoCuestionario"));

        	String prevSuelo = beanCuestionariosSMAnu.obtenerCampoPrevSueloDeGrupoConMuniAno(codProv,codMuni,ano,mes,tipoCuestionario);         	 

        	boolean hayCuestionarios = false;

        	if (prevSuelo.equals("0") || prevSuelo.equals("null"))

 			{

 				hayCuestionarios = false;

 			}

 			else

 			{

 				hayCuestionarios = beanCuestionariosSMAnu.obtenerNumCuestionarios(codProv,codMuni,ano,mes,tipoCuestionario);

 			}

 			Boolean hayCues = Boolean.valueOf(hayCuestionarios); 			 

 			String hayCu = hayCues.toString();

        	

		 	result.addGroup("RESULT_1"); 			

		 			

		 	result.addProperty("RESULT_1","RESULT","OK");

		 	result.addProperty("RESULT_1","PREV_SUELO", prevSuelo);

		 	result.addProperty("RESULT_1","HAY_CUESTIONARIOS", hayCu);

		 	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoPrevSueloDeGrupoConMuniAnoMes: hola");			

        	return result;

        

       }catch(Exception ex){

            result.addProperty("RESULT_1","RESULT","NOOK");

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoPrevSueloDeGrupoConMuniAnoMes: " + sw.getBuffer ().toString());

            throw new Q02bDAOException(ex);

       }finally{

    	   

    	   if (tr.isTraceActive()){

    		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoPrevSueloDeGrupoConMuniAnoMes: saliendo");                

           }

           

       }

       

   }

   

   /**

    * Mtodo que llama al Bean de CuestionariosSMAnu que obtiene los  aos que no se han introducido cuestionarios para el municipio y ao seleccionados

    * @return 

    * @throws Exception

    */

   public Q02bGenericDataTransferProtocol getAnosMesesPendientes() throws Exception {

    	

    	if (tr.isTraceActive())

    	{

		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getAnosPendientes: entrando");

	}

    	

    	Q02bGenericDataTransferProtocol result = new Q02bGenericDataTransferProtocol(); 

    	Q02bCuestionariosSMBean beanCuestionariosSMAnu = new Q02bCuestionariosSMBean();

    	

        try{ 

        

        	String codProv = ((String)getMapaDatos().get("codProv"));

        	String codMuni = ((String)getMapaDatos().get("codMuni"));

        	String ano = ((String)getMapaDatos().get("ano"));

        	String idioma = ((String)getMapaDatos().get("idioma"));

        	

        	String msgMeses = beanCuestionariosSMAnu.obtenerAnosMesesPendientes(codProv,codMuni,ano,idioma);         	 

 			 

 	result.addGroup("RESULT_1"); 			

 			

 	result.addProperty("RESULT_1","RESULT","OK");

 	result.addProperty("RESULT_1","MSG_MESES", msgMeses);

						

        	return result;

        

       }catch(Exception ex){

            result.addProperty("RESULT_1","RESULT","NOOK");

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getAnosMesesPendientes: " + sw.getBuffer ().toString());

            throw new Q02bDAOException(ex);

       }finally{

    	   

    	   if (tr.isTraceActive()){

    		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getAnosMesesPendientes: saliendo");                

           }

           

       }

       

   }

   

   /**

    * Mtodo que llama al Bean de CuestionariosSMAnu para guardar la firma del grupo de cuestionarios

    * @return 

    * @throws Exception

    */

   public Q02bGenericDataTransferProtocol guardarFirmaCuestionariosSMAnu() throws Exception 

   {

    	

    	if (tr.isTraceActive())

    	{

		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaCuestionariosSMAnu: entrando");

	}

    	

    	Q02bGenericDataTransferProtocol result = new Q02bGenericDataTransferProtocol(); 

    	Q02bCuestionariosSMBean beanCuestionariosSMAnu = new Q02bCuestionariosSMBean();

    	

        try{ 

        

        	String niGrupoCuesSMAnu = ((String)getMapaDatos().get("niGrupoCuesSMAnu"));

        	String xmlFirmaGrupoCuesSMAnu = ((String)getMapaDatos().get("xmlFirmaGrupoCuesSMAnu"));

        	

        	beanCuestionariosSMAnu.guardarFirmaGrupoCuestionariosSMAnu(niGrupoCuesSMAnu,xmlFirmaGrupoCuesSMAnu);         	 

 			 

 		result.addGroup("RESULT_1"); 				

 		result.addProperty("RESULT_1","RESULT","OK");

						

        	return result;

        

       }catch(Exception ex){

            result.addProperty("RESULT_1","RESULT","NOOK");

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":guardarFirmaCuestionariosSMAnu: " + sw.getBuffer ().toString());

            throw new Q02bDAOException(ex);

       }finally{

    	   

    	   if (tr.isTraceActive()){

    		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaCuestionariosSMAnu: saliendo");                

           }

    	   

    	   

           

       }

       

   }

   

  

     



   

  

}