package q02b.exe.cuestionariosSMAnu.beans;



import java.util.ArrayList;

import java.util.HashMap;



import q02b.exe.arquitectura.beans.Q02bBaseBean;

import q02b.exe.cuestionariosSMAnu.dataobjects.Q02bCuestionariosSMDataBaseDAO;

import q02b.exe.cuestionariosSMAnu.valueobjects.Q02bCuestionarioSM;

import q02b.exe.cuestionariosSMAnu.valueobjects.Q02bCuestionarioSMFiltro;

import q02b.exe.utils.Q02bFormatData;

import q02b.exe.utils.Q02bVoUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;



   

public class Q02bCuestionariosSMBean extends Q02bBaseBean{

	private static final long serialVersionUID = 5474311672836163390L;

	protected Q02bCuestionariosSMDataBaseDAO daoCuestionariosSMAnu = null;

	final static String	LISTA_CUESTIONARIOS_SM = "listaCuestionariosSMAnu";

	//Q70ContextoEJIE q70contextoejie = (Q70ContextoEJIE)request.getSession().getAttribute("contexto");

	//ArrayList listaCues= (ArrayList)q70contextoejie.get("listaCuestionariosSMAnu");

	 /** Constructor vacio */

    public Q02bCuestionariosSMBean() {

        super();

    }



        

    /**

     * Funcin que recupera los cuestionarios de suelo municipal con los datos introducidos en el filtro (pgina de portada)

     * 

     * @param filtroCuestionariosSM - Datos de los cuestionarios a consultar

     * @return listaCuestionariosSMAnu  -  Listado de cuestionarios obtenidos

     * @throws Exception

     */

	public ArrayList getCuestionariosSM(HashMap mapaFiltroPortadaCuestionarioSM) throws Exception 

	{

		 if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCuestionariosSM: entrando.");

	   		}  	  

		String idGrupo = null;		

		//String noRegRecuperados = "NoHayCuestionariosSMAnu";

		ArrayList listaCuestionariosSMAnu = new ArrayList();

		Q02bCuestionarioSMFiltro cuestionarioSMFiltroPortada = null;

		boolean error = false;

		boolean obtenerListado=false;

		

		try{

			String anyo2008=q02b.exe.utils.Q02bConstantes.getString("ano.portada.2008");

			

			cuestionarioSMFiltroPortada = (Q02bCuestionarioSMFiltro) Q02bVoUtils.getValueObject(mapaFiltroPortadaCuestionarioSM,"q02b.exe.cuestionariosSMAnu.valueobjects.Q02bCuestionarioSMFiltro");

			cuestionarioSMFiltroPortada.setPrevSuelo("1");

			//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoCuestionariosSMAnu = new Q02bCuestionariosSMDataBaseDAO(this.getConn());

			if(cuestionarioSMFiltroPortada.getAno().equals(anyo2008)){//Viene de la portada 2008

				int numCuestionarios = 0;

				numCuestionarios = daoCuestionariosSMAnu.getNumCuestionariosSM(cuestionarioSMFiltroPortada.getCodProv(),cuestionarioSMFiltroPortada.getCodMuni(),cuestionarioSMFiltroPortada.getAno(),cuestionarioSMFiltroPortada.getMes());

				if(numCuestionarios>0){

					obtenerListado=true;
                }
			}

			else{

				//se llamamara al dao para obtener el nmero de cuestionarios

				idGrupo = daoCuestionariosSMAnu.obtenerIdGrupoCuestionariosSM(cuestionarioSMFiltroPortada);

				if(idGrupo!=null && !idGrupo.equals("")){

					//listaCuestionariosSMAnu = daoCuestionariosSMAnu.getSelectCuestionariosSMAnu(idGrupo);

					cuestionarioSMFiltroPortada.setNiGrupoCuesSMAnu(idGrupo);

					obtenerListado=true;

	            }    

			}

			if(obtenerListado){

				listaCuestionariosSMAnu = daoCuestionariosSMAnu.getSelectCuestionariosSMAnu(cuestionarioSMFiltroPortada);
            }
            return listaCuestionariosSMAnu;              

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter sw = new java.io.StringWriter();

          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCuestionariosSM: " + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoCuestionariosSMAnu.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCuestionariosSM: error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCuestionariosSM: saliendo.");

	   		}

 	  	}

 	  } //fin getCuestionariosSM 

	

	

	/**

	 * Insertar en bbdd un  nuevo cuestionario con los datos pasados como parmetro en la HashMap

	 */

	public String insertarCuestionarioSM(HashMap mapaCuestionarioSM, HashMap mapaFiltroPortadaCuestionarioSM) throws Exception 

	{

		String niCuestionarioSMAnu = "";

		Q02bCuestionarioSM cuestionarioSMAnu = null;

		Q02bCuestionarioSMFiltro cuestionarioSMFiltroPortada = null;

		String niGrupoCuesSM = null;

		boolean es2008=false;

		String anoPortada2008=q02b.exe.utils.Q02bConstantes.getString("ano.portada.2008");

		try {

			if (tr.isTraceActive()){     

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioSMAnu: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaCuestionarioSMAnu : " + mapaCuestionarioSM.toString());

			}

						//se pasa el hashmap de entrada a un objeto de tipo Q02bCuestionarioSMAnu	  		

			cuestionarioSMAnu = (Q02bCuestionarioSM) Q02bVoUtils.getValueObject(mapaCuestionarioSM,"q02b.exe.cuestionariosSMAnu.valueobjects.Q02bCuestionarioSM");

			//se instancia el bean de negocio

	  		

	  		//En caso de que vengamos de la portada, el campo niGrupoCuesSMAnu del mapa 

	  		//no va a tener ningn valor

	  		//Puede que est en el contexto (en caso de que estemos haciendo altas para los mismo parmetros de portada)

	  		//o  no, en cuyo caso lo tendremos que obtener

	  		cuestionarioSMFiltroPortada = (Q02bCuestionarioSMFiltro) Q02bVoUtils.getValueObject(mapaFiltroPortadaCuestionarioSM,"q02b.exe.cuestionariosSMAnu.valueobjects.Q02bCuestionarioSMFiltro");

  			if(cuestionarioSMFiltroPortada.getAno().equals(anoPortada2008)){

  				es2008=true;
            }
	  		

	  		if(Q02bFormatData.esNullSinCero(cuestionarioSMAnu.getNiGrupoCuesSMAnu()).equals("")){ 

	  			niGrupoCuesSM = this.altaModifGrupoCuestionariosSMAnu(cuestionarioSMFiltroPortada);

	  			cuestionarioSMAnu.setNiGrupoCuesSMAnu(niGrupoCuesSM);

	  		}

	  		else{ niGrupoCuesSM = cuestionarioSMAnu.getNiGrupoCuesSMAnu();}

	  		//Miramos si hay que modificar la previsin del suelo

	  		//Si el campo tiene valor 1, habr que modificar el campo de la BD con el valor que tenga el campo prevSuelo

	  		//Si el campo tiene valor 0, habr que borrar los cuestionarios rellenados anteriormente y modificar el campo de la BD con el valor que tenga el campo prevSuelo

	  		if(cuestionarioSMFiltroPortada!= null && Q02bFormatData.esNullSinCero(cuestionarioSMFiltroPortada.getModificarPrevSuelo()).equals("1") && (!es2008 || (es2008 && cuestionarioSMFiltroPortada.getPrevSuelo().equals("1")) )){

	  			this.modificarGrupoCuestionariosSM(niGrupoCuesSM,cuestionarioSMFiltroPortada.getPrevSuelo(),cuestionarioSMFiltroPortada.getMes(), cuestionarioSMFiltroPortada.getObsSuelo());

	  		}

	  		//se llama al mtodo del bean necesario

	  		niCuestionarioSMAnu= this.insertarCuestionarioSMAnu(cuestionarioSMAnu);

	  		//Actualizamos el campo de nmero de cuestionarios de la tabla de grupo

	  		this.actualizarNumCuestionariosRellenados(cuestionarioSMAnu.getNiGrupoCuesSMAnu());

	  		return niGrupoCuesSM;			

	     }catch(Exception ex){

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw); 

            if (tr.isTraceActive()){  

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarCuestionarioSMAnu: " + sw.getBuffer ().toString());

			}

            

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioSMAnu: saliendo");

			}			

		}

	} // fin insertarCuestionarioSMAnu

	

	

	

    /**

     * Funcin que inserta los datos del cuestionario de Suelo Municipal Anual pasada como parmetro en la BBDD

     * 

     * @param cuestionarioSMAnu - Datos del cuestionario a insertar

     * 

     * @throws Exception

     */

      public String insertarCuestionarioSMAnu(Q02bCuestionarioSM cuesSMAnu) throws Exception {   	 

    	//se crean objetos necesarios.

    	String niCuestionarioSMAnu = "";

    	boolean error = false;

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioSMAnu: entrando");

      		}

	  		//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoCuestionariosSMAnu = new Q02bCuestionariosSMDataBaseDAO(this.getConn());

//			se pasan los parmetros de usuario e idioma

			//daoCuestionariosSMAnu.setUser(this.autenticador.getUser());

			//daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());

			//se llamaa la metodo del DAO que realiza la insert

			niCuestionarioSMAnu = daoCuestionariosSMAnu.insertarCuestionarioSMAnu(cuesSMAnu);

			return niCuestionarioSMAnu;

    	}catch(Exception ex){

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarCuestionarioSMAnu: " + sw.getBuffer ().toString());

	        throw ex;                     

 	  }finally{

 		    try{

 		    	daoCuestionariosSMAnu.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarCuestionarioSMAnu: error liberando recursos");

	   	   	   }  

 		    }  		 

 		  	//se cierra la conexin  

 		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioSMAnu: saliendo.");

	   		}

 	  }

    }//fin insertarCuestionarioSMAnu 

    

    /**

     * Funcin que borra el cuestionario pasado como parmetro de la BBDD

     * 

     * @param niCuestionarioSMAnu - nmero interno del cuestionario a borrar

     * 

     * @throws Exception

     */

  public void borrarCuestionarioSMAnu(String niCuestionarioSMAnu,String niGrupoCuestionarioSMAnu) throws Exception {

         

	  	int numeroRegistros = 0;

    	if (tr.isTraceActive()){

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioSMAnu: entrando");

		}

    	 boolean error = false;

    	 try{

    		 //se abre la conexin

   			abrirConexion();

   			//se instancia el dao pasandole la conexin			

   			daoCuestionariosSMAnu = new Q02bCuestionariosSMDataBaseDAO(this.getConn());

			// Segmento tecnico 

   			//daoCuestionariosSMAnu.setUser(this.getAutenticador().getUser());

   			//daoCuestionariosSMAnu.setIdioma(this.getAutenticador().getIdioma()); 



   			//se comprueba el numero de cuestionarios que tiene el grupo de cuestionarios

   			numeroRegistros = daoCuestionariosSMAnu.getNumCuestionariosSM(niGrupoCuestionarioSMAnu);

   			if (numeroRegistros==1)

   				{

   					daoCuestionariosSMAnu.borrarCuestionarioSMAnu(niCuestionarioSMAnu,niGrupoCuestionarioSMAnu);

   					daoCuestionariosSMAnu.borrarGrupoCuestionarioSMAnu(niGrupoCuestionarioSMAnu);

   				}

   			else 

   				{

   					daoCuestionariosSMAnu.borrarCuestionarioSMAnu(niCuestionarioSMAnu,niGrupoCuestionarioSMAnu);

   				}

   		 	  

    	 }catch(Exception ex){

		  error= true;

          java.io.StringWriter sw = new java.io.StringWriter();

          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioSMAnu: " + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoCuestionariosSMAnu.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioSMAnu: error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioSMAnu: saliendo.");

	   		}

 	  }



    }//fin borrarCuestionarioSMAnu

    /**

     * Funcin que modifica los datos del cuestionario pasado como parmetro en la BBDD

     * 

     * @param cuestionarioSMAnu - Datos del cuestionario a modificar

     * 

     * @throws Exception

     */

   public void modificarCuestionarioSMAnu(Q02bCuestionarioSM cuestionarioSMAnu) throws Exception {

   	 if (tr.isTraceActive()){

  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioSMAnu: entrando");

  		}

   	 boolean error = false;

   	try{

   		//se abre la conexin

   		abrirConexion();

   		//se instancia el dao pasandole la conexin			

   		daoCuestionariosSMAnu = new Q02bCuestionariosSMDataBaseDAO(this.getConn());

			// Segmento tecnico 

			//daoCuestionariosSMAnu.setUser(this.getAutenticador().getUser());

			//daoCuestionariosSMAnu.setIdioma(this.getAutenticador().getIdioma()); 



   		//se llamaa la metodo del DAO que realiza la update

   		daoCuestionariosSMAnu.modificarCuestionarioSMAnu(cuestionarioSMAnu);

   		    	

   	}catch(Exception ex){

		  error= true;

         java.io.StringWriter sw = new java.io.StringWriter();

         java.io.PrintWriter pw = new java.io.PrintWriter(sw);

         ex.printStackTrace(pw);

         tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioSMAnu: " + sw.getBuffer ().toString());

         throw ex;                     

	  }finally{

		 try{

			daoCuestionariosSMAnu.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioSMAnu: error liberando recursos");

	   	   	   }  

		   }  		 

		  	//se cierra la conexin  

		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioSMAnu: saliendo.");

	   		}

	  }

   }





    /**

     * Mtodo que dado el nmero interno del cuestionario recuperar de la BBDD

     * los datos de dicho cuestionario.

     * @param niCuestionarioSMAnu

     * @return

     */

	public Q02bCuestionarioSM obtenerCuestionarioSMAnu(String niCuestionarioSMAnu,String niGrupoCuestionarioSMAnu)throws Exception{

			

	    	boolean error = false;

	    	Q02bCuestionarioSM cuestionarioSMAnu = null;

	  	  	try  	  {

	  	  		if (tr.isTraceActive()){

	  	  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioSMAnu, ** niCuestionarioSMAnu bean=" + niCuestionarioSMAnu + ", niGrupoCuestionarioSMAnu =" + niGrupoCuestionarioSMAnu+ " *** entrando");                

	  	  		}

	  	  		//se abre la conexin

	  	  		abrirConexion();

	  	  		//se instancia el dao pasandole la conexin			

	  	  		daoCuestionariosSMAnu = new Q02bCuestionariosSMDataBaseDAO(this.getConn());

	  	  		//Segmento tecnico 

	  			//daoCuestionariosSMAnu.setUser(this.getAutenticador().getUser());

	  			//daoCuestionariosSMAnu.setIdioma(this.getAutenticador().getIdioma()); 

	  	  		//se llama al mtodo del dao recupera el cuestionario

	  	  		cuestionarioSMAnu = daoCuestionariosSMAnu.obtenerCuestionarioSMAnu(niCuestionarioSMAnu,niGrupoCuestionarioSMAnu);

	  	  		//se devuelve el cuestionario recuperado

	  	  		return cuestionarioSMAnu;

	  	  }catch(Exception ex){

	  		  	error= true;

	  		  	java.io.StringWriter sw = new java.io.StringWriter();

	          	java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          	ex.printStackTrace(pw);

	          	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioSMAnu: " + sw.getBuffer ().toString());

	          	throw ex;                     

	 	  }finally{

	 		  	try{

	 		  		daoCuestionariosSMAnu.freeResourcesNotConnection();

	 		  	}catch(Exception ex){

				   if (tr.isTraceActive()){

					   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioSMAnu: error liberando recursos");

		   	   	   }  

	 		  	}  		 

	 		  	//se cierra la conexin  

	 		  	cerrarConexion(error);	       	

		        if (tr.isTraceActive()){

		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioSMAnu: saliendo.");

		   		}

	 	  }

	    }//fin obtenerCuestionarioSMAnu

	    

	    

	    

     /**

     * Funcin que inserta/modifica los datos del grupo de cuestionarios de Suelo Municipal a partir de los Datos Contenidos en el filtro

     * 

     * @param cuestionarioSMAnuFiltro - Datos del grupo de cuestionarios a insertar

     * 

     * @throws Exception

     */

    public String altaModifGrupoCuestionariosSMAnu(Q02bCuestionarioSMFiltro cuesSMAnuFiltro) throws Exception {   	 

    	//se crean objetos necesarios.

    	//Q02bCuestionarioSMAnuFiltro grupoCuestionarioSMAnuConNi = null;

    	String niGrupoCuesSMAnu = null;

    	boolean error = false;

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: entrando");

      		}

	  		//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoCuestionariosSMAnu = new Q02bCuestionariosSMDataBaseDAO(this.getConn());

//			se pasan los parmetros de usuario e idioma

			//daoCuestionariosSMAnu.setUser(this.autenticador.getUser());

			//daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());

			//se llamaa la metodo del DAO que realiza la insert

			

			niGrupoCuesSMAnu =daoCuestionariosSMAnu.altaModifGrupoCuestionariosSMAnu(cuesSMAnuFiltro);

			return niGrupoCuesSMAnu;

			

    	}catch(Exception ex){

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: " + sw.getBuffer ().toString());

	        throw ex;                     

 	  }finally{

 		    try{

 		    	daoCuestionariosSMAnu.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: error liberando recursos");

	   	   	   }  

 		    }  		 

 		  	//se cierra la conexin  

 		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioSMAnu: saliendo.");

	   		}

 	  }

    }//fin altaModifGrupoCuestionariosSMAnu

    

    /**

     * Funcin que obtiene los  aos para el municipio y ano seleccionados, en los que no se han introducido cuestionarios

     * 

     * @param codProv , codMuni, ano, idioma

     * 

     * @throws Exception

     */

    public String obtenerAnosMesesPendientes(String codProv,String codMuni,String ano,String idioma) throws Exception {   	 

	boolean error = false;

    	String msgAnos = null;

    	

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientes: entrando");

      		}

	  		//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoCuestionariosSMAnu = new Q02bCuestionariosSMDataBaseDAO(this.getConn());

//			se pasan los parmetros de usuario e idioma

			//daoCuestionariosSMAnu.setUser(this.autenticador.getUser());

			//daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());

			//se llamaa la metodo del DAO que realiza la insert

			msgAnos =daoCuestionariosSMAnu.obtenerAnosMesesPendientesParaMuni(codProv,codMuni,ano,idioma);

			return msgAnos;

			

    	}catch(Exception ex){

	 		error= true;

	        		java.io.StringWriter sw = new java.io.StringWriter();

	        		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        		ex.printStackTrace(pw);

	        		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAnosPendientes: " + sw.getBuffer ().toString());

	        		throw ex;                     

 	  }finally{

 		    try{

 		    	daoCuestionariosSMAnu.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAnosPendientes: error liberando recursos");

	   	   	   }  

 		    }  		 

 		    //se cierra la conexin  

 		    cerrarConexion(error);	       	

	        	   if (tr.isTraceActive())

	        	   {

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientes: saliendo.");

	   	  }

 	  }

    }//fin obtenerAnosPendientes

    

     

    /**

     * Funcin que obtiene el campo Prevision Suelo  para el municipio y ano seleccionados

     * 

     * @param codProv , codMuni, ano

     * 

     * @throws Exception

     */

    public String obtenerCampoPrevSueloDeGrupoConMuniAno(String codProv,String codMuni,String ano, String mes, String tipoCuestionario) throws Exception {   	 

	boolean error = false;

    	

    	try{

    		if (tr.isTraceActive())

    		{

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoPrevSueloDeGrupoConMuniAno: entrando");

      		}

	  		//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoCuestionariosSMAnu = new Q02bCuestionariosSMDataBaseDAO(this.getConn());

//			se pasan los parmetros de usuario e idioma

			//daoCuestionariosSMAnu.setUser(this.autenticador.getUser());

			//daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());

			//se llamaa la metodo del DAO que realiza la insert

			return daoCuestionariosSMAnu.obtenerCampoPrevSueloDeGrupoConMuniAno(codProv,codMuni,ano, mes, tipoCuestionario);

			

			

    	}catch(Exception ex){

	 		error= true;

	        		java.io.StringWriter sw = new java.io.StringWriter();

	        		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        		ex.printStackTrace(pw);

	        		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoPrevSueloDeGrupoConMuniAno: " + sw.getBuffer ().toString());

	        		throw ex;                     

 	  }finally{

 		    try{

 		    	daoCuestionariosSMAnu.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoPrevSueloDeGrupoConMuniAno: error liberando recursos");

	   	   	   }  

 		    }  		 

 		    //se cierra la conexin  

 		    cerrarConexion(error);	       	

	        	   if (tr.isTraceActive())

	        	   {

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoPrevSueloDeGrupoConMuniAno: saliendo.");

	   	  }

 	  }

    }//fin obtenerCampoPrevSueloDeGrupoConMuniAno

    

        /**Metodo que se encarga de devolver un XML con los datos principales de los cuestionarios a firmar que no estn ya firmados.

	* @param ArrayList ArrayList arrCuestionariosSMAnuFirma

	* @throws Exception

       */

    /*

   public Document obtenerXmlFirmaCuestionariosSMAnu(ArrayList arrCuestionariosSMAnuFirma ) throws Exception{

        //Definicion de constantes

        final String TRACE_METODO = nombreClaseSinPackage +":obtenerXmlFirmaCuestionariosSMAnu:";



        //Variable que indica si se ha producido un error

        boolean error = false;

        

        Document docCuestionariosSMAnuFirmar = null;

        Q02bCuestionarioSM cuestionarioSMAnuBD = null;

        

        if (tr.isTraceActive()) 

        {

            	tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": entrando");

            	tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +": ArrayList ="+ (arrCuestionariosSMAnuFirma==null?"Es nulo":Integer.toString(arrCuestionariosSMAnuFirma.size())));

        }

        try {

        	if(arrCuestionariosSMAnuFirma !=null)

        	{

        		

        		Q02bXMLBuilder xml = new Q02bXMLBuilder();

            		Element document = xml.createTag("DOCUMENT");

        		for(int i =0;i<arrCuestionariosSMAnuFirma.size();i++)

        		{

        			cuestionarioSMAnuBD = (Q02bCuestionarioSM)arrCuestionariosSMAnuFirma.get(i);

        			//MODIFICACION -> Se firman todos otra vez

        			//Slo se van a firmar los que no estn ya firmados

        			//tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": Fec. Firma del elemento  "+ i + "=" +cuestionarioSMAnuBD.getFecFirma() );

        			//if(Q02bFormatData.esVacio(cuestionarioSMAnuBD.getFecFirma()))

        			//{

	        			//tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": Se genera XML del elemento "+ i);

	        			Element cuestionario = xml.createTag("CUESTIONARIO");

	                    			xml.addChild(document, cuestionario);

	                    			xml.addChild(cuestionario, xml.createTag("IDEN_LICEN",cuestionarioSMAnuBD.getIdenLicen() , true));

	                    			xml.addChild(cuestionario, xml.createTag("LOCAL_OBRA",cuestionarioSMAnuBD.getLocalObra(), true));

	                    			xml.addChild(cuestionario, xml.createTag("SUPERFICIE_SUELO", cuestionarioSMAnuBD.getSupSueloT(), true));

	                    		//}

        		}

        		xml.setRootTag(document);

        		

        		

        		docCuestionariosSMAnuFirmar= xml.getDocument();

        		

        	}

        	//Se devuelve el document

        	return docCuestionariosSMAnuFirmar;

        }

        catch (Exception ex) 

        {

	            error = true;

	            java.io.StringWriter sw = new java.io.StringWriter();

	            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	            ex.printStackTrace(pw);

	            tr.trace(COMPONENTE, Q70TraceLevel.ERROR,

	                TRACE_METODO + ": " + sw.getBuffer().toString());

	            throw ex;

        } 

    }

    */

    /**

     * Funcin que inserta la firma del grupo de cuestionarios de Ayuntamientos Mensual pasada como parmetro

     * 

     * @param niGrupoCuesSMAnu - Ni del grupo de cuestionarios

     * @param xmlFirmaGrupoCuestionariosSMAnu - Firma del grupo de cuestionarios

     * 

     * @throws Exception  

     */

    public void guardarFirmaGrupoCuestionariosSMAnu(String niGrupoCuesSMAnu,String xmlFirmaGrupoCuestionariosSMAnu) throws Exception {   	 

    	boolean error = false;

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosSMAnu: entrando");

      		}

  		//se abre la conexin

		abrirConexion();

		//se instancia el dao pasandole la conexin			

		daoCuestionariosSMAnu = new Q02bCuestionariosSMDataBaseDAO(this.getConn());

//		se pasan los parmetros de usuario e idioma

		//daoCuestionariosSMAnu.setUser(this.autenticador.getUser());

		//daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());

		//se llamaa la metodo del DAO que realiza las modificaciones en la base de datos

		daoCuestionariosSMAnu.guardarFirmaGrupoCuestionariosSMAnu(niGrupoCuesSMAnu,xmlFirmaGrupoCuestionariosSMAnu);

    	}catch(Exception ex){

	 	 error= true;

		 java.io.StringWriter sw = new java.io.StringWriter();

		 java.io.PrintWriter pw = new java.io.PrintWriter(sw);

		 ex.printStackTrace(pw);

		 tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosSMAnu: " + sw.getBuffer ().toString());

		  throw ex;                     

 	  }finally{

 		    try{

 		    	daoCuestionariosSMAnu.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosSMAnu: error liberando recursos");

	   	   	   }  

 		    }  		 

 		  	

 		  //se cierra la conexin  

 		 cerrarConexion(error);	       	

	        	if (tr.isTraceActive())

	        	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosSMAnu: saliendo.");

	   	}

 	  }

    }//fin guardarFirmaGrupoCuestionariosSMAnu

    

    public boolean obtenerNumCuestionarios(String codProv,String codMuni,String ano,String mes, String tipoCuestionario) throws Exception {   	 

    	boolean error = false;

        	

        	try{

        		if (tr.isTraceActive())

        		{

          			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNumCuestionarios: entrando");

          		}

    	  		//se abre la conexin

    			abrirConexion();

    			//se instancia el dao pasandole la conexin			

    			daoCuestionariosSMAnu = new Q02bCuestionariosSMDataBaseDAO(this.getConn());

    			//se pasan los parmetros de usuario e idioma

    			//daoCuestionariosAyunMen.setUser(this.autenticador.getUser());

    			//daoCuestionariosAyunMen.setIdioma(this.autenticador.getIdioma());

    			//se llamaa la metodo del DAO que realiza la insert

    			return daoCuestionariosSMAnu.obtenerNumCuestionarios(codProv,codMuni,ano,mes,tipoCuestionario);

    			

    			

        	}catch(Exception ex){

    	 		error= true;

    	        		java.io.StringWriter sw = new java.io.StringWriter();

    	        		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

    	        		ex.printStackTrace(pw);

    	        		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerNumCuestionarios: " + sw.getBuffer ().toString());

    	        		throw ex;                     

     	  }finally{

     		    try{

     		    	daoCuestionariosSMAnu.freeResourcesNotConnection();

     		    }catch(Exception ex){

    			   if (tr.isTraceActive()){

    				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerNumCuestionarios: error liberando recursos");

    	   	   	   }  

     		    }  		 

     		    //se cierra la conexin  

     		    cerrarConexion(error);	       	

    	        	   if (tr.isTraceActive())

    	        	   {

    	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNumCuestionarios: saliendo.");

    	   	  }

     	  }

        }//fin obtenerNumCuestionarios

    

    /**

     * Funcin que actualiza el nmero de cuestionarios rellenados de Suelo Municipal 

     * 

     * @param cuestionarioSMAnu - Datos del cuestionario a actualizar

     * 

     * @throws Exception

     */

      public int actualizarNumCuestionariosRellenados(String niGrupoCuesSMAnu) throws Exception {   	 

    	//se crean objetos necesarios.

    	int numCuestionarios = 0;

    	boolean error = false;

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":actualizarNumCuestionariosRellenados: entrando");

      		}

	  		//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoCuestionariosSMAnu = new Q02bCuestionariosSMDataBaseDAO(this.getConn());

//			se pasan los parmetros de usuario e idioma

			//daoCuestionariosSMAnu.setUser(this.autenticador.getUser());

			//daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());

			//se llamaa la metodo del DAO que realiza la insert

			numCuestionarios = daoCuestionariosSMAnu.actualizarNumCuestionariosRellenados(niGrupoCuesSMAnu);

			return numCuestionarios;

    	}catch(Exception ex){

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":actualizarNumCuestionariosRellenados: " + sw.getBuffer ().toString());

	        throw ex;                     

 	  }finally{

 		    try{

 		    	daoCuestionariosSMAnu.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":actualizarNumCuestionariosRellenados: error liberando recursos");

	   	   	   }  

 		    }  		 

 		  	//se cierra la conexin  

 		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":actualizarNumCuestionariosRellenados: saliendo.");

	   		}

 	  }

    }//fin actualizarNumCuestionariosRellenados 

      

      

      /**

       * Funcin que modifica el campo Q22CT00_REALIZA_ACTUACION  

       * 

       * @param niGrupoCuesSM  - el ni del grupo a modificar

       * @param valorPrevSuelo - nuevo valor del campo

       * @param mes - mes del grupo de cuestionarios 

       * 

       * @throws Exception

       */

        public void modificarGrupoCuestionariosSM(String niGrupoCuesSM, String valorPrevSuelo, String mes, String obs) throws Exception {   	 

        	boolean error = false;

        	try{

      		if (tr.isTraceActive()){

        			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarGrupoCuestionariosSM: entrando");

        		}

  	  		//se abre la conexin

  			abrirConexion();

  			//se instancia el dao pasandole la conexin			

  			daoCuestionariosSMAnu = new Q02bCuestionariosSMDataBaseDAO(this.getConn());

//  			se pasan los parmetros de usuario e idioma

  			//daoCuestionariosSMAnu.setUser(this.autenticador.getUser());

  			//daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());

  			//se llamaa la metodo del DAO que realiza la insert

  			daoCuestionariosSMAnu.modificarGrupoCuestionariosSM(niGrupoCuesSM,valorPrevSuelo,mes,obs);

  	  	}catch(Exception ex){

  	 		error= true;

  	        java.io.StringWriter sw = new java.io.StringWriter();

  	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

  	        ex.printStackTrace(pw);

  	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarGrupoCuestionariosSM: " + sw.getBuffer ().toString());

  	        throw ex;                     

   	  }finally{

   		    try{

   		    	daoCuestionariosSMAnu.freeResourcesNotConnection();

   		    }catch(Exception ex){

  			   if (tr.isTraceActive()){

  				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarGrupoCuestionariosSM: error liberando recursos");

  	   	   	   }  

   		    }  		 

   		  	//se cierra la conexin  

   		    cerrarConexion(error);	       	

  	        if (tr.isTraceActive()){

  	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarGrupoCuestionariosSM: saliendo.");

  	   		}

   	  }

      }//fin modificarGrupoCuestionariosSM 

        

        

        /**

         * Funcin que recupera el nmero de cuestionarios de SM 

         * 

         * @param cuestionarioSMAnu - Datos del cuestionario a actualizar

         * 

         * @throws Exception

         */

          public int getNumCuestionariosPortada(String territorio, String municipio, String anyoReferencia,String mesReferencia) throws Exception {   	 

        	//se crean objetos necesarios.

        	int numCuestionariosSM=0;	        	         

        	boolean error = false;

        	

        	try{

        		 

        		if (tr.isTraceActive()){

          			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortada: entrando");

          		}

    	  		//se abre la conexin

    			abrirConexion();

    			//se instancia el dao pasandole la conexin			

    			daoCuestionariosSMAnu = new Q02bCuestionariosSMDataBaseDAO(this.getConn());

    			

    			numCuestionariosSM = daoCuestionariosSMAnu.getNumCuestionariosSM(territorio, municipio, anyoReferencia, mesReferencia);

    			    			   			

    			return numCuestionariosSM;

        	}catch(Exception ex){

    	 		error= true;

    	        java.io.StringWriter sw = new java.io.StringWriter();

    	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

    	        ex.printStackTrace(pw);

    	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: " + sw.getBuffer ().toString());

    	        throw ex;                     

     	  }finally{

     		    try{

     		    	daoCuestionariosSMAnu.freeResourcesNotConnection();

     		    }catch(Exception ex){

    			   if (tr.isTraceActive()){

    				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: error liberando recursos");

    	   	   	   }  

     		    }  		 

     		  	//se cierra la conexin  

     		    cerrarConexion(error);	       	

    	        if (tr.isTraceActive()){

    	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortada: saliendo.");

    	   		}

     	  }

        }//fin getNumCuestionariosPortada 

        

          public String getPrevisionGrupoCuesSM(String territorio, String municipio, String anyoReferencia,String mesReferencia) throws Exception {   	 

          	//se crean objetos necesarios.

          	String prevSueloInicial="";	        	         

          	boolean error = false;

          	

          	try{

          		 

          		if (tr.isTraceActive()){

            			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortada: entrando");

            		}

      	  		//se abre la conexin

      			abrirConexion();

      			//se instancia el dao pasandole la conexin			

      			daoCuestionariosSMAnu = new Q02bCuestionariosSMDataBaseDAO(this.getConn());

      			

      			prevSueloInicial = daoCuestionariosSMAnu.getPrevisionGrupoCuesSM(territorio, municipio, anyoReferencia, mesReferencia);

      			    			   			

      			return prevSueloInicial;

          	}catch(Exception ex){

      	 		error= true;

      	        java.io.StringWriter sw = new java.io.StringWriter();

      	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

      	        ex.printStackTrace(pw);

      	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: " + sw.getBuffer ().toString());

      	        throw ex;                     

       	  }finally{

       		    try{

       		    	daoCuestionariosSMAnu.freeResourcesNotConnection();

       		    }catch(Exception ex){

      			   if (tr.isTraceActive()){

      				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: error liberando recursos");

      	   	   	   }  

       		    }  		 

       		  	//se cierra la conexin  

       		    cerrarConexion(error);	       	

      	        if (tr.isTraceActive()){

      	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortada: saliendo.");

      	   		}

       	  }

          } 

          

          

          /**

           * Funcin que eliminar grupo y cuestionarios de suelo de las tabla Q022CT00 y Q022ET00   

           * 

           * @param ano  - ano (que ser 2008)

           * @param codProvincia - provincia

           * @param codMunicipio - municipio 

           * 

           * @throws Exception

           */

            public void eliminarCuestionariosSM(String ano, String codProvincia, String codMunicipio) throws Exception {   	 

            	boolean error = false;

            	try{

          		if (tr.isTraceActive()){

            			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":eliminarCuestionariosSM: entrando");

            		}

      	  		//se abre la conexin

      			abrirConexion();

      			//se instancia el dao pasandole la conexin			

      			daoCuestionariosSMAnu = new Q02bCuestionariosSMDataBaseDAO(this.getConn());

//      			se pasan los parmetros de usuario e idioma

      			//daoCuestionariosSMAnu.setUser(this.autenticador.getUser());

      			//daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());

      			//se llamaa la metodo del DAO que realiza la insert

      			daoCuestionariosSMAnu.eliminarCuestionariosSM(ano, codProvincia, codMunicipio);

      	  	}catch(Exception ex){

      	 		error= true;

      	        java.io.StringWriter sw = new java.io.StringWriter();

      	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

      	        ex.printStackTrace(pw);

      	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":eliminarCuestionariosSM: " + sw.getBuffer ().toString());

      	        throw ex;                     

       	  }finally{

       		    try{

       		    	daoCuestionariosSMAnu.freeResourcesNotConnection();

       		    }catch(Exception ex){

      			   if (tr.isTraceActive()){

      				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":eliminarCuestionariosSM: error liberando recursos");

      	   	   	   }  

       		    }  		 

       		  	//se cierra la conexin  

       		    cerrarConexion(error);	       	

      	        if (tr.isTraceActive()){

      	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarGrupoCuestionariosSM: saliendo.");

      	   		}

       	  }

          }//fin eliminarCuestionariosSM 

          

        public String getNiGrupoCuesSM(String territorio, String municipio, String anyoReferencia, String mesReferencia) throws Exception

        {

        	String niGrupoCuesSMAnu = "";

        	boolean error = false;

            {          	              	

          	try{

          		 

          		if (tr.isTraceActive()){

            			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNiGrupoCuesSM: entrando");

            		}

      	  		//se abre la conexin

      			abrirConexion();

      			//se instancia el dao pasandole la conexin			

      			daoCuestionariosSMAnu = new Q02bCuestionariosSMDataBaseDAO(this.getConn());

      			

      			niGrupoCuesSMAnu = daoCuestionariosSMAnu.getNiGrupoCuesSM(territorio, municipio, anyoReferencia, mesReferencia);

      			    			   			

      			return niGrupoCuesSMAnu;

          	}catch(Exception ex){

      	 		error= true;

      	        java.io.StringWriter sw = new java.io.StringWriter();

      	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

      	        ex.printStackTrace(pw);

      	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNiGrupoCuesSM: " + sw.getBuffer ().toString());

      	        throw ex;                     

       	    }finally{

       		    try{

       		    	daoCuestionariosSMAnu.freeResourcesNotConnection();

       		    }catch(Exception ex){

      			   if (tr.isTraceActive()){

      				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNiGrupoCuesSM: error liberando recursos");

      	   	   	   }  

       		    }  		 

       		  	//se cierra la conexin  

       		    cerrarConexion(error);	       	

      	        if (tr.isTraceActive()){

      	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNiGrupoCuesSM: saliendo.");

      	   		}

       	    }  	

            }

        }//fin getNiGRupoCuesSM

        

        

        

        /**

    	 * Insertar/Modifica en bbdd un  nuevo grupo de cuestionarios con los datos pasados como parmetro en la HashMap de filtro

    	 */

    	public String altaModifGrupoCuestionariosSMAnu(HashMap mapaCuestionarioSMAnuFiltro) throws Exception 

    	{

    		Q02bCuestionarioSMFiltro cuestionarioSMFiltro = null;

    		String niGrupoCuesSMAnu=null;	

    		//boolean es2008=false;

    		String anoPortada2008=null;

    		try {

    			if (tr.isTraceActive()){

    				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: entrando");

    			}

    			//se pasa el hashmap de entrada a un objeto de tipo Q02bCuestionarioSMAnu	  		

    			cuestionarioSMFiltro = (Q02bCuestionarioSMFiltro) Q02bVoUtils.getValueObject(mapaCuestionarioSMAnuFiltro,"q02b.exe.cuestionariosSMAnu.valueobjects.Q02bCuestionarioSMFiltro");

    			//se instancia el bean de negocio

    	  		anoPortada2008 = q02b.exe.utils.Q02bConstantes.getString("ano.portada.2008");



    	  		//Antes de todo, vamos a comprobar el siguiente caso: se han rellenado cuestionarios de suelo del 2008

    		    //y ahora, el usuario, ha seleccionado que NO en la portada (donde no tenemos ell mes) y ha pulsado a Finalizar Cuestionario

    		    //es decir, despues de haber rellenado cuestionarios para uno o varios meses, ahora dice que no se ha concedido ninguna licencia

    		    //En este caso, deberemos borrar todos los cuestionarios (y sus grupos) y crear despus un grupo con prevSuelo==0 y sin mes

    	  		if(cuestionarioSMFiltro!= null && cuestionarioSMFiltro.getAno().equals(anoPortada2008) && Q02bFormatData.esNullSinCero(cuestionarioSMFiltro.getModificarPrevSuelo()).equals("1") && cuestionarioSMFiltro.getPrevSuelo().equals("0")){

    	  			//es2008=true;	

    	  			this.eliminarCuestionariosSM(cuestionarioSMFiltro.getAno(),cuestionarioSMFiltro.getCodProv(), cuestionarioSMFiltro.getCodMuni());

    	  		}

    	  		niGrupoCuesSMAnu=this.altaModifGrupoCuestionariosSMAnu(cuestionarioSMFiltro);

    	  		

    	  		if(cuestionarioSMFiltro!= null && Q02bFormatData.esNullSinCero(cuestionarioSMFiltro.getModificarPrevSuelo()).equals("1")){

    	  			this.modificarGrupoCuestionariosSM(niGrupoCuesSMAnu,cuestionarioSMFiltro.getPrevSuelo(),cuestionarioSMFiltro.getMes(), cuestionarioSMFiltro.getObsSuelo());

    	  		}

    	  		

    	  		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: niGrupoCuestionarioSMAnu="+ niGrupoCuesSMAnu);

    			return niGrupoCuesSMAnu;			

    	     }catch(Exception ex){

                java.io.StringWriter sw = new java.io.StringWriter();

                java.io.PrintWriter pw = new java.io.PrintWriter(sw);

                ex.printStackTrace(pw); 

                if (tr.isTraceActive()){  

    				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: " + sw.getBuffer ().toString());

    			}

                

                throw ex;

    		 }finally{

    			 if (tr.isTraceActive()){

    					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: saliendo");

    			}			

    		}

    	} // fin altaModifGrupoCuestionariosSMAnu

}