package q02b.exe.cuestionarioVAPM.beans;



import java.util.ArrayList;

import java.util.HashMap;



import q02b.exe.arquitectura.beans.Q02bBaseBean;

import q02b.exe.cuestionarioVAPM.dataobjects.Q02bCuestionarioVAPMDataBaseDAO;

import q02b.exe.cuestionarioVAPM.valueobjects.Q02bCuestionarioVAPM;

import q02b.exe.cuestionarioVAPM.valueobjects.Q02bCuestionarioVAPMFiltro;

//import q02b.exe.cuestionariosSMAnu.dataobjects.Q02bCuestionariosSMDataBaseDAO;

//import q02b.exe.cuestionariosSMAnu.valueobjects.Q02bCuestionarioSM;

//import q02b.exe.cuestionariosSMAnu.valueobjects.Q02bCuestionarioSMFiltro;

//import q02b.exe.cuestionariosVTMAnu.dataobjects.Q02bCuestionariosVTMAnuDataBaseDAO;

//import q02b.exe.cuestionariosVTMAnu.valueobjects.Q02bCuestionarioVTMAnu;

//import q02b.exe.cuestionariosVTMAnu.valueobjects.Q02bCuestionarioVTMAnuFiltro;

//import q02b.exe.utils.Q02bConstantes;

//import q02b.exe.utils.Q02bFormatData;

import q02b.exe.utils.Q02bVoUtils;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

//import q02b.exe.arquitectura.utils.xml.Q02bXMLBuilder;

//import org.w3c.dom.Document;

//import org.w3c.dom.Element;

//import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;



   

public class Q02bCuestionarioVAPMBean extends Q02bBaseBean{

	private static final long serialVersionUID = 5474311672836163390L;

	protected Q02bCuestionarioVAPMDataBaseDAO daoCuestionarioVAPM = null;

	final static String	CUESTIONARIO_VAPM = "cuestionarioVAPM";

	//Q70ContextoEJIE q70contextoejie = (Q70ContextoEJIE)request.getSession().getAttribute("contexto");

	//ArrayList listaCues= (ArrayList)q70contextoejie.get("listaCuestionariosSMAnu");

	 /** Constructor vacio */

    public Q02bCuestionarioVAPMBean() {

        super();

    }

        



     

    /**

     * Funcin que obtiene el campo Prevision Suelo  para el municipio y ano seleccionados

     * 

     * @param codProv , codMuni, ano

     * 

     * @throws Exception

     */

    public String obtenerCampoConcedeLicenDeGrupoConMuniAno(String codProv,String codMuni,String ano) throws Exception {   	 

	boolean error = false;

    	

    	try{

    		if (tr.isTraceActive())

    		{

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoConcedeLicenDeGrupoConMuniAno: entrando");

      		}

	  		//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoCuestionarioVAPM = new Q02bCuestionarioVAPMDataBaseDAO(this.getConn());

//			se pasan los parmetros de usuario e idioma

			//daoCuestionariosSMAnu.setUser(this.autenticador.getUser());

			//daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());

			//se llamaa la metodo del DAO que realiza la insert

			return daoCuestionarioVAPM.obtenerCampoConcedeLicenDeGrupoConMuniAno(codProv,codMuni,ano);

			

			

    	}catch(Exception ex){

	 		error= true;

	        		java.io.StringWriter sw = new java.io.StringWriter();

	        		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        		ex.printStackTrace(pw);

	        		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoConcedeLicenDeGrupoConMuniAno: " + sw.getBuffer ().toString());

	        		throw ex;                     

 	  }finally{

 		    try{

 		    	daoCuestionarioVAPM.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoConcedeLicenDeGrupoConMuniAno: error liberando recursos");

	   	   	   }  

 		    }  		 

 		    //se cierra la conexin  

 		    cerrarConexion(error);	       	

	        	   if (tr.isTraceActive())

	        	   {

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoConcedeLicenDeGrupoConMuniAno: saliendo.");

	   	  }

 	  }

    }//fin obtenerCampoConcedeLicenDeGrupoConMuniAno

    

    

    /**

     * Funcin que obtiene los  aos para el municipio y ano seleccionados, en los que no se han introducido cuestionarios

     * 

     * @param codProv , codMuni, ano, idioma

     * 

     * @throws Exception

     */

    public String obtenerAnosPendientes(String codProv,String codMuni,String ano,String idioma) throws Exception {   	 

	boolean error = false;

    	String msgAnos = null;

    	

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientes: entrando");

      		}

	  		//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoCuestionarioVAPM = new Q02bCuestionarioVAPMDataBaseDAO(this.getConn());

//			se pasan los parmetros de usuario e idioma

			//daoCuestionariosSMAnu.setUser(this.autenticador.getUser());

			//daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());

			//se llamaa la metodo del DAO que realiza la insert

			msgAnos =daoCuestionarioVAPM.obtenerAnosPendientesParaMuni(codProv,codMuni,ano,idioma);

			return msgAnos;

			

    	}catch(Exception ex){

	 		error= true;

	        		java.io.StringWriter sw = new java.io.StringWriter();

	        		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        		ex.printStackTrace(pw);

	        		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAnosPendientes: " + sw.getBuffer ().toString());

	        		throw ex;                     

 	  }finally{

 		    try{

 		    	daoCuestionarioVAPM.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAnosPendientes: error liberando recursos");

	   	   	   }  

 		    }  		 

 		    //se cierra la conexin  

 		    cerrarConexion(error);	       	

	        	   if (tr.isTraceActive())

	        	   {

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientes: saliendo.");

	   	  }

 	  }

    }//fin obtenerAnosPendientes

    

    

    

    /**

     * Funcin que inserta/modifica los datos del grupo de cuestionarios de Suelo Municipal a partir de los Datos Contenidos en el filtro

     * 

     * @param cuestionarioSMAnuFiltro - Datos del grupo de cuestionarios a insertar

     * 

     * @throws Exception

     */

    public Q02bCuestionarioVAPM altaModifCuestionarioVAPM(String niCuesVAPM,Q02bCuestionarioVAPMFiltro cuesVAPMFiltro ) throws Exception {   	 

    	//se crean objetos necesarios.

    	

    	Q02bCuestionarioVAPM cuestionarioVAPM= new Q02bCuestionarioVAPM();

    	

    	boolean error = false;

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifCuestionarioVAPM: entrando");

      		}

	  		//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoCuestionarioVAPM = new Q02bCuestionarioVAPMDataBaseDAO(this.getConn());

			//se pasan los parmetros de usuario e idioma

			//daoCuestionariosSMAnu.setUser(this.autenticador.getUser());

			//daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());

			//se llamaa la metodo del DAO que realiza la insert

			cuestionarioVAPM =daoCuestionarioVAPM.altaModifCuestionarioVAPM(niCuesVAPM,cuesVAPMFiltro);

			return cuestionarioVAPM;

			

    	}catch(Exception ex){

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifCuestionarioVAPM: " + sw.getBuffer ().toString());

	        throw ex;                     

 	  }finally{

 		    try{

 		    	daoCuestionarioVAPM.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifCuestionarioVAPM: error liberando recursos");

	   	   	   }  

 		    }  		 

 		  	//se cierra la conexin  

 		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifCuestionarioVAPM: saliendo.");

	   		}

 	  }

    }//fin altaModifCuestionarioVAPM

    

    /**

     * Funcin que modifica los datos del cuestionario pasado como parmetro en la BBDD

     * 

     * @param cuestionarioVAPM - Datos del cuestionario a modificar

     * 

     * @throws Exception

     */

   public void modificarCuestionarioVAPM(Q02bCuestionarioVAPM cuestionarioVAPM, String ano, String codMunicip, String concedeLicen, String codProv, String niCuesVAPM) throws Exception {

   	 if (tr.isTraceActive()){

  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVAPM: entrando");

  		}

   	 boolean error = false;

   	try{

   		//se abre la conexin

   		abrirConexion();

   		//se instancia el dao pasandole la conexin			

   		daoCuestionarioVAPM = new Q02bCuestionarioVAPMDataBaseDAO(this.getConn());

			// Segmento tecnico 

			//daoCuestionariosSMAnu.setUser(this.getAutenticador().getUser());

			//daoCuestionariosSMAnu.setIdioma(this.getAutenticador().getIdioma()); 



   		//se llamaa la metodo del DAO que realiza la update

   		daoCuestionarioVAPM.modificarCuestionarioVAPM(cuestionarioVAPM, ano, codMunicip, concedeLicen, codProv, niCuesVAPM);

   		    	

   	}catch(Exception ex){

		  error= true;

         java.io.StringWriter sw = new java.io.StringWriter();

         java.io.PrintWriter pw = new java.io.PrintWriter(sw);

         ex.printStackTrace(pw);

         tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVAPM: " + sw.getBuffer ().toString());

         throw ex;                     

	  }finally{

		 try{

			daoCuestionarioVAPM.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVAPM: error liberando recursos");

	   	   	   }  

		   }  		 

		  	//se cierra la conexin  

		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVAPM: saliendo.");

	   		}

	  }

   }

   

   /**

    * Funcin que devuelve el niCuesVAPM a partir de los datos  en el filtro

    * 

    * @param cuestionarioVAPMFiltro - Datos del grupo de cuestionarios a insertar

    * 

    * @throws Exception

    */

   public String obtenerNiCuesVAPM(Q02bCuestionarioVAPMFiltro cuesVAPMFiltro) throws Exception {   	 

   	//se crean objetos necesarios.

   	//Q02bCuestionarioSMAnuFiltro grupoCuestionarioSMAnuConNi = null;

   	String niCuesVAPM= null;

   	

   	boolean error = false;

   	try{

   		if (tr.isTraceActive()){

     			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNiCuesVAPM: entrando");

     		}

	  		//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoCuestionarioVAPM = new Q02bCuestionarioVAPMDataBaseDAO(this.getConn());

			//se pasan los parmetros de usuario e idioma

			//daoCuestionariosSMAnu.setUser(this.autenticador.getUser());

			//daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());

			//se llamaa la metodo del DAO que realiza la insert

			niCuesVAPM =daoCuestionarioVAPM.obtenerNiCuesVAPM(cuesVAPMFiltro);

			return niCuesVAPM;

			

   	}catch(Exception ex){

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerNiCuesVAPM: " + sw.getBuffer ().toString());

	        throw ex;                     

	  }finally{

		    try{

		    	daoCuestionarioVAPM.freeResourcesNotConnection();

		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerNiCuesVAPM: error liberando recursos");

	   	   	   }  

		    }  		 

		  	//se cierra la conexin  

		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNiCuesVAPM: saliendo.");

	   		}

	  }

   }//fin obtenerNiCuesVAPM

   

  /* * Funcin que inserta/modifica los datos del grupo de cuestionarios de Ayuntamientos Mensual a partir de los Datos Contenidos en el filtro

   * 

   * @param cuestionarioVTMAnuFiltro - Datos del grupo de cuestionarios a insertar

   * 

   * @throws Exception

   */

  public String altaModifGrupoCuestionariosVAPM(Q02bCuestionarioVAPMFiltro cuesVAPMFiltro) throws Exception {   	 

  	//se crean objetos necesarios.

  	//Q02bCuestionarioVTMAnuFiltro grupoCuestionarioVTMAnuConNi = null;

  	String niCuesVAPM = null;

  	boolean error = false;

  	try{

  		if (tr.isTraceActive()){

    			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVAPM: entrando");

    		}

	  		//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoCuestionarioVAPM = new Q02bCuestionarioVAPMDataBaseDAO(this.getConn());

//			se pasan los parmetros de usuario e idioma

			//daoCuestionariosVTMAnu.setUser(this.autenticador.getUser());

			//daoCuestionariosVTMAnu.setIdioma(this.autenticador.getIdioma());

			//se llamaa la metodo del DAO que realiza la insert

			niCuesVAPM =daoCuestionarioVAPM.altaModifGrupoCuestionariosVAPM(cuesVAPMFiltro);

			return niCuesVAPM;

			

  	}catch(Exception ex){

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosVAPM: " + sw.getBuffer ().toString());

	        throw ex;                     

	  }finally{

		    try{

		    	daoCuestionarioVAPM.freeResourcesNotConnection();

		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosVAPM: error liberando recursos");

	   	   	   }  

		    }  		 

		  	//se cierra la conexin  

		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVAPM: saliendo.");

	   		}

	  }

  }//fin altaModifGrupoCuestionariosVAPM

   

  /**

   * Funcin que recupera el nmero de cuestionarios de SM 

   * 

   * @param cuestionarioSMAnu - Datos del cuestionario a actualizar

   * 

   * @throws Exception

   */

    public int getNumCuestionariosPortada(String territorio, String municipio, String anyoReferencia,String mesReferencia) throws Exception {   	 

  	//se crean objetos necesarios.

  	int numCuestionariosVA=0;	        	         

  	boolean error = false;

  	

  	try{

  		 

  		if (tr.isTraceActive()){

    			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortada: entrando");

    		}

	  		//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoCuestionarioVAPM = new Q02bCuestionarioVAPMDataBaseDAO(this.getConn());

			

			numCuestionariosVA = daoCuestionarioVAPM.getNumCuestionariosVA(territorio, municipio, anyoReferencia, mesReferencia);

			    			   			

			return numCuestionariosVA;

  	}catch(Exception ex){

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: " + sw.getBuffer ().toString());

	        throw ex;                     

	  }finally{

		    try{

		    	daoCuestionarioVAPM.freeResourcesNotConnection();

		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: error liberando recursos");

	   	   	   }  

		    }  		 

		  	//se cierra la conexin  

		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortada: saliendo.");

	   		}

	  }

  }//fin getNumCuestionariosPortada 

  

    

    public String getConcedidoLicenGrupoCuesVAPM(String territorio, String municipio, String anyoReferencia,String mesReferencia) throws Exception {   	 

    	//se crean objetos necesarios.

    	String concedidoLicenVAPM="";	        	         

    	boolean error = false;

    	

    	try{

    		 

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getConcedidoLicenGrupoCuesVAPM: entrando");

      		}

	  		//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoCuestionarioVAPM = new Q02bCuestionarioVAPMDataBaseDAO(this.getConn());

			

			concedidoLicenVAPM = daoCuestionarioVAPM.getConcedidoLicenGrupoCuesVAPM(territorio, municipio, anyoReferencia, mesReferencia);

			    			   			

			return concedidoLicenVAPM;

    	}catch(Exception ex){

	 		error= true;

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getConcedidoLicenGrupoCuesVAPM: " + sw.getBuffer ().toString());

	        throw ex;                     

 	  }finally{

 		    try{

 		    	daoCuestionarioVAPM.freeResourcesNotConnection();

 		    }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getConcedidoLicenGrupoCuesVAPM: error liberando recursos");

	   	   	   }  

 		    }  		 

 		  	//se cierra la conexin  

 		    cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getConcedidoLicenGrupoCuesVAPM: saliendo.");

	   		}

 	  }

    } 

    

    /**

     * Funcin que recupera los cuestionarios de vivienda en alquiler con los datos introducidos en el filtro (pgina de portada)

     * 

     * @param filtroCuestionariosVAPM - Datos de los cuestionarios a consultar

     * @return listaCuestionariosVAPM  -  Listado de cuestionarios obtenidos

     * @throws Exception

     */

	public ArrayList getCuestionariosVAPM(HashMap mapaFiltroPortadaCuestionarioVAPM) throws Exception 

	{

		 if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCuestionariosVAPM: entrando.");

	   		}  	  

		String idCues = null;		

		//String noRegRecuperados = "NoHayCuestionariosVAPM";

		ArrayList listaCuestionariosVAPM = new ArrayList();

		Q02bCuestionarioVAPMFiltro cuestionarioVAPMFiltroPortada = null;

		boolean error = false;

		

		try{

			cuestionarioVAPMFiltroPortada = (Q02bCuestionarioVAPMFiltro) Q02bVoUtils.getValueObject(mapaFiltroPortadaCuestionarioVAPM,"q02b.exe.cuestionarioVAPM.valueobjects.Q02bCuestionarioVAPMFiltro");

			//cuestionarioVAPMFiltroPortada.setConcedidoLicen("1");

			//se abre la conexin

			abrirConexion();

			//se instancia el dao pasandole la conexin			

			daoCuestionarioVAPM = new Q02bCuestionarioVAPMDataBaseDAO(this.getConn());

			//se llamamara al dao para obtener el nmero de cuestionarios

			idCues = daoCuestionarioVAPM.obtenerIdGrupoCuestionariosVAPM(cuestionarioVAPMFiltroPortada);

			if(idCues!=null && !idCues.equals("")){

				listaCuestionariosVAPM = daoCuestionarioVAPM.getSelectCuestionariosVAPM(idCues);

            }            

            return listaCuestionariosVAPM;              

	  } catch(Exception ex){

 		  error= true;

          java.io.StringWriter sw = new java.io.StringWriter();

          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCuestionariosVAPM: " + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoCuestionarioVAPM.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCuestionariosVAPM: error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCuestionariosVAPM: saliendo.");

	   		}

 	  	}

 	  } //fin getCuestionariosVAPM 

	

	/**

     * Funcin que modifica los datos del cuestionario pasado como parmetro en la BBDD

     * 

     * @param cuestionarioVAPM - Datos del cuestionario a modificar

     * 

     * @throws Exception

     */

   public void modificarCuestionarioVAPM(String niCuesVAPM, Q02bCuestionarioVAPM cuestionarioVAPM) throws Exception {

   	 if (tr.isTraceActive()){

  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVAPM: entrando");

  		}

   	 boolean error = false;

   	try{

   		//se abre la conexin

   		abrirConexion();

   		//se instancia el dao pasandole la conexin			

   		daoCuestionarioVAPM = new Q02bCuestionarioVAPMDataBaseDAO(this.getConn());

			// Segmento tecnico 

			//daoCuestionariosSMAnu.setUser(this.getAutenticador().getUser());

			//daoCuestionariosSMAnu.setIdioma(this.getAutenticador().getIdioma()); 



   		//se llamaa la metodo del DAO que realiza la update

   		daoCuestionarioVAPM.modificarCuestionarioVAPM(niCuesVAPM, cuestionarioVAPM);

   		    	

   	}catch(Exception ex){

		  error= true;

         java.io.StringWriter sw = new java.io.StringWriter();

         java.io.PrintWriter pw = new java.io.PrintWriter(sw);

         ex.printStackTrace(pw);

         tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVAPM: " + sw.getBuffer ().toString());

         throw ex;                     

	  }finally{

		 try{

			daoCuestionarioVAPM.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVAPM: error liberando recursos");

	   	   	   }  

		   }  		 

		  	//se cierra la conexin  

		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVAPM: saliendo.");

	   		}

	  }

   }



   /**

    * Mtodo que dado el nmero interno del cuestionario recuperar de la BBDD

    * los datos de dicho cuestionario.

    * @param niCuestionarioVAPM

    * @return

    */

	public Q02bCuestionarioVAPM obtenerCuestionarioSeleccionadoVAPM(String niCuestionarioVAPM)throws Exception{  	 

	    	boolean error = false;

	    	Q02bCuestionarioVAPM cuestionarioVAPM = null;

	  	  	try  	  {

	  	  		if (tr.isTraceActive()){

	  	  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioSeleccionadoVAPM, ** niCuestionarioVAPM bean=" + niCuestionarioVAPM + " *** entrando");                

	  	  		}

	  	  		//se abre la conexin

	  	  		abrirConexion();

	  	  		//se instancia el dao pasandole la conexin			

	  	  		daoCuestionarioVAPM = new Q02bCuestionarioVAPMDataBaseDAO(this.getConn());

	  	  		//Segmento tecnico 

	  			//daoCuestionariosVTMAnu.setUser(this.getAutenticador().getUser());

	  			//daoCuestionariosVTMAnu.setIdioma(this.getAutenticador().getIdioma()); 

	  	  		//se llama al mtodo del dao recupera el cuestionario

	  	  		cuestionarioVAPM = daoCuestionarioVAPM.obtenerCuestionarioSeleccionadoVAPM(niCuestionarioVAPM);

	  	  		//se devuelve el cuestionario recuperado

	  	  		return cuestionarioVAPM;

	  	  }catch(Exception ex){

	  		  	error= true;

	  		  	java.io.StringWriter sw = new java.io.StringWriter();

	          	java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	          	ex.printStackTrace(pw);

	          	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioVAPM: " + sw.getBuffer ().toString());

	          	throw ex;                     

	 	  }finally{

	 		  	try{

	 		  		daoCuestionarioVAPM.freeResourcesNotConnection();

	 		  	}catch(Exception ex){

				   if (tr.isTraceActive()){

					   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioVAPM: error liberando recursos");

		   	   	   }  

	 		  	}  		 

	 		  	//se cierra la conexin  

	 		  	cerrarConexion(error);	       	

		        if (tr.isTraceActive()){

		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVAPM: saliendo.");

		   		}

	 	  }

	    }//fin obtenerCuestionarioVAPM

	

	/**

     * Funcin que borra el cuestionario pasado como parmetro de la BBDD

     * 

     * @param niCuestionarioVAPM - nmero interno del cuestionario a borrar

     * 

     * @throws Exception

     */

  public void borrarCuestionarioVAPM(String niCuestionarioVAPM) throws Exception {

         

	  	//int numeroRegistros = 0;

    	if (tr.isTraceActive()){

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVAPM: entrando");

		}

    	 boolean error = false;

    	 try{

    		 //se abre la conexin

   			abrirConexion();

   			//se instancia el dao pasandole la conexin			

   			daoCuestionarioVAPM = new Q02bCuestionarioVAPMDataBaseDAO(this.getConn());

			// Segmento tecnico 

   			//daoCuestionariosSMAnu.setUser(this.getAutenticador().getUser());

   			//daoCuestionariosSMAnu.setIdioma(this.getAutenticador().getIdioma()); 



   			//se comprueba el numero de cuestionarios que tiene el grupo de cuestionarios

   			daoCuestionarioVAPM.borrarCuestionarioVAPM(niCuestionarioVAPM);

   			

   		 	  

    	 }catch(Exception ex){

		  error= true;

          java.io.StringWriter sw = new java.io.StringWriter();

          java.io.PrintWriter pw = new java.io.PrintWriter(sw);

          ex.printStackTrace(pw);

          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioVAPM: " + sw.getBuffer ().toString());

          throw ex;                     

 	  }finally{

 		 try{

 			daoCuestionarioVAPM.freeResourcesNotConnection();

		   }catch(Exception ex){

			   if (tr.isTraceActive()){

				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioVAPM: error liberando recursos");

	   	   	   }  

		   }  		 

 		  	//se cierra la conexin  

 		  	cerrarConexion(error);	       	

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVAPM: saliendo.");

	   		}

 	  }



    }//fin borrarCuestionarioVAPM

 



}



		





