package q02b.exe.comun.beans;



import java.util.ArrayList;



import q02b.exe.arquitectura.beans.Q02bBaseBean;

import q02b.exe.comun.valueobjects.Q02bContacto;

//import q02b.exe.comun.valueobjects.Q02bMailTo;

import q02b.exe.utils.Q02bMailUtils;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.listeners.base.Q70ListenerUtils;



public class Q02bContactoBean extends Q02bBaseBean{



	private static final long serialVersionUID = 3394757413314128326L;

	

	/** Constructor vacio */

    public Q02bContactoBean() {

        super();

    }

    

    /**

     * Mtodo que llama a un DAO para mandar un email.

     * @param 

     * @return

     * @throws Exception

     */

    public void contactar(Q02bContacto contacto) throws Exception{

    	//Variables que no se van a modificar

    	final String METODO_TRAZA 				= ":contactar:";	

    	final String SEPARADOR 					= ":"; 

		final String CARRIAGE_RETURN 			= "\n"; 

		final String GUION						= " - ";

		

    	try{

    		if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + METODO_TRAZA +  ":entrando");

      		}

    		

    		String CUERPO_NOMBRE_APELLIDOS 	= Q70GestorMensajesi18n.getSingleton().getMessage("q02brecursosCuestionarios","comun.nombreApellidos","es");

    		String CUERPO_DNI				= Q70GestorMensajesi18n.getSingleton().getMessage("q02brecursosCuestionarios","comun.dni", "es");

    		String CUERPO_RAZONSOCIAL		= Q70GestorMensajesi18n.getSingleton().getMessage("q02brecursosCuestionarios","comun.razon", "es");

    		String CUERPO_DIRECCION			= Q70GestorMensajesi18n.getSingleton().getMessage("q02brecursosCuestionarios","comun.direccion", "es");

    		String CUERPO_MUNICIPIO			= Q70GestorMensajesi18n.getSingleton().getMessage("q02brecursosCuestionarios","comun.municipio", "es");

    		String CUERPO_PROVINCIA			= Q70GestorMensajesi18n.getSingleton().getMessage("q02brecursosCuestionarios","comun.provincia", "es");

    		String CUERPO_PAIS 				= Q70GestorMensajesi18n.getSingleton().getMessage("q02brecursosCuestionarios","comun.pais", "es");

    		String CUERPO_CODIGOPOSTAL		= Q70GestorMensajesi18n.getSingleton().getMessage("q02brecursosCuestionarios","comun.postal", "es");

    		String CUERPO_TELEFONO			= Q70GestorMensajesi18n.getSingleton().getMessage("q02brecursosCuestionarios","comun.telefono", "es");

    		String CUERPO_FAX 				= Q70GestorMensajesi18n.getSingleton().getMessage("q02brecursosCuestionarios","comun.fax", "es");

    		String CUERPO_EMAIL				= Q70GestorMensajesi18n.getSingleton().getMessage("q02brecursosCuestionarios","comun.email", "es");

    		String CUERPO_TEXTO				= Q70GestorMensajesi18n.getSingleton().getMessage("q02brecursosCuestionarios","comun.body", "es");

    		

    		//Variable que contiene el mensaje

    		StringBuffer mensaje = new StringBuffer();

    		// Nombre y apellidos 

       		mensaje.append(CUERPO_NOMBRE_APELLIDOS).append(SEPARADOR).append(contacto.getNombreApellidos()).append(CARRIAGE_RETURN);

       		//Dni 

       		mensaje.append(CUERPO_DNI).append(SEPARADOR).append(contacto.getDni()).append(CARRIAGE_RETURN);

       		//Razon Social

       		mensaje.append(CUERPO_RAZONSOCIAL).append(SEPARADOR).append(contacto.getRazonSocial()).append(CARRIAGE_RETURN);

       		//Direccion

       		mensaje.append(CUERPO_DIRECCION).append(SEPARADOR).append(contacto.getDireccion()).append(CARRIAGE_RETURN);

       		//Provincia

       		mensaje.append(CUERPO_PROVINCIA).append(SEPARADOR).append(contacto.getCodProvincia()).append(GUION).append(contacto.getProvincia()).append(CARRIAGE_RETURN);

       		//Municipio

       		mensaje.append(CUERPO_MUNICIPIO).append(SEPARADOR).append(contacto.getCodMunicipio()).append(GUION).append(contacto.getMunicipio()).append(CARRIAGE_RETURN);

       		//Pais

       		mensaje.append(CUERPO_PAIS).append(SEPARADOR).append(contacto.getPais()).append(CARRIAGE_RETURN);

       		//Codigo Postal

       		mensaje.append(CUERPO_CODIGOPOSTAL).append(SEPARADOR).append(contacto.getCodigoPostal()).append(CARRIAGE_RETURN);

       		//Telefono

       		mensaje.append(CUERPO_TELEFONO).append(SEPARADOR).append(contacto.getTelefono()).append(CARRIAGE_RETURN);

       		//Codigo Postal

       		mensaje.append(CUERPO_FAX).append(SEPARADOR).append(contacto.getFax()).append(CARRIAGE_RETURN);

       		// Email

      		mensaje.append(CUERPO_EMAIL).append(SEPARADOR).append(contacto.getEmail()).append(CARRIAGE_RETURN);      		

      		// Texto  

    		mensaje.append(CUERPO_TEXTO).append(SEPARADOR).append(CARRIAGE_RETURN).append(contacto.getBody());

    		if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + "MENSAJE " + mensaje);

	   		}

    		  		

    		//Se instancia la clase con el constructor vaco

    		Q02bMailUtils mailUtil=new Q02bMailUtils();

    		//Se asocian los parmetros

    		mailUtil.setSubject("");

    		mailUtil.setBody(mensaje.toString());

    		mailUtil.setRemitente(contacto.getEmail());

    		//ArrayList con los destinatarios

    		ArrayList destinatarios = new ArrayList();

    		destinatarios.add(Q70ListenerUtils.getApplicationProperty("EMAIL_CONTACTO"));

    		mailUtil.setListaDestinatarios(destinatarios);

    		if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + "CONTACTO " + destinatarios.get(0).toString());

	   		}

    		mailUtil.setAttachment(null);

    		mailUtil.setIdioma("es");

      		//Se enva el correo

    		mailUtil.enviarMail();		

    			

    	}catch(Exception ex){

	        java.io.StringWriter sw = new java.io.StringWriter();

	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	        ex.printStackTrace(pw);

	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":contactar: " + sw.getBuffer ().toString());

	        throw ex;                     

    	}finally{

	        if (tr.isTraceActive()){

	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":contactar: saliendo");

	   		}

    	}

    	

    }

}