package q02b.exe.ayuntamiento.beans;



import java.util.ArrayList;



import q02b.exe.arquitectura.beans.Q02bBaseBean;

import q02b.exe.ayuntamiento.dataobjects.Q02bAyuntamientoDataBaseDAO;

import q02b.exe.ayuntamiento.valueobjects.Q02bAyuntamiento;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;



public class Q02bAyuntamientoBean extends Q02bBaseBean {

	private static final long serialVersionUID = 5474311672836163390L;



	protected Q02bAyuntamientoDataBaseDAO daoAyuntamiento = null;



	final static String LISTA_AYUNTAMIENTO = "listaAyuntamiento";



	/** Constructor vacio */

	public Q02bAyuntamientoBean() {

		super();

	}



	/**

	 * Funcin que recupera los ayuntamientos

	 * 

	 * @return listaAyuntamientos - Listado de ayuntamientos obtenidos

	 * @throws Exception

	 */

	public ArrayList obtenerAyuntamientos(Q02bAyuntamiento ayuntamiento) throws Exception {

		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":obtenerAyuntamientos: entrando.");

		}

		ArrayList listaAyuntamiento = new ArrayList();

		boolean error = false;



		try {

			// se abre la conexin

			abrirConexion();

			// se instancia el dao pasandole la conexin

			daoAyuntamiento = new Q02bAyuntamientoDataBaseDAO(this.getConn());



			// Segmento tecnico

			// daoAyuntamiento.setUser(this.getAutenticador().getUser());

			// daoAyuntamiento.setIdioma(this.getAutenticador().getIdioma());



			listaAyuntamiento = daoAyuntamiento.getAyuntamientos(ayuntamiento);

			return listaAyuntamiento;

		} catch (Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":obtenerAyuntamientos: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				daoAyuntamiento.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE,Q70TraceLevel.ERROR,this.getClass().getName()+ ":obtenerAyuntamientos: error liberando recursos");

				}

			}

			// se cierra la conexin

			cerrarConexion(error);

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":obtenerAyuntamientos: saliendo.");

			}

		}

	} // fin obtenerAyuntamientos



	/**

	 * Funcin que inserta los datos del ayuntamiento pasado como parmetro en

	 * la BBDD

	 * 

	 * @param ayuntamiento -

	 *            Datos del ayuntamiento a insertar

	 * @throws Exception

	 */

	public void insertarAyuntamiento(Q02bAyuntamiento ayuntamiento) throws Exception {

		boolean error = false;

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":insertarAyuntamiento: entrando");

			}

			// se abre la conexin

			abrirConexion();



			// se instancia el dao pasandole la conexin

			daoAyuntamiento = new Q02bAyuntamientoDataBaseDAO(this.getConn());



			// se pasan los parmetros de usuario e idioma

			// daoAyuntamiento.setUser(this.autenticador.getUser());

			// daoAyuntamientos.setIdioma(this.autenticador.getIdioma());



			// se llama la metodo del DAO que realiza la insert

			daoAyuntamiento.insertarAyuntamiento(ayuntamiento);

		} catch (Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":insertarAyuntamiento: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				daoAyuntamiento.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE,Q70TraceLevel.ERROR,this.getClass().getName()+ ":insertarAyuntamiento: error liberando recursos");

				}

			}

			// se cierra la conexin

			cerrarConexion(error);

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":insertarAyuntamiento: saliendo.");

			}

		}

	}// fin insertarAyuntamiento



	/**

	 * Mtodo que dado el nmero interno del ayuntamiento recupera de la BBDD

	 * los datos de dicho ayuntamiento.

	 * 

	 * @param idAyuntamiento

	 * @return ayuntamiento

	 */

	public Q02bAyuntamiento obtenerAyuntamiento(String idAyuntamiento) throws Exception {

		boolean error = false;

		Q02bAyuntamiento ayuntamiento = null;

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":obtenerAyuntamiento, ** idAyuntamiento bean="	+ idAyuntamiento + " *** entrando");

			}



			// se abre la conexin

			abrirConexion();



			// se instancia el dao pasandole la conexin

			daoAyuntamiento = new Q02bAyuntamientoDataBaseDAO(this.getConn());



			// Segmento tecnico

			// daoAyuntamiento.setUser(this.getAutenticador().getUser());

			// daoAyuntamiento.setIdioma(this.getAutenticador().getIdioma());



			// se llama al mtodo del dao que recupera el ayuntamiento

			ayuntamiento = daoAyuntamiento.obtenerAyuntamiento(idAyuntamiento);



			// se devuelve el ayuntamiento recuperado

			return ayuntamiento;

		} catch (Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":obtenerAyuntamiento: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				daoAyuntamiento.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":obtenerAyuntamiento: error liberando recursos");

				}

			}

			// se cierra la conexin

			cerrarConexion(error);

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":obtenerAyuntamiento: saliendo.");

			}

		}

	}// fin obtenerAyuntamiento



	/**

	 * Funcin que borra el ayuntamiento pasado como parmetro de la BBDD

	 * 

	 * @param idAyuntamiento - nmero interno del ayuntamiento a borrar

	 * @throws Exception

	 */

	public void borrarAyuntamiento(String idAyuntamiento) throws Exception {

		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":borrarAyuntamiento: entrando");

		}

		boolean error = false;

		try {

			// se abre la conexin

			abrirConexion();



			// se instancia el dao pasandole la conexin

			daoAyuntamiento = new Q02bAyuntamientoDataBaseDAO(this.getConn());



			// Segmento tecnico

			// daoAyuntamiento.setUser(this.getAutenticador().getUser());

			// daoAyuntamiento.setIdioma(this.getAutenticador().getIdioma());



			daoAyuntamiento.borrarAyuntamiento(idAyuntamiento);

		} catch (Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":borrarAyuntamiento: " + sw.getBuffer().toString());

			throw ex;



		} finally {

			try {

				daoAyuntamiento.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":borrarAyuntamiento: error liberando recursos");

				}

			}

			// se cierra la conexin

			cerrarConexion(error);

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":borrarAyuntamiento: saliendo.");

			}

		}

	}// fin borrarAyuntamiento



	/**

	 * Funcin que modifica los datos del ayuntamiento pasado como parmetro en la BBDD

	 * 

	 * @param ayuntamiento - Datos del ayuntamiento a modificar

	 * @throws Exception

	 */

	public void modificarAyuntamiento(Q02bAyuntamiento ayuntamiento) throws Exception {

		if (tr.isTraceActive()) {

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":modificarAyuntamiento: entrando");

		}

		boolean error = false;

		try {

			// se abre la conexin

			abrirConexion();

			// se instancia el dao pasandole la conexin

			daoAyuntamiento = new Q02bAyuntamientoDataBaseDAO(this.getConn());



			// Segmento tecnico

			// daoAyuntamiento.setUser(this.getAutenticador().getUser());

			// daoAyuntamiento.setIdioma(this.getAutenticador().getIdioma());



			// se llamaa la metodo del DAO que realiza la update

			daoAyuntamiento.modificarAyuntamiento(ayuntamiento);



		} catch (Exception ex) {

			error = true;

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":modificarAyuntamiento: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				daoAyuntamiento.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":modificarAyuntamiento: error liberando recursos");

				}

			}

			// se cierra la conexin

			cerrarConexion(error);

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":modificarAyuntamiento: saliendo.");

			}

		}

	}// modificarAyuntamiento



}