/*

 * Encryption.java

 *

 * Created on 24 de noviembre de 2003, 10:03

 */



package q02b.exe.arquitectura.utils.crypto;

import java.security.Provider;

import java.security.Security;



import javax.crypto.Cipher;

import javax.crypto.SecretKey;

import javax.crypto.SecretKeyFactory;

import javax.crypto.spec.DESKeySpec;

import javax.crypto.spec.DESedeKeySpec;

import javax.crypto.spec.IvParameterSpec;



//import weblogic.apache.xerces.impl.dv.util.Base64;







import com.sun.crypto.provider.SunJCE;





/**

 *

 * @author  asier.axpe

 * @version

 * La clase Encripta y desencripta array de bytes de acuerdo con una clave y mediante en algoritmo SIMPLE DES

 * haciendo uso del proveedor de SUN de criptografa

 */

public class Q02bEncrypt {

    public static String cipherAlg = "DES/ECB/PKCS5Padding";

    public static String keyAlg = "DES";

    //private static byte[] DEFAULT_IV = {0,0,0,0,0,0,0,0};

    

    /** Creates new Encriptado */

    public Q02bEncrypt() {

    }

    /** Encriptacin Triple DES*/

	public static byte[] encryptDESedeData(String data, String password, String iv, String Algorithm){

		byte[] plainText = data.getBytes();

		byte[] cipherText = null;

		byte[] tdesKeyData = password.getBytes();

		byte[] myIV = null;

		//IvParameterSpec ivspec = null;

		if(iv != null){

			myIV = iv.getBytes();

		}

		if(Algorithm == null){

			Algorithm = "DESede/ECB/PKCS5Padding";

		}

		try {

            Provider provider = Security.getProvider("IBMJCE");

        if(provider == null)

        {

            provider = new SunJCE();

            Security.addProvider(provider);

        }



			Cipher c3des = Cipher.getInstance(Algorithm);

			DESedeKeySpec tripleDesKeySpec = new DESedeKeySpec ( tdesKeyData ) ;

			SecretKeyFactory keyFactory = SecretKeyFactory.getInstance ( "DESede" ) ;

			SecretKey tripleDesKey = keyFactory.generateSecret ( tripleDesKeySpec ) ;

/*			if(iv != null){

				ivspec = new IvParameterSpec(myIV);

			}

			if(iv != null){

				c3des.init(Cipher.ENCRYPT_MODE, tripleDesKey, ivspec);

			}else{

				c3des.init(Cipher.ENCRYPT_MODE, tripleDesKey);

			}

*/

			c3des.init(Cipher.ENCRYPT_MODE, tripleDesKey);

			cipherText = c3des.doFinal(plainText);

		} catch (Exception e) {

			e.printStackTrace();

		}

		return cipherText;

	}



    /** Encriptacin Triple DES*/

	public static byte[] decryptDESedeData(String data, String password, String iv, String Algorithm){

		byte[] cipherText = data.getBytes();

		byte[] plainText = null;

		byte[] tdesKeyData = password.getBytes();

		byte[] myIV = null;

		//IvParameterSpec ivspec = null;



		if(iv != null){

			myIV = iv.getBytes();

		}

		if(Algorithm == null){

			Algorithm = "DESede/ECB/PKCS5Padding";

		}

		try {

            Provider provider = Security.getProvider("IBMJCE");

        if(provider == null)

        {

            provider = new SunJCE();

            Security.addProvider(provider);

        }





			Cipher c3des = Cipher.getInstance(Algorithm);

			DESedeKeySpec tripleDesKeySpec = new DESedeKeySpec ( tdesKeyData ) ;

			SecretKeyFactory keyFactory = SecretKeyFactory.getInstance ( "DESede" ) ;

			SecretKey tripleDesKey = keyFactory.generateSecret ( tripleDesKeySpec ) ;

/*			if(iv != null){

				ivspec = new IvParameterSpec(myIV);

			}

			if(iv != null){

				c3des.init(Cipher.DECRYPT_MODE, tripleDesKey, ivspec);

			}else{

				c3des.init(Cipher.DECRYPT_MODE, tripleDesKey);

			}

*/

			c3des.init(Cipher.DECRYPT_MODE, tripleDesKey);

			plainText = c3des.doFinal(cipherText);

		} catch (Exception e) {

			e.printStackTrace();

		}

		return plainText;

	}





    public static byte[] decryptData(String cipherAlg, String keyAlg, byte[] data, byte[] key){

        try{

            Provider provider = Security.getProvider("IBMJCE");

        if(provider == null)

        {

            provider = new SunJCE();

            Security.addProvider(provider);

        }

            

            Cipher cipher = Cipher.getInstance(cipherAlg, provider.getName());

            

            DESKeySpec keyspec = new DESKeySpec(key);

            SecretKeyFactory keyfactory = SecretKeyFactory.getInstance(keyAlg);

            SecretKey secretKey = keyfactory.generateSecret(keyspec);

            

            cipher.init(Cipher.DECRYPT_MODE, secretKey/*, new IvParameterSpec(DEFAULT_IV)*/);

            return cipher.doFinal(data);

        }catch(Exception e){

            return null;

        }

    }

    

    public static byte[] encryptData(String cipherAlg, String keyAlg, byte[] data, byte[] key){

        try{

            Provider provider = Security.getProvider("IBMJCE");

        if(provider == null)

        {

            provider = new SunJCE();

            Security.addProvider(provider);

        }

            Cipher cipher = Cipher.getInstance(cipherAlg,provider.getName());

            DESKeySpec  keyspec = new DESKeySpec(key);

            SecretKeyFactory keyfactory = SecretKeyFactory.getInstance(keyAlg);

            SecretKey secretKey = keyfactory.generateSecret(keyspec);

            

            cipher.init(Cipher.ENCRYPT_MODE, secretKey/*, new IvParameterSpec(DEFAULT_IV)*/);

            return cipher.doFinal(data);

        }catch(Exception e){

            return null;

        }

    }

	/** Encriptacin Triple DES*/

	public static byte[] encryptDESedeData(byte[] plainText, String password, String iv, String Algorithm){

		byte[] cipherText = null;

		byte[] tdesKeyData = password.getBytes();

		byte[] myIV = null;

		//IvParameterSpec ivspec = null;

		if(iv != null){

			myIV = iv.getBytes();

		}

		if(Algorithm == null){

			Algorithm = "DESede/ECB/PKCS5Padding";

		}

		try {

			Provider provider = Security.getProvider("IBMJCE");

		if(provider == null)

		{

			provider = new SunJCE();

			Security.addProvider(provider);

		}



			Cipher c3des = Cipher.getInstance(Algorithm);

			DESedeKeySpec tripleDesKeySpec = new DESedeKeySpec ( tdesKeyData ) ;

			SecretKeyFactory keyFactory = SecretKeyFactory.getInstance ( "DESede" ) ;

			SecretKey tripleDesKey = keyFactory.generateSecret ( tripleDesKeySpec ) ;

			c3des.init(Cipher.ENCRYPT_MODE, tripleDesKey);

			cipherText = c3des.doFinal(plainText);

		} catch (Exception e) {

			e.printStackTrace();

		}

		return cipherText;

	}



	/** Encriptacin Triple DES*/

	public static byte[] decryptDESedeData(byte[] cipherText, String password, String iv, String Algorithm){

		byte[] plainText = null;

		byte[] tdesKeyData = password.getBytes();

		byte[] myIV = null;

		//IvParameterSpec ivspec = null;



		if(iv != null){

			myIV = iv.getBytes();

		}

		if(Algorithm == null){

			Algorithm = "DESede/ECB/PKCS5Padding";

		}

		try {

			Provider provider = Security.getProvider("IBMJCE");

		if(provider == null)

		{

			provider = new SunJCE();

			Security.addProvider(provider);

		}





			Cipher c3des = Cipher.getInstance(Algorithm);

			DESedeKeySpec tripleDesKeySpec = new DESedeKeySpec ( tdesKeyData ) ;

			SecretKeyFactory keyFactory = SecretKeyFactory.getInstance ( "DESede" ) ;

			SecretKey tripleDesKey = keyFactory.generateSecret ( tripleDesKeySpec ) ;

			c3des.init(Cipher.DECRYPT_MODE, tripleDesKey);

			plainText = c3des.doFinal(cipherText);

		} catch (Exception e) {

			e.printStackTrace();

		}

		return plainText;

	}

	/** funcin que encriptara una clave usando el algorithmo DES

	 * 

	 */

	public static String encrypPassWordDes (String key, String password) throws Exception

	{

		//se pasa la clave y la clave de cifrado a Bytes 

		String claveEncriptada = null;

		byte[] plainText = null;

		byte[] cipherText = password.getBytes();;

		byte[] tdesKey = key.getBytes();

		//se define el Algorithmo de cifrado DES

		String algorithm = "DES/ECB/PKCS5Padding";

		//Se define el tipo de cifrado

		String cifrado_Desc = "DES";

		//se realiza la llamada al metodo de encriptacion pasandole los paramaetros adecuados

		plainText = encryptData(algorithm,cifrado_Desc,cipherText,tdesKey);

		//se pasa a string la clave encriptada

		claveEncriptada = new String(plainText);

		//decodificar la clave 

		return claveEncriptada;

		

	}

	/** funcin que desencriptara una clave usando el algorithmo DES

	 * 

	 */

	public static String decrypPassWordDes (String key, String password) throws Exception

	{

		//se pasa la clave y la clave de cifrado a Bytes 

		String claveDesencriptada = null;

		byte[] plainText = null;

		byte[] cipherText = password.getBytes();

		byte[] tdesKey = key.getBytes();

		//se define el Algorithmo de cifrado DES

		String algorithm = "DES/ECB/PKCS5Padding";

		//Se define el tipo de cifrado

		String cifrado_Desc = "DES";

		//se realiza la llamada al metodo de encriptacion pasandole los paramaetros adecuados

		plainText = decryptData(algorithm,cifrado_Desc,cipherText,tdesKey);

		//se pasa a string la clave encriptada

		claveDesencriptada = new String(plainText);

		return claveDesencriptada;

		

	}

}

