package q02b.exe.agentes.dataobjects;



import java.sql.Connection;

//import java.sql.PreparedStatement;

import java.sql.ResultSet;

import java.util.ArrayList;



import q02b.exe.agentes.valueobjects.Q02bAgenteOfi;

import q02b.exe.agentes.valueobjects.Q02bAgenteOfiLista;

//import q02b.exe.agentes.valueobjects.Q02bAgentes;

//import q02b.exe.agentes.valueobjects.Q02bFiltroAgentes;

import q02b.exe.arquitectura.dataobjects.Q02bDataBaseDAO;

/*import q02b.exe.agentes.valueobjects.Q02bAgentes;

import q02b.exe.agentes.valueobjects.Q02bFiltroAgentes;

import q02b.exe.informantes.valueobjects.Q02bFiltroInformantes;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022IS01V01;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022JS01V01;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022JS00; 

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022AS01V01;*/

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022JS01V01;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022ZS00;

//import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022JS00;

import q02b.exe.tablasBD.jdbc.oracle.Q02bTablaBDQ022ZS01V01;

//import q02b.exe.utils.Q02bConstantes;

import q02b.exe.utils.Q02bFormatData;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;







public class Q02bAgenteOfiDataBaseDAO extends Q02bDataBaseDAO{

	private static final long serialVersionUID = -8520551641771839103L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "DAO_ACCESO_DATOS";

	//private static final String RECURSOS_PLAZOS = "q02brecursosCuestionarios";



	public Q02bAgenteOfiDataBaseDAO() {

        super();                

    }



    

    public Q02bAgenteOfiDataBaseDAO(Connection conn) {

    	super(conn);     

    }



    /**

     * Funcin que inserta los datos del agente pasado como parmetro en la BBDD

     * @param agente - Datos del agente-oficina a insertar 

     * @throws Exception

     */

    public String insertarAgenteOfi(Q02bAgenteOfi agenteofi) throws Exception {

    	int niAgente = 0; 

    	Q02bTablaBDQ022ZS00 tablaAgenteOfi=null;

//    	se crean objetos necesarios.

        long numAgenteOfi = -1;

      	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarAgenteOfi: entrando");

	    	}

   		    //se crea el objeto de tablasBD

	    	tablaAgenteOfi = new Q02bTablaBDQ022ZS00(this.getConnection());

     		tablaAgenteOfi.setQ022HT00_ID_OFI(Q02bFormatData.checkIntegerNull(agenteofi.getIdOfi()));

	    	tablaAgenteOfi.setQ022JT00_ID_AGEN(Q02bFormatData.checkIntegerNull(agenteofi.getIdAgente()));    	

	    	

     		//se realiza la insert

	    	tablaAgenteOfi.insert();          

        	return String.valueOf(numAgenteOfi);

    	}

    	catch(Exception ex)

    	{   	   

    		java.io.StringWriter sw = new java.io.StringWriter();

    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

    		ex.printStackTrace(pw);

    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarAgenteOfi: " + sw.getBuffer ().toString());

    		throw ex;

    	}

    	finally

    	{

    		try

    		{

    			tablaAgenteOfi.freeResourcesNotConnection();	

    		}

    		catch(Exception ex)

    		{

    			if (tr.isTraceActive())

    			{

    				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarAgenteOfi: error liberando recursos");

		   	   }  

		}  		

		if (tr.isTraceActive())

		{

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarAgenteOfi: saliendo");                

   		}       	

    	}

    } //insertarAgenteOfi  

      

    

    public ArrayList obtenerListaAgenteOfi(String idAgente) throws Exception {

    	

 		//se instancian los objetos necesarios para realizar la consulta.

    	Q02bTablaBDQ022ZS01V01 vistaAgenteOfi=null;

 		ResultSet rs = null;

 		ArrayList listaOficinas = new ArrayList();

 		

 		try{

 	    	if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerListaAgenteOfi: entrando");

 			}

 	    	

 	    	//se instancia la clase del tablas bd a llamar pasandole la conexion    	

 	    	

 	    	vistaAgenteOfi = new Q02bTablaBDQ022ZS01V01(this.getConnection());

 	    	vistaAgenteOfi.setQ022JT00_ID_AGEN_WHERE(Integer.parseInt(idAgente));

 	    	 //Se indica el order by de las columnas	

 	    	//vistaAgenteOfi.setOrderBy(Q02bTablaBDQ022ZS01V01.NOMCOLUMN_Q022HT00_DESC);

  	 	     	    	

 	    	//se realiza la select

 	    	rs = vistaAgenteOfi.select();

 	    	//aadimos el cursos para luego poder liberarlo ( en el freeResources)

 	    	vistaAgenteOfi.addResultSet(rs); 

 	    	//se trata el resultado obtenido aadiendolo a la lista de salida

 	    	listaOficinas = this.rellenaVOsOficinas(rs);

    	

 	    	return listaOficinas;    	

 		}catch(Exception ex){ 	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getAgentes: " + sw.getBuffer ().toString());

     		throw ex;

 		}finally{

 		 	try{

 		 		//liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet

 		 		vistaAgenteOfi.freeResourcesNotConnection();	

 			 }catch(Exception ex)

 			 {

 			    if (tr.isTraceActive())

 			    {

 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerListaAgenteOfi: error liberando recursos.");

 	   	   	    }  

 			 }  		 			

 			 if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerListaAgenteOfi: saliendo.");                

 	         }   

 		}	

 	}//fin obtenerListaAgenteOfi

    

    private ArrayList rellenaVOsOficinas( ResultSet rs ) throws Exception{

    	Q02bAgenteOfiLista oficinas;

     	ArrayList listaAgenteOfi = new ArrayList();

     	try{

     		//String idiomaEu=q02b.exe.utils.Q02bConstantes.getString("idioma.eu");

     		if (tr.isTraceActive()){

 		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOsOficinas: entrando");                

 		    } 

     		while (rs.next()){	 

 	        	//se cargan en el objeto cuestionario los datos recuperados

     			oficinas = new Q02bAgenteOfiLista();

     			tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":rellenaVOsOficinas: Hay Datos");

     			oficinas.setIdAgente(rs.getString(Q02bTablaBDQ022ZS01V01.NOMCOLUMN_Q022JT00_ID_AGEN));

     			oficinas.setIdOfi(rs.getString(Q02bTablaBDQ022ZS01V01.NOMCOLUMN_Q022HT00_ID_OFI));

     			//if (Q02bFormatData.esNull(this.getIdioma()).equals(idiomaEu))

     				oficinas.setDesc(rs.getString(Q02bTablaBDQ022ZS01V01.NOMCOLUMN_Q022HT00_DESC));

     				oficinas.setDesceus(rs.getString(Q02bTablaBDQ022ZS01V01.NOMCOLUMN_Q022HT00_DESC_EUS));

			   	//else oficinas.setDesc(rs.getString(Q02bTablaBDQ022ZS01V01.COLUMN_Q022HT00_DESC_EUS));

     			oficinas.setMunicipo_ds(rs.getString(Q02bTablaBDQ022ZS01V01.NOMCOLUMN_NORA_T17_MUNICIPIO_DS));

     			oficinas.setProvincia_ds(rs.getString(Q02bTablaBDQ022ZS01V01.COLUMN_NORA_T17_PROVINCIA_DS));

     			oficinas.setMuni(rs.getString(Q02bTablaBDQ022ZS01V01.NOMCOLUMN_Q022HT00_MUNI ));

     			oficinas.setProv(rs.getString(Q02bTablaBDQ022ZS01V01.NOMCOLUMN_Q022HT00_PROV));

			   	listaAgenteOfi.add(oficinas);

   			}  	  

     		return listaAgenteOfi;

     	}catch(Exception ex){    	 	   

  	       java.io.StringWriter sw = new java.io.StringWriter();

  	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);

  	       ex.printStackTrace(pw);

  	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaVOsOficinas: " + sw.getBuffer ().toString());

  	       throw ex;

  		}finally{			 	

  			if (tr.isTraceActive()){

  		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOsOficinas: saliendo");                

  		    }    				

  		}

     }//fin rellenaVOsOficinas(rs) 

    

    // -------------------- INI - DELETE --------------------

    /**

     * Borra un/a VarActEprtr por Clave Primaria

     * @param pk - Q02bAgenteOfi

     * @throws Exception

     * @see Q02bAgenteOfi

     * @see Q02bTablaBDQ022ZS00

     * @generated

     */

    public void borrarAgenteOfi(Q02bAgenteOfi pk)

        throws Exception {

        final String TRACE_METODO = ":borrarAgenteOfi";



        if (tr.isTraceActive()) {

            tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +

                ": entrando");

        }



        //se crean los objetos necesarios

        Q02bTablaBDQ022ZS00 objTBD = null; // Objeto TablasBD de tabla



        try {

            //se crea el objeto de tablasBD

            objTBD = new Q02bTablaBDQ022ZS00(this.getConnection());



            // Asignacion de filtro seg?n la PK

            if (Q02bFormatData.esVacio(pk.getIdAgente() ) ||

            		Q02bFormatData.esVacio(pk.getIdOfi())) {

                // Si esta vacio o nulo, implica error

                if (tr.isTraceActive()) {

                    tr.trace(COMPONENTE, Q70TraceLevel.ERROR,

                        TRACE_METODO + ": PK tiene campos vacios");

                    tr.trace(COMPONENTE, Q70TraceLevel.ERROR,

                        TRACE_METODO + pk.toString());

                }



                // Generar una excepcion		

                throw new Exception("Primary Key  con campos vacios");

            } else {

                objTBD.setQ022HT00_ID_OFI_WHERE(Integer.parseInt(pk.getIdOfi()));

                objTBD.setQ022JT00_ID_AGEN_WHERE(Integer.parseInt(pk.getIdAgente()));

            }



            //se asignan los campos de auditoria

            //objTBD.setAuditUser(new Long(this.getUser()));

            objTBD.delete();

        } catch (Exception ex) {

            java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw);

            tr.trace(COMPONENTE, Q70TraceLevel.ERROR,

                TRACE_METODO + ": " + sw.getBuffer().toString());

            throw ex;

        } finally {

            try {

                objTBD.freeResourcesNotConnection();

            } catch (Exception ex) {

                if (tr.isTraceActive()) {

                    tr.trace(COMPONENTE, Q70TraceLevel.ERROR,

                        TRACE_METODO + ": error liberando recursos");

                }

            }



            if (tr.isTraceActive()) {

                tr.trace(COMPONENTE, Q70TraceLevel.INFO,

                    TRACE_METODO + ": saliendo");

            }

        }

    }



    // -------------------- FIN - DELETE ----------------------- 

}

