set time on;
set echo on;

set feedback 1;

spool /aplic/q02b/scripts/q022et00.lst;

SELECT TO_CHAR(SYSDATE,'DD-MM-YYYY:HH24:MI:SS') || 'INI q022et00' from dual;
 
WHENEVER SQLERROR EXIT SQL.SQLCODE;

CREATE TABLE Q022ET00 ( 
  Q022CT00_ID_GRUPO     NUMBER (8)    NOT NULL, 
  Q022ET00_ID_CUES      NUMBER (10)   NOT NULL, 
  Q022ET00_CLASU        VARCHAR2 (20), 
  Q022ET00_SUPSU        NUMBER (6), 
  Q022ET00_SUPTE        NUMBER (6), 
  Q022ET00_VALSU        NUMBER (12,2), 
  Q022ET00_NVPOG        NUMBER (3), 
  Q022ET00_NVPOE        NUMBER (3), 
  Q022ET00_NVTMG        NUMBER (3), 
  Q022ET00_NVTME        NUMBER (3), 
  Q022ET00_NALOD        NUMBER (3), 
  Q022ET00_NREAL        NUMBER (3), 
  Q022ET00_NVTOT        NUMBER (6), 
  Q022ET00_FEC_ALTA     DATE, 
  Q022ET00_FEC_MOD      DATE, 
  Q022ET00_FEC_BAJA     DATE, 
  Q022ET00_FIRMADO      NUMBER (1)    DEFAULT 0, 
  Q022ET00_CDEXP        VARCHAR2 (20), 
  Q022ET00_NVPOT        NUMBER (4), 
  Q022ET00_NLIBRE       NUMBER (4), 
  Q022ET00_OBSSU        VARCHAR2 (250), 
  Q022ET00_FADQ         DATE, 
  Q022ET00_ENTI         NUMBER (15), 
  Q022ET00_TVIA         VARCHAR2 (2), 
  Q022ET00_CALLE        NUMBER (15), 
  Q022ET00_POR_CL_POR   NUMBER (15), 
  Q022ET00_BLOQ         VARCHAR2 (3), 
  Q022ET00_NUME         NUMBER (4), 
  Q022ET00_BIS          VARCHAR2 (1), 
  Q022ET00_CDIR         VARCHAR2 (50), 
  Q022ET00_TIPADQ       VARCHAR2 (1), 
  Q022ET00_DX           NUMBER (16,9), 
  Q022ET00_DY           NUMBER (16,9), 
  Q022ET00_DIR_NUEVA    VARCHAR2 (250), 
  Q022ET00_FUERA_PLAZO  VARCHAR2 (1), 
  Q022ET00_USU_ALTA     VARCHAR2 (10)  DEFAULT -1 NOT NULL, 
  Q022ET00_USU_MODIF    VARCHAR2 (10)  DEFAULT -1, 
  CONSTRAINT PK_Q022ET00
  PRIMARY KEY ( Q022CT00_ID_GRUPO, Q022ET00_ID_CUES ) 
    USING INDEX 
     TABLESPACE Q0202E00 PCTFREE 10
     STORAGE ( INITIAL 131072 NEXT 40960 PCTINCREASE 50 ))
   TABLESPACE Q0201E00
   PCTFREE 10
   PCTUSED 40
   INITRANS 1
   MAXTRANS 255
  STORAGE ( 
   INITIAL 131072
   NEXT 40960
   PCTINCREASE 50
   MINEXTENTS 1
   MAXEXTENTS 2147483645
   FREELISTS 1 FREELIST GROUPS 1 )
   NOCACHE; 

ALTER TABLE Q022ET00 ADD  CONSTRAINT FK_Q022ET00_Q022C
 FOREIGN KEY (Q022CT00_ID_GRUPO) 
  REFERENCES Q02B.Q022CT00 (Q022CT00_ID_GRUPO) ;


COMMIT;
 
SELECT TO_CHAR(SYSDATE,'DD-MM-YYYY:HH24:MI:SS')  ||  'FIN q022et00' from dual;
 
SPOOL OFF;
EXIT;
