set time on;
set echo on;

set feedback 1;

spool /aplic/q02b/scripts/q022dt00.lst;

SELECT TO_CHAR(SYSDATE,'DD-MM-YYYY:HH24:MI:SS') || 'INI q022dt00' from dual;
 
WHENEVER SQLERROR EXIT SQL.SQLCODE;

CREATE TABLE Q022DT00 ( 
  Q022BT00_ID_GRUPO         NUMBER (8)    NOT NULL, 
  Q022DT00_ID_CUES          NUMBER (10)   NOT NULL, 
  Q022DT00_IDEN_LICEN       VARCHAR2 (25), 
  Q022DT00_FEC_ENT          DATE, 
  Q022DT00_ESTADO_LICEN     VARCHAR2 (1), 
  Q022DT00_CAUSA_BAJA       VARCHAR2 (1), 
  Q022DT00_ENTI             NUMBER (15), 
  Q022DT00_TVIA             VARCHAR2 (2), 
  Q022DT00_CALLE            NUMBER (15), 
  Q022DT00_POR_CL_POR       NUMBER (15), 
  Q022DT00_BLOQ             VARCHAR2 (3), 
  Q022DT00_NUME             NUMBER (4), 
  Q022DT00_BIS              VARCHAR2 (1), 
  Q022DT00_CDIR             VARCHAR2 (50), 
  Q022DT00_RS_PROMO         VARCHAR2 (100), 
  Q022DT00_CIF_DNI          VARCHAR2 (11), 
  Q022DT00_MUN_PROV         VARCHAR2 (2), 
  Q022DT00_MUN_MUNI         VARCHAR2 (3), 
  Q022DT00_ENTI_PRO         NUMBER (15), 
  Q022DT00_TVIA_PRO         VARCHAR2 (2), 
  Q022DT00_CALLE_PRO        NUMBER (15), 
  Q022DT00_POR_CL_POR_PRO   NUMBER (15), 
  Q022DT00_BLOQ_PRO         VARCHAR2 (3), 
  Q022DT00_NUME_PRO         NUMBER (4), 
  Q022DT00_BIS_PRO          VARCHAR2 (1), 
  Q022DT00_CDIR_PRO         VARCHAR2 (50), 
  Q022DT00_TLF              VARCHAR2 (9), 
  Q022DT00_MAIL             VARCHAR2 (80), 
  Q022DT00_FAX              VARCHAR2 (9), 
  Q022DT00_WEB              VARCHAR2 (80), 
  Q022DT00_PRESUPUESTO      NUMBER (14,2), 
  Q022DT00_F_INI            DATE, 
  Q022DT00_F_FIN            DATE, 
  Q022DT00_TIPO_OBRA        VARCHAR2 (1), 
  Q022DT00_USO_RES          VARCHAR2 (1), 
  Q022DT00_ACTIVIDAD        VARCHAR2 (2), 
  Q022DT00_NVN              NUMBER (5), 
  Q022DT00_NVR              NUMBER (5), 
  Q022DT00_NVL              NUMBER (3), 
  Q022DT00_NVVPO            NUMBER (3), 
  Q022DT00_NVVS             NUMBER (3), 
  Q022DT00_NVPOT            NUMBER (3), 
  Q022DT00_NVALDOT          NUMBER (3), 
  Q022DT00_NVREAL           NUMBER (3), 
  Q022DT00_NVVTMG           NUMBER (3), 
  Q022DT00_NVVTME           NUMBER (3), 
  Q022DT00_NTOT             NUMBER (4), 
  Q022DT00_NSP45            NUMBER (3), 
  Q022DT00_NSP75            NUMBER (3), 
  Q022DT00_NSP90            NUMBER (3), 
  Q022DT00_NSP120           NUMBER (3), 
  Q022DT00_NSPT             NUMBER (4), 
  Q022DT00_PRINC_USO        VARCHAR2 (1), 
  Q022DT00_PU_ESPECIF       VARCHAR2 (50), 
  Q022DT00_PRECIO_MED       NUMBER (10,2), 
  Q022DT00_OBS              VARCHAR2 (250), 
  Q022DT00_DX               NUMBER (16,9), 
  Q022DT00_DY               NUMBER (16,9), 
  Q022DT00_DX_PRO           NUMBER (16,9), 
  Q022DT00_DY_PRO           NUMBER (16,9), 
  Q022DT00_DIR_PRO_EXTERNO  VARCHAR2 (250), 
  Q022DT00_DIR_NUEVA        VARCHAR2 (250), 
  Q022DT00_FEC_ALTA         DATE          DEFAULT SYSDATE NOT NULL, 
  Q022DT00_FEC_MOD          DATE, 
  Q022DT00_NUMVIVFINALES    NUMBER (6), 
  Q022DT00_INDNUEPLREHAB    NUMBER (6), 
  Q022DT00_INDREHABNUMVIV   NUMBER (6), 
  Q022DT00_FUERA_PLAZO      VARCHAR2 (1), 
  Q022DT00_CODIGO_LICEN     VARCHAR2 (20), 
  Q022DT00_USU_ALTA         VARCHAR2 (10)  DEFAULT -1 NOT NULL, 
  Q022DT00_USU_MODIF        VARCHAR2 (10)  DEFAULT -1, 
  CONSTRAINT PK_Q022DT00
  PRIMARY KEY ( Q022BT00_ID_GRUPO, Q022DT00_ID_CUES ) ) 
    USING INDEX 
     TABLESPACE Q0202E00 PCTFREE 10
     STORAGE ( INITIAL 131072 NEXT 131072 PCTINCREASE 0 ))
   TABLESPACE Q0201E00
   PCTFREE 10
   PCTUSED 40
   INITRANS 1
   MAXTRANS 255
  STORAGE ( 
   INITIAL 131072
   NEXT 131072
   PCTINCREASE 0
   MINEXTENTS 1
   MAXEXTENTS 2147483645
   FREELISTS 1 FREELIST GROUPS 1 )
   NOCACHE; 


ALTER TABLE Q02B.Q022DT00 ADD  CONSTRAINT FK_Q022DT00_Q022B
 FOREIGN KEY (Q022BT00_ID_GRUPO) 
  REFERENCES Q02B.Q022BT00 (Q022BT00_ID_GRUPO) ;

COMMIT;
 
SELECT TO_CHAR(SYSDATE,'DD-MM-YYYY:HH24:MI:SS')  ||  'FIN q022dt00' from dual;
 
SPOOL OFF;
EXIT;
