CREATE OR REPLACE FUNCTION buscarDenoPromo (codPromo IN NUMBER,
	   tipoDef IN VARCHAR, tipoProv IN VARCHAR, activa IN NUMBER)
	   RETURN VARCHAR AS
BEGIN
	 DECLARE CURSOR cCal (codPromo NUMBER, tipo VARCHAR, activa NUMBER)
	 	IS SELECT GREATEST(NVL(CALI_SOLC_009, TO_DATE('01/01/0001', 'DD/MM/YYYY')),
	   				NVL(CALI_CONC_009,TO_DATE('01/01/0001', 'DD/MM/YYYY')),
	   				NVL(CALI_ACTA_009, TO_DATE('01/01/0001', 'DD/MM/YYYY'))) AS FECHA,
					CALI_DENO_009
			 FROM Q0209S00
			 WHERE PR_ID_009 = codPromo
	  	   	 AND CALI_ACT_009 = activa
	  	   	 AND CALI_TIPO_009 = tipo
			 ORDER BY FECHA DESC;

	   fecha  		  DATE;
	   denom  		  VARCHAR(100);
BEGIN
	 -- Se buscan las calificaciones definitivas de la promocin
	 -- que estn activas y se selecciona la que tenga la mayor fecha de todas
	 OPEN cCal(codPromo, tipoDef, activa);

 	 FETCH cCal INTO fecha, denom;
--	 DBMS_OUTPUT.Put_Line('fecha ' || fecha || ' - denom ' || denom);
	 CLOSE cCal;

	 IF (FECHA IS NOT NULL) THEN
--		DBMS_OUTPUT.Put_Line('tiene calificaciones definitivas');
	 	RETURN denom;
	 ELSE
--	 	 DBMS_OUTPUT.Put_Line('no tiene calificaciones definitivas');

 		 --Si no tiene calificaciones definitivas se hace la misma bsqueda para
 		 --las provisionales
		 OPEN cCal(codPromo, tipoProv, activa);

	 	 FETCH cCal INTO fecha, denom;
--		 DBMS_OUTPUT.Put_Line('fecha ' || fecha || ' - denom ' || denom);
		 CLOSE cCal;

		 IF (FECHA IS NOT NULL) THEN
--			DBMS_OUTPUT.Put_Line('tiene calificaciones provisionales');
		 	RETURN denom;
		 ELSE
--		 	 DBMS_OUTPUT.Put_Line('no tiene calificaciones provisionales');
		 	 RETURN '';
	     END IF;
	 END IF;


END;
END;
/

