set time on;

set echo on;

set feedback 1;

spool /aplic/q02b/scripts/000_Q022DV02_70013.lst;
 
SELECT TO_CHAR(SYSDATE,'DD-MM-YYYY:HH24:MI:SS') || 'INI 000_Q022DV02_70013' from dual;

WHENEVER SQLERROR EXIT SQL.SQLCODE;

CREATE OR REPLACE VIEW q022dv02 (
   q022bt00_id_grupo,
   q022dt00_id_cues,
   q022dt00_iden_licen,
   q022dt00_fec_ent,
   q022dt00_estado_licen,
   q022dt00_causa_baja,
   q022dt00_enti,
   q022dt00_tvia,
   q022dt00_calle,
   q022dt00_por_cl_por,
   q022dt00_bloq,
   q022dt00_nume,
   q022dt00_bis,
   q022dt00_cdir,
   q022dt00_rs_promo,
   q022dt00_cif_dni,
   q022dt00_mun_prov,
   q022dt00_mun_muni,
   q022dt00_enti_pro,
   q022dt00_tvia_pro,
   q022dt00_calle_pro,
   q022dt00_por_cl_por_pro,
   q022dt00_bloq_pro,
   q022dt00_nume_pro,
   q022dt00_bis_pro,
   q022dt00_cdir_pro,
   q022dt00_tlf,
   q022dt00_mail,
   q022dt00_fax,
   q022dt00_web,
   q022dt00_presupuesto,
   q022dt00_f_ini,
   q022dt00_f_fin,
   q022dt00_tipo_obra,
   q022dt00_uso_res,
   q022dt00_actividad,
   q022dt00_nvn,
   q022dt00_nvr,
   q022dt00_nvl,
   q022dt00_nvvpo,
   q022dt00_nvvs,
   q022dt00_nvpot,
   q022dt00_nvaldot,
   q022dt00_nvreal,
   q022dt00_nvvtmg,
   q022dt00_nvvtme,
   q022dt00_ntot,
   q022dt00_nsp45,
   q022dt00_nsp75,
   q022dt00_nsp90,
   q022dt00_nsp120,
   q022dt00_nspt,
   q022dt00_princ_uso,
   q022dt00_pu_especif,
   q022dt00_precio_med,
   q022dt00_obs,
   q022dt00_nora_t17_localizacion,
   q022dt00_dir_pro_externo,
   q022dt00_dir_nueva,
   fca02t00_codmunicip,
   fca02t00_codprovinc,
   q022dt00_numvivfinales,
   q022dt00_indnueplrehab,
   q022dt00_indrehabnumviv,
   q022dt00_fuera_plazo, 
   q022dt00_codigo_licen,
   q022dt00_usu_alta,
   q022dt00_usu_modif
)
AS
   SELECT q022ds00.q022bt00_id_grupo, q022dt00_id_cues, q022dt00_iden_licen,
          q022dt00_fec_ent, q022dt00_estado_licen, q022dt00_causa_baja,
          q022dt00_enti, q022dt00_tvia, q022dt00_calle, q022dt00_por_cl_por,
          q022dt00_bloq, q022dt00_nume, q022dt00_bis, q022dt00_cdir,
          q022dt00_rs_promo, q022dt00_cif_dni, q022dt00_mun_prov,
          q022dt00_mun_muni, q022dt00_enti_pro, q022dt00_tvia_pro,
          q022dt00_calle_pro, q022dt00_por_cl_por_pro, q022dt00_bloq_pro,
          q022dt00_nume_pro, q022dt00_bis_pro, q022dt00_cdir_pro, q022dt00_tlf,
          q022dt00_mail, q022dt00_fax, q022dt00_web, q022dt00_presupuesto,
          q022dt00_f_ini, q022dt00_f_fin, q022dt00_tipo_obra, q022dt00_uso_res,
          q022dt00_actividad, q022dt00_nvn, q022dt00_nvr, q022dt00_nvl,
          q022dt00_nvvpo, q022dt00_nvvs, q022dt00_nvpot, q022dt00_nvaldot,
          q022dt00_nvreal, q022dt00_nvvtmg, q022dt00_nvvtme, q022dt00_ntot,
          q022dt00_nsp45, q022dt00_nsp75, q022dt00_nsp90, q022dt00_nsp120,
          q022dt00_nspt, q022dt00_princ_uso, q022dt00_pu_especif,
          q022dt00_precio_med, q022dt00_obs,
          CASE
             WHEN (   TRIM (q022dt00_calle) = 0
                   OR TRIM (q022dt00_calle) = ''
                   OR TRIM (q022dt00_calle) IS NULL
                  ) THEN nora_t17_localidad.ds_o
             ELSE    nora_t17_localidad.ds_o
                  || DECODE (nora_t17_localidad.ds_o, '', '', ', ')
                  || nora_t17_calle.ds_o
                  || ' '
                  || DECODE (
                        q022dt00_bloq,
                        '0', '',
                        '', '',
                           'Bloque:'
                        || q022dt00_bloq
                     )
                  || ' '
                  || DECODE (
                        q022dt00_nume,
                        '0', '',
                        '', '',
                           'N:'
                        || q022dt00_nume
                     )
                  || ' '
                  || DECODE (
                        q022dt00_bis,
                        '0', '',
                        '', '',
                           'Bis: '
                        || q022dt00_bis
                     )
          END
                direccion,
          q022dt00_dir_pro_externo, q022dt00_dir_nueva,
          q022bs00.fca02t00_codmunicip, q022bs00.fca02t00_codprovinc,
          q022dt00_numvivfinales, q022dt00_indnueplrehab,
          q022dt00_indrehabnumviv, 
		  q022dt00_fuera_plazo, q022dt00_codigo_licen, q022dt00_usu_alta, q022dt00_usu_modif
     FROM q022ds00, nora_t17_localidad, nora_t17_calle, q022bs00
    WHERE q022ds00.q022dt00_enti = nora_t17_localidad.id(+)
      AND q022ds00.q022dt00_calle = nora_t17_calle.id(+)
      AND q022ds00.q022bt00_id_grupo = q022bs00.q022bt00_id_grupo;

commit;
SELECT TO_CHAR(SYSDATE,'DD-MM-YYYY:HH24:MI:SS')  ||  'FIN 000_Q022DV02_70013' from dual;

spool off;
set echo off;

exit;