CREATE OR REPLACE VIEW Q022GV01
(ALQ_ID_CUES, ALQ_ANNO, ALQ_MALQ, ALQ_TERR, ALQ_MUN, 
 ALQ_PRV1A, ALQ_ADQVI1, ALQ_NADQ1, ALQ_PROVI1, ALQ_NPRO1, 
 ALQ_OTRVI1, ALQ_OTRLT1, ALQ_NOTR1, ALQ_NTOT1, ALQ_PRV4A, 
 ALQ_ADQVI4, ALQ_NADQ4, ALQ_PROVI4, ALQ_NPRO4, ALQ_OTRVI4, 
 ALQ_OTRLT4, ALQ_NOTR4, ALQ_NTOT4, ALQ_TALQ, ALQ_NALQ, 
 ALQ_NSP45, ALQ_NSP75, ALQ_NSP90, ALQ_NSP90M, ALQ_NSPT, 
 ALQ_NRSP45, ALQ_NRSP75, ALQ_NRSP90, ALQ_NRSP90M, ALQ_NRSPT, 
 ALQ_NOCUP, ALQ_NDESA, ALQ_NDESO, ALQ_NDESOT, ALQ_DESOTR, 
 ALQ_NOCUT, ALQ_NVPOG, ALQ_NVPOE, ALQ_NVPOT, ALQ_NALOD, 
 ALQ_NREAL, ALQ_NLIBRE, ALQ_NVTMG, ALQ_NVTME, ALQ_NVTOT, 
 ALQ_NANT60M, ALQ_NANT30, ALQ_NANT10, ALQ_NANT10M, ALQ_NANTT, 
 ALQ_OBSAL, ALQ_OBSSU)
AS 
SELECT
  Q022GT00_ID_CUES         , 
  Q022GT00_ANO             , 
  Q022GT00_CONCEDIDO_LICEN , 
  Q022GT00_MUN_PROV        , 
  Q022GT00_MUN_MUNI        , 
  Q022GT00_PRV1A           , 
  Q022GT00_ADQVI1          , 
  Q022GT00_NADQ1           , 
  Q022GT00_PROVI1          , 
  Q022GT00_NPRO1           , 
  Q022GT00_OTRVI1          , 
  Q022GT00_OTRLT1          , 
  Q022GT00_NOTR1           , 
  Q022GT00_NTOT1           , 
  Q022GT00_PRV4A           , 
  Q022GT00_ADQVI4          , 
  Q022GT00_NADQ4           , 
  Q022GT00_PROVI4          , 
  Q022GT00_NPRO4           , 
  Q022GT00_OTRVI4          , 
  Q022GT00_OTRLT4          , 
  Q022GT00_NOTR4           , 
  Q022GT00_NTOT4           , 
  Q022GT00_TALQ            , 
  Q022GT00_NALQ            , 
  Q022GT00_NSP45           , 
  Q022GT00_NSP75           , 
  Q022GT00_NSP90           , 
  Q022GT00_NSP90M          , 
  Q022GT00_NSPT            , 
  Q022GT00_NRSP45          , 
  Q022GT00_NRSP75          , 
  Q022GT00_NRSP90          , 
  Q022GT00_NRSP90M         , 
  Q022GT00_NRSPT           , 
  Q022GT00_NOCUP           , 
  Q022GT00_NDESA           , 
  Q022GT00_NDESO           , 
  Q022GT00_NDESOT          , 
  Q022GT00_DESOTR          , 
  Q022GT00_NOCUT           , 
  Q022GT00_NVPOG           , 
  Q022GT00_NVPOE           , 
  Q022GT00_NVPOT           , 
  Q022GT00_NALOD           , 
  Q022GT00_NREAL           , 
  Q022GT00_NLIBRE          , 
  Q022GT00_NVTMG           , 
  Q022GT00_NVTME           , 
  Q022GT00_NVTOT           , 
  Q022GT00_NANT60M         , 
  Q022GT00_NANT30          , 
  Q022GT00_NANT10          , 
  Q022GT00_NANT10M         , 
  Q022GT00_NANTT           , 
  Q022GT00_OBSAL           , 
  Q022GT00_OBSSU            
FROM  Q022GT00
/

COMMENT ON COLUMN Q022GV01.ALQ_ID_CUES IS '#INF#ALQ_ID_CUES#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_ANNO IS '#INF#ALQ_ANNO#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_MALQ IS '#INF#ALQ_MALQ#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_TERR IS '#INF#ALQ_TERR#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_MUN IS '#INF#ALQ_MUN#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_PRV1A IS '#INF#ALQ_PRV1A#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_ADQVI1 IS '#INF#ALQ_ADQVI1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NADQ1 IS '#INF#ALQ_NADQ1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_PROVI1 IS '#INF#ALQ_PROVI1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NPRO1 IS '#INF#ALQ_NPRO1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_OTRVI1 IS '#INF#ALQ_OTRVI1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_OTRLT1 IS '#INF#ALQ_OTRLT1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NOTR1 IS '#INF#ALQ_NOTR1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NTOT1 IS '#INF#ALQ_NTOT1#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_PRV4A IS '#INF#ALQ_PRV4A#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_ADQVI4 IS '#INF#ALQ_ADQVI4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NADQ4 IS '#INF#ALQ_NADQ4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_PROVI4 IS '#INF#ALQ_PROVI4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NPRO4 IS '#INF#ALQ_NPRO4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_OTRVI4 IS '#INF#ALQ_OTRVI4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_OTRLT4 IS '#INF#ALQ_OTRLT4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NOTR4 IS '#INF#ALQ_NOTR4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NTOT4 IS '#INF#ALQ_NTOT4#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_TALQ IS '#INF#ALQ_TALQ#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NALQ IS '#INF#ALQ_NALQ#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NSP45 IS '#INF#ALQ_NSP45#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NSP75 IS '#INF#ALQ_NSP75#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NSP90 IS '#INF#ALQ_NSP90#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NSP90M IS '#INF#ALQ_NSP90M#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NSPT IS '#INF#ALQ_NSPT#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NRSP45 IS '#INF#ALQ_NRSP45#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NRSP75 IS '#INF#ALQ_NRSP75#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NRSP90 IS '#INF#ALQ_NRSP90#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NRSP90M IS '#INF#ALQ_NRSP90M#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NRSPT IS '#INF#ALQ_NRSPT#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NOCUP IS '#INF#ALQ_NOCUP#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NDESA IS '#INF#ALQ_NDESA#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NDESO IS '#INF#ALQ_NDESO#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NDESOT IS '#INF#ALQ_NDESOT#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_DESOTR IS '#INF#ALQ_DESOTR#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NOCUT IS '#INF#ALQ_NOCUT#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NVPOG IS '#INF#ALQ_NVPOG#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NVPOE IS '#INF#ALQ_NVPOE#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NVPOT IS '#INF#ALQ_NVPOT#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NALOD IS '#INF#ALQ_NALOD#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NREAL IS '#INF#ALQ_NREAL#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NLIBRE IS '#INF#ALQ_NLIBRE#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NVTMG IS '#INF#ALQ_NVTMG#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NVTME IS '#INF#ALQ_NVTME#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NVTOT IS '#INF#ALQ_NVTOT#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NANT60M IS '#INF#ALQ_NANT60M#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NANT30 IS '#INF#ALQ_NANT30#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NANT10 IS '#INF#ALQ_NANT10#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NANT10M IS '#INF#ALQ_NANT10M#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_NANTT IS '#INF#ALQ_NANTT#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_OBSAL IS '#INF#ALQ_OBSAL#INF#'
/

COMMENT ON COLUMN Q022GV01.ALQ_OBSSU IS '#INF#ALQ_OBSSU#INF#'
/



CREATE OR REPLACE VIEW Q022EV02
(Q022CT00_ID_GRUPO, MUN_PROV, MUN_MUNI, Q022CT00_ANO, Q22CT00_MES, 
 Q022ET00_ID_CUES, Q022ET00_CLASU, Q022ET00_SUPSU, Q022ET00_SUPTE, Q022ET00_VALSU, 
 Q022ET00_NVPOG, Q022ET00_NVPOE, Q022ET00_NVTMG, Q022ET00_NVTME, Q022ET00_NALOD, 
 Q022ET00_NREAL, Q022ET00_NVTOT, Q022ET00_FEC_ALTA, Q022ET00_FEC_MOD, Q022ET00_FEC_BAJA, 
 Q022ET00_FIRMADO, Q022ET00_CDEXP, Q022ET00_NVPOT, Q022ET00_NLIBRE, Q022ET00_OBSSU, 
 Q022ET00_FADQ, Q022ET00_ENTI, Q022ET00_TVIA, Q022ET00_CALLE, Q022ET00_POR_CL_POR, 
 Q022ET00_BLOQ, Q022ET00_NUME, Q022ET00_BIS, Q022ET00_CDIR, Q022ET00_TIPADQ, 
 Q022ET00_NORA_T17_LOCALIZACION, Q022ET00_DIR_NUEVA)
AS 
select 
  Q022CS00.Q022CT00_ID_GRUPO   ,
   MUN_PROV,
  MUN_MUNI,
  Q022CT00_ANO,
  Q22CT00_MES        ,
  Q022ET00_ID_CUES    ,
  Q022ET00_CLASU      ,
  Q022ET00_SUPSU      ,
  Q022ET00_SUPTE      ,
  Q022ET00_VALSU      ,
  Q022ET00_NVPOG      ,
  Q022ET00_NVPOE      ,
  Q022ET00_NVTMG      ,
  Q022ET00_NVTME      ,
  Q022ET00_NALOD      ,
  Q022ET00_NREAL      ,
  Q022ET00_NVTOT      ,
  Q022ET00_FEC_ALTA   ,
  Q022ET00_FEC_MOD    ,
  Q022ET00_FEC_BAJA   ,
  Q022ET00_FIRMADO    ,
  Q022ET00_CDEXP      ,
  Q022ET00_NVPOT      ,
  Q022ET00_NLIBRE     ,
  Q022ET00_OBSSU      ,
  Q022ET00_FADQ       ,
  Q022ET00_ENTI       ,
  Q022ET00_TVIA       ,
  Q022ET00_CALLE      ,
  Q022ET00_POR_CL_POR ,
  Q022ET00_BLOQ       ,
  Q022ET00_NUME       ,
  Q022ET00_BIS        ,
  Q022ET00_CDIR       ,
  Q022ET00_TIPADQ ,
  CASE WHEN ( TRIM(Q022ET00_CALLE) = 0 OR TRIM(Q022ET00_CALLE) = '' OR TRIM(Q022ET00_CALLE) IS NULL) THEN NORA_T17_LOCALIDAD.DS_O
       ELSE NORA_T17_LOCALIDAD.DS_O  || DECODE(NORA_T17_LOCALIDAD.DS_O,'','',', ')  || NORA_T17_CALLE.DS_O || ' ' ||  DECODE ( Q022ET00_BLOQ, '0' , '',  Q022ET00_BLOQ)  || ' '  || DECODE ( Q022ET00_NUME, '0' , '',  Q022ET00_NUME) || ' '||  DECODE( Q022ET00_BIS, '0','',Q022ET00_BIS)
  END DIRECCION,
  Q022ET00_DIR_NUEVA  
from Q022CS00 ,Q022ES00, NORA_T17_LOCALIDAD,NORA_T17_CALLE 
where 
Q022CS00.Q022CT00_ID_GRUPO=Q022ES00.Q022CT00_ID_GRUPO and
Q022ES00.Q022ET00_ENTI=NORA_T17_LOCALIDAD.ID(+)   and
Q022ES00.Q022ET00_CALLE=NORA_T17_CALLE.ID(+)
/

CREATE OR REPLACE SYNONYM Q022ES01V02 FOR Q022EV02;

CREATE OR REPLACE VIEW Q022WV01
(Q022WT00_NI, Q022NT00_CODIGO, Q022WT00_ID_GRUPO, Q022WT00_ID_CUES, DATOS_CUESTIONARIO, 
 LOCALIZACION, Q022WT00_DIRECCIN, Q022WT00_ESTADO, Q022WT00_FECHA_GRABACION, Q022WT00_OBSERVACIONES, 
 Q022YT00_DESC, Q022YT00_DESC_EUS, Q022NT00_DESC_ES, Q022NT00_DESC_EU)
AS 
SELECT "Q022WT00_NI", tablasolicitudes."Q022NT00_CODIGO",
          "Q022WT00_ID_GRUPO", "Q022WT00_ID_CUES", "DATOS_CUESTIONARIO",
          "LOCALIZACION", "Q022WT00_DIRECCIN", "Q022WT00_ESTADO",
          "Q022WT00_FECHA_GRABACION", "Q022WT00_OBSERVACIONES", q022yt00_desc,
          q022yt00_desc_eus, q022nt00_desc_es, q022nt00_desc_eu
     FROM (SELECT q022wt00_ni, q022nt00_codigo, q022wt00_id_grupo,
                  q022wt00_id_cues,
                  CASE
                     WHEN q022nt00_codigo = 'SM'
                        THEN (SELECT    q022ct00_ano
                                     || ';'
                                     || (CASE
                                            WHEN LENGTH (q22ct00_mes) = 1
                                               THEN '0' || q22ct00_mes
                                            ELSE '' || q22ct00_mes
                                         END
                                        )
                                     || ';'
                                     || mun_prov
                                     || ';'
                                     || mun_muni
                                     || ';'
                                     || desc_prov
                                     || ';'
                                     || desc_muni
                                     || ';'
                                     || q022et00_enti
                                     || ';'
                                     || desc_localidad
                                FROM q022es01v04
                               WHERE q022wt00_id_grupo = q022ct00_id_grupo
                                 AND q022wt00_id_cues = q022et00_id_cues)
                     WHEN q022nt00_codigo = 'VTM'
                        THEN (SELECT    q022bt00_ano
                                     || ';'
                                     || (CASE
                                            WHEN LENGTH (q022bt00_mes) = 1
                                               THEN '0' || q022bt00_mes
                                            ELSE '' || q022bt00_mes
                                         END
                                        )
                                     || ';'
                                     || fca02t00_codprovinc
                                     || ';'
                                     || fca02t00_codmunicip
                                     || ';'
                                     || desc_prov
                                     || ';'
                                     || desc_muni
                                     || ';'
                                     || q022dt00_enti
                                     || ';'
                                     || desc_localidad
                                FROM q022ds01v04
                               WHERE q022wt00_id_grupo = q022bt00_id_grupo
                                 AND q022wt00_id_cues = q022dt00_id_cues)
                  END datos_cuestionario,
                  CASE
                     WHEN q022nt00_codigo = 'VTM'
                        THEN (SELECT q022dt00_nora_t17_localizacion
                               FROM q022ds01v02
                               WHERE q022wt00_id_grupo = q022bt00_id_grupo
                                 AND q022wt00_id_cues = q022dt00_id_cues)
                     WHEN q022nt00_codigo = 'SM'
                        THEN (SELECT q022et00_nora_t17_localizacion
                                FROM q022es01v02
                               WHERE q022wt00_id_grupo = q022ct00_id_grupo
                                 AND q022wt00_id_cues = q022et00_id_cues)
                  END localizacion,
                  q022wt00_direccin, q022wt00_estado,
                  q022wt00_fecha_grabacion, q022wt00_observaciones
             FROM q022wt00) tablasolicitudes,
          tt_hrc_estsol_nora,
          q022nt00
    WHERE tablasolicitudes.q022wt00_estado = tt_hrc_estsol_nora.q022yt00_cod
      AND tablasolicitudes.q022nt00_codigo = q022nt00.q022nt00_codigo
/
