SET SERVEROUTPUT ON

DECLARE

vsSql VARCHAR2(1000);




-- Para poder eliminar tablas hay que eliminar previamente las posibles constraints (primero las secundarias y luego las primarias)
-- Ej: ALTER TABLE ... DROP CONSTRAINT ... Esto es lo mejor en este caso porque vamos a eliminar todos los objetos, pero si no es as
-- es mejor desabilitar las constraints y al terminar volver a habilitarlas

CURSOR CURFK -- Foreign Keys
IS
select 'ALTER TABLE ' || TABLE_NAME || ' DROP CONSTRAINT ' ||  CONSTRAINT_NAME AS SENTENCIA, CONSTRAINT_NAME AS OBJETO
FROM USER_CONSTRAINTS
WHERE OWNER = USER
AND CONSTRAINT_NAME NOT LIKE 'SYS_C%'
AND CONSTRAINT_TYPE = 'R'
ORDER BY CONSTRAINT_NAME, TABLE_NAME;


CURSOR CURPK -- Primary Keys
IS
select 'ALTER TABLE ' || TABLE_NAME || ' DROP PRIMARY KEY CASCADE ' AS SENTENCIA, CONSTRAINT_NAME AS OBJETO
FROM USER_CONSTRAINTS
WHERE OWNER = USER
AND CONSTRAINT_NAME NOT LIKE 'SYS_C%'
AND CONSTRAINT_TYPE='P'
ORDER BY CONSTRAINT_NAME, TABLE_NAME;


CURSOR CURDROPS
IS
select 'DROP ' ||object_type||' '||object_name as SENTENCIA, object_name AS OBJETO
from user_objects 
where object_type not in ('INDEX','PACKAGE BODY','TRIGGER','DATABASE LINK') and object_name NOT LIKE 'SYS_%';


-- CASO MUY ESPECIFICO DE X91B QUE TIENE TYPE QUE HAN DE BORRARSE UNOS ANTES QUE OTROS
CURSOR CURDROPSTYPE
IS
select 'DROP ' ||object_type||' '||object_name as SENTENCIA, object_name AS OBJETO
from user_objects
where object_type in ('TYPE') AND object_name like 'TBL%';

-- ndices y bodys de packages se eliminan automticamente al eliminar las tablas y las especificacion, respectivamente.
-- los dblinks no debemos eliminarlos, pues no nos corresponde crearlos a nosotros, sino a EJIE.
-- Los objetos de K80 y N55 que se han creado en M62 para no depender de estas aplicaciones no se borran


BEGIN

DBMS_OUTPUT.ENABLE(1000000);

-- Eliminar Foreign Keys

   FOR FILAFK IN CURFK
   LOOP
      
      DBMS_OUTPUT.PUT_LINE('Eliminando FOREN KEY ' || FILAFK.OBJETO || '......');
      vsSql := FILAFK.SENTENCIA;
      EXECUTE IMMEDIATE vsSql;

   END LOOP;


-- Eliminar Primary Keys


   FOR FILAPK IN CURPK
   LOOP

      DBMS_OUTPUT.PUT_LINE('Eliminando PRIMARY KEY ' || FILAPK.OBJETO || '......');
      vsSql := FILAPK.SENTENCIA;
      EXECUTE IMMEDIATE vsSql;

   END LOOP;


-- Eliminar objetos de tipo type que empiezan por TBL que han de ser borrados antes.


   FOR FILADROPT IN CURDROPSTYPE
   LOOP

      DBMS_OUTPUT.PUT_LINE('Eliminando TYPE ' || FILADROPT.OBJETO || '......');
      vsSql := FILADROPT.SENTENCIA;
      EXECUTE IMMEDIATE vsSql;

   END LOOP;

-- Eliminar objetos


   FOR FILADROP IN CURDROPS
   LOOP

      DBMS_OUTPUT.PUT_LINE('Eliminando OBJETO ' || FILADROP.OBJETO || '......');
      vsSql := FILADROP.SENTENCIA;
      EXECUTE IMMEDIATE vsSql;

   END LOOP;


END;
/



clear screen;

col object_name format a30;

select object_name, object_type from user_objects;



exit
