#****************************************
#obtener_copia_bck.sh
#****************************************

clear

echo "\r\r\r"

echo "***************************************************"
echo "* EXPORT DE LA BASE DE DATOS ACTUAL				 *"
echo "***************************************************"

#****************************************************
# EJECUTAMOS LA EXPORT DE LA BASE DE DATOS
#****************************************************

#************************************************************
# OBTENER USUARIO Y PASSWORD DE CONEXION A LA BASE DE DATOS
#************************************************************

. n38bd 32307 01 STRING
salida=$?
if [ "salida" -gt 0 ]; then
echo "Error al obtener los parametros de conexion"
echo "*******************************************"
echo "NO SE HA PODIDO REALIZAR LA COPIA DE BBDD."
echo "*******************************************"
exit 1
fi

USUARIO=`echo $STRING |cut -d '#' -f2`
PASSWORD=`echo $STRING |cut -d '#' -f3` 


#**************************************
#Localizacion de ficheros 
#**************************************

DIR_LOG=/datos/q02b/copias
# Si no existe lo crea
test -d ${DIR_LOG}
if [ ${?} -ne 0 ] ;then
   mkdir ${DIR_LOG}
fi

chmod 777 ${DIR_LOG}

rm ${DIR_LOG}/copiabbdd.dmp

echo "Exportando base de datos a ${DIR_LOG}/copiabbdd.dmp"
exp ${USUARIO}/${PASSWORD} file=${DIR_LOG}/copiabbdd.dmp log=${DIR_LOG}/copiabbdd.log

if [ "${?}" -ne 0 ]; then
	echo "Error al realizar la export"
else
	echo "Export de la BD realizado correctamente"	
fi

