/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.tags;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.displaytag.decorator.DecoratorFactory;
import org.displaytag.exception.MissingAttributeException;
import org.displaytag.exception.TagStructureException;
import org.displaytag.export.MediaTypeEnum;
import org.displaytag.model.Cell;
import org.displaytag.model.HeaderCell;
import org.displaytag.tags.TableTag;
import org.displaytag.util.Href;
import org.displaytag.util.HtmlAttributeMap;
import org.displaytag.util.MultipleHtmlAttribute;

public class ColumnTag
extends BodyTagSupport {
    private static Log log = LogFactory.getLog((Class)(class$org$displaytag$tags$ColumnTag == null ? (class$org$displaytag$tags$ColumnTag = ColumnTag.class$("org.displaytag.tags.ColumnTag")) : class$org$displaytag$tags$ColumnTag));
    private HtmlAttributeMap attributeMap = new HtmlAttributeMap();
    private HtmlAttributeMap headerAttributeMap = new HtmlAttributeMap();
    private String property;
    private String title;
    private boolean nulls;
    private boolean sortable;
    private boolean autolink;
    private int group = -1;
    private Href href;
    private String paramId;
    private String paramName;
    private String paramProperty;
    private String paramScope;
    private int maxLength;
    private int maxWords;
    private String decorator;
    private boolean alreadySorted = false;
    private List supportedMedia = Arrays.asList(MediaTypeEnum.ALL);
    static /* synthetic */ Class class$org$displaytag$tags$ColumnTag;
    static /* synthetic */ Class class$org$displaytag$tags$TableTag;

    public void setProperty(String value) {
        this.property = value;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public void setNulls(String value) {
        if (!Boolean.FALSE.toString().equals(value)) {
            this.nulls = true;
        }
    }

    public void setSortable(String value) {
        if (!Boolean.FALSE.toString().equals(value)) {
            this.sortable = true;
        }
    }

    public void setSort(String value) {
        this.setSortable(value);
    }

    public void setAutolink(String value) {
        if (!Boolean.FALSE.toString().equals(value)) {
            this.autolink = true;
        }
    }

    public void setGroup(String value) {
        try {
            this.group = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Invalid \"group\" attribute: value=\"" + value + "\""));
        }
    }

    public void setHref(String value) {
        this.href = new Href(value);
    }

    public void setParamId(String value) {
        this.paramId = value;
    }

    public void setParamName(String value) {
        this.paramName = value;
    }

    public void setParamProperty(String value) {
        this.paramProperty = value;
    }

    public void setParamScope(String value) {
        this.paramScope = value;
    }

    public void setMaxLength(int value) {
        this.maxLength = value;
    }

    public void setMaxWords(int value) {
        this.maxWords = value;
    }

    public void setWidth(String value) {
        this.attributeMap.put("width", value);
        this.headerAttributeMap.put("width", value);
    }

    public void setAlign(String value) {
        this.attributeMap.put("align", value);
        this.headerAttributeMap.put("align", value);
    }

    public void setBackground(String value) {
        this.attributeMap.put("background", value);
    }

    public void setBgcolor(String value) {
        this.attributeMap.put("bgcolor", value);
    }

    public void setHeight(String value) {
        this.attributeMap.put("height", value);
    }

    public void setNowrap(String value) {
        this.attributeMap.put("nowrap", value);
    }

    public void setValign(String value) {
        this.attributeMap.put("valign", value);
    }

    public void setStyleClass(String value) {
        this.setClass(value);
    }

    public void setClass(String value) {
        this.attributeMap.put("class", new MultipleHtmlAttribute(value));
    }

    public void addClass(String value) {
        Object classAttributes = this.attributeMap.get("class");
        if (classAttributes == null) {
            this.attributeMap.put("class", new MultipleHtmlAttribute(value));
        } else {
            ((MultipleHtmlAttribute)classAttributes).addAttributeValue(value);
        }
    }

    public void setHeaderClass(String value) {
        this.headerAttributeMap.put("class", new MultipleHtmlAttribute(value));
    }

    public void setHeaderStyleClass(String value) {
        this.setHeaderClass(value);
    }

    public void setDecorator(String value) {
        this.decorator = value;
    }

    public boolean availableForMedia(MediaTypeEnum mediaType) {
        return this.supportedMedia.contains(mediaType);
    }

    public void setMedia(String media) {
        if (StringUtils.isBlank((String)media) || media.toLowerCase().indexOf("all") > -1) {
            this.supportedMedia = Arrays.asList(MediaTypeEnum.ALL);
            return;
        }
        this.supportedMedia = new ArrayList();
        String[] values = StringUtils.split((String)media);
        int i = 0;
        while (i < values.length) {
            String value = values[i];
            if (!StringUtils.isBlank((String)value)) {
                MediaTypeEnum type = MediaTypeEnum.fromName(value.toLowerCase());
                if (type == null) {
                    String msg = "Unknown media type \"" + value + "\"; media must be one or more values, space separated." + " Possible values are:";
                    int j = 0;
                    while (j < MediaTypeEnum.ALL.length) {
                        MediaTypeEnum mediaTypeEnum = MediaTypeEnum.ALL[j];
                        msg = msg + " '" + mediaTypeEnum.getName() + "'";
                        ++j;
                    }
                    throw new IllegalArgumentException(msg + ".");
                }
                this.supportedMedia.add(type);
            }
            ++i;
        }
    }

    public int doEndTag() throws JspException {
        Cell cell;
        MediaTypeEnum currentMediaType = (MediaTypeEnum)((TagSupport)this).pageContext.findAttribute("mediaType");
        if (currentMediaType != null && !this.availableForMedia(currentMediaType)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("skipping column body, currentMediaType=" + currentMediaType));
            }
            return 0;
        }
        TableTag tableTag = (TableTag)TagSupport.findAncestorWithClass((Tag)this, (Class)(class$org$displaytag$tags$TableTag == null ? (class$org$displaytag$tags$TableTag = ColumnTag.class$("org.displaytag.tags.TableTag")) : class$org$displaytag$tags$TableTag));
        if (tableTag.isFirstIteration()) {
            HeaderCell headerCell = new HeaderCell();
            headerCell.setHeaderAttributes((HtmlAttributeMap)this.headerAttributeMap.clone());
            headerCell.setHtmlAttributes((HtmlAttributeMap)this.attributeMap.clone());
            headerCell.setTitle(this.title);
            headerCell.setSortable(this.sortable);
            headerCell.setColumnDecorator(DecoratorFactory.loadColumnDecorator(this.decorator));
            headerCell.setBeanPropertyName(this.property);
            headerCell.setShowNulls(this.nulls);
            headerCell.setMaxLength(this.maxLength);
            headerCell.setMaxWords(this.maxWords);
            headerCell.setAutoLink(this.autolink);
            headerCell.setGroup(this.group);
            if (this.href != null && this.paramId != null) {
                Href colHref = new Href(this.href);
                if (this.paramName != null || this.paramScope != null) {
                    StringBuffer expression = new StringBuffer();
                    if (this.paramScope != null && !"".equals(this.paramScope)) {
                        expression.append(this.paramScope).append("Scope.");
                    }
                    if (this.paramId != null) {
                        expression.append(this.paramName);
                    } else {
                        expression.append(tableTag.getName());
                    }
                    if (this.paramProperty != null && !"".equals(this.paramProperty)) {
                        expression.append('.').append(this.property);
                    }
                    Object paramValue = tableTag.evaluateExpression(expression.toString());
                    colHref.addParameter(this.paramId, paramValue);
                } else {
                    headerCell.setParamName(this.paramId);
                    headerCell.setParamProperty(this.paramProperty);
                }
                headerCell.setHref(colHref);
            }
            tableTag.addColumn(headerCell);
            if (log.isDebugEnabled()) {
                log.debug((Object)("columnTag.doEndTag() :: first iteration - adding header " + headerCell));
            }
        }
        if (this.property == null) {
            Object cellValue;
            if (this.getBodyContent() != null) {
                String value = null;
                BodyContent bodyContent = this.getBodyContent();
                if (bodyContent != null) {
                    value = bodyContent.getString();
                }
                if (value == null && this.nulls) {
                    value = "";
                }
                cellValue = value;
            } else if (tableTag.isEmpty()) {
                cellValue = Cell.EMPTY_CELL;
            } else {
                throw new MissingAttributeException(((Object)((Object)this)).getClass(), new String[]{"property attribute", "value attribute", "tag body"});
            }
            cell = new Cell(cellValue);
        } else {
            cell = Cell.EMPTY_CELL;
        }
        tableTag.addCell(cell);
        this.attributeMap.clear();
        this.headerAttributeMap.clear();
        this.paramName = null;
        this.decorator = null;
        this.setBodyContent(null);
        return super.doEndTag();
    }

    public void release() {
        super.release();
    }

    public int doStartTag() throws JspException {
        TableTag tableTag = (TableTag)TagSupport.findAncestorWithClass((Tag)this, (Class)(class$org$displaytag$tags$TableTag == null ? (class$org$displaytag$tags$TableTag = ColumnTag.class$("org.displaytag.tags.TableTag")) : class$org$displaytag$tags$TableTag));
        if (tableTag == null) {
            throw new TagStructureException(((Object)((Object)this)).getClass(), "column", "table");
        }
        if (tableTag.isEmpty()) {
            return 0;
        }
        MediaTypeEnum currentMediaType = (MediaTypeEnum)((TagSupport)this).pageContext.findAttribute("mediaType");
        if (!this.availableForMedia(currentMediaType)) {
            return 0;
        }
        return super.doStartTag();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SIMPLE_STYLE).append("bodyContent", (Object)this.bodyContent).append("group", this.group).append("maxLength", this.maxLength).append("decorator", (Object)this.decorator).append("href", (Object)this.href).append("title", (Object)this.title).append("paramScope", (Object)this.paramScope).append("property", (Object)this.property).append("paramProperty", (Object)this.paramProperty).append("headerAttributeMap", (Object)this.headerAttributeMap).append("paramName", (Object)this.paramName).append("autolink", this.autolink).append("nulls", this.nulls).append("maxWords", this.maxWords).append("attributeMap", (Object)this.attributeMap).append("sortable", this.sortable).append("paramId", (Object)this.paramId).append("alreadySorted", this.alreadySorted).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

