/*
 * Decompiled with CFR 0.152.
 */
package org.displaytag.export;

import org.apache.commons.lang.StringUtils;
import org.displaytag.export.BaseExportView;
import org.displaytag.model.TableModel;

public class CsvView
extends BaseExportView {
    public CsvView(TableModel tableModel, boolean exportFullList, boolean includeHeader) {
        super(tableModel, exportFullList, includeHeader);
    }

    protected String getRowStart() {
        return "";
    }

    protected String getRowEnd() {
        return "\n";
    }

    protected String getCellStart() {
        return "";
    }

    protected String getCellEnd() {
        return ",";
    }

    protected String getDocumentStart() {
        return "";
    }

    protected String getDocumentEnd() {
        return "";
    }

    protected boolean getAlwaysAppendCellEnd() {
        return false;
    }

    protected boolean getAlwaysAppendRowEnd() {
        return true;
    }

    public String getMimeType() {
        return "text/csv";
    }

    protected Object escapeColumnValue(Object value) {
        if (value != null) {
            String stringValue = StringUtils.trim((String)value.toString());
            if (!StringUtils.containsNone((String)stringValue, (char[])new char[]{'\n', ','})) {
                return "\"" + StringUtils.replace((String)stringValue, (String)"\"", (String)"\\\"") + "\"";
            }
            return stringValue;
        }
        return null;
    }
}

