/*
 * Decompiled with CFR 0.152.
 */
package es.ejie.frmk.presentacion.iu.taglib.html.menu.displayer;

import es.ejie.frmk.control.excepciones.Q70FrameworkException;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.presentacion.iu.taglib.html.menu.base.Q70MenuComponent;
import es.ejie.frmk.presentacion.iu.taglib.html.menu.displayer.Q70MenuDisplayerMapping;
import es.ejie.frmk.presentacion.iu.taglib.html.menu.displayer.Q70MessageResourcesMenuDisplayer;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.struts.util.RequestUtils;

public class Q70DHTMLCascadeMenuDisplayer
extends Q70MessageResourcesMenuDisplayer {
    private static Q70Traza tr = Q70Traza.getSingleton();
    private static MessageFormat menuMessage = new MessageFormat("oCMenu.makeMenu(''{0}'',''{1}'',''{2}'',''{3}'',''{4}'',''{5}''");
    private static final String SCRIPT_START = "<script language=\"javascript\" type=\"text/javascript\"> \r\n";
    private static final String SCRIPT_END = "</script>\n";
    private static final String END_STATEMENT = "\noCMenu.construct()\n";
    private static final String DEFAULT_JAVASCRIPTFILES = "dhtmlcascademenus.js,dhtmlcascademenu-config.js";

    protected String getJavaScriptsFilesDefault() {
        return DEFAULT_JAVASCRIPTFILES;
    }

    public void init(PageContext pageContext, Q70MenuDisplayerMapping q70MenuDisplayerMapping) throws JspException {
        block2: {
            super.init(pageContext, q70MenuDisplayerMapping);
            try {
                this.out.println(SCRIPT_START);
            }
            catch (Exception exception) {
                if (!tr.isTraceActive()) break block2;
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Q70DHTMLCascadeMenuDisplayer: Throwable recogida en metodo init():" + exception.getMessage());
            }
        }
    }

    public void display(Q70MenuComponent q70MenuComponent, PageContext pageContext) throws JspException, IOException {
        this.pageContext = pageContext;
        super.setSecureId(q70MenuComponent.getSecureId());
        boolean bl = 2 != super.getDisplayMode();
        StringBuffer stringBuffer = new StringBuffer();
        this.buildMenuString(q70MenuComponent, stringBuffer, bl, pageContext);
        this.out.print((Object)stringBuffer);
    }

    public void end(PageContext pageContext) {
        block2: {
            try {
                this.out.print(END_STATEMENT);
                this.out.print(SCRIPT_END);
            }
            catch (Exception exception) {
                if (!tr.isTraceActive()) break block2;
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Q70DHTMLCascadeMenuDisplayer: Throwable recogida en metodo end():" + exception.getMessage());
            }
        }
    }

    protected void buildMenuString(Q70MenuComponent q70MenuComponent, StringBuffer stringBuffer, boolean bl, PageContext pageContext) throws JspException {
        Q70MenuComponent[] q70MenuComponentArray;
        super.displayComponents(q70MenuComponent, pageContext);
        try {
            this.setPageLocation(q70MenuComponent);
        }
        catch (MalformedURLException malformedURLException) {
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Action o forward incorrecto: " + malformedURLException.getMessage());
                tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, "Estableciendo location a #");
            }
            q70MenuComponent.setLocation("#");
        }
        stringBuffer.append(menuMessage.format(this.getArgs(q70MenuComponent, bl)));
        stringBuffer.append(",'");
        stringBuffer.append(q70MenuComponent.getOnclick() == null ? "" : q70MenuComponent.getOnclick());
        stringBuffer.append("')\n");
        try {
            q70MenuComponentArray = q70MenuComponent.getMenuComponents();
        }
        catch (Q70FrameworkException q70FrameworkException) {
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, "Error en la obtenci\u00f3n de los menus. Q70CascadeMenuDisplayer");
            }
            RequestUtils.saveException((PageContext)pageContext, (Throwable)q70FrameworkException);
            throw new JspException("Error en la obtenci\u00f3n de los menus. Q70CascadeMenuDisplayer", (Throwable)q70FrameworkException);
        }
        if (q70MenuComponentArray.length > 0) {
            for (int i = 0; i < q70MenuComponentArray.length; ++i) {
                q70MenuComponentArray[i].setI18nKey(q70MenuComponent.getI18nKey());
                super.setSecureId(q70MenuComponentArray[i].getSecureId());
                q70MenuComponentArray[i].setPageContext(pageContext);
                q70MenuComponentArray[i].setListaI18nKey(this.getListaI18nKey());
                boolean bl2 = 2 != super.getDisplayMode();
                this.buildMenuString(q70MenuComponentArray[i], stringBuffer, bl2, pageContext);
            }
        }
    }

    protected String[] getArgs(Q70MenuComponent q70MenuComponent, boolean bl) throws JspException {
        String[] stringArray = new String[10];
        stringArray[0] = q70MenuComponent.getName().indexOf("null") == 0 ? this.obtenerNombreFuncional(q70MenuComponent) : q70MenuComponent.getName();
        stringArray[1] = this.getParentName(q70MenuComponent);
        stringArray[2] = this.getTitle(q70MenuComponent);
        stringArray[3] = q70MenuComponent.getUrl() == null ? "" : (bl ? q70MenuComponent.getUrl() : "");
        stringArray[4] = this.getTarget(q70MenuComponent);
        stringArray[5] = "";
        stringArray[6] = "";
        return stringArray;
    }

    private String obtenerNombreFuncional(Q70MenuComponent q70MenuComponent) {
        Pattern pattern = Pattern.compile("null{1}");
        Matcher matcher = pattern.matcher(q70MenuComponent.getName());
        return this.getParentName(q70MenuComponent) + matcher.replaceAll("item");
    }

    protected String getTitle(Q70MenuComponent q70MenuComponent) throws JspException {
        return this.getMessage(q70MenuComponent.getListaI18nKey(), q70MenuComponent.getTitle());
    }

    protected String getParentName(Q70MenuComponent q70MenuComponent) {
        String string = null;
        string = q70MenuComponent.getParentMenu() == null ? "" : q70MenuComponent.getParentMenu().getName();
        return string;
    }

    protected String getTarget(Q70MenuComponent q70MenuComponent) {
        String string = super.getTarget(q70MenuComponent);
        if (this.target == null) {
            string = "";
        }
        return string;
    }
}

