/*
 * Decompiled with CFR 0.152.
 */
package es.ejie.frmk.infraestructura.tablas;

import es.ejie.frmk.Q70Factoria;
import es.ejie.frmk.infraestructura.logs.incidencias.Q70LogIncidenciasInterface;
import es.ejie.frmk.infraestructura.tablas.Q70Catalogo;
import es.ejie.frmk.infraestructura.tablas.Q70GestorTablasCodigosBase;
import es.ejie.frmk.infraestructura.tablas.Q70GestorTablasCodigosServidor;
import es.ejie.frmk.infraestructura.tablas.Q70GestorTablasException;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.infraestructura.utilidades.concurrencia.Q70Lock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.collections.CollectionUtils;

public class Q70GestorTablasCodigosAplicacion
extends Q70GestorTablasCodigosBase {
    private static Q70GestorTablasCodigosAplicacion instancia = null;
    private static Q70Traza traza = Q70Traza.getSingleton();
    private Q70LogIncidenciasInterface logInc = Q70Factoria.getLogIncidencias();

    private Q70GestorTablasCodigosAplicacion() {
        this.setLock(new Q70Lock("tablasDeCodigos"));
    }

    public static Q70GestorTablasCodigosAplicacion getSingleton() {
        if (instancia == null) {
            instancia = new Q70GestorTablasCodigosAplicacion();
        }
        return instancia;
    }

    protected void doDestruir() {
        instancia = null;
    }

    public void setCatalog(Q70Catalogo q70Catalogo) throws Q70GestorTablasException {
        try {
            Collection collection = CollectionUtils.intersection(q70Catalogo.getTablas().keySet(), Q70GestorTablasCodigosServidor.getSingleton().getCatalog().getTablas().keySet());
            String string = "";
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (traza.isTraceActive()) {
                    traza.trace("TBLCOD", Q70TraceLevel.ERROR, "Se esta intentando a\u00f1adir una tabla al catalogo con el nombre logico '" + string + "', el cual ya existe en el catalogo de servidor");
                }
                if (this.logInc.isEnabled()) {
                    this.logInc.log((Throwable)new Q70GestorTablasException(((Object)((Object)this)).getClass().getName(), "setCatalog", "Se esta intentando a\u00f1adir una tabla al catalogo con el nombre logico '" + string + "', el cual ya existe en el catalogo de servidor", null));
                }
                this.doRemoveTablaCatalogo(q70Catalogo, string);
            }
            super.setCatalog(q70Catalogo);
        }
        catch (Exception exception) {
            if (traza.isTraceActive()) {
                traza.trace("TBLCOD", Q70TraceLevel.ERROR, "Se esta producido un error en el m\u00e9todo setCatalog de la clase Q70GestorTablasCodigosAplicacion");
            }
            throw new Q70GestorTablasException(((Object)((Object)this)).getClass().toString(), "setCatalog", "Se ha producido un error en el m\u00e9todo setCatalog", (Throwable)exception);
        }
    }

    public ArrayList selectRecordsFromTable(String string, String string2, String string3, Vector vector) throws Q70GestorTablasException, Exception {
        if (Q70GestorTablasCodigosServidor.getSingleton().tableExist(string)) {
            return Q70GestorTablasCodigosServidor.getSingleton().selectRecordsFromTable(string, string2, string3, vector);
        }
        return super.selectRecordsFromTable(string, string2, string3, vector);
    }

    public boolean tableExist(String string) {
        if (super.tableExist(string)) {
            return true;
        }
        return Q70GestorTablasCodigosServidor.getSingleton().tableExist(string);
    }

    public Map getInfoTable(String string) {
        if (Q70GestorTablasCodigosServidor.getSingleton().tableExist(string)) {
            return Q70GestorTablasCodigosServidor.getSingleton().getInfoTable(string);
        }
        return super.getInfoTable(string);
    }

    protected boolean isSobrepasadoMaximoTablasEnMem() {
        return Q70GestorTablasCodigosServidor.getSingleton().getMaximoNumeroTablasEnMemoria() == this.getNumTablasCargadasEnMemoria();
    }
}

