/**
 * Clase que encapsula una coleccion de parametros en forma de diccionario (acceso por clave)
 * y de array (acceso por indice)
 * @constructor
 * @return Nuevo objeto WindowParameters
 */

function WindowParameters(bLoad){
	this.parameter=new Array();
	this.PRV_inverseParameter=new Array();
	
	if (bLoad){
		this.loadOutPutParameters();
	}
}


/******************/
/*** PROPIEDADES***/
/******************/

/**
 * Array accesible por indice <i>objeto.parameters[0]</i> o por clave <i>objeto.parameters[</i>stringKey<i>]</i>
 * que contiene la coleccion de pares clave - valor. 
 * @type Array	 
 */	
WindowParameters.prototype.parameter=null;
WindowParameters.prototype.PRV_inverseParameter=null;


/*******************************/
/*** DEFINICION DE FUNCIONES ***/
/*******************************/
WindowParameters.prototype.add=PRV_WindowParameters_Add;
/*
* Obtiene el numero de parametros en la coleccion
* @return Numero de parametros en la coleccion
* @type int
*/
WindowParameters.prototype.getLength=function () {return this.parameter.length;};
WindowParameters.prototype.freeResources=WindowParameters_freeResources;
WindowParameters.prototype.toGDH = PRV_WindowParameters_toGDH;
WindowParameters.prototype.loadOutPutParameters = PRV_WindowParameters_loadOutPutParameters;


/***********************************/
/*** IMPLEMENTACION DE FUNCIONES ***/
/***********************************/
function WindowParameters_freeResources(){
	freeArray(this.parameter);
	this.parameter = null;

	freeArray(this.PRV_inverseParameter);
	this.PRV_inverseParameter = null;
}

/**
	* Aade el par clave - valor especificado al array parameters, tanto por indice como por clave
	* @param key String conteniendo el nombre de la clave
	* @param value String conteniendo el valor asignado a la clave	 	 
	*/	
function PRV_WindowParameters_Add(key,value)
{
	//si el parametro ya existe, se sobreescribe su valor
	if (this.parameter[key]!=undefined)
	{
		this.parameter[key]=value;
		this.parameter[this.PRV_inverseParameter[key]].value=value;	
	}
	else
	{
		var obj=new Object();
		obj.key=key;
		obj.value=value;
		this.parameter.push(obj);
		this.parameter[key]=value;
		this.PRV_inverseParameter[key]=this.parameter.length-1;
	}
}


function PRV_WindowParameters_toGDH(dsID,gdh,dePrefix,gdhGroupName){
	if(!gdhGroupName) gdhGroupName = "DATA";
	if(!gdh)
		gdh = new GenericDataHandler();

	if(dePrefix) dePrefix = dePrefix+".";
	for (var i=0; i<this.getLength(); i++){
		if (this.parameter[i].key.indexOf(dsID)>=0){
			gdh.setData(this.parameter[i].value,gdhGroupName+gdh.DEFAULT_SEPARATOR+this.parameter[i].key,gdh.DEFAULT_SEPARATOR);
		}
	}
	return gdh;
}


function PRV_WindowParameters_loadOutPutParameters(oContainer){
	if (!oContainer){
		oContainer = WND_WINDOW;
	}
	if (oContainer.PRV_controlArray.length>0){
		for (var i=0; i<oContainer.PRV_controlArray.length; i++){
			if ((oContainer.PRV_controlArray[i] instanceof ARQ_imsprocess) || (oContainer.PRV_controlArray[i] instanceof ARQ_maint)){
				var sInitDEParameters = oContainer.PRV_controlArray[i].PRV_dsFields["OUTPUT_PARAMETER"];
				if(!sInitDEParameters) continue;
				var aInitDEParameters=sInitDEParameters.split(",");
				for (var j=0; j<aInitDEParameters.length; j++){
					try{
						var aCtrls = oContainer.PRV_controlArray[i].PRV_dataElementContainer["OUTPUT_PARAMETER."+aInitDEParameters[j]].split(";");
							for (var h=0; h<aCtrls.length; h++){
								var ctrl = eval(aCtrls[h]);
								this.add(aInitDEParameters[j],ctrl.getValue());
							}
					}catch(ex){}
				}			
			}else{//si no es un maint ni un imsProcess mira q es 
				if (oContainer.PRV_controlArray[i] instanceof ARQ_abstractContainer){//es tab o un folder
					PRV_WindowParameters_loadOutPutParameters(oContainer.PRV_controlArray[i]);
				}else{//es un control simple
					var aux = oContainer.PRV_controlArray[i].PRV_dataElement;
					if(aux){
						aux = aux.split(";");
						var paramName = null;
						for(var j=0;j<aux.length;j++){
							if(aux[j].indexOf("OUTPUT_PARAMETER.")>=0){
								this.add(aux[j].substring(17),oContainer.PRV_controlArray[i].getValue());
							}
						}
					}			
				}
			}//ELSE DEL INSTANCEOF ARQ_imsprocess Y ARQ_maint
		}//FOR
	}//IF
}
