package q02a.cuestionariosVTMAnu.action;

import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import q02a.exe.comun.Q02aImprimirExcel;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;

/**
 * @author GADIMAAR
 */

public class Q02aPrepararImprimirExcel extends Q70ActionPasoOP {
    
   private Map datos = new HashMap();
 
   private int columnas = 0;
 
   private int criterios = 0;
   private static final int LIMITE_10 = 10;
   private static final int LIMITE_100 = 100;
 
   protected void processOP(Q70ContextoEJIE contexto, ActionErrors actionErrors, ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response)
     throws Exception {
       
       System.out.println(" -- // Q02aPrepararImprimirExcel // -- ");
       
     Q02aImprimirExcel imprimirExcel = new Q02aImprimirExcel();
     
     HashMap hashExportar = (HashMap)contexto.get("tablaExportar");//los datos que hemos dejado cargados en Q02aPrepararTablaExcelExpd
     String idioma = (String)contexto.get("idioma");
     leer(hashExportar, idioma);
     
     imprimirExcel.setDatos((HashMap)getDatos());
     imprimirExcel.setColumnas(getColumnas());
     imprimirExcel.setCriterios(getCriterios());
     
     ByteArrayOutputStream ficheroExcel = imprimirExcel.escribirExcel();
 
     if ((ficheroExcel != null) && (!ficheroExcel.equals(""))) {
         
         response.setContentType("application/vnd.ms-excel;charset=iso-8859-1");
         response.setHeader("Content-disposition", "attachment;filename=Tabla.xls");
           
         byte[] bytesFichero = ficheroExcel.toByteArray();
     
         ByteArrayInputStream fin = new ByteArrayInputStream(bytesFichero);
         ServletOutputStream out = response.getOutputStream();
           
         int dato;
         
         while (-1 != (dato = fin.read()))  {
             //int dato;
             out.write(dato);
             //dato = -1;
         }
         fin.close();
         out.flush();
         out.close();
         
     }else {
       new Exception(" Q02aPrepararImprimirExcel --> Error en el servlet al generar el Excel");
     }
   }
   
   protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception{
        System.out.println("// Q02aPrepararImprimirExcel -- PROCESSFORWARD //");
       
        if ( errors.isEmpty() ){
           return mapping.findForward("ok");
       }
       return mapping.findForward("errores");
       
    }
   
   
   private void leer(Map lista, String idioma) throws Exception {
       
     String ficheroRecursos = "";
     String titulo = "";
     ArrayList cabecera = new ArrayList();
     ArrayList criteriosBusqueda = new ArrayList();
     ArrayList datosTabla = new ArrayList();
     Properties propiedades = null;
     setDatos(new HashMap());
     String cabeceraDescripcion = "Cabecera";
     String cabeceraAux = "";
     String cabeceraValor = "";
     HashMap criterioHash = null;
     String critDescripcion = "crit";
     String critAux = "";
     String critValor = "";
     String critValorDescripcion = "Valor";
     String critValorAux = "";
     String critValorPosicionAux = "";
     String critValorPosicionValor = "";
     String elemento = "elemento";
     
     
     if (lista != null) {//separa los datos que tenemos 
       titulo = (String)lista.get("titulo");
       ficheroRecursos = (String)lista.get("i18nkey");
       cabecera = (ArrayList)lista.get("cabecera");
       criteriosBusqueda = (ArrayList)lista.get("criteriosBusqueda");
       datosTabla = (ArrayList)lista.get("datosTabla");//datos
     }
     
     if (!"".equals(ficheroRecursos)) {
       propiedades = Q70GestorMensajesi18n.getSingleton().getProperties(ficheroRecursos, idioma);
     }
     
     if (propiedades != null) {
         getDatos().put("Titulo", propiedades.getProperty(titulo));
 
         setColumnas(cabecera.size());
         setCriterios(criteriosBusqueda.size());
         // TRATAR CABECERA Y GUARDAR 
         for (int i = 0; i < cabecera.size(); i++) {
             cabeceraAux = cabeceraDescripcion + i;
             cabeceraValor = (String)cabecera.get(i);
             getDatos().put(cabeceraAux, propiedades.getProperty(cabeceraValor));
         }
         //CRITERIOS DE BUSQUEDA
         for (int j = 0; j < criteriosBusqueda.size(); j++) {
             criterioHash = (HashMap)criteriosBusqueda.get(j);
             critAux = critDescripcion + j;
             critValorAux = critValorDescripcion + j;
             critValor = propiedades.getProperty((String)criterioHash.get("crit"));
             getDatos().put(critAux, critValor + ": " + (String)criterioHash.get("critValor"));
         }
         criterioHash = null;
         
         //
         for (int k = 0; k < datosTabla.size(); k++) {
             
             criterioHash = (HashMap)datosTabla.get(k);
             
             if (k < 10) {
                 critValorAux = critValorDescripcion + "00" + k + "_";
             }else if (k < 100) {
                 critValorAux = critValorDescripcion + "0" + k + "_";
             }else {
                 critValorAux = critValorDescripcion + k + "_";
             }
         
             for (int n = 0; n < criterioHash.size(); n++) {
                 if (n < 10)
                     critValorPosicionAux = critValorAux + "0" + n;
                 else {
                     critValorPosicionAux = critValorAux + n;
                 }
                 critValorPosicionValor = elemento + n;
                 getDatos().put(critValorPosicionAux, criterioHash.get(critValorPosicionValor));
             }
             
         
         }
     }
   }
   
   public int getColumnas(){
     return this.columnas;
   }
 
   public void setColumnas(int columnas){
     this.columnas = columnas;
   }

   public int getCriterios() {
     return this.criterios;
   }
 
   public void setCriterios(int criterios){
     this.criterios = criterios;
   }

   public Map getDatos() {
     return this.datos;
   }

   public void setDatos(Map datos)  {
     this.datos = datos;
   }
   
 }
