package q02aPlazosSesionEJB;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;

import q02a.exe.comun.Q02aAplicException;
import q02a.exe.comun.Q02aAutenticador;
import q02a.exe.plazos.beans.Q02aPlazosBean;
import q02a.exe.plazos.valueobjects.Q02aPlazos;
import q02a.exe.utils.Q02aVoUtils;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
 
/**
 * XDoclet-based session bean.  The class must be declared
 * public according to the EJB specification.
 *
 * To generate the EJB related files to this EJB:
 *		- Add Standard EJB module to XDoclet project properties
 *		- Customize XDoclet configuration for your appserver
 *		- Run XDoclet
 *
 * Below are the xdoclet-related tags needed for this EJB.
 * 
 * @ejb.bean name="Q02aPlazosSesion"
 *           display-name="Name for Q02aPlazosSesion"
 *           description="Description for Q02aPlazosSesion"
 *           jndi-name="ejb/Q02aPlazosSesion"
 *           type="Stateless"
 *           view-type="remote"
 */

public class Q02aPlazosSesionBean implements SessionBean {

	private static final long serialVersionUID = 4131248384461301469L;
	private static Q70Traza tr = Q70Traza.getSingleton();
	private static final String COMPONENTE = "EJB_SESION_DATOS";
	protected Q02aPlazosBean beanPlazos= null;

	/** The session context */

	private javax.ejb.SessionContext mySessionCtx;

    public Q02aPlazosSesionBean() {
		super();
		// TODO Auto-generated constructor stub
	}

	/**

	 * Set the associated session context. The container calls this method 

	 * after the instance creation.

	 * 

	 * The enterprise bean instance should store the reference to the context 

	 * object in an instance variable.

	 * 

	 * This method is called with no transaction context. 

	 * 

	 * @throws EJBException Thrown if method fails due to system-level error.

	 */

	/**

	 * getSessionContext

	 */

	public javax.ejb.SessionContext getSessionContext() {

		return mySessionCtx;

	}

	/**

	 * setSessionContext

	 */

	public void setSessionContext(javax.ejb.SessionContext ctx) {

		mySessionCtx = ctx;

	}



	public void ejbRemove() throws EJBException, RemoteException {
		// TODO Auto-generated method stub
	}

	public void ejbActivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub
	}

    public void ejbPassivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub
	}

	/**
	 * An ejbCreate method as required by the EJB specification.
	 * The container calls the instance?s <code>ejbCreate</code> method whose
	 * signature matches the signature of the <code>create</code> method invoked
	 * by the client. The input parameters sent from the client are passed to
	 * the <code>ejbCreate</code> method. Each session bean class must have at
	 * least one <code>ejbCreate</code> method. The number and signatures
	 * of a session bean?s <code>create</code> methods are specific to each 
	 * session bean class.
	 * 
	 * @throws CreateException Thrown if method fails due to system-level error.
	 * 
	 * @ejb.create-method
	 * 
	 */

	public void ejbCreate() throws CreateException {
		// TODO Add ejbCreate method implementation
	}  

	// -------------------------------------------------------------------------------------------------
	// ---------- PLAZOS  ----------
	// -------------------------------------------------------------------------------------------------

	/**
	 * Obtener la lista de plazos
	 * @return Devuelve la lista de plazos
	 * @throws Exception
	 */

	public ArrayList obtenerPlazos(Q02aAutenticador autenticador) throws Exception 
	{		
		ArrayList listaPlazos= new ArrayList(); 
		try{
			if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazos: entrando.");
	   		}		
			beanPlazos= new Q02aPlazosBean();
			beanPlazos.setAutenticador(autenticador);
			listaPlazos = beanPlazos.getPlazos();
			return listaPlazos;
		} catch(Q02aAplicException ex1){	 		  
	          java.io.StringWriter sw = new java.io.StringWriter();
	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	          ex1.printStackTrace(pw);
	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazos: " + sw.getBuffer ().toString());
	          throw ex1;       	
		}catch(Exception ex){	 	
			java.io.StringWriter sw = new java.io.StringWriter();
			java.io.PrintWriter pw = new java.io.PrintWriter(sw);
			ex.printStackTrace(pw);
			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerPlazos: " + sw.getBuffer ().toString());
			throw ex;                     
	 	}finally{    	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazos: saliendo.");
	   		}
	 	}
	}//fin obtenerPlazos

	/**
     * Metodo que dado el numero interno del plazo 
     * recuperara de la BBDD los datos de dicho cuestionario
     * @param niPlazo
     * @return plazo
     */ 
	public HashMap obtenerPlazo(String niPlazo, Q02aAutenticador autenticador) throws Exception 
	{		
		//Definici�n de variables
		HashMap plazo =  new HashMap(); 
		Q02aPlazos plazoVO = new Q02aPlazos();
		try{
			if (tr.isTraceActive())
			{
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazo ejb-> ** niPlazo=:" + niPlazo);	   			
	   		}			
			beanPlazos= new Q02aPlazosBean();
			
			//se pasa el autenticador
	  		beanPlazos.setAutenticador(autenticador);
	  		
	  		//se llama al m�todo del bean necesario			
	  		plazoVO = beanPlazos.obtenerPlazo(niPlazo);
	  		
	  		//se pasa el resultado a un hashMap
	  		plazo = (HashMap)Q02aVoUtils.getHashMap(plazoVO);
			return plazo;
		} catch(Q02aAplicException ex1){	 		  
	          java.io.StringWriter sw = new java.io.StringWriter();
	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	          ex1.printStackTrace(pw);
	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazo: " + sw.getBuffer ().toString());
	          throw ex1;       	
		}catch(Exception ex){	 	
			java.io.StringWriter sw = new java.io.StringWriter();
			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerPlazo: " + sw.getBuffer ().toString());

			throw ex;                     

	 	}finally{    	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazo: saliendo.");
	   		}
	 	}
	}//fin obtenerPlazo

	/**
     * M�todo que dado un plazo lo inserta en la BBDD 
     * insertara la BBDD los datos de dicho plazo
     * @param mapaPlazos
     */ 

	public void insertarPlazos(HashMap mapaPlazos, Q02aAutenticador autenticador) throws Exception 
	{
		Q02aPlazos plazo = null;
		try {
			if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarPlazos: entrando");
				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaPlazos : " + mapaPlazos.toString());
			}

			//se pasa el hashmap de entrada a un objeto de tipo Q02aCuestionarioVTMAnu	

			plazo = (Q02aPlazos) Q02aVoUtils.getValueObject(mapaPlazos,"q02a.exe.plazos.valueobjects.Q02aPlazos");


			//se instancia el bean de negocio
	  		beanPlazos= new Q02aPlazosBean();

	  		//se pasa el autenticador
	  		beanPlazos.setAutenticador(autenticador);

	  		//se llama al m�todo del bean necesario
	  		beanPlazos.insertarPlazos(plazo);		

	     }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw); 
            if (tr.isTraceActive()){  
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarPlazos: " + sw.getBuffer ().toString());
			}

            throw ex;

		 }finally{
			 if (tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarPlazos: saliendo");
			}			
		}
	} // fin insertarPlazos
	
	/**
	 * Borrar de bbdd un plazo
	 * @param niPlazo - N�mero interno del plazo a borrar
	 */
	public void borrarPlazos(String niPlazo, Q02aAutenticador autenticador) throws Exception
	{
		try {
			if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarPlazos: entrando con plazo: " + niPlazo);
			}
			beanPlazos= new Q02aPlazosBean();
			
            //se pasa el autenticador
	  		beanPlazos.setAutenticador(autenticador);

            //se llama al m�todo del bean necesario
			beanPlazos.borrarPlazos(niPlazo);			
	     }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarPlazos: " + sw.getBuffer ().toString());
			}

            throw ex;

		 }finally{

			 if (tr.isTraceActive()){

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarPlazos: saliendo");

			 }	

		 }			  

	} // fin borrarPlazos

	/**
	 * Modificar en bbdd un plazo con los datos pasados como par�metro en la HashMap
	 */

	public void modificarPlazos(HashMap mapaPlazos, Q02aAutenticador autenticador) throws Exception
	{
		Q02aPlazos plazo = null;	  	
		try {
			if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarPlazos: entrando");
				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaPlazos : " + mapaPlazos.toString());
			}			
			//se pasa el hashmap de entrada a un objeto de tipo Q02aPlazos
			plazo = (Q02aPlazos) Q02aVoUtils.getValueObject(mapaPlazos,"q02a.exe.plazos.valueobjects.Q02aPlazos");
			beanPlazos= new Q02aPlazosBean();
			//se pasa el autenticador
	  		beanPlazos.setAutenticador(autenticador);
			//se llama al metodo del bean para modificar el contacto
			beanPlazos.modificarPlazos(plazo);			
		}catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarPlazos: " + sw.getBuffer ().toString());
			}
            throw ex;
		 }finally{
			 if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarPlazos: saliendo");
			 }
		 }		
	} // fin modificarPlazos

	// --------------------------------------------------------------------------
	// ---------- FIN PLAZOS -----------
	// ---------------------------------------------------------------------------

} // fin clase
