package q02aCuestionariosSMAnuSesionEJB;

import java.io.File;
import java.io.StringReader;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;

import org.w3c.dom.Document;

import q02a.exe.comun.Q02aAplicException;
import q02a.exe.comun.Q02aAutenticador;
import q02a.exe.comun.Q02aDocumento;
import q02a.exe.cuestionariosSMAnu.beans.Q02aCuestionariosSMBean;
import q02a.exe.cuestionariosSMAnu.valueobjects.Q02aCuestionarioSM;
import q02a.exe.cuestionariosSMAnu.valueobjects.Q02aCuestionarioSMFiltro;
import q02a.exe.cuestionariosVTMAnu.beans.Q02aCuestionariosVTMAnuBean;
import q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMFiltro;
import q02a.exe.utils.Q02aVoUtils;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;

import q02a.exe.listados.Q02AUtils;
//import q02a.exe.ejbs.noraConsultas.*;
 
/**
 * XDoclet-based session bean.  The class must be declared
 * public according to the EJB specification.
 *
 * To generate the EJB related files to this EJB:
 *		- Add Standard EJB module to XDoclet project properties
 *		- Customize XDoclet configuration for your appserver
 *		- Run XDoclet
 *
 * Below are the xdoclet-related tags needed for this EJB.
 * 
 * @ejb.bean name="Q02aCuestionariosSMAnuSesion"
 *           display-name="Name for Q02aCuestionariosSMAnuSesion"
 *           description="Description for Q02aCuestionariosSMAnuSesion"
 *           jndi-name="ejb/Q02aCuestionariosSMAnuSesion"
 *           type="Stateless"
 *           view-type="remote"
 */

public class Q02aCuestionariosSMAnuSesionBean implements SessionBean {

	private static final long serialVersionUID = 4131248384461301469L;
	private static Q70Traza tr = Q70Traza.getSingleton();
	private static final String COMPONENTE = "EJB_SESION_DATOS";
	protected Q02aCuestionariosSMBean beanCuestionarioSMAnu= null;
	
	/** The session context */
	private javax.ejb.SessionContext mySessionCtx;

    /**
     * 
     *
     */
	public Q02aCuestionariosSMAnuSesionBean() {
		super();
		// TODO Auto-generated constructor stub
	}

    /**
	 * Set the associated session context. The container calls this method 
	 * after the instance creation.
	 * 
	 * The enterprise bean instance should store the reference to the context 
	 * object in an instance variable.
	 * 
	 * This method is called with no transaction context. 
	 * 
	 * @throws EJBException Thrown if method fails due to system-level error.
	 */

    /**
	 * getSessionContext
     * @return mySessionCtx
	 */

	public javax.ejb.SessionContext getSessionContext() {
		return mySessionCtx;
	}

	/**
	 * setSessionContext
     * @param ctx ctx
	 */

	public void setSessionContext(javax.ejb.SessionContext ctx) {
		mySessionCtx = ctx;
	}

    /**
     * @throws EJBException EJBException
     * @throws RemoteException RemoteException
     */
	public void ejbRemove() throws EJBException, RemoteException {
		// TODO Auto-generated method stub
	}

    /**
     * @throws EJBException EJBException
     * @throws RemoteException RemoteException
     */
	public void ejbActivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub
	}

    /**
     * @throws EJBException EJBException
     * @throws RemoteException RemoteException
     */
	public void ejbPassivate() throws EJBException, RemoteException {
		// TODO Auto-generated method stub
	}

	/**
	 * An ejbCreate method as required by the EJB specification.
	 * 
	 * The container calls the instance?s <code>ejbCreate</code> method whose
	 * signature matches the signature of the <code>create</code> method invoked
	 * by the client. The input parameters sent from the client are passed to
	 * the <code>ejbCreate</code> method. Each session bean class must have at
	 * least one <code>ejbCreate</code> method. The number and signatures
	 * of a session bean?s <code>create</code> methods are specific to each 
	 * session bean class.
	 * 
	 * @throws CreateException Thrown if method fails due to system-level error.
	 * 
	 * @ejb.create-method
	 * 
	 */

	public void ejbCreate() throws CreateException {
		// TODO Add ejbCreate method implementation
	}  
	// -------------------------------------------------------------------------------------------------
	// ---------- CUESTIONARIOS SUELO MUNICIPAL  ----------
	// -------------------------------------------------------------------------------------------------

	/**
	 * Insertar en bbdd un  nuevo cuestionario con los datos pasados como parmetro en la HashMap
     * @param mapaCuestionarioSM mapaCuestionarioSM
     * @param mapaFiltroPortadaCuestionarioSM mapaFiltroPortadaCuestionarioSM
     * @param autenticador autenticador
     * @throws Exception Exception
     * @return niGrupoCuesSM
     */

	public String insertarCuestionarioSM(HashMap mapaCuestionarioSM, HashMap mapaFiltroPortadaCuestionarioSM, Q02aAutenticador autenticador) throws Exception 
	{
		String niGrupoCuesSM = null;
		try {
			if (tr.isTraceActive()){     
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioSMAnu: entrando");
				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaCuestionarioSMAnu : " + mapaCuestionarioSM.toString());
			}
			//se instancia el bean de negocio
	  		beanCuestionarioSMAnu= new Q02aCuestionariosSMBean();
	  		//se pasa el autenticador
	  		beanCuestionarioSMAnu.setAutenticador(autenticador);
            
	  		//Llamamos al mtodo del bean
            //INSERTAR
	  		niGrupoCuesSM=beanCuestionarioSMAnu.insertarCuestionarioSM(mapaCuestionarioSM, mapaFiltroPortadaCuestionarioSM);
	  		//Devolvemos el id del grupo
	  		beanCuestionarioSMAnu.insertarContactoSM();
	  		return niGrupoCuesSM;			
	     }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw); 
            if (tr.isTraceActive()){  
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarCuestionarioSMAnu: " + sw.getBuffer ().toString());
			}
            throw ex;
		 }finally{
			 if (tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioSMAnu: saliendo");
			}			
		}
	} // fin insertarCuestionarioSM

    /**
	 * Borrar de bbdd un cuestionario
	 * 
	 * @param niCuestionarioSMAnu - Nmero interno del cuestionario a borrar
	 * @param niGrupoCuestionarioSMAnu niGrupoCuestionarioSMAnu
     * @param autenticador autenticador
     * @throws Exception Exception
     *
	 */

	public void borrarCuestionarioSMAnu(String niCuestionarioSMAnu,String niGrupoCuestionarioSMAnu, Q02aAutenticador autenticador) throws Exception
	{
		try {
			if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioSMAnu: entrando con cuestionario: " + niCuestionarioSMAnu);
			}
			beanCuestionarioSMAnu= new Q02aCuestionariosSMBean();
			//se pasa el autenticador
	  		beanCuestionarioSMAnu.setAutenticador(autenticador);
	  		//se llama al mtodo del bean necesario
			beanCuestionarioSMAnu.borrarCuestionarioSMAnu(niCuestionarioSMAnu,niGrupoCuestionarioSMAnu);			
	     }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioSMAnu: " + sw.getBuffer ().toString());
			}
            throw ex;
		 }finally{
			 if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioSMAnu: saliendo");
			 }	
		 }			 
		 
	} // fin borrarCuestionarioSMAnu

    /**
	 * Modificar en bbdd un cuestionario con los datos pasados como parmetro en la HashMap
	 * @param mapaCuestionarioSMAnu mapaCuestionarioSMAnu
     * @param autenticador autenticador
     * @throws Exception Exception
     * 
     */
	public void modificarCuestionarioSMAnu(HashMap mapaCuestionarioSMAnu, Q02aAutenticador autenticador) throws Exception
	{
		Q02aCuestionarioSM cuestionarioSMAnu = null;	  	
		try {
			if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioSMAnu: entrando");
				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaCuestionarioSMAnu : " + mapaCuestionarioSMAnu.toString());
			}			
			//se pasa el hashmap de entrada a un objeto de tipo Q02aCuestionarioSMAnu
			cuestionarioSMAnu = (Q02aCuestionarioSM) Q02aVoUtils.getValueObject(mapaCuestionarioSMAnu,"q02a.exe.cuestionariosSMAnu.valueobjects.Q02aCuestionarioSM");
			
			beanCuestionarioSMAnu= new Q02aCuestionariosSMBean();
			//se pasa el autenticador
	  		beanCuestionarioSMAnu.setAutenticador(autenticador);
			//se llama al metodo del bean para modificar el contacto
			beanCuestionarioSMAnu.modificarCuestionarioSMAnu(cuestionarioSMAnu);			
		}catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioSMAnu: " + sw.getBuffer ().toString());
			}
            throw ex;
		 }finally{
			 if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioSMAnu: saliendo");
			 }
		 }		
	} // fin modificarCuestionarioSMAnu
	
	/**
	/**
     * Mtodo que dado el nmero interno del cuestionario recuperara de la BBDD
     * los datos de dicho cuestionario
     * @param niCuestionarioSMAnu niCuestionarioSMAnu
     * @param niGrupoCuestionarioSMAnu - niGrupoCuestionarioSMAnu
     * @param autenticador autenticador
     * @return niGrupoCuestionarioSMAnu niGrupoCuestionarioSMAnu
     * @throws Exception Exception
     */
	 
	public HashMap obtenerCuestionarioSMAnu(String niCuestionarioSMAnu,String niGrupoCuestionarioSMAnu, Q02aAutenticador autenticador) throws Exception 
	{		
		//Definicin de variables
		HashMap cuestionarioSMAnu =  new HashMap(); 
		Q02aCuestionarioSM cuestionarioSMAnuVO = new Q02aCuestionarioSM();
		try{
			if (tr.isTraceActive())
			{
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioSMAnu ejb-> ** niCuestionarioSMAnu=:" + niCuestionarioSMAnu + "  , niGrupoCuestionarioSMAnu = " + niGrupoCuestionarioSMAnu+ " ** entrando.");	   			
	   		}			
			beanCuestionarioSMAnu= new Q02aCuestionariosSMBean();
			//se pasa el autenticador
	  		beanCuestionarioSMAnu.setAutenticador(autenticador);
	  		//se llama al mtodo del bean necesario			
	  		cuestionarioSMAnuVO = beanCuestionarioSMAnu.obtenerCuestionarioSMAnu(niCuestionarioSMAnu,niGrupoCuestionarioSMAnu);
	  		//se pasa el resultado a un hashMap
	  		cuestionarioSMAnu = (HashMap)Q02aVoUtils.getHashMap(cuestionarioSMAnuVO);
			return cuestionarioSMAnu;
		} catch(Q02aAplicException ex1){	 		  
	          java.io.StringWriter sw = new java.io.StringWriter();
	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	          ex1.printStackTrace(pw);
	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioSMAnu: " + sw.getBuffer ().toString());
	          throw ex1;       	
		}catch(Exception ex){	 	
			java.io.StringWriter sw = new java.io.StringWriter();
			java.io.PrintWriter pw = new java.io.PrintWriter(sw);
			ex.printStackTrace(pw);
			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioSMAnu: " + sw.getBuffer ().toString());
			throw ex;                     
	 	}finally{    	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioSMAnu: saliendo.");
	   		}
	 	}
	}//fin obtenerCuestionarioSMAnu
	
	
	
	/**
	 * Obtener la lista de cuestionarios
	 * 
	 * @param mapaFiltroPortadaCuestionarioSM - mapaFiltroPortadaCuestionarioSM
     * @param autenticador autenticador
     * @return Devuelve la lista de cuestionarios
	 * @throws Exception Exception
	 */

	public ArrayList obtenerCuestionariosSM(HashMap mapaFiltroPortadaCuestionarioSM, Q02aAutenticador autenticador) throws Exception 
	{		
		ArrayList listaCuestionariosSM= new ArrayList(); 
		try{
			if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionariosSM: entrando.");
	   		}		
			beanCuestionarioSMAnu= new Q02aCuestionariosSMBean();
			//se pasa el autenticador
	  		beanCuestionarioSMAnu.setAutenticador(autenticador);
			listaCuestionariosSM = beanCuestionarioSMAnu.getCuestionariosSM(mapaFiltroPortadaCuestionarioSM);
			return listaCuestionariosSM;
			
		} catch(Q02aAplicException ex1){	 		  
	          java.io.StringWriter sw = new java.io.StringWriter();
	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	          ex1.printStackTrace(pw);
	          tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionariosSM: " + sw.getBuffer ().toString());
	          throw ex1;       	
		}catch(Exception ex){	 	
			java.io.StringWriter sw = new java.io.StringWriter();
			java.io.PrintWriter pw = new java.io.PrintWriter(sw);
			ex.printStackTrace(pw);
			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionariosSM: " + sw.getBuffer ().toString());
			throw ex;                     
	 	}finally{    	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionariosSM: saliendo.");
	   		}
	 	}
	}//fin obtenerEntidades*/
	
	/**
     * Borrar todos los cuestionarios de un mes de una localidad en las dos tablas
     * @param mapaFiltroPortadaCuestionarioSM mapaFiltroPortadaCuestionarioSM
     * @param autenticador autenticador
     * 
     * @throws Exception
     */
    public void resetearCuestionariosMesSM(HashMap mapaFiltroPortadaCuestionarioSM, Q02aAutenticador autenticador) 
    throws Exception {
        
        Q02aCuestionarioSMFiltro cuestionariosSMFiltro = null;
        try{
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":resetearCuestionariosMesSM: entrando.");
                //tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaFiltroEntidad : " + mapaFiltroEntidad.toString());
            }           
            beanCuestionarioSMAnu= new Q02aCuestionariosSMBean();
            //se pasa el autenticador
            beanCuestionarioSMAnu.setAutenticador(autenticador);
            cuestionariosSMFiltro = (Q02aCuestionarioSMFiltro) Q02aVoUtils.getValueObject(mapaFiltroPortadaCuestionarioSM,"q02a.exe.cuestionariosSMAnu.valueobjects.Q02aCuestionarioSMFiltro");
            
            //se llama al metodo del bean necesario
            beanCuestionarioSMAnu.getResetearCuestionariosSM(cuestionariosSMFiltro);
            
        } catch(Q02aAplicException ex1){              
              java.io.StringWriter sw = new java.io.StringWriter();
              java.io.PrintWriter pw = new java.io.PrintWriter(sw);
              ex1.printStackTrace(pw);
              tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":resetearCuestionariosMesSM: " + sw.getBuffer ().toString());
              throw ex1;        
        }catch(Exception ex){       
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":resetearCuestionariosMesSM: " + sw.getBuffer ().toString());
            throw ex;                     
        }finally{       
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":resetearCuestionariosMesSM: saliendo.");
            }
        }
    }//fin resetearCuestionariosMesSM
    
    /**
     * Obtener la lista de cuestionarios
     * 
     * @param mapaFiltroPortadaCuestionarioSM - mapaFiltroPortadaCuestionarioSM
     * @param autenticador autenticador
     * @return Devuelve la lista de cuestionarios
     * 
     * @throws Exception Exception
     */

    public ArrayList cuestSinGrabarSM(HashMap mapaFiltroPortadaCuestionarioSM, Q02aAutenticador autenticador) throws Exception 
    {       
        ArrayList listaCuestionariosSM= new ArrayList(); 
        Q02aCuestionarioSMFiltro cuestionariosSMFiltro = null;
        try{
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":cuestSinGrabarSM: entrando.");
            }    
            
            beanCuestionarioSMAnu= new Q02aCuestionariosSMBean();
            //se pasa el autenticador
            beanCuestionarioSMAnu.setAutenticador(autenticador);
            
            cuestionariosSMFiltro = (Q02aCuestionarioSMFiltro) Q02aVoUtils.getValueObject(mapaFiltroPortadaCuestionarioSM,"q02a.exe.cuestionariosSMAnu.valueobjects.Q02aCuestionarioSMFiltro");
            cuestionariosSMFiltro.setPrevSuelo("1");
            
            listaCuestionariosSM = beanCuestionarioSMAnu.getCuestionariosSinGrabarSM(cuestionariosSMFiltro);
            
            
            return listaCuestionariosSM;
        } catch(Q02aAplicException ex1){              
              java.io.StringWriter sw = new java.io.StringWriter();
              java.io.PrintWriter pw = new java.io.PrintWriter(sw);
              ex1.printStackTrace(pw);
              tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":cuestSinGrabarSM: " + sw.getBuffer ().toString());
              throw ex1;        
        }catch(Exception ex){       
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":cuestSinGrabarSM: " + sw.getBuffer ().toString());
            throw ex;                     
        }finally{       
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":cuestSinGrabarSM: saliendo.");
            }
        }
    }//fin cuestSinGrabarVTM */
    
	/**
	 * Insertar/Modifica en bbdd un  nuevo grupo de cuestionarios con los datos pasados como parmetro en la HashMap de filtro
     * @param mapaCuestionarioSMAnuFiltro - mapaCuestionarioSMAnuFiltro
     * @param autenticador autenticador
     * @throws Exception Exception
     * @return niGrupoCuesSMAnu
     */
	public String altaModifGrupoCuestionariosSMAnu(HashMap mapaCuestionarioSMAnuFiltro, Q02aAutenticador autenticador) throws Exception 
	{
		String niGrupoCuesSMAnu=null;	
		try {
			if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: entrando");
			}
			//se instancia el bean de negocio
	  		beanCuestionarioSMAnu= new Q02aCuestionariosSMBean();
	  		//se pasa el autenticador
	  		beanCuestionarioSMAnu.setAutenticador(autenticador);
	  		//Llamamos al mtodo del bean
	  		niGrupoCuesSMAnu=beanCuestionarioSMAnu.altaModifGrupoCuestionariosSMAnu(mapaCuestionarioSMAnuFiltro);
	  		
	  		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: niGrupoCuestionarioSMAnu="+ niGrupoCuesSMAnu);
			return niGrupoCuesSMAnu;			
	     }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw); 
            if (tr.isTraceActive()){  
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: " + sw.getBuffer ().toString());
			}
            
            throw ex;
		 }finally{
			 if (tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: saliendo");
			}			
		}
	} // fin altaModifGrupoCuestionariosSMAnu

    /* //////////////////////////////////// PDF //////////////////////////////////// */
    /**
    /**
     * Mtodo que genera un pdf de un cuestionario
     * los datos de dicho cuestionario
     * @param niCuestionarioSMAnu niCuestionarioSMAnu
     * @param niGrupoCuestionarioSMAnu niGrupoCuestionarioSMAnu
     * @param autenticador autenticador
     * @param filtro filtro
     * @return cuestionarioSMAnu
     * @throws Exception Exception
     */
     
    public Q02aDocumento generarPdfCuestionarioSMAnu(String niCuestionarioSMAnu,String niGrupoCuestionarioSMAnu, Q02aAutenticador autenticador, HashMap filtro) throws Exception 
    {       
        //Definicin de variables
        HashMap cuestionarioSMAnu =  new HashMap(); 
        Q02aCuestionarioSM cuestionarioSMAnuVO = new Q02aCuestionarioSM();
        String idioma = autenticador.getIdioma();
        
        try{
            if (tr.isTraceActive())
            {
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":generarPdfCuestionarioSMAnu ejb-> ** niCuestionarioSMAnu=:" + niCuestionarioSMAnu + "  , niGrupoCuestionarioSMAnu = " + niGrupoCuestionarioSMAnu+ " ** entrando.");             
            }
            
            beanCuestionarioSMAnu= new Q02aCuestionariosSMBean();
            
            //se pasa el autenticador
            beanCuestionarioSMAnu.setAutenticador(autenticador);
            //se llama al mtodo del bean necesario         
            cuestionarioSMAnuVO = beanCuestionarioSMAnu.obtenerCuestionarioSMAnu(niCuestionarioSMAnu,niGrupoCuestionarioSMAnu);
            
            
            ////////////////////////////////////////////////////////////////////////////////
            
            File pdfFile=null;
            String charset = "UTF-8";
           String CONFIG_LISTADOS_PATH_TMP = "/datos/q02a/tmp";
           // String CONFIG_LISTADOS_PATH_TMP = "c:/datos/q02a/tmp";
           
            try{
                //final W08BConfiguration config = W08BConfiguration.getInstance();
                //final File tempPath = new File(config.get(CONFIG_LISTADOS_PATH_TMP));
                final File tempPath = new File(CONFIG_LISTADOS_PATH_TMP);
                pdfFile=File.createTempFile("CuestionarioSM", ".pdf", tempPath);
                //System.out.println(pdfFile);
            }catch(Exception e){
                //System.out.println("Excepcion al crear pdf temporal en listado solicitud deposito");
                throw new EJBException("Excepcion al crear pdf temporal en listado solicitud deposito", e);
            }
            
            try{
//              Descripciones provincia, municipio, localidad, tipoVia
                String desc_Entidad = ""; String desc_TipoVia = "";
                String desc_Calle = ""; String portal = "";
                
                desc_Entidad = cuestionarioSMAnuVO.getEntClEnt() == null?"":( q02a.exe.ejbs.noraConsultas.Q02AUtilsEjbs.getLocalidad( cuestionarioSMAnuVO.getEntClEnt().toString() ) ) ;
                desc_TipoVia = cuestionarioSMAnuVO.getTipoVia() == null?"":( q02a.exe.ejbs.noraConsultas.Q02AUtilsEjbs.getTipo_Via( cuestionarioSMAnuVO.getTipoVia().toString(), idioma ) ) ;
                desc_Calle = cuestionarioSMAnuVO.getNombreVia() == null?"":( q02a.exe.ejbs.noraConsultas.Q02AUtilsEjbs.getCalle( cuestionarioSMAnuVO.getNombreVia().toString(), idioma )  );
                portal = cuestionarioSMAnuVO.getNumePortal() == null?"":( cuestionarioSMAnuVO.getNumePortal().toString() );
                
                //Formamos el xml.
                String rutaXsl = "/html/datos/xsl/q02acuestionarioSM.xsl";
                
                //final String imgName = "/html/datos/xsl/images/escudo.gif";
                final String imgName = "/html/datos/xsl/images/logoPDF.jpg";
                final String uno = "/html/datos/xsl/images/uno.jpg";
                final String dos = "/html/datos/xsl/images/dos.jpg";
                final String tres = "/html/datos/xsl/images/tres.jpg";
                final String cuatro = "/html/datos/xsl/images/cuatro.jpg";
                final String cinco = "/html/datos/xsl/images/cinco.jpg";
                final String seis = "/html/datos/xsl/images/seis.jpg";
                final String siete = "/html/datos/xsl/images/siete.jpg";
                final String ocho = "/html/datos/xsl/images/ocho.jpg";
                final String nueve = "/html/datos/xsl/images/nueve.jpg";
                final String diez = "/html/datos/xsl/images/diez.jpg";
                String fin = "";
                if ( idioma.equals("es") ){
                        fin = "/html/datos/xsl/images/fin.jpg";
                }else{
                        fin = "/html/datos/xsl/images/amaiera.jpg";
                        rutaXsl = "/html/datos/xsl/q02acuestionarioSM_EU.xsl";
                }
                
                final String mes = filtro.get("mes").toString();
                final String anyo = filtro.get("ano").toString();
//              Num Cuestionario
                String numCuestionario = ("".equals(niCuestionarioSMAnu.toString()) ) ?"":( niCuestionarioSMAnu.toString() );
                final String descMuni = filtro.get("descMuni").toString();
                
                //TEXTOS
                final String textoDirServiciosEs = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.dirServicios",  "es");
                final String textoDirServiciosEus = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioVATM.dirServicios",  "eu");
                final String textoTituloSM = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.titulo",  idioma);
                final String textoPie = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.pie",  idioma);
                final String textoAnyo = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.anyo",  idioma);
                final String textoMes = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.mes",  idioma);
                final String textoNumCuestionario =  Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.numCuestionario",  idioma);
                final String titulo1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.titulo1",  idioma);
                final String titulo1_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.titulo1_1",  idioma);
                final String titulo2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.titulo2",  idioma);
                final String titulo3 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.titulo3",  idioma);
                final String titulo4 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.titulo4",  idioma);
                final String titulo5 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.titulo5",  idioma);
                final String titulo5_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.titulo5_1",  idioma);
                final String titulo6 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.titulo6",  idioma);
                final String titulo7 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.titulo7",  idioma);
                final String titulo7_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.titulo7_1",  idioma);
                final String titulo8 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.titulo8",  idioma);
                final String titulo9 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.titulo9",  idioma);
                final String titulo10 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.titulo10",  idioma);
                final String texto1A = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto1A",  idioma);
                final String texto1B = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto1B",  idioma);
                final String texto1C = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto1C",  idioma);
                final String texto1D = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto1D",  idioma);
                final String texto1E = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto1E",  idioma);
                final String texto5_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto5_1",  idioma);
                final String texto5_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto5_2",  idioma);
                final String texto5_3 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto5_3",  idioma);
                final String texto5_4 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto5_4",  idioma);
                final String texto5_5 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto5_5",  idioma);
                final String texto5_6 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto5_6",  idioma);
                final String texto5_7 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto5_7",  idioma);
                final String texto6 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto6",  idioma);
                final String texto7_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto7_1",  idioma);
                final String texto7_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto7_2",  idioma);
                final String texto8 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto8",  idioma);
                final String texto9_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto9_1",  idioma);
                final String texto9_2 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto9_2",  idioma);
                final String texto9_2_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto9_2_1",  idioma);
                final String texto9_3 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto9_3",  idioma);
                final String texto9_3_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto9_3_1",  idioma);
                final String texto9_4 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto9_4",  idioma);
                final String texto9_4_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto9_4_1",  idioma);
                final String texto9_5 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto9_5",  idioma);
                final String texto9_6 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto9_6",  idioma);
                final String texto9_7 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto9_7",  idioma);
                final String texto9_7_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto9_7_1",  idioma);
                final String texto9_8 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto9_8",  idioma);
                final String texto9_8_1 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto9_8_1",  idioma);
                final String texto9_9 = Q02AUtils.getI18nProperty( "q02arecursosCuestionarios",  "pdf.cuestionarioSM.texto9_9",  idioma);
                
                //XML
                StringBuffer xml= new StringBuffer("");
                xml.append("<?xml version=\"1.0\" encoding='ISO-8859-1'?>\n");
                xml.append("\t<cuestionario>\n");
                            
                       // xml.append("\t<url>").append(imgName.toString()).append("</url>\n");
                        xml.append("\t<url>").append(getClass().getResource(imgName).toString()).append("</url>\n");
                        //imagenes
                        xml.append("\t<uno>").append(getClass().getResource(uno).toString()).append("</uno>\n");
                        xml.append("\t<dos>").append(getClass().getResource(dos).toString()).append("</dos>\n");
                        xml.append("\t<tres>").append(getClass().getResource(tres).toString()).append("</tres>\n");
                        xml.append("\t<cuatro>").append(getClass().getResource(cuatro).toString()).append("</cuatro>\n");
                        xml.append("\t<cinco>").append(getClass().getResource(cinco).toString()).append("</cinco>\n");
                        xml.append("\t<seis>").append(getClass().getResource(seis).toString()).append("</seis>\n");
                        xml.append("\t<siete>").append(getClass().getResource(siete).toString()).append("</siete>\n");
                        xml.append("\t<ocho>").append(getClass().getResource(ocho).toString()).append("</ocho>\n");
                        xml.append("\t<nueve>").append(getClass().getResource(nueve).toString()).append("</nueve>\n");
                        xml.append("\t<diez>").append(getClass().getResource(diez).toString()).append("</diez>\n");
                        xml.append("\t<fin>").append(getClass().getResource(fin).toString()).append("</fin>\n");
                        //textos
                        xml.append("\t<tituloSM>").append( textoTituloSM ).append("</tituloSM>\n");
                        xml.append("\t<dirServiciosEus>").append( textoDirServiciosEus ).append("</dirServiciosEus>\n");
                        xml.append("\t<dirServiciosEs>").append( textoDirServiciosEs ).append("</dirServiciosEs>\n");
                        xml.append("\t<textoPie>").append( textoPie ).append("</textoPie>\n");
                        xml.append("\t<textoAnyo>").append( textoAnyo ).append("</textoAnyo>\n");
                        xml.append("\t<textoMes>").append( textoMes ).append("</textoMes>\n");
                        xml.append("\t<textoNumCuestionario>").append( textoNumCuestionario ).append("</textoNumCuestionario>\n");
                        xml.append("\t<titulo1>").append( titulo1 ).append("</titulo1>\n");
                        xml.append("\t<titulo1_1>").append( titulo1_1 ).append("</titulo1_1>\n");
                        xml.append("\t<titulo2>").append( titulo2 ).append("</titulo2>\n");
                        xml.append("\t<titulo3>").append( titulo3 ).append("</titulo3>\n");
                        xml.append("\t<titulo4>").append( titulo4 ).append("</titulo4>\n");
                        xml.append("\t<titulo5>").append( titulo5 ).append("</titulo5>\n");
                        xml.append("\t<titulo5_1>").append( titulo5_1 ).append("</titulo5_1>\n");
                        xml.append("\t<titulo6>").append( titulo6 ).append("</titulo6>\n");
                        xml.append("\t<titulo7>").append( titulo7 ).append("</titulo7>\n");
                        xml.append("\t<titulo7_1>").append( titulo7_1 ).append("</titulo7_1>\n");
                        xml.append("\t<titulo8>").append( titulo8 ).append("</titulo8>\n");
                        xml.append("\t<titulo9>").append( titulo9 ).append("</titulo9>\n");
                        xml.append("\t<titulo10>").append( titulo10 ).append("</titulo10>\n");
                        xml.append("\t<texto1A>").append( texto1A ).append("</texto1A>\n");
                        xml.append("\t<texto1B>").append( texto1B ).append("</texto1B>\n");
                        xml.append("\t<texto1C>").append( texto1C ).append("</texto1C>\n");
                        xml.append("\t<texto1D>").append( texto1D ).append("</texto1D>\n");
                        xml.append("\t<texto1E>").append( texto1E ).append("</texto1E>\n");
                        xml.append("\t<texto5_1>").append( texto5_1 ).append("</texto5_1>\n");
                        xml.append("\t<texto5_2>").append( texto5_2 ).append("</texto5_2>\n");
                        xml.append("\t<texto5_3>").append( texto5_3 ).append("</texto5_3>\n");
                        xml.append("\t<texto5_4>").append( texto5_4 ).append("</texto5_4>\n");
                        xml.append("\t<texto5_5>").append( texto5_5 ).append("</texto5_5>\n");
                        xml.append("\t<texto5_6>").append( texto5_6 ).append("</texto5_6>\n");
                        xml.append("\t<texto5_7>").append( texto5_7 ).append("</texto5_7>\n");
                        xml.append("\t<texto6>").append( texto6 ).append("</texto6>\n");
                        xml.append("\t<texto7_1>").append( texto7_1 ).append("</texto7_1>\n");
                        xml.append("\t<texto7_2>").append( texto7_2 ).append("</texto7_2>\n");
                        xml.append("\t<texto8>").append( texto8 ).append("</texto8>\n");
                        xml.append("\t<texto9_1>").append( texto9_1 ).append("</texto9_1>\n");
                        xml.append("\t<texto9_2>").append( texto9_2 ).append("</texto9_2>\n");
                        xml.append("\t<texto9_2_1>").append( texto9_2_1 ).append("</texto9_2_1>\n");
                        xml.append("\t<texto9_3>").append( texto9_3 ).append("</texto9_3>\n");
                        xml.append("\t<texto9_3_1>").append( texto9_3_1 ).append("</texto9_3_1>\n");
                        xml.append("\t<texto9_4>").append( texto9_4 ).append("</texto9_4>\n");
                        xml.append("\t<texto9_4_1>").append( texto9_4_1 ).append("</texto9_4_1>\n");
                        xml.append("\t<texto9_5>").append( texto9_5 ).append("</texto9_5>\n");
                        xml.append("\t<texto9_6>").append( texto9_6 ).append("</texto9_6>\n");
                        xml.append("\t<texto9_7>").append( texto9_7 ).append("</texto9_7>\n");
                        xml.append("\t<texto9_7_1>").append( texto9_7_1 ).append("</texto9_7_1>\n");
                        xml.append("\t<texto9_8>").append( texto9_8 ).append("</texto9_8>\n");
                        xml.append("\t<texto9_8_1>").append( texto9_8_1 ).append("</texto9_8_1>\n");
                        xml.append("\t<texto9_9>").append( texto9_9 ).append("</texto9_9>\n");
                        //
                        xml.append("\t<mes>").append( mes.toString() ).append("</mes>\n");
                        xml.append("\t<anyo>").append( anyo.toString() ).append("</anyo>\n");
                        xml.append("\t<descMuni>").append( descMuni.toString() ).append("</descMuni>\n");
                        xml.append("\t<numCuestionario>").append( numCuestionario ).append("</numCuestionario>\n");
                        
                            xml.append("\t<tipoActuacion>").append( cuestionarioSMAnuVO.getTipadq() == null?"":(cuestionarioSMAnuVO.getTipadq().toString()) ).append("</tipoActuacion>\n");
                            xml.append("\t<codigoExpediente>").append( cuestionarioSMAnuVO.getCodExpediente() == null?"":(cuestionarioSMAnuVO.getCodExpediente().toString())  ).append("</codigoExpediente>\n");
                            xml.append("\t<claveIdentificacion>").append( cuestionarioSMAnuVO.getClasu() == null?"":(cuestionarioSMAnuVO.getClasu().toString()) ).append("</claveIdentificacion>\n");
                            xml.append("\t<fechaAdquisicion>").append( cuestionarioSMAnuVO.getFecAdquisicion() == null?"":(cuestionarioSMAnuVO.getFecAdquisicion().toString()) ).append("</fechaAdquisicion>\n");
                            //ubicacion
                            xml.append("\t<entidad>").append( desc_Entidad ).append("</entidad>\n");
                            xml.append("\t<tipoVia>").append( desc_TipoVia ).append("</tipoVia>\n");
                            xml.append("\t<denominacionVia>").append( desc_Calle ).append("</denominacionVia>\n");
                            xml.append("\t<bloque>").append( cuestionarioSMAnuVO.getBloque() == null?"":(cuestionarioSMAnuVO.getBloque().toString()) ).append("</bloque>\n");
                            xml.append("\t<numero>").append( portal ).append("</numero>\n");
                            xml.append("\t<bis>").append( cuestionarioSMAnuVO.getBisPortal() == null?"":(cuestionarioSMAnuVO.getBisPortal().toString()) ).append("</bis>\n");
                            
                            if ( cuestionarioSMAnuVO.getDirNueva() != null ){
                                xml.append("\t<complementoDir>").append( cuestionarioSMAnuVO.getDirNueva().toString() ).append("</complementoDir>\n");
                            }else{
                                xml.append("\t<complementoDir>").append( cuestionarioSMAnuVO.getAcepcion() == null?"":(cuestionarioSMAnuVO.getAcepcion().toString()) ).append("</complementoDir>\n");
                            }
                            //
                            xml.append("\t<superficieTotal>").append( cuestionarioSMAnuVO.getSupSueloT() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioSMAnuVO.getSupSueloT().toString())) ).append("</superficieTotal>\n");
                            xml.append("\t<superficieConstruida>").append( cuestionarioSMAnuVO.getSupSueloC() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioSMAnuVO.getSupSueloC().toString())) ).append("</superficieConstruida>\n");
                            xml.append("\t<valoracionSuelo>").append( cuestionarioSMAnuVO.getCosteSuelo() == null?"":( q02a.exe.ejbs.utils.Q02AUtils.getPuntosMiles(cuestionarioSMAnuVO.getCosteSuelo().toString())) ).append("</valoracionSuelo>\n");
                            //viviendas previstas
                            xml.append("\t<vivPreLibre>").append( cuestionarioSMAnuVO.getLibres() == null?"":(cuestionarioSMAnuVO.getLibres().toString()) ).append("</vivPreLibre>\n");
                            xml.append("\t<vivPreVPO>").append( cuestionarioSMAnuVO.getVpoRG() == null?"":(cuestionarioSMAnuVO.getVpoRG().toString()) ).append("</vivPreVPO>\n");
                            xml.append("\t<vivPreVS>").append( cuestionarioSMAnuVO.getVpoRE() == null?"":(cuestionarioSMAnuVO.getVpoRE().toString()) ).append("</vivPreVS>\n");
                            xml.append("\t<vivPreVPOT>").append( cuestionarioSMAnuVO.getVpot() == null?"":(cuestionarioSMAnuVO.getVpot().toString()) ).append("</vivPreVPOT>\n");
                            xml.append("\t<vivPreAlojamientos>").append( cuestionarioSMAnuVO.getAlojDota() == null?"":(cuestionarioSMAnuVO.getAlojDota().toString()) ).append("</vivPreAlojamientos>\n");
                            xml.append("\t<vivPreViviendaRealojo>").append( cuestionarioSMAnuVO.getRealojos() == null?"":(cuestionarioSMAnuVO.getRealojos().toString()) ).append("</vivPreViviendaRealojo>\n");
                            xml.append("\t<vivPreVTMG>").append( cuestionarioSMAnuVO.getVtmRG() == null?"":(cuestionarioSMAnuVO.getVtmRG().toString()) ).append("</vivPreVTMG>\n");
                            xml.append("\t<vivPreVTME>").append( cuestionarioSMAnuVO.getVtmRE() == null?"":(cuestionarioSMAnuVO.getVtmRE().toString()) ).append("</vivPreVTME>\n");
                            xml.append("\t<vivPreTotal>").append( cuestionarioSMAnuVO.getTotalViv() == null?"":(cuestionarioSMAnuVO.getTotalViv().toString()) ).append("</vivPreTotal>\n");
                            //
                            xml.append("\t<observaciones>").append( cuestionarioSMAnuVO.getObservaciones() == null?"":(cuestionarioSMAnuVO.getObservaciones().toString()) ).append("</observaciones>\n");
                            
                xml.append("\t</cuestionario>");
                
                final String xmlString = xml.toString();
                //System.out.println(xmlString);
                StringReader stream = new StringReader(xmlString); 
                
                try{
                    //System.out.println("--- Antes de la llamada a pdf ---");
                    Q02AUtils.convertXML2PDF( stream, pdfFile, getClass().getResourceAsStream(rutaXsl));
                    //System.out.println("--- Despues de la llamada a pdf ---");
                    
                }catch (Exception e){
                    pdfFile.delete();
                    //System.out.println("Error al generar pdf imprimir CuestionarioSM" );
                    throw new EJBException("Error al generar pdf imprimir CuestionarioSM",e  );
                }
                pdfFile.deleteOnExit();
            }catch(Exception exp){
                pdfFile.delete();
                //System.out.println("Error al imprimir CuestionarioSM" );
                throw new EJBException("Error al imprimir CuestionarioSM",exp  );
            }
            //System.out.println("--- FIN ---");
            
            ///////////////////////////////////////////////////////////////////////////////
            
            return new Q02aDocumento("CuestionarioSM.pdf","application/pdf",charset,pdfFile);
            
        } catch(Q02aAplicException ex1){              
              java.io.StringWriter sw = new java.io.StringWriter();
              java.io.PrintWriter pw = new java.io.PrintWriter(sw);
              ex1.printStackTrace(pw);
              tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":generarPdfCuestionarioSMAnu: " + sw.getBuffer ().toString());
              throw ex1;        
        }catch(Exception ex){       
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":generarPdfCuestionarioSMAnu: " + sw.getBuffer ().toString());
            throw ex;                     
        }finally{       
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":generarPdfCuestionarioSMAnu: saliendo.");
            }
        }
    }//fin obtenerCuestionarioSMAnu
    
    
    /* //////////////////////////////////// FIN PDF //////////////////////////////////// */
    
	/**
	     * Metodo que se encarga de devolver un XML con los datos principales de los cuestionarios a firmar que no estn ya firmados.
	     * @param arrCuestionariosSMAnuFirma arrCuestionariosSMAnuFirma
	     * @param autenticador autenticador
         * @throws Exception Exception
	     * @return document
	     */
	    public Document obtenerXmlFirmaCuestionariosSMAnu(ArrayList arrCuestionariosSMAnuFirma, Q02aAutenticador autenticador) throws Exception{
	        final String TRACE_METODO = "Q02aCuestionariosSMAnuSesionBean:obtenerXmlFirmaCuestionariosSMAnu";

	        //Variable que se va a devolver
	        Document document = null;

	        if (tr.isTraceActive())
	        {
	            	tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +": entrando");
	        }
	        
	        try{
		            //Se instancia el bean de negocio
		            beanCuestionarioSMAnu= new Q02aCuestionariosSMBean();
		            //se pasa el autenticador
			  		beanCuestionarioSMAnu.setAutenticador(autenticador);
		            //Se obtiene la lista con los resultados
		            
		            tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +": ArrayList ="+ (arrCuestionariosSMAnuFirma==null?"Es nulo":Integer.toString(arrCuestionariosSMAnuFirma.size())));
		            //document=beanCuestionarioSMAnu.obtenerXmlFirmaCuestionariosSMAnu(arrCuestionariosSMAnuFirma);
		            //Se devuelve el objeto
		            return document;
	        }catch (Exception ex) 
	        {
		            java.io.StringWriter sw = new java.io.StringWriter();
		            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
		            ex.printStackTrace(pw);
		            tr.trace(COMPONENTE, Q70TraceLevel.ERROR,
		            TRACE_METODO + sw.getBuffer().toString());
	            throw ex;
	        } finally {
	            if (tr.isTraceActive()) {
	                tr.trace(COMPONENTE, Q70TraceLevel.INFO,
	                		TRACE_METODO + " saliendo.");
	            }
	        }
	    }
	   
        /**
         * 
         * @param niGrupoCuesSMAnu niGrupoCuesSMAnu
         * @param xmlFirmaGrupoCuestionariosSMAnu xmlFirmaGrupoCuestionariosSMAnu
         * @param autenticador autenticador
         * @throws Exception Exception
         */
	   public void guardarFirmaGrupoCuestionariosSMAnu(String niGrupoCuesSMAnu,String xmlFirmaGrupoCuestionariosSMAnu, Q02aAutenticador autenticador) throws Exception
	    {  	
		try {
			if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosSMAnu: entrando");
			}			
			
			beanCuestionarioSMAnu= new Q02aCuestionariosSMBean();
			//se pasa el autenticador
	  		beanCuestionarioSMAnu.setAutenticador(autenticador);
			//se llama al metodo del bean para modificar el contacto
			beanCuestionarioSMAnu.guardarFirmaGrupoCuestionariosSMAnu(niGrupoCuesSMAnu,xmlFirmaGrupoCuestionariosSMAnu);
		}
		catch(Exception ex)
		{
            			java.io.StringWriter sw = new java.io.StringWriter();
            			java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            			ex.printStackTrace(pw);
   			if (tr.isTraceActive())
   			{
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosSMAnu: " + sw.getBuffer ().toString());
			}
   			throw ex;
		 }finally
		 {
			 if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosSMAnu: saliendo");
			 }
		 }		
	} // fin guardarFirmaGrupoCuestionariosSMAnu

	// --------------------------------------------------------------------------
	// ---------- FIN CUESTIONARIOS SM ANU -----------
	// ---------------------------------------------------------------------------
} // fin clase
