// Fecha: 22-09-00; Autores: Josu Orbe & Leire Uriarte 

package q02a.exe.utils;
 
import java.text.*;
import java.util.*;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.Integer;
import java.lang.String;
import java.math.*;


/**
 * @author *
 *  Clase con funciones para formateo y adecuacin de los datos
*/
public class Q02aFormatData {

    /**
    * Pone un espacio a una cadena si esta es blancos.
    * @param cadena objeto cadenaque deseo testear.
    * @return El objeto cadena resultante.
    */
     public static String trimUno( String cadena)
    {
        cadena = cadena.trim();
        if ( cadena.length()== 0 ){
            cadena = " ";
        }    
        return cadena;
    }
     /**
    * Pone un cero a una cadena si esta es blancos.
    * @param cadena objeto cadenaque deseo testear.
    * @return El objeto cadena resultante.
    */
    public static String ponCero( String cadena)
    {   cadena = cadena.trim();
        if ( cadena.length()== 0 ){
            cadena = "0";
        }    
        return cadena;
    }
    /**
    * Transforma un objeto Decimal a objeto String
    * @param decimal objeto Decimal que deseo convertir a objeto String.
    * @param pattern Patrn para adecuar el formato de la cadena de salida.
    * @return El objeto String resultante.
    */
    public static String decimalFormat( Double decimal, String pattern)
    {
        DecimalFormat nf = ( DecimalFormat)NumberFormat.getInstance( new Locale( "es", "ES"));
        String format;
        if ( decimal.doubleValue() >= 0) {
            nf.applyPattern( pattern);
            format = nf.format( decimal.doubleValue());
        } else {
            nf.applyPattern( pattern);
            format = "<font color=red>" + nf.format( decimal.doubleValue()) + "</font>";
        }
        return format;
    }

     /**
    * Transforma un objeto Decimal a objeto String, sin poner color
    * @param decimal objeto Decimal que deseo convertir a objeto String.
    * @param pattern Patrn para adecuar el formato de la cadena de salida.
    * @return El objeto String resultante.
    */
    public static String decimalFormat2( double decimal, String pattern)
    {
     DecimalFormat nf = ( DecimalFormat)NumberFormat.getInstance( new Locale( "es", "ES"));
        String format;
        if ( decimal >= 0) {
            nf.applyPattern( pattern);
            format = nf.format( decimal);
        } else {
            nf.applyPattern( pattern);
            format =  nf.format( decimal) ;
        }
        return format;
    }

    /**
    * Transforma un double a objeto String y si el nmero es negativo le pone 
    * color rojo en HTML
    * @param decimal nmero que deseo convertir a objeto String.
    * @param pattern Patrn para adecuar el formato de la cadena de salida.
    * @return El objeto String resultante.
    */
    public static String decimalFormat( double decimal, String pattern)
    {
        DecimalFormat nf = ( DecimalFormat)NumberFormat.getInstance( new Locale( "es", "ES"));
        String format;
        if ( decimal >= 0) {
            nf.applyPattern( pattern);
            format = nf.format( decimal);
        } else {
            nf.applyPattern( pattern);
            format = "<font color=red>" + nf.format( decimal) + "</font>";
        }
        return format;
    }

    /**
    * Transforma un double a objeto String sin contemplar negativos
    * @param decimal nmero que deseo convertir a objeto String.
    * @param pattern Patrn para adecuar el formato de la cadena de salida.
    * @return El objeto String resultante.
    */
    public static String decimalFormatExcel( double decimal, String pattern)
    {
        DecimalFormat nf = ( DecimalFormat) NumberFormat.getInstance( new Locale( "es", "ES"));
        String format;
        nf.applyPattern( pattern);
        format = nf.format( decimal);
        return format;
    }

    /**
    * Transforma un objeto Integer a objeto String
    * @param number objeto Integer que deseo convertir a objeto String.
    * @param pattern Patrn para adecuar el formato de la cadena de salida.
    * @return El objeto String resultante.
    */
    public static String integerFormat( Integer number, String pattern)
    {
        DecimalFormat nf = ( DecimalFormat) NumberFormat.getInstance( new Locale( "es", "ES"));
        nf.applyPattern( pattern);
        return nf.format( number.doubleValue());
    }

    /**
    * Transforma un int a objeto String
    * @param number Nmero que deseo convertir a objeto String.
    * @param pattern Patrn para adecuar el formato de la cadena de salida.
    * @return El objeto String resultante.
    */
    public static String integerFormat( int number, String pattern)
    {
        DecimalFormat nf = ( DecimalFormat)NumberFormat.getInstance( new Locale( "es", "ES"));
        nf.applyPattern( pattern);
        Integer d = new Integer(number);
        return nf.format( d.doubleValue());
    }

    /**
    * Transforma un objeto Long a objeto String
    * @param number objeto Long que deseo convertir a objeto String.
    * @param pattern Patrn para adecuar el formato de la cadena de salida.
    * @return El objeto String resultante.
    */
    public static String longFormat( Long number, String pattern)
    {
        DecimalFormat nf = ( DecimalFormat)NumberFormat.getInstance( new Locale( "es", "ES"));
        nf.applyPattern( pattern);
        return nf.format( number.longValue());
    }

    /**
    * Transforma un long a objeto String
    * @param number Nmero que deseo convertir a objeto String.
    * @param pattern Patrn para adecuar el formato de la cadena de salida.
    * @return El objeto String resultante.
    */
    public static String longFormat( long number, String pattern)
    {
        DecimalFormat nf = ( DecimalFormat)NumberFormat.getInstance( new Locale( "es", "ES"));
        nf.applyPattern( pattern);
        return nf.format( number);
    }
    
    /**
    * Formatea un nmero de cuenta de tarjeta de 16 dgitos, introduciendo un espacio cada 4 dgitos
    * @param numero Cadena con el nmero que quiero formatear.
    * @return La cadena con los espacios correspondientes.
    */
    public static String tarjetaFormat( String numero)
    {
        //Variable que indicar cada cuanto hay un espacio
        int numDigitos = 4;
        if (numero == null){
            return "";
        }
        String resto;
        if (numero.length() > numDigitos){
            resto          = numero.substring(numDigitos);
            numero         = numero.substring(0,numDigitos);
            return (numero + " " + tarjetaFormat(resto));
        }else{
            return (numero);
        }
    }


    /**
    * Formatea un nmero de cuenta o tarjeta, aplicando el patrn correspondiente
    * @param numero Cadena con el nmero que quiero formatear.
    * @param pattern Patrn para adecuar el formato de la cadena de salida.
    * @return La cadena formateada con el patrn solicitado.
    */
    public static String multiFormat( String numero, String pattern)
    {
        int i = 0;
        int j = 0;
        String cuenta = "";
        int    longPatron = 0;
        
        for( i = 0; i < pattern.length(); i ++) {
            if( pattern.charAt( i) == 'X') {
                longPatron ++;
            }
        }
        
        //En caso de que el patrn y el nmero no tengan el mismo tamao
        //se devolver una cadena vacia.
        if( longPatron == numero.length()) {
           for( i = 0; i < pattern.length(); i ++) {
              if( pattern.charAt( i) == 'X') {
                 cuenta += numero.charAt( j);
                 j ++;
              } else {
                 cuenta += pattern.charAt( i);
              }
           }
        }  
        
        return cuenta;
    }

    /**
    * Quita todos los puntos de un string
    * @param dato Cadena a la que quiero quitar los punto.
    * @return La cadena sin espacios.
    */
    public static String quitaPuntos( String dato)
    {
        int i = 0;
        while ( dato.indexOf(".") != -1  ) {
            i = dato.indexOf(".");
            dato = dato.substring( 0, i) + "" + dato.substring( i+1, dato.length());
        }
        while ( dato.indexOf(",") != -1  ) {
            i = dato.indexOf(",");
            dato = dato.substring( 0, i) + "." + dato.substring( i+1, dato.length());
        }
        dato.replace(',','.');
        return dato;




     /*   while (dato.indexOf(".")>0){
            dato=dato.substring(0,dato.indexOf(" ")) + dato.substring(dato.indexOf(" ") + 1);
        }
        return dato;      */
    }

         /**
    * Quita todos los puntos de un string
    * @param dato Cadena a la que quiero quitar los punto.
    * @return La cadena sin espacios.
    */
    public static String quitaPuntosFecha( String dato)
    {
        int i = 0;
        while ( dato.indexOf(".") != -1  ) {
            i = dato.indexOf(".");
            dato = dato.substring( 0, i) + "-" + dato.substring( i+1, dato.length());
        }

        dato.replace('.','-');
        return dato;




     /*   while (dato.indexOf(".")>0){
            dato=dato.substring(0,dato.indexOf(" ")) + dato.substring(dato.indexOf(" ") + 1);
        }
        return dato;      */
    }

 /**
    * Quita todos los espacios de un string
    * @param dato Cadena a la que quiero quitar los espacios.
    * @return La cadena sin espacios.
    */
    public static String quitaEspacios( String dato)
    {
        while (dato.indexOf(" ")>0){
            dato=dato.substring(0,dato.indexOf(" ")) + dato.substring(dato.indexOf(" ") + 1);
        }
        return dato;
    }

    /**
    * Transforma un objeto String con formato de nmero espaol en un objeto Double
    * @param decimal Cadena que quiero transformar a objeto Double.
    * @return El objeto Double resultante.
    */
    public static double stringToDouble( String decimal)
    {
        int pos;
        while ((pos = decimal.indexOf(".")) >= 0){
            decimal = decimal.substring(0,pos) + decimal.substring(pos+1,decimal.length());
        }
        decimal = decimal.replace(',', '.');

        Double res = new Double (decimal);
        return res.doubleValue();
    }
    
    /**
    * Transforma un objeto String con formato de nmero espaol en un BigDecimal con tantos decimales como se precise
    * @param numero de decimales que se desea
    * @return El objeto Double resultante.
    */
    public static BigDecimal stringToBigDecimal( String numero)
    {
       return stringToBigDecimal(numero,2);
    }
    /**
    * Transforma un objeto String con formato de nmero espaol en un BigDecimal con tantos decimales como se precise
    * @param numero Cadena que quiero transformar a objeto Double.
    * @param precision de decimales que se desea
    * @return El objeto Double resultante.
    */
    public static BigDecimal stringToBigDecimal( String numero, int precision)
    {
    	if (numero != null && !numero.equals("")){
	        int pos;
	        numero=ponCero(numero);
	        //obtenemos un String con el formato ingls
	        while ((pos = numero.indexOf(".")) >= 0){
	            numero = numero.substring(0,pos) + numero.substring(pos+1,numero.length());
	        }
	        numero = numero.replace(',', '.');
	        //si tiene decimales:
	        if ( numero.indexOf(".") != -1){
	            //sacamos el nmero de decimales:
	            String decimales = numero.substring( numero.indexOf(".") + 1 , numero.length());    
	            
	            if ( decimales.length() > precision){
	                numero = numero.substring( 0, numero.indexOf(".") + 1 + precision );
	            }    
	        }    
	        BigDecimal bd = new BigDecimal(numero);
	        return bd;
    	} else {
    		return null;
    	}
    }
    
   /**
    * Transforma un objeto String con formato de nmero espaol en un BigInteger con tantos decimales como se precise
    * @param numero de decimales que se desea
    * @return El objeto Double resultante.
    */
    public static BigInteger stringToBigInteger( String numero)
    {
        numero=ponCero(numero);
        BigInteger bi = new BigInteger(numero);
        return bi;
    }

    /**
    * Transforma un objeto String a objeto Long
    * @param decimal Cadena que quiero transformar a objeto Long.
    * @return El objeto Long resultante.
    */
    public static Long stringToLong( String decimal)
    {
        int pos;
        while ((pos = decimal.indexOf(".")) >= 0){
            decimal = decimal.substring(0,pos) + decimal.substring(pos+1,decimal.length());
        }

        Long res = new Long (decimal);
        return res;
    }
    
    
   
    
    /**
    * Convierte la cadena que se le pasa a objeto Calendar
    * @param codigoAvance Es un timeStamp, es decir una fecha con formato AAAA/MM/DD HH/MM/SS el separador
    * puede ser "-" o cualquier otro carcter.
    * @return Un objeto Calendar con la fecha y hora que la cadena pasada como parmetro le indicaba.
    */
    public static Calendar convertirCodigoAvanceFecha( String codigoAvance)
    {
        if( codigoAvance != null){
            codigoAvance = codigoAvance.trim();
            if ( codigoAvance.length() > 0){
                String ano      = codigoAvance.substring( 0, 4);
                String mes      = codigoAvance.substring( 5, 7);
                String dia      = codigoAvance.substring( 8, 10);
                String horas    = codigoAvance.substring( 11, 13);
                String minutos  = codigoAvance.substring( 14, 16);
                String segundos = codigoAvance.substring( 17, 19);
                Calendar fecha = Calendar.getInstance();
                fecha.set( ( new Integer(ano)).intValue(),( new Integer( mes)).intValue() -1,( new Integer( dia)).intValue(), ( new Integer( horas)).intValue(), ( new Integer( minutos)).intValue(), ( new Integer( segundos)).intValue());
                return fecha;
            }
            return null;
        } else {
            return null;
        }
    }
    
    /**
    * Transforma un objeto Calendar a un objeto String usando el formato 0 y el separador "/".
    * @param calendar Objeto Calendar que se quiere transformar a objeto String.
    * @param dateStyle date
    * @param timeStyle style
    * @return Cadena con la fecha en formato String con el separador "/" y el formato "DD-MM-AAAA".
    * @deprecated
    */
    static String dateFormat( Calendar calendar, int dateStyle, int timeStyle)
    {
        return dateFormat( calendar, 0, "/");
    }

    /**
    * Transforma un objeto Calendar a un objeto String usando el formato y separador que le indicamos
    * @param fecha Objeto Calendar que se quiere transformar a objeto String.
    * @param formato Un entero que puede ser 0: DD-MM-AAAA, 1: AAAA-MM-DD ,2: DD-MM-AAAA HH:MM:SS,3: AAAA-MM-DD HH:MM:SS dependiendo del formato que queramos.
    * @param separador El separador que se quiere que tenga la fecha resultante "/", "-" etc...
    * @param idioma Dependiendo de si la fecha se muestra en euskera o en castellano 
    * el orden de composicin de la fecha es distinto, en euskera es AAAA-MM-DD y en castellano DD-MM-AAAA
    * @return Cadena con la fecha en formato String con el separador y formato elegido.
    */
    public static String dateFormat( Calendar fecha, int formato, String separador, String idioma)
    {
        if( !idioma.toUpperCase().equals("ES")) {
            if( ( formato == 0) || ( formato == 2)) {
                formato ++;
            }
        }
        return dateFormat( fecha, formato, separador);
    }
    
    /**
    * Transforma un objeto Calendar a un objeto String usando el formato y separador que le indicamos
    * @param fecha Objeto Calendar que se quiere transformar a objeto String.
    * @param formato Un entero que puede ser 0: "DD-MM-AAAA", 1: "AAAA-MM-DD" ,2: "DD-MM-AAAA HH:MM:SS", 3: "AAAA-MM-DD HH:MM:SS" 
    * dependiendo del formato que queramos.
    * @param separador El separador que se quiere que tenga la fecha resultante "/", "-" etc...
    * @return Cadena con la fecha en formato String con el separador y formato elegido.
    */
    public static String dateFormat( Calendar fecha, int formato, String separador)
    {
        String fechaRetorno = null;
        String day   = "00"   + fecha.get( Calendar.DAY_OF_MONTH);
        String month = "00"   + new Integer( fecha.get( Calendar.MONTH) + 1).toString();
        String year  = "0000" + fecha.get( Calendar.YEAR);
        String hour  = "00"   + fecha.get( Calendar.HOUR_OF_DAY);
        String min   = "00"   + fecha.get( Calendar.MINUTE);
        String sec   = "00"   + fecha.get( Calendar.SECOND);
        
        switch( formato) {
            //DD-MM-AAAA
            case 0:
                fechaRetorno = day.substring( day.length() - 2) + separador + month.substring( month.length() - 2) + separador + year.substring( year.length() - 4);
                break;
            //AAAA-MM-DD
            case 1:
                fechaRetorno = year.substring( year.length() - 4) + separador + month.substring( month.length() - 2) + separador + day.substring( day.length() - 2);
                break;
            //DD-MM-AAAA HH:MM:SS
            case 2:
                fechaRetorno = day.substring( day.length() - 2) + separador + month.substring( month.length() - 2) + separador + year.substring( year.length() - 4) + 
                               " " + hour.substring( hour.length()-2) + ":" + min.substring( min.length()-2) + ":" + sec.substring( sec.length()-2);
                break;
            //AAAA-MM-DD HH:MM:SS
            case 3:
                fechaRetorno = year.substring( year.length() - 4) + separador + month.substring( month.length() - 2) + separador + day.substring( day.length() - 2) + 
                               " " + hour.substring( hour.length()-2) + ":" + min.substring( min.length()-2) + ":" + sec.substring( sec.length()-2);
                break;
            default:
                break;
        }
        if ( fechaRetorno.equals( "31/12/0002") || fechaRetorno.equals( "0002/12/31")){
            return "";
        }
        return fechaRetorno;
    }

    /**
    * Obtiene los tags de input para las fechas en Html.
    *
    * @param tabIndex Nmero del tab index inicial.
    * @param idioma Idioma en el que esta la pgina.
    * @param nombreDia Nombre del campo de da.
    * @param valorDia Valor del campo de da.
    * @param nombreMes Nombre del campo de mes.
    * @param valorMes Valor del campo de mes.
    * @param nombreAno Nombre del campo de ao.
    * @param valorAno Valor del campo de ao.
    * @param esNetscape true si el navegador es netscape.
    *
    * @return String con el html para la introduccin de fechas.
    */
    public static String obtenerInputsFecha( int tabIndex, String idioma, String nombreDia, String valorDia, String nombreMes, String valorMes, String nombreAno, String valorAno, boolean esNetscape)
    {
        return obtenerInputsFecha( tabIndex, idioma, nombreDia, valorDia, nombreMes, valorMes, nombreAno, valorAno, esNetscape, "");    
    }

    /**
    * Obtiene los tags de input para las fechas en Html.
    *
    * @param tabIndex Nmero del tab index inicial.
    * @param idioma Idioma en el que esta la pgina.
    * @param nombreDia Nombre del campo de da.
    * @param valorDia Valor del campo de da.
    * @param nombreMes Nombre del campo de mes.
    * @param valorMes Valor del campo de mes.
    * @param nombreAno Nombre del campo de ao.
    * @param valorAno Valor del campo de ao.
    * @param esNetscape true si el navegador es netscape.
    * @param literal Literal de la etiqueta correspondiente a las fechas( ejm: desde, hasta).
    *
    * @return String con el html para la introduccin de fechas.
    */
    public static String obtenerInputsFecha( int tabIndex, String idioma, String nombreDia, String valorDia, String nombreMes, String valorMes, String nombreAno, String valorAno, boolean esNetscape, String literal)
    {
        String retorno = "";
        int tamanoDos    = 2;
        int tamanoCuatro = 4;
        if( esNetscape) {
            tamanoDos    = 1;
            tamanoCuatro = 3;
        }
        
        String textoValorDia=" ";
        String textoValorMes=" ";
        String textoValorAno=" ";
        
        if ( ! (valorDia.trim().equals("") ) ){
            textoValorDia=" value='" + valorDia + "'";
        }
        if ( ! (valorMes.trim().equals("") ) ){
            textoValorMes=" value='" + valorMes + "'";
        }
        if ( ! (valorAno.trim().equals("") ) ){
            textoValorAno=" value='" + valorAno + "'";
        }
        
        if ( idioma.equals( "ES")) {
            if( !literal.equals( "")) {
                retorno = literal + "\r\n";
            }
            retorno += "<input type='text' size='" +  tamanoDos    + "' tabIndex = '" + ( tabIndex++) + "' maxlength='2' name='" + nombreDia + "'" + textoValorDia + " id='" + nombreDia + "'/>\r\n";
            retorno += "<input type='text' size='" +  tamanoDos    + "' tabIndex = '" + ( tabIndex++) + "' maxlength='2' name='" + nombreMes + "'"  + textoValorMes + " id='" + nombreMes + "'/>\r\n";
            retorno += "<input type='text' size='" +  tamanoCuatro + "' tabIndex = '" + ( tabIndex++) + "' maxlength='4' name='" + nombreAno + "'"  + textoValorAno + " id='" + nombreAno + "'/>\r\n";
        } else {
            retorno += "<input type='text' size='" +  tamanoCuatro + "' tabIndex = '" + ( tabIndex++) + "' maxlength='4' name='" + nombreAno + "'"  + textoValorDia + " id='" + nombreAno + "'/>\r\n";
            retorno += "<input type='text' size='" +  tamanoDos    + "' tabIndex = '" + ( tabIndex++) + "' maxlength='2' name='" + nombreMes + "'"  + textoValorMes + " id='" + nombreMes + "'/>\r\n";
            retorno += "<input type='text' size='" +  tamanoDos    + "' tabIndex = '" + ( tabIndex++) + "' maxlength='2' name='" + nombreDia + "'"  + textoValorAno + " id='" + nombreDia + "'/>\r\n";
            if( !literal.equals( "")) {
                retorno += literal + "\r\n";
            }
        }
        return retorno;
    }
    
    /**
    * Obtiene los tags de input para los importes.
    *
    * @param tabIndex Nmero del tab index inicial.
    * @param idioma Idioma en el que esta la pgina.
    * @param tamanoCampo Tamao para el campo.
    * @param maxlength Mximo n de carcteres que se pueden escribir en el campo.
    * @param nombreCampo Nombre del campo.
    * @param valorCampo Valor del campo.
    * @param eventos Cadena con todos los eventos del campo.
    * @param literal Literal de la etiqueta correspondiente al campo( ejm: desde, hasta) ponemos "" 
    * si no se quiere literal.
    *
    * @return String con el html para la introduccin de importes.
    */
    public static String obtenerInput( int tabIndex, String idioma, int tamanoCampo, int maxlength, String nombreCampo, String valorCampo, String eventos, String literal)
    {
        String retorno = "";
        //StringBuffer retornoBuffer = new StringBuffer();
        
        String aux = "";
        if( maxlength != 0) {
            aux = "maxlength = " + maxlength;
        }
        String textoValorCampo=" ";
        
        if ( ! valorCampo.trim().equals("") ){ 
            textoValorCampo=" value='" + valorCampo + "'";
        }
        
        if ( idioma.equals( "ES")) {
            if( !literal.equals( "")) {
                retorno = literal + "\r\n";
                //retornoBuffer.append( literal ).append("\r\n");
            }
            //retornoBuffer.append("<input type='text' " ).append( aux ).append( " size='" ).append( tamanoCampo ).append( "' tabIndex = " ).append( tabIndex++ ).append( " name='" ).append( nombreCampo ).append( "'" ).append( textoValorCampo ).append( " id='" ).append( nombreCampo ).append( "' " ).append( eventos ).append( ">\r\n");
            retorno += "<input type='text' " + aux + " size='" + tamanoCampo + "' tabIndex = " + ( tabIndex++) + " name='" + nombreCampo + "'" + textoValorCampo + " id='" + nombreCampo + "' " + eventos + ">\r\n";
        } else {
            retorno += "<input type='text' " + aux + " size='" + tamanoCampo + "' tabIndex = " + ( tabIndex++) + " name='" + nombreCampo + "'" + textoValorCampo + " id='" + nombreCampo + "' " + eventos + ">\r\n";
            if( !literal.equals( "")) {
                retorno += literal + "\r\n";
            }
        }
        //retorno = retornoBuffer.toString();
        return retorno;
    }
    
    /**
    * Sustituye en la cadena que le pase los acentos en formato HTML por acentos normales
    * ejm: "&aacute;" por "".
    * @param dato Cadena a la que se quiere cambiar el tipo de acentos.
    * @return Cadena con los acentos cambiados.
    */ 
    public static String cambiaAcentos( String dato)
    {
        String auxiliar = "";
        char   vocal;

        int i = 0;
        do {
            if( dato.charAt( i) != '&') {
                auxiliar = auxiliar + dato.charAt( i);
                i ++;
            } else {
                i ++;
                if( i < dato.length()) {
                    vocal = dato.charAt( i);
                    switch( vocal) {
                        case 'a':
                        case 'e':
                        case 'i':
                        case 'o':
                        case 'u':
                            if( ( ( i + 6) < dato.length()) && ( dato.substring( ( i + 1), ( i + 7)).equals( "acute;"))) {
                                switch( vocal) {
                                    case 'a':
                                        auxiliar = auxiliar + '';
                                        break;
                                    case 'e':
                                        auxiliar = auxiliar + '';
                                        break;
                                    case 'i':
                                        auxiliar = auxiliar + '';
                                        break;
                                    case 'o':
                                        auxiliar = auxiliar + '';
                                        break;
                                    case 'u':
                                        auxiliar = auxiliar + '';
                                        break;
                                }
                                i = i + 7;
                            } else {
                                auxiliar = '&' + auxiliar + vocal;
                                i ++;
                            }
                            break;
                        case 'n':
                            if( ( ( i + 6) < dato.length()) && ( dato.substring( ( i + 1), ( i + 7)).equals( "tilde;"))) {
                                auxiliar = auxiliar + '';
                                i = i + 7;
                            } else {
                                auxiliar = '&' + auxiliar + vocal;
                                i ++;
                            }
                            break;
                        default:
                            auxiliar = '&' + auxiliar + vocal;
                            i ++;
                            break;
                    }
                }
            }
        } while( i < dato.length());
        return auxiliar;
    }

    /** 
    * Aade dos ceros como decimales a una cantidad entera. Se utiliza para poner los euros en
    * decimales
    * @param valor Cadena con el importe a modificar, ponindole decimales o espacios.
    * @return Cadena con el importe origen ms los decimales o espacios.
    */
    public static String anadeDecimalesEuros( String valor)
    {
     //Si es un valor negativo, el dato puede venir en rojo
     
        int posicionDecimales = valor.indexOf("</font>");
        if (posicionDecimales < 0){
            if (valor.indexOf(",") < 0){
                valor = valor + ",00";
            }else{
                String aux = valor.substring(valor.indexOf(",")+1);
                if (aux.length() == 1){
                    valor = valor + "0";
                }
            }
        }else{
            if (valor.indexOf(",") < 0){  
                valor= valor.substring(0,posicionDecimales) + ",00" + valor.substring(posicionDecimales);
            }else{
                String aux = "";
                if (valor.indexOf(",") < valor.indexOf("</font>")){
                    aux = valor.substring(valor.indexOf(",")+1,valor.indexOf("</font>"));
                }
                if (aux.length() == 1){
                    valor = valor.substring(0,valor.indexOf(",")+2) + "0" + valor.substring(valor.indexOf("</font>"));
                }
            }
        }
        return valor;
    }
    
    

    /**
    * Funcin que devuelve un blanco en el caso de que el valor introducido sea null
    * @param s La cadena que se quiere convertir a "" en caso de que sea null.
    * @return La cadena origen o "".
    */
    public static String esNull( String s){
		// si la cadena es nula devuelve " " 
        if( s == null){
            return "";
        }else {
			if ( s.equals("0") ){
				return "";
            }
			return s;
        }
     }
     
      /**
    * Funcin que devuelve un blanco en el caso de que el valor introducido sea null, si viene 0 se devuelve el valor original
    * @param s La cadena que se quiere convertir a "" en caso de que sea null.
    * @return La cadena origen o "".
    */
     public static String esNullSinCero( String s)
     {
        // si la cadena es nula devuelve " " 
        if( s == null){
            return "";
        }else {
	return s;
        }
     }

    /**
     * Funcin que devuelve un blanco en el caso de que el valor introducido sea null
     * @param s La cadena que se quiere convertir a "" en caso de que sea null.
     * @return La cadena origen o "".
     */
     public static String getNuloCadenaBD( String s){
 		// si la cadena es nula devuelve " " 
         if( s == null){
             return "";
         }else {
 			if ( s.equals("0") ){
 				return "";
             }
 			return s;
         }
      }
     
     /**
      * Funcin que devuelve un blanco en el caso de que el valor introducido sea null
      * @param s La cadena que se quiere convertir a "" en caso de que sea null.
      * @return La cadena origen o "".
      */
      public static String getNuloNumericBD( String s){
  		// si la cadena es nula devuelve " " 
          if( s == null){
              return "NULL";
          }else {
  			if ( s.trim().equals("") ){
  				return "NULL";
             }
  			return s;
          }
       }




     
       /**
    * Funcin que reemplaza en la cadena pasada como parmetro los caracteres peligrosos para pintar en HTML
    * @param texto La cadena cuyos caracteres se quieren testear
    * @return La cadena origen con los caracteres reemplazados
    */
     public static String htmlFormat(String texto)
     {
           texto = esNull(texto);
           texto = texto.replace('\'','"');
           texto = texto.replace('','"');
           texto = texto.replace('`','"');   
           //vamos a reemplazar los caracteres propios de HTML
           //texto =  reemplazaCaracteresHTML( texto);
           //vamos a reemplazar los saltos de carro por BR
           
           String mensaje = "";
           if ( mensaje.indexOf("\r\n") != -1){
               StringTokenizer token = new StringTokenizer( texto , "\r\n");
               while ( token.hasMoreElements()) {
                    mensaje += ( String) token.nextElement() + "<br>";                    
               }
               texto = mensaje;
           }
           return texto; 
     }
     
       /**
    * Funcin que reemplaza en la cadena pasada como parmetro los caracteres peligrosos para insertar en bd
    * @param texto La cadena cuyos caracteres se quieren testear
    * @return La cadena origen con los caracteres reemplazados
    */
     public static String bdFormat(String texto){
           texto = esNull(texto);
           texto = texto.replace('\'','`');           
           return texto;
     }    
       /**
    * Funcin que reemplaza en la cadena pasada como parmetro el carcter `,  que se haba incluido para que no
	* fallase la BD, por el carcter ', necesario para que funcionen los links.
    * @param texto La cadena cuyos caracteres se quieren testear
    * @return La cadena origen con los caracteres reemplazados
    */
     public static String scriptFormat(String texto){
           texto = esNull(texto);
           texto = texto.replace('`','\'');           
           return texto;
     }   
      /**
    * Reemplaza los caracteres '<' y '>' del texto del mensaje por su correspondiente notacin 
    * para texto html, "&lt;" y "&gt;" respectivamente, de manera que no sean parseados incorrectamente
    * como parte del html representativo de la jsp.Esto es para el caso de que alguien incluya "</table>" o cualquier otro
    * tag HTML en el texto de su mensaje y se vea afectada la jsp resultante. 
    * @param textoMensaje texto del mensaje escrito por el usuario
    * @return String texot con el mensaje con los caracteres reemplazados.
    */
    
    public static String reemplazaCaracteresHTML (String textoMensaje )
    {
        StringBuffer aux = new StringBuffer(textoMensaje);
        for ( int i=0 ; i < aux.length();i++)
        {
            if ( aux.charAt(i)== '<')
            {
                aux=aux.deleteCharAt(i);
                aux=aux.insert(i,"&lt;");
            }
            if ( aux.charAt(i)== '>')
            {
                aux=aux.deleteCharAt(i);
                aux=aux.insert(i,"&gt;");
            }
            if ( aux.charAt(i)== '"')
            {
                aux=aux.deleteCharAt(i);
                aux=aux.insert(i,"&quot;");
            }
        }
        return ( aux.toString());
    }         
     
     /**
     * A partir de un dia,mes y ao obtiene una fecha con formato dd-mm-yyyy
     * @return fecha formateada
     * @param dia da de la fecha
     * @param mes mes de la fecha
     * @param anyo ao de la fecha */   
    public static String parseaFecha(String dia, String mes, String anyo)
    {
        java.util.Calendar fechaAux = java.util.Calendar.getInstance();
        fechaAux.set(new Integer(anyo.trim()).intValue(),new Integer(mes.trim()).intValue()-1,new Integer(dia.trim()).intValue());
        return Q02aFormatData.dateFormat(fechaAux,1,"-","ES");                
    }   
    /**
     * A partir de una cadena de carcteres separados por comas (apellido1,apellido2,nombre)
     * devuelve nombre apellido1 apellido2
     * @param nombreCompleto nombre completo
     * @return cadena nombre apellido1 apellido2
     */
     public static String obtenerNombre(String nombreCompleto){
		nombreCompleto = nombreCompleto.trim();
		int separador = ',';
                int primera = 0;
                int segunda = 0;
                String nombre = "";
                String apellido1 = "";
                String apellido2 = "";
                StringBuffer cadena = new StringBuffer();
		primera = nombreCompleto.indexOf(separador);
                if(primera == -1){
                return "";
                }
                segunda = nombreCompleto.indexOf(separador, primera + 1);
                if(segunda == -1 ){
                    return "";
                }
                nombre = ponMayuscula(nombreCompleto.substring(segunda+1).trim().toLowerCase());
                apellido1 = ponMayuscula(nombreCompleto.substring(0,primera).trim().toLowerCase());
                apellido2 = ponMayuscula(nombreCompleto.substring(primera+1,segunda).trim().toLowerCase());
                cadena.append(nombre).append(" ").append(apellido1).append(" ").append(apellido2);
                return cadena.toString();
			
    }
    /**
     * A partir de una cadena de carcteres separados por espacios ( nombre apellido1 apellido2 )
     * devuelve nombre apellido1 apellido2 con la primera inicial mayuscula de cada palabra
     * @param nombre nombre 
     * @return cadena Nombre  
     */
    public static String ponMayuscula(String nombre){
        nombre = nombre.trim().toLowerCase();
        int separador = ' ';
        int espacio = 0;
        StringBuffer cadena = new StringBuffer();
        String temp = "";
        espacio = nombre.indexOf(separador);
        if(espacio == -1){
            cadena.append(new Character(nombre.charAt(0)).toString().toUpperCase()).append(nombre.substring(1));
            return cadena.toString();
        } else {
            String array [] = obtenerArray(nombre);
            for(int i = 0;i<array.length;i++){
                temp = array[i];
                cadena.append(new Character(temp.charAt(0)).toString().toUpperCase()).append(temp.substring(1)).append(" ");
            }
            return cadena.toString();
        }
        
    }
    /**
     * A partir de una cadena de carcteres separados por espacios ( nombre apellido1 apellido2 )
     * devuelve un array de String formado por las diferentes palabras
     * @param nombre nombre 
     * @return array de String  
     */
     public static String [] obtenerArray(String nombre){
		String array [] = null;
		nombre = nombre.trim();
		int separador = ' ';
		int inicio = 0;
		int fin = 0;
		int temp = 0;		
		int contadorEspacios = 0;
		Character caracter = new Character(' ');
		Character temporal = new Character('a');
		for(int i=0;i<nombre.length();i++){
			temporal = new Character(nombre.charAt(i));	
			if(temporal.equals(caracter)){
				contadorEspacios++;				
			}
		}
		array = new String[contadorEspacios+1];
		for(int i=0;i<=contadorEspacios;i++){
			inicio =temp;
			fin = nombre.indexOf(separador,fin+1);
			if(fin==-1){//si no hay mas comas
				fin=nombre.length();
			}
			temp = fin;
			if(i!=0){//para no coger la coma
				inicio++;
			}
			array[i] = nombre.substring(inicio,fin).trim();                        
		}
		return array;		
    }

    /**
     * A partir de una cadena de carcteres separados por espacios ( nombre apellido1 apellido2 )
     * devuelve un array de String formado por las diferentes palabras
     * @param nombre nombre 
     * @param separador separador 
     * @return array de String  
     */
     public static String [] obtenerArray(String nombre, char separador){
		String array [] = null;
		nombre = nombre.trim();
		int inicio = 0;
		int fin = 0;
		int temp = 0;		
		int contadorEspacios = 0;
		Character caracter = new Character(separador);
		Character temporal = new Character('a');
		for(int i=0;i<nombre.length();i++){
			temporal = new Character(nombre.charAt(i));	
			if(temporal.equals(caracter)){
				contadorEspacios++;				
			}
		}
		array = new String[contadorEspacios+1];
		for(int i=0;i<=contadorEspacios;i++){
			inicio =temp;
			fin = nombre.indexOf(separador,fin+1);
			if(fin==-1){//si no hay mas comas
				fin=nombre.length();
			}
			temp = fin;
			if(i!=0){//para no coger la coma
				inicio++;
			}
			array[i] = nombre.substring(inicio,fin).trim();                        
		}
		return array;		
    }

    /**
     * Convierte un String en una fecha
     * devuelve un integer
     * @param strDate String que queremos convertir
     * @param format Formato de la fecha
     * @return Date  
     */
    public static java.util.Date stringToDate(String strDate,String format){
            java.util.Date convertDate=null;
        try{
            convertDate=new java.text.SimpleDateFormat(format).parse(strDate);          
        }catch(ParseException pex){
          pex.printStackTrace();
        }
      return convertDate;
    }
    

    /**
     * Convierte una fecha con un determinado formato en la fecha con el formato adecudado
     * teniendo en cuenta el idioma y el formato que la fecha tenia originalmente
     * devuelve un String (fecha en formato adecuado)
     * @param fecha , fecha a aplicar el formateo
     * @param formato , en el que se pasa la fecha
     *                  0 ==> dd-mm-yyyy o dd/mm/yyyy
     *                  1 ==> yyyy-mm-dd o yyyy/mm/dd
     * @param idioma , idioma en el que se quiere la fecha (ES, EUS)
     * @return String, la fecha correcta para ser presentada en Internet, teniendo en cuenta el idioma  
     */
    public static String formatearFecha(String fecha,String formato,String idioma){
    	//Variables que no se modifican
    	final String IDIOMA_ES = "ES";
    	final String IDIOMA_EU = "EUS";
        //Variables para obtener el da, el mes y el ao
        String dia 	= null;
        String mes 	= null;
        String anio = null;
        //String para concatenar fechas
        StringBuffer inter = new StringBuffer("");
        //Si la fecha no es null entra
        if(fecha != null)
        {
	        // Si el formato es null, se entiende que la fecha viene como dd-mm-yyyy o dd/mm/yyyy
	        if(formato == null){
	            dia 	= fecha.trim().substring(0,2);
	            mes 	= fecha.trim().substring(3,5);
	            anio 	= fecha.trim().substring(6,10);
	            if(idioma != null){         		
	                    if(idioma.toUpperCase().equals(IDIOMA_ES)){// ponemos en formato dd/MM/yyyy
	                        fecha = inter.append(dia).append("/").append(mes).append("/").append(anio).toString();
	                    }
	                    else if(idioma.toUpperCase().equals(IDIOMA_EU)){// ponemos en formato yyyy/MM/dd
	                        fecha = inter.append(anio).append("/").append(mes).append("/").append(dia).toString();
	                    } else {// ponemos en formato dd/MM/yyyy si no viene idioma
	                    	fecha = inter.append(dia).append("/").append(mes).append("/").append(anio).toString();
	                    }
	            } else {
	            	//Si no se ha metido idioma se devuelve por defecto dd/MM/yyyy
	            	fecha = inter.append(dia).append("/").append(mes).append("/").append(anio).toString();
	            }
	         } else {
	                // Controlamos el formato en el que nos aparece la fecha    
	                if (formato.compareTo("0")==0){    
	                	 //Si no viene el idioma
		                 if(idioma != null){
			                    dia  = fecha.trim().substring(0,2);
			                    mes  = fecha.trim().substring(3,5);
			                    anio = fecha.trim().substring(6,10);               
			                    if(idioma.toUpperCase().equals(IDIOMA_ES)){// ponemos en formato dd/MM/yyyy
			                        fecha = inter.append(dia).append("/").append(mes).append("/").append(anio).toString();
			                    }
			                    else if(idioma.toUpperCase().equals(IDIOMA_EU)){// ponemos en formato yyyy/MM/dd
			                        fecha = inter.append(anio).append("/").append(mes).append("/").append(dia).toString();
			                    } else {// ponemos en formato dd/MM/yyyy si no es ningn idioma de estos
			                    	fecha = inter.append(dia).append("/").append(mes).append("/").append(anio).toString();
			                    }
		                  } else {// ponemos en formato dd/MM/yyyy si no existe el idioma
		                	  fecha = inter.append(dia).append("/").append(mes).append("/").append(anio).toString();
		                  }
	                }
	                else if (formato.compareTo("1")==0){ // formato yyyy-mm-dd
                          dia 	= fecha.trim().substring(8,10);
                          mes 	= fecha.trim().substring(5,7);
                          anio 	= fecha.trim().substring(0,4); 
	                	
	                	  //Si no viene el idioma
		                  if(idioma != null){
             
			                    if(idioma.toUpperCase().equals(IDIOMA_ES)){// ponemos en formato dd/MM/yyyy
			                        fecha = inter.append(dia).append("/").append(mes).append("/").append(anio).toString();
			                    }
			                    else if(idioma.toUpperCase().equals(IDIOMA_EU)){// ponemos en formato yyyy/MM/dd
			                        fecha = inter.append(anio).append("/").append(mes).append("/").append(dia).toString();
			                    } else {//ponemos en formato dd/MM/yyyy si no es ningn idioma de estos
			                        fecha = inter.append(dia).append("/").append(mes).append("/").append(anio).toString();
			                    }
		                  } else { // ponemos en formato dd/MM/yyyy si no existe el idioma
		                	  fecha = inter.append(dia).append("/").append(mes).append("/").append(anio).toString();
		                  }
	                }    
	            } 
        }
        return fecha;
    }
   

  
     /**
    * Funcin que reemplaza en la cadena pasada como parmetro los caracteres peligrosos para Base de datos
    * @param texto La cadena cuyos caracteres se quieren testear
    * @return La cadena origen con los caracteres reemplazados
    */
     public static String limpiaCadena(String texto)
     {

           texto = texto.replace('\'','"');
           texto = texto.replace('','"');
           texto = texto.replace('`','"');

           return texto; 
     }
     
     
      /**
    *   funcion que cambia los blancos de un string por &nbsp; para mostrarlo
    *   por pantalla formateado.
    *
    * @param cadena cadena sin formatear
    * @return la cadena formateada
    */
    public static String cambiaBlancos( String cadena){
        int i = 0;
        while ( cadena.indexOf(" ") != -1  ) {
            i = cadena.indexOf(" ");        
            cadena = cadena.substring( 0, i) + "&nbsp;" + cadena.substring( i+1, cadena.length());
        }        
        return cadena;
    }
    
    
  /**
     * Convierte una fecha con formato yyyymmdd en formato dd/mm/yyyy
     * @param fecha fecha
    * @return String, la fecha correcta para ser presentada en Internet 
     */
    public static String formatearFecha(String fecha){

        if (fecha != null)
        {
        
		   // Controlamos el formato en el que nos viene la fecha
		   String dia;
		   String mes;
		   String anio;        
		   dia = fecha.trim().substring(8);
		   mes = fecha.trim().substring(5,7);
		   anio = fecha.trim().substring(0,4);
		   StringBuffer inter = new StringBuffer();      
		   fecha = inter.append(dia).append("/").append(mes).append("/").append(anio).toString();
		}
        return fecha;
    }

    /**
     * Convierte una fecha con formato yyyymmdd en formato dd/mm/yyyy
     * @param fecha fecha
     * @return String, la fecha correcta para ser presentada en Internet
     */
    public static String formatearFecha_sin(String fecha){

        if (fecha != null)
        {

		   // Controlamos el formato en el que nos viene la fecha
		   String dia;
		   String mes;
		   String anio;
		   dia = fecha.trim().substring(8,10);
		   mes = fecha.trim().substring(5,7);
		   anio = fecha.trim().substring(0,4);
		   StringBuffer inter = new StringBuffer();
		   fecha = inter.append(dia).append(mes).append(anio).toString();
		}
        return fecha;
    }

   /**
     * Convierte una hora con formato hhmmss en formato hh:mi:ss
     * @param hora hora
     * @return String, la hora correcta para ser presentada en Internet 
     */
    public static String formatearHora(String hora){
       
		 if ( !hora.equals("0") )
	     {
			 // Controlamos el formato en el que nos viene la fecha
	        String horas ="";
	        String minutos="";
            String segundos="";

            if (hora.length()==5){
				hora = "0"+hora;
			}
            if (hora.length()>=2){
                horas = hora.trim().substring(0,2);
                if (hora.length() >= 4){
                    minutos = hora.trim().substring(2,4);
                    if (hora.length()>=6){
                        segundos = hora.trim().substring(4,6);
                    }
                }
            }
        	StringBuffer inter = new StringBuffer();
	        hora = inter.append(horas).append(":").append(minutos).append(":").append(segundos).toString();

		}
		else
		{
			hora="";
		}
        return hora;
    }

    /**
      * Convierte un cdigo local en formato ddd
      * @param codlocal codlocal
      * @return String, el cdigo local correcto para ser presentada en Internet
      */
     public static String formatearCodigo(String codlocal){

          if (!codlocal.equals("0")){
              if (codlocal.length()==1){
                  codlocal="00"+codlocal;
              }
              else if   (codlocal.length()==2){
                  codlocal="0"+codlocal;
              }
          }

         return codlocal;
     }


 /**
     * Devuelve el substring de una cadena con la longitud indicada
     * @param cadena cadena
     * @param longitud longitud
     * @return String, la cadena correcta para ser presentada en Internet 
     */
    public static String substringCadena(String cadena, int longitud){
		if (cadena != null)
		{
			if (cadena.length() >= longitud)
			{
				cadena = cadena.substring(0,longitud);
			}
			else
			{
				cadena=cadena.substring(0,cadena.length());
			}
		}
		return cadena;
    }


    /**
     * Devuelve el substring de una cadena con la longitud indicada
     * @param longitud longitud
     * @param campo campo
     * @return String, la cadena correcta para ser presentada en Internet
     */
    public static String getCadenaRellena(int longitud, String campo){
		StringBuffer cadena = new StringBuffer("");
        if (campo != null && !campo.trim().equals("")){
            cadena.append(campo);
        }
        for (int i= cadena.length(); i < longitud; i++){
            cadena.append(" ");
        }
		return cadena.toString();
    }

    /**
     * Devuelve el substring de una cadena con la longitud indicada
     * @param cadena cadena
     * @param fin fin
     * @param inicio inicio
     * @return String, la cadena correcta para ser presentada en Internet
     */
     public static String getSubstring(String cadena, int inicio, int fin){
        String valor = "";
        if (inicio <= cadena.length()){
            if (cadena.length() >= fin){
                valor = cadena.substring(inicio, fin);
            }else{
               valor = cadena.substring(inicio, cadena.length());
            }
        }
       return valor.trim();
    }


     /**
      * Devuelve un Integer
      * @param cadena cadena
      * @return Integer, la cadena correcta para ser presentada en Internet
      */
     public static Integer parseInt(String cadena){
        if (cadena != null && !cadena.equals("")){
            return new Integer(cadena);
        }else{
            return null;
        }
    }
     /**
      * Devuelve un Long
      * @param cadena cadena
      * @return Long, la cadena correcta para ser presentada en Internet
      */
     public static Long parseLong(String cadena){
         if (cadena != null && !cadena.equals("")){
             return new Long(cadena);
         }else{
             return null;
         }
     }
     
     /**
      * Devuelve un Integer
      * @param cadena cadena
      * @return Integer, la cadena correcta para ser presentada en Internet
      */
     public static Integer parseIntWithCero(String cadena){
         if (cadena != null && !cadena.equals("")){
             return new Integer(cadena);
         }else{
             return new Integer(0);
         }
     }
     
     /**
      * Devuelve un long
      * @param cadena cadena
      * @return Long, la cadena correcta para ser presentada en Internet
      */
     public static Long parseLongWithCero(String cadena){
         if (cadena != null && !cadena.equals("")){
             return new Long(cadena);
         }else{
             return new Long(0);
         }
     }
	

     /**
      * Devuelve un Doble
      * @param cadena cadena
      * @return Double, la cadena correcta para ser presentada en Internet
      */
    public static Double parseDouble(String cadena){
       if (cadena != null && !cadena.equals("")){
            int pos;
            while ((pos = cadena.indexOf(".")) >= 0){
                cadena = cadena.substring(0,pos) + cadena.substring(pos+1,cadena.length());
            }
            cadena = cadena.replace(',', '.');


                return new Double(cadena);
        }else{
            return null;
        }
    }

    /**
     * Devuelve un Date
     * @param cadena cadena
     * @return Date, la cadena correcta para ser presentada en Internet
     * @throws Exception Exception
     */
     public static Date parseDate(String cadena) throws Exception{
        return parseDate(cadena, "dd/MM/yyyy");
    }

     /**
      * Devuelve un Date
      * @param cadena cadena
      * @param patron patron
      * @return Date, la cadena correcta para ser presentada en Internet
      * @throws Exception Exception
     */
     public static Date parseDate(String cadena, String patron) throws Exception{
        Date fecha = null;
        if (cadena != null && !cadena.equals("")){
            try{
                fecha = new SimpleDateFormat(patron).parse(cadena);
            }catch(Exception ex){
                throw ex;
            }
            return fecha;
        }else{
            return null;
        }
    }
     
     /**
      * Funcin que devuelve un blanco en el caso de que el valor introducido sea null
      * @param s La cadena que se quiere convertir a "" en caso de que sea null.
      * @return boolean La cadena origen o "".
      */
      public static boolean esVacio( String s){
  		// si la cadena es nula devuelve " " 
          if( s == null){
              return true;
          }else{
  			if ( s.trim().equals("") ){
  				return true;
             }else{
            	 return false;
             }
          }
       }
      
      /**
       * Funcin que devuelve un blanco en el caso de que el valor introducido sea null
       * @param s La cadena que se quiere convertir a "" en caso de que sea null.
       * @return String origen o "".
       */
       public static String checkStringNull( String s){
   		// si la cadena es nula devuelve " " 
           if( s == null){
               return null;
           }else {   	
        	    if ( s.trim().equals("") ){
        	    	return null;
        	    }else{
        	    	return s;
        	    }
        	}
           }
       /**
        * Funcin que devuelve un blanco en el caso de que el valor introducido sea null
        * @param s La cadena que se quiere convertir a "" en caso de que sea null.
        * @return La cadena origen o "".
        */
        public static Long checkLongNull( String s){
    		// si la cadena es nula devuelve " " 
        	 if( s == null){
                 return null;
             }else{
     			if ( s.trim().equals("") ){
     				return null;
                }else{
               	 	return new Long(s);
                }
             }
        }
        
        
        
        /**
         * Funcin que devuelve un blanco en el caso de que el valor introducido sea null
         * @param s La cadena que se quiere convertir a "" en caso de que sea null.
         * @return La cadena origen o "".
         */
         public static Double checkDoubleNull( String s){
     		// si la cadena es nula devuelve " " 
         	 if( s == null){
                  return null;
              }else{
      			if ( s.trim().equals("") ){
      				return null;
                 }else{
                	 	return new Double(s);
                 }
              }
         }

         /**
          * Funcin que devuelve un blanco en el caso de que el valor introducido sea null
          * @param s La cadena que se quiere convertir a "" en caso de que sea null.
          * @return La cadena origen o "".
          */
          public static Integer checkIntegerNull( String s){
      		// si la cadena es nula devuelve " " 
          	 if( s == null){
                   return null;
               }else{
       			if ( s.trim().equals("") ){
       				return null;
                  }else{
                 	 	return new Integer(s);
                  }
               }
          }
          
          /**
           * Funcin que devuelve una cadena sin tildes.
           * @param cadena String al que queremos eliminar las tildes
           * @return cadena 
           */
          public static String quitaAcentos (String cadena) {
        	  cadena = cadena.toUpperCase();
        	  cadena = cadena.replace ('','A');
        	  cadena = cadena.replace ('','E');
        	  cadena = cadena.replace ('','I');
        	  cadena = cadena.replace ('','O');
        	  cadena = cadena.replace ('','U');
        	  
        	  return cadena.toLowerCase();
          }
          
          /**
           * Mtodo que a partir de un ArrayList de String devuelve un String con los elementos del ArrayList 
           * separados por el separador especificado.
           * @param lista ArrayList de String
           * @param SEPARADOR  String
           * @return String con los elementos separados por el separador indicado
           * @throws Exception Exception
           */
          public static String obtenerListaElementos(ArrayList lista,final String SEPARADOR) throws Exception{
          	StringBuffer listaComas = new StringBuffer();
          	
          	if (!lista.isEmpty()){
          		listaComas.append(lista.get(0).toString());
          		for (int i=1; i<lista.size();i++){
          			listaComas.append(SEPARADOR).append(lista.get(i).toString());
          		}
          	}       	
      		return listaComas.toString();
          }
          
		/**
		* Mtodo que Obtiene la fecha del sistema en el formato dd/mm/yyyy
		* @return La fecha del sistema
		* @throws Exception Exception
		*/
          public static String fncObtenerFechaSistema() throws Exception
          {
            Calendar calendario = Calendar.getInstance();
            
            String strAnyo = String.valueOf(calendario.get(Calendar.YEAR));
            String strMes = String.valueOf(calendario.get(Calendar.MONTH)+1);
            if (strMes.length()==1){
              strMes="0"+strMes;
            }
            String strDia = String.valueOf(calendario.get(Calendar.DAY_OF_MONTH));
            if (strDia.length()==1){
              strDia = "0"+strDia;
            }

            String strFechaSistema = strDia + "/" +strMes + "/" + strAnyo;

            return strFechaSistema;
          }
          
          /**
      	 * Funcin que reemplaza palabras clave que contiene el texto (p.e {xxx}) 
      	 * por los valores de mapaParametros
      	 * @param body 					-Cuerpo del email 
      	 * @param mapaParametros   		-Contiene los valores por los cuales se van a sustituir los parametros del texto
      	 * @param caracInicio			-Caracter que define el inicio de la palabra clave del texto
      	 * @param caracFinal 			-Caracter que define el final de la palabra clave del texto
      	 * @return Devuelve un String, el texto completo
      	
      	 */
          public static String sustituirParametrosTexto(String body,HashMap mapaParametros, String caracInicio, String caracFinal)
          {
      	    StringBuffer textoCompleto = new StringBuffer();      	   
            String palabraClave;
            
            while ( body.indexOf(caracInicio) != -1  ) {        	     
          	  
          	  textoCompleto.append(body.substring(0,body.indexOf(caracInicio)));
          	  palabraClave=body.substring(body.indexOf(caracInicio)+1,body.indexOf(caracFinal));
          	  textoCompleto.append(mapaParametros.get(palabraClave));
          	  body=body.substring(body.indexOf(caracFinal)+1,body.length());
            }
            textoCompleto.append(body);
            
            return textoCompleto.toString();
          	
          }   
          
          /**
           * Funcin que devuelve el tamao de un fichero en bytes
           * 
           * @param is InputStream 
           * 
           * @return Devuelve el tamao del fichero en bytes     	
           */
          public static String obtenerTamanoBytesFicheroString(InputStream is){
        	  return Integer.toString(obtenerTamanoBytesFicheroInt(is));
          }
          
         /**
          * Funcin que devuelve el tamao de un fichero en bytes
          * 
          * @param is InputStream 
          * 
          * @return Devuelve el tamao del fichero en bytes     	
          */
          public static int obtenerTamanoBytesFicheroInt(InputStream is){
        	  int size = -1;
        	  try{
        		  if(is!=null){
	        		  ByteArrayOutputStream baos = new ByteArrayOutputStream();  
	        		  int data=0;
	        		  //Se escriben los datos mientras existan
	        		  while((data = is.read())>-1){
	        			  baos.write(data);
	        		  }
	        		  baos.flush();
	        		  baos.close(); // MUY IMPORTANTE!!!
	        		  is.close();
	        		  //Obtiene la longitud del fichero en bytes
	        		  size = baos.toByteArray().length; 
        		  }
        	  }catch(IOException io){}
        	  return size;
          }
          /**
        	 * Este mtodo convierte la cadena de string en mayusculas  y sin acentos        	 
        	 * @param cadena 			- String a tratar      	 * 
        	 * @return 				-String 
        	 */
            public static String convertirMaysculaSinAcento( String cadena ) {
            	
             String resultado=cadena.trim().toUpperCase();
             
             resultado=((((resultado.replace('','A')).replace('','E')).replace('','I')).replace('','O')).replace('','U');
             resultado=((((resultado.replace('','A')).replace('','E')).replace('','I')).replace('','O')).replace('','U');
             resultado=((((resultado.replace('','A')).replace('','E')).replace('','I')).replace('','O')).replace('','U');
             resultado=((((resultado.replace('','A')).replace('','E')).replace('','I')).replace('','O')).replace('','U');
             resultado=resultado.replace('','C');
             return resultado;
                
            }
                               
}