package q02a.exe.utils;
 
import java.util.Calendar;
import java.util.GregorianCalendar;

/**
 *  Clase con funciones de utililidad para la aplicacin
 *  @author GADIMAAR 
*/
public class Q02aAplicationUtils {

    public static final String [] mesesCas = {"Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre"};
    public static final String [] mesesEus = {"Urtarrila","Otsaila","Martxoa","Apirila","Maiatza","Ekaina","Uztaila","Abuztua","Iraila","Urria","Azaroa","Abendua"};

         /**
          * Funcin que devuelve un array con los meses del ao
          * 
          * @return Devuelve un array con los  meses	
          */
          public static String[] dameArrayMeses(){
        	  String[] listaMeses = new String[12];
        	  try{
        		for (int i=0;i<12;i++)
		{
			listaMeses[i] =  Integer.toString(i+1);
		}
        	  }catch(Exception ex){}
        	  return listaMeses;
          }
          
           /**
          * Funcin que devuelve un array con los aos que se van a cargar en el combo de bsqueda de Cuestionarios de Ayuntamientos Mensuales
          * 
          * @return Devuelve un array con los  aos
          */
          public static String[] dameArrayAnosCuesAyunMen(){
        	  int anoInicial = 0;
	  int anoFinal = 0;
	  Calendar c = new GregorianCalendar();
	  //anoInicial =  Integer.valueOf(Q02aConstantes.getString("q02a.cuestionarios.ayunMen.anoInicial")).intValue();
	  int anoConfig =  Integer.valueOf(Q02aConstantes.getString("q02a.cuestionarios.ayunVtmMen.anosConfig")).intValue();
	  anoFinal =   c.get(Calendar.YEAR);
	  anoInicial = anoFinal - anoConfig;
	  String[] listaAnos = new String[(anoFinal-anoInicial)+1];
        	  try{
		for(int i=0;i<=anoFinal-anoInicial;i++)
		{
			listaAnos[i] =  Integer.toString(anoInicial+i);
		}
        	  }catch(Exception ex){}
        	  return listaAnos;
          }
          
          /**
           * Funcin que devuelve un array con los aos que se van a cargar en el combo de bsqueda de Cuestionarios de Suelo Municipal
           * 
           * @return Devuelve un array con los  aos
           */
           public static String[] dameArrayAnosCuesSMAnu(){
        		  int anoInicial = 0;
        		  int anoFinal = 0;
        		  Calendar c = new GregorianCalendar();
//        		  anoInicial =  Integer.valueOf(Q02aConstantes.getString("q02a.cuestionarios.ayunMen.anoInicial")).intValue();
        		  int anoConfig =  Integer.valueOf(Q02aConstantes.getString("q02a.cuestionarios.sMAnu.anosConfig")).intValue();
        		  anoFinal =   c.get(Calendar.YEAR);
        		  anoInicial = anoFinal - anoConfig;
        		  String[] listaAnos = new String[(anoFinal-anoInicial)+1];
        		  	  try{
        		  for(int i=0;i<=anoFinal-anoInicial;i++)
        		  {
        		  	listaAnos[i] =  Integer.toString(anoInicial+i);
        		  }
        		  	  }catch(Exception ex){}
        		  	  return listaAnos;
        		   }
           
   /**
* Funcin que devuelve un array con los aos que se van a cargar en el combo de bsqueda de Cuestionarios de Suelo Municipal
* 
* @return Devuelve un array con los  aos
*/
public static String[] dameArrayAnosCuesVTMAnu(){
	int anoInicial = 0;
	int anoFinal = 0;
	Calendar c = new GregorianCalendar();
	anoInicial =  Integer.valueOf(Q02aConstantes.getString("q02a.cuestionarios.VTMAnu.anoInicial")).intValue();
	anoFinal =  c.get(Calendar.YEAR);
	String[] listaAnos = new String[(anoFinal-anoInicial)+1];
		try{
			for(int i=0;i<=anoFinal-anoInicial;i++)
			{
				listaAnos[i] =  Integer.toString(anoInicial+i);
			}
		}catch(Exception ex){}

	return listaAnos;

}



/**
 * Funcin que devuelve un array con los aos que se van a cargar en el combo de bsqueda de Cuestionarios VAPM
 * 
 * @return Devuelve un array con los  aos
 */
 public static String[] dameArrayAnosCuesVAPM(){
	  int anoInicial = 0;
int anoFinal = 0;

Calendar c = new GregorianCalendar();

//anoInicial =  Integer.valueOf(Q02aConstantes.getString("q02a.cuestionarios.ayunMen.anoInicial")).intValue();

int anoConfig =  Integer.valueOf(Q02aConstantes.getString("q02a.cuestionarios.VAPM.anosConfig")).intValue();

anoFinal =   c.get(Calendar.YEAR);

anoInicial = anoFinal - anoConfig;

String[] listaAnos = new String[(anoFinal-anoInicial)+1];

	  try{

for(int i=0;i<=anoFinal-anoInicial;i++)

{

	listaAnos[i] =  Integer.toString(anoInicial+i);

}

	  }catch(Exception ex){}

	  return listaAnos;

 }

 /**
 * Funcin que devuelve un array con los aos que se van a cargar en el combo de creacin de los cuestionarios
 * 
 * @return Devuelve un array con los  aos
 */

 public static String[] dameArrayAnosCues(){
 	int anoInicial = 0;
 	int anoFinal = 0; 
 	Calendar c = new GregorianCalendar();
 	//anoInicial =  Integer.valueOf(Q02aConstantes.getString("q02a.cuestionarios.VTMAnu.anoInicial")).intValue();
 	anoFinal =  c.get(Calendar.YEAR);
 	anoInicial =  anoFinal-1;
 	String[] listaAnos = new String[(anoFinal-anoInicial)+1];

 		try{
 			for(int i=0;i<=anoFinal-anoInicial;i++){
 				listaAnos[i] =  Integer.toString(anoInicial+i);
 			}
 		}catch(Exception ex){}

 	return listaAnos;

 } 
 
	public static String[] dameArrayAnosEst() {
		int anoInicial = 0;
		int anoFinal = 0;
		Calendar c = new GregorianCalendar();
		/*
		 * XXX[JBHG] PARCHE (Puerta Goikoetxea, Aitor
		 * <a-puertagoikoetxea@euskadi.eus>) Se ha pedido que el anyo minimo a
		 * elegir para las estadisticas sea de 2010 en adelante). Del 2001 al
		 * 2009 no se tienen guardadas estadisticas.
		 */
		// anoFinal = c.get(Calendar.YEAR) + 15;
		// anoInicial = anoFinal-30;
		anoInicial = c.get(Calendar.YEAR) - 15;
		if (anoInicial < 2010) {
			anoInicial = 2010;
		}
		anoFinal = anoInicial + 30;

		String[] listaAnos = new String[(anoFinal - anoInicial) + 1];

		try {
			for (int i = 0; i <= anoFinal - anoInicial; i++) {
				listaAnos[i] = Integer.toString(anoInicial + i);
			}
		} catch (Exception ex) {
		}

		return listaAnos;

	}

}