package q02a.exe.solicitudesNora.dataobjects;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;

import q02a.exe.arquitectura.dataobjects.Q02aDataBaseDAO;
import q02a.exe.solicitudesNora.valueobjects.Q02aSolicitudNora;
import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022WS00;
import q02a.exe.utils.Q02aFormatData;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;

/**
 * 
 * @author GADIMAAR
 *
 */
public class Q02aSolicitudesNoraDataBaseDAO extends Q02aDataBaseDAO{

    private static final long serialVersionUID = -8520551641771839103L;
	private static Q70Traza tr = Q70Traza.getSingleton();
	private static final String COMPONENTE = "DAO_ACCESO_DATOS";
	private static final String RECURSOS_CUES_SM_ANU = "q02arecursosCuestionarios";

    /**
     * 
     *
     */
	public Q02aSolicitudesNoraDataBaseDAO() {
        super();                
    }

    /**
     * 
     * @param conn conn
     */
    public Q02aSolicitudesNoraDataBaseDAO(Connection conn) {
    	super(conn);     
    }
     /**
      * Funcin que inserta los datos de una solicitud de alta en NORA
      * @param solicitudNora - Datos de la solicitud a insertar
      * @throws Exception Exception
      */
     public void insertarSolicitudNora(Q02aSolicitudNora solicitudNora) throws Exception {
       	Q02aTablaBDQ022WS00 tablaBDSolicitudesNora = null;
       	try{
	    	if (tr.isTraceActive()){
	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarSolicitudNora: entrando");
	    	}
    		//se crea el objeto de tablasBD
	    	tablaBDSolicitudesNora = new Q02aTablaBDQ022WS00(this.getConnection());
	    	this.rellenaDatosSolicitudNora(solicitudNora, tablaBDSolicitudesNora);         	         
      		//se realiza la insert
	    	tablaBDSolicitudesNora.insert();
     	}
     	catch(Exception ex){   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarSolicitudNora: " + sw.getBuffer ().toString());
     		throw ex;
     	}finally{
     		try{
     			tablaBDSolicitudesNora.freeResourcesNotConnection();	
     		}
     		catch(Exception ex){
     			if (tr.isTraceActive()){
     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarSolicitudNora: error liberando recursos");
 		   	   }  
     		}  		
     		if (tr.isTraceActive()){
     			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarSolicitudNora: saliendo");                
    		}       	
     	}
     }

     /**
      * Funcin que modifica los datos de la solcitud de alta en NORA si as corresponde
      * @param solicitudNora - Datos de la solicitud a modificar
      * @throws Exception Exception
      */
     public void modificarSolicitudNora(Q02aSolicitudNora solicitudNora) throws Exception{
    	if (tr.isTraceActive()){
        	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarSolicitud: entrando");
        }
    	try{ 
    		this.borrarSolicitudNora(solicitudNora.getCodigo(), solicitudNora.getNiGrupoCuestionario(), solicitudNora.getNiCuestionario());
    		if(!Q02aFormatData.esVacio(solicitudNora.getDireccion())){
    				this.insertarSolicitudNora(solicitudNora);
            }
    		
    	}catch(Exception ex){
             java.io.StringWriter sw = new java.io.StringWriter();
             java.io.PrintWriter pw = new java.io.PrintWriter(sw);
             ex.printStackTrace(pw);
             tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarSolicitud: " + sw.getBuffer ().toString());
             throw ex;
        }
    	finally{     
         	if (tr.isTraceActive()){
         		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarSolicitud: saliendo");                
         	}             
         }     
     }
     
     /**
      * Funcin que borra la solicitud
      * @param codigoCuestionario - solicitud NORA a eliminar
      * @param niGrupo - solicitud NORA a eliminar
      * @param niCuestionario - solicitud NORA a eliminar
      * 
      * @throws Exception Exception
      */
     public void borrarSolicitudNora(String codigoCuestionario, String niGrupo, String niCuestionario) throws Exception {

    	if (tr.isTraceActive()){
    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarSolicitudNora: entrando");
      	}
       //se crean los objetos necesarios
    	Q02aTablaBDQ022WS00 tablaBDSolicitudesNora = null;      
          try{       	
         	 //se crea el objeto de tablasBD
        	tablaBDSolicitudesNora = new Q02aTablaBDQ022WS00(this.getConnection());
        	tablaBDSolicitudesNora.setQ022NT00_CODIGO_WHERE(codigoCuestionario);
   	    	tablaBDSolicitudesNora.setQ022WT00_ID_GRUPO_WHERE(Q02aFormatData.checkIntegerNull(niGrupo));
   	    	tablaBDSolicitudesNora.setQ022WT00_ID_CUES_WHERE(Q02aFormatData.checkLongNull(niCuestionario));
   	        //se lanza al delete
            tablaBDSolicitudesNora.delete();         	
         }
         catch(Exception ex){
              java.io.StringWriter sw = new java.io.StringWriter();
              java.io.PrintWriter pw = new java.io.PrintWriter(sw);
              ex.printStackTrace(pw);
              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarSolicitudNora: " + sw.getBuffer ().toString());
              throw ex;
         }finally{
         	try	{
         		tablaBDSolicitudesNora.freeResourcesNotConnection();	
         	}
         	catch(Exception ex){
         		if (tr.isTraceActive()){
         				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarSolicitudNora: error liberando recursos");
         		}  
         	}  		
         	if (tr.isTraceActive()){
         			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarSolicitudNora: saliendo");                
         		}     	   
         }
     }//fin borrarSolicitudNora

     /**
      * Funcin que informa ell objeto tablaBD con los datos de la solicitud a insertar
      * 
      * @param solicitudNora solicitudNora
      * @param tablaBDSolicitudesNora tablaBDSolicitudesNora
      * 
      * @throws Exception Exception
      */
     public void rellenaDatosSolicitudNora(Q02aSolicitudNora solicitudNora, Q02aTablaBDQ022WS00 tablaBDSolicitudesNora ) throws Exception {
     	try{
 	    	if (tr.isTraceActive()){
 	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosSolicitudNora: entrando");
 	    	}         	         
      		//se aaden los datos
 	    	tablaBDSolicitudesNora.setQ022WT00_NI(this.dameSeqSolicitudNora());
 	    	tablaBDSolicitudesNora.setQ022NT00_CODIGO(Q02aFormatData.checkStringNull(solicitudNora.getCodigo()));
 	    	tablaBDSolicitudesNora.setQ022WT00_ID_GRUPO(Q02aFormatData.checkIntegerNull(solicitudNora.getNiGrupoCuestionario()));
 	    	tablaBDSolicitudesNora.setQ022WT00_ID_CUES(Q02aFormatData.checkLongNull(solicitudNora.getNiCuestionario()));
 	    	tablaBDSolicitudesNora.setQ022WT00_DIRECCIN(solicitudNora.getDireccion());
 	    	tablaBDSolicitudesNora.setQ022WT00_ESTADO(solicitudNora.getEstadoSolicitud());
 	    	tablaBDSolicitudesNora.setQ022WT00_FECHA_GRABACION(new Date());
 	    	//Las observaciones solamente se pueden modificar desde la Intranet
 	    	tablaBDSolicitudesNora.setQ022WT00_OBSERVACIONES(null);
 	   
     	}catch(Exception ex){   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaDatosSolicitudNora: " + sw.getBuffer ().toString());
     		throw ex;
     	}finally{    		
 			if (tr.isTraceActive()){
 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosSolicitudNora: saliendo");                
            }       	
     	}	
     }
     
     /**
      * Funcin que devuelve el siguiente valor de la secuencia Q022WQ00 de la tabla Q022WT00
      * 
      * @return valorSec
      * @throws Exception Exception
      */
     private int dameSeqSolicitudNora() throws Exception 
     {
    	 int valorSec=0;
    	 ResultSet rs = null;
       	 PreparedStatement prepStmt =null;	
       	 try{
	    	if (tr.isTraceActive()){
	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameSeqSolicitudNora: entrando");
	    	}
	   		StringBuffer query = new StringBuffer(" SELECT Q022WQ00.NEXTVAL FROM DUAL ");
	        prepStmt = this.getConnection().prepareStatement(query.toString());         	
	        rs = prepStmt.executeQuery();
	        if (rs.next()){
	         	valorSec = rs.getInt(1);
	        }
	         return valorSec;
	     } catch(Exception ex){   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameSeqSolicitudNora: " + sw.getBuffer ().toString());
     		throw ex;
     	  }
     } 
}
