package q02a.exe.solicitudesNora.beans;

import q02a.exe.arquitectura.beans.Q02aBaseBean;
import q02a.exe.solicitudesNora.dataobjects.Q02aSolicitudesNoraDataBaseDAO;
import q02a.exe.solicitudesNora.valueobjects.Q02aSolicitudNora;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

   /**
    * 
    * @author GADIMAAR
    *
    */
public class Q02aSolicitudesNoraBean extends Q02aBaseBean{
	private static final long serialVersionUID = 5474311672836163390L;
	protected Q02aSolicitudesNoraDataBaseDAO daoSolicitudesNora = null;
	
	/** Constructor vacio */
    public Q02aSolicitudesNoraBean() {
        super();
    }

   /**
	 * Insertar en bbdd una  nueva solicitud de alta provisional en NORA con los datos pasados como parmetro
	 * @param solicitudNora - Datos de la solicitud a insertar
     * @throws Exception Exception
	 */
	public void insertarSolicitudNora(Q02aSolicitudNora solicitudNora) throws Exception 

	{

		boolean error=false;

		try {

			if (tr.isTraceActive()){     

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarSolicitudNora: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de la solicitud  : " + solicitudNora.toString());

			}

			 //se abre la conexin

   			abrirConexion();

   			//se instancia el dao pasandole la conexin			

   			daoSolicitudesNora = new Q02aSolicitudesNoraDataBaseDAO(this.getConn());

   			daoSolicitudesNora.insertarSolicitudNora(solicitudNora);

	 

		}catch(Exception ex){

			error= true;

			java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw); 

            if (tr.isTraceActive()){  

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarSolicitudNora: " + sw.getBuffer ().toString());

			}

            

            throw ex;

		 }finally{

	 		 try{

	 			daoSolicitudesNora.freeResourcesNotConnection();

	 		   }catch(Exception ex){

	 			   if (tr.isTraceActive()){

	 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarSolicitudNora: error liberando recursos");

	 	   	   	   }  

	 		   }  		 

	  		  	//se cierra la conexin  

	  		  	cerrarConexion(error);	       	

	 	        if (tr.isTraceActive()){

	 	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarSolicitudNora: saliendo.");

	 	   		}

	  	  }

	} // fin insertarSolicitudNora

	

	

	 /**

	 * Modifica en bbdd una  nueva solicitud de alta provisional en NORA con los datos pasados como parmetro
	 * @param solicitudNora - Datos de la solicitud a modificar
     * @throws Exception Exception
	 */

	public void modificarSolicitudNora(Q02aSolicitudNora solicitudNora) throws Exception 

	{

		boolean error=false;

		try {

			if (tr.isTraceActive()){     

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarSolicitudNora: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de la solicitud  : " + solicitudNora.toString());

			}

			 //se abre la conexin

   			abrirConexion();

   			//se instancia el dao pasandole la conexin			

   			daoSolicitudesNora = new Q02aSolicitudesNoraDataBaseDAO(this.getConn());

   			daoSolicitudesNora.modificarSolicitudNora(solicitudNora);

	 

		}catch(Exception ex){

			error= true;

			java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw); 

            if (tr.isTraceActive()){  

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarSolicitudNora: " + sw.getBuffer ().toString());

			}

            

            throw ex;

		 }finally{

	 		 try{

	 			daoSolicitudesNora.freeResourcesNotConnection();

	 		   }catch(Exception ex){

	 			   if (tr.isTraceActive()){

	 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarSolicitudNora: error liberando recursos");

	 	   	   	   }  

	 		   }  		 

	  		  	//se cierra la conexin  

	  		  	cerrarConexion(error);	       	

	 	        if (tr.isTraceActive()){

	 	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarSolicitudNora: saliendo.");

	 	   		}

	  	  }

	} // fin insertarSolicitudNora

	

	

	 /**

	 * Elimina de la bbdd una solicitud de alta provisional en NORA

	 * @param solicitudNora - solicitud NORA a eliminar 

	 */

	/*public void borrarSolicitudNora(Q02aSolicitudNora solicitudNora) throws Exception 

	{

		boolean error=false;

		try {

			if (tr.isTraceActive()){     

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarSolicitudNora: entrando");

				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de la solicitud  : " + solicitudNora.toString());

			}

			 //se abre la conexin

   			abrirConexion();

   			//se instancia el dao pasandole la conexin			

   			daoSolicitudesNora = new Q02aSolicitudesNoraDataBaseDAO(this.getConn());

   			daoSolicitudesNora.borrarSolicitudNora(solicitudNora);

	 

		}catch(Exception ex){

			error= true;

			java.io.StringWriter sw = new java.io.StringWriter();

            java.io.PrintWriter pw = new java.io.PrintWriter(sw);

            ex.printStackTrace(pw); 

            if (tr.isTraceActive()){  

				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarSolicitudNora: " + sw.getBuffer ().toString());

			}

            

            throw ex;

		 }finally{

	 		 try{

	 			daoSolicitudesNora.freeResourcesNotConnection();

	 		   }catch(Exception ex){

	 			   if (tr.isTraceActive()){

	 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarSolicitudNora: error liberando recursos");

	 	   	   	   }  

	 		   }  		 

	  		  	//se cierra la conexin  

	  		  	cerrarConexion(error);	       	

	 	        if (tr.isTraceActive()){

	 	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarSolicitudNora: saliendo.");

	 	   		}

	  	  }

	}*/ // fin borrarSolicitudNora

	
}