package q02a.exe.solicitudes.mail;

import java.util.*;
import java.io.*;
import javax.mail.*;
import javax.mail.internet.*;
import javax.activation.*;
 
/**
 *  Clase creada para el envo de correo mediante protocolo SMTP
 *  @author sssssmail
 */

public class q02aSMTPMail
{  

    /**
    *  Parsea las direcciones de correo desde una cadena con las direcciones separadas por comas.
    *  @param  addresses Cadena con las direcciones de correo
    *  @return  Vector con las direcciones parseadas.
    */

    static Vector parseAddresses( String addresses) 
    {
        Vector vector = new Vector();
        if ( addresses != null) {
            StringTokenizer st = new StringTokenizer( addresses, ",");
            while ( st.hasMoreTokens()) {
                vector.add( st.nextToken());
            }
        }
        return vector;
    }
    
    /**
    *  Parsea los attachments desde una cadena con los attachments separados por comas.
    *  @param  attachments Cadena con los attachments de correo
    *  @return  Vector con los attachments parseados.
    */
    static Vector parseAttachments( String attachments) 
    {
        return parseAddresses( attachments);
    }
    
    /**
    *  Envia un correo por SMTP.
    *  @param  host Direccin del host SMTP.
    *  @param  fromAddress Direccin del remitente.
    *  @param  toAddresses Cadena con los destinatarios separados por comas.
    *  @param  subject Asunto del correo.
    *  @param  text Texto del correo.
    *  @param  htmlText Correo en html.
    *  @param  fileAttachments Cadena con los attachments separados por comas..
    *  
    *  @throws AddressException  AddressException
    *  @throws MessagingException MessagingException
    */
    protected static void send( String host, String fromAddress, String toAddresses, String subject, String text, String htmlText, String fileAttachments) throws AddressException, MessagingException
    {
        String smtpHost = host; // "192.168.197.2"; 

        String from = fromAddress;

        Vector to = parseAddresses( toAddresses);

        Vector attachments = parseAttachments( fileAttachments);



        // Get system properties

        Properties props = System.getProperties();



        // Setup mail server

        props.put( "mail.smtp.host", smtpHost);



        // Get session

        Session session = Session.getDefaultInstance( props, null);



        // Define message

        MimeMessage message = new MimeMessage( session);



        // Message add FROM

        message.setFrom( new InternetAddress( from));

        

        // Message add TO

        for ( Enumeration eToAddresses = to.elements(); eToAddresses.hasMoreElements();) {

            message.addRecipient( Message.RecipientType.TO, new InternetAddress( ( String) eToAddresses.nextElement()));

        }



        // Message add SUBJECT

        message.setSubject( subject,"iso-8859-1");

        

        if ( attachments.size() == 0) {

            // No Multi-part mail

            //message.setText( text);Rafa

            //=========== HTML MESSAGE =====================================

            MimeBodyPart multipartHTML = new MimeBodyPart();



            multipartHTML.setText(text,"iso-8859-1");





            // setting the right values for the Header

            multipartHTML.setHeader("Content-Type","text/html;");

            multipartHTML.setHeader("Content-Transfer-Encoding", "base64");



            //commenting to check the problem in charset

            //multipartHTML.setHeader("charset","\"gb2312\""); 

            

            //Creating a multipart that will englobe all the already defined bodyparts, this will also define the header of the message

            Multipart multipart = new MimeMultipart("alternative");

            // Adding both, the text, and the signature

            //multipart.addBodyPart(multitext);

            multipart.addBodyPart(multipartHTML);

            // Adding the date to the mail

            //message.setSentDate(new Date());

            // Adding the mime multi part to the mail

            message.setContent(multipart);



        } else {

            // Create the multi-part

            Multipart multipart = new MimeMultipart( ( htmlText == null || htmlText.length() == 0) ? "mixed" : "related");



            // Create part text, Fill htmlText and add the part

            BodyPart messageTextPart = new MimeBodyPart();

            messageTextPart.setText( text + "\n");

            multipart.addBodyPart( messageTextPart);

                

            // Create part text, Fill htmlText and add the part

            if ( htmlText != null || htmlText.length() > 0) {

                BodyPart messageHtmlTextPart = new MimeBodyPart();

                messageHtmlTextPart.setDataHandler( new DataHandler( new q02aSMTPByteArrayDataSource( htmlText, "text/html")));

                multipart.addBodyPart( messageHtmlTextPart);

            }

                

            // Create part attachments, Fill attachments and add the part

            for ( Enumeration eAttachments = attachments.elements(); eAttachments.hasMoreElements();) {
                String nameFile = ( String) eAttachments.nextElement();
                BodyPart messageAttachmentsPart = new MimeBodyPart();
                DataSource source = new FileDataSource( nameFile);
                messageAttachmentsPart.setDataHandler( new DataHandler( source));
                messageAttachmentsPart.setHeader( "Content-ID", nameFile);
                messageAttachmentsPart.setFileName( ( new File( nameFile)).getName());
                multipart.addBodyPart( messageAttachmentsPart);
            }
                
            // Put parts in message
            message.setContent( multipart);

        }

        // Send message
        Transport.send( message);
    }

    /**
    *  Envia un correo por SMTP.
    *  @param  host Direccin del host SMTP.
    *  @param  fromAddress Direccin del remitente.
    *  @param  toAddresses Cadena con los destinatarios separados por comas.
    *  @param  subject Asunto del correo.
    *  @param  text Texto del correo.
    *  @throws AddressException AddressException
    *  @throws MessagingException MessagingException
    */
    public static void sendMail( String host, String fromAddress, String toAddresses, String subject, String text) throws AddressException, MessagingException
    {
        send( host, fromAddress, toAddresses, subject, text, null, null);
    }
    
    /**
    *  Envia un correo por SMTP.
    *  @param  host Direccin del host SMTP.
    *  @param  fromAddress Direccin del remitente.
    *  @param  toAddresses Cadena con los destinatarios separados por comas.
    *  @param  subject Asunto del correo.
    *  @param  text Texto del correo.
    *  @param  fileAttachments Cadena con los attachments separados por comas..
    *  @throws AddressException AddressException
    *  @throws MessagingException MessagingException
    */
    public static void sendMail( String host, String fromAddress, String toAddresses, String subject, String text, String fileAttachments) throws AddressException, MessagingException
    {
        send( host, fromAddress, toAddresses, subject, text, null, fileAttachments);
    }
    
    /**
    *  Envia un correo por SMTP.
    *  @param  host Direccin del host SMTP.
    *  @param  fromAddress Direccin del remitente.
    *  @param  toAddresses Cadena con los destinatarios separados por comas.
    *  @param  subject Asunto del correo.
    *  @param  text Texto del correo.
    *  @param  html Correo en html.
    *  @param  fileAttachments Cadena con los attachments separados por comas..
    *  @throws AddressException AddressException
    *  @throws MessagingException MessagingException
    */

    public static void sendMail( String host, String fromAddress, String toAddresses, String subject, String text, String html, String fileAttachments) throws AddressException, MessagingException
    {
        send( host, fromAddress, toAddresses, subject, text, html, fileAttachments);
    }
	
    /**
     * 
     * @param fromAddress fromAddress
     * @param toAddresses toAddresses
     * @param subject subject
     * @param text text
     * @throws AddressException AddressException
     * @throws MessagingException MessagingException
     */
	public static void sendMail(String fromAddress, String toAddresses, String subject, String text) throws AddressException, MessagingException
    {
		//String host = q02a.exe.comun.config.q02aConfiguracion.getProperty("mail.smtp.host");
		String host = es.ejie.frmk.listeners.base.Q70ListenerUtils.getApplicationProperty("mail.smtp.host");

        send( host, fromAddress, toAddresses, subject, text, null, null);
    }
    
}
   