package q02a.exe.seguridad.dataobjects;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import q02a.exe.arquitectura.dataobjects.Q02aDataBaseDAO;
import q02a.exe.plazos.valueobjects.Q02aPlazos;
import q02a.exe.seguridad.valueobjects.Q02aProvMuni; 
import q02a.exe.seguridad.valueobjects.Q02aUsuario;
import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022AS00;
import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022FS00;
import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022FS01V01;
import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ021MS00;
import q02a.exe.utils.Q02aFormatData;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import q02a.exe.arquitectura.utils.crypto.Q02aEncrypt;
import q02a.exe.utils.Q02aConstantes;

/**
 * 
 * @author GADIMAAR
 *
 */
public class Q02aSeguridadDataBaseDAO extends Q02aDataBaseDAO{

	private static final long serialVersionUID = -8520551641771839103L;
	/**
     * 
     *
	 */
    public Q02aSeguridadDataBaseDAO() {
        super();                
    }

    /**
     * 
     * @param conn conn
     */
    public Q02aSeguridadDataBaseDAO(Connection conn) {
    	super(conn);     
    }
    

    /**
     * Mtodo que rellena un objeto Q02aUsuario a partir de una fila obtenida de bbdd.
     * @param rs ResultSet con la tupla.
     * @return usuario
     * @throws Exception  Exception
     */

    public Q02aUsuario rellenaVOUsuario(ResultSet rs) throws Exception {
    	Q02aUsuario usuario = new Q02aUsuario();
    	try{
    		if (tr.isTraceActive()){
		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOUsuario: entrando");                
		    } 

    		usuario.setId(rs.getString(Q02aTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_IDUSUARIO));
    		//usuario.setPass(rs.getString(Q02aTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_PASSWORD));

    		if(rs.getString(Q02aTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_PASSWORD)!=null){
    			usuario.setPass(Q02aEncrypt.decrypPassWordDes(Q02aConstantes.getString("Q02_CIFER_ALG"), rs.getString(Q02aTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_PASSWORD)));
            }
    		usuario.setNombre(rs.getString(Q02aTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_NOMBRE));
    		usuario.setApellido1(rs.getString(Q02aTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_APELLIDO1));
    		usuario.setApellido2(rs.getString(Q02aTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_APELLIDO2));
    		usuario.setDni(rs.getString(Q02aTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_NIF));
    		usuario.setNiPerfil(rs.getString(Q02aTablaBDQ022FS01V01.NOMCOLUMN_Q021AT00_CODPERFIL));
    		usuario.setNiProvincia(rs.getString(Q02aTablaBDQ022FS01V01.NOMCOLUMN_MUN_PROV));
    		usuario.setDescProvincia(rs.getString(Q02aTablaBDQ022FS01V01.NOMCOLUMN_DESC_PROV ));
    		usuario.setNiMunicipio(rs.getString(Q02aTablaBDQ022FS01V01.NOMCOLUMN_MUN_MUNI));
    		usuario.setDescMunicipio(rs.getString(Q02aTablaBDQ022FS01V01.COLUMN_DESC_MUNI));
    		usuario.setFechaActivacion(rs.getString(Q02aTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_FECHA_ACTIVACION));
    		usuario.setFechaDesactivacion(rs.getString(Q02aTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_FECHA_DESACTIVACION));
    		usuario.setMail(rs.getString(Q02aTablaBDQ022FS01V01.NOMCOLUMN_Q022FT00_EMAIL));
    		
    		return usuario;
    	}catch(Exception ex){    	 	   
  	       java.io.StringWriter sw = new java.io.StringWriter();
  	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);
  	       ex.printStackTrace(pw);
  	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaVOUsuario: " + sw.getBuffer ().toString());
  	       throw ex;
  		}finally{			 	
  			if (tr.isTraceActive()){
  		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOUsuario: saliendo");                
  		    }    				
  		}
    }
    
    /**
     * Mtodo que obtiene los datos de un usuario a partir de su id.
     * @param dniUsuario identificador de usuario.
     * @return Q02aUsuario con los datos del usuario.
     * @throws Exception Exception
     */

    public Q02aUsuario obtenerUsuario (String dniUsuario) throws Exception {
    	Q02aTablaBDQ022FS01V01 tablaBDUsuarios = null;
    	ResultSet rs = null;
    	   
    	try{
    		if (tr.isTraceActive()){
     			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuario: entrando "+ dniUsuario);     			
     		}
    		
    		tablaBDUsuarios = new Q02aTablaBDQ022FS01V01(this.getConnection());
    		    		
    		tablaBDUsuarios.setQ022FT00_NIF_WHERE(dniUsuario);
    		tablaBDUsuarios.setAditionalWhere (" and " +  Q02aTablaBDQ022FS00.NOMCOLUMN_Q022FT00_FECHA_ACTIVACION + " <= SYSDATE AND ( " + Q02aTablaBDQ022FS00.NOMCOLUMN_Q022FT00_FECHA_DESACTIVACION + " IS NULL OR " + Q02aTablaBDQ022FS00.NOMCOLUMN_Q022FT00_FECHA_DESACTIVACION + " >= SYSDATE )  ");
    		if (tr.isTraceActive()){
     			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuario: WHERE "+ tablaBDUsuarios.getAditionalWhere());     			
     		}
    		rs = tablaBDUsuarios.select();     		
              
    		tablaBDUsuarios.addResultSet(rs);
    		if (rs.next()){
    			return this.rellenaVOUsuario(rs);
    		}else{ 
    			return null;
    		}
    		
    	}catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);  
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuario: " + sw.getBuffer ().toString());
            throw ex;
   	 	}finally{
   	 		try{
   	 			tablaBDUsuarios.freeResourcesNotConnection();	
   	 		}catch(Exception ex){
   	 			if (tr.isTraceActive()){
   	 				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuario: error liberando recursos");
   	 			}  
   	 		}  		
   	 		if (tr.isTraceActive()){
   	 			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuario: saliendo");                
   	 		}           
   	 	}      	
    }
   
    /**
     * Mtodo que obtiene los datos de un usuario a partir de su id.
     * @param niProvincia niProvincia
     * @param niMunicipio niMunicipio
     * 
     * @return listaPlazos con los datos del usuario.
     * @throws Exception Exception
     */
    public ArrayList obtenerPlazos(String niProvincia ,String niMunicipio) throws Exception {
    	Q02aTablaBDQ022AS00 tablaBDPlazos = null;
    	ArrayList listaPlazos = new ArrayList();    	
    	ResultSet rs = null;    	   
    	try{
    		if (tr.isTraceActive()){
     			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerPlazos: entrando "+ niProvincia);     			
     		}
    		
    		tablaBDPlazos = new Q02aTablaBDQ022AS00(this.getConnection());
    		/*if ( anyo != 0){
    			tablaBDPlazos.setQ022AT00_ANO_WHERE(anyo);
    		}else{
    			Date fechaHoy = new Date();
    			tablaBDPlazos.setQ022AT00_ANO_WHERE(fechaHoy.getYear());
    		}*/
    		if (!Q02aFormatData.esNull(niProvincia).equals("")){
    			tablaBDPlazos.setMUN_PROV_WHERE(niProvincia);
    		}
    		if (!Q02aFormatData.esNull(niMunicipio).equals("")){
    			tablaBDPlazos.setMUN_MUNI_WHERE(niMunicipio);
    		}
    		rs = tablaBDPlazos.select();     		              
    		tablaBDPlazos.addResultSet(rs);    		  	
    		while (rs.next()){
    			Q02aPlazos plazo = new Q02aPlazos();
        		plazo.setProvincia(rs.getString(Q02aTablaBDQ022AS00.NOMCOLUMN_MUN_PROV));
        		plazo.setMunicipio(rs.getString(Q02aTablaBDQ022AS00.NOMCOLUMN_MUN_MUNI)); 
        		//si el registro no tiene municipio, le ponemos un 0 para saber que significa "Todos los municipios"
        		if (Q02aFormatData.esVacio(plazo.getMunicipio())){
    	    		plazo.setMunicipio("0");
    	    	}
        		plazo.setPlazo(rs.getString(Q02aTablaBDQ022AS00.NOMCOLUMN_Q022AT00_PLAZO));
        		plazo.setDia(rs.getString(Q02aTablaBDQ022AS00.NOMCOLUMN_Q022AT00_PLAZO_DIA));
        		plazo.setTipoCuestionario(rs.getString(Q02aTablaBDQ022AS00.NOMCOLUMN_Q022NT00_CODIGO));
        		plazo.setAnyo(rs.getString(Q02aTablaBDQ022AS00.NOMCOLUMN_Q022AT00_ANO));
        		listaPlazos.add(plazo);
        		
    		}
    		return listaPlazos;
    	}catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);  
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuario: " + sw.getBuffer ().toString());
            throw ex;
   	 	}finally{
   	 		try{
   	 			tablaBDPlazos.freeResourcesNotConnection();	
   	 		}catch(Exception ex){
   	 			if (tr.isTraceActive()){
   	 				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerUsuario: error liberando recursos");
   	 			}  
   	 		}  		
   	 		if (tr.isTraceActive()){
   	 			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerUsuario: saliendo");                
   	 		}           
   	 	}      	
    }
    
    /**
     * Mtodo que verifica si el usuario tiene acceso permitido (existe en la tabla de usuarios)
     * @param dniUsuario identificador de usuario.
     * @return acceso boolean 
     * @throws Exception Exception
     */
    public boolean accesoPermitido (String dniUsuario) throws Exception {
    	Q02aTablaBDQ022FS00 tablaBDUsuarios = null;
    	ResultSet rs = null;
    	try{
    		if (tr.isTraceActive()){
     			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":accesoPermitido: entrando "+ dniUsuario);     			
     		}
    		tablaBDUsuarios = new Q02aTablaBDQ022FS00(this.getConnection());
    		tablaBDUsuarios.setQ022FT00_NIF_WHERE(dniUsuario);
    		tablaBDUsuarios.setAditionalWhere (" and " +  Q02aTablaBDQ022FS00.NOMCOLUMN_Q022FT00_FECHA_ACTIVACION + " <= SYSDATE AND ( " + Q02aTablaBDQ022FS00.NOMCOLUMN_Q022FT00_FECHA_DESACTIVACION + " IS NULL OR " + Q02aTablaBDQ022FS00.NOMCOLUMN_Q022FT00_FECHA_DESACTIVACION + " >= SYSDATE )  ");

            if (tr.isTraceActive()){
     			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":accesoPermitido: WHERE "+ tablaBDUsuarios.getAditionalWhere());     			
     		}
    		rs = tablaBDUsuarios.select();     		
           tablaBDUsuarios.addResultSet(rs);
    		if (rs.next()){
    			return true;
    		}else{ 
    			return false;
    		}
    		
    	}catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);  
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":accesoPermitido: " + sw.getBuffer ().toString());
            throw ex;
   	 	}finally{
   	 		try{
   	 			tablaBDUsuarios.freeResourcesNotConnection();	
   	 		}catch(Exception ex){
   	 			if (tr.isTraceActive()){
   	 				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":accesoPermitido: error liberando recursos");
   	 			}  
   	 		}  		
   	 		if (tr.isTraceActive()){
   	 			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":accesoPermitido: saliendo");                
   	 		}           
   	 	}      	
    }
   
    /**
     * Mtodo guarda la password del usuario en la tabla de Usuarios
     * @param dniUsuario identificador de usuario.
     * @param pwd password del usuario.
     * @throws Exception Exception
     */
    	public void guardarPassword (String dniUsuario, String pwd) throws Exception {
    	Q02aTablaBDQ022FS00 tablaBDUsuarios = null;
    	ResultSet rs = null;
    	try{
    		if (tr.isTraceActive()){
     			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarPassword: entrando "+ dniUsuario);     			
     		}
			//La guardamos en la tabla
			tablaBDUsuarios = new Q02aTablaBDQ022FS00(this.getConnection());
    		tablaBDUsuarios.setQ022FT00_PASSWORD(Q02aEncrypt.encrypPassWordDes(Q02aConstantes.getString("Q02_CIFER_ALG"), pwd));
    		tablaBDUsuarios.setQ022FT00_NIF_WHERE(dniUsuario);
    		tablaBDUsuarios.update();
   		
    		if (tr.isTraceActive()){
     			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarPassword: WHERE "+ tablaBDUsuarios.getAditionalWhere());     			
     		}
    	}catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);  
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":guardarPassword: " + sw.getBuffer ().toString());
            throw ex;
   	 	}finally{
   	 		try{
   	 			tablaBDUsuarios.freeResourcesNotConnection();	
   	 		}catch(Exception ex){
   	 			if (tr.isTraceActive()){
   	 				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":guardarPassword: error liberando recursos");
   	 			}  
   	 		}  		
   	 		if (tr.isTraceActive()){
   	 			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarPassword: saliendo");                
   	 		}           
   	 	}      	
    }
    	
    	/**
         * Mtodo que obtiene los municipios de un usuario 
         * @param idUsuario identificador de usuario.
         * @return ArrayList con los datos del municipios a los que puede acceder el usuario
         * @throws Exception Exception
         */
        public ArrayList obtenerMunicipiosUsuario (String idUsuario) throws Exception {
        	Q02aTablaBDQ021MS00 tablaBDMunicipioUsuario = null;
        	ResultSet rs = null;
        	ArrayList listaProvMuni = new ArrayList();  
        	   
        	try{
        		if (tr.isTraceActive()){
         			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerMunicipiosUsuario: entrando "+ idUsuario);     			
         		}
        		
        		tablaBDMunicipioUsuario = new Q02aTablaBDQ021MS00(this.getConnection());        	
        		tablaBDMunicipioUsuario.setQ022FT00_IDUSUARIO_WHERE(Integer.parseInt(idUsuario));        		
        		if (tr.isTraceActive()){
         			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerMunicipiosUsuario: WHERE "+ idUsuario.toString() );     			
         		}
        		rs = tablaBDMunicipioUsuario.select();     		
                  
        		tablaBDMunicipioUsuario.addResultSet(rs);
        		while (rs.next()){
        			//listaMunicipios.add(rs.getString(Q02aTablaBDQ021MS00.NOMCOLUMN_FCA02T00_CODMUNICIP));   
        			Q02aProvMuni provmuni = new Q02aProvMuni();
        			provmuni.setNiProvincia (rs.getString(Q02aTablaBDQ021MS00.NOMCOLUMN_FCA02T00_CODPROVINC));
        			provmuni.setNiMunicipio(rs.getString(Q02aTablaBDQ021MS00.NOMCOLUMN_FCA02T00_CODMUNICIP)); 
            		//si el registro no tiene municipio, le ponemos un 0 para saber que significa "Todos los municipios"
            		/*if (Q02aFormatData.esVacio(plazo.getMunicipio())){
        	    		plazo.setMunicipio("0");
        	    	};*/        			
        			
        			listaProvMuni.add(provmuni);
        		}        		
        		return listaProvMuni;       		
        		
        	}catch(Exception ex){
                java.io.StringWriter sw = new java.io.StringWriter();
                java.io.PrintWriter pw = new java.io.PrintWriter(sw);  
                ex.printStackTrace(pw);
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerMunicipiosUsuario: " + sw.getBuffer ().toString());
                throw ex;
       	 	}finally{
       	 		try{
       	 		tablaBDMunicipioUsuario.freeResourcesNotConnection();	
       	 		}catch(Exception ex){
       	 			if (tr.isTraceActive()){
       	 				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerMunicipiosUsuario: error liberando recursos");
       	 			}  
       	 		}  		
       	 		if (tr.isTraceActive()){
       	 			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerMunicipiosUsuario: saliendo");                
       	 		}           
       	 	}      	
        }  	
        
        /**
         * Mtodo que obtiene al grupo que pertenece el usuario si pertenece a alguno.
         * @param idUsuario id de usuario.
         * @return idgrupo del usuario.
         * @throws Exception Exception
         */
        public String usuarioGrupo (String idUsuario) throws Exception {
            
            ResultSet rs = null;
            PreparedStatement prepStmt =null;   
            StringBuffer query = null;
            String esAdmin = "";
               
            try{
                
                query = new StringBuffer("SELECT Q021HT00_NI FROM Q021JS00 WHERE");
                query.append(" Q022FT00_NI=").append(idUsuario);  

                prepStmt = this.getConnection().prepareStatement(query.toString());
                rs = prepStmt.executeQuery(); 
                
                if (rs.next()) {
                    esAdmin = rs.getString(1).toString();
                }
                
                if (tr.isTraceActive()){
                    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":usuarioGrupo: esAdmin: " + esAdmin);                
                }
                
                return esAdmin;
                
            }catch(Exception ex){
                java.io.StringWriter sw = new java.io.StringWriter();
                java.io.PrintWriter pw = new java.io.PrintWriter(sw);  
                ex.printStackTrace(pw);
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":usuarioGrupo catch: " + sw.getBuffer ().toString());
                throw ex;
            }finally{
                if (tr.isTraceActive()){
                    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":usuarioGrupo: saliendo");                
                }        
            }       
        } 
        
        /**
         * Mtodo que obtiene al grupo que pertenece el usuario si pertenece a alguno.
         * @param idUsuario id de usuario.
         * @return idgrupo del usuario.
         * @throws Exception Exception
         */
        public String grupoAdministrador (String codADMConst) throws Exception {
            
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":grupoAdministrador: entrando");                
            }   
            ResultSet rs = null;
            PreparedStatement prepStmt =null;   
            StringBuffer query = null;
            String esAdmin = "";
               
            try{
                
                query = new StringBuffer("SELECT Q021HT00_NI,Q021HT00_COD FROM Q021HS00 WHERE");
                query.append(" Q021HT00_COD='").append(codADMConst).append("'");  
                
                prepStmt = this.getConnection().prepareStatement(query.toString());
                rs = prepStmt.executeQuery(); 
                
                if (rs.next()) {
                    esAdmin = rs.getString(1).toString();
                }
                
                if (tr.isTraceActive()){
                    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":grupoAdministrador: esAdmin: " + esAdmin);                
                }
                return esAdmin;
                
            }catch(Exception ex){
                java.io.StringWriter sw = new java.io.StringWriter();
                java.io.PrintWriter pw = new java.io.PrintWriter(sw);  
                ex.printStackTrace(pw);
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":grupoAdministrador catch: " + sw.getBuffer ().toString());
                throw ex;
            }finally{
                if (tr.isTraceActive()){
                    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":grupoAdministrador: saliendo");                
                }        
            }       
        } 
        
}