package q02a.exe.reports.beans;

import java.io.ByteArrayOutputStream;

import q02a.exe.arquitectura.beans.Q02aBaseBean;
import q02a.exe.reports.dataobjects.Q02aInformesDataBaseDAO;
import q02a.exe.reports.valueobjects.Q02aColumnas;
import q02a.exe.reports.valueobjects.Q02aParametrizacion;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;


/** 
 * Q02aInformesBean es un Bean que gestiona el acceso 
 * al DAO de Informes.
 * @author asdf
 */

public class Q02aInformesBean extends Q02aBaseBean {
	
	private static final long serialVersionUID = -4018422300357977737L;
	private static Q70Traza tr = Q70Traza.getSingleton();
	protected Q02aInformesDataBaseDAO dao = null;
	
	/**
	 * Constructor
	 */
	public Q02aInformesBean() {
		super();                
	}
	
	/**
	 * Metodo que se invoca para obtener los datos de parametrizacion relativos 
	 * a un Informe
	 * @param niParametrizacion  - niParametrizacion
	 * @return ValueObject de Q02aParametrizacion
	 * @throws Exception Exception
	 */
	public Q02aParametrizacion obtenerParametrizacion(String niParametrizacion) throws Exception {

		final String TRACE_METODO 	= "Q02aInformesBean:obtenerParametrizacion";

		Q02aParametrizacion param 	= null;

		boolean error 				= false;

		

		if (tr.isTraceActive()){

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": entrando");

		}

		try {
			//Se abre la conexion
			abrirConexion();
			//Se instancia el dao pasandole la conexion			
			dao = new Q02aInformesDataBaseDAO(this.getConn());
			//Se pasan los parametros de usuario e idioma
			dao.setUser(this.autenticador.getUser()); 
			dao.setIdioma(this.autenticador.getIdioma());
			//Se llama al dao para obtener los valores de parametrizacin del Informe 
			param = dao.obtenerParametrizacion(niParametrizacion);
			
			return param;
		} catch(Exception ex) {
			error = true;
			java.io.StringWriter sw = new java.io.StringWriter();
			java.io.PrintWriter pw = new java.io.PrintWriter(sw);
			ex.printStackTrace(pw);
			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, TRACE_METODO + ": " + sw.getBuffer ().toString());
			throw ex;
		} finally {
			try {
				dao.freeResourcesNotConnection();	
			} catch(Exception ex) {
				if (tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, TRACE_METODO + ": error liberando recursos");
				}  
			}  		
			//se cierra la conexin  
			cerrarConexion(error);	 
			if (tr.isTraceActive()) {
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": saliendo");                
			}   
		}
	}

	/**
     * 
     * @param nombreTabla nombreTabla
     * @return columnas
     * @throws Exception Exception
	 */
	public Q02aColumnas obtenerColumnasTabla(String nombreTabla) throws Exception {

		final String TRACE_METODO 	= "Q02aInformesBean:obtenerColumnasTabla";
		boolean error 				= false;
		Q02aColumnas columnas  		= null;
		
		if (tr.isTraceActive()){
			tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": entrando");
		}
		try {
			//Se abre la conexion
			abrirConexion();
			//Se instancia el dao pasandole la conexion			
			dao = new Q02aInformesDataBaseDAO(this.getConn());
			//Se pasan los parametros de usuario e idioma
			dao.setUser(this.autenticador.getUser());
			dao.setIdioma(this.autenticador.getIdioma());
			//Se llama al dao para obtener los valores de parametrizacin del Informe 
			columnas = dao.obtenerColumnasTabla(nombreTabla);
			
			return columnas;
		} catch(Exception ex) {
			error = true;
			java.io.StringWriter sw = new java.io.StringWriter();
			java.io.PrintWriter pw = new java.io.PrintWriter(sw);
			ex.printStackTrace(pw);
			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, TRACE_METODO + ": " + sw.getBuffer ().toString());
			throw ex;
		} finally {
			try {
				dao.freeResourcesNotConnection();	
			} catch(Exception ex) {
				if (tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, TRACE_METODO + ": error liberando recursos");
				}  
			}  		
			//se cierra la conexin  
			cerrarConexion(error);	 
			if (tr.isTraceActive()) {
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": saliendo");                
			}   
		}
	}
	
	
	/**
	 * Metodo que se invoca para obtener los datos de un Informe
	 * @param parametrizacion Q02aParametrizacion - datos de parametrizacion del informe
     * @param columnas columnas
	 * @return ByteArrayOutputStream
	 * @throws Exception Exception
	 */
	public ByteArrayOutputStream obtenerDatosInforme(Q02aParametrizacion parametrizacion, Q02aColumnas columnas) throws Exception {
		final String TRACE_METODO 		= "Q02aInformesBean:obtenerDatosInforme";
		boolean error 					= false;
		ByteArrayOutputStream outStr	= null;
		
		if (tr.isTraceActive()){
			tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": entrando");
		}
		try {
			//Se abre la conexion
			abrirConexion();
			//Se instancia el dao pasandole la conexion			
			dao = new Q02aInformesDataBaseDAO(this.getConn());
			//Se pasan los parametros de usuario e idioma
			dao.setUser(this.autenticador.getUser());
			dao.setIdioma(this.autenticador.getIdioma());
			//Se llama al dao para obtener los valores de parametrizacin del Informe 
			outStr = dao.obtenerDatosInforme(parametrizacion, columnas);
			
			return outStr;
		} catch(Exception ex) {
			error = true;
			java.io.StringWriter sw = new java.io.StringWriter();
			java.io.PrintWriter pw = new java.io.PrintWriter(sw);
			ex.printStackTrace(pw);
			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, TRACE_METODO + ": " + sw.getBuffer ().toString());
			throw ex;
		} finally {
			try {
				dao.freeResourcesNotConnection();	
			} catch(Exception ex) {
				if (tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, TRACE_METODO + ": error liberando recursos");
				}  
			}  		
			//se cierra la conexin  
			cerrarConexion(error);	 
			if (tr.isTraceActive()) {
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": saliendo");                
			}   
		}
	}


	/**
	 * Metodo que se invoca para generar un informe generico
	 * @param niParametrizacion String - niParametrizacion, datos de parametrizacion del informe
     * @param addWhere addWhere
	 * @return ByteArrayOutputStream
	 * @throws Exception Exception
	 */
	public ByteArrayOutputStream generarInformeGenerico(String niParametrizacion, String addWhere) throws Exception{
		final String TRACE_METODO 			= "Q02aInformesBean:generarInformeGenerico";
		Q02aParametrizacion parametrizacion = null;
		Q02aColumnas columnas 				= null;
		ByteArrayOutputStream outStr		= null;
		
		if (tr.isTraceActive()){
			tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": entrando");
		}
		try {
			//Metodos que componen los datos del informe
			parametrizacion = obtenerParametrizacion(niParametrizacion);
			//Aadimos la additional where
			parametrizacion.setAddWhere(addWhere);
			columnas = obtenerColumnasTabla(parametrizacion.getTabla());
			outStr = obtenerDatosInforme(parametrizacion, columnas);
									
			return outStr;
		} catch(Exception ex) {
			java.io.StringWriter sw = new java.io.StringWriter();
			java.io.PrintWriter pw = new java.io.PrintWriter(sw);
			ex.printStackTrace(pw);
			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, TRACE_METODO + ": " + sw.getBuffer ().toString());
			throw ex;
		}    					
	}
	
}