package q02a.exe.informantes.dataobjects;

import java.sql.Connection;
import java.sql.ResultSet;

import q02a.exe.arquitectura.dataobjects.Q02aDataBaseDAO;
import q02a.exe.informantes.valueobjects.Q02aInformante;
import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022IS01V01;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;

/**
 * 
 * @author GADIMAAR
 *
 */
public class Q02aInformantesDataBaseDAO extends Q02aDataBaseDAO{

	private static final long serialVersionUID = -8520551641771839103L;
	private static Q70Traza tr = Q70Traza.getSingleton();
	private static final String COMPONENTE = "DAO_ACCESO_DATOS";
	
    /**
     * 
     *
     */
	public Q02aInformantesDataBaseDAO() {
        super();                
    }

    /**
     * 
     * @param conn conn
     */
    public Q02aInformantesDataBaseDAO(Connection conn) {
    	super(conn);     
    }
       
   /**
     * Mtodo que devuelve un objeto informante resultado de la consulta a bbdd
     * @param  idInformante - String nmero interno del informante
     * @return informanteVO - Q02aInformante Valueobject de informante con los datos del informante obtenido
     * @throws Exception Exception
     */
   	public Q02aInformante getInformante(String idInformante) throws Exception {		
 		//se instancian los objetos necesarios para realizar la consulta.			
   		Q02aTablaBDQ022IS01V01 tabla022IS01V01 = null;
 		ResultSet rs = null;
 		Q02aInformante informanteVO=null;
 		
 		try{
 	    	if (tr.isTraceActive()){
 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":Q02aInformante: entrando");
 			}

            //se instancia la clase del tablas bd a llamar pasandole la conexion
 	    	//se realiza la select
 	    	tabla022IS01V01 = new Q02aTablaBDQ022IS01V01(this.getConnection());
 	    	tabla022IS01V01.setQ022IT00_ID_INF_WHERE(Integer.parseInt(idInformante));
 	    	rs = tabla022IS01V01.select();
 	    	//aadimos el cursos para luego poder liberarlo ( en el freeResources)
 	    	tabla022IS01V01.addResultSet(rs); 
 	    	//se trata el resultado obtenido 
 	    	informanteVO= new Q02aInformante();
 	    	if(rs.next()){
 	    		this.rellenarVOInformante(informanteVO, rs);
            }
 	    	return informanteVO;    	
 		}catch(Exception ex){ 	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":Q02aInformante: " + sw.getBuffer ().toString());
     		throw ex;
 		}finally{
 		 	try{
 		 		//liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet
 		 		tabla022IS01V01.freeResourcesNotConnection();	
 			 }catch(Exception ex){
 			    if (tr.isTraceActive()){
 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":Q02aInformante: error liberando recursos.");
 	   	   	    }  
 			 }  		 			
 			 if (tr.isTraceActive()){
 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":Q02aInformante: saliendo.");                
 	         }   
 		}	
 	}
      		    
	    
	    /**
	     * Mtodo que informa un valueobject de informante con los datos de informante obtenidos de la tabla de informantes
	     * @param informanteVO - Q02aInformante valueobject de informante que se va a informar
	     * @param rs - ResultSet Resultado de la consulta a bbdd
	     * @throws Exception
	     */
        private void rellenarVOInformante (Q02aInformante informanteVO, ResultSet rs) throws Exception
	    {
           	try{
			   	tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":rellenarVOUsuario: Hay Datos");
			   	
			   	String idiomaEs=q02a.exe.utils.Q02aConstantes.getString("idioma.es");
			   	
			   	informanteVO.setIdInformante(rs.getString(Q02aTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_ID_INF));
			   	informanteVO.setIdOficina(rs.getString(Q02aTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_ID_OFI));
			   	informanteVO.setNombre(rs.getString(Q02aTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_NOMB));
			   	informanteVO.setApellido1(rs.getString(Q02aTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_APE1));
			   	informanteVO.setApellido2(rs.getString(Q02aTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_APE2));
			   	informanteVO.setTelefono1(rs.getString(Q02aTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_TELF1));
			   	informanteVO.setTelefono2(rs.getString(Q02aTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_TELF2));
			   	informanteVO.setFax(rs.getString(Q02aTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_FAX));
			   	informanteVO.setEmail(rs.getString(Q02aTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_EMAIL));
			   	informanteVO.setCargo(rs.getString(Q02aTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_CARGO));
			   	informanteVO.setDepartamento(rs.getString(Q02aTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_DEPA));
			   	informanteVO.setFirma(rs.getString(Q02aTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_FELEC));
			   	informanteVO.setPrincipal(rs.getString(Q02aTablaBDQ022IS01V01.NOMCOLUMN_Q022IT00_PRINCPL));
			   	informanteVO.setDescProvincia(rs.getString(Q02aTablaBDQ022IS01V01.NOMCOLUMN_Q022HT00_PROV));
			   	informanteVO.setDescMunicipio(rs.getString(Q02aTablaBDQ022IS01V01.NOMCOLUMN_Q022HT00_MUNI));
			   	if(this.getIdioma().equals(idiomaEs)){
			   		informanteVO.setDescOficina(rs.getString(Q02aTablaBDQ022IS01V01.NOMCOLUMN_Q022HT00_DESC));
                }else{
                    informanteVO.setDescOficina(rs.getString(Q02aTablaBDQ022IS01V01.NOMCOLUMN_Q022HT00_DESC_EUS));
                }
			   	
			}
			catch (Exception e) {
			    if (tr.isTraceActive()){
			   	   	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenarVOUsuario: error "+ e.getMessage());
				}  
		    }  	
	    }
  
}
