package q02a.exe.cuestionariosVTMAnu.dataobjects;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;

import org.apache.commons.lang.StringUtils;

import q02a.exe.arquitectura.dataobjects.Q02aDAOException;
import q02a.exe.arquitectura.dataobjects.Q02aDataBaseDAO;
import q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMAnu;
import q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMAnuFiltro;
import q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMFiltro;
import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022BS00;
import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022CS00;
import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022DS00;
import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022DS01V02;
import q02a.exe.utils.Q02aConstantes;
import q02a.exe.utils.Q02aFormatData;
import q02a.exe.utils.oracle.Q02aBDUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;

/**
 * 
 * @author GADIMAAR
 *
 */
public class Q02aCuestionariosVTMAnuDataBaseDAO extends Q02aDataBaseDAO{
	private static final long serialVersionUID = -8520551641771839103L;
	private static Q70Traza tr = Q70Traza.getSingleton();
	private static final String COMPONENTE = "DAO_ACCESO_DATOS";
	private static final String RECURSOS_CUES_AYUN_MEN = "q02arecursosCuestionarios";

    /**
     * 
     *
     */
	public Q02aCuestionariosVTMAnuDataBaseDAO() {
        super();                
    }

    /**
     * 
     * @param conn conn
     */
    public Q02aCuestionariosVTMAnuDataBaseDAO(Connection conn) {
    	super(conn);     
    }
    /**
     * 
     * @param cuestionarioVTMAnu cuestionarioVTMAnu
     */
    public void cambiarComa(Q02aCuestionarioVTMAnu cuestionarioVTMAnu)
    {
    	
		if (cuestionarioVTMAnu.getPresupuesto()!=null){
			cuestionarioVTMAnu.setPresupuesto(cuestionarioVTMAnu.getPresupuesto().replace(',','.'));
        }
        if (cuestionarioVTMAnu.getPrecioMed()!=null){
			cuestionarioVTMAnu.setPrecioMed(cuestionarioVTMAnu.getPrecioMed().replace(',','.'));
        }
    }

    /**
     * 
     * @param cuestionarioVTMAnu cuestionarioVTMAnu
     */
    public void cambiarPunto(Q02aCuestionarioVTMAnu cuestionarioVTMAnu)
    {
    	if (cuestionarioVTMAnu.getPresupuesto()!=null){
			cuestionarioVTMAnu.setPresupuesto(cuestionarioVTMAnu.getPresupuesto().replace('.',','));
        }
    	
    	if (cuestionarioVTMAnu.getPrecioMed()!=null){
			cuestionarioVTMAnu.setPrecioMed(cuestionarioVTMAnu.getPrecioMed().replace('.',','));
        }
    }
    

     /**
     * Mtodo que compone la where para hacer la consulta
     * @param 
     * @return where 
     * @throws Exception
     */

    /*public String componerFiltroCuestionarioVTMAnu() throws Exception {

    	StringBuffer where = new StringBuffer();

    	try{

    		if (tr.isTraceActive())

    		{

		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":componerFiltroCuestionarioVTMAnu: entrando");                

		} 

	    	where.append(Q02aTablaBDQ022DS00.NOMCOLUMN_Q022DT00_ID_CUES + " is not null" );    	

    		return where.toString();

    	}catch(Exception ex){    	 	   

	       java.io.StringWriter sw = new java.io.StringWriter();

	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	       ex.printStackTrace(pw);

	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":componerFiltroCuestionarioVTMAnu: " + sw.getBuffer ().toString());

	       throw ex;

		}finally{			 	

			if (tr.isTraceActive()){

		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":componerFiltroCuestionarioVTMAnu: saliendo");                

		    }    				

		}

    }*/

    
    /**
     * @param rs rs
     * @throws Exception Exception
     * @return listaCuestionariosVTM
     */
    private ArrayList rellenaVOsCuestionariosVTM ( ResultSet rs ) throws Exception{

    	Q02aCuestionarioVTMAnu cuestionarioVTM;

    	ArrayList listaCuestionariosVTM = new ArrayList();

    	try{
    		if (tr.isTraceActive()){
		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOsCuestionariosVTM: entrando");                
		    } 

    		while (rs.next()){	 
	        	//se cargan en el objeto cuestionario los datos recuperados
    			cuestionarioVTM = new Q02aCuestionarioVTMAnu();
    			rellenarVOCuestionarioVTMAnu(cuestionarioVTM,rs);
    			listaCuestionariosVTM.add(cuestionarioVTM);
			}  	  

    		return listaCuestionariosVTM;

    	}catch(Exception ex){    	 	   
 	       java.io.StringWriter sw = new java.io.StringWriter();
 	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);
 	       ex.printStackTrace(pw);
 	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaVOsCuestionariosVTM: " + sw.getBuffer ().toString());
 	       throw ex;
 		}finally{			 	
 			if (tr.isTraceActive()){
 		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOsCuestionariosVTM: saliendo");                
 		    }    				
 		}

    } 
    
    /**
     * Funcin que inserta los datos del cuestionarioVTMAnu pasada como parmetro en la BBDD
     * 
     * @param cuestionarioVTMAnu - Datos de la cuestionarioVTMAnu a insertar
     * @param tablaBDCuestionariosVTMAnu - tablaBDCuestionariosVTMAnu
     * @throws Exception Exception
     */
    public void rellenaDatosCuestionarioVTMAnu( Q02aCuestionarioVTMAnu cuestionarioVTMAnu, Q02aTablaBDQ022DS00 tablaBDCuestionariosVTMAnu) throws Exception {

    	//se definen objetos necesarios.
    	try{
	    	if (tr.isTraceActive()){
	    	    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosCuestionarioVTMAnu: entrando");
	    	}         	         
     		//se aaden los datos
	    	tablaBDCuestionariosVTMAnu.setQ022BT00_ID_GRUPO(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnu.getNiGrupoCuesVTMAnu()));
	    	tablaBDCuestionariosVTMAnu.setQ022DT00_ID_CUES(Q02aFormatData.checkLongNull(cuestionarioVTMAnu.getNiCuesVTMAnu()));
	    	tablaBDCuestionariosVTMAnu.setQ022DT00_IDEN_LICEN(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getIdenLicen()));
	    	tablaBDCuestionariosVTMAnu.setQ022DT00_FEC_ENT(Q02aFormatData.parseDate(cuestionarioVTMAnu.getFecEnt()));
	    	tablaBDCuestionariosVTMAnu.setQ022DT00_ESTADO_LICEN(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getEstadoLicen()));
	    	tablaBDCuestionariosVTMAnu.setQ022DT00_CAUSA_BAJA(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getCausaBaja()));
	    	tablaBDCuestionariosVTMAnu.setQ022DT00_ENTI(Q02aFormatData.checkLongNull(cuestionarioVTMAnu.getEnti()));
	    	tablaBDCuestionariosVTMAnu.setQ022DT00_TVIA(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getTvia()));
	    	tablaBDCuestionariosVTMAnu.setQ022DT00_CALLE(Q02aFormatData.checkLongNull(cuestionarioVTMAnu.getCalle()));
	    	tablaBDCuestionariosVTMAnu.setQ022DT00_POR_CL_POR(Q02aFormatData.checkLongNull(cuestionarioVTMAnu.getPorClPor()));
	    	
	    	tablaBDCuestionariosVTMAnu.setQ022DT00_BLOQ(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getBloq()));	    	
	    	tablaBDCuestionariosVTMAnu.setQ022DT00_NUME(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnu.getNume()));
	    	tablaBDCuestionariosVTMAnu.setQ022DT00_BIS(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getBis()));
	    	tablaBDCuestionariosVTMAnu.setQ022DT00_CDIR(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getCdir()));
	    	tablaBDCuestionariosVTMAnu.setQ022DT00_DIR_NUEVA(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getDirNueva()));
	    	
	    	tablaBDCuestionariosVTMAnu.setQ022DT00_RS_PROMO(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getRsPromo()));
	    	tablaBDCuestionariosVTMAnu.setQ022DT00_CIF_DNI(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getCifDni()));
	    	tablaBDCuestionariosVTMAnu.setQ022DT00_MUN_PROV(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getMunProv()));
	    	tablaBDCuestionariosVTMAnu.setQ022DT00_MUN_MUNI(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getMunMuni()));
	    	tablaBDCuestionariosVTMAnu.setQ022DT00_ENTI_PRO(Q02aFormatData.checkLongNull(cuestionarioVTMAnu.getEntiPro()));
			//tablaBDCuestionariosVTMAnu.setQ022DT00_FIRMADO((Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getFirmado()))==null?new Integer("0"):new Integer(cuestionarioVTMAnu.getFirmado()));

	    	//comprobar regimen uso y guardarlo si es otro
			/*if (!cuestionarioVTMAnu.getRegUso().equals("")){
				if ((Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getRegUso()).equals(Q02aConstantes.getString("q02a.cuestionarios.VTMAnu.regOtro")))){
					tablaBDCuestionariosVTMAnu.setQ022DT00_OTRO_REGIMEN_USO(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getOtroRegUso()));
				}else{
					tablaBDCuestionariosVTMAnu.setQ022DT00_OTRO_REGIMEN_USO(Q02aFormatData.checkStringNull(""));
				}
			}*/
			tablaBDCuestionariosVTMAnu.setQ022DT00_TVIA_PRO(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getTviaPro()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_CALLE_PRO(Q02aFormatData.checkLongNull(cuestionarioVTMAnu.getCallePro()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_POR_CL_POR_PRO(Q02aFormatData.checkLongNull(cuestionarioVTMAnu.getPorClPorPro()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_BLOQ_PRO(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getBloqPro()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_NUME_PRO(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnu.getNumePro()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_BIS_PRO(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getBisPro()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_CDIR_PRO(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getCdirPro()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_DIR_PRO_EXTERNO(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getDirExternaPro()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_TLF(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getTlf()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_MAIL(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getMail()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_FAX(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getFax()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_WEB(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getWeb()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_PRESUPUESTO(Q02aFormatData.checkDoubleNull(cuestionarioVTMAnu.getPresupuesto()));
			
            tablaBDCuestionariosVTMAnu.setQ022DT00_F_INI(Q02aFormatData.parseDate(cuestionarioVTMAnu.getFIni()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_F_FIN(Q02aFormatData.parseDate(cuestionarioVTMAnu.getFFin()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_TIPO_OBRA(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getTipoObra()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_USO_RES(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getUsoRes()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_ACTIVIDAD(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getActividad()));
			
            tablaBDCuestionariosVTMAnu.setQ022DT00_NVN(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnu.getNvn()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_NVR(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnu.getNvr()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_NVL(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnu.getNvl()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_NVVPO(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnu.getNvvpo()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_NVVS(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnu.getNvvs()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_NVPOT(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnu.getNvpot()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_NVALDOT(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnu.getNvaldot()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_NVREAL(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnu.getNvreal()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_NVVTMG(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnu.getNvvtmg()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_NVVTME(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnu.getNvvtme()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_NTOT(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnu.getNtot()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_NSP45(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnu.getNsp45()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_NSP75(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnu.getNsp75()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_NSP90(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnu.getNsp90()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_NSP120(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnu.getNsp120()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_NSPT(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnu.getNspt()));
			
            tablaBDCuestionariosVTMAnu.setQ022DT00_PRINC_USO(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getPrincUso()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_PU_ESPECIF(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getPuEspecif()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_PRECIO_MED(Q02aFormatData.checkDoubleNull(cuestionarioVTMAnu.getPrecioMed()));
			tablaBDCuestionariosVTMAnu.setQ022DT00_OBS(Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getObs()));
            tablaBDCuestionariosVTMAnu.setQ022DT00_NUMVIVFINALES( Q02aFormatData.checkIntegerNull( cuestionarioVTMAnu.getNumVivFinales() ) );
            tablaBDCuestionariosVTMAnu.setQ022DT00_INDNUEPLREHAB( Q02aFormatData.checkIntegerNull( cuestionarioVTMAnu.getIndNuePlRehab() ) );
            tablaBDCuestionariosVTMAnu.setQ022DT00_INDREHABNUMVIV( Q02aFormatData.checkIntegerNull( cuestionarioVTMAnu.getIndRehabNumViv() ) );
            tablaBDCuestionariosVTMAnu.setQ022DT00_FUERA_PLAZO( Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getFueraPlazo()) );
            tablaBDCuestionariosVTMAnu.setQ022DT00_CODIGO_LICEN( Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getCodigoLicencia()) );
            
            if ( cuestionarioVTMAnu.getUsuAlta() != null && !"".equals(cuestionarioVTMAnu.getUsuAlta()))
                tablaBDCuestionariosVTMAnu.setQ022DT00_USU_ALTA( Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getUsuAlta()) );
            if ( cuestionarioVTMAnu.getUsuModif() != null && !"".equals(cuestionarioVTMAnu.getUsuModif()))
                tablaBDCuestionariosVTMAnu.setQ022DT00_USU_MODIF( Q02aFormatData.checkStringNull(cuestionarioVTMAnu.getUsuModif()) );

			String coodX = "";
 	    	String coodY = "";

 	    	if (cuestionarioVTMAnu.getCoordenadaX()!=null){
 	    		coodX = cuestionarioVTMAnu.getCoordenadaX().toString();
 	    	}

 	    	if (cuestionarioVTMAnu.getCoordenadaY()!=null){
 	    		coodY = cuestionarioVTMAnu.getCoordenadaY().toString();
 	    	}

 	    	tablaBDCuestionariosVTMAnu.setQ022DT00_DX(Q02aFormatData.checkDoubleNull(coodX));
 	    	tablaBDCuestionariosVTMAnu.setQ022DT00_DY(Q02aFormatData.checkDoubleNull(coodY));

 	    	String coodXPro = "";
 	    	String coodYPro = "";

 	    	if (cuestionarioVTMAnu.getCoordenadaXPro()!=null){
 	    		coodXPro = cuestionarioVTMAnu.getCoordenadaXPro().toString();
 	    	}

 	    	if (cuestionarioVTMAnu.getCoordenadaYPro()!=null){
 	    		coodYPro = cuestionarioVTMAnu.getCoordenadaYPro().toString();
 	    	}

 	    	tablaBDCuestionariosVTMAnu.setQ022DT00_DX_PRO(Q02aFormatData.checkDoubleNull(coodXPro));
 	    	tablaBDCuestionariosVTMAnu.setQ022DT00_DY_PRO(Q02aFormatData.checkDoubleNull(coodYPro));

    	}catch(Exception ex){   	   
    		java.io.StringWriter sw = new java.io.StringWriter();
    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
    		ex.printStackTrace(pw);
    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaDatosCuestionarioVTMAnu: " + sw.getBuffer ().toString());

    		throw ex;
    	}finally{    		
			if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosCuestionarioVTMAnu: saliendo");                
           }       	
    	}	

    }  

    
    
    /**
     * 
     * @param niGrupoCuesVTM niGrupoCuesVTM
     * @return listaCuestionariosVTM
     * @throws Exception Exception
     */
	public ArrayList getSelectCuestionariosVTM(String niGrupoCuesVTM) throws Exception {		

		//se instancian los objetos necesarios para realizar la consulta.			
		Q02aTablaBDQ022DS01V02 vistaBDCuestionariosVTM = null;
		ResultSet rs = null;
		ArrayList listaCuestionariosVTM = new ArrayList();
		Q02aCuestionarioVTMAnu cuestionarioVTM;

        try{
	    	if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getSelectCuestionariosVTMAnu: entrando");
		}

	    	//se instancia la clase del tablas bd a llamar pasandole la conexion	    	
	    	vistaBDCuestionariosVTM = new Q02aTablaBDQ022DS01V02(this.getConnection());

            //rellenamos la where con los datos del filtro de usuarioTODO
	    	this.rellenaFiltroCuestionarioVTM(niGrupoCuesVTM, vistaBDCuestionariosVTM);	    	    	
	    	
	    	//se realiza la select
	    	rs = vistaBDCuestionariosVTM.select();
	    	
	    	//aadimos el cursos para luego poder liberarlo ( en el freeResources)
	    	vistaBDCuestionariosVTM.addResultSet(rs); 

	    	//se trata el resultado obtenido aadiendolo a la lista de salida
	    	listaCuestionariosVTM = this.rellenaVOsCuestionariosVTM(rs);
	    	for (int i=0; i < listaCuestionariosVTM.size(); i++)
	    	{
	    		cuestionarioVTM = (Q02aCuestionarioVTMAnu)listaCuestionariosVTM.get(i);	    			    		
    			this.cambiarPunto(cuestionarioVTM);	    			
    			listaCuestionariosVTM.set(i,cuestionarioVTM);	    		
	    	}

	    	return listaCuestionariosVTM;    	

		}catch(Exception ex){ 	   

    		java.io.StringWriter sw = new java.io.StringWriter();
    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
    		ex.printStackTrace(pw);
    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getSelectCuestionariosVTMAnu: " + sw.getBuffer ().toString());
    		throw ex;
		}finally{
		 	try{
		 		//liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet
		 		vistaBDCuestionariosVTM.freeResourcesNotConnection();	
			}catch(Exception ex){
			    if (tr.isTraceActive()) {
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getSelectCuestionariosVTMAnu: error liberando recursos.");
	   	   	    }  
			}  		 			
			 if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getSelectCuestionariosVTMAnu: saliendo.");                
	         }   
		}	
	}
    
	/**
     * Mtodo que devuelve el nmero de registros de la BBDD de cuestionarios
     * 
     * @param niGrupoCuesVTMAnu niGrupoCuesVTMAnu
     * @return devuelve nmero de registros de la BBDD de cuestionarios
     * 
     * @throws Exception Exception
     */

    public int getCountCuestionariosVTM(String niGrupoCuesVTMAnu) throws Exception {    	    
    	//se crean las objetos necesarios.
    	int numReg = 0;
    	ResultSet rs = null;       
    	Q02aTablaBDQ022DS01V02 vistaBDCuestionariosVTM = null;	
        try{
        	if (tr.isTraceActive()){
    			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCountCuestionariosVTM: entrando");
    		}
        	//se instancia la clase del tablas bd a llamar pasandole la conexion        	
        	vistaBDCuestionariosVTM = new Q02aTablaBDQ022DS01V02(this.getConnection());
                     //segmento tecnico
        	//tablaBDCuestionariosVTMAnu.setUser(this.getUser());
        	
        	//se carga el filtro de la where con los datos de entrada.TODO
        	this.rellenaFiltroCuestionarioVTM(niGrupoCuesVTMAnu,vistaBDCuestionariosVTM);        	
        	//se realiza la cout
        	rs = vistaBDCuestionariosVTM.selectCount();       	
        	
        	vistaBDCuestionariosVTM.addResultSet(rs);
        	//se recupera el resultado
        	if (rs.next()){          		 
        	 	 numReg =  rs.getInt(1);
        	}
        	return numReg;
        }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCountCuestionariosVTM: " + sw.getBuffer ().toString());
            throw ex;
       }finally{
    	   try{
    		   vistaBDCuestionariosVTM.freeResourcesNotConnection();	
    	   }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCountCuestionariosVTM: error liberando recursos");
	   	   	   }  
		   }  		
    	   if (tr.isTraceActive()){
    		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCountCuestionariosVTM: saliendo");                
           }           
       }      
    }//fin getCountCuestionariosVTM()

    

    /**
	      * Mtodo que rellena el tablasBD con los datos del filtro de objeto que contiene
	      * el ni del objeto y el tipo de objeto
	      * 
	      * @param niGrupoCuesVTM niGrupoCuesVTM
	      * @param tablaBD tablaBD
	      * 
	      * @throws Exception Exception
	      */

	    public void rellenaFiltroCuestionarioVTM(String niGrupoCuesVTM,Q02aTablaBDQ022DS01V02 tablaBD)throws Exception
	    {
	     //Definicin de variables que no se van a modificar
	     final String TRACE_METODO = ":rellenaFiltroCuestionarioVTM:";
	    	try{
	    		if (tr.isTraceActive()){
			        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando");                
			} 
		    	/*if(cuestionarioVTMAnuFiltro!=null)
		    	{
		    		if (!Q02aFormatData.esVacio(cuestionarioVTMAnuFiltro.getCodProv())){
		    			tablaBD.setFCA02T00_CODPROVINC_WHERE(new Integer(cuestionarioVTMAnuFiltro.getCodProv()));
		    		}
		    		if (!Q02aFormatData.esVacio(cuestionarioVTMAnuFiltro.getCodMuni())){
		    			tablaBD.setFCA02T00_CODMUNICIP_WHERE(new Integer(cuestionarioVTMAnuFiltro.getCodMuni()));
		    		}
		    		if (!Q02aFormatData.esVacio(cuestionarioVTMAnuFiltro.getAno())){
		    			tablaBD.setQ022BT00_ANO_WHERE(new Integer(cuestionarioVTMAnuFiltro.getAno()));
		    		}*/
		    		if (!Q02aFormatData.esVacio(niGrupoCuesVTM)){
		    			tablaBD.setQ022BT00_ID_GRUPO_WHERE(new Integer(niGrupoCuesVTM));
		    		}	
		    		tablaBD.setOrderBy( "Q022DT00_ID_CUES DESC");
		    	//}	    	
	    	}catch(Exception ex)
	    	{    	 	   
		       java.io.StringWriter sw = new java.io.StringWriter();
		       java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);
		       ex.printStackTrace(pw);
		       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() 		+ TRACE_METODO + sw.getBuffer ().toString());
		       throw ex;
		}finally
		{			 	
			if (tr.isTraceActive())
			{
			        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() 	+ TRACE_METODO + " saliendo");                
			 }    				
		}
	    }//fin rellenaFiltroCuestionarioVTM()
    

      /**
      * Funcin que inserta los datos del cuestionario pasado como parmetro en la BBDD
      * 
      * @param cuestionarioVTMAnu - Datos de la cuestionario a insertar
      * @return NiCuesVTMAnu()
      * @throws Exception Exception
      */

     public String insertarCuestionarioVTMAnu(Q02aCuestionarioVTMAnu cuestionarioVTMAnu) throws Exception {
    	//se definen objetos necesarios.
    	int niCuestionarioVTMAnu=1;     	
       	Q02aTablaBDQ022DS00 tablaBDCuestionariosVTMAnu = null;

       	try{
	    	if (tr.isTraceActive()) {
	    	    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioVTMAnu: entrando");
	    	}

    		//se crea el objeto de tablasBD
	    	tablaBDCuestionariosVTMAnu = new Q02aTablaBDQ022DS00(this.getConnection());
	    	
	    	this.cambiarComa(cuestionarioVTMAnu);
      		//primero recuperamos el nmero interno de contacto que le corresponde

	    	//-------------------------------------------------------------------------------------------------------------------------------------
	    	   	niCuestionarioVTMAnu = dameMaxNiCuesDeGrupo(cuestionarioVTMAnu.getNiGrupoCuesVTMAnu(),tablaBDCuestionariosVTMAnu);
	         	cuestionarioVTMAnu.setNiCuesVTMAnu(Integer.toString(niCuestionarioVTMAnu));   
	         	//tablaBDCuestionariosVTMAnu.reset();	         
	         	//----------------------------------------------------------------------         	

      		//se aaden los datos a insertar
         		this.rellenaDatosCuestionarioVTMAnu(cuestionarioVTMAnu, tablaBDCuestionariosVTMAnu);         	         
      		//se realiza la insert

      		tablaBDCuestionariosVTMAnu.insert();

      		//pediente de recuperar el numContacto
      		return cuestionarioVTMAnu.getNiCuesVTMAnu();

     	}

     	catch(Exception ex){   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarCuestionarioVTMAnu: " + sw.getBuffer ().toString());
     		throw ex;
     	}

     	finally{
     		try{
     			tablaBDCuestionariosVTMAnu.freeResourcesNotConnection();	
     		}catch(Exception ex){
     			if (tr.isTraceActive()){
     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarCuestionarioVTMAnu: error liberando recursos");
 		   	    }  
     		}  		

    		if (tr.isTraceActive()){
    			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioVTMAnu: saliendo");                
        		}       	
         	}
     }     
     
     
     /**
      * Funcin que borra el cuestionarioVTMAnu pasado como parmetro de la BBDD
      * 
      * @param niCuestionarioVTMAnu - nmero interno del cuestionarioVTMAnu a borrar
      * @param niGrupoCuestionarioVTMAnu - niGrupoCuestionarioVTMAnu
      * @throws Exception Exception
      */

     public void borrarCuestionarioVTMAnu(String niCuestionarioVTMAnu,String niGrupoCuestionarioVTMAnu) throws Exception {
    	 
      	if (tr.isTraceActive())
      	{
  		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVTMAnu: entrando");
      	}
        
      	Q02aTablaBDQ022DS00 Q02aTablaBDQ022DS00obj = null;
        try{       	
        	//se crean los objetos necesarios
         	Q02aTablaBDQ022DS00obj = new Q02aTablaBDQ022DS00(this.getConnection());   
         	
        	// segmento tecnico
            //Q02aTablaBDQ022DS00obj.setUser(this.getUser());
         	
         	//se pone el filtro para la delete
         	Q02aTablaBDQ022DS00obj.setQ022DT00_ID_CUES_WHERE(Integer.parseInt(niCuestionarioVTMAnu));
         	Q02aTablaBDQ022DS00obj.setQ022BT00_ID_GRUPO_WHERE(Integer.parseInt(niGrupoCuestionarioVTMAnu));         	
         	
         	//se lanza el delete
          	Q02aTablaBDQ022DS00obj.delete();  
            
        }catch(Exception ex){
              java.io.StringWriter sw = new java.io.StringWriter();
              java.io.PrintWriter pw = new java.io.PrintWriter(sw);
              ex.printStackTrace(pw);
              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioVTMAnu: " + sw.getBuffer ().toString());
              throw ex;
         }finally{
         	try{
         	    Q02aTablaBDQ022DS00obj.freeResourcesNotConnection();	
         	}catch(Exception ex){
         		if (tr.isTraceActive()){
         			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioVTMAnu: error liberando recursos");
         		}  
         	}  		

          	if (tr.isTraceActive()){
          		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVTMAnu: saliendo");                
            }     	   
      }

     }//fin borrarCuestionarioVTMAnu

     

     
     /**
      * 
      * @param niGrupoCuestionarioVTMAnu niGrupoCuestionarioVTMAnu
      * @throws Exception Exception
      */
     public void borrarGrupoCuestionarioVTMAnu(String niGrupoCuestionarioVTMAnu) throws Exception {
      	if (tr.isTraceActive())	{
    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarGrupoCuestionarioVTMAnu: entrando");
        }
          	
        //se crean los objetos necesarios
       	Q02aTablaBDQ022BS00 Q02aTablaBDQ022BS00obj = null;       

         try{       	
           	 //se crea el objeto de tablasBD
           	 Q02aTablaBDQ022BS00obj = new Q02aTablaBDQ022BS00(this.getConnection());
           
           	 // segmento tecnico
           	 //Q02aTablaBDQ022BS00obj.setUser(this.getUser());    	
           	
           	 //se pone el filtro para la delete
           	 Q02aTablaBDQ022BS00obj.setQ022BT00_ID_GRUPO_WHERE(Integer.parseInt(niGrupoCuestionarioVTMAnu));
            	
           	 //se lanza al delete
            	 Q02aTablaBDQ022BS00obj.delete();         	
        }catch(Exception ex){
                java.io.StringWriter sw = new java.io.StringWriter();
                java.io.PrintWriter pw = new java.io.PrintWriter(sw);
                ex.printStackTrace(pw);
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarGrupoCuestionarioVTMAnu: " + sw.getBuffer ().toString());
                throw ex;
        }finally{
           	try	{
           		Q02aTablaBDQ022BS00obj.freeResourcesNotConnection();	
           	}catch(Exception ex){
           			if (tr.isTraceActive()){
           				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarGrupoCuestionarioVTMAnu: error liberando recursos");
           			}  
           	}  		
           	if (tr.isTraceActive()){
           			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarGrupoCuestionarioVTMAnu: saliendo");                
        	}     	   
         }

       }//fin borrarGrupoCuestionarioVTMAnu
     
     /**
      * resetear1, borra en Q02aTablaBDQ022BS00obj
      * 
      * @param idGrupo idGrupo
      * @throws Exception Exception
      */
    public void resetear1VTM(String idGrupo) throws Exception {        

        if (tr.isTraceActive()) {
            tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":resetear1VTM: entrando");
        }
        //se instancian los objetos necesarios para realizar la consulta.  
        Q02aTablaBDQ022BS00 Q02aTablaBDQ022BS00obj = null;
        
        try{        
             //se crea el objeto de tablasBD
             Q02aTablaBDQ022BS00obj = new Q02aTablaBDQ022BS00(this.getConnection());
              
             //se pone el filtro para la delete
             Q02aTablaBDQ022BS00obj.setQ022BT00_ID_GRUPO_WHERE( Integer.parseInt(idGrupo) );
            
             //se lanza al delete
             Q02aTablaBDQ022BS00obj.delete();   
             
       }catch(Exception ex){
               java.io.StringWriter sw = new java.io.StringWriter();
               java.io.PrintWriter pw = new java.io.PrintWriter(sw);
               ex.printStackTrace(pw);
               tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":resetear1VTM: " + sw.getBuffer ().toString());
               throw ex;
       }finally{
            try {
                Q02aTablaBDQ022BS00obj.freeResourcesNotConnection();    
            }catch(Exception ex){
                    if (tr.isTraceActive()){
                        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":resetear1VTM: error liberando recursos");
                    }  
            }       
            if (tr.isTraceActive()){
                    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":resetear1VTM: saliendo");                
            }          
        }
       
    }//resetearVTM
    
    /**
     * resetear2, borra en Q02aTablaBDQ022BS00obj
     * 
     * @param idGrupo idGrupo
     * @throws Exception Exception
     */
   public void resetear2VTM(String idGrupo) throws Exception { 
       
       if (tr.isTraceActive()) {
           tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":resetear2VTM: entrando");
       }
       //se instancian los objetos necesarios para realizar la consulta.  
       Q02aTablaBDQ022DS00 Q02aTablaBDQ022DS00obj = null;
       
       try{         
           //se crean los objetos necesarios
            Q02aTablaBDQ022DS00obj = new Q02aTablaBDQ022DS00(this.getConnection());   
            
            //se pone el filtro para la delete
            //Q02aTablaBDQ022DS00obj.setQ022DT00_ID_CUES_WHERE(Integer.parseInt(niCuestionarioVTMAnu));
            Q02aTablaBDQ022DS00obj.setQ022BT00_ID_GRUPO_WHERE(Integer.parseInt(idGrupo));             
            
            //se lanza el delete
            Q02aTablaBDQ022DS00obj.delete();  
           
       }catch(Exception ex){
              java.io.StringWriter sw = new java.io.StringWriter();
              java.io.PrintWriter pw = new java.io.PrintWriter(sw);
              ex.printStackTrace(pw);
              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":resetear2VTM: " + sw.getBuffer ().toString());
              throw ex;
      }finally{
           try {
               Q02aTablaBDQ022DS00obj.freeResourcesNotConnection();    
           }catch(Exception ex){
                   if (tr.isTraceActive()){
                       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":resetear2VTM: error liberando recursos");
                   }  
           }       
           if (tr.isTraceActive()){
                   tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":resetear2VTM: saliendo");                
           }          
       }
      
   }//resetear2VTM

     /**
      * Funcin que comprueba si un grupo de cuestionarios tiene cuestionariosVTMAnu asociados
      * 
      * @param niGrupoCuestionarioVTMAnu - nmero interno del grupo de cuestionarios a comprobar
      * @return true si tiene cuestionarios, false si no los tiene
      * @throws Exception Exception
      */

     public boolean tieneCuestionariosVTMAnu(String niGrupoCuestionarioVTMAnu) throws Exception {

      	if (tr.isTraceActive())

      	{

  		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":tieneCuestionariosVTMAnu: entrando");

      	}

        java.sql.ResultSet rs = null;

        boolean retorno = false;

      	//se crean los objetos necesarios

     	Q02aTablaBDQ022DS00 Q02aTablaBDQ022DS00obj = null;       

          try{       	        	  

         	 //se crea el objeto de tablasBD

        	  Q02aTablaBDQ022DS00obj = new Q02aTablaBDQ022DS00(this.getConnection());    

         	//se pone el filtro para la select

        	  Q02aTablaBDQ022DS00obj.setQ022BT00_ID_GRUPO_WHERE(Integer.parseInt(niGrupoCuestionarioVTMAnu));        	  

         	

         	//se lanza la select

         	rs=Q02aTablaBDQ022DS00obj.select();

         	if(rs.next()){         		

         		retorno=true;

         	}

         	return retorno;

         }

         catch(Exception ex)

         {

              java.io.StringWriter sw = new java.io.StringWriter();

              java.io.PrintWriter pw = new java.io.PrintWriter(sw);

              ex.printStackTrace(pw);

              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":tieneCuestionariosVTMAnu: " + sw.getBuffer ().toString());

              throw ex;

         }finally

         {

         	try{

         		Q02aTablaBDQ022DS00obj.freeResourcesNotConnection();	

     	}

     	catch(Exception ex)

     	{

     		if (tr.isTraceActive())

     		{

     			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":tieneCuestionariosVTMAnu: error liberando recursos");

     		}  

     	}  		

      	if (tr.isTraceActive())

      	{

      		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":tieneCuestionariosVTMAnu: saliendo");                

                     }     	   

         }

     }//fin tieneCuestionariosVTMAnu

     /**
      * Funcin que modifica los datos del cuestionarioVTMAnu pasado como parmetro en la BBDD
      * 
      * @param cuestionarioVTMAnu - Datos de cuestionarioVTMAnu a modificar
      * 
      * @throws Exception Exception
      */
     public void modificarCuestionarioVTMAnu(Q02aCuestionarioVTMAnu cuestionarioVTMAnu) throws Exception {
      	if (tr.isTraceActive()){
      	    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVTMAnu: entrando");
      	}
      	//Se isntancian los objetos necesarios.
      	Q02aTablaBDQ022DS00 Q02aTablaBDQ022DS00obj = null;    
         	 try {     
         	 	//se crea el objeto de tablasBD
        		Q02aTablaBDQ022DS00obj = new Q02aTablaBDQ022DS00(this.getConnection());
        		//segmento tecnico
             		//Q02aTablaBDQ022DS00obj.setUser(this.getUser());
        		this.cambiarComa(cuestionarioVTMAnu);
        		
        		rellenaDatosCuestionarioVTMAnu(cuestionarioVTMAnu,Q02aTablaBDQ022DS00obj);
        		Q02aTablaBDQ022DS00obj.setQ022DT00_ID_CUES_WHERE(Long.parseLong(cuestionarioVTMAnu.getNiCuesVTMAnu()));
        		Q02aTablaBDQ022DS00obj.setQ022BT00_ID_GRUPO_WHERE(Integer.parseInt(cuestionarioVTMAnu.getNiGrupoCuesVTMAnu()));
       		
       		//se realiza la update
       		Q02aTablaBDQ022DS00obj.update();
         }
         catch(Exception ex)
         {
              java.io.StringWriter sw = new java.io.StringWriter();
              java.io.PrintWriter pw = new java.io.PrintWriter(sw);
              ex.printStackTrace(pw);
              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVTMAnu: " + sw.getBuffer ().toString());
              //System.out.println( ":modificarCuestionarioVTMAnu: " + sw.getBuffer ().toString() );
              throw ex;
         }finally{     
         	try{
         	        Q02aTablaBDQ022DS00obj.freeResourcesNotConnection();	
        	}catch(Exception ex){
        		   if (tr.isTraceActive()){
        			   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVTMAnu: error liberando recursos");
           	   	   }  
        	}  		  
          	if (tr.isTraceActive()){
          		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVTMAnu: saliendo");                
            }             
         }     
     } // fin modificarCuestionarioVTMAnu

    
     /**
      * Mtodo que dado el nmero interno del cuestionarioVTMAnu recuperar de la BBDD
      * los datos de dicho cuestionarioVTMAnu.
      * @param niCuestionarioVTMAnu niCuestionarioVTMAnu
      * @param niGrupoCuestionarioVTMAnu niGrupoCuestionarioVTMAnu
      * @throws Exception Exception
      * @return cuestionarioVTMAnuBD
      */
     public Q02aCuestionarioVTMAnu obtenerCuestionarioVTMAnu(String niCuestionarioVTMAnu,String niGrupoCuestionarioVTMAnu)
     throws Exception
     {
   	  if (tr.isTraceActive()){
  		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVTMAnu , ** dao niCuestionarioVTMAnu= "+  niCuestionarioVTMAnu + ", niGrupoCuestionarioVTMAnu=" + niGrupoCuestionarioVTMAnu +"  ** entrando");            
         	}
   	  
   	  //se crean los objetos necesarios para ralizar la select.
   	  Q02aTablaBDQ022DS00 Q02aTablaBDQ022DS00obj = null;
   	  Q02aCuestionarioVTMAnu cuestionarioVTMAnuBD = null;
   	  ResultSet rs = null;   	  
         try{ 
           if (niCuestionarioVTMAnu!=null){           
           	Q02aTablaBDQ022DS00obj = new Q02aTablaBDQ022DS00(this.getConnection());
           	//se pone el filtro
           	
           	Q02aTablaBDQ022DS00obj.setQ022DT00_ID_CUES_WHERE(new Long(niCuestionarioVTMAnu));
           	Q02aTablaBDQ022DS00obj.setQ022BT00_ID_GRUPO_WHERE(new Integer(niGrupoCuestionarioVTMAnu));
         
           	rs = Q02aTablaBDQ022DS00obj.select();
           	Q02aTablaBDQ022DS00obj.addResultSet(rs); 
           	cuestionarioVTMAnuBD = tratarRs(rs);
        	cambiarPunto(cuestionarioVTMAnuBD);
            
           }  
           return cuestionarioVTMAnuBD;
           
           }catch(Exception ex){           	   
                  java.io.StringWriter sw = new java.io.StringWriter();
                  java.io.PrintWriter pw = new java.io.PrintWriter(sw);
                  ex.printStackTrace(pw);
                  tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioVTMAnu: " + sw.getBuffer ().toString());
                  throw ex;
           }finally{
        	   try{
   	   			 Q02aTablaBDQ022DS00obj.freeResourcesNotConnection();	
   				}catch(Exception ex){
   	   			if (tr.isTraceActive()){
   	   				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioVTMAnu: error liberando recursos");
   	   		   	   }  
   				}  	
            	  if (tr.isTraceActive()){
            		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVTMAnu: saliendo");                
                 }            	 
           }	  
           
     }//fin obtenerCuestionarioVTMAnu

     /**
      * 
      * @param rs rs
      * @return cuestionarioVTMAnuBD
      * @throws Exception Exception
      */
     private Q02aCuestionarioVTMAnu  tratarRs (ResultSet rs) throws Exception {

	  tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":tratarRs: entrando");           

	  Q02aCuestionarioVTMAnu cuestionarioVTMAnuBD = new Q02aCuestionarioVTMAnu();     

   	  if (rs.next()) {	 
   		 tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":tratarRs: Hay registro");                
   		 try{
        		 	rellenarVOCuestionarioVTMAnu(cuestionarioVTMAnuBD,rs);
   		 }catch (Exception e) {
   		     if (tr.isTraceActive()){
	   	   		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":tratarRs: error "+ e.getMessage());
   		     }  
       }  	

	}

	return cuestionarioVTMAnuBD;

     } 

     
     /**
      * 
      * @param cuestionarioVTMAnuBD cuestionarioVTMAnuBD
      * @param rs rs
      * @throws Exception Exception
      */
     private void rellenarVOCuestionarioVTMAnu (Q02aCuestionarioVTMAnu cuestionarioVTMAnuBD, ResultSet rs) throws Exception
     {
     	try{
	     	tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":rellenarVOCuestionarioVTMAnu: Hay Datos");            

            cuestionarioVTMAnuBD.setNiGrupoCuesVTMAnu(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022BT00_ID_GRUPO));
	     	cuestionarioVTMAnuBD.setNiCuesVTMAnu(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_ID_CUES));
			cuestionarioVTMAnuBD.setIdenLicen(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_IDEN_LICEN));			
			cuestionarioVTMAnuBD.setFecEnt(Q02aFormatData.formatearFecha( Q02aFormatData.checkStringNull( rs.getString( Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_FEC_ENT)), Q02aConstantes.FORMATO_FECHA_FORMAT_DATA, this.getIdioma()));
			cuestionarioVTMAnuBD.setEstadoLicen(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_ESTADO_LICEN));
			cuestionarioVTMAnuBD.setCausaBaja(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_CAUSA_BAJA));
			cuestionarioVTMAnuBD.setEnti(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_ENTI));
			cuestionarioVTMAnuBD.setTvia(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_TVIA));
			cuestionarioVTMAnuBD.setCalle(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_CALLE));
			cuestionarioVTMAnuBD.setPorClPor(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_POR_CL_POR));
			cuestionarioVTMAnuBD.setBloq(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_BLOQ));
			cuestionarioVTMAnuBD.setNume(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NUME));
			cuestionarioVTMAnuBD.setBis(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_BIS));
			cuestionarioVTMAnuBD.setCdir(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_CDIR));
			cuestionarioVTMAnuBD.setDirNueva(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_DIR_NUEVA));
			cuestionarioVTMAnuBD.setRsPromo(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_RS_PROMO));
			cuestionarioVTMAnuBD.setCifDni(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_CIF_DNI));
			cuestionarioVTMAnuBD.setMunProv(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_MUN_PROV));
			cuestionarioVTMAnuBD.setMunMuni(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_MUN_MUNI));
			cuestionarioVTMAnuBD.setEntiPro(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_ENTI_PRO));
			cuestionarioVTMAnuBD.setTviaPro(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_TVIA_PRO));
			cuestionarioVTMAnuBD.setCallePro(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_CALLE_PRO));
			cuestionarioVTMAnuBD.setPorClPorPro(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_POR_CL_POR_PRO));
			cuestionarioVTMAnuBD.setBloqPro(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_BLOQ_PRO));
			cuestionarioVTMAnuBD.setNumePro(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NUME_PRO));
			cuestionarioVTMAnuBD.setBisPro(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_BIS_PRO));
			cuestionarioVTMAnuBD.setCdirPro(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_CDIR_PRO));
			cuestionarioVTMAnuBD.setDirExternaPro(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_DIR_PRO_EXTERNO));
			cuestionarioVTMAnuBD.setTlf(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_TLF));
			cuestionarioVTMAnuBD.setMail(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_MAIL));
			cuestionarioVTMAnuBD.setFax(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_FAX));
			cuestionarioVTMAnuBD.setWeb(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_WEB));
			cuestionarioVTMAnuBD.setPresupuesto(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_PRESUPUESTO));
			cuestionarioVTMAnuBD.setFIni(Q02aFormatData.formatearFecha( Q02aFormatData.checkStringNull( rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_F_INI)),Q02aConstantes.FORMATO_FECHA_FORMAT_DATA, this.getIdioma()));
			cuestionarioVTMAnuBD.setFFin(Q02aFormatData.formatearFecha( Q02aFormatData.checkStringNull( rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_F_FIN)),Q02aConstantes.FORMATO_FECHA_FORMAT_DATA, this.getIdioma()));
			cuestionarioVTMAnuBD.setTipoObra(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_TIPO_OBRA));
			cuestionarioVTMAnuBD.setUsoRes(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_USO_RES));
			cuestionarioVTMAnuBD.setActividad(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_ACTIVIDAD));
			cuestionarioVTMAnuBD.setNvn(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NVN));
			cuestionarioVTMAnuBD.setNvr(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NVR));
			cuestionarioVTMAnuBD.setNvl(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NVL));
			cuestionarioVTMAnuBD.setNvvpo(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NVVPO));
			cuestionarioVTMAnuBD.setNvvs(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NVVS));
			cuestionarioVTMAnuBD.setNvpot(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NVPOT));
			cuestionarioVTMAnuBD.setNvaldot(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NVALDOT));
			cuestionarioVTMAnuBD.setNvreal(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NVREAL));
			cuestionarioVTMAnuBD.setNvvtmg(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NVVTMG));
			cuestionarioVTMAnuBD.setNvvtme(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NVVTME));
			cuestionarioVTMAnuBD.setNtot(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NTOT));
			cuestionarioVTMAnuBD.setNsp45(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NSP45));
			cuestionarioVTMAnuBD.setNsp75(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NSP75));
			cuestionarioVTMAnuBD.setNsp90(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NSP90));
			cuestionarioVTMAnuBD.setNsp120(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NSP120));
			cuestionarioVTMAnuBD.setNspt(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NSPT));
			cuestionarioVTMAnuBD.setPrincUso(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_PRINC_USO));
			cuestionarioVTMAnuBD.setPuEspecif(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_PU_ESPECIF));
			cuestionarioVTMAnuBD.setPrecioMed(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_PRECIO_MED));
			cuestionarioVTMAnuBD.setObs(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_OBS));
			
            if ( rs.getString( Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NUMVIVFINALES ) != null){
                cuestionarioVTMAnuBD.setNumVivFinales( rs.getString( Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NUMVIVFINALES ));
            }
            if ( rs.getString( Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_INDNUEPLREHAB ) != null){
                cuestionarioVTMAnuBD.setIndNuePlRehab( rs.getString( Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_INDNUEPLREHAB ));
            }
            if ( rs.getString( Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_INDREHABNUMVIV ) != null){
                cuestionarioVTMAnuBD.setIndRehabNumViv( rs.getString( Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_INDREHABNUMVIV ));
            }
            if ( rs.getString( Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_FUERA_PLAZO ) != null){
                cuestionarioVTMAnuBD.setFueraPlazo( rs.getString( Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_FUERA_PLAZO ));
            }
            
            if ( rs.getString( Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_CODIGO_LICEN ) != null){
                cuestionarioVTMAnuBD.setCodigoLicencia(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_CODIGO_LICEN));
            }
            
            cuestionarioVTMAnuBD.setLocalizacionObra(rs.getString(Q02aTablaBDQ022DS01V02.NOMCOLUMN_Q022DT00_NORA_T17_LOCALIZACION));
            
            
            
	}catch (Exception e) {
        //System.out.println(this.getClass().getName() + ":rellenarVOCuestionarioVTMAnu: error "+ e.getMessage());
	    	if (tr.isTraceActive()){
	   	   	    tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenarVOCuestionarioVTMAnu: error "+ e.getMessage());
	    	}  
   	}  	

 }

     

      /**
      * Funcin que comprueba si para el municipio y ao hay algn registro en la tabla de Grupos de 
      * 
      * @param cuestionarioVTMAnuFiltro - Datos de la cuestionario a insertar
      * 
      * @throws Exception Exception
      * @return niGrupoCuesVTMAnu
      */

     public String altaModifGrupoCuestionariosVTMAnu(Q02aCuestionarioVTMAnuFiltro cuestionarioVTMAnuFiltro) throws Exception {
    	//se definen objetos necesarios. 	
    	 Q02aTablaBDQ022BS00 tablaBDGrupoCuestionariosVTMAnu = null;
       	//Q02aCuestionarioVTMAnuFiltro grupoCuestionarioVTMAnuBD = null;
       	String niGrupoCuesVTMAnu= null;
       	try{
	    	if (tr.isTraceActive()){
	    	    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVTMAnu: entrando");
	    	}
    		//se crea el objeto de tablasBD
	    	tablaBDGrupoCuestionariosVTMAnu = new Q02aTablaBDQ022BS00(this.getConnection());
      		this.obtenerGrupoCuestionariosVTMAnu(cuestionarioVTMAnuFiltro,tablaBDGrupoCuestionariosVTMAnu);
      		niGrupoCuesVTMAnu =cuestionarioVTMAnuFiltro.getNiGrupoCuesVTMAnu();
      		return niGrupoCuesVTMAnu;
     	}catch(Exception ex){   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosVTMAnu: " + sw.getBuffer ().toString());
     		throw ex;
     	}
     	
        finally{
     		try{
     			tablaBDGrupoCuestionariosVTMAnu.freeResourcesNotConnection();	
     		}catch(Exception ex){
     			if (tr.isTraceActive()){
     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosVTMAnu: error liberando recursos");
 		   	     }  
     		}  		
    		if (tr.isTraceActive()){
    			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVTMAnu: saliendo");                
        	}       	
     	}
     }
     
     /**
      * 
      * @param cuestionarioVTMAnuFiltro cuestionarioVTMAnuFiltro
      * @param tablaBDGrupoCuestionariosVTMAnu tablaBDGrupoCuestionariosVTMAnu
      * @throws Exception Exception
      */
      private void obtenerGrupoCuestionariosVTMAnu(Q02aCuestionarioVTMAnuFiltro cuestionarioVTMAnuFiltro,Q02aTablaBDQ022BS00 tablaBDGrupoCuestionariosVTMAnu) 
      throws Exception {
     	ResultSet rs = null;

     	String niGrupoCuestionariosVTMAnu=null;
     	//String realizaActuacionBD=null;
     	String realizaActuacion=null;
     	boolean hayCuestionarios = false;

     	try{
	    	if (tr.isTraceActive()){
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGrupoCuestionariosVTMAnu: entrando");
	    	}

	   	tablaBDGrupoCuestionariosVTMAnu.setFCA02T00_CODPROVINC_WHERE(Q02aFormatData.checkStringNull(cuestionarioVTMAnuFiltro.getCodProv()));
	   	tablaBDGrupoCuestionariosVTMAnu.setFCA02T00_CODMUNICIP_WHERE(Q02aFormatData.checkStringNull(cuestionarioVTMAnuFiltro.getCodMuni()));
	   	tablaBDGrupoCuestionariosVTMAnu.setQ022BT00_ANO_WHERE(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnuFiltro.getAno()));
	   
		//if(!Q02aFormatData.esNullSinCero(cuestionarioVTMAnuFiltro.getModificarConcedidoLicen()).equals("1"))	
			tablaBDGrupoCuestionariosVTMAnu.setQ022BT00_MES_WHERE(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnuFiltro.getMes()));
	   
	   	
		rs=tablaBDGrupoCuestionariosVTMAnu.select();
	   	tablaBDGrupoCuestionariosVTMAnu.addResultSet(rs);
	   	if(rs.next()){
	   		//Si existe, se comprueba si el campo aplica tiene el mismo valor
	   		niGrupoCuestionariosVTMAnu =rs.getString(tablaBDGrupoCuestionariosVTMAnu.NOMCOLUMN_Q022BT00_ID_GRUPO);
	   		cuestionarioVTMAnuFiltro.setNiGrupoCuesVTMAnu(niGrupoCuestionariosVTMAnu);
	   		/*realizaActuacionBD= Q02aFormatData.esNull(rs.getString(tablaBDGrupoCuestionariosVTMAnu.NOMCOLUMN_Q022BT00_CONCEDIDO_LICEN));
	   		realizaActuacion = Q02aFormatData.esNull(cuestionarioVTMAnuFiltro.getRealizaActuacion());
	   		hayCuestionarios = this.obtenerNumCuestionarios(cuestionarioVTMAnuFiltro.getCodProv(),cuestionarioVTMAnuFiltro.getCodMuni(),cuestionarioVTMAnuFiltro.getAno(),cuestionarioVTMAnuFiltro.getMes());
			if(!realizaActuacionBD.equals(realizaActuacion) && !hayCuestionarios)
	   		{
	   			//Si en el Filtro se ha puesto que se realizan actuaciones, significaba que antes no, con lo que hay que modificar el registro en BD
	   			//Si antes si se realizaban y ahora no, se modifica tb el registro, y se anulan los cuestionarios de ese grupo mediante un trigger
	   			this.modificarLicenciaGrupoCuestionarioVTMAnu(cuestionarioVTMAnuFiltro,tablaBDGrupoCuestionariosVTMAnu);
	   		}*/
	   		
		}else{
			//Si no existe el grupo se da de alta
			niGrupoCuestionariosVTMAnu = this.insertarGrupoCuestionarioVTMAnu(cuestionarioVTMAnuFiltro,tablaBDGrupoCuestionariosVTMAnu);
			cuestionarioVTMAnuFiltro.setNiGrupoCuesVTMAnu(niGrupoCuestionariosVTMAnu);
		}
	    }catch(Exception ex){   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGrupoCuestionariosVTMAnu: " + sw.getBuffer ().toString());
     		throw ex;
	    }

     }     

     
      /**
       * 
       * @param cuestionarioVTMAnuFiltro cuestionarioVTMAnuFiltro
       * @param tablaBDGrupoCuestionariosVTMAnu tablaBDGrupoCuestionariosVTMAnu
       * @return NiGrupoCuesVTMAnu
       * @throws Exception Exception
       */
     public String insertarGrupoCuestionarioVTMAnu(Q02aCuestionarioVTMAnuFiltro cuestionarioVTMAnuFiltro,Q02aTablaBDQ022BS00 tablaBDGrupoCuestionariosVTMAnu) throws Exception {

    	//se definen objetos necesarios.

    	int niGrupoCuestionarioVTMAnu=1;     	

       	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarGrupoCuestionarioVTMAnu: entrando");

	   	}

	    	niGrupoCuestionarioVTMAnu = this.dameSeqNiDeGrupo(tablaBDGrupoCuestionariosVTMAnu);

	         	cuestionarioVTMAnuFiltro.setNiGrupoCuesVTMAnu(Integer.toString(niGrupoCuestionarioVTMAnu));   

	         	//tablaBDGrupoCuestionariosVTMAnu.reset();	         

	         	//----------------------------------------------------------------------         	

      		//se aaden los datos a insertar

         		this.rellenaDatosGrupoCuestionarioVTMAnu(cuestionarioVTMAnuFiltro, tablaBDGrupoCuestionariosVTMAnu);         	         

      		//se realiza la insert

      		tablaBDGrupoCuestionariosVTMAnu.insert();

      		//pediente de recuperar el numContacto

      		return cuestionarioVTMAnuFiltro.getNiGrupoCuesVTMAnu();

     	}

     	catch(Exception ex)

     	{   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarGrupoCuestionarioVTMAnu: " + sw.getBuffer ().toString());

     		throw ex;

     	}

     }

     
     /**
      * 
      * @param cuestionarioVTMAnuFiltro cuestionarioVTMAnuFiltro
      * @param tablaBDGrupoCuestionariosVTMAnu tablaBDGrupoCuestionariosVTMAnu
      * @throws Exception Exception
      */
     public void  modificarLicenciaGrupoCuestionarioVTMAnu(Q02aCuestionarioVTMAnuFiltro cuestionarioVTMAnuFiltro,Q02aTablaBDQ022BS00 tablaBDGrupoCuestionariosVTMAnu) throws Exception {		

		try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarLicenciaGrupoCuestionarioVTMAnu: entrando");

	   	}

	   		//realizaActuacion = cuestionarioVTMAnuFiltro.getRealizaActuacion();

			tablaBDGrupoCuestionariosVTMAnu.setQ022BT00_ID_GRUPO_WHERE(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnuFiltro.getNiGrupoCuesVTMAnu()));

			tablaBDGrupoCuestionariosVTMAnu.setQ022BT00_CONCEDIDO_LICEN(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnuFiltro.getRealizaActuacion()));

			//tablaBDGrupoCuestionariosVTMAnu.setQ022CT00_REALIZA_ACTUACION(new Integer(realizaActuacion));

			tablaBDGrupoCuestionariosVTMAnu.update();



     	}

     	catch(Exception ex)

     	{   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarLicenciaGrupoCuestionarioVTMAnu: " + sw.getBuffer ().toString());

     		throw ex;

     	}

   

     }

     
     /**
      * 
      * @param tablaBDGrupoCuestionariosVTMAnu tablaBDGrupoCuestionariosVTMAnu
      * @return niGrupoCuestionarioVTMAnu
      * @throws Exception Exception
      */
     private int dameSeqNiDeGrupo(Q02aTablaBDQ022BS00 tablaBDGrupoCuestionariosVTMAnu) throws Exception 

     {

     	int niGrupoCuestionarioVTMAnu=1;

     	ResultSet rs = null;

       	PreparedStatement prepStmt =null;	

     	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameSeqNiDeGrupo: entrando");

	   	}

	   	

	   	StringBuffer query = new StringBuffer(" SELECT Q022BQ00.NEXTVAL FROM DUAL ");

	         	prepStmt = this.getConnection().prepareStatement(query.toString());         	

	         	rs = prepStmt.executeQuery();

	         	tablaBDGrupoCuestionariosVTMAnu.addResultSet(rs);

	         	tablaBDGrupoCuestionariosVTMAnu.addStatement(prepStmt);        	

	         	if (rs.next()){

	         		niGrupoCuestionarioVTMAnu = rs.getInt(1);

	         	}

	         	return niGrupoCuestionarioVTMAnu;

	        }

	        catch(Exception ex)

     	        {   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameSeqNiDeGrupo: " + sw.getBuffer ().toString());

     		throw ex;

     	      }

     }     

     
     /**
      * 
      * @param niGrupoCuestionarioVTMAnu niGrupoCuestionarioVTMAnu
      * @param tablaBDCuestionariosVTMAnu tablaBDCuestionariosVTMAnu
      * @return niCuestionarioVTMAnu
      * @throws Exception Exception
      */
     private int dameMaxNiCuesDeGrupo(String niGrupoCuestionarioVTMAnu,Q02aTablaBDQ022DS00 tablaBDCuestionariosVTMAnu) throws Exception 
     {
     	int niCuestionarioVTMAnu=1;
     	ResultSet rs = null;	
     	try{
	    	if (tr.isTraceActive())
	    	{
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameMaxNiCuesDeGrupo: entrando");
	   	}
	   	
	   	tablaBDCuestionariosVTMAnu.setMax(tablaBDCuestionariosVTMAnu.NOMCOLUMN_Q022DT00_ID_CUES);
	   	
	         	tablaBDCuestionariosVTMAnu.setQ022BT00_ID_GRUPO_WHERE(new Integer(niGrupoCuestionarioVTMAnu));
	         	rs = tablaBDCuestionariosVTMAnu.selectMax();
	         	
	         	tablaBDCuestionariosVTMAnu.addResultSet(rs);     	
	         	if (rs.next()){
	         		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameMaxNiCuesDeGrupo: max Cuestionario para niGrupoCuesVTMAnu " + niGrupoCuestionarioVTMAnu+ " ="+ rs.getInt(1));
	         		niCuestionarioVTMAnu = rs.getInt(1) + 1;
	         	}
	         	return niCuestionarioVTMAnu;
	        } catch(Exception ex) {   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameMaxNiCuesDeGrupo: " + sw.getBuffer ().toString());
     		throw ex;
     	      }
     }

     
     /**
      * 
      * @param cuestionarioVTMAnuFiltro cuestionarioVTMAnuFiltro
      * @param tablaBDGrupoCuestionariosVTMAnu tablaBDGrupoCuestionariosVTMAnu
      * @throws Exception Exception
      */
      public void rellenaDatosGrupoCuestionarioVTMAnu( Q02aCuestionarioVTMAnuFiltro cuestionarioVTMAnuFiltro, Q02aTablaBDQ022BS00 tablaBDGrupoCuestionariosVTMAnu) throws Exception {
    	//se definen objetos necesarios.
    	try{
	    	if (tr.isTraceActive())
	    	{
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosGrupoCuestionarioVTMAnu: entrando");
	   	}         	         
     		//se aaden los datos
	    	tablaBDGrupoCuestionariosVTMAnu.setQ022BT00_ID_GRUPO(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnuFiltro.getNiGrupoCuesVTMAnu()));
	    	tablaBDGrupoCuestionariosVTMAnu.setQ022BT00_ANO(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnuFiltro.getAno()));
	    	tablaBDGrupoCuestionariosVTMAnu.setQ022BT00_MES(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnuFiltro.getMes()));
	    	tablaBDGrupoCuestionariosVTMAnu.setQ022BT00_CONCEDIDO_LICEN(Q02aFormatData.checkIntegerNull(cuestionarioVTMAnuFiltro.getRealizaActuacion()));
	    	tablaBDGrupoCuestionariosVTMAnu.setFCA02T00_CODPROVINC(Q02aFormatData.checkStringNull(cuestionarioVTMAnuFiltro.getCodProv()));
	    	tablaBDGrupoCuestionariosVTMAnu.setFCA02T00_CODMUNICIP(Q02aFormatData.checkStringNull(cuestionarioVTMAnuFiltro.getCodMuni()));
	    	tablaBDGrupoCuestionariosVTMAnu.setQ022BT00_OBSSU(Q02aFormatData.checkStringNull(cuestionarioVTMAnuFiltro.getObsVTM()));
			//tablaBDGrupoCuestionariosVTMAnu.setQ022CT00_TIPO_CUESTIONARIO(new Integer(Q02aConstantes.getString("q02a.cuestionarios.VTMAnu.tipoCuestionario")));

    	}catch(Exception ex){   	   
    		java.io.StringWriter sw = new java.io.StringWriter();
    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
    		ex.printStackTrace(pw);
    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaDatosGrupoCuestionarioVTMAnu: " + sw.getBuffer ().toString());
    		throw ex;
    	}finally{    		
			if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosGrupoCuestionarioVTMAnu: saliendo");                
           }       	
    	}	
    }  
    
     /**
      * Funcin que devuelve un string con los meses que le quedan por introducir para un municipio y ao determinados por los parmetros de entrada
      * 
      * @param codProv - Cdigo de la provincia
      * @param codMuni - Cdigo del municipio
      * @param ano - Ao
      * @param idioma - Idioma
      * 
      * @throws Exception Exception
      * @return msgAnos
      */
     public String obtenerAnosSinActuacionesParaMuni(String codProv,String codMuni,String ano,String idioma) throws Exception {

    	//se definen objetos necesarios.
    	String msgAnos = "";
    	int anno = Integer.parseInt(ano);
    	ResultSet rs = null;
    	java.util.Hashtable hashAnos = new java.util.Hashtable();
       	Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosVTMAnu = null;

       	try{
	    	if (tr.isTraceActive())
	    	{
	    	    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: entrando");
	    	}
	   	
	   	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: idioma="+ idioma);
	   
	   	/*if(Q70ListenerUtils.getApplicationProperty("IDIOMA_ES").equals(idioma))
	   	{
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: idioma ES");
	   		arrNombresMeses = Q02aAplicationUtils.mesesCas;
	   	}
	   	else if(Q70ListenerUtils.getApplicationProperty("IDIOMA_EU").equals(idioma))
	   	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: idioma EU");

	   		arrNombresMeses = Q02aAplicationUtils.mesesEus;

	   	}

	   	//Se carga el hashtable con los nombres de los  meses*/
	   
	   	for (int i = anno - 2; i <= anno + 2; i++)
	   	{
	   		hashAnos.put(Integer.toString(i),Integer.toString(i));
		}
    	tablaBDGrupoCuestionariosVTMAnu = new Q02aTablaBDQ022CS00(this.getConnection());
    	rs = this.dameAnosConCuesVTMAnu(codProv,codMuni,ano,tablaBDGrupoCuestionariosVTMAnu);
     	while (rs.next())
     	{
     		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: Hay cuestionarios VTM en el ao ****"+ rs.getString(1));
     		hashAnos.remove(rs.getString(1));
    	}
	        	
     	
		if(!hashAnos.isEmpty())
		{
    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni:Faltan cuestionarios de meter, xq el array hastable no est vacio ****");
    		//String mesesSinCues = "";
    		for (int i = anno - 2; i <= anno + 2; i++)
    		{
    			//Si el array de aos contiene el ao, es que falta de introducir datos, 
    			if(hashAnos.containsKey(Integer.toString(i+1)))
    			{
    				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni:Falta de introducir el ao  ******* ="+ i);
    				if(!msgAnos.equals("")){
    					msgAnos += ", ";
                    }
    				msgAnos += hashAnos.get(Integer.toString(i+1));
    			}
    		}
    		
    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni:Meses sin meter ******* ="+ msgAnos);
    		msgAnos = Q70GestorMensajesi18n.getSingleton().getMessage(RECURSOS_CUES_AYUN_MEN,"cuestionarios.VTMAnu.mesesFaltan",idioma) + msgAnos + ".";
    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni:MSG = ****" + msgAnos);

    	}

      		return msgAnos;
     	}

     	catch(Exception ex)

     	{   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: " + sw.getBuffer ().toString());

     		throw ex;

     	}

     	finally

     	{

     		try

     		{

     			tablaBDGrupoCuestionariosVTMAnu.freeResourcesNotConnection();	

     		}

     		catch(Exception ex)

     		{

     			if (tr.isTraceActive())

     			{

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: error liberando recursos");

 		   	   }  

 		}  		

		if (tr.isTraceActive())

		{

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosSinActuacionesParaMuni: saliendo");                

    		}       	

     	}

     }

     
     /**
      * 
      * @param codProv codProv
      * @param codMuni codMuni
      * @param ano ano
      * @param tablaBDGrupoCuestionariosVTMAnu tablaBDGrupoCuestionariosVTMAnu
      * @return rs
      * @throws Exception Exception
      */
     private ResultSet dameAnosConCuesVTMAnu(String codProv,String codMuni,String ano ,Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosVTMAnu) throws Exception 
     {
     	ResultSet rs = null;	
     	try{
	    	if (tr.isTraceActive())
	    	{
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameAnosConCuesVTMAnu: entrando");
	   	}
   	
	         	tablaBDGrupoCuestionariosVTMAnu.setMUN_PROV_WHERE(codProv);
	         	tablaBDGrupoCuestionariosVTMAnu.setMUN_MUNI_WHERE(codMuni);
	         	tablaBDGrupoCuestionariosVTMAnu.setQ022CT00_ANO_WHERE(new Integer(ano));
				//tablaBDGrupoCuestionariosVTMAnu.setQ022CT00_TIPO_CUESTIONARIO(new Integer(Q02aConstantes.getString("q02a.cuestionarios.VTMAnu.tipoCuestionario")));
	         	tablaBDGrupoCuestionariosVTMAnu.setAditionalWhere(" and  ( " + tablaBDGrupoCuestionariosVTMAnu.NOMCOLUMN_Q022CT00_REALIZA_ACTUACION + " = 0 or ( " +  tablaBDGrupoCuestionariosVTMAnu.NOMCOLUMN_Q022CT00_REALIZA_ACTUACION + " = 1 and " + tablaBDGrupoCuestionariosVTMAnu.NOMCOLUMN_Q022CT00_ID_GRUPO + " in (select distinct(" + tablaBDGrupoCuestionariosVTMAnu.NOMCOLUMN_Q022CT00_ID_GRUPO + ") from Q022DS00)))");

	         	rs = tablaBDGrupoCuestionariosVTMAnu.selectDistinct();

	         	tablaBDGrupoCuestionariosVTMAnu.addResultSet(rs);     	
	         	return rs;
	        }

	        catch(Exception ex)
     	        {   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameAnosConCuesVTMAnu: " + sw.getBuffer ().toString());
     		throw ex;
     	      } finally {

     	      	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameAnosConCuesVTMAnu: saliendo");

	   	}

     	      }

     }

     

      /**
      * Funcin que devuelve el campo Concede Licencias para un municipio,ao y mes determinados por los parmetros de entrada
      * 
      * @param codProv - Cdigo de la provincia
      * @param codMuni - Cdigo del municipio
      * @param ano - Ao
      * @return realizaActuacion
      * @throws Exception Exception
      */

     public String obtenerCamporRealizaActuacionDeGrupoConMuniAno(String codProv,String codMuni,String ano) 
     throws Exception {

    	//se definen objetos necesarios.

    	String realizaActuacion = null;

    	ResultSet rs = null;

       	Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosVTMAnu = null;

       	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCamporRealizaActuacionDeGrupoConMuniAno: entrando");

	   	}

	   	

	    	tablaBDGrupoCuestionariosVTMAnu = new Q02aTablaBDQ022CS00(this.getConnection());

	    	rs = this.dameRsGrupoCues(codProv,codMuni,ano,tablaBDGrupoCuestionariosVTMAnu);

				if (rs.next())

	         	{

	         		realizaActuacion = rs.getString(tablaBDGrupoCuestionariosVTMAnu.NOMCOLUMN_Q022CT00_REALIZA_ACTUACION);

	         		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCamporRealizaActuacionDeGrupoConMuniAno: entrando");

	        	}

      		return Q02aFormatData.esNullSinCero(realizaActuacion);

     	}

     	catch(Exception ex)

     	{   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCamporRealizaActuacionDeGrupoConMuniAno: " + sw.getBuffer ().toString());

     		throw ex;

     	}

     	finally

     	{

     		try

     		{

     			tablaBDGrupoCuestionariosVTMAnu.freeResourcesNotConnection();	

     		}

     		catch(Exception ex)

     		{

     			if (tr.isTraceActive())

     			{

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCamporRealizaActuacionDeGrupoConMuniAno: error liberando recursos");

 		   	   }  

 		}  		

		if (tr.isTraceActive())

		{

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCamporRealizaActuacionDeGrupoConMuniAno: saliendo");                

    		}       	

     	}

     }

     
     /**
      * 
      * @param codProv codProv
      * @param codMuni codMuni
      * @param ano ano
      * @param tablaBDGrupoCuestionariosVTMAnu tablaBDGrupoCuestionariosVTMAnu
      * @return rs
      * @throws Exception Exception
      */
     private ResultSet dameRsGrupoCues(String codProv,String codMuni,String ano , Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosVTMAnu) throws Exception 
     {
     	ResultSet rs = null;	
     	try{
	    	if (tr.isTraceActive())
	    	{
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameRsGrupoCues: entrando");
	   	}
	   	
	         	tablaBDGrupoCuestionariosVTMAnu.setMUN_PROV_WHERE(codProv);
	         	tablaBDGrupoCuestionariosVTMAnu.setMUN_MUNI_WHERE(codMuni);
	         	tablaBDGrupoCuestionariosVTMAnu.setQ022CT00_ANO_WHERE(new Integer(ano));
				//tablaBDGrupoCuestionariosVTMAnu.setQ022CT00_TIPO_CUESTIONARIO_WHERE(new Integer(Q02aConstantes.getString("q02a.cuestionarios.VTMAnu.tipoCuestionario")));
	         	rs = tablaBDGrupoCuestionariosVTMAnu.select();
	         	tablaBDGrupoCuestionariosVTMAnu.addResultSet(rs);     	
	         	return rs;
	        }
	        catch(Exception ex)
     	        {   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameRsGrupoCues: " + sw.getBuffer ().toString());
     		throw ex;
     	      }
     	      finally

     	      {

     	      	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameRsGrupoCues: saliendo");

	   	}

     	      }

     }

     

      /**
      * Funcin que modifica la firma del grupo de cuestionarios pasado como parmetro
      * 
      * @param niGrupoCuesVTMAnu - Datos de cuestionarioVTMAnu a modificar
      * @param xmlFirmaGrupoCuestionariosVTMAnu xmlFirmaGrupoCuestionariosVTMAnu
      * @throws Exception Exception
      */

     public void guardarFirmaGrupoCuestionariosVTMAnu(String niGrupoCuesVTMAnu,String xmlFirmaGrupoCuestionariosVTMAnu) throws Exception {  



      	if (tr.isTraceActive()){

  		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu: entrando");

  	}

      	//Se instancian los objetos necesarios.

      	StringBuffer queryClob= new StringBuffer();

      	Q02aTablaBDQ022CS00 Q02aTablaBDQ022CS00obj = null;    

         	 try

         	 {     

         	 	//se crea el objeto de tablasBD

        		Q02aTablaBDQ022CS00obj = new Q02aTablaBDQ022CS00(this.getConnection());

        		//segmento tecnico

             		//Q02aTablaBDQ022DS00obj.setUser(this.getUser());

  		

       		Q02aTablaBDQ022CS00obj.setQ022CT00_ID_GRUPO_WHERE(new Integer(niGrupoCuesVTMAnu));

       		//Este campo se actualiza de forma especial, con una select for update de este campo

       		//Q02aTablaBDQ022CS00obj.setQ022CT00_XML_FIRMADO(xmlFirmaGrupoCuestionariosVTMAnu);

       		//Q02aTablaBDQ022CS00obj.setQ022CT00_FEC_FIRMA(new java.util.Date(System.currentTimeMillis()));

       		//De momento el usuario lo metemos vacio

       		//Q02aTablaBDQ022CS00obj.setQ022CT00_USER_FIRMA();

       		//se realiza la update

       		Q02aTablaBDQ022CS00obj.update();

       		

       		//Se realiza la query de los CLOB

	    	//queryClob.append("SELECT ").append(Q02aTablaBDQ022CS00obj.NOMCOLUMN_Q022CT00_XML_FIRMADO).append(" FROM  Q022CS00 WHERE ").append(Q02aTablaBDQ022CS00obj.NOMCOLUMN_Q022CT00_ID_GRUPO).append(" = " ).append(niGrupoCuesVTMAnu).append(" FOR UPDATE");

	    	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu->queryClob="+ queryClob.toString());

	    	//Se inserta el Clob

	    	Q02aBDUtilidades.insertClob(xmlFirmaGrupoCuestionariosVTMAnu,queryClob.toString(),this.getConnection());

       		

         }

         catch(Exception ex)

         {

              java.io.StringWriter sw = new java.io.StringWriter();

              java.io.PrintWriter pw = new java.io.PrintWriter(sw);

              ex.printStackTrace(pw);

              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu: " + sw.getBuffer ().toString());

              throw ex;

         }

         finally

         {     

         	try

         	{

    		Q02aTablaBDQ022CS00obj.freeResourcesNotConnection();	

    	}

    	catch(Exception ex)

    	{

		   if (tr.isTraceActive())

		   {

			   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu: error liberando recursos");

   	   	   }  

    	}  		  

      	if (tr.isTraceActive())

      	{

      		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosVTMAnu: saliendo");                

                      }             

         }     

     } // fin guardarFirmaGrupoCuestionariosVTMAnu

     

     

     /**
      * Funcin que borra el cuestionarioVTMAnu pasado como parmetro de la BBDD
      * 
      * @param niGrupoCuestionarioVTMAnu - nmero interno del cuestionarioVTMAnu a borrar
      * 
      * @throws Exception Exception
      */

     public void borrarTodosCuestionarioVTMAnu(String niGrupoCuestionarioVTMAnu) throws Exception {
		if (tr.isTraceActive()) {
			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarTodosCuestionarioVTMAnu: entrando");
		}
		// se crean los objetos necesarios

		Q02aTablaBDQ022DS00 Q02aTablaBDQ022DS00obj = null;
		try {
//			Calendar calendar = Calendar.getInstance();
//			String fecha = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss", new java.util.Locale("es")).format(new Date(calendar.getTimeInMillis()));
			// se crea el objeto de tablasBD
			Q02aTablaBDQ022DS00obj = new Q02aTablaBDQ022DS00(this.getConnection());
			// segmento tecnico
			// Q02aTablaBDQ022DS00obj.setUser(this.getUser());
			// se pone el filtro para la delete
			// Q02aTablaBDQ022DS00obj.setQ022DT00_ID_CUES_WHERE(Long.parseLong(niCuestionarioVTMAnu));
			Q02aTablaBDQ022DS00obj.setQ022BT00_ID_GRUPO_WHERE(Integer.parseInt(niGrupoCuestionarioVTMAnu));
			// se lanza al delete
			Q02aTablaBDQ022DS00obj.update();
		} catch (Exception ex){
			java.io.StringWriter sw = new java.io.StringWriter();
			java.io.PrintWriter pw = new java.io.PrintWriter(sw);
			ex.printStackTrace(pw);
			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarTodosCuestionarioVTMAnu: " + sw.getBuffer().toString());
			throw ex;
		} finally{
			try {
				Q02aTablaBDQ022DS00obj.freeResourcesNotConnection();
			} catch (Exception ex){
				if (tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarTodosCuestionarioVTMAnu: error liberando recursos");
				}
			}
			if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarTodosCuestionarioVTMAnu: saliendo");
			}
		}

     }//fin borrarTodosCuestionarioVTMAnu 

     
     /**
      * 
      * @param niGrupoCuestionarioVTMAnu niGrupoCuestionarioVTMAnu
      * @throws Exception Exception
      */
     public void  modificarDatosFirmaGrupoCuestionarioVTMMen(String niGrupoCuestionarioVTMAnu) throws Exception {

    	 

    	 Q02aTablaBDQ022BS00 tablaBDGrupoCuestionariosVTMMen = null;

      	try{

 	    	if (tr.isTraceActive())

 	    	{

 	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarDatosFirmaGrupoCuestionarioVTMMen: entrando");

 	   	}

 	    	tablaBDGrupoCuestionariosVTMMen = new Q02aTablaBDQ022BS00(this.getConnection());

 	    	

 	    	tablaBDGrupoCuestionariosVTMMen.setQ022BT00_ID_GRUPO_WHERE(Integer.parseInt(niGrupoCuestionarioVTMAnu));

 	    	

 	    	tablaBDGrupoCuestionariosVTMMen.setQ022BT00_FEC_FIRMA(null);

 	    	

 	    		

 	    	StringBuffer queryClob= new StringBuffer();

 	    	

 	    	queryClob.append("SELECT ").append(Q02aTablaBDQ022BS00.NOMCOLUMN_Q022BT00_XML_FIRMADO).append(" FROM  Q022BS00 WHERE ").append(Q02aTablaBDQ022BS00.NOMCOLUMN_Q022BT00_ID_GRUPO).append(" = " ).append(Integer.parseInt(niGrupoCuestionarioVTMAnu)).append(" FOR UPDATE");

 	    		    	

 	    	Q02aBDUtilidades.insertClob(" ",queryClob.toString(),this.getConnection());

 	    	

 	    	tablaBDGrupoCuestionariosVTMMen.setQ022BT00_USER_FIRMA(null);

 	    	

 	    	tablaBDGrupoCuestionariosVTMMen.update();



    	}

    	catch(Exception ex)

    	{   	   

    		java.io.StringWriter sw = new java.io.StringWriter();

    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

    		ex.printStackTrace(pw);

    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarDatosFirmaGrupoCuestionarioVTMMen: " + sw.getBuffer ().toString());

    		throw ex;

    	}

  

    }

     

     /**
      * Funcin que devuelve el campo Concede Licencias para un municipio,ao y mes determinados por los parmetros de entrada
      * 
      * @param codProv - Cdigo de la provincia
      * @param codMuni - Cdigo del municipio
      * @param ano - Ao
      * @param mes - Mes
      * @throws Exception Exception
      * @return hayCuestionarios
      */

     public boolean obtenerNumCuestionarios(String codProv,String codMuni,String ano,String mes) throws Exception {

    	//se definen objetos necesarios.

    	boolean hayCuestionarios = false;

    	ResultSet rs = null;

       	Q02aTablaBDQ022BS00 tablaBDGrupoCuestionariosVTM = null;

       	Q02aTablaBDQ022DS00 tablaBDCuestionariosVTM = null;

       	int numero = -1;

       	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNumCuestionarios: entrando");

	   	}

	   	

	    	tablaBDGrupoCuestionariosVTM = new Q02aTablaBDQ022BS00(this.getConnection());

	    	tablaBDCuestionariosVTM = new Q02aTablaBDQ022DS00(this.getConnection());

	    	

	    	//hacer un metodo nuevo

	    	rs = this.dameRsNumCues(codProv,codMuni,ano,mes,tablaBDGrupoCuestionariosVTM,tablaBDCuestionariosVTM);

	        if (rs.next())

	        {

	        	numero = rs.getInt(1);

	        	if (numero > 0)

	        	{

	        		hayCuestionarios = true;

	        	}

	        	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNumCuestionarios: entrando");

	        }

	        	

      		return hayCuestionarios;

     	}

     	catch(Exception ex)

     	{   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerNumCuestionarios: " + sw.getBuffer ().toString());

     		throw ex;

     	}

     	finally

     	{

     		try

     		{

     			tablaBDGrupoCuestionariosVTM.freeResourcesNotConnection();	

     		}

     		catch(Exception ex)

     		{

     			if (tr.isTraceActive())

     			{

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoConcedeLicenDeGrupoConMuniAnoYMes: error liberando recursos");

 		   	   }  

 		}  		

		if (tr.isTraceActive())

		{

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoConcedeLicenDeGrupoConMuniAnoYMes: saliendo");                

    		}       	

     	}

     }

     
     /**
      * 
      * @param codProv codProv
      * @param codMuni codMuni
      * @param ano ano
      * @param mes mes
      * @param tablaBDGrupoCuestionariosVTM tablaBDGrupoCuestionariosVTM
      * @param tablaBDCuestionariosVTM tablaBDCuestionariosVTM
      * @return rs
      * @throws Exception Exception
      */
     private ResultSet dameRsNumCues(String codProv,String codMuni,String ano ,String mes,Q02aTablaBDQ022BS00 tablaBDGrupoCuestionariosVTM,Q02aTablaBDQ022DS00 tablaBDCuestionariosVTM) throws Exception 
     {
     	ResultSet rs = null;	
     	try{
	    	if (tr.isTraceActive()){
	    	    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameRsNumCues: entrando");
	    	}
	    	
	    	tablaBDCuestionariosVTM.setAditionalWhere("AND " + Q02aTablaBDQ022DS00.NOMCOLUMN_Q022BT00_ID_GRUPO + " in (select " + Q02aTablaBDQ022DS00.NOMCOLUMN_Q022BT00_ID_GRUPO + " from Q022BS00 where " + Q02aTablaBDQ022BS00.NOMCOLUMN_Q022BT00_ANO + " = " + ano + " and " + Q02aTablaBDQ022BS00.NOMCOLUMN_Q022BT00_MES + " = " + mes + " and " + Q02aTablaBDQ022BS00.NOMCOLUMN_FCA02T00_CODPROVINC + " = " + codProv + " and " + Q02aTablaBDQ022BS00.NOMCOLUMN_FCA02T00_CODMUNICIP + " = " + codMuni + " )");
	    	rs = tablaBDCuestionariosVTM.selectCount();
	    	tablaBDCuestionariosVTM.addResultSet(rs);     	
	        return rs;
	    }catch(Exception ex){   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameRsNumCues: " + sw.getBuffer ().toString());
     		throw ex;
     	} finally {
     	    if (tr.isTraceActive())	{
     	        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameRsGrupoCues: saliendo");
     	    }
     	}
     }

     
     /**
      * 
      * @param territorio territorio
      * @param municipio municipio
      * @param anyoReferencia anyoReferencia
      * @param mesReferencia mesReferencia
      * @return numCuestionariosOM
      * @throws Exception Exception
      */
     public int getNumCuestionariosOM(String territorio, String  municipio, String  anyoReferencia, String  mesReferencia) throws Exception 

     {

    	int numCuestionariosOM=0;
    	ResultSet rs = null;
       	PreparedStatement prepStmt =null;	
       	StringBuffer query = null;

     	try{
	    	if (tr.isTraceActive()){
	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosOM: entrando");
	    	}

	    	query = new StringBuffer("SELECT COUNT(*) FROM Q022DS01V01 WHERE");
        	query.append(" Q022BT00_ANO=").append(anyoReferencia);
        	query.append(" AND FCA02T00_CODPROVINC='").append(territorio).append("'");
        	query.append(" AND FCA02T00_CODMUNICIP='").append(municipio).append("'");

        	if(!Q02aFormatData.esNull(mesReferencia).equals("")){ //Si se llama desde la portada SM 2008, l mes no vendr informado
        		query.append(" AND Q022BT00_MES=").append(mesReferencia);
            }
        	prepStmt = this.getConnection().prepareStatement(query.toString());
        	
   	 		rs = prepStmt.executeQuery(); 

   	 		if(rs.next()){
   	 			numCuestionariosOM = rs.getInt(1);
   	 		}

	        if (tr.isTraceActive()){
		    	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosOM: saliendo");
		    }

	        return numCuestionariosOM;

	       }catch(Exception ex){   	   
	     		java.io.StringWriter sw = new java.io.StringWriter();
	     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	     		ex.printStackTrace(pw);
	     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosOM: " + sw.getBuffer ().toString());
	     		throw ex;
     	    }finally{ 
    	    	  try{
    	    		   if (rs!=null){
    	    			   rs.close();
                       }
    	       		   if (prepStmt!=null){
    	       			   prepStmt.close();
                       }
    	          }catch(Exception ex){
    	        	  java.io.StringWriter sw = new java.io.StringWriter();
    		          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
    		          ex.printStackTrace(pw);
    		          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: " + sw.getBuffer ().toString());
    		          throw new Q02aDAOException(ex);
    	          }
	       }
	 }
     
     /**
      * 
      * @param territorio territorio
      * @param municipio municipio
      * @param anyoReferencia anyoReferencia
      * @param mesReferencia mesReferencia
      * @return concedidoLicenInicial
      * @throws Exception Exception
      */
     public String getConcedidoGrupoCuesVTM(String territorio, String  municipio, String  anyoReferencia, String  mesReferencia) throws Exception 
     {
    	String concedidoLicenInicial="";
    	ResultSet rs = null;
       	PreparedStatement prepStmt =null;	
       	StringBuffer query = null;
     	try{

	    	if (tr.isTraceActive()){
	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getConcedidoGrupoCuesVTM: entrando");
	    	}

	    	query = new StringBuffer("SELECT Q022BT00_CONCEDIDO_LICEN FROM Q022BS00 WHERE");
        	query.append(" Q022BT00_ANO=").append(anyoReferencia);
        	query.append(" AND FCA02T00_CODPROVINC='").append(territorio).append("'");
        	query.append(" AND FCA02T00_CODMUNICIP='").append(municipio).append("'");	  

        	if(!Q02aFormatData.esNull(mesReferencia).equals("")){ //Si se llama desde la portada SM 2008, l mes no vendr informado
        		query.append(" AND Q022BT00_MES=").append(mesReferencia);
            }
        	prepStmt = this.getConnection().prepareStatement(query.toString());
        	
   	 		rs = prepStmt.executeQuery(); 
   	 		if (rs.next()) {
   	 		concedidoLicenInicial = rs.getString(1);
   	 		}
	        if (tr.isTraceActive()) {
		    	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getConcedidoGrupoCuesVTM: saliendo");
		    }
	        return concedidoLicenInicial;
	       } catch (Exception ex) {   	   
	     		java.io.StringWriter sw = new java.io.StringWriter();
	     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	     		ex.printStackTrace(pw);
	     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getConcedidoGrupoCuesVTM: " + sw.getBuffer ().toString());
	     		throw ex;
     	    } finally { 
	    	   try {
	    		   if (rs != null) {
	    			   rs.close();
                   }
	       		   if (prepStmt != null) {
	       			   prepStmt.close();
                   }
	          }catch(Exception ex){
	        	  java.io.StringWriter sw = new java.io.StringWriter();
		          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
		          ex.printStackTrace(pw);
		          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getConcedidoGrupoCuesVTM: " + sw.getBuffer ().toString());
		          throw new Q02aDAOException(ex);
	          }
     	    }
     }
     
     /**
      * 
      * @param territorio territorio
      * @param municipio municipio
      * @param anyoReferencia anyoReferencia
      * @param mesReferencia mesReferencia
      * @return concedidoLicenInicial
      * @throws Exception Exception
      */
     public String getObservacionesCuesVTM(String territorio, String  municipio, String  anyoReferencia, String  mesReferencia) throws Exception 
     {
        String observacionesVTM = "";
        ResultSet rs = null;
        PreparedStatement prepStmt = null;   
        StringBuffer query = null;
        try{

            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getConcedidoGrupoCuesVTM: entrando");
            }

            query = new StringBuffer("SELECT Q022BT00_CONCEDIDO_LICEN, Q022BT00_OBSSU FROM Q022BS00 WHERE");
            query.append(" Q022BT00_ANO=").append(anyoReferencia);
            query.append(" AND FCA02T00_CODPROVINC='").append(territorio).append("'");
            query.append(" AND FCA02T00_CODMUNICIP='").append(municipio).append("'");     

            //if(!Q02aFormatData.esNull(mesReferencia).equals("")){ //Si se llama desde la portada SM 2008, l mes no vendr informado
                query.append(" AND Q022BT00_MES=").append(mesReferencia);
            //}
            prepStmt = this.getConnection().prepareStatement(query.toString());
            
            rs = prepStmt.executeQuery(); 
            if (rs.next()) {
                observacionesVTM = rs.getString(2)== null?"":( rs.getString(2) );
            }else{
                observacionesVTM = "noExistReg";
            }
            
            if (tr.isTraceActive()) {
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getConcedidoGrupoCuesVTM: saliendo");
            }
            return observacionesVTM;
           } catch (Exception ex) {        
                java.io.StringWriter sw = new java.io.StringWriter();
                java.io.PrintWriter pw = new java.io.PrintWriter(sw);
                ex.printStackTrace(pw);
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getConcedidoGrupoCuesVTM: " + sw.getBuffer ().toString());
                throw ex;
            } finally { 
               try {
                   if (rs != null) {
                       rs.close();
                   }
                   if (prepStmt != null) {
                       prepStmt.close();
                   }
              }catch(Exception ex){
                  java.io.StringWriter sw = new java.io.StringWriter();
                  java.io.PrintWriter pw = new java.io.PrintWriter(sw);
                  ex.printStackTrace(pw);
                  tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getConcedidoGrupoCuesVTM: " + sw.getBuffer ().toString());
                  throw new Q02aDAOException(ex);
              }
            }
     }
     
     /**
      * 
      * @param niGrupoCuesVTM niGrupoCuesVTM
      * @param valorRealizaActu valorRealizaActu
      * @param mes mes
      * @param obs obs
      * @throws Exception Exception
      */
     public void  modificarGrupoCuestionariosVTM(String niGrupoCuesVTM, String valorRealizaActu, String mes, String obs) throws Exception {
    	 Q02aTablaBDQ022BS00 tablaBDGrupoCuestionariosVTM = null;
    	 Q02aTablaBDQ022DS00 tablaBDCuestionariosVTM = null;
    	 try{
	    	if (tr.isTraceActive()){
	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarGrupoCuestionariosVTM: entrando");
	    	}
	    	tablaBDGrupoCuestionariosVTM = new Q02aTablaBDQ022BS00(this.getConnection());
	    	tablaBDCuestionariosVTM = new Q02aTablaBDQ022DS00(this.getConnection());
	    	
	    	if (valorRealizaActu.equals("0")) { //Hay que borrar los cuestionarios rellenados de cuando se respondio que SI se haban concedido licencias
	    		tablaBDCuestionariosVTM.setQ022BT00_ID_GRUPO_WHERE(Q02aFormatData.checkIntegerNull(niGrupoCuesVTM));
	    		tablaBDCuestionariosVTM.delete();

	    	}

	    	//Modificamos el grupo

	    	tablaBDGrupoCuestionariosVTM.setQ022BT00_ID_GRUPO_WHERE(Q02aFormatData.checkIntegerNull(niGrupoCuesVTM));

	    	tablaBDGrupoCuestionariosVTM.setQ022BT00_CONCEDIDO_LICEN(Q02aFormatData.checkIntegerNull(valorRealizaActu));

	    	//tablaBDGrupoCuestionariosVTM.setQ22BT00_MES(Integer.parseInt(mes));

	    	if (valorRealizaActu.equals("0")) {
	    		tablaBDGrupoCuestionariosVTM.setQ022BT00_OBSSU(obs);
            }else{
	    		tablaBDGrupoCuestionariosVTM.setQ022BT00_OBSSU(null);
            }
	    	tablaBDGrupoCuestionariosVTM.update();

     	}
     	catch(Exception ex){   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarGrupoCuestionariosVTM: " + sw.getBuffer ().toString());
     		throw ex;
     	}

     	finally{

    		try{

    			tablaBDGrupoCuestionariosVTM.freeResourcesNotConnection();	

    		}

    		catch(Exception ex){

    			if (tr.isTraceActive()){

    				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarGrupoCuestionariosVTM: error liberando recursos");

		   	}  

		}

     }

   }
public ArrayList obtenerEstadisticas(HashMap mapaEstadisticas)
throws Exception {
	
	ArrayList listaEstadisticasVTM = new ArrayList();
	
 	try{
 		
 		if (tr.isTraceActive()){
    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":mapaEstadisticas():"+mapaEstadisticas.toString());
    	}
 		
 		String tipoObra = (String)mapaEstadisticas.get("tipoobra"); //0-nueva,1-rehabilitacion,2-demolicion,null-cualquiera
 		String agrupado = (String)mapaEstadisticas.get("agrupado"); //0-comarca,1-area funcional,2-tamao municipio
 		String tamanyoMunicipio = (String)mapaEstadisticas.get("tamanyoMunicipio"); //Solo en caso de haber seleccionado agrupacion por tamao de municipio
 		String dato = (String)mapaEstadisticas.get("dato"); //0-licencias,1-viviendas nuevas,2-viviendas rehabilitadas
 		
 		String codProv =(String)mapaEstadisticas.get("codProv");
 		String codMuni =(String)mapaEstadisticas.get("codMuni");
 		
 		//int mesDesde = Integer.parseInt((String)mapaEstadisticas.get("mesdesde"));
 		//int mesHasta = Integer.parseInt((String)mapaEstadisticas.get("meshasta"));
 		int anyoDesde = Integer.parseInt((String)mapaEstadisticas.get("anyodesde"));
 		int anyoHasta = Integer.parseInt((String)mapaEstadisticas.get("anyohasta"));
 		
 		if (tr.isTraceActive()){
    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":tipoObra:"+tipoObra);
    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":agrupado:"+agrupado);
    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":tamanyoMunicipio:"+tamanyoMunicipio);
    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dato:"+dato);
    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":anyoDesde:"+anyoDesde);
    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":anyoHasta:"+anyoHasta);
    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":codProv:"+codProv);
    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":codMuni:"+codMuni);
    	}
 		
 		// obtenemos las estadisticas del municipio que ha seleccionado
 		
 	    
 		int i=0;
 		int totalEnero=0;
 		int totalFebrero=0;
 		int totalMarzo=0;
 		int totalAbril=0;
 		int totalMayo=0;
 		int totalJunio=0;
 		int totalJulio=0;
 		int totalAgosto=0;
 		int totalSeptiembre=0;
 		int totalOctubre=0;
 		int totalNoviembre=0;
 		int totalDiciembre=0;
 		int totalTotal=0;
 		
 		int totalEnero1=0;
 		int totalFebrero1=0;
 		int totalMarzo1=0;
 		int totalAbril1=0;
 		int totalMayo1=0;
 		int totalJunio1=0;
 		int totalJulio1=0;
 		int totalAgosto1=0;
 		int totalSeptiembre1=0;
 		int totalOctubre1=0;
 		int totalNoviembre1=0;
 		int totalDiciembre1=0;
 		int totalTotal1=0;
 		
 		for (i=anyoDesde;i<=anyoHasta;i++){
 			//por cada ao del intervalo, una fila de la tabla.listaEstadisticasVTM.
 			HashMap fila = new HashMap();
 			int num=0;
 			int total=0;
 			int num1=0;
 			int total1=0;
 			fila.put("anyo", String.valueOf(i) );
 			fila.put("anyo1", String.valueOf(i) );
 			//Enero
 			num = obtenerNumViviendas(i,1,tipoObra,dato,codProv,codMuni);
 			total = total + num;
 			totalEnero = totalEnero +  num;
 			num1 = obtenerNumViviendasAgrupacion(i,1,tipoObra,dato,codProv,codMuni,agrupado,tamanyoMunicipio);
 			total1 = total1 + num1;
 			totalEnero1 = totalEnero1 +  num1;
 			fila.put("enero", Integer.toString(num) );
 			fila.put("enero1", Integer.toString(num1) );
 			//Febrero
 			num = obtenerNumViviendas(i,2,tipoObra,dato,codProv,codMuni);
 			total = total + num;
 			totalFebrero = totalFebrero +  num;
 			fila.put("febrero", Integer.toString(num) );
 			num1 = obtenerNumViviendasAgrupacion(i,2,tipoObra,dato,codProv,codMuni,agrupado,tamanyoMunicipio);
 			total1 = total1 + num1;
 			totalFebrero1 = totalFebrero1 +  num1;
 			fila.put("febrero1", Integer.toString(num1) );
 			//Marzo
 			num = obtenerNumViviendas(i,3,tipoObra,dato,codProv,codMuni);
 			total = total + num;
 			totalMarzo = totalMarzo +  num;
 			fila.put("marzo", Integer.toString(num) );
 			num1 = obtenerNumViviendasAgrupacion(i,3,tipoObra,dato,codProv,codMuni,agrupado,tamanyoMunicipio);
 			total1 = total1 + num1;
 			totalMarzo1 = totalMarzo1 +  num1;
 			fila.put("marzo1", Integer.toString(num1) );
 			//Abril
 			num = obtenerNumViviendas(i,4,tipoObra,dato,codProv,codMuni);
 			total = total + num;
 			totalAbril = totalAbril +  num;
 			fila.put("abril", Integer.toString(num) );
 			num1 = obtenerNumViviendasAgrupacion(i,4,tipoObra,dato,codProv,codMuni,agrupado,tamanyoMunicipio);
 			total1 = total1 + num1;
 			totalAbril1 = totalAbril1 +  num1;
 			fila.put("abril1", Integer.toString(num1) );
 			//Mayo
 			num = obtenerNumViviendas(i,5,tipoObra,dato,codProv,codMuni);
 			total = total + num;
 			totalMayo = totalMayo +  num;
 			fila.put("mayo", Integer.toString(num) );
 			num1 = obtenerNumViviendasAgrupacion(i,5,tipoObra,dato,codProv,codMuni,agrupado,tamanyoMunicipio);
 			total1 = total1 + num1;
 			totalMayo1 = totalMayo1 +  num1;
 			fila.put("mayo1", Integer.toString(num1) );
 			//Junio
 			num = obtenerNumViviendas(i,6,tipoObra,dato,codProv,codMuni);
 			total = total + num;
 			totalJunio = totalJunio +  num;
 			fila.put("junio", Integer.toString(num) );
 			num1 = obtenerNumViviendasAgrupacion(i,6,tipoObra,dato,codProv,codMuni,agrupado,tamanyoMunicipio);
 			total1 = total1 + num1;
 			totalJunio1 = totalJunio1 +  num1;
 			fila.put("junio1", Integer.toString(num1) );
 			//Julio
 			num = obtenerNumViviendas(i,7,tipoObra,dato,codProv,codMuni);
 			total = total + num;
 			totalJulio = totalJulio +  num;
 			fila.put("julio", Integer.toString(num) );
 			num1 = obtenerNumViviendasAgrupacion(i,7,tipoObra,dato,codProv,codMuni,agrupado,tamanyoMunicipio);
 			total1 = total1 + num1;
 			totalJulio1 = totalJulio1 +  num1;
 			fila.put("julio1", Integer.toString(num1) );
 			//Agosto
 			num = obtenerNumViviendas(i,8,tipoObra,dato,codProv,codMuni);
 			total = total + num;
 			totalAgosto = totalAgosto +  num;
 			fila.put("agosto", Integer.toString(num) );
 			num1 = obtenerNumViviendasAgrupacion(i,8,tipoObra,dato,codProv,codMuni,agrupado,tamanyoMunicipio);
 			total1 = total1 + num1;
 			totalAgosto1 = totalAgosto1 +  num;
 			fila.put("agosto1", Integer.toString(num1) );
 			//Septiembre
 			num = obtenerNumViviendas(i,9,tipoObra,dato,codProv,codMuni);
 			total = total + num;
 			totalSeptiembre = totalSeptiembre + num;
 			fila.put("septiembre", Integer.toString(num) );
 			num1 = obtenerNumViviendasAgrupacion(i,9,tipoObra,dato,codProv,codMuni,agrupado,tamanyoMunicipio);
 			total1 = total1 + num1;
 			totalSeptiembre1 = totalSeptiembre1 + num1;
 			fila.put("septiembre1", Integer.toString(num1) );
 			//Octubre
 			num = obtenerNumViviendas(i,10,tipoObra,dato,codProv,codMuni);
 			total = total + num;
 			totalOctubre = totalOctubre +  num;
 			fila.put("octubre", Integer.toString(num) );
 			num1 = obtenerNumViviendasAgrupacion(i,10,tipoObra,dato,codProv,codMuni,agrupado,tamanyoMunicipio);
 			total1 = total1 + num1;
 			totalOctubre1 = totalOctubre1 +  num1;
 			fila.put("octubre1", Integer.toString(num1) );
 			//Noviembre
 			num = obtenerNumViviendas(i,11,tipoObra,dato,codProv,codMuni);
 			total = total + num;
 			totalNoviembre = totalNoviembre +  num;
 			fila.put("noviembre", Integer.toString(num) );
 			num1 = obtenerNumViviendasAgrupacion(i,11,tipoObra,dato,codProv,codMuni,agrupado,tamanyoMunicipio);
 			total1 = total1 + num1;
 			totalNoviembre1 = totalNoviembre1 +  num1;
 			fila.put("noviembre1", Integer.toString(num1) );
 			
 			num = obtenerNumViviendas(i,12,tipoObra,dato,codProv,codMuni);
 			total = total + num;
 			totalDiciembre = totalDiciembre +  num;
 			fila.put("diciembre", Integer.toString(num) );
 			num1 = obtenerNumViviendasAgrupacion(i,12,tipoObra,dato,codProv,codMuni,agrupado,tamanyoMunicipio);
 			total1 = total1 + num1;
 			totalDiciembre1 = totalDiciembre1 +  num1;
 			fila.put("diciembre1", Integer.toString(num1) );
 			
 			total = total + num;
 			totalTotal = totalTotal + total;
 			fila.put("total", Integer.toString(total) );
 			total1 = total1 + num1;
 			totalTotal1 = totalTotal1 + total1;
 			fila.put("total1", Integer.toString(total1) );
 			
 			
            listaEstadisticasVTM.add(fila);
            
 		}
    	//Aadimos la fila de total
 		HashMap total = new HashMap();
 		total.put("anyo", " " );
 		total.put("enero", Integer.toString(totalEnero) );
 		total.put("febrero", Integer.toString(totalFebrero) );
 		total.put("marzo", Integer.toString(totalMarzo) );
 		total.put("abril", Integer.toString(totalAbril) );
 		total.put("mayo", Integer.toString(totalMayo) );
 		total.put("junio", Integer.toString(totalJunio) );
 		total.put("julio", Integer.toString(totalJulio) );
 		total.put("agosto", Integer.toString(totalAgosto) );
 		total.put("septiembre", Integer.toString(totalSeptiembre) );
 		total.put("octubre", Integer.toString(totalOctubre) );
 		total.put("noviembre", Integer.toString(totalNoviembre) );
 		total.put("diciembre", Integer.toString(totalDiciembre) );
 		total.put("total", Integer.toString(totalTotal) );
 		
 		total.put("anyo1", " " );
 		total.put("enero1", Integer.toString(totalEnero1) );
 		total.put("febrero1", Integer.toString(totalFebrero1) );
 		total.put("marzo1", Integer.toString(totalMarzo1) );
 		total.put("abril1", Integer.toString(totalAbril1) );
 		total.put("mayo1", Integer.toString(totalMayo1) );
 		total.put("junio1", Integer.toString(totalJunio1) );
 		total.put("julio1", Integer.toString(totalJulio1) );
 		total.put("agosto1", Integer.toString(totalAgosto1) );
 		total.put("septiembre1", Integer.toString(totalSeptiembre1) );
 		total.put("octubre1", Integer.toString(totalOctubre1) );
 		total.put("noviembre1", Integer.toString(totalNoviembre1) );
 		total.put("diciembre1", Integer.toString(totalDiciembre1) );
 		total.put("total1", Integer.toString(totalTotal1) );
 			
 		
 		listaEstadisticasVTM.add(total);

    	
 	}catch(Exception ex){   	   
 		java.io.StringWriter sw = new java.io.StringWriter();
 		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
 		ex.printStackTrace(pw);
 		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerEstadisticas: " + sw.getBuffer ().toString());
 		throw ex;
 	    }
 	
	return listaEstadisticasVTM;
}
	
	public int obtenerNumViviendas(int anoy,int mes, String tipoObra, String dato, String codProv,String codMuni) throws Exception{
		int num=0;
		ResultSet rs = null;
	   	PreparedStatement prepStmt =null;	
	   	StringBuffer query = null;
	   
	try{
		if (tr.isTraceActive()){
    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNumViviendas:inicio");
    	}
		query = new StringBuffer("");
		if (dato.equalsIgnoreCase("0")){
			query.append("select count(*) from q022dt00,q022bt00 where q022dt00.Q022BT00_ID_GRUPO = q022bt00.Q022BT00_ID_GRUPO "); 
		}else if (dato.equalsIgnoreCase("1")){
			query.append("select sum(Q022DT00_NVN) from q022dt00,q022bt00 where q022dt00.Q022BT00_ID_GRUPO = q022bt00.Q022BT00_ID_GRUPO ");
		}else if (dato.equalsIgnoreCase("2")){
			query.append("select sum(Q022DT00_NVR) from q022dt00,q022bt00 where q022dt00.Q022BT00_ID_GRUPO = q022bt00.Q022BT00_ID_GRUPO ");
		}
		
		// tipo obra, hay que convertir lo que viene de los rb: 0 - nueva, 1-rehab, 2-demol
		//a lo que hay en BD: tipo obra: 3 - rehab, 2 - demol, 1 - nueva
		
		String tipoobraBD = "";
		if ((tipoObra!=null)&&(tipoObra!="")){
			if (tipoObra.equalsIgnoreCase("0")){
				tipoobraBD = "1";
			}else if (tipoObra.equalsIgnoreCase("1")){
				tipoobraBD = "3";
			}else if (tipoObra.equalsIgnoreCase("2")){
				tipoobraBD = "2";
			}
		}
		
		if (tipoobraBD!=""){
			query.append(" and q022dt00.Q022DT00_TIPO_OBRA = '").append(tipoobraBD).append("'");
		}
		query.append(" and q022bt00.Q022BT00_ANO = '").append(anoy).append("'");
		query.append(" and q022bt00.Q022BT00_MES= '").append(mes).append("'");
		query.append(" and q022bt00.FCA02T00_CODPROVINC= '").append(codProv).append("'");
		query.append(" and q022bt00.FCA02T00_CODMUNICIP= '").append(codMuni).append("'");
		
		
    	prepStmt = this.getConnection().prepareStatement(query.toString());
    	rs = prepStmt.executeQuery(); 
        
	 		if(rs.next()){
	 			num = rs.getInt(1);
			}
	}catch(Exception ex){   	   
 		java.io.StringWriter sw = new java.io.StringWriter();
 		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
 		ex.printStackTrace(pw);
 		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerNumViviendas: " + sw.getBuffer ().toString());
 		throw ex;
 	    }
 	finally{ 
 		try{
			if (rs!=null){
 				rs.close();
            }
 			if (prepStmt!=null){
 				prepStmt.close();
            }
         }
 		catch(Exception ex){
	    	  java.io.StringWriter sw = new java.io.StringWriter();
	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	          ex.printStackTrace(pw);
	          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerNumViviendas: " + sw.getBuffer ().toString());
	          throw new Q02aDAOException(ex);
         }
 	}
 	if (tr.isTraceActive()){
		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":num: "+num);
	}
		return num;
	}
	
	
	/**
	 * 
	 * @param anyo
	 * @param mes
	 * @param tipoObra
	 * @param dato
	 * @param codProv
	 * @param codMuni
	 * @param agrupado
	 * @return
	 * @throws Exception
	 */
	public int obtenerNumViviendasAgrupacion(int anyo,int mes, String tipoObra, String dato, String codProv,String codMuni,String agrupado, String tamanyoMun) throws Exception{
		int num=0;
		int idAux=0;
		ResultSet rs = null;
	   	PreparedStatement prepStmt =null;	
	   	StringBuffer query = null;
		StringBuffer queryMun = null;
	try{
		if (tr.isTraceActive()){
    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNumViviendasAgrupacion:inicio");
    	}
		query = new StringBuffer("");
		if (dato.equalsIgnoreCase("0")){
			query.append("select count(*) from q022dt00,q022bt00 where q022dt00.Q022BT00_ID_GRUPO = q022bt00.Q022BT00_ID_GRUPO "); 
		}else if (dato.equalsIgnoreCase("1")){
			query.append("select sum(Q022DT00_NVN) from q022dt00,q022bt00 where q022dt00.Q022BT00_ID_GRUPO = q022bt00.Q022BT00_ID_GRUPO ");
		}else if (dato.equalsIgnoreCase("2")){
			query.append("select sum(Q022DT00_NVR) from q022dt00,q022bt00 where q022dt00.Q022BT00_ID_GRUPO = q022bt00.Q022BT00_ID_GRUPO ");
		}
		
		// tipo obra, hay que convertir lo que viene de los rb: 0 - nueva, 1-rehab, 2-demol
		//a lo que hay en BD: tipo obra: 3 - rehab, 2 - demol, 1 - nueva
		
		String tipoobraBD = "";
		if ((tipoObra!=null)&&(tipoObra!="")){
			if (tipoObra.equalsIgnoreCase("0")){
				tipoobraBD = "1";
			}else if (tipoObra.equalsIgnoreCase("1")){
				tipoobraBD = "3";
			}else if (tipoObra.equalsIgnoreCase("2")){
				tipoobraBD = "2";
			}
		}
		
		if (tipoobraBD!=""){
			query.append(" and q022dt00.Q022DT00_TIPO_OBRA = '").append(tipoobraBD).append("'");
		}
		query.append(" and q022bt00.Q022BT00_ANO = '").append(anyo).append("'");
		query.append(" and q022bt00.Q022BT00_MES= '").append(mes).append("'");
		query.append(" and q022bt00.FCA02T00_CODPROVINC= '").append(codProv).append("'");
		
		//agrupado 0-comarca,1-area funcional,2-tamao municipio
		//query.append(" and q022bt00.FCA02T00_CODMUNICIP= '").append(codMuni).append("'");
		if (agrupado.equalsIgnoreCase("0")){
			queryMun = new StringBuffer("");
			queryMun.append("select COMARCA_ID from Q0298s00 where TH_ID = ").append(codProv);
			queryMun.append(" and MUNICIPIO_ID = ").append(codMuni);
			prepStmt = this.getConnection().prepareStatement(queryMun.toString());
	    	rs = prepStmt.executeQuery(); 
	        	if(rs.next()){
		 			idAux = rs.getInt(1);
				}
	        	query.append(" and q022bt00.FCA02T00_CODMUNICIP IN (select MUNICIPIO_ID from ").append(
	        			"Q0298s00 where COMARCA_ID = ").append(idAux).append(" )");
		}
		if (agrupado.equalsIgnoreCase("1")){
			queryMun = new StringBuffer("");
			queryMun.append("select AF_ID from Q0298s00 where TH_ID = ").append(codProv);
			queryMun.append(" and MUNICIPIO_ID = ").append(codMuni);
			prepStmt = this.getConnection().prepareStatement(queryMun.toString());
	    	rs = prepStmt.executeQuery(); 
	        	if(rs.next()){
		 			idAux = rs.getInt(1);
				}
	        	query.append(" and q022bt00.FCA02T00_CODMUNICIP IN (select MUNICIPIO_ID from ").append(
	        			"Q0298s00 where AF_ID = ").append(idAux).append(" )");
			
		}
		if (agrupado.equalsIgnoreCase("2")){
			queryMun = new StringBuffer("");
			//[JBHG] 2016/08/08 Parche para poder seleccionar el tamao de los municipios a agrupar.
			if(StringUtils.isEmpty(tamanyoMun)){
				queryMun.append("select TAMANO_ID from Q0298s00 where TH_ID = ").append(codProv);
				queryMun.append(" and MUNICIPIO_ID = ").append(codMuni);
				prepStmt = this.getConnection().prepareStatement(queryMun.toString());
		    	rs = prepStmt.executeQuery(); 
	        	if(rs.next()){
		 			idAux = rs.getInt(1);
				}
			}else{
				idAux = Integer.parseInt(tamanyoMun);
			}
			
        	query.append(" and q022bt00.FCA02T00_CODMUNICIP IN (select MUNICIPIO_ID from ").append(
        			"Q0298s00 where TAMANO_ID = ").append(idAux).append(" )");
			
		}
		
		
    	prepStmt = this.getConnection().prepareStatement(query.toString());
    	
    	String laSelect = query.toString();
    	
    	if (tr.isTraceActive()){
    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":query.toString():" + laSelect.substring(0, 150));
    	}
    	if (tr.isTraceActive()){
    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":query.toString():" + laSelect.substring(150, query.toString().length()));
    	}
    	
    	rs = prepStmt.executeQuery(); 
        
	 		if(rs.next()){
	 			num = rs.getInt(1);
			}
	}catch(Exception ex){   	   
 		java.io.StringWriter sw = new java.io.StringWriter();
 		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
 		ex.printStackTrace(pw);
 		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerNumViviendasAgrupacion: " + sw.getBuffer ().toString());
 		throw ex;
 	    }
 	finally{ 
 		try{
			if (rs!=null){
 				rs.close();
            }
 			if (prepStmt!=null){
 				prepStmt.close();
            }
         }
 		catch(Exception ex){
	    	  java.io.StringWriter sw = new java.io.StringWriter();
	          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	          ex.printStackTrace(pw);
	          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerNumViviendasAgrupacion: " + sw.getBuffer ().toString());
	          throw new Q02aDAOException(ex);
         }
 	}
 	if (tr.isTraceActive()){
		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":num: "+num);
	}
		return num ;
	}
	
	


     /**
      * 
      * @param cuestionariosVTMFiltro cuestionariosVTMFiltro
      * @return idGrupo
      * @throws Exception Exception
      */
     public String obtenerIdGrupoCuestionariosVTM(Q02aCuestionarioVTMFiltro cuestionariosVTMFiltro) 
     throws Exception {

     	ResultSet rs = null;
     	String idGrupo=null;
     	Q02aTablaBDQ022BS00 tablaBDGrupoCuestionariosVTM = null;

     	try{
 		    	if (tr.isTraceActive()){
 		    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerIdGrupoCuestionariosSM: entrando");
 		    	}

 		    	tablaBDGrupoCuestionariosVTM = new Q02aTablaBDQ022BS00(this.getConnection());
                tablaBDGrupoCuestionariosVTM.addColumnSelect(Q02aTablaBDQ022BS00.NOMCOLUMN_Q022BT00_ID_GRUPO);
                tablaBDGrupoCuestionariosVTM.setQ022BT00_ANO_WHERE(Q02aFormatData.checkIntegerNull(cuestionariosVTMFiltro.getAno()));
                tablaBDGrupoCuestionariosVTM.setFCA02T00_CODPROVINC_WHERE(Q02aFormatData.checkStringNull(cuestionariosVTMFiltro.getCodProv()));
                tablaBDGrupoCuestionariosVTM.setFCA02T00_CODMUNICIP_WHERE(Q02aFormatData.checkStringNull(cuestionariosVTMFiltro.getCodMuni()));
                tablaBDGrupoCuestionariosVTM.setQ022BT00_CONCEDIDO_LICEN_WHERE(1);
                tablaBDGrupoCuestionariosVTM.setQ022BT00_MES_WHERE(Q02aFormatData.checkIntegerNull(cuestionariosVTMFiltro.getMes()));
                
                rs=tablaBDGrupoCuestionariosVTM.select();
                tablaBDGrupoCuestionariosVTM.addResultSet(rs);

 			   	if(rs.next()){
 			   		idGrupo =rs.getString(Q02aTablaBDQ022BS00.NOMCOLUMN_Q022BT00_ID_GRUPO);
 			   	}

 			   	if (tr.isTraceActive()){
 		    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerIdGrupoCuestionariosSM: saliendo");
 		    	}

 			   	return idGrupo;

 		 } catch(Exception ex){   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerIdGrupoCuestionariosSM: " + sw.getBuffer ().toString());
     		throw ex;
     	  }finally{
              
       		try{
       			tablaBDGrupoCuestionariosVTM.freeResourcesNotConnection();	
       		}catch(Exception ex){
       			 if (tr.isTraceActive()){
       				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerIdGrupoCuestionariosSM: error liberando recursos");
   		   	     }  
       		}
     	 }
     }

     /**
      * 
      * @param cuestionariosVTMFiltro cuestionariosVTMFiltro
      * @return idGrupo
      * @throws Exception Exception
      */
     public String obtenerMiGrupoCuestionariosVTM(Q02aCuestionarioVTMFiltro cuestionariosVTMFiltro) 
     throws Exception {

        ResultSet rs = null;
        String idGrupo=null;
        Q02aTablaBDQ022BS00 tablaBDGrupoCuestionariosVTM = null;

        try{
                if (tr.isTraceActive()){
                    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerIdGrupoCuestionariosSM: entrando");
                }

                tablaBDGrupoCuestionariosVTM = new Q02aTablaBDQ022BS00(this.getConnection());
                tablaBDGrupoCuestionariosVTM.addColumnSelect(Q02aTablaBDQ022BS00.NOMCOLUMN_Q022BT00_ID_GRUPO);
                tablaBDGrupoCuestionariosVTM.setQ022BT00_ANO_WHERE(Q02aFormatData.checkIntegerNull(cuestionariosVTMFiltro.getAno()));
                tablaBDGrupoCuestionariosVTM.setFCA02T00_CODPROVINC_WHERE(Q02aFormatData.checkStringNull(cuestionariosVTMFiltro.getCodProv()));
                tablaBDGrupoCuestionariosVTM.setFCA02T00_CODMUNICIP_WHERE(Q02aFormatData.checkStringNull(cuestionariosVTMFiltro.getCodMuni()));
                tablaBDGrupoCuestionariosVTM.setQ022BT00_MES_WHERE(Q02aFormatData.checkIntegerNull(cuestionariosVTMFiltro.getMes()));
                
                rs=tablaBDGrupoCuestionariosVTM.select();
                tablaBDGrupoCuestionariosVTM.addResultSet(rs);

                if(rs.next()){
                    idGrupo =rs.getString(Q02aTablaBDQ022BS00.NOMCOLUMN_Q022BT00_ID_GRUPO);
                }

                if (tr.isTraceActive()){
                    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerIdGrupoCuestionariosSM: saliendo");
                }

                return idGrupo;

         } catch(Exception ex){        
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerIdGrupoCuestionariosSM: " + sw.getBuffer ().toString());
            throw ex;
          }finally{
              
            try{
                tablaBDGrupoCuestionariosVTM.freeResourcesNotConnection();  
            }catch(Exception ex){
                 if (tr.isTraceActive()){
                    tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerIdGrupoCuestionariosSM: error liberando recursos");
                 }  
            }
         }
     }
     
     /**
      * 
      * @param territorio territorio
      * @param municipio municipio
      * @param anyoReferencia anyoReferencia
      * @param mesReferencia mesReferencia
      * @return resultado
      * @throws Exception Exception
      */
     public String getNiGrupoCuesVTM(String territorio, String municipio, String anyoReferencia, String mesReferencia) throws Exception
 	{
 		//se definen objetos necesarios. 	
       	Q02aTablaBDQ022BS00 tablaBDGrupoCuestionariosVTMAnu = null;
       	int niGrupoCuesVTMAnu = 0;
       	String resultado = "";
       	ResultSet rs = null;
       	
       	try{
 	    	if (tr.isTraceActive())
 	    	{
 	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNiGrupoCuesVTM: entrando");
 	   	}
    		//se crea el objeto de tablasBD
 	    	
 	    	tablaBDGrupoCuestionariosVTMAnu = new Q02aTablaBDQ022BS00(this.getConnection());
      		

 	    	

 	    	tablaBDGrupoCuestionariosVTMAnu.setQ022BT00_ANO_WHERE(Integer.parseInt(anyoReferencia));

 		   	tablaBDGrupoCuestionariosVTMAnu.setFCA02T00_CODPROVINC_WHERE(territorio);

 		   	tablaBDGrupoCuestionariosVTMAnu.setFCA02T00_CODMUNICIP_WHERE(municipio);

 		   	tablaBDGrupoCuestionariosVTMAnu.setQ022BT00_MES_WHERE(Integer.parseInt(mesReferencia));

 	   	

 		   	rs=tablaBDGrupoCuestionariosVTMAnu.select();

 		   	tablaBDGrupoCuestionariosVTMAnu.addResultSet(rs);

 		   	if (rs.next()){

 		   		niGrupoCuesVTMAnu = rs.getInt(1);

          	}	 

 		    if (niGrupoCuesVTMAnu==0){

 		    	resultado="";

 		    }

 		    else {

       			resultado = Integer.toString(niGrupoCuesVTMAnu);;

 		    }

      		return resultado;

     	}

     	catch(Exception ex)

     	{   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNiGrupoCuesVTM: " + sw.getBuffer ().toString());

     		throw ex;

     	}

     	finally

     	{

     		try

     		{

     			tablaBDGrupoCuestionariosVTMAnu.freeResourcesNotConnection();	

     		}

     		catch(Exception ex)

     		{

     			if (tr.isTraceActive())

     			{

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNiGrupoCuesVTM: error liberando recursos");

 		   	 }  

 		}  		

 		if (tr.isTraceActive())

 		{

 			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNiGrupoCuesVTM: saliendo");                

    		}       	

     	}

 	}

    /**
     * 
     * @param niGrupoCuestionarioVTMAnu niGrupoCuestionarioVTMAnu
     * @return numCuestionariosVTM
     * @throws Exception Exception
     */
    public int getNumCuestionariosVTM(String niGrupoCuestionarioVTMAnu) throws Exception 
     {
    	int numCuestionariosVTM=0;
    	ResultSet rs = null;
       	PreparedStatement prepStmt =null;	
       	StringBuffer query = null;
     	try{
	    	if (tr.isTraceActive()){
	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosVTM: entrando");
	    	}

	    	query = new StringBuffer("SELECT COUNT(*) FROM Q022DS00 WHERE");
        	query.append(" Q022BT00_ID_GRUPO =").append(niGrupoCuestionarioVTMAnu);
        	prepStmt = this.getConnection().prepareStatement(query.toString());
        	rs = prepStmt.executeQuery(); 
            
   	 		if(rs.next()){
   	 				numCuestionariosVTM = rs.getInt(1);
 			}

		   	if (tr.isTraceActive()){
		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosVTM: saliendo");
	   		}
	        return numCuestionariosVTM;

	       }

     	catch(Exception ex){   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosVTM: " + sw.getBuffer ().toString());
     		throw ex;
     	    }
     	finally{ 
     		try{
    			if (rs!=null){
     				rs.close();
                }
     			if (prepStmt!=null){
     				prepStmt.close();
                }
	         }
     		catch(Exception ex){
		    	  java.io.StringWriter sw = new java.io.StringWriter();
		          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
		          ex.printStackTrace(pw);
		          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosVTM: " + sw.getBuffer ().toString());
		          throw new Q02aDAOException(ex);
	         }
     	}
	 }//fin getNumCuestionariosVTM 

    /**
     * Mtodo que dado la clave de Licencia para una prov y municipo comprueba si existe en BBDD
     * los datos de dicho cuestionarioVTMAnu.
     * @param claveLicen claveLicen
     * @param codMuni codMuni
     * @param codProv codProv
     * @throws Exception Exception
     * @return 0  no existe licencia / 1 existe clave
     */   
    public String obtenerClavelicencia(String claveLicen, String codMuni, String codProv) throws Exception {		

		//se instancian los objetos necesarios para realizar la consulta.			
		Q02aTablaBDQ022DS01V02 vistaBDCuestionariosVTM = null;
		ResultSet rs = null;
		//ArrayList listaCuestionariosVTM = new ArrayList();		
//		Q02aCuestionarioVTMAnu cuestionarioVTM;
		String resultado = "";

		try{
	    	if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerClavelicencia: entrando");
			}
	    	//se instancia la clase del tablas bd a llamar pasandole la conexion	    	
	    	vistaBDCuestionariosVTM = new Q02aTablaBDQ022DS01V02(this.getConnection());
	    	//rellenamos la where con los datos del filtro de usuarioTODO
	    	//this.rellenaFiltroCuestionarioVTM(niGrupoCuesVTM, vistaBDCuestionariosVTM);
	    	//if (!Q02aFormatData.esVacio(niGrupoCuesVTM)){
	    	vistaBDCuestionariosVTM.setQ022DT00_IDEN_LICEN_WHERE(claveLicen);
	    	vistaBDCuestionariosVTM.setFCA02T00_CODMUNICIP_WHERE(codMuni);
	    	vistaBDCuestionariosVTM.setFCA02T00_CODPROVINC_WHERE(codProv);
	    	vistaBDCuestionariosVTM.setQ022DT00_ESTADO_LICEN_WHERE("A");
    		//}	
	    	
	    	//se realiza la select
	    	rs = vistaBDCuestionariosVTM.selectCount() ;	    	
	    	//aadimos el cursos para luego poder liberarlo ( en el freeResources)
	    	vistaBDCuestionariosVTM.addResultSet(rs); 
	    	//se trata el resultado obtenido aadiendolo a la lista de salida
	    	if (rs.next() && rs.getInt(1)>0 ){
	    		resultado = "1";
          	}else{	  		    
       			resultado = "0";
 		    }
      		return resultado; 	
		}catch(Exception ex){ 	   
    		java.io.StringWriter sw = new java.io.StringWriter();
    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
    		ex.printStackTrace(pw);
    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerClavelicencia: " + sw.getBuffer ().toString());
    		throw ex;
		}finally{
			try {
				// liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet
				vistaBDCuestionariosVTM.freeResourcesNotConnection();
			} catch (Exception ex) {
				if (tr.isTraceActive()) {
					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerClavelicencia: error liberando recursos.");
				}
			}
			if (tr.isTraceActive()) {
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerClavelicencia: saliendo.");
			}
		}	

	}

    
    /**
     * 
     * @param portal portal
     * @return idEntidad
     * @throws Exception Exception
     */
    public String getEntidad(String portal) throws Exception 
    {
   	//int numCuestionariosVTM=0;
    	String idEntidad="";
   	ResultSet rs = null;
      	PreparedStatement prepStmt =null;	
      	StringBuffer query = null;
    	try{
	    	if (tr.isTraceActive())
	    		{
	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getEntidad: entrando");
	    		}
	    	query = new StringBuffer("SELECT LOCALIDAD_ID FROM NORA_T17_PORTAL WHERE");
       	    query.append(" ID =").append(portal);
       	    prepStmt = this.getConnection().prepareStatement(query.toString());
       	    rs = prepStmt.executeQuery(); 
  	 		if(rs.next()){
  	 			idEntidad = rs.getString("LOCALIDAD_ID");
  	 		}
		   	if (tr.isTraceActive()){
		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getEntidad: saliendo");
		   	}
	        return idEntidad;
	       }

    	catch(Exception ex){   	   
    		java.io.StringWriter sw = new java.io.StringWriter();
    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
    		ex.printStackTrace(pw);
    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getEntidad: " + sw.getBuffer ().toString());
    		throw ex;
    	}finally{ 
    		try{
    			if (rs!=null){
    				rs.close();
                }
    			if (prepStmt!=null){
    				prepStmt.close();
                }
	         }
    		catch(Exception ex){
		    	  java.io.StringWriter sw = new java.io.StringWriter();
		          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
		          ex.printStackTrace(pw);
		          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getEntidad: " + sw.getBuffer ().toString());
		          throw new Q02aDAOException(ex);
	         }
    	}
	 }//fin getNumCuestionariosVTM 
    
}
