package q02a.exe.cuestionariosSMAnu.launcher;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;

import q02a.exe.arquitectura.beans.Q02aBaseBean;
import q02a.exe.arquitectura.dataobjects.Q02aDAOException;
import q02a.exe.arquitectura.webCommon.beans.Q02aProcessLauncherBean;
import q02a.exe.arquitectura.webCommon.utils.gdtp.Q02aGenericDataTransferProtocol;


import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;


//import q02a.exe.cuestionariosAyunMen.beans.Q02aCuestionariosAyunMenBean;
import q02a.exe.cuestionariosSMAnu.beans.Q02aCuestionariosSMBean;

/**
 * 
 * @author GADIMAAR
 *
 */
public class Q02aCuestionariosSMLauncher extends Q02aBaseBean implements Q02aProcessLauncherBean {

	/**
	 * 
	 */
	private static final long serialVersionUID = 1677342344158205416L;
	/** Objeto tablaBD usado para buscar en base de datos */
	//protected TablaBDWWHISPLA tablaHISPLA=null;

	private static Q70Traza tr = Q70Traza.getSingleton();
	private static final String COMPONENTE = "DAO_CUESTIONARIOS_SM_ANU_ACCESO_DATOS";
	
	//Q70ContextoEJIE q70contextoejie = (Q70ContextoEJIE)request.getSession().getAttribute("contexto");
	//ArrayList listaCues= (ArrayList)q70contextoejie.get("listaCuestionariosSMAnu");
	
	private  String user = ""; 
	/**
     *  Constructor vaco
     */

	 /* (non-Javadoc)
     * @see com.bbk.arquitectura.webCommon.beans.ProcessLauncherBean#initProcessLauncherBean(javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     */
	/**
     * @param request request
     * @param response response
     * 
     * @throws Q02aDAOException Q02aDAOException
	 */
    public void initProcessLauncherBean(HttpServletRequest request, HttpServletResponse response)
    throws Q02aDAOException {

		init(request,response);

    }

	/* (non-Javadoc)
     * @see com.bbk.arquitectura.webCommon.beans.ProcessLauncherBean#initProcessLauncherBean(javax.servlet.jsp.PageContext)
     */
    /**
     * @param context context
     * @throws Q02aDAOException Q02aDAOException
     */
    public void initProcessLauncherBean(PageContext context) throws Q02aDAOException {
    	this.request = (HttpServletRequest)context.getRequest();
    	this.response =(HttpServletResponse)context.getResponse(); 	
    }

    /**
     * @return generic
     * @throws Exception Exception
     */
	 public Q02aGenericDataTransferProtocol launch() throws Exception {
    	try{	       
	            if (tr.isTraceActive()) {
	                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":launch: entrando");
	             }

                String proceso = getParametro("METHOD");
	            if (proceso.equals("getAnosMesesPendientes")){
	            	return this.getAnosMesesPendientes();
	            }else if (proceso.equals("obtenerCampoPrevSueloDeGrupoConMuniAnoMes")){
	            	return this.obtenerCampoPrevSueloDeGrupoConMuniAnoMes();
	            }else if (proceso.equals("guardarFirmaCuestionariosSMAnu")){
	            	return this.guardarFirmaCuestionariosSMAnu();
	            }	           
	            return null;
    	}
    	catch(Exception e){
	           return this.processException(e);
        	}
     }

     /**
    * Mtodo que llama al Bean de CuestionariosSMAnu que obtiene el campo Prevision Suelo para el grupo del municipio y ao seleccionados
    * @return result
    * @throws Exception Exception
    */
   public Q02aGenericDataTransferProtocol obtenerCampoPrevSueloDeGrupoConMuniAnoMes() throws Exception {
    	
    	if (tr.isTraceActive()){
    	    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoPrevSueloDeGrupoConMuniAnoMes: entrando");
    	}
    	
    	Q02aGenericDataTransferProtocol result = new Q02aGenericDataTransferProtocol(); 
    	Q02aCuestionariosSMBean beanCuestionariosSMAnu = new Q02aCuestionariosSMBean();
    	
        try{ 
        
        	String codProv = ((String)getMapaDatos().get("codProv"));
        	String codMuni = ((String)getMapaDatos().get("codMuni"));
        	String ano = ((String)getMapaDatos().get("ano"));
        	String mes = ((String)getMapaDatos().get("mes"));
        	String tipoCuestionario = ((String)getMapaDatos().get("tipoCuestionario"));
        	String prevSuelo = beanCuestionariosSMAnu.obtenerCampoPrevSueloDeGrupoConMuniAno(codProv,codMuni,ano,mes,tipoCuestionario);         	 
        	boolean hayCuestionarios = false;
        	if (prevSuelo.equals("0") || prevSuelo.equals("null"))
 			{
 				hayCuestionarios = false;
 			}
 			else
 			{
 				hayCuestionarios = beanCuestionariosSMAnu.obtenerNumCuestionarios(codProv,codMuni,ano,mes,tipoCuestionario);
 			}
 			Boolean hayCues = new Boolean(hayCuestionarios); 			 
 			String hayCu = hayCues.toString();
        	
		 	result.addGroup("RESULT_1"); 
		 	result.addProperty("RESULT_1","RESULT","OK");
		 	result.addProperty("RESULT_1","PREV_SUELO", prevSuelo);
		 	result.addProperty("RESULT_1","HAY_CUESTIONARIOS", hayCu);

            tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoPrevSueloDeGrupoConMuniAnoMes: hola");			
        	return result;

        

       }catch(Exception ex){
            result.addProperty("RESULT_1","RESULT","NOOK");
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoPrevSueloDeGrupoConMuniAnoMes: " + sw.getBuffer ().toString());
            throw new Q02aDAOException(ex);
       }finally{
    	   if (tr.isTraceActive()){
    		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoPrevSueloDeGrupoConMuniAnoMes: saliendo");                
           }
       }

   }
   

   /**
    * Mtodo que llama al Bean de CuestionariosSMAnu que obtiene los  aos que no se han introducido cuestionarios para el municipio y ao seleccionados
    * @return result
    * @throws Exception Exception
    */
   public Q02aGenericDataTransferProtocol getAnosMesesPendientes() throws Exception {
    	if (tr.isTraceActive())
    	{
		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getAnosPendientes: entrando");
	}
    	
    	Q02aGenericDataTransferProtocol result = new Q02aGenericDataTransferProtocol(); 
    	Q02aCuestionariosSMBean beanCuestionariosSMAnu = new Q02aCuestionariosSMBean();
    	
        try{ 
        
        	String codProv = ((String)getMapaDatos().get("codProv"));
        	String codMuni = ((String)getMapaDatos().get("codMuni"));
        	String ano = ((String)getMapaDatos().get("ano"));
        	String idioma = ((String)getMapaDatos().get("idioma"));
        	
        	String msgMeses = beanCuestionariosSMAnu.obtenerAnosMesesPendientes(codProv,codMuni,ano,idioma);         	 
 			 
        	result.addGroup("RESULT_1"); 			
        	result.addProperty("RESULT_1","RESULT","OK");
        	result.addProperty("RESULT_1","MSG_MESES", msgMeses);

        	return result;
       }catch(Exception ex){
            result.addProperty("RESULT_1","RESULT","NOOK");
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getAnosMesesPendientes: " + sw.getBuffer ().toString());
            throw new Q02aDAOException(ex);
       }finally{
    	   if (tr.isTraceActive()){
    		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getAnosMesesPendientes: saliendo");                
           }
       }

   }

   /**
    * Mtodo que llama al Bean de CuestionariosSMAnu para guardar la firma del grupo de cuestionarios
    * @return result
    * @throws Exception Exception
    */

   public Q02aGenericDataTransferProtocol guardarFirmaCuestionariosSMAnu() throws Exception 
   {
    	
    	if (tr.isTraceActive())
    	{
		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaCuestionariosSMAnu: entrando");
	}
   	
    	Q02aGenericDataTransferProtocol result = new Q02aGenericDataTransferProtocol(); 
    	Q02aCuestionariosSMBean beanCuestionariosSMAnu = new Q02aCuestionariosSMBean();
    	
        try{ 
        
        	String niGrupoCuesSMAnu = ((String)getMapaDatos().get("niGrupoCuesSMAnu"));
        	String xmlFirmaGrupoCuesSMAnu = ((String)getMapaDatos().get("xmlFirmaGrupoCuesSMAnu"));
        	
        	beanCuestionariosSMAnu.guardarFirmaGrupoCuestionariosSMAnu(niGrupoCuesSMAnu,xmlFirmaGrupoCuesSMAnu);         	 
 			 
 		result.addGroup("RESULT_1"); 				
 		result.addProperty("RESULT_1","RESULT","OK");
						
        	return result;
        
       }catch(Exception ex){
            result.addProperty("RESULT_1","RESULT","NOOK");
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":guardarFirmaCuestionariosSMAnu: " + sw.getBuffer ().toString());
            throw new Q02aDAOException(ex);
       }finally{
    	   if (tr.isTraceActive()){
    		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaCuestionariosSMAnu: saliendo");                
           }
   	   
       }

   }

}