package q02a.exe.cuestionariosSMAnu.dataobjects;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
//import java.util.Vector;

import q02a.exe.arquitectura.dataobjects.Q02aDAOException;
import q02a.exe.arquitectura.dataobjects.Q02aDataBaseDAO;
import q02a.exe.cuestionariosSMAnu.valueobjects.Q02aCuestionarioSM;
import q02a.exe.cuestionariosSMAnu.valueobjects.Q02aCuestionarioSMFiltro;
import q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMFiltro;
//import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022AS00;
//import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022BS00;
//import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022AV00;
//import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022BV00;
import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022CS00;
//import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022DS00;
import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022BS00;
import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022DS00;
import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022ES00;
import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022ES01V02;
//import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022GS00;
import q02a.exe.utils.Q02aConstantes;
import q02a.exe.utils.Q02aFormatData;
import q02a.exe.utils.Q02aAplicationUtils;
//import q02a.exe.utils.Q02aVoUtils;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
//import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import q02a.exe.utils.oracle.Q02aBDUtilidades;

/**
 * 
 * @author GADIMAAR
 *
 */
public class Q02aCuestionariosSMDataBaseDAO extends Q02aDataBaseDAO{

	private static final long serialVersionUID = -8520551641771839103L;
	private static Q70Traza tr = Q70Traza.getSingleton();
	private static final String COMPONENTE = "DAO_ACCESO_DATOS";
	private static final String RECURSOS_CUES_SM_ANU = "q02arecursosCuestionarios";

	/**
     */
	public Q02aCuestionariosSMDataBaseDAO() {
        super();                
    }

    /**
     * @param conn conn
     */
    public Q02aCuestionariosSMDataBaseDAO(Connection conn) {
    	super(conn);     
    }
    
    /**
     * @param cuestionarioSMAnu cuestionarioSMAnu
     */
    public void cambiarComa(Q02aCuestionarioSM cuestionarioSMAnu)
    {
    	boolean fin = false;
	    String aux = new String();
	    String ppe = cuestionarioSMAnu.getCosteSuelo().toString();
		
		while ( ( ppe.length() > 0) && !fin) {
				if (ppe.indexOf(',') != -1 ) {	
					int indice2 = ppe.indexOf( ',');
					aux = aux.concat( ppe.substring( 0, indice2));
					aux = aux.concat(".");
					aux = aux.concat(ppe.substring( indice2 + 1, ppe.length()));
					fin = true;
				}else{
					aux = ppe;
					fin=true;
				}
		}	
		cuestionarioSMAnu.setCosteSuelo(aux);
    }

    /**
     * 
     * @param cuestionarioSMAnu cuestionarioSMAnu
     */
    public void cambiarPunto(Q02aCuestionarioSM cuestionarioSMAnu)  {
    	
    	boolean fin = false;
    	String aux = new String();
    	String ppe = cuestionarioSMAnu.getCosteSuelo().toString();
    	
    	while ((ppe.length() > 0) && !fin) 
    	{
    		if (ppe.indexOf('.') != -1) 
    		{	
    			int indice2 = ppe.indexOf('.');
    			aux = aux.concat(ppe.substring(0, indice2));
    			aux = aux.concat(",");
    			aux = aux.concat(ppe.substring(indice2 + 1, ppe.length()));
    			fin = true;
    		}else{
    			aux = ppe;
    			fin=true;
    		}
    	}
    	cuestionarioSMAnu.setCosteSuelo(aux);	
    }

    /**
     * 
     * @param cuestionarioSMAnu cuestionarioSMAnu
     * @param cero cero
     */
    public void formatearNumero (Q02aCuestionarioSM cuestionarioSMAnu, String cero) {
    	//valor = trim (valor);
    	String valor = cuestionarioSMAnu.getCosteSuelo();
    	String numero  = valor.trim();
    	String aux     = new String();
    	String entera  = new String();
    	String decimal = new String();
    	String finales = new String();
    	String final1  = new String();
    	boolean fin     = false;    	
    	boolean esCero  = true;
    	String resto   = new String();
    	//quita los ceros por delante:
    	
    	if (numero.equals("")){
    	    if (cero.equals("S")){ 
    		    numero = "0";
    		} else{ 
    		    numero="";
    		}
    	} else {	
    		while(esCero) {
    			if (numero.charAt( 0) == '0') {
    			    if (numero.length() == 1){
    			        numero = "0";
    			        esCero = false;
    			    } else {
    				    numero = numero.substring(1, numero.length());
    				}
    			} else {
    			    if (numero.charAt( 0) == ',') {
    			        numero = "0" + numero;
    			    }
    				esCero = false;
    			}		
    		}    		
    		//le quita los puntos que ya tenga puestos
    		while ( numero.length() > 0 && fin == false) {
    			if ( numero.indexOf( '.') != -1) {	
    				int indice = numero.indexOf('.');
    				aux = aux.concat( numero.substring( 0, indice));								
    				numero = numero.substring( indice + 1, numero.length());
    			} else {
    				aux = aux.concat( numero);
    				fin = true;
    			}	
    		}
    		//guardamos los decimales:
    		int indice = aux.indexOf(',');
    		if ( indice!=-1) {
    			entera = aux.substring( 0, indice);
    			decimal = aux.substring( indice, aux.length());	
    		} else {
    			entera  = aux;
    			decimal = "";
    		}
    		
    		//ponemos los puntos de los miles:
    		while( entera.length() > 3){
    			int longitud = entera.length();
    			resto   = entera.substring( longitud-3, longitud);
    			entera  = entera.substring( 0, entera.lastIndexOf( resto));
    			finales = "." + resto + finales;
    		}
    	   
    		final1 = final1.concat(entera).concat(finales).concat(decimal);
    		numero = final1;
        }
    	cuestionarioSMAnu.setCosteSuelo(numero);
    	
    }
    
     /**
     * Mtodo que compone la where para hacer la consulta
     * @param 
     * @return where 
     * @throws Exception
     */
    /*public String componerFiltroCuestionarioSMAnu() throws Exception {
    	StringBuffer where = new StringBuffer();
    	try{
    		if (tr.isTraceActive())
    		{
		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":componerFiltroCuestionarioSMAnu: entrando");                
		} 
	    	where.append(Q02aTablaBDQ022AS00.NOMCOLUMN_Q022AT00_ID_CUES + " is not null" );    	
    		return where.toString();
    	}catch(Exception ex){    	 	   
	       java.io.StringWriter sw = new java.io.StringWriter();
	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	       ex.printStackTrace(pw);

	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":componerFiltroCuestionarioSMAnu: " + sw.getBuffer ().toString());

	       throw ex;

		}finally{			 	

			if (tr.isTraceActive()){

		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":componerFiltroCuestionarioSMAnu: saliendo");                

		    }    				

		}

    }*/
    
       
  /**
     * Funcin que comprueba si para el municipio, ao, mes y tipo de cuestionario=2 hay algn registro en la tabla de Grupos de 
     * 
     * @param cuestionarioSMAnuFiltro cuestionarioSMAnuFiltro
     * @return ex
     * @throws Exception Exception
     */

    public String altaModifGrupoCuestionariosSMAnu(Q02aCuestionarioSMFiltro cuestionarioSMAnuFiltro) 
        throws Exception {
   	//se definen objetos necesarios. 	
      	Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosSMAnu = null;
      	//Q02aCuestionarioSMAnuFiltro grupoCuestionarioSMAnuBD = null;
      	String niGrupoCuesSMAnu= null;
      	try{
	    	if (tr.isTraceActive())
	    	{
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: entrando");
	   	}
   		//se crea el objeto de tablasBD
	    	
	    	tablaBDGrupoCuestionariosSMAnu = new Q02aTablaBDQ022CS00(this.getConnection());
     		this.obtenerGrupoCuestionariosSMAnu(cuestionarioSMAnuFiltro,tablaBDGrupoCuestionariosSMAnu);
     		niGrupoCuesSMAnu =cuestionarioSMAnuFiltro.getNiGrupoCuesSMAnu();
     		return niGrupoCuesSMAnu;
    	}
    	catch(Exception ex){   	   
    		java.io.StringWriter sw = new java.io.StringWriter();
    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
    		ex.printStackTrace(pw);
    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: " + sw.getBuffer ().toString());
    		throw ex;
    	}finally	{
    		try	{
    			tablaBDGrupoCuestionariosSMAnu.freeResourcesNotConnection();	
    		}catch(Exception ex){
    			if (tr.isTraceActive()){
    				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: error liberando recursos");
		   	 }  
		}  		
		if (tr.isTraceActive()){
			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: saliendo");                
   		}       	
    	}
    }

    /**
     * 
     * @param cuestionarioSMAnuFiltro cuestionarioSMAnuFiltro
     * @param tablaBDGrupoCuestionariosSMAnu tablaBDGrupoCuestionariosSMAnu
     * @throws Exception Exception
     */
    private void obtenerGrupoCuestionariosSMAnu(Q02aCuestionarioSMFiltro cuestionarioSMAnuFiltro,Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosSMAnu) 
    throws Exception  {
    	
    	ResultSet rs = null;
    	String niGrupoCuestionariosSMAnu=null;
    	//String prevSueloBD=null;
    	//String prevSueloFiltro=null;
    	boolean hayCuestionarios = false;
    	String anoPortadaConcreta=null;
    	try{
	    	if (tr.isTraceActive()){
	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGrupoCuestionariosSMAnu: entrando");
	    	}
	    	
	    	anoPortadaConcreta = q02a.exe.utils.Q02aConstantes.getString("ano.portada.2008");
	    	
	    	tablaBDGrupoCuestionariosSMAnu.setQ022CT00_ANO_WHERE(Q02aFormatData.checkIntegerNull(cuestionarioSMAnuFiltro.getAno()));
		   	tablaBDGrupoCuestionariosSMAnu.setMUN_PROV_WHERE(Q02aFormatData.checkStringNull(cuestionarioSMAnuFiltro.getCodProv()));
		   	tablaBDGrupoCuestionariosSMAnu.setMUN_MUNI_WHERE(Q02aFormatData.checkStringNull(cuestionarioSMAnuFiltro.getCodMuni()));
	   	
		   	//Si se da el caso de que hay que modificar la prevision del suelo, es porque anteriormente se ha grabado 
		   	//la no existencia de actuaciones para esa provincia, municipio y ao (sin mes)
		   	//por lo que en ese caso, habr que buscar el grupo sin mes y a la hora de actualizar la previsin
		   	//insertar el mes
		   	//if(!Q02aFormatData.esNullSinCero(cuestionarioSMAnuFiltro.getModificarPrevSuelo()).equals("1"))
            
		   	if(!cuestionarioSMAnuFiltro.getAno().equals(anoPortadaConcreta) 
                    || !Q02aFormatData.esNullSinCero(cuestionarioSMAnuFiltro.getModificarPrevSuelo()).equals("1")){
		   		tablaBDGrupoCuestionariosSMAnu.setQ22CT00_MES_WHERE(Q02aFormatData.checkIntegerNull(cuestionarioSMAnuFiltro.getMes()));
            }
		   	rs=tablaBDGrupoCuestionariosSMAnu.select();
		   	tablaBDGrupoCuestionariosSMAnu.addResultSet(rs);

            if(rs.next()){
		   		//Si existe, se comprueba si el campo aplica tiene el mismo valor
		   		niGrupoCuestionariosSMAnu =rs.getString(tablaBDGrupoCuestionariosSMAnu.NOMCOLUMN_Q022CT00_ID_GRUPO);
		   		cuestionarioSMAnuFiltro.setNiGrupoCuesSMAnu(niGrupoCuestionariosSMAnu);
		   		/*prevSueloBD= Q02aFormatData.esNull(rs.getString(tablaBDGrupoCuestionariosSMAnu.NOMCOLUMN_Q022CT00_REALIZA_ACTUACION));
		   		prevSueloFiltro = Q02aFormatData.esNull(cuestionarioSMAnuFiltro.getPrevSuelo());
		   		hayCuestionarios = this.obtenerNumCuestionarios(cuestionarioSMAnuFiltro.getCodProv(),cuestionarioSMAnuFiltro.getCodMuni(),cuestionarioSMAnuFiltro.getAno(),cuestionarioSMAnuFiltro.getMes(),cuestionarioSMAnuFiltro.getTipoCuestionario());
		   		if(!prevSueloBD.equals(prevSueloFiltro) && !hayCuestionarios)
		   		{
		   			//Si en el Filtro se ha puesto que se realiza actuacin, significaba que antes no, con lo que hay que modificar el registro en BD
		   			//Si antes si se realizaba actuacin y ahora no, se modifica tb el registro, y se anulan los cuestionarios de ese grupo mediante un trigger
		   			this.modificarPrevGrupoCuestionarioSM(cuestionarioSMAnuFiltro,tablaBDGrupoCuestionariosSMAnu);
		   		}*/
	   		
		   	}else{

				//Si no existe el grupo se da de alta

				niGrupoCuestionariosSMAnu = this.insertarGrupoCuestionarioSMAnu(cuestionarioSMAnuFiltro,tablaBDGrupoCuestionariosSMAnu);

				cuestionarioSMAnuFiltro.setNiGrupoCuesSMAnu(niGrupoCuestionariosSMAnu);

			}

	     }

	      catch(Exception ex){   	   

    		java.io.StringWriter sw = new java.io.StringWriter();

    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

    		ex.printStackTrace(pw);

    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGrupoCuestionariosSMAnu: " + sw.getBuffer ().toString());

    		throw ex;

    	  }

    }     

    /**
     * 
     * @param cuestionarioSMFiltroPortada cuestionarioSMFiltroPortada
     * @return idgrupo
     * @throws Exception Exception
     */
    public String obtenerIdGrupoCuestionariosSM(Q02aCuestionarioSMFiltro cuestionarioSMFiltroPortada) 
    throws Exception {

    	ResultSet rs = null;

    	String idGrupo=null;

    	Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosSM = null;

    	try{
		    	if (tr.isTraceActive()){
		    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerIdGrupoCuestionariosSM: entrando");
		    	}
		    	tablaBDGrupoCuestionariosSM = new Q02aTablaBDQ022CS00(this.getConnection());
		    	tablaBDGrupoCuestionariosSM.addColumnSelect(Q02aTablaBDQ022CS00.NOMCOLUMN_Q022CT00_ID_GRUPO);
		    	tablaBDGrupoCuestionariosSM.setQ022CT00_ANO_WHERE(Q02aFormatData.checkIntegerNull(cuestionarioSMFiltroPortada.getAno()));
		    	tablaBDGrupoCuestionariosSM.setMUN_PROV_WHERE(Q02aFormatData.checkStringNull(cuestionarioSMFiltroPortada.getCodProv()));
		    	tablaBDGrupoCuestionariosSM.setMUN_MUNI_WHERE(Q02aFormatData.checkStringNull(cuestionarioSMFiltroPortada.getCodMuni()));
		    	tablaBDGrupoCuestionariosSM.setQ022CT00_REALIZA_ACTUACION_WHERE(Integer.parseInt(cuestionarioSMFiltroPortada.getPrevSuelo()));
			   	
                if(!Q02aFormatData.esNullSinCero(cuestionarioSMFiltroPortada.getMes()).equals("")) {
			   		tablaBDGrupoCuestionariosSM.setQ22CT00_MES_WHERE(Q02aFormatData.checkIntegerNull(cuestionarioSMFiltroPortada.getMes()));
                }
			   	
			   	rs=tablaBDGrupoCuestionariosSM.select();
			   	tablaBDGrupoCuestionariosSM.addResultSet(rs);
			   	if(rs.next()){
			   		idGrupo =rs.getString(tablaBDGrupoCuestionariosSM.NOMCOLUMN_Q022CT00_ID_GRUPO);
			   	}
			   	if (tr.isTraceActive()){
		    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerIdGrupoCuestionariosSM: saliendo");
		    	}
			   	return idGrupo;
		 } catch(Exception ex){   	   

    		java.io.StringWriter sw = new java.io.StringWriter();

    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

    		ex.printStackTrace(pw);

    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerIdGrupoCuestionariosSM: " + sw.getBuffer ().toString());

    		throw ex;

    	  }finally{

      		try{

      			tablaBDGrupoCuestionariosSM.freeResourcesNotConnection();	

      		}

      		catch(Exception ex){

      			if (tr.isTraceActive()){

      				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerIdGrupoCuestionariosSM: error liberando recursos");

  		   	 }  

      		}

    	 }

    }   
    
    /**
     * 
     * @param cuestionariosSMFiltro cuestionariosSMFiltro
     * @return idGrupo
     * @throws Exception Exception
     */
    public String obtenerMiGrupoCuestionariosSM(Q02aCuestionarioSMFiltro cuestionariosSMFiltro) 
    throws Exception {

       ResultSet rs = null;
       String idGrupo=null;
       Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosSM = null;

       try{
               if (tr.isTraceActive()){
                   tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerIdGrupoCuestionariosSM: entrando");
               }

               tablaBDGrupoCuestionariosSM = new Q02aTablaBDQ022CS00(this.getConnection());
               tablaBDGrupoCuestionariosSM.addColumnSelect( Q02aTablaBDQ022CS00.NOMCOLUMN_Q022CT00_ID_GRUPO);
               tablaBDGrupoCuestionariosSM.setQ022CT00_ANO_WHERE(Q02aFormatData.checkIntegerNull(cuestionariosSMFiltro.getAno()));
               tablaBDGrupoCuestionariosSM.setMUN_PROV_WHERE(Q02aFormatData.checkStringNull(cuestionariosSMFiltro.getCodProv()));
               tablaBDGrupoCuestionariosSM.setMUN_MUNI_WHERE(Q02aFormatData.checkStringNull(cuestionariosSMFiltro.getCodMuni()));
               tablaBDGrupoCuestionariosSM.setQ22CT00_MES_WHERE(Q02aFormatData.checkIntegerNull(cuestionariosSMFiltro.getMes()));
               
               rs=tablaBDGrupoCuestionariosSM.select();
               tablaBDGrupoCuestionariosSM.addResultSet(rs);

               if(rs.next()){
                   idGrupo =rs.getString(tablaBDGrupoCuestionariosSM.NOMCOLUMN_Q022CT00_ID_GRUPO);
               }

               if (tr.isTraceActive()){
                   tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerMiGrupoCuestionariosSM: saliendo");
               }

               return idGrupo;

        } catch(Exception ex){        
           java.io.StringWriter sw = new java.io.StringWriter();
           java.io.PrintWriter pw = new java.io.PrintWriter(sw);
           ex.printStackTrace(pw);
           tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerMiGrupoCuestionariosSM: " + sw.getBuffer ().toString());
           throw ex;
         }finally{
             
           try{
               tablaBDGrupoCuestionariosSM.freeResourcesNotConnection();  
           }catch(Exception ex){
                if (tr.isTraceActive()){
                   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerIdGrupoCuestionariosSM: error liberando recursos");
                }  
           }
        }
    }
    
    /**
     * 
     * @param territorio territorio
     * @param municipio municipio
     * @param anyoReferencia anyoReferencia
     * @param mesReferencia mesReferencia
     * @return concedidoLicenInicial
     * @throws Exception Exception
     */
    public String getConcedidoGrupoCuesSM(String territorio, String  municipio, String  anyoReferencia, String  mesReferencia) throws Exception 
    {
       String realizaActuacion = "";
       ResultSet rs = null;
       PreparedStatement prepStmt =null;   
       StringBuffer query = null;
       try {

           if (tr.isTraceActive()){
               tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getConcedidoGrupoCuesSM: entrando");
           }

           query = new StringBuffer("SELECT Q022CT00_REALIZA_ACTUACION FROM Q022CS00 WHERE");
           query.append(" Q022CT00_ANO=").append(anyoReferencia);
           query.append(" AND MUN_PROV='").append(territorio).append("'");
           query.append(" AND MUN_MUNI='").append(municipio).append("'");     

           if(!Q02aFormatData.esNull(mesReferencia).equals("")){ //Si se llama desde la portada SM 2008, l mes no vendr informado
               query.append(" AND Q22CT00_MES=").append(mesReferencia);
           }
           
           prepStmt = this.getConnection().prepareStatement(query.toString());
           rs = prepStmt.executeQuery(); 
           
           if (rs.next()) {
               realizaActuacion = rs.getString(1);
           }
           if (tr.isTraceActive()) {
               tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getConcedidoGrupoCuesSM: saliendo");
           }
           return realizaActuacion;
           
       } catch (Exception ex) {        
               java.io.StringWriter sw = new java.io.StringWriter();
               java.io.PrintWriter pw = new java.io.PrintWriter(sw);
               ex.printStackTrace(pw);
               tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getConcedidoGrupoCuesSM: " + sw.getBuffer ().toString());
               throw ex;
           } finally { 
              try {
                  if (rs != null) {
                      rs.close();
                  }
                  if (prepStmt != null) {
                      prepStmt.close();
                  }
              }catch(Exception ex){
                 java.io.StringWriter sw = new java.io.StringWriter();
                 java.io.PrintWriter pw = new java.io.PrintWriter(sw);
                 ex.printStackTrace(pw);
                 tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getConcedidoGrupoCuesSM: " + sw.getBuffer ().toString());
                 throw new Q02aDAOException(ex);
              }
           }
    }

    /**
     * 
     * @param cuestionarioSMAnuFiltro cuestionarioSMFiltroPortada
     * @param tablaBDGrupoCuestionariosSMAnu tablaBDGrupoCuestionariosSMAnu
     * @return cuestionarioSMAnuFiltro.getNiGrupoCuesSMAnu
     * @throws Exception Exception
     */
    public String insertarGrupoCuestionarioSMAnu(Q02aCuestionarioSMFiltro cuestionarioSMAnuFiltro,Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosSMAnu) 
    throws Exception {
    	//se definen objetos necesarios.

    	int niGrupoCuestionarioSMAnu=1;     	

       	try{
	    	if (tr.isTraceActive())	{
	    	    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarGrupoCuestionarioSMAnu: entrando");
	    	}

	    	niGrupoCuestionarioSMAnu = this.dameSeqNiDeGrupo(tablaBDGrupoCuestionariosSMAnu);
	    	   	cuestionarioSMAnuFiltro.setNiGrupoCuesSMAnu(Integer.toString(niGrupoCuestionarioSMAnu));   
	         	//tablaBDGrupoCuestionariosSMAnu.reset();	         
	         	//----------------------------------------------------------------------         	
	    	   	//se aaden los datos a insertar

	    	   	cuestionarioSMAnuFiltro.setTipoCuestionario(Q02aConstantes.getString("q02a.cuestionarios.sMAnu.tipoCuestionario"));
	    	   	this.rellenaDatosGrupoCuestionarioSMAnu(cuestionarioSMAnuFiltro, tablaBDGrupoCuestionariosSMAnu);
         	
      		//se realiza la insert
      		tablaBDGrupoCuestionariosSMAnu.insert();
      		//pediente de recuperar el numContacto
      		return cuestionarioSMAnuFiltro.getNiGrupoCuesSMAnu();
     	}
     	catch(Exception ex)	{   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarGrupoCuestionarioSMAnu: " + sw.getBuffer ().toString());
     		throw ex;
     	}
     }
     
    /**
     * 
     * @param niGrupoCuesSM niGrupoCuesSM
     * @param valorPrevSuelo valorPrevSuelo
     * @param mes mes
     * @param obs obs
     * @throws Exception Exception
     */
     public void  modificarGrupoCuestionariosSM(String niGrupoCuesSM, String valorPrevSuelo, String mes, String obs) throws Exception {
    	 Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosSM = null;
    	 Q02aTablaBDQ022ES00 tablaBDCuestionariosSM = null;
         
    	 try{
	    	if (tr.isTraceActive()){
	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarGrupoCuestionariosSM: entrando");
	    	}
	    	tablaBDGrupoCuestionariosSM = new Q02aTablaBDQ022CS00(this.getConnection());
	    	tablaBDCuestionariosSM = new Q02aTablaBDQ022ES00(this.getConnection());
	    	
	    	if(valorPrevSuelo.equals("0")){//Hay que borrar los cuestionarios rellenados de cuando se respondio que SI se haban concedido licencias
	    		tablaBDCuestionariosSM.setQ022CT00_ID_GRUPO_WHERE(Q02aFormatData.checkIntegerNull(niGrupoCuesSM));
	    		tablaBDCuestionariosSM.delete();
	    	}
	    	
	    	tablaBDGrupoCuestionariosSM.setQ022CT00_ID_GRUPO_WHERE(Q02aFormatData.checkIntegerNull(niGrupoCuesSM));
	    	tablaBDGrupoCuestionariosSM.setQ022CT00_REALIZA_ACTUACION(Q02aFormatData.checkIntegerNull(valorPrevSuelo));
	    	tablaBDGrupoCuestionariosSM.setQ22CT00_MES(Integer.parseInt(mes));

	       	if(valorPrevSuelo.equals("0")){
	       		tablaBDGrupoCuestionariosSM.setQ022CT00_NCUS(0);
	       		tablaBDGrupoCuestionariosSM.setQ022CT00_OBSSU(obs);
	       	}else{
	    		tablaBDGrupoCuestionariosSM.setQ022CT00_OBSSU(null);
            }
	    	tablaBDGrupoCuestionariosSM.update();

     	}catch(Exception ex){   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarGrupoCuestionariosSM: " + sw.getBuffer ().toString());
     		throw ex;
     	}finally{
    		try{
    			tablaBDGrupoCuestionariosSM.freeResourcesNotConnection();	
    			tablaBDCuestionariosSM.freeResourcesNotConnection();
    		}
    		catch(Exception ex){
    			if (tr.isTraceActive()){
    				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarGrupoCuestionariosSM: error liberando recursos");
		   	}  
		}
     }
   }
   
    /**
     * 
     * @param tablaBDGrupoCuestionariosSMAnu tablaBDGrupoCuestionariosSMAnu
     * @return niGrupoCuestionarioSMAnu
     * @throws Exception Exception
     */
     private int dameSeqNiDeGrupo(Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosSMAnu) 
     throws Exception {

    	int niGrupoCuestionarioSMAnu=1;
     	ResultSet rs = null;
       	PreparedStatement prepStmt =null;	

     	try{
	    	if (tr.isTraceActive())	{
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameSeqNiDeGrupo: entrando");
	    	}
	    		StringBuffer query = new StringBuffer(" SELECT Q022CQ00.NEXTVAL FROM DUAL ");
	         	prepStmt = this.getConnection().prepareStatement(query.toString());         	
	         	rs = prepStmt.executeQuery();
	         	tablaBDGrupoCuestionariosSMAnu.addResultSet(rs);
	         	tablaBDGrupoCuestionariosSMAnu.addStatement(prepStmt);        	

                if (rs.next()){
	         		niGrupoCuestionarioSMAnu = rs.getInt(1);
	         	}	         	
	         	return niGrupoCuestionarioSMAnu;
        }catch(Exception ex){   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameSeqNiDeGrupo: " + sw.getBuffer ().toString());
     		throw ex;
     	      }

     }
     
     /**
      * 
      * @param cuestionarioSMAnuFiltro cuestionarioSMAnuFiltro
      * @param tablaBDGrupoCuestionariosSMAnu tablaBDGrupoCuestionariosSMAnu
      * @throws Exception Exception
      */
     public void rellenaDatosGrupoCuestionarioSMAnu( Q02aCuestionarioSMFiltro cuestionarioSMAnuFiltro, Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosSMAnu) 
     throws Exception {

     	//se definen objetos necesarios.

     	try{

 	    	if (tr.isTraceActive())

 	    	{

 	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosGrupoCuestionarioSMAnu: entrando");

 	   	}         	         

      		//se aaden los datos

 	    	tablaBDGrupoCuestionariosSMAnu.setQ022CT00_ID_GRUPO(Q02aFormatData.checkIntegerNull(cuestionarioSMAnuFiltro.getNiGrupoCuesSMAnu()));

 	    	tablaBDGrupoCuestionariosSMAnu.setQ022CT00_ANO(Q02aFormatData.checkIntegerNull(cuestionarioSMAnuFiltro.getAno())); 	

 	    	tablaBDGrupoCuestionariosSMAnu.setQ22CT00_MES(Q02aFormatData.checkIntegerNull(cuestionarioSMAnuFiltro.getMes()));

 	    	tablaBDGrupoCuestionariosSMAnu.setQ022CT00_REALIZA_ACTUACION(Q02aFormatData.checkIntegerNull(cuestionarioSMAnuFiltro.getPrevSuelo()));

 	    	tablaBDGrupoCuestionariosSMAnu.setMUN_PROV(Q02aFormatData.checkStringNull(cuestionarioSMAnuFiltro.getCodProv()));

 	    	tablaBDGrupoCuestionariosSMAnu.setMUN_MUNI(Q02aFormatData.checkStringNull(cuestionarioSMAnuFiltro.getCodMuni()));

 	    	tablaBDGrupoCuestionariosSMAnu.setQ022CT00_OBSSU(Q02aFormatData.checkStringNull(cuestionarioSMAnuFiltro.getObsSuelo()));

 	    	tablaBDGrupoCuestionariosSMAnu.setQ022CT00_NCUS(0);

 	    	//tablaBDGrupoCuestionariosSMAnu.setQ022CT00_TIPO_CUESTIONARIO(Q02aFormatData.checkIntegerNull(cuestionarioSMAnuFiltro.getTipoCuestionario()));



     	}catch(Exception ex){   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaDatosGrupoCuestionarioSMAnu: " + sw.getBuffer ().toString());

     		throw ex;

     	}finally{    		

 			if (tr.isTraceActive()){

 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosGrupoCuestionarioSMAnu: saliendo");                

            }       	

     	}	

     }  

     

     

      /**
      * Funcin que devuelve el campo Prevision Suelo para un municipio y ao determinados por los parmetros de entrada
      * 
      * @param codProv - Cdigo de la provincia
      * @param codMuni - Cdigo del municipio
      * @param ano - Ao  
      * @param mes mes
      * @param tipoCuestionario tipoCuestionario
      * @throws Exception Exception
      * @return prevSuelo
      */

     public String obtenerCampoPrevSueloDeGrupoConMuniAno(String codProv,String codMuni,String ano, String mes, String tipoCuestionario) throws Exception {

    	//se definen objetos necesarios.
    	String prevSuelo = null;
    	ResultSet rs = null;
       	Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosSMAnu = null;

       	try{
	    	if (tr.isTraceActive())
	    	{
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoPrevSueloDeGrupoConMuniAno: entrando");
	   	}
	   	
	    	tablaBDGrupoCuestionariosSMAnu = new Q02aTablaBDQ022CS00(this.getConnection());
	    	rs = this.dameRsGrupoCues(codProv,codMuni,ano,mes,tablaBDGrupoCuestionariosSMAnu, tipoCuestionario);
	         	if (rs.next())
	         	{
	         		prevSuelo = rs.getString(tablaBDGrupoCuestionariosSMAnu.NOMCOLUMN_Q022CT00_REALIZA_ACTUACION);
	         		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoPrevSueloDeGrupoConMuniAno: entrando");
	        	}
	        	
      		return Q02aFormatData.esNullSinCero(prevSuelo);
     	}catch(Exception ex){   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoPrevSueloDeGrupoConMuniAno: " + sw.getBuffer ().toString());
     		throw ex;
     	}finally	{
     		try{
     			tablaBDGrupoCuestionariosSMAnu.freeResourcesNotConnection();	
     		}catch(Exception ex){
     			if (tr.isTraceActive())
     			{
     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoPrevSueloDeGrupoConMuniAno: error liberando recursos");
 		   	   }  
 		}  		
		if (tr.isTraceActive())
		{
			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoPrevSueloDeGrupoConMuniAno: saliendo");                
    		}       	
     	}
     }
     
     /**
      * Funcin que inserta los datos del cuestionario pasado como parmetro en la BBDD
      * 
      * @param cuestionarioSMAnu - Datos de la cuestionario a insertar
      * @return NiCuesSMAnu
      * @throws Exception Exception
      */

     public String insertarCuestionarioSMAnu(Q02aCuestionarioSM cuestionarioSMAnu) throws Exception {

    	//se definen objetos necesarios.
    	int niCuestionarioSMAnu=1;     	

       	Q02aTablaBDQ022ES00 tablaBDCuestionariosSMAnu = null;

       	try{
	    	if (tr.isTraceActive()){
	    	    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioSMAnu: entrando");
	    	}

    		//se crea el objeto de tablasBD
	    	tablaBDCuestionariosSMAnu = new Q02aTablaBDQ022ES00(this.getConnection());
	    	this.cambiarComa(cuestionarioSMAnu);

      		//primero recuperamos el nmero interno de contacto que le corresponde
	    	//-------------------------------------------------------------------------------------------------------------------------------------
	    	    niCuestionarioSMAnu = dameMaxNiCuesDeGrupo(cuestionarioSMAnu.getNiGrupoCuesSMAnu(),tablaBDCuestionariosSMAnu);
	         	cuestionarioSMAnu.setNiCuesSMAnu(Integer.toString(niCuestionarioSMAnu));   
	         	//tablaBDCuestionariosSMAnu.reset();	         
         	//----------------------------------------------------------------------         	

      		//se aaden los datos a insertar
         		this.rellenaDatosCuestionarioSMAnu(cuestionarioSMAnu, tablaBDCuestionariosSMAnu);         	         

      		//se realiza la insert
      		tablaBDCuestionariosSMAnu.insert();

      		//pediente de recuperar el numContacto
      		return cuestionarioSMAnu.getNiCuesSMAnu();

     	}catch(Exception ex){   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarCuestionarioSMAnu: " + sw.getBuffer ().toString());
     		throw ex;
     	}finally{

     		try{
     			tablaBDCuestionariosSMAnu.freeResourcesNotConnection();	
     		}catch(Exception ex){
     			if (tr.isTraceActive()){
     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarCuestionarioSMAnu: error liberando recursos");
     			}  
     		}  		

		if (tr.isTraceActive()){
			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioSMAnu: saliendo");                
    		}       	
     	}

     }

     /**
      * 
      * @param niGrupoCuestionarioSMAnu niGrupoCuestionarioSMAnu
      * @param tablaBDCuestionariosSMAnu tablaBDCuestionariosSMAnu
      * @return niCuestionarioSMAnu
      * @throws Exception Exception
      */
     private int dameMaxNiCuesDeGrupo(String niGrupoCuestionarioSMAnu,Q02aTablaBDQ022ES00 tablaBDCuestionariosSMAnu) 
     throws Exception {

     	int niCuestionarioSMAnu=1;

     	ResultSet rs = null;	

     	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameMaxNiCuesDeGrupo: entrando");

	   	}

	   	

	   	tablaBDCuestionariosSMAnu.setMax(tablaBDCuestionariosSMAnu.NOMCOLUMN_Q022ET00_ID_CUES);

	         	tablaBDCuestionariosSMAnu.setQ022CT00_ID_GRUPO_WHERE(new Integer(niGrupoCuestionarioSMAnu));

	         	rs = tablaBDCuestionariosSMAnu.selectMax();

	         	tablaBDCuestionariosSMAnu.addResultSet(rs);     	

	         	if (rs.next()){

	         		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameMaxNiCuesDeGrupo: max Cuestionario para niGrupoCuesSMAnu " + niGrupoCuestionarioSMAnu+ " ="+ rs.getInt(1));

	         		niCuestionarioSMAnu = rs.getInt(1) + 1;

	         	}

	         	return niCuestionarioSMAnu;

	        }

	        catch(Exception ex)

     	        {   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameMaxNiCuesDeGrupo: " + sw.getBuffer ().toString());

     		throw ex;

     	      }

     }

     /**
      * Funcin que inserta los datos del cuestionarioSMAnu pasada como parmetro en la BBDD
      * 
      * @param cuestionarioSMAnu - Datos de la cuestionarioSMAnu a insertar
      * @param tablaBDCuestionariosSMAnu tablaBDCuestionariosSMAnu
      * @throws Exception Exception
      */

     public void rellenaDatosCuestionarioSMAnu( Q02aCuestionarioSM cuestionarioSMAnu, Q02aTablaBDQ022ES00 tablaBDCuestionariosSMAnu) throws Exception {

     	//se definen objetos necesarios.
     	try{
 	    	if (tr.isTraceActive()){
 	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosCuestionarioSMAnu: entrando");
 	   	}         	         
      		//se aaden los datos

 	    	tablaBDCuestionariosSMAnu.setQ022CT00_ID_GRUPO(Q02aFormatData.checkIntegerNull(cuestionarioSMAnu.getNiGrupoCuesSMAnu()));
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_ID_CUES(Q02aFormatData.checkLongNull(cuestionarioSMAnu.getNiCuesSMAnu()));
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_CLASU(Q02aFormatData.checkStringNull(cuestionarioSMAnu.getClasu())); 	    	
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_SUPSU(Q02aFormatData.checkIntegerNull(cuestionarioSMAnu.getSupSueloT()));
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_SUPTE(Q02aFormatData.checkIntegerNull(cuestionarioSMAnu.getSupSueloC()));
 	    	
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_VALSU(Q02aFormatData.checkDoubleNull(cuestionarioSMAnu.getCosteSuelo()));
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_NVPOG(Q02aFormatData.checkIntegerNull(cuestionarioSMAnu.getVpoRG()));
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_NVPOE(Q02aFormatData.checkIntegerNull(cuestionarioSMAnu.getVpoRE()));
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_NVTMG(Q02aFormatData.checkIntegerNull(cuestionarioSMAnu.getVtmRG()));
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_NVTME(Q02aFormatData.checkIntegerNull(cuestionarioSMAnu.getVtmRE())); 	    	
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_NALOD(Q02aFormatData.checkIntegerNull(cuestionarioSMAnu.getAlojDota()));
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_NREAL(Q02aFormatData.checkIntegerNull(cuestionarioSMAnu.getRealojos()));
 	    	
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_NVTOT(Q02aFormatData.checkIntegerNull(cuestionarioSMAnu.getTotalViv())); 	    	
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_FIRMADO((Q02aFormatData.checkStringNull(cuestionarioSMAnu.getFirmado()))==null?new Integer("0"):new Integer(cuestionarioSMAnu.getFirmado()));
 	    	
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_CDEXP(Q02aFormatData.checkStringNull(cuestionarioSMAnu.getCodExpediente()));
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_NVPOT(Q02aFormatData.checkIntegerNull(cuestionarioSMAnu.getVpot()));
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_NLIBRE(Q02aFormatData.checkIntegerNull(cuestionarioSMAnu.getLibres())); 	    	
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_OBSSU(Q02aFormatData.checkStringNull(cuestionarioSMAnu.getObservaciones()));
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_FADQ(Q02aFormatData.parseDate(cuestionarioSMAnu.getFecAdquisicion()));
 	    	
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_ENTI(Q02aFormatData.checkLongNull(cuestionarioSMAnu.getEntClEnt()));
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_TVIA(Q02aFormatData.checkStringNull(cuestionarioSMAnu.getTipoVia()));
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_CALLE(Q02aFormatData.checkLongNull(cuestionarioSMAnu.getNombreVia()));
 	    	//tablaBDCuestionariosSMAnu.setQ022ET00_POR_CL_POR(Q02aFormatData.checkLongNull(cuestionarioSMAnu.getNumBloque()));
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_POR_CL_POR(Q02aFormatData.checkLongNull(cuestionarioSMAnu.getPorClPor()));
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_BLOQ(Q02aFormatData.checkStringNull(cuestionarioSMAnu.getBloque()));
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_NUME(Q02aFormatData.checkIntegerNull(cuestionarioSMAnu.getNumePortal()));
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_BIS(Q02aFormatData.checkStringNull(cuestionarioSMAnu.getBisPortal()));
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_CDIR(Q02aFormatData.checkStringNull(cuestionarioSMAnu.getAcepcion()));
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_DIR_NUEVA(Q02aFormatData.checkStringNull(cuestionarioSMAnu.getDirNueva()));
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_TIPADQ(Q02aFormatData.checkStringNull(cuestionarioSMAnu.getTipadq()));
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_FUERA_PLAZO(Q02aFormatData.checkStringNull(cuestionarioSMAnu.getFueraPlazo()));
            
            if ( cuestionarioSMAnu.getUsuAlta() != null && !"".equals(cuestionarioSMAnu.getUsuAlta()) )
                tablaBDCuestionariosSMAnu.setQ022ET00_USU_ALTA( Q02aFormatData.checkStringNull(cuestionarioSMAnu.getUsuAlta()) );
            if ( cuestionarioSMAnu.getUsuModif() != null && !"".equals(cuestionarioSMAnu.getUsuModif()) )
                tablaBDCuestionariosSMAnu.setQ022ET00_USU_MODIF( Q02aFormatData.checkStringNull(cuestionarioSMAnu.getUsuModif()) );
            
 	    	String coodX = "";
 	    	String coodY = "";
 	    	if (cuestionarioSMAnu.getCoordenadaX()!=null){
 	    		coodX = cuestionarioSMAnu.getCoordenadaX().toString();
 	    	}
 	    	if (cuestionarioSMAnu.getCoordenadaY()!=null){
 	    		coodY = cuestionarioSMAnu.getCoordenadaY().toString();
 	    	}

 	    	tablaBDCuestionariosSMAnu.setQ022ET00_DX(Q02aFormatData.checkDoubleNull(coodX));
 	    	tablaBDCuestionariosSMAnu.setQ022ET00_DY(Q02aFormatData.checkDoubleNull(coodY));

     	}catch(Exception ex){   	   

     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaDatosCuestionarioSMAnu: " + sw.getBuffer ().toString());
     		throw ex;
     	}finally{    		
 			if (tr.isTraceActive()){
 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosCuestionarioSMAnu: saliendo");                
            }       	
     	}	
     }  

     /**
      * Mtodo que devuelve el nmero de registros de la BBDD de cuestionarios
      * @param niGrupoCuesSMAnu niGrupoCuesSMAnu
      * @return devuelve nmero de registros de la BBDD de cuestionarios
      * @throws Exception Exception
      */

     public int getCountCuestionariosSMAnu(String niGrupoCuesSMAnu) throws Exception {    	    

      	//se crean las objetos necesarios.

      	int numReg = 0;

      	ResultSet rs = null;       

      	Q02aTablaBDQ022ES01V02 vistaCuestionariosSM = null;	

          try{

          	if (tr.isTraceActive()){

      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCountCuestionariosSMAnu: entrando");

      		}

          	//se instancia la clase del tablas bd a llamar pasandole la conexion        	

          	vistaCuestionariosSM = new Q02aTablaBDQ022ES01V02(this.getConnection());

          	

          	//se carga el filtro de la where con los datos de entrada.TODO

          	this.rellenaFiltroCuestionarioSM(niGrupoCuesSMAnu,vistaCuestionariosSM);        	

          	//se realiza la cout

          	rs = vistaCuestionariosSM.selectCount();       	

          	vistaCuestionariosSM.addResultSet(rs);

          	//se recupera el resultado

          	if (rs.next()){          		 

          	 	 numReg =  rs.getInt(1);

          	}

          	return numReg;

          }catch(Exception ex){

              java.io.StringWriter sw = new java.io.StringWriter();

              java.io.PrintWriter pw = new java.io.PrintWriter(sw);

              ex.printStackTrace(pw);

              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCountCuestionariosSMAnu: " + sw.getBuffer ().toString());

              throw ex;

         }finally{

      	   try{

      		 vistaCuestionariosSM.freeResourcesNotConnection();	

      	   }catch(Exception ex){

  			   if (tr.isTraceActive()){

  				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCountCuestionariosSMAnu: error liberando recursos");

  	   	   	   }  

  		   }  		

      	   if (tr.isTraceActive()){

      		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCountCuestionariosSMAnu: saliendo");                

             }           

         }      

      }//fin getCountCuestionariosSMAnu()

     
     /**
      * 
      * @param cuestionarioSMFiltroPortada cuestionarioSMFiltroPortada
      * @return listaCuestionariosSM
      * @throws Exception Exception
      */
     public ArrayList getSelectCuestionariosSMAnu(Q02aCuestionarioSMFiltro cuestionarioSMFiltroPortada) 
     throws Exception {		

 		//se instancian los objetos necesarios para realizar la consulta.			
 		Q02aTablaBDQ022ES01V02 vistaCuestionariosSM=null;
 		ResultSet rs = null;
 		ArrayList listaCuestionariosSM = new ArrayList();
 		Q02aCuestionarioSM cuestionarioSMAnu;
 		
 		try{
 	    	if (tr.isTraceActive()){
 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getSelectCuestionariosSMAnu: entrando");
 			}
 	    	
 	    	//se instancia la clase del tablas bd a llamar pasandole la conexion	    	

 	    	vistaCuestionariosSM = new Q02aTablaBDQ022ES01V02(this.getConnection());
 	    
 	    	//rellenamos la where con los datos del filtro de usuarioTODO
 	    	this.rellenaFiltroListadoCuestionariosSM(cuestionarioSMFiltroPortada, vistaCuestionariosSM);
 	    	//se realiza la select
 	    	rs = vistaCuestionariosSM.select();
 	    	//aadimos el cursos para luego poder liberarlo ( en el freeResources)
 	    	vistaCuestionariosSM.addResultSet(rs); 
 	    	//se trata el resultado obtenido aadiendolo a la lista de salida
 	    	listaCuestionariosSM = this.rellenaVOsCuestionariosSMAnu(rs);
 	    	
 	    	for (int i=0; i < listaCuestionariosSM.size(); i++){
 	    		cuestionarioSMAnu = (Q02aCuestionarioSM)listaCuestionariosSM.get(i);
	    		if (cuestionarioSMAnu.getCosteSuelo() != null){
	    			this.cambiarPunto(cuestionarioSMAnu);
	    			this.formatearNumero(cuestionarioSMAnu, "N");
	    			listaCuestionariosSM.set(i,cuestionarioSMAnu);
	    		}
	    	}
	    	
 	    	return listaCuestionariosSM;    	
 		}catch(Exception ex){ 	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getSelectCuestionariosSMAnu: " + sw.getBuffer ().toString());
     		throw ex;
 		}finally{
 		 	try{
 		 		//liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet
 		 		vistaCuestionariosSM.freeResourcesNotConnection();	
 			 }catch(Exception ex)
 			 {
 			    if (tr.isTraceActive())
 			    {
 				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getSelectCuestionariosSMAnu: error liberando recursos.");
 	   	   	    }  
 			 }  		 			
 			 if (tr.isTraceActive()){
 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getSelectCuestionariosSMAnu: saliendo.");                
 	         }   
 		}	
 	}

     /**
      * 
      * @param rs rs
      * @return listaCuestionariosSMAnu
      * @throws Exception Exception
      */
     private ArrayList rellenaVOsCuestionariosSMAnu ( ResultSet rs ) throws Exception{

     	Q02aCuestionarioSM cuestionarioSMAnu;
     	ArrayList listaCuestionariosSMAnu = new ArrayList();

     	try{
     		if (tr.isTraceActive()){
 		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOCuestionariosSMAnuBD: entrando");                
 		    } 
     		while (rs.next()){	 
 	        	//se cargan en el objeto cuestionario los datos recuperados
     			cuestionarioSMAnu = new Q02aCuestionarioSM();
     			rellenarVOCuestionarioSM(cuestionarioSMAnu,rs);
     			listaCuestionariosSMAnu.add(cuestionarioSMAnu);
   			}  	  
     		return listaCuestionariosSMAnu;
     	}catch(Exception ex){    	 	   
  	       java.io.StringWriter sw = new java.io.StringWriter();
  	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);
  	       ex.printStackTrace(pw);
  	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaVOCuestionariosSMAnuBD: " + sw.getBuffer ().toString());
  	       throw ex;
  		}finally{			 	
  			if (tr.isTraceActive()){
  		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOCuestionariosSMAnuBD: saliendo");                
  		    }    				
  		}
     }
     

     /**
      * 
      * @param cuestionarioSMAnuBD cuestionarioSMAnuBD
      * @param rs rs
      * @throws Exception Exception
      */
     private void rellenarVOCuestionarioSM (Q02aCuestionarioSM cuestionarioSMAnuBD, ResultSet rs) 
     throws Exception {
         
	     	try{
			   	tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":rellenarVOCuestionarioSM: Hay Datos");            
			   	cuestionarioSMAnuBD.setNiGrupoCuesSMAnu(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022CT00_ID_GRUPO));
			   	cuestionarioSMAnuBD.setNiGrupoCuesSM(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022CT00_ID_GRUPO));//Se utiliza en el caso de listado de 2008
			   	cuestionarioSMAnuBD.setNiCuesSMAnu(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_ID_CUES));
				cuestionarioSMAnuBD.setClasu(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_CLASU));			
				cuestionarioSMAnuBD.setSupSueloT(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_SUPSU));
				cuestionarioSMAnuBD.setSupSueloC(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_SUPTE));
				cuestionarioSMAnuBD.setCosteSuelo(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_VALSU));
				cuestionarioSMAnuBD.setVpoRG(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_NVPOG));
				cuestionarioSMAnuBD.setVpoRE(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_NVPOE));
				cuestionarioSMAnuBD.setVtmRG(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_NVTMG));
				cuestionarioSMAnuBD.setVtmRE(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_NVTME));			
				cuestionarioSMAnuBD.setAlojDota(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_NALOD));
				cuestionarioSMAnuBD.setRealojos(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_NREAL));
				cuestionarioSMAnuBD.setTotalViv(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_NVTOT));
				cuestionarioSMAnuBD.setFecAlta(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_FEC_ALTA));
				cuestionarioSMAnuBD.setFecMod(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_FEC_MOD));
				cuestionarioSMAnuBD.setFirmado(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_FIRMADO));
				cuestionarioSMAnuBD.setFecBaja(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_FEC_BAJA));
				cuestionarioSMAnuBD.setCodExpediente(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_CDEXP));
				cuestionarioSMAnuBD.setVpot(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_NVPOT));
				cuestionarioSMAnuBD.setLibres(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_NLIBRE));			
				cuestionarioSMAnuBD.setObservaciones(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_OBSSU));			
				cuestionarioSMAnuBD.setFecAdquisicion(Q02aFormatData.formatearFecha( Q02aFormatData.checkStringNull( rs.getString( Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_FADQ)), Q02aConstantes.FORMATO_FECHA_FORMAT_DATA, this.getIdioma()));
				cuestionarioSMAnuBD.setEntClEnt(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_ENTI));
				cuestionarioSMAnuBD.setTipoVia(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_TVIA));
				cuestionarioSMAnuBD.setNombreVia(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_CALLE));
				cuestionarioSMAnuBD.setBloque(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_BLOQ));
				cuestionarioSMAnuBD.setNumBloque(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_POR_CL_POR));
				cuestionarioSMAnuBD.setPorClPor(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_POR_CL_POR));
				cuestionarioSMAnuBD.setNumePortal(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_NUME));
				cuestionarioSMAnuBD.setBisPortal(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_BIS));
				cuestionarioSMAnuBD.setAcepcion(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_CDIR));
				cuestionarioSMAnuBD.setDirNueva(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_DIR_NUEVA));
				cuestionarioSMAnuBD.setTipadq(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_TIPADQ));
				if ( rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_FUERA_PLAZO) != null)
                    cuestionarioSMAnuBD.setFueraPlazo(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_FUERA_PLAZO));
                
				cuestionarioSMAnuBD.setUbicacion(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q022ET00_NORA_T17_LOCALIZACION));
				cuestionarioSMAnuBD.setMesReferencia(rs.getString(Q02aTablaBDQ022ES01V02.NOMCOLUMN_Q22CT00_MES));
				
	}catch (Exception e) {
		    if (tr.isTraceActive()){
		   	   	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenarVOCuestionarioSM: error "+ e.getMessage());
			}  
   }  	
}

     /**
      * Mtodo que rellena el tablasBD con el ni del objeto
      * 
      * @param niGrupoCuesSMAnu - ni del grupo cuestionarios
      * @param tablaBD - vista sobre la que se va a realizar la consulta
      * 
      * @throws Exception Exception
      */

    public void rellenaFiltroCuestionarioSM(String niGrupoCuesSMAnu,Q02aTablaBDQ022ES01V02 tablaBD)throws Exception
    {
    	final String TRACE_METODO = ":rellenaFiltroCuestionarioSM:";
    	try{

    		if (tr.isTraceActive()){
		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando");                
    		} 
	    	if (!Q02aFormatData.esVacio(niGrupoCuesSMAnu)){
	    		tablaBD.setQ022CT00_ID_GRUPO_WHERE(new Integer(niGrupoCuesSMAnu));
	    	}
	    	tablaBD.setAditionalWhere(" and " + tablaBD.NOMCOLUMN_Q022ET00_FEC_BAJA + " is null");
    	}catch(Exception ex){    	 	   
	       java.io.StringWriter sw = new java.io.StringWriter();
	       java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);
	       ex.printStackTrace(pw);
	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() 		+ TRACE_METODO + sw.getBuffer ().toString());
	       throw ex;
    	}finally{			 	
    		if (tr.isTraceActive()){
		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() 	+ TRACE_METODO + " saliendo");                
    		}    				
    	}
    }//fin rellenaFiltroCuestionarioSMAnu()

    

    

     /**
      * Mtodo que rellena el tablasBD con los datos del filtro de objeto que contiene
      * el ni del objeto y el tipo de objeto
      * 
      * @param cuestionarioSMFiltroPortada Q02aCuestionarioSMFiltro - objeto que contiene los datos del filtro
      * @param tablaBD - vista sobre la que se va a realizar la consulta
      * 
      * @throws Exception Exception
      */

    public void rellenaFiltroListadoCuestionariosSM(Q02aCuestionarioSMFiltro cuestionarioSMFiltroPortada,Q02aTablaBDQ022ES01V02 tablaBD)throws Exception
    {
     final String TRACE_METODO = ":rellenaFiltroCuestionarioSM:";
    	try{
    		String anyo2008=q02a.exe.utils.Q02aConstantes.getString("ano.portada.2008");
    		if (tr.isTraceActive())
    		{
		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando");                
    		} 
    		if(cuestionarioSMFiltroPortada.getAno().equals(anyo2008)){//Viene de la portada 2008
    			tablaBD.setQ022CT00_ANO_WHERE(Integer.parseInt(cuestionarioSMFiltroPortada.getAno()));
    			tablaBD.setMUN_PROV_WHERE(cuestionarioSMFiltroPortada.getCodProv());
    			tablaBD.setMUN_MUNI_WHERE(cuestionarioSMFiltroPortada.getCodMuni());
    		}
    		else{ //Viene de la portada general		
	    		if (!Q02aFormatData.esVacio(cuestionarioSMFiltroPortada.getNiGrupoCuesSMAnu())){
	    			tablaBD.setQ022CT00_ID_GRUPO_WHERE(new Integer(cuestionarioSMFiltroPortada.getNiGrupoCuesSMAnu()));
	    		}
    		}
	    	tablaBD.setAditionalWhere(" and " + tablaBD.NOMCOLUMN_Q022ET00_FEC_BAJA + " is null");
	    	tablaBD.setOrderBy(" Q022ET00_ID_CUES DESC");
	  
    	}catch(Exception ex){    	 	   
	       java.io.StringWriter sw = new java.io.StringWriter();
	       java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);
	       ex.printStackTrace(pw);
	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() 		+ TRACE_METODO + sw.getBuffer ().toString());
	       throw ex;
    	}finally{			 	
    		if (tr.isTraceActive()){
		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() 	+ TRACE_METODO + " saliendo");                
    		}    				
    	}
    }//fin rellenaFiltroListadoCuestionariosSM()
 

     /**
      * Funcin que devuelve un string con los meses que le quedan por introducir para un municipio y ao determinados por los parmetros de entrada
      * 
      * @param codProv- Cdigo de la provincia
      * @param codMuni- Cdigo del municipio
      * @param ano- Ao
      * @param idioma- Idioma
      * 
      * @throws Exception
      */

   /*  public String obtenerAnosMesesPendientesParaMuni(String codProv,String codMuni,String ano,String idioma) throws Exception {

    	//se definen objetos necesarios.

    	String msgMeses = "";

    	ResultSet rs = null;

    	java.util.Hashtable hashAnos = new java.util.Hashtable();

    	String [] arrNombresAnos = {};

       	Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosSMAnu = null;

  

       	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientesParaMuni: entrando");

	   	}

	   	

	   	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientesParaMuni: idioma="+ idioma);

	   	if(Q70ListenerUtils.getApplicationProperty("IDIOMA_ES").equals(idioma))

	   	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientesParaMuni: idioma ES");

	   		arrNombresAnos = Q02aAplicationUtils.dameArrayAnosCuesSMAnu();

	   	}

	   	else if(Q70ListenerUtils.getApplicationProperty("IDIOMA_EU").equals(idioma))

	   	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientesParaMuni: idioma EU");

	   		arrNombresAnos = Q02aAplicationUtils.dameArrayAnosCuesSMAnu();

	   	}

	 	//Se carga el hashtable con los aos



	   	for (int i=1;i<=arrNombresAnos.length;i++)

	   	{

	   		hashAnos.put(Integer.toString(i),arrNombresAnos[i-1]);

		}

	   	tablaBDGrupoCuestionariosSMAnu = new Q02aTablaBDQ022CS00(this.getConnection());

	   	int aux = hashAnos.size();

	    	rs = this.dameAnosPendientes(codProv,codMuni,ano,tablaBDGrupoCuestionariosSMAnu);

	         	while (rs.next())

	         	{

	         		

	         		boolean encon = true;

	         		int key = 1;

	         		int cont = aux;

	         		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientesParaMuni: Hay cuestionarios SM Anu en el ao ****"+ rs.getString(1));

	         		

	         		while (cont > 0 && encon)

	         		{

	         			

	         			if (hashAnos.containsKey(Integer.toString(key)))

	         			{

	         				String obj = (String)hashAnos.get(Integer.toString(key));

	         				if (obj.equals(rs.getString(1)))

	         				{

	         					

	         					hashAnos.remove(Integer.toString(key));

	         					encon = false;

	         				}

	         				else key++;

	         			}

	         			else

	         				key++;

	         				cont--;

	         			

	         		}

	         		

	         		

	         		

	        	}

	         	

	        	if(!hashAnos.isEmpty())

	        	{

	        		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientesParaMuni:Faltan cuestionarios de meter, xq el array hastable no est vacio ****");

	        		String anosP = "";

	        		for (int i=0;i<arrNombresAnos.length;i++)

	        		{

	        			//Si el array de meses contiene el mes, es que falta de introducir datos, 

	        			if(hashAnos.containsKey(Integer.toString(i+1)))

	        			{

	        				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientesParaMuni:Falta de introducir el ao  ******* ="+ i);

	        				if(!anosP.equals(""))

	        					anosP += ", ";

	        				anosP += hashAnos.get(Integer.toString(i+1));

	        			}

	        		}

	        		

	        		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientesParaMuni:Aos sin meter ******* ="+ anosP);

	        		msgAnos = Q70GestorMensajesi18n.getSingleton().getMessage(RECURSOS_CUES_SM_ANU,"cuestionarios.sMAnu.anosFaltanDos",idioma) + anosP + ".";

	        		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientesParaMuni:MSG = ****" + msgAnos);

	

	        	}



      		return msgAnos;

     	}

     	catch(Exception ex)

     	{   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAnosPendientesParaMuni: " + sw.getBuffer ().toString());

     		throw ex;

     	}

     	finally

     	{

     		try

     		{

     			tablaBDGrupoCuestionariosSMAnu.freeResourcesNotConnection();	

     		}

     		catch(Exception ex)

     		{

     			if (tr.isTraceActive())

     			{

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAnosPendientesParaMuni: error liberando recursos");

 		   	   }  

 		}  		

		if (tr.isTraceActive())

		{

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientesParaMuni: saliendo");                

    		}       	

     	}

     }*/

     

    /* private ResultSet dameAnosPendientes(String codProv,String codMuni,String ano ,Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosSMAnu) throws Exception 

     {

     	ResultSet rs = null;	

     	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameAnosPendientes: entrando");

	   	}

	   	

	   	tablaBDGrupoCuestionariosSMAnu.setDistinct(tablaBDGrupoCuestionariosSMAnu.NOMCOLUMN_Q022CT00_ANO);

	         	tablaBDGrupoCuestionariosSMAnu.setFCA02T00_CODPROVINC_WHERE(new Integer(codProv));

	         	tablaBDGrupoCuestionariosSMAnu.setFCA02T00_CODMUNICIP_WHERE(new Integer(codMuni));

	         	tablaBDGrupoCuestionariosSMAnu.setMUN_PROV_WHERE(codProv);

	         	tablaBDGrupoCuestionariosSMAnu.setMUN_MUNI_WHERE(codMuni);

	         	//tablaBDGrupoCuestionariosSMAnu.setQ022CT00_ANO_WHERE(new Integer(ano));

	         	//tablaBDGrupoCuestionariosSMAnu.setQ022CT00_TIPO_CUESTIONARIO_WHERE(new Integer(tipoCuestionario));

	         	tablaBDGrupoCuestionariosSMAnu.setAditionalWhere(" and  ( " + tablaBDGrupoCuestionariosSMAnu.NOMCOLUMN_Q022CT00_REALIZA_ACTUACION + " = 0 or ( " +  tablaBDGrupoCuestionariosSMAnu.NOMCOLUMN_Q022CT00_REALIZA_ACTUACION + " = 1 and " + tablaBDGrupoCuestionariosSMAnu.NOMCOLUMN_Q022CT00_ID_GRUPO + " in (select distinct(" + tablaBDGrupoCuestionariosSMAnu.NOMCOLUMN_Q022CT00_ID_GRUPO + ") from Q022ES00 where Q022ET00_FEC_BAJA is null)))");

	         	rs = tablaBDGrupoCuestionariosSMAnu.selectDistinct();

	         	tablaBDGrupoCuestionariosSMAnu.addResultSet(rs);     	

	         	return rs;

	        }

	        catch(Exception ex)

     	        {   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameAnosPendientes: " + sw.getBuffer ().toString());

     		throw ex;

     	      }

     	      finally

     	      {

     	      	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameAnosPendientes: saliendo");

	   	}

     	      }

     }*/

     

    /**
     * Funcin que devuelve un string con los meses que le quedan por introducir para un municipio y ao determinados por los parmetros de entrada
     * 
     * @param codProv - Cdigo de la provincia
     * @param codMuni - Cdigo del municipio
     * @param ano - Ao
     * @param idioma - Idioma
     * @return 
     * @throws Exception Exception
     */
    public String obtenerAnosMesesPendientesParaMuni(String codProv,String codMuni,String ano,String idioma) 
    throws Exception {
   	//se definen objetos necesarios.
   	String msgMeses = "";
   	ResultSet rs = null;
   	java.util.Hashtable hashMeses = new java.util.Hashtable();
   	String [] arrNombresMeses = {};
   	Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosSM = null;
      	try{
	    	if (tr.isTraceActive())	{
    	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosMesesPendientesParaMuni: entrando");
    	   	}

	   	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosMesesPendientesParaMuni: idioma="+ idioma);

	   	if(Q70ListenerUtils.getApplicationProperty("IDIOMA_ES").equals(idioma)){
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosMesesPendientesParaMuni: idioma ES");
	   		arrNombresMeses = Q02aAplicationUtils.mesesCas;
	   	}else if(Q70ListenerUtils.getApplicationProperty("IDIOMA_EU").equals(idioma)){
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosMesesPendientesParaMuni: idioma EU");
	   		arrNombresMeses = Q02aAplicationUtils.mesesEus;
	   	}

	   	Calendar c = new GregorianCalendar();	   	

	   	int anoConfig =  Integer.valueOf(Q02aConstantes.getString("q02a.cuestionarios.ayunVtmMen.anosConfig")).intValue();
	   	int anoFinal =  c.get(Calendar.YEAR);
	   	int cont = (anoFinal-anoConfig);
	   	String mesesSinCues = "<br>";
	   	int tam = 0;
	   	int contador;

        for (int j = cont;j <= anoFinal; j++) 	{

	   		contador = 1;

		   	//Se carga el hashtable con los nombres de los  meses

		   	for (int i=1; i<=12; i++)  	{
		   		hashMeses.put(Integer.toString(i),arrNombresMeses[i-1]);
			}

		    	tablaBDGrupoCuestionariosSM = new Q02aTablaBDQ022CS00(this.getConnection());

		    	rs = this.dameMesesConCuesSM(codProv,codMuni,String.valueOf(j),tablaBDGrupoCuestionariosSM);		    	

		         	while (rs.next())
		         	{
		         		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosMesesPendientesParaMuni: Hay cuestionarios SM Men en el mes ****"+ rs.getString(1));
		         		hashMeses.remove(rs.getString(1));
		        	}

		        	if(!hashMeses.isEmpty()){
		        		tam = hashMeses.size();
		        		mesesSinCues += "<br>";	
		        		mesesSinCues += "-" + String.valueOf(j) + ": ";
		        		
		        		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosMesesPendientesParaMuni:Faltan cuestionarios de meter, xq el array hastable no est vacio ****");		        		

		        		for (int i=0; i<12; i++)
		        		{
		        			if (contador < tam)	{    
			        			//Si el array de meses contiene el mes, es que falta de introducir datos, 
			        			if(hashMeses.containsKey(Integer.toString(i+1))){

		        					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosMesesPendientesParaMuni:Falta de introducir el mes  ******* ="+ i);
			        				//if(!mesesSinCues.equals(""))
			        					//mesesSinCues += ", ";
			        				mesesSinCues += hashMeses.get(Integer.toString(i+1));
			        				mesesSinCues += ", ";
			        				contador++;
		        				}
	        				}else{

		        				if(hashMeses.containsKey(Integer.toString(i+1))){
		        					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosMesesPendientesParaMuni:Falta de introducir el mes  ******* ="+ i);
		        					//if(!mesesSinCues.equals(""))
		        					//mesesSinCues += ", ";
		        					mesesSinCues += hashMeses.get(Integer.toString(i+1));
       					
		        					mesesSinCues += ".";
				        		}
		        			}
		        		}
		        	}		        		
     		
		        		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosMesesPendientesParaMuni:Meses sin meter ******* ="+ mesesSinCues);
		        		msgMeses = mesesSinCues;
		        		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosMesesPendientesParaMuni:MSG = ****" + msgMeses);

		        	}

     	return msgMeses;
    	}

    	catch(Exception ex){   	   
    		java.io.StringWriter sw = new java.io.StringWriter();
    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
    		ex.printStackTrace(pw);
    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAnosMesesPendientesParaMuni: " + sw.getBuffer ().toString());
    		throw ex;
    	}finally{

    		try{
    			tablaBDGrupoCuestionariosSM.freeResourcesNotConnection();	
    		}catch(Exception ex){
    			if (tr.isTraceActive())
    			{
    				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAnosMesesPendientesParaMuni: error liberando recursos");
		   	   }  
		}  		

		if (tr.isTraceActive()){
			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosMesesPendientesParaMuni: saliendo");                
   		}       	
    	}

    }

    
    /**
     * 
     * @param codProv codProv
     * @param codMuni codMuni
     * @param ano ano
     * @param tablaBDGrupoCuestionariosSM tablaBDGrupoCuestionariosSM
     * @return rs
     * @throws Exception Exception
     */
    private ResultSet dameMesesConCuesSM(String codProv,String codMuni,String ano ,Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosSM) throws Exception 

    {

    	ResultSet rs = null;	

    	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameMesesConCuesAyunVTMMen: entrando");

	   	}

	   	

	    		tablaBDGrupoCuestionariosSM.setDistinct(tablaBDGrupoCuestionariosSM.NOMCOLUMN_Q22CT00_MES);	         	

	         	tablaBDGrupoCuestionariosSM.setQ022CT00_ANO_WHERE(new Integer(ano));

	         	tablaBDGrupoCuestionariosSM.setMUN_PROV_WHERE(codProv);

	         	tablaBDGrupoCuestionariosSM.setMUN_MUNI_WHERE(codMuni);

	         	//tablaBDGrupoCuestionariosAyunVTMMen.setAditionalWhere(" and  ( " + tablaBDGrupoCuestionariosAyunVTMMen.NOMCOLUMN_Q022BT00_CONCEDIDO_LICEN + " = 0 or ( " +  tablaBDGrupoCuestionariosAyunVTMMen.NOMCOLUMN_Q022BT00_CONCEDIDO_LICEN + " = 1 and " + tablaBDGrupoCuestionariosAyunVTMMen.NOMCOLUMN_Q022BT00_ID_GRUPO + " in (select distinct(" + tablaBDGrupoCuestionariosAyunVTMMen.NOMCOLUMN_Q022BT00_ID_GRUPO + ") from Q022AS00 where Q022AT00_FEC_BAJA is null)))");

	         	///tablaBDGrupoCuestionariosAyunVTMMen.setAditionalWhere(" and  ( (" + tablaBDGrupoCuestionariosAyunVTMMen.NOMCOLUMN_Q022BT00_CONCEDIDO_LICEN + " = 0 and "+tablaBDGrupoCuestionariosAyunVTMMen.NOMCOLUMN_Q022BT00_FEC_FIRMA+" IS NOT NULL ) or ( " +  tablaBDGrupoCuestionariosAyunVTMMen.NOMCOLUMN_Q022BT00_CONCEDIDO_LICEN + " = 1 and " + tablaBDGrupoCuestionariosAyunVTMMen.NOMCOLUMN_Q022BT00_ID_GRUPO + " not in (select distinct(" + tablaBDGrupoCuestionariosAyunVTMMen.NOMCOLUMN_Q022BT00_ID_GRUPO + ") from Q022AS00 where Q022AT00_FIRMADO = 0)))");

	         	rs = tablaBDGrupoCuestionariosSM.selectDistinct();

	         	tablaBDGrupoCuestionariosSM.addResultSet(rs);     	

	         	return rs;

	        }

	        catch(Exception ex)

    	        {   	   

    		java.io.StringWriter sw = new java.io.StringWriter();

    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

    		ex.printStackTrace(pw);

    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameMesesConCuesAyunVTMMen: " + sw.getBuffer ().toString());

    		throw ex;

    	      }

    	      finally

    	      {

    	      	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameMesesConCuesAyunVTMMen: saliendo");

	   	}

    	      }

    }

    
    /**
     * 
     * @param codProv codProv
     * @param codMuni codMuni
     * @param ano ano
     * @param mes mes
     * @param tablaBDGrupoCuestionariosSMAnu tablaBDGrupoCuestionariosSMAnu
     * @param tipoCuestionario tipoCuestionario
     * @return rs
     * @throws Exception Exception
     */
     private ResultSet dameRsGrupoCues(String codProv,String codMuni,String ano, String mes, Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosSMAnu, String tipoCuestionario) throws Exception 

     {

     	ResultSet rs = null;	

     	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameRsGrupoCues: entrando");

	   	}

	   	

	         	tablaBDGrupoCuestionariosSMAnu.setMUN_PROV_WHERE(codProv);

	         	tablaBDGrupoCuestionariosSMAnu.setMUN_MUNI_WHERE(codMuni);

	         	tablaBDGrupoCuestionariosSMAnu.setQ022CT00_ANO_WHERE(new Integer(ano));	

	         	tablaBDGrupoCuestionariosSMAnu.setQ22CT00_MES_WHERE(new Integer(mes));	

	         	//tablaBDGrupoCuestionariosSMAnu.setQ022CT00_TIPO_CUESTIONARIO_WHERE(new Integer(tipoCuestionario));

	         	rs = tablaBDGrupoCuestionariosSMAnu.select();

	         	tablaBDGrupoCuestionariosSMAnu.addResultSet(rs);     	

	         	return rs;

	        }

	        catch(Exception ex)

     	        {   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameRsGrupoCues: " + sw.getBuffer ().toString());

     		throw ex;

     	      }

     	      finally

     	      {

     	      	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameRsGrupoCues: saliendo");

	   	}

     	      }

     }

     /**
      * Mtodo que dado el nmero interno del cuestionarioSMAnu recuperar de la BBDD
      * los datos de dicho cuestionarioSMAnu.
      * @param niCuestionarioSMAnu niCuestionarioSMAnu
      * @param niGrupoCuestionarioSMAnu niGrupoCuestionarioSMAnu
      * @return cuestionarioSMAnuBD
      * @throws Exception Exception
      */

     public Q02aCuestionarioSM obtenerCuestionarioSMAnu(String niCuestionarioSMAnu,String niGrupoCuestionarioSMAnu)throws Exception
     {
   	  if (tr.isTraceActive()){
  		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioSMAnu , ** dao niCuestionarioSMAnu= "+  niCuestionarioSMAnu + ", niGrupoCuestionarioSMAnu=" + niGrupoCuestionarioSMAnu +"  ** entrando");            
         	}
   	  
   	  //se crean los objetos necesarios para ralizar la select.
   	  Q02aTablaBDQ022ES00 Q02aTablaBDQ022ES00obj = null;
   	  Q02aCuestionarioSM cuestionarioSMAnuBD = null;
   	  ResultSet rs = null;   	  
         try{ 
           if (niCuestionarioSMAnu!=null){           
               	Q02aTablaBDQ022ES00obj = new Q02aTablaBDQ022ES00(this.getConnection());
               	
               	//se pone el filtro
               	Q02aTablaBDQ022ES00obj.setQ022ET00_ID_CUES_WHERE(new Long(niCuestionarioSMAnu));
               	Q02aTablaBDQ022ES00obj.setQ022CT00_ID_GRUPO_WHERE(new Integer(niGrupoCuestionarioSMAnu));
               	
               	rs = Q02aTablaBDQ022ES00obj.select();
               	Q02aTablaBDQ022ES00obj.addResultSet(rs); 
               	cuestionarioSMAnuBD = tratarRs(rs);
               	
               	if (cuestionarioSMAnuBD.getCosteSuelo() != null){
               		cambiarPunto(cuestionarioSMAnuBD);
               	}
           }  

           return cuestionarioSMAnuBD;

         }catch(Exception ex){           	   
                  java.io.StringWriter sw = new java.io.StringWriter();
                  java.io.PrintWriter pw = new java.io.PrintWriter(sw);
                  ex.printStackTrace(pw);
                  tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioSMAnu: " + sw.getBuffer ().toString());
                  throw ex;
           }finally{
        	   try{
   	   			 Q02aTablaBDQ022ES00obj.freeResourcesNotConnection();	
   				}catch(Exception ex){
       	   			if (tr.isTraceActive()){
       	   				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioSMAnu: error liberando recursos");
       	   		   	   }  
   				}  	
            	if (tr.isTraceActive()){
            		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioSMAnu: saliendo");                
                }            	 
           }	  


     }//fin obtenerCuestionarioSMAnu

     /**
      * 
      * @param rs rs
      * @return rs
      * @throws Exception Exception
      */
     private Q02aCuestionarioSM  tratarRs (ResultSet rs) throws Exception{

   		  tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":tratarRs: entrando");           

		  Q02aCuestionarioSM cuestionarioSMAnuBD = new Q02aCuestionarioSM();     

	   	  if (rs.next()){	 
	   		 tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":tratarRs: Hay registro");                
	   		 try{
	        	rellenarVOCuestionarioSM(cuestionarioSMAnuBD,rs);
	         }catch (Exception e) {
	        	 if (tr.isTraceActive()){
		   	   		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":tratarRs: error "+ e.getMessage());
		   	   	 }  
	         }  	
	   	  }
	   	  return cuestionarioSMAnuBD;
     } 
     
     /**
      * Funcin que modifica los datos del cuestionarioSMAnu pasado como parmetro en la BBDD
      * 
      * @param cuestionarioSMAnu - Datos de cuestionarioSMAnu a modificar
      * 
      * @throws Exception Exception
      */

     public void modificarCuestionarioSMAnu(Q02aCuestionarioSM cuestionarioSMAnu) throws Exception {

      	if (tr.isTraceActive()){
      	    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioSMAnu: entrando");
      	}

      	//Se isntancian los objetos necesarios.
      	Q02aTablaBDQ022ES00 Q02aTablaBDQ022ES00obj = null;    

      	try{     
         	 	//se crea el objeto de tablasBD
        		Q02aTablaBDQ022ES00obj = new Q02aTablaBDQ022ES00(this.getConnection());
        		//segmento tecnico
             		//Q02aTablaBDQ022AS00obj.setUser(this.getUser());
        		if (cuestionarioSMAnu.getCosteSuelo() != null){
        			this.cambiarComa(cuestionarioSMAnu);
        		}
  		
        		rellenaDatosCuestionarioSMAnu(cuestionarioSMAnu,Q02aTablaBDQ022ES00obj);
           		Q02aTablaBDQ022ES00obj.setQ022ET00_ID_CUES_WHERE(Long.parseLong(cuestionarioSMAnu.getNiCuesSMAnu()));
           		Q02aTablaBDQ022ES00obj.setQ022CT00_ID_GRUPO_WHERE(Integer.parseInt(cuestionarioSMAnu.getNiGrupoCuesSMAnu()));
           		//se realiza la update
           		Q02aTablaBDQ022ES00obj.update();
       		
         }catch(Exception ex){
              java.io.StringWriter sw = new java.io.StringWriter();
              java.io.PrintWriter pw = new java.io.PrintWriter(sw);
              ex.printStackTrace(pw);
              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioSMAnu: " + sw.getBuffer ().toString());
              throw ex;
         }
         finally
         {     
         	try
         	{
    		Q02aTablaBDQ022ES00obj.freeResourcesNotConnection();	
    	}catch(Exception ex){
		   if (tr.isTraceActive()){
			   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioSMAnu: error liberando recursos");
   	   	   }  
    	}  		  
      	if (tr.isTraceActive()){
      		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioSMAnu: saliendo");                
        }             
         }     
     } // fin modificarCuestionarioSMAnu

     /**
      * Funcin que borra el cuestionarioSMAnu pasado como parmetro de la BBDD
      * 
      * @param niCuestionarioSMAnu - nmero interno del cuestionarioSMAnu a borrar
      * @param niGrupoCuestionarioSMAnu niGrupoCuestionarioSMAnu
      * 
      * @throws Exception Exception
      */

     public void borrarCuestionarioSMAnu(String niCuestionarioSMAnu,String niGrupoCuestionarioSMAnu) throws Exception {



    	if (tr.isTraceActive())

      	{

  		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioSMAnu: entrando");

      	}

        	

      	//se crean los objetos necesarios

     	Q02aTablaBDQ022ES00 Q02aTablaBDQ022ES00obj = null;       

          try{       	

         	 //se crea el objeto de tablasBD

         	 Q02aTablaBDQ022ES00obj = new Q02aTablaBDQ022ES00(this.getConnection());

         

         	// segmento tecnico

            //Q02aTablaBDQ022AS00obj.setUser(this.getUser());    	

         	

         	 //se pone el filtro para la delete

         	Q02aTablaBDQ022ES00obj.setQ022ET00_ID_CUES_WHERE(Integer.parseInt(niCuestionarioSMAnu));

         	Q02aTablaBDQ022ES00obj.setQ022CT00_ID_GRUPO_WHERE(Integer.parseInt(niGrupoCuestionarioSMAnu));

          	

         	//se lanza al delete

          	Q02aTablaBDQ022ES00obj.delete();         	

         }

         catch(Exception ex)

         {

              java.io.StringWriter sw = new java.io.StringWriter();

              java.io.PrintWriter pw = new java.io.PrintWriter(sw);

              ex.printStackTrace(pw);

              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioSMAnu: " + sw.getBuffer ().toString());

              throw ex;

         }finally

         {

         	try	{

         		Q02aTablaBDQ022ES00obj.freeResourcesNotConnection();	

         		}

         	catch(Exception ex)

         		{

         			if (tr.isTraceActive())

         				{

         					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioSMAnu: error liberando recursos");

         				}  

         		}  		

         	if (tr.isTraceActive())

         		{

         			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioSMAnu: saliendo");                

         		}     	   

         }

     }//fin borrarCuestionarioSMAnu

     /**
      * 
      * @param niGrupoCuestionarioSMAnu niGrupoCuestionarioSMAnu
      * @throws Exception Exception
      */
     public void borrarGrupoCuestionarioSMAnu(String niGrupoCuestionarioSMAnu) throws Exception {



     	if (tr.isTraceActive())

       	{

   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarGrupoCuestionarioSMAnu: entrando");

       	}

         	

       	//se crean los objetos necesarios

      	Q02aTablaBDQ022CS00 Q02aTablaBDQ022CS00obj = null;       

        try{       	

          	 //se crea el objeto de tablasBD

          	 Q02aTablaBDQ022CS00obj = new Q02aTablaBDQ022CS00(this.getConnection());

          

          	 // segmento tecnico

          	 //Q02aTablaBDQ022AS00obj.setUser(this.getUser());    	

          	

          	 //se pone el filtro para la delete

          	 Q02aTablaBDQ022CS00obj.setQ022CT00_ID_GRUPO_WHERE(Integer.parseInt(niGrupoCuestionarioSMAnu));

           	

          	 //se lanza al delete

           	 Q02aTablaBDQ022CS00obj.delete();         	

          }

        catch(Exception ex)

          {

               java.io.StringWriter sw = new java.io.StringWriter();

               java.io.PrintWriter pw = new java.io.PrintWriter(sw);

               ex.printStackTrace(pw);

               tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarGrupoCuestionarioSMAnu: " + sw.getBuffer ().toString());

               throw ex;

          }

        finally

          {

          	try	{

          		Q02aTablaBDQ022CS00obj.freeResourcesNotConnection();	

          		}

          	catch(Exception ex)

          		{

          			if (tr.isTraceActive())

          				{

          				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarGrupoCuestionarioSMAnu: error liberando recursos");

          				}  

          		}  		

          	if (tr.isTraceActive())

       			{

          			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarGrupoCuestionarioSMAnu: saliendo");                

       			}     	   

          }

      }//fin borrarGrupoCuestionarioSMAnu

     /**
      * resetear1, borra en Q02aTablaBDQ022CS00obj
      * 
      * @param idGrupo idGrupo
      * @throws Exception Exception
      */
    public void resetear1SM(String idGrupo) throws Exception {        

        if (tr.isTraceActive()) {
            tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":resetear1SM: entrando");
        }
        //se instancian los objetos necesarios para realizar la consulta.  
        Q02aTablaBDQ022CS00 Q02aTablaBDQ022CS00obj = null;
        
        try{        
             //se crea el objeto de tablasBD
            Q02aTablaBDQ022CS00obj = new Q02aTablaBDQ022CS00(this.getConnection());
              
             //se pone el filtro para la delete
            Q02aTablaBDQ022CS00obj.setQ022CT00_ID_GRUPO_WHERE( Integer.parseInt(idGrupo) );
            
             //se lanza al delete
            Q02aTablaBDQ022CS00obj.delete();   
             
       }catch(Exception ex){
               java.io.StringWriter sw = new java.io.StringWriter();
               java.io.PrintWriter pw = new java.io.PrintWriter(sw);
               ex.printStackTrace(pw);
               tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":resetear1SM: " + sw.getBuffer ().toString());
               throw ex;
       }finally{
            try {
                Q02aTablaBDQ022CS00obj.freeResourcesNotConnection();    
            }catch(Exception ex){
                    if (tr.isTraceActive()){
                        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":resetear1SM: error liberando recursos");
                    }  
            }       
            if (tr.isTraceActive()){
                    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":resetear1SM: saliendo");                
            }          
        }
       
    }//resetear1SM
    
    /**
     * resetear2, borra en Q02aTablaBDQ022ES00obj
     * 
     * @param idGrupo idGrupo
     * @throws Exception Exception
     */
   public void resetear2SM(String idGrupo) throws Exception { 
       
       if (tr.isTraceActive()) {
           tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":resetear2SM: entrando");
       }
       //se instancian los objetos necesarios para realizar la consulta.  
       Q02aTablaBDQ022ES00 Q02aTablaBDQ022ES00obj = null;
       
       try{         
           //se crean los objetos necesarios
            Q02aTablaBDQ022ES00obj = new Q02aTablaBDQ022ES00(this.getConnection());   
            
            //se pone el filtro para la delete
            Q02aTablaBDQ022ES00obj.setQ022CT00_ID_GRUPO_WHERE( Integer.parseInt(idGrupo) );             
            
            //se lanza el delete
            Q02aTablaBDQ022ES00obj.delete();  
           
       }catch(Exception ex){
              java.io.StringWriter sw = new java.io.StringWriter();
              java.io.PrintWriter pw = new java.io.PrintWriter(sw);
              ex.printStackTrace(pw);
              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":resetear2SM: " + sw.getBuffer ().toString());
              throw ex;
      }finally{
           try {
               Q02aTablaBDQ022ES00obj.freeResourcesNotConnection();    
           }catch(Exception ex){
                   if (tr.isTraceActive()){
                       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":resetear2SM: error liberando recursos");
                   }  
           }       
           if (tr.isTraceActive()){
                   tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":resetear2SM: saliendo");                
           }          
       }
      
   }//resetear2SM

      /**
      * Funcin que modifica la firma del grupo de cuestionarios pasado como parmetro
      * 
      * @param niGrupoCuesSMAnu niGrupoCuesSMAnu
      * @param xmlFirmaGrupoCuestionariosSMAnu xmlFirmaGrupoCuestionariosSMAnu
      * @throws Exception Exception
      */

     public void guardarFirmaGrupoCuestionariosSMAnu(String niGrupoCuesSMAnu,String xmlFirmaGrupoCuestionariosSMAnu) throws Exception {  



      	if (tr.isTraceActive()){

  		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosSMAnu: entrando");

  	}

      	//Se instancian los objetos necesarios.

      	StringBuffer queryClob= new StringBuffer();

      	Q02aTablaBDQ022CS00 Q02aTablaBDQ022CS00obj = null;    

         	 try

         	 {     

         	 	//se crea el objeto de tablasBD

        		Q02aTablaBDQ022CS00obj = new Q02aTablaBDQ022CS00(this.getConnection());

        		//segmento tecnico

             		//Q02aTablaBDQ022AS00obj.setUser(this.getUser());

  		

       		Q02aTablaBDQ022CS00obj.setQ022CT00_ID_GRUPO_WHERE(new Integer(niGrupoCuesSMAnu));

       		//Este campo se actualiza de forma especial, con una select for update de este campo

       		//Q02aTablaBDQ022BS00obj.setQ022BT00_XML_FIRMADO(xmlFirmaGrupoCuestionariosSMAnu);

       		//Q02aTablaBDQ022CS00obj.setQ022CT00_FEC_FIRMA(new java.util.Date(System.currentTimeMillis()));

       		//De momento el usuario lo metemos vacio

       		//Q02aTablaBDQ022BS00obj.setQ022BT00_USER_FIRMA();

       		//se realiza la update

       		Q02aTablaBDQ022CS00obj.update();

       		

       		//Se realiza la query de los CLOB

	    	//queryClob.append("SELECT ").append(Q02aTablaBDQ022CS00obj.NOMCOLUMN_Q022CT00_XML_FIRMADO).append(" FROM  Q022CS00 WHERE ").append(Q02aTablaBDQ022CS00obj.NOMCOLUMN_Q022CT00_ID_GRUPO).append(" = " ).append(niGrupoCuesSMAnu).append(" FOR UPDATE");

	    	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosSMAnu->queryClob="+ queryClob.toString());

	    	//Se inserta el Clob

	    	Q02aBDUtilidades.insertClob(xmlFirmaGrupoCuestionariosSMAnu,queryClob.toString(),this.getConnection());

       		

         }

         catch(Exception ex)

         {

              java.io.StringWriter sw = new java.io.StringWriter();

              java.io.PrintWriter pw = new java.io.PrintWriter(sw);

              ex.printStackTrace(pw);

              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosSMAnu: " + sw.getBuffer ().toString());

              throw ex;

         }

         finally

         {     

         	try

         	{

    		Q02aTablaBDQ022CS00obj.freeResourcesNotConnection();	

    	}

    	catch(Exception ex)

    	{

		   if (tr.isTraceActive())

		   {

			   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosSMAnu: error liberando recursos");

   	   	   }  

    	}  		  

      	if (tr.isTraceActive())

      	{

      		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosSMAnu: saliendo");                

                      }             

         }     

     } // fin guardarFirmaGrupoCuestionariosSMAnu 

     

     /**
      * Funcin que devuelve el campo Concede Licencias para un municipio,ao y mes determinados por los parmetros de entrada
      * 
      * @param codProv - Cdigo de la provincia
      * @param codMuni - Cdigo del municipio
      * @param ano - Ao
      * @param mes - Mes
      * @param tipoCuestionario - tipoCuestionario
      * @throws Exception Exception
      * @return hayCuestionarios
      */
     public boolean obtenerNumCuestionarios(String codProv,String codMuni,String ano,String mes, String tipoCuestionario) throws Exception {

    	//se definen objetos necesarios.

    	boolean hayCuestionarios = false;

    	ResultSet rs = null;

       	Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosSM = null;

       	Q02aTablaBDQ022ES00 tablaBDCuestionariosSM = null;

       	int numero = -1;

       	try{

	    	if (tr.isTraceActive()){

	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNumCuestionarios: entrando");

	    	}

	   	

	    	tablaBDGrupoCuestionariosSM = new Q02aTablaBDQ022CS00(this.getConnection());

	    	tablaBDCuestionariosSM = new Q02aTablaBDQ022ES00(this.getConnection());

	    	

	    	//hacer un metodo nuevo

	    	rs = this.dameRsNumCues(codProv,codMuni,ano,mes,tipoCuestionario,tablaBDGrupoCuestionariosSM,tablaBDCuestionariosSM);

	        if (rs.next())

	        {

	        	numero = rs.getInt(1);

	        	if (numero > 0)

	        	{

	        		hayCuestionarios = true;

	        	}

	        	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNumCuestionarios: entrando");

	        }

	        	

      		return hayCuestionarios;

     	}

     	catch(Exception ex)

     	{   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerNumCuestionarios: " + sw.getBuffer ().toString());

     		throw ex;

     	}

     	finally

     	{

     		try

     		{

     			tablaBDGrupoCuestionariosSM.freeResourcesNotConnection();	

     		}

     		catch(Exception ex)

     		{

     			if (tr.isTraceActive())

     			{

     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoConcedeLicenDeGrupoConMuniAnoYMes: error liberando recursos");

 		   	   }  

 		}  		

		if (tr.isTraceActive())

		{

			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoConcedeLicenDeGrupoConMuniAnoYMes: saliendo");                

    		}       	

     	}

     }

    
     /**
      * 
      * @param codProv codProv
      * @param codMuni codMuni
      * @param ano ano
      * @param mes mes
      * @param tipoCuestionario tipoCuestionario
      * @param tablaBDGrupoCuestionariosSM tablaBDGrupoCuestionariosSM
      * @param tablaBDCuestionariosSM tablaBDCuestionariosSM
      * @return rs
      * @throws Exception Exception
      */
     private ResultSet dameRsNumCues(String codProv,String codMuni,String ano ,String mes,String tipoCuestionario,Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosSM,Q02aTablaBDQ022ES00 tablaBDCuestionariosSM) throws Exception 

     {

     	ResultSet rs = null;	

     	try{

	    	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameRsNumCues: entrando");

	   	}

	    	

	    	//tablaBDCuestionariosSM.setAditionalWhere("AND " + tablaBDCuestionariosSM.NOMCOLUMN_Q022CT00_ID_GRUPO + " in (select " + tablaBDGrupoCuestionariosSM.NOMCOLUMN_Q022CT00_ID_GRUPO + " from Q022CS00 where " + tablaBDGrupoCuestionariosSM.NOMCOLUMN_Q022CT00_ANO + " = " + ano + " and " + tablaBDGrupoCuestionariosSM.NOMCOLUMN_Q22CT00_MES + " = " + mes + " and " + tablaBDGrupoCuestionariosSM.NOMCOLUMN_Q022CT00_TIPO_CUESTIONARIO + " = " + tipoCuestionario + " and " + tablaBDGrupoCuestionariosSM.NOMCOLUMN_MUN_PROV + " = " + codProv + " and " + tablaBDGrupoCuestionariosSM.NOMCOLUMN_MUN_MUNI + " = " + codMuni + " ) and " + tablaBDCuestionariosSM.NOMCOLUMN_Q022ET00_FEC_BAJA + " is NULL");

	    	tablaBDCuestionariosSM.setAditionalWhere("AND " + tablaBDCuestionariosSM.NOMCOLUMN_Q022CT00_ID_GRUPO + " in (select " + tablaBDGrupoCuestionariosSM.NOMCOLUMN_Q022CT00_ID_GRUPO + " from Q022CS00 where " + tablaBDGrupoCuestionariosSM.NOMCOLUMN_Q022CT00_ANO + " = " + ano + " and " + tablaBDGrupoCuestionariosSM.NOMCOLUMN_Q22CT00_MES + " = " + mes +  " and " + tablaBDGrupoCuestionariosSM.NOMCOLUMN_MUN_PROV + " = " + codProv + " and " + tablaBDGrupoCuestionariosSM.NOMCOLUMN_MUN_MUNI + " = " + codMuni + " ) and " + tablaBDCuestionariosSM.NOMCOLUMN_Q022ET00_FEC_BAJA + " is NULL");

	    	rs = tablaBDCuestionariosSM.selectCount();

	    	tablaBDCuestionariosSM.addResultSet(rs);     	

	        return rs;

	     }

	        catch(Exception ex)

     	        {   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameRsNumCues: " + sw.getBuffer ().toString());

     		throw ex;

     	      }

     	      finally

     	      {

     	      	if (tr.isTraceActive())

	    	{

	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameRsGrupoCues: saliendo");

	   	}

     	      }

     }

    
     /**
      * 
      * @param niGrupoCuesSMAnu niGrupoCuesSMAnu
      * @return numCuestionarios
      * @throws Exception Exception
      */
     public int actualizarNumCuestionariosRellenados(String niGrupoCuesSMAnu) throws Exception 
     {
    	int numCuestionarios=0;
    	ResultSet rs = null;
       	Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosSMAnu = null;

        try{
		    	if (tr.isTraceActive()){

		    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":actualizarNumCuestionariosRellenados: entrando");

		    	}

		    	tablaBDGrupoCuestionariosSMAnu = new Q02aTablaBDQ022CS00(this.getConnection());
		    	//tablaBDGrupoCuestionariosSMAnu.addColumnSelect(tablaBDGrupoCuestionariosSMAnu.NOMCOLUMN_Q022CT00_ID_GRUPO);
		    	tablaBDGrupoCuestionariosSMAnu.addColumnSelect(tablaBDGrupoCuestionariosSMAnu.NOMCOLUMN_Q022CT00_NCUS);
		    	tablaBDGrupoCuestionariosSMAnu.setQ022CT00_ID_GRUPO_WHERE(Integer.parseInt(niGrupoCuesSMAnu));
		    	//tablaBDGrupoCuestionariosSMAnu.setQ022CT00_ANO_WHERE(Q02aFormatData.checkIntegerNull(cuesSMAnuFiltro.getAno()));
			   	//tablaBDGrupoCuestionariosSMAnu.setQ22CT00_MES_WHERE(Q02aFormatData.checkIntegerNull(cuesSMAnuFiltro.getMes()));
			   	//tablaBDGrupoCuestionariosSMAnu.setMUN_PROV_WHERE(Q02aFormatData.checkStringNull(cuesSMAnuFiltro.getCodProv()));
			   	//tablaBDGrupoCuestionariosSMAnu.setMUN_MUNI_WHERE(Q02aFormatData.checkStringNull(cuesSMAnuFiltro.getCodMuni()));
			   	rs=tablaBDGrupoCuestionariosSMAnu.select();
			   	tablaBDGrupoCuestionariosSMAnu.addResultSet(rs);
			   	if (rs.next()){
			   		numCuestionarios = rs.getInt(tablaBDGrupoCuestionariosSMAnu.NOMCOLUMN_Q022CT00_NCUS)+1;
			   	}	  
			   	
			   	tablaBDGrupoCuestionariosSMAnu.clearColumnsSelect();
			   	tablaBDGrupoCuestionariosSMAnu.setQ022CT00_NCUS(numCuestionarios);
			   	tablaBDGrupoCuestionariosSMAnu.setQ022CT00_ID_GRUPO_WHERE(Integer.parseInt(niGrupoCuesSMAnu));
			   	tablaBDGrupoCuestionariosSMAnu.update();
			   	
		        if (tr.isTraceActive()){
			    	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":actualizarNumCuestionariosRellenados: saliendo");
			    }
		        return numCuestionarios;

	        }

	        catch(Exception ex){   	   

	     		java.io.StringWriter sw = new java.io.StringWriter();

	     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	     		ex.printStackTrace(pw);

	     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":actualizarNumCuestionariosRellenados: " + sw.getBuffer ().toString());

	     		throw ex;

     	    }

	 }

     
     /**
      * 
      * @param territorio territorio
      * @param municipio municipio
      * @param anyoReferencia anyoReferencia
      * @param mesReferencia mesReferencia
      * @return numCuestionariosSM
      * @throws Exception Exception
      */
     public int getNumCuestionariosSM(String territorio, String  municipio, String  anyoReferencia, String  mesReferencia) throws Exception 
     {
    	int numCuestionariosSM = 0;
    	ResultSet rs = null;
       	PreparedStatement prepStmt = null;	
       	StringBuffer query = null;

        try {
	    	if (tr.isTraceActive()) {
	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosSM: entrando");
	    	}
	    	query = new StringBuffer("SELECT COUNT(*) FROM Q022ES01V01 WHERE");
        	query.append(" Q022CT00_ANO=").append(anyoReferencia);
        	query.append(" AND MUN_PROV='").append(territorio).append("'");
        	query.append(" AND MUN_MUNI='").append(municipio).append("'");
            
        	if (!Q02aFormatData.esNull(mesReferencia).equals("")) { //Si se llama desde la portada SM 2008, l mes no vendr informado
        	    query.append(" AND Q22CT00_MES=").append(mesReferencia);
            }
            
        	prepStmt = this.getConnection().prepareStatement(query.toString());
        	rs = prepStmt.executeQuery(); 
            
   	 		if (rs.next()) {
   	 			numCuestionariosSM = rs.getInt(1);
   	 		}
		   	
	        if (tr.isTraceActive()) {
		    	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosSM: saliendo");
		    }
	        return numCuestionariosSM;
	       } catch (Exception ex) {   	   
	     		java.io.StringWriter sw = new java.io.StringWriter();
	     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	     		ex.printStackTrace(pw);
	     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosSM: " + sw.getBuffer ().toString());
	     		throw ex;
     	    } finally { 
	    	   try {
	    		   if (rs != null) {
	    		           rs.close();
	    		   }
	       		   if (prepStmt != null) {
	       			       prepStmt.close();
                   }
	          } catch (Exception ex) {
	        	  java.io.StringWriter sw = new java.io.StringWriter();
		          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
		          ex.printStackTrace(pw);
		          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: " + sw.getBuffer ().toString());
		          throw new Q02aDAOException(ex);
	          }
     	    }
	 }
     
     /**
      * 
      * @param niGrupoCuestionarioSMAnu niGrupoCuestionarioSMAnu
      * @return numCuestionariosSM
      * @throws Exception Exception
      */
     public int getNumCuestionariosSM(String niGrupoCuestionarioSMAnu) throws Exception 
     {
    	int numCuestionariosSM=0;
    	ResultSet rs = null;
       	PreparedStatement prepStmt =null;	

       	StringBuffer query = null;

     	try{

	    	if (tr.isTraceActive())

	    		{

	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosSM: entrando");

	    		}

	    	query = new StringBuffer("SELECT COUNT(*) FROM Q022ES01V01 WHERE");

        	query.append(" Q022CT00_ID_GRUPO =").append(niGrupoCuestionarioSMAnu);

        	prepStmt = this.getConnection().prepareStatement(query.toString());

        	rs = prepStmt.executeQuery(); 

   	 		if(rs.next())

   	 			{

   	 				numCuestionariosSM = rs.getInt(1);

   	 			}

		   	if (tr.isTraceActive())

		   		{

		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosSM: saliendo");

		   		}

	        return numCuestionariosSM;

	       }

     	catch(Exception ex){   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosSM: " + sw.getBuffer ().toString());

     		throw ex;

     	    }

     	finally{ 

     		try{

     			if (rs!=null){
     				rs.close();
                }
     			if (prepStmt!=null){
     				prepStmt.close();
                }
	         }
     		catch(Exception ex){
		    	  java.io.StringWriter sw = new java.io.StringWriter();
		          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
		          ex.printStackTrace(pw);
		          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosSM: " + sw.getBuffer ().toString());
		          throw new Q02aDAOException(ex);
	         }
     	}
	 }//fin getNumCuestionariosSM
     
     /**
      * 
      * @param territorio territorio
      * @param municipio municipio
      * @param anyoReferencia anyoReferencia
      * @param mesReferencia mesReferencia
      * @return numCuestionariosOM
      * @throws Exception Exception
      */
     public int getNumCuestionariosOM(String territorio, String  municipio, String  anyoReferencia, String  mesReferencia) throws Exception 
     {
    	int numCuestionariosOM=0;
    	ResultSet rs = null;
       	PreparedStatement prepStmt =null;	

       	StringBuffer query = null;

     	try{

	    	if (tr.isTraceActive()){

	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosOM: entrando");

	    	}

	    	query = new StringBuffer("SELECT COUNT(*) FROM Q022DS01V01 WHERE");

        	query.append(" Q022BT00_ANO=").append(anyoReferencia);

        	query.append(" AND FCA02T00_CODPROVINC='").append(territorio).append("'");

        	query.append(" AND FCA02T00_CODMUNICIP='").append(municipio).append("'");

        	if(!Q02aFormatData.esNull(mesReferencia).equals("")){ //Si se llama desde la portada SM 2008, l mes no vendr informado
        		query.append(" AND Q022BT00_MES=").append(mesReferencia);
            }
        	prepStmt = this.getConnection().prepareStatement(query.toString());

        	

   	 		rs = prepStmt.executeQuery(); 

   	 		if(rs.next()){

   	 			numCuestionariosOM = rs.getInt(1);

   	 		}

	        if (tr.isTraceActive()){

		    	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosOM: saliendo");

		    }

	        return numCuestionariosOM;

	       }catch(Exception ex){   	   

	     		java.io.StringWriter sw = new java.io.StringWriter();

	     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

	     		ex.printStackTrace(pw);

	     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosOM: " + sw.getBuffer ().toString());

	     		throw ex;

     	    }finally{ 

	    	   try{

	    		   if (rs!=null){
	    			   rs.close();
                   }
	       		   if (prepStmt!=null){
	       			   prepStmt.close();
                   }
	          }catch(Exception ex){
	        	  java.io.StringWriter sw = new java.io.StringWriter();
		          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
		          ex.printStackTrace(pw);
		          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: " + sw.getBuffer ().toString());
		          throw new Q02aDAOException(ex);
	          }
	       }
	 }
     
     /**
      * 
      * @param territorio territorio
      * @param municipio municipio
      * @param anyoReferencia anyoReferencia
      * @param mesReferencia mesReferencia
      * @return numCuestionariosVA
      * @throws Exception Exception
      */
     public int getNumCuestionariosVA(String territorio, String  municipio, String  anyoReferencia, String  mesReferencia) throws Exception 
     {
    	int numCuestionariosVA=0;
    	ResultSet rs = null;
       	PreparedStatement prepStmt =null;	
       	StringBuffer query = null;
     	try{

	    	if (tr.isTraceActive()){
	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosVA: entrando");
	    	}

	    	query = new StringBuffer("SELECT COUNT(*) FROM Q022GS00 WHERE");
        	query.append(" Q022GT00_ANO=").append(anyoReferencia);
        	query.append(" AND Q022GT00_MUN_PROV='").append(territorio).append("'");
        	query.append(" AND Q022GT00_MUN_MUNI='").append(municipio).append("'");	
        	prepStmt = this.getConnection().prepareStatement(query.toString());
        	
   	 		rs = prepStmt.executeQuery(); 
   	 		if(rs.next()){
   	 		numCuestionariosVA = rs.getInt(1);
   	 		}
	        if (tr.isTraceActive()){
		    	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosVA: saliendo");
		    }
	        return numCuestionariosVA;

	       }catch(Exception ex){   	   
	     		java.io.StringWriter sw = new java.io.StringWriter();
	     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	     		ex.printStackTrace(pw);
	     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosVA: " + sw.getBuffer ().toString());
	     		throw ex;
     	    }finally{ 

	    	   try{

	    		   if (rs!=null){
	    			   rs.close();
                   }
	       		   if (prepStmt!=null){
	       			   prepStmt.close();
                   }
	          }catch(Exception ex){
	        	  java.io.StringWriter sw = new java.io.StringWriter();
		          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
		          ex.printStackTrace(pw);
		          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: " + sw.getBuffer ().toString());
		          throw new Q02aDAOException(ex);
	          }
     	    }
     }
     
     /**
      * 
      * @param territorio territorio
      * @param municipio municipio
      * @param anyoReferencia anyoReferencia
      * @param mesReferencia mesReferencia
      * @return prevSueloInicial
      * @throws Exception Exception
      */
     public String getPrevisionGrupoCuesSM(String territorio, String  municipio, String  anyoReferencia, String  mesReferencia) throws Exception 
     {
    	String prevSueloInicial="";
    	ResultSet rs = null;
       	PreparedStatement prepStmt =null;	
       	StringBuffer query = null;

     	try{
	    	if (tr.isTraceActive()){
	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getPrevisionGrupoCuesSM: entrando");
	    	}
	    	query = new StringBuffer("SELECT Q022CT00_REALIZA_ACTUACION FROM Q022CS00 WHERE");
        	query.append(" Q022CT00_ANO=").append(anyoReferencia);
        	query.append(" AND MUN_PROV='").append(territorio).append("'");
        	query.append(" AND MUN_MUNI='").append(municipio).append("'");	  

        	if(!Q02aFormatData.esNull(mesReferencia).equals("")){ //Si se llama desde la portada SM 2008, l mes no vendr informado
        		query.append(" AND Q22CT00_MES=").append(mesReferencia);
            }
        	prepStmt = this.getConnection().prepareStatement(query.toString());
        	
   	 		rs = prepStmt.executeQuery(); 
   	 		if(rs.next()){
   	 			prevSueloInicial = rs.getString(1);
   	 		}

	        if (tr.isTraceActive()){
		    	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getPrevisionGrupoCuesSM: saliendo");
		    }

	        return prevSueloInicial;

	       }catch(Exception ex){   	   
	     		java.io.StringWriter sw = new java.io.StringWriter();
	     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	     		ex.printStackTrace(pw);
	     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getPrevisionGrupoCuesSM: " + sw.getBuffer ().toString());
	     		throw ex;
     	    }finally{ 
	    	   try{
	    		   if (rs!=null){
	    			   rs.close();
                   }
	       		   if (prepStmt!=null){
	       			   prepStmt.close();
                   }
	          }catch(Exception ex){
	        	  java.io.StringWriter sw = new java.io.StringWriter();
		          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
		          ex.printStackTrace(pw);
		          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: " + sw.getBuffer ().toString());
		          throw new Q02aDAOException(ex);
	          }
     	    }
     }
     
     /**
      * 
      * @param territorio territorio
      * @param municipio municipio
      * @param anyoReferencia anyoReferencia
      * @param mesReferencia mesReferencia
      * @return prevSueloInicial
      * @throws Exception Exception
      */
     public String getObservacionesCuesSM(String territorio, String  municipio, String  anyoReferencia, String  mesReferencia) throws Exception 
     {
        String prevSueloInicial="";
        ResultSet rs = null;
        PreparedStatement prepStmt =null;   
        StringBuffer query = null;

        try{
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getObservacionesCuesSM: entrando");
            }
            query = new StringBuffer("SELECT Q022CT00_REALIZA_ACTUACION, Q022CT00_OBSSU FROM Q022CS00 WHERE");
            query.append(" Q022CT00_ANO=").append(anyoReferencia);
            query.append(" AND MUN_PROV='").append(territorio).append("'");
            query.append(" AND MUN_MUNI='").append(municipio).append("'");    

            query.append(" AND Q22CT00_MES=").append(mesReferencia);
            
            prepStmt = this.getConnection().prepareStatement(query.toString());
            
            rs = prepStmt.executeQuery(); 
            
            if (rs.next()) {
                prevSueloInicial = rs.getString(2)== null?"":( rs.getString(2) );
            }else{
                prevSueloInicial = "noExistRegSM";
            }

            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getObservacionesCuesSM: saliendo");
            }

            return prevSueloInicial;

           }catch(Exception ex){       
                java.io.StringWriter sw = new java.io.StringWriter();
                java.io.PrintWriter pw = new java.io.PrintWriter(sw);
                ex.printStackTrace(pw);
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getObservacionesCuesSM: " + sw.getBuffer ().toString());
                throw ex;
            }finally{ 
               try{
                   if (rs!=null){
                       rs.close();
                   }
                   if (prepStmt!=null){
                       prepStmt.close();
                   }
              }catch(Exception ex){
                  java.io.StringWriter sw = new java.io.StringWriter();
                  java.io.PrintWriter pw = new java.io.PrintWriter(sw);
                  ex.printStackTrace(pw);
                  tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getObservacionesCuesSM: " + sw.getBuffer ().toString());
                  throw new Q02aDAOException(ex);
              }
            }
     }
     
     /**

      * Funcin que eliminar grupo y cuestionarios de suelo de las tabla Q022CT00 y Q022ET00   
      * 
      * @param ano  - ano (que ser 2008)
      * @param codProvincia - provincia
      * @param codMunicipio - municipio 
      * 
      * @throws Exception Exception
      */
     public void  eliminarCuestionariosSM(String ano, String codProvincia, String codMunicipio) throws Exception {

    	 Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosSM = null;

    	 Q02aTablaBDQ022ES00 tablaBDCuestionariosSM = null;

    	 ResultSet rs = null;

    	 try{

	    	if (tr.isTraceActive()){

	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":eliminarCuestionariosSM: entrando");

	    	}

	    	tablaBDGrupoCuestionariosSM = new Q02aTablaBDQ022CS00(this.getConnection());

	    	tablaBDCuestionariosSM = new Q02aTablaBDQ022ES00(this.getConnection());

	    	

	    	tablaBDGrupoCuestionariosSM.setQ022CT00_ANO_WHERE(Integer.parseInt(ano));

	    	tablaBDGrupoCuestionariosSM.setMUN_PROV_WHERE(codProvincia);

	    	tablaBDGrupoCuestionariosSM.setMUN_MUNI_WHERE(codMunicipio);

	    	rs = tablaBDGrupoCuestionariosSM.select();

	    	tablaBDGrupoCuestionariosSM.addResultSet(rs);

	    	while(rs.next()){

	    		//Eliminamos los cuestionarios

	    		//eliminarCuestionariosSM(rs.getString(tablaBDGrupoCuestionariosSM.NOMCOLUMN_Q022CT00_ID_GRUPO),tablaBDCuestionariosSM);

	    		//tablaBDCuestionariosSM.reset();

	    		tablaBDCuestionariosSM.setQ022CT00_ID_GRUPO_WHERE(Integer.parseInt(rs.getString(tablaBDGrupoCuestionariosSM.NOMCOLUMN_Q022CT00_ID_GRUPO)));

	    		tablaBDCuestionariosSM.delete();

	    	}

	    	//Eliminamos los grupos

	    	//tablaBDGrupoCuestionariosSM.reset();

	    	tablaBDGrupoCuestionariosSM.setQ022CT00_ANO_WHERE(Integer.parseInt(ano));

	    	tablaBDGrupoCuestionariosSM.setMUN_PROV_WHERE(codProvincia);

	    	tablaBDGrupoCuestionariosSM.setMUN_MUNI_WHERE(codMunicipio);

	    	tablaBDGrupoCuestionariosSM.delete();

	 	}

     	catch(Exception ex){   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":eliminarCuestionariosSM: " + sw.getBuffer ().toString());

     		throw ex;

     	}

     	finally{

    		try{

    			tablaBDGrupoCuestionariosSM.freeResourcesNotConnection();	

    			tablaBDCuestionariosSM.freeResourcesNotConnection();	

    		}

    		catch(Exception ex){

    			if (tr.isTraceActive()){

    				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":eliminarCuestionariosSM: error liberando recursos");

    			}  

    		}

     	}

   }

     /**
      * 
      * @param niGrupoCuestionarioSMAnu niGrupoCuestionarioSMAnu
      * @return numCuestionarios
      * @throws Exception Exception
      */
	public int getCountGrupoCuestionarioSM(String niGrupoCuestionarioSMAnu) throws Exception {

		ResultSet rs = null;
    	int numCuestionarios = 0;

    	try{

	    	if (tr.isTraceActive()){
	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGrupoCuestionariosSMAnu: entrando");
	    	}

	    	Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosSMAnu = new Q02aTablaBDQ022CS00(this.getConnection());
	    	tablaBDGrupoCuestionariosSMAnu.setQ022CT00_ID_GRUPO(Integer.parseInt(niGrupoCuestionarioSMAnu));
		
		   	rs=tablaBDGrupoCuestionariosSMAnu.selectCount();
		   	tablaBDGrupoCuestionariosSMAnu.addResultSet(rs);

		   	if (rs.next()){          		 
         	 	 numCuestionarios =  rs.getInt(1);
         	}
	     }catch(Exception ex){   	   
    		java.io.StringWriter sw = new java.io.StringWriter();
    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
    		ex.printStackTrace(pw);
    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGrupoCuestionariosSMAnu: " + sw.getBuffer ().toString());
    		throw ex;
    	  }
		return numCuestionarios;
	}

    
	/**
     * 
     * @param territorio territorio
     * @param municipio municipio
     * @param anyoReferencia anyoReferencia
     * @param mesReferencia mesReferencia
     * @return resultado
     * @throws Exception Exception
	 */
	public String getNiGrupoCuesSM(String territorio, String municipio, String anyoReferencia, String mesReferencia) throws Exception

	{

		//se definen objetos necesarios. 	
      	Q02aTablaBDQ022CS00 tablaBDGrupoCuestionariosSMAnu = null;
      	int niGrupoCuesSMAnu = 0;
      	String resultado = "";
      	ResultSet rs = null;
      	
      	try{
	    	if (tr.isTraceActive())
	    	{
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNiGrupoCuesSM: entrando");
	   	}

   		//se crea el objeto de tablasBD
	    	
	    	tablaBDGrupoCuestionariosSMAnu = new Q02aTablaBDQ022CS00(this.getConnection());

	    	tablaBDGrupoCuestionariosSMAnu.setQ022CT00_ANO_WHERE(Integer.parseInt(anyoReferencia));
		   	tablaBDGrupoCuestionariosSMAnu.setMUN_PROV_WHERE(territorio);
		   	tablaBDGrupoCuestionariosSMAnu.setMUN_MUNI_WHERE(municipio);

		   	if(mesReferencia!=null && !mesReferencia.equals("")){
		   		tablaBDGrupoCuestionariosSMAnu.setQ22CT00_MES_WHERE(Integer.parseInt(mesReferencia));
            }
	   	
		   	rs=tablaBDGrupoCuestionariosSMAnu.select();
		   	tablaBDGrupoCuestionariosSMAnu.addResultSet(rs);
		   	if (rs.next()){
		   		niGrupoCuesSMAnu = rs.getInt(1);
         	}	 
		    if (niGrupoCuesSMAnu==0){
		    	resultado="";
		    }else {
      			resultado = Integer.toString(niGrupoCuesSMAnu);;
		    }
     		return resultado;
    	}	catch(Exception ex) {   	   
        		java.io.StringWriter sw = new java.io.StringWriter();
        		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
        		ex.printStackTrace(pw);
        		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNiGrupoCuesSM: " + sw.getBuffer ().toString());
        		throw ex;
    	}finally{
    		try
    		{
    			tablaBDGrupoCuestionariosSMAnu.freeResourcesNotConnection();	
    		}
    		catch(Exception ex)
    		{
    			if (tr.isTraceActive())
    			{
    				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNiGrupoCuesSM: error liberando recursos");
		   	 }  
		}  		
		if (tr.isTraceActive()){
			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNiGrupoCuesSM: saliendo");                
   		}       	
    	}

	}

	

   /*private void eliminarCuestionariosSM(String niGrupoCuestinariosSM,Q02aTablaBDQ022ES00 tablaBDCuestionariosSMAnu) throws Exception 

   {

    	ResultSet rs = null;

       	try{

	    	if (tr.isTraceActive()){

	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":eliminarCuestionariosSM: entrando");

	    	}

	    	tablaBDCuestionariosSMAnu.reset();

	    	tablaBDCuestionariosSMAnu.setQ022CT00_ID_GRUPO_WHERE(Integer.parseInt(niGrupoCuestinariosSM));

	    	tablaBDCuestionariosSMAnu.delete();

	    	if (tr.isTraceActive()){

	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":eliminarCuestionariosSM: saliendo");

	    	}

	     }

       	 catch(Exception ex){   	   

     		java.io.StringWriter sw = new java.io.StringWriter();

     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);

     		ex.printStackTrace(pw);

     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":eliminarCuestionariosSM: " + sw.getBuffer ().toString());

     		throw ex;

     	  }

	}*/

     

}

