package q02a.exe.cuestionariosSMAnu.beans;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

import javax.ejb.EJBException;
import javax.naming.NamingException;

import q02a.exe.arquitectura.beans.Q02aBaseBean;
import q02a.exe.comun.Q02aUsuarioInformanteDataBaseDAO;
import q02a.exe.comun.dataobjects.Q02aNoraDataBaseDAO;
import q02a.exe.comun.dataobjects.Q02aTablasDataBaseDAO;
import q02a.exe.comun.valueobjects.Q02aPortal;
import q02a.exe.contactos.dataobjects.Q02aContactosDataBaseDAO;
import q02a.exe.contactos.valueobjects.Q02aContactos;
import q02a.exe.cuestionariosSMAnu.dataobjects.Q02aCuestionariosSMDataBaseDAO;
import q02a.exe.cuestionariosSMAnu.valueobjects.Q02aCuestionarioSM;
import q02a.exe.cuestionariosSMAnu.valueobjects.Q02aCuestionarioSMFiltro;
import q02a.exe.cuestionariosVTMAnu.dataobjects.Q02aCuestionariosVTMAnuDataBaseDAO;
import q02a.exe.cuestionariosVTMAnu.valueobjects.Q02aCuestionarioVTMFiltro;
import q02a.exe.informantes.dataobjects.Q02aInformantesDataBaseDAO;
import q02a.exe.informantes.valueobjects.Q02aInformante;
import q02a.exe.solicitudesNora.dataobjects.Q02aSolicitudesNoraDataBaseDAO;
import q02a.exe.solicitudesNora.valueobjects.Q02aSolicitudNora;
import q02a.exe.utils.Q02aConstantes;
import q02a.exe.utils.Q02aFormatData;
import q02a.exe.utils.Q02aVoUtils;
import es.ejie.frmk.conectores.conectorJDBC.Q70ConectorJDBC;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

/**
 * 
 * @author GADIMAAR
 *
 */   
public class Q02aCuestionariosSMBean extends Q02aBaseBean{
    
	private static final long serialVersionUID = 5474311672836163390L;
	protected Q02aCuestionariosSMDataBaseDAO daoCuestionariosSMAnu = null;
	protected Q02aSolicitudesNoraDataBaseDAO daoSolicitudesNora = null;
	protected Q02aNoraDataBaseDAO daoNora = null;
	protected Q02aTablasDataBaseDAO daoTablas = null;
    
	final static String	LISTA_CUESTIONARIOS_SM = "listaCuestionariosSMAnu";
	//Q70ContextoEJIE q70contextoejie = (Q70ContextoEJIE)request.getSession().getAttribute("contexto");
	//ArrayList listaCues= (ArrayList)q70contextoejie.get("listaCuestionariosSMAnu");
	 /** Constructor vacio */
    public Q02aCuestionariosSMBean() {
        super();
    }

        
    /**
     * Funcin que recupera los cuestionarios de suelo municipal con los datos introducidos en el filtro (pgina de portada)
     * 
     * @param mapaFiltroPortadaCuestionarioSM - Datos de los cuestionarios a consultar
     * @return listaCuestionariosSMAnu  -  Listado de cuestionarios obtenidos
     * @throws Exception Exception
     */

	public ArrayList getCuestionariosSM(HashMap mapaFiltroPortadaCuestionarioSM) throws Exception 
	{
		 if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCuestionariosSM: entrando.");
	   		}  	  
		String idGrupo = null;		
		String noRegRecuperados = "NoHayCuestionariosSMAnu";
		ArrayList listaCuestionariosSMAnu = new ArrayList();
		Q02aCuestionarioSMFiltro cuestionarioSMFiltroPortada = null;
		boolean error = false;
		boolean obtenerListado=false;
		
		try{
			String anyo2008=q02a.exe.utils.Q02aConstantes.getString("ano.portada.2008");
			
			cuestionarioSMFiltroPortada = (Q02aCuestionarioSMFiltro) Q02aVoUtils.getValueObject(mapaFiltroPortadaCuestionarioSM,"q02a.exe.cuestionariosSMAnu.valueobjects.Q02aCuestionarioSMFiltro");
			cuestionarioSMFiltroPortada.setPrevSuelo("1");
			//se abre la conexin
			abrirConexion();
			//se instancia el dao pasandole la conexin			
			daoCuestionariosSMAnu = new Q02aCuestionariosSMDataBaseDAO(this.getConn());
			if(cuestionarioSMFiltroPortada.getAno().equals(anyo2008)){//Viene de la portada 2008
				int numCuestionarios = 0;
				numCuestionarios = daoCuestionariosSMAnu.getNumCuestionariosSM(cuestionarioSMFiltroPortada.getCodProv(),cuestionarioSMFiltroPortada.getCodMuni(),cuestionarioSMFiltroPortada.getAno(),cuestionarioSMFiltroPortada.getMes());
				if(numCuestionarios>0){
					obtenerListado=true;
                }
			}else{
				//se llamamara al dao para obtener el nmero de cuestionarios
				idGrupo = daoCuestionariosSMAnu.obtenerIdGrupoCuestionariosSM(cuestionarioSMFiltroPortada);
				if(idGrupo!=null && !idGrupo.equals("")){
					//listaCuestionariosSMAnu = daoCuestionariosSMAnu.getSelectCuestionariosSMAnu(idGrupo);
					cuestionarioSMFiltroPortada.setNiGrupoCuesSMAnu(idGrupo);
					obtenerListado=true;
	            }    
			}
			if(obtenerListado){
				listaCuestionariosSMAnu = daoCuestionariosSMAnu.getSelectCuestionariosSMAnu(cuestionarioSMFiltroPortada);
            }
            return listaCuestionariosSMAnu;              

	  } catch(Exception ex){
 		  error= true;
          java.io.StringWriter sw = new java.io.StringWriter();
          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
          ex.printStackTrace(pw);
          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCuestionariosSM: " + sw.getBuffer ().toString());
          throw ex;                     
 	  }finally{
 		 try{
 			daoCuestionariosSMAnu.freeResourcesNotConnection();
		   }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCuestionariosSM: error liberando recursos");
	   	   	   }  
		   }  		 
 		  	//se cierra la conexin  
 		  	cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCuestionariosSM: saliendo.");
	   		}
 	  	}
 	  } //fin getCuestionariosSM 
	
	/**
     * 
     * @param cuestionariosVTMFiltro cuestionariosVTMFiltro
     * @return listaCuestionariosVTM
     * @throws Exception Exception
     */
    public void getResetearCuestionariosSM(Q02aCuestionarioSMFiltro cuestionariosSMFiltro) 
    throws Exception {
        if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getResetearCuestionariosSM: entrando.");
        }     
        String idGrupo = null;  
        String miConcedidoLicen = "";
        ArrayList listaCuestionariosSM = new ArrayList();
        boolean error = false;
        
        try{
            String miNiGrupoCuesSM = cuestionariosSMFiltro.getNiGrupoCuesSMAnu();
            //se abre la conexin
            abrirConexion();
            
            if ( miNiGrupoCuesSM == null || "".equals(miNiGrupoCuesSM) ){
                //se instancia el dao pasandole la conexin         
                daoCuestionariosSMAnu = new Q02aCuestionariosSMDataBaseDAO(this.getConn());
                miNiGrupoCuesSM = daoCuestionariosSMAnu.obtenerMiGrupoCuestionariosSM(cuestionariosSMFiltro);
            }
            
            if ( miNiGrupoCuesSM != null && !"".equals(miNiGrupoCuesSM) ){
                //Si concedidoLicencia = 0 --> Es No y solo grabado en Q022BS00
                //Si concedicoLicencia = 1 --> Es Si y grabado en las dos tablas
                
                String territorio = ""; String municipio = ""; String anyoReferencia = ""; String mesReferencia = "";
                if (cuestionariosSMFiltro.getCodProv() != null){ territorio = cuestionariosSMFiltro.getCodProv(); }
                if (cuestionariosSMFiltro.getCodMuni() != null){ municipio = cuestionariosSMFiltro.getCodMuni(); }
                if (cuestionariosSMFiltro.getCodMuni() != null){ anyoReferencia = cuestionariosSMFiltro.getAno(); }
                if (cuestionariosSMFiltro.getCodMuni() != null){ mesReferencia = cuestionariosSMFiltro.getMes(); }
                
                
                miConcedidoLicen = daoCuestionariosSMAnu.getConcedidoGrupoCuesSM(territorio, municipio, anyoReferencia, mesReferencia);
                if ( "1".equals(miConcedidoLicen) ) {
                    daoCuestionariosSMAnu.resetear2SM(miNiGrupoCuesSM);   //Q022ES00
                }
                daoCuestionariosSMAnu.resetear1SM(miNiGrupoCuesSM);   //Q022CS00
                
            }
            
      } catch(Exception ex){
          error= true;
          java.io.StringWriter sw = new java.io.StringWriter();
          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
          ex.printStackTrace(pw);
          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getResetearCuestionariosSM: " + sw.getBuffer ().toString());
          throw ex;                     
      }finally{
         try{
             daoCuestionariosSMAnu.freeResourcesNotConnection();
           }catch(Exception ex){
               if (tr.isTraceActive()){
                   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getResetearCuestionariosSM: error liberando recursos");
               }  
           }         
            //se cierra la conexin  
            cerrarConexion(error);          
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getResetearCuestionariosVTM: saliendo.");
            }
        }
      } //fin getResetearCuestionariosVTM 
	
	/**
	 * Insertar en bbdd un  nuevo cuestionario con los datos pasados como parmetro en la HashMap
     * 
     * @param mapaCuestionarioSM mapaCuestionarioSM
     * @param mapaFiltroPortadaCuestionarioSM mapaFiltroPortadaCuestionarioSM
     * 
     * @throws Exception Exception
     * @return niGrupoCuesSM
	 */

	public String insertarCuestionarioSM(HashMap mapaCuestionarioSM, HashMap mapaFiltroPortadaCuestionarioSM) throws Exception 
	{
		String niCuestionarioSMAnu = "";
		Q02aCuestionarioSM cuestionarioSMAnu = null;
		Q02aCuestionarioSMFiltro cuestionarioSMFiltroPortada = null;
		String niGrupoCuesSM = null;
		boolean es2008=false;
		String anoPortada2008=q02a.exe.utils.Q02aConstantes.getString("ano.portada.2008");
		
		try {
			if (tr.isTraceActive()){     
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioSMAnu: entrando");
				tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":Datos de HasMap mapaCuestionarioSMAnu : " + mapaCuestionarioSM.toString());
			}
			//se pasa el hashmap de entrada a un objeto de tipo Q02aCuestionarioSMAnu	  		
			cuestionarioSMAnu = (Q02aCuestionarioSM) Q02aVoUtils.getValueObject(mapaCuestionarioSM,"q02a.exe.cuestionariosSMAnu.valueobjects.Q02aCuestionarioSM");
			//se instancia el bean de negocio
	  		
            
	  		//En caso de que vengamos de la portada, el campo niGrupoCuesSMAnu del mapa 
	  		//no va a tener ningn valor
	  		//Puede que est en el contexto (en caso de que estemos haciendo altas para los mismo parmetros de portada)
	  		//o  no, en cuyo caso lo tendremos que obtener
	  		cuestionarioSMFiltroPortada = (Q02aCuestionarioSMFiltro) Q02aVoUtils.getValueObject(mapaFiltroPortadaCuestionarioSM,"q02a.exe.cuestionariosSMAnu.valueobjects.Q02aCuestionarioSMFiltro");
  			if(cuestionarioSMFiltroPortada.getAno().equals(anoPortada2008)){
  				es2008=true;
            }
	  		
	  		if(Q02aFormatData.esNullSinCero(cuestionarioSMAnu.getNiGrupoCuesSMAnu()).equals("")){ 
	  			niGrupoCuesSM = this.altaModifGrupoCuestionariosSMAnu(cuestionarioSMFiltroPortada);
	  			cuestionarioSMAnu.setNiGrupoCuesSMAnu(niGrupoCuesSM);
	  		}else {niGrupoCuesSM = cuestionarioSMAnu.getNiGrupoCuesSMAnu();}
	  		
	  		//Miramos si hay que modificar la previsin del suelo
	  		//Si el campo tiene valor 1, habr que modificar el campo de la BD con el valor que tenga el campo prevSuelo
	  		//Si el campo tiene valor 0, habr que borrar los cuestionarios rellenados anteriormente y modificar el campo de la BD con el valor que tenga el campo prevSuelo
	  		if(cuestionarioSMFiltroPortada!= null && Q02aFormatData.esNullSinCero(cuestionarioSMFiltroPortada.getModificarPrevSuelo()).equals("1") && (!es2008 || (es2008 && cuestionarioSMFiltroPortada.getPrevSuelo().equals("1")) )){
	  			this.modificarGrupoCuestionariosSM(niGrupoCuesSM,cuestionarioSMFiltroPortada.getPrevSuelo(),cuestionarioSMFiltroPortada.getMes(), cuestionarioSMFiltroPortada.getObsSuelo());
	  		}
	  		/*daoNora = new Q02aNoraDataBaseDAO(this.getConn());
	  		Q02aCoordenadas c = daoNora.obtenerCoordenadas(cuestionarioSMAnu.getNombreVia(),cuestionarioSMAnu.getBloque(),cuestionarioSMAnu.getNumePortal());
	  		cuestionarioSMAnu.setCoordenadaX(c.getCoordenadaX());
	  		cuestionarioSMAnu.setCoordenadaY(c.getCoordenadaY());*/
	  		

//          Poner el usuario de alta
            if ( cuestionarioSMFiltroPortada.getUsuAlta() != null && !"".equals(cuestionarioSMFiltroPortada.getUsuAlta()) ){
                cuestionarioSMAnu.setUsuAlta(cuestionarioSMFiltroPortada.getUsuAlta());
            }
            
            
	  		daoNora = new Q02aNoraDataBaseDAO(this.getConn());	  		
	  		
	  		if (!cuestionarioSMAnu.getPorClPor().equals(null) && !cuestionarioSMAnu.getPorClPor().equals("") ){
		  		Q02aPortal c = daoNora.obtenerDatosPortal(cuestionarioSMAnu.getPorClPor());
		  		cuestionarioSMAnu.setCoordenadaX(c.getCoordenadaX());
		  		cuestionarioSMAnu.setCoordenadaY(c.getCoordenadaY());
		  		cuestionarioSMAnu.setBisPortal (c.getBis());
		  		cuestionarioSMAnu.setBloque(c.getBloq());
		  		cuestionarioSMAnu.setNumePortal (c.getNume());
		    	}	  		
		    if (!cuestionarioSMAnu.getNombreVia().equals(null)  && !cuestionarioSMAnu.getNombreVia().equals("") ){		    	
		    		cuestionarioSMAnu.setTipoVia(daoNora.obtenerTViaCalle(cuestionarioSMAnu.getNombreVia()));
            }
            
	  		//se llama al mtodo del bean necesario
	  		niCuestionarioSMAnu= this.insertarCuestionarioSMAnu(cuestionarioSMAnu);

	  		//Actualizamos el campo de nmero de cuestionarios de la tabla de grupo
	  		this.actualizarNumCuestionariosRellenados(cuestionarioSMAnu.getNiGrupoCuesSMAnu());
	  		return niGrupoCuesSM;			
	     }catch(Exception ex){
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw); 
            if (tr.isTraceActive()){  
				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarCuestionarioSMAnu: " + sw.getBuffer ().toString());
			}
            throw ex;
		 }finally{
			 try{
				 daoNora.freeResourcesNotConnection();
	 		    }catch(Exception ex){
				   if (tr.isTraceActive()){
					   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarCuestionarioSMAnu: error liberando recursos");
		   	   	   }  
	 		    }  	
			 if (tr.isTraceActive()){
					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioSMAnu: saliendo");
			 }			
		}
	} // fin insertarCuestionarioSMAnu



    /**
     * Funcin que inserta los datos del cuestionario de Suelo Municipal Anual pasada como parmetro en la BBDD
     * 
     * @param cuesSMAnu - Datos del cuestionario a insertar
     * 
     * @throws Exception Exception
     * @return niCuestionarioSMAnu
     */
      public String insertarCuestionarioSMAnu(Q02aCuestionarioSM cuesSMAnu) throws Exception {   	 
    	//se crean objetos necesarios.
    	String niCuestionarioSMAnu = "";
    	boolean error = false;
    	try{
    		if (tr.isTraceActive()){
      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioSMAnu: entrando");
      		}
	  		//se abre la conexin
			abrirConexion();
			//se instancia el dao pasandole la conexin			
			daoCuestionariosSMAnu = new Q02aCuestionariosSMDataBaseDAO(this.getConn());
			daoSolicitudesNora = new Q02aSolicitudesNoraDataBaseDAO(this.getConn());
            
			//se pasan los parmetros de usuario e idioma
			daoCuestionariosSMAnu.setUser(this.autenticador.getUser());
			daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());
            
			daoNora = new Q02aNoraDataBaseDAO(this.getConn());
			/*Q02aCoordenadas c = daoNora.obtenerCoordenadas(cuesSMAnu.getNombreVia(),cuesSMAnu.getBloque(),cuesSMAnu.getNumePortal());
	  		cuesSMAnu.setCoordenadaX(c.getCoordenadaX());
	  		cuesSMAnu.setCoordenadaY(c.getCoordenadaY());*/
	  				
	  		
			//se llamaa la metodo del DAO que realiza la insert
			niCuestionarioSMAnu = daoCuestionariosSMAnu.insertarCuestionarioSMAnu(cuesSMAnu);
			
			//insertamos la solicitud de alta en NORA si es el caso
			if(!Q02aFormatData.esVacio(cuesSMAnu.getDirNueva())){
				Q02aSolicitudNora solicitudNora = this.rellenarSolicitudNora(cuesSMAnu);
				daoSolicitudesNora.insertarSolicitudNora(solicitudNora);
			}
			return niCuestionarioSMAnu;

    	}catch(Exception ex){
	 		error= true;
	        java.io.StringWriter sw = new java.io.StringWriter();
	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	        ex.printStackTrace(pw);
	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarCuestionarioSMAnu: " + sw.getBuffer ().toString());
	        throw ex;                     
 	  }finally{
 		    try{
 		    	daoCuestionariosSMAnu.freeResourcesNotConnection();
 		    	daoSolicitudesNora.freeResourcesNotConnection();
 		    }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarCuestionarioSMAnu: error liberando recursos");
	   	   	   }  
 		    }  		 
 		  	//se cierra la conexin  
		    cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioSMAnu: saliendo.");
	   		}
 	  }
    }//fin insertarCuestionarioSMAnu 
    
    /**
     * Funcin que borra el cuestionario pasado como parmetro de la BBDD
     * 
     * @param niCuestionarioSMAnu - nmero interno del cuestionario a borrar
     * @param niGrupoCuestionarioSMAnu niGrupoCuestionarioSMAnu
     * 
     * @throws Exception Exception
     */
  public void borrarCuestionarioSMAnu(String niCuestionarioSMAnu,String niGrupoCuestionarioSMAnu) throws Exception {
        
	  	int numeroRegistros = 0;
    	if (tr.isTraceActive()){
			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioSMAnu: entrando");
		}
    	 boolean error = false;
    	 try{
    		 //se abre la conexin
   			abrirConexion();
   			//se instancia el dao pasandole la conexin			
   			daoCuestionariosSMAnu = new Q02aCuestionariosSMDataBaseDAO(this.getConn());
   			daoSolicitudesNora = new Q02aSolicitudesNoraDataBaseDAO(this.getConn());
			// Segmento tecnico 
   			//daoCuestionariosSMAnu.setUser(this.getAutenticador().getUser());
   			//daoCuestionariosSMAnu.setIdioma(this.getAutenticador().getIdioma()); 
   			
   			//Antes de borrar el cuestionario, eliminamos la solicitud de alta provisional de NORA si la tuviera
 			daoSolicitudesNora.borrarSolicitudNora(Q02aConstantes.getString("tipo.suelo.municipal"), niGrupoCuestionarioSMAnu, niCuestionarioSMAnu);
   			
   			//se comprueba el numero de cuestionarios que tiene el grupo de cuestionarios
   			numeroRegistros = daoCuestionariosSMAnu.getNumCuestionariosSM(niGrupoCuestionarioSMAnu);
   			if (numeroRegistros==1){
   					daoCuestionariosSMAnu.borrarCuestionarioSMAnu(niCuestionarioSMAnu,niGrupoCuestionarioSMAnu);
   					daoCuestionariosSMAnu.borrarGrupoCuestionarioSMAnu(niGrupoCuestionarioSMAnu);
   			}
   			else {
   					daoCuestionariosSMAnu.borrarCuestionarioSMAnu(niCuestionarioSMAnu,niGrupoCuestionarioSMAnu);
   			}
   		 	  
    	 }catch(Exception ex){
		  error= true;
          java.io.StringWriter sw = new java.io.StringWriter();
          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
          ex.printStackTrace(pw);
          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioSMAnu: " + sw.getBuffer ().toString());
          throw ex;                     
 	  }finally{
 		 try{
 			daoCuestionariosSMAnu.freeResourcesNotConnection();
 			daoSolicitudesNora.freeResourcesNotConnection();
		   }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioSMAnu: error liberando recursos");
	   	   	   }  
		   }  		 
 		  	//se cierra la conexin  
 		  	cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioSMAnu: saliendo.");
	   		}
 	  }

    }//fin borrarCuestionarioSMAnu
    /**
     * Funcin que modifica los datos del cuestionario pasado como parmetro en la BBDD
     * 
     * @param cuestionarioSMAnu - Datos del cuestionario a modificar
     * 
     * @throws Exception Exception
     */
   public void modificarCuestionarioSMAnu(Q02aCuestionarioSM cuestionarioSMAnu) throws Exception {
       
   	 if (tr.isTraceActive()){
  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioSMAnu: entrando");
  	 }
   	 boolean error = false;
   	 
   	try{
   		//se abre la conexin
   		abrirConexion();
   		
   		//se instancia el dao pasandole la conexin			
   		daoCuestionariosSMAnu = new Q02aCuestionariosSMDataBaseDAO(this.getConn());
   		daoSolicitudesNora = new Q02aSolicitudesNoraDataBaseDAO(this.getConn());
   		
		// Segmento tecnico 
		daoCuestionariosSMAnu.setUser(this.getAutenticador().getUser());
		daoCuestionariosSMAnu.setIdioma(this.getAutenticador().getIdioma()); 
		daoNora = new Q02aNoraDataBaseDAO(this.getConn());
		
   		/*Q02aCoordenadas c = daoNora.obtenerCoordenadas(cuestionarioSMAnu.getNombreVia(),cuestionarioSMAnu.getBloque(),cuestionarioSMAnu.getNumePortal());
  		cuestionarioSMAnu.setCoordenadaX(c.getCoordenadaX());
  		cuestionarioSMAnu.setCoordenadaY(c.getCoordenadaY());*/	  		
 		
  		if (!cuestionarioSMAnu.getPorClPor().equals(null) && !cuestionarioSMAnu.getPorClPor().equals("") ){
	  		Q02aPortal c = daoNora.obtenerDatosPortal(cuestionarioSMAnu.getPorClPor());
	  		cuestionarioSMAnu.setCoordenadaX(c.getCoordenadaX());
	  		cuestionarioSMAnu.setCoordenadaY(c.getCoordenadaY());
	  		cuestionarioSMAnu.setBisPortal (c.getBis());
	  		cuestionarioSMAnu.setBloque(c.getBloq());
	  		cuestionarioSMAnu.setNumePortal (c.getNume());
	    	}	  		
	    if (!cuestionarioSMAnu.getNombreVia().equals(null)  && !cuestionarioSMAnu.getNombreVia().equals("") )	{	    	
	    		cuestionarioSMAnu.setTipoVia(daoNora.obtenerTViaCalle(cuestionarioSMAnu.getNombreVia()));
        }
  		
   		//se llama la metodo del DAO que realiza la update
   		daoCuestionariosSMAnu.modificarCuestionarioSMAnu(cuestionarioSMAnu);
   		//Puede que se haya modificado la direccin nueva de la localizacion de obra
   		//que antes no la tuviera y ahora s o se haya eliminado
   		Q02aSolicitudNora solicitudNora = this.rellenarSolicitudNora(cuestionarioSMAnu);
   		daoSolicitudesNora.modificarSolicitudNora(solicitudNora);
   		    	
   	}catch(Exception ex){
		  error= true;
         java.io.StringWriter sw = new java.io.StringWriter();
         java.io.PrintWriter pw = new java.io.PrintWriter(sw);
         ex.printStackTrace(pw);
         tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioSMAnu: " + sw.getBuffer ().toString());
         throw ex;                     
	  }finally{
		 try{
			daoCuestionariosSMAnu.freeResourcesNotConnection();
			daoSolicitudesNora.freeResourcesNotConnection();
		   }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioSMAnu: error liberando recursos");
	   	   	   }  
		   }  		 
		  	//se cierra la conexin  
		  	cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioSMAnu: saliendo.");
	   		}
	  }
   }


    /**
     * Mtodo que dado el nmero interno del cuestionario recuperar de la BBDD
     * los datos de dicho cuestionario.
     * @param niCuestionarioSMAnu niCuestionarioSMAnu
     * @param niGrupoCuestionarioSMAnu niGrupoCuestionarioSMAnu
     * @return cuestionarioSMAnu
     * @throws Exception Exception
     */
	public Q02aCuestionarioSM obtenerCuestionarioSMAnu(String niCuestionarioSMAnu,String niGrupoCuestionarioSMAnu)
    throws Exception{
			
	    	boolean error = false;
	    	Q02aCuestionarioSM cuestionarioSMAnu = null;
	  	  	try  	  {
	  	  		if (tr.isTraceActive()){
	  	  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioSMAnu, ** niCuestionarioSMAnu bean=" + niCuestionarioSMAnu + ", niGrupoCuestionarioSMAnu =" + niGrupoCuestionarioSMAnu+ " *** entrando");                
	  	  		}
	  	  		//se abre la conexin
	  	  		abrirConexion();
	  	  		//se instancia el dao pasandole la conexin			
	  	  		daoCuestionariosSMAnu = new Q02aCuestionariosSMDataBaseDAO(this.getConn());
	  	  		//Segmento tecnico 
	  			//daoCuestionariosSMAnu.setUser(this.getAutenticador().getUser());
	  			//daoCuestionariosSMAnu.setIdioma(this.getAutenticador().getIdioma()); 
	  	  		//se llama al mtodo del dao recupera el cuestionario
	  	  		cuestionarioSMAnu = daoCuestionariosSMAnu.obtenerCuestionarioSMAnu(niCuestionarioSMAnu,niGrupoCuestionarioSMAnu);
	  	  		//se devuelve el cuestionario recuperado
	  	  		return cuestionarioSMAnu;
	  	  }catch(Exception ex){
	  		  	error= true;
	  		  	java.io.StringWriter sw = new java.io.StringWriter();
	          	java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	          	ex.printStackTrace(pw);
	          	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioSMAnu: " + sw.getBuffer ().toString());
	          	throw ex;                     
	 	  }finally{
	 		  	try{
	 		  		daoCuestionariosSMAnu.freeResourcesNotConnection();
	 		  	}catch(Exception ex){
				   if (tr.isTraceActive()){
					   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioSMAnu: error liberando recursos");
		   	   	   }  
	 		  	}  		 
	 		  	//se cierra la conexin  
	 		  	cerrarConexion(error);	       	
		        if (tr.isTraceActive()){
		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioSMAnu: saliendo.");
		   		}
	 	  }
	    }//fin obtenerCuestionarioSMAnu
	 
    /**
     * 
     * @param cuestionariosSMFiltro cuestionariosSMFiltro
     * @return listaCuestionariosSM
     * @throws Exception Exception
     */
    public ArrayList getCuestionariosSinGrabarSM(Q02aCuestionarioSMFiltro cuestionariosSMFiltro) throws Exception {
        
        if (tr.isTraceActive()){
               tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCuestionariosSinGrabarSM: entrando.");
        }    
        
        ////////////////////////////--  SQL -- ///////////////////////////////////////
        final StringBuffer sql = new StringBuffer();
                sql.append("Select * from Q022CT00 ");
        final StringBuffer where = new StringBuffer();
                where.append(" where MUN_PROV =").append( cuestionariosSMFiltro.getCodProv() ).append(
                        " and MUN_MUNI = ").append( cuestionariosSMFiltro.getCodMuni() );
                        //" and q022ct00_REALIZA_ACTUACION=1");
                                
        final StringBuffer order = new StringBuffer();
                order.append(" order by Q022CT00_ANO, Q22CT00_MES");

        // Saco el mes y el ao para saber la select que hay que hacer
        int mes=0; int anyo=2010;
        
        if ( cuestionariosSMFiltro.getMes()!= null ) {     
            mes = Integer.parseInt( cuestionariosSMFiltro.getMes().toString() );
        }
        if ( cuestionariosSMFiltro.getAno() != null ){
             anyo = Integer.parseInt( cuestionariosSMFiltro.getAno().toString() );
        }
        if ( mes == 1 ){//Si es enero hay que sacar octubre, noviembre y diciembre del anyo anterior
            anyo = anyo-1; 
            where.append(" and Q022CT00_ANO =").append( anyo ).append(
            " and Q22CT00_MES IN (10, 11, 12) ");
        }else{
            where.append(" and Q022CT00_ANO =").append( anyo ).append(
            " and Q22CT00_MES < ").append( mes );
        }
        ////////// FIN SQL ////////////////////////////////////////
        sql.append(where).append(order);
        
        
       ArrayList listaCuestionariosSM = new ArrayList();
       //boolean error = false;
       
       try{
           final Connection connection = Q70ConectorJDBC.getSingleton().getConnection(Q02_JNDI_DATASOURCE);
           try{
                   PreparedStatement ps = connection.prepareStatement(sql.toString()); 
                       try {
                           int i = 0;
                           ps.execute();
                           ResultSet rs = ps.getResultSet();
                           HashMap mesesHashMap;
                           
                               try {
                                       while (rs.next()){
                                           mesesHashMap = this.obtenerHashMap();
                                           mesesHashMap.put("mes", new Long ( rs.getLong("Q22CT00_MES") ).toString() );
                                           mesesHashMap.put("ano", new Long ( rs.getLong("Q022CT00_ANO") ).toString() );
                                           listaCuestionariosSM.add(mesesHashMap);
                                           i++;
                                       }
                               } finally {
                                   try { rs.close(); } catch (SQLException e) { }
                               }
                           
                       } finally {
                           try { ps.close(); } catch (SQLException e) { }
                       }
           }finally {
               try { connection.close(); } catch (SQLException sqle) {}
           }
           
           return listaCuestionariosSM;              
     
     }catch (SQLException e) {
         if (tr.isTraceActive()){
             tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCuestionariosSinGrabarSM: saliendo.");
         }
         throw new EJBException("getCuestionariosSinGrabarSM",e);
     } catch (NamingException e) {
         if (tr.isTraceActive()){
             tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCuestionariosSinGrabarSM: saliendo.");
         }
         throw new EJBException("getCuestionariosSinGrabarSM",e);
     }
     
     } //fin getCuestionariosSinGrabarSM 
	    
     /**
     * Funcin que inserta/modifica los datos del grupo de cuestionarios de Suelo Municipal a partir de los Datos Contenidos en el filtro
     * 
     * @param cuesSMAnuFiltro - Datos del grupo de cuestionarios a insertar
     * 
     * @throws Exception  Exception
     * @return niGrupoCuesSMAnu
     */
    public String altaModifGrupoCuestionariosSMAnu(Q02aCuestionarioSMFiltro cuesSMAnuFiltro) throws Exception {   	 
    	//se crean objetos necesarios.
    	//Q02aCuestionarioSMAnuFiltro grupoCuestionarioSMAnuConNi = null;
    	String niGrupoCuesSMAnu = null;
    	boolean error = false;
    	try{
    		if (tr.isTraceActive()){
      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: entrando");
      		}
	  		//se abre la conexin
			abrirConexion();
			//se instancia el dao pasandole la conexin			
			daoCuestionariosSMAnu = new Q02aCuestionariosSMDataBaseDAO(this.getConn());
//			se pasan los parmetros de usuario e idioma
			//daoCuestionariosSMAnu.setUser(this.autenticador.getUser());
			//daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());
			//se llamaa la metodo del DAO que realiza la insert
			
			niGrupoCuesSMAnu =daoCuestionariosSMAnu.altaModifGrupoCuestionariosSMAnu(cuesSMAnuFiltro);
			return niGrupoCuesSMAnu;
			
    	}catch(Exception ex){
	 		error= true;
	        java.io.StringWriter sw = new java.io.StringWriter();
	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	        ex.printStackTrace(pw);
	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: " + sw.getBuffer ().toString());
	        throw ex;                     
 	  }finally{
 		    try{
 		    	daoCuestionariosSMAnu.freeResourcesNotConnection();
 		    }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: error liberando recursos");
	   	   	   }  
 		    }  		 
 		  	//se cierra la conexin  
 		    cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarCuestionarioSMAnu: saliendo.");
	   		}
 	  }
    }//fin altaModifGrupoCuestionariosSMAnu
    
    /**
     * Funcin que obtiene los  aos para el municipio y ano seleccionados, en los que no se han introducido cuestionarios
     * 
     * @param codProv codProv
     * @param codMuni codMuni
     * @param ano ano
     * @param idioma idioma
     * 
     * @throws Exception Exception
     * @return msgAnos
     */
    public String obtenerAnosMesesPendientes(String codProv,String codMuni,String ano,String idioma) throws Exception {   	 
	boolean error = false;
    	String msgAnos = null;
    	
    	try{
    		if (tr.isTraceActive()){
      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientes: entrando");
      		}
	  		//se abre la conexin
			abrirConexion();
			//se instancia el dao pasandole la conexin			
			daoCuestionariosSMAnu = new Q02aCuestionariosSMDataBaseDAO(this.getConn());
//			se pasan los parmetros de usuario e idioma
			//daoCuestionariosSMAnu.setUser(this.autenticador.getUser());
			//daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());
			//se llamaa la metodo del DAO que realiza la insert
			msgAnos =daoCuestionariosSMAnu.obtenerAnosMesesPendientesParaMuni(codProv,codMuni,ano,idioma);
			return msgAnos;
			
    	}catch(Exception ex){
	 		error= true;
	        		java.io.StringWriter sw = new java.io.StringWriter();
	        		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	        		ex.printStackTrace(pw);
	        		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAnosPendientes: " + sw.getBuffer ().toString());
	        		throw ex;                     
 	  }finally{
 		    try{
 		    	daoCuestionariosSMAnu.freeResourcesNotConnection();
 		    }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAnosPendientes: error liberando recursos");
	   	   	   }  
 		    }  		 
 		    //se cierra la conexin  
 		    cerrarConexion(error);	       	
 		    if (tr.isTraceActive()){
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientes: saliendo.");
	   	    }
 	  }
    }//fin obtenerAnosPendientes
    
     
    /**
     * Funcin que obtiene el campo Prevision Suelo  para el municipio y ano seleccionados
     * 
     * @param codProv codProv
     * @param codMuni codMuni
     * @param ano ano
     * @param mes mes
     * @param tipoCuestionario tipoCuestionario
     * 
     * @throws Exception Exception
     * @return daoCuestionariosSMAnu.obtenerCampoPrevSueloDeGrupoConMuniAno(
     */
    public String obtenerCampoPrevSueloDeGrupoConMuniAno(String codProv,String codMuni,String ano, String mes, String tipoCuestionario) throws Exception {   	 
	boolean error = false;
    	
    	try{
    		if (tr.isTraceActive())
    		{
      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoPrevSueloDeGrupoConMuniAno: entrando");
      		}
	  		//se abre la conexin
			abrirConexion();
			//se instancia el dao pasandole la conexin			
			daoCuestionariosSMAnu = new Q02aCuestionariosSMDataBaseDAO(this.getConn());
//			se pasan los parmetros de usuario e idioma
			//daoCuestionariosSMAnu.setUser(this.autenticador.getUser());
			//daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());
			//se llamaa la metodo del DAO que realiza la insert
			return daoCuestionariosSMAnu.obtenerCampoPrevSueloDeGrupoConMuniAno(codProv,codMuni,ano, mes, tipoCuestionario);
			
			
    	}catch(Exception ex){
	 		error= true;
	        		java.io.StringWriter sw = new java.io.StringWriter();
	        		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	        		ex.printStackTrace(pw);
	        		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoPrevSueloDeGrupoConMuniAno: " + sw.getBuffer ().toString());
	        		throw ex;                     
 	  }finally{
 		    try{
 		    	daoCuestionariosSMAnu.freeResourcesNotConnection();
 		    }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoPrevSueloDeGrupoConMuniAno: error liberando recursos");
	   	   	   }  
 		    }  		 
 		    //se cierra la conexin  
 		    cerrarConexion(error);	       	
      	   if (tr.isTraceActive()){
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoPrevSueloDeGrupoConMuniAno: saliendo.");
	   	  }
 	  }
    }//fin obtenerCampoPrevSueloDeGrupoConMuniAno
    
    /**Metodo que se encarga de devolver un XML con los datos principales de los cuestionarios a firmar que no estn ya firmados.
	* @param ArrayList ArrayList arrCuestionariosSMAnuFirma
	* @throws Exception
    */
    /*
   public Document obtenerXmlFirmaCuestionariosSMAnu(ArrayList arrCuestionariosSMAnuFirma ) throws Exception{
        //Definicion de constantes
        final String TRACE_METODO = nombreClaseSinPackage +":obtenerXmlFirmaCuestionariosSMAnu:";

        //Variable que indica si se ha producido un error
        boolean error = false;
        
        Document docCuestionariosSMAnuFirmar = null;
        Q02aCuestionarioSM cuestionarioSMAnuBD = null;
        
        if (tr.isTraceActive()) 
        {
            	tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": entrando");
            	tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO +": ArrayList ="+ (arrCuestionariosSMAnuFirma==null?"Es nulo":Integer.toString(arrCuestionariosSMAnuFirma.size())));
        }
        try {
        	if(arrCuestionariosSMAnuFirma !=null)
        	{
        		Q02aXMLBuilder xml = new Q02aXMLBuilder();
            		Element document = xml.createTag("DOCUMENT");
        		for(int i =0;i<arrCuestionariosSMAnuFirma.size();i++)
        		{
        			cuestionarioSMAnuBD = (Q02aCuestionarioSM)arrCuestionariosSMAnuFirma.get(i);
        			//MODIFICACION -> Se firman todos otra vez
        			//Slo se van a firmar los que no estn ya firmados
        			//tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": Fec. Firma del elemento  "+ i + "=" +cuestionarioSMAnuBD.getFecFirma() );
        			//if(Q02aFormatData.esVacio(cuestionarioSMAnuBD.getFecFirma()))
        			//{
	        			//tr.trace(COMPONENTE, Q70TraceLevel.INFO, TRACE_METODO + ": Se genera XML del elemento "+ i);
	        			Element cuestionario = xml.createTag("CUESTIONARIO");
	                    			xml.addChild(document, cuestionario);
	                    			xml.addChild(cuestionario, xml.createTag("IDEN_LICEN",cuestionarioSMAnuBD.getIdenLicen() , true));
	                    			xml.addChild(cuestionario, xml.createTag("LOCAL_OBRA",cuestionarioSMAnuBD.getLocalObra(), true));
	                    			xml.addChild(cuestionario, xml.createTag("SUPERFICIE_SUELO", cuestionarioSMAnuBD.getSupSueloT(), true));
	                    		//}
        		}
        		xml.setRootTag(document);
        		
        		docCuestionariosSMAnuFirmar= xml.getDocument();
        		
        	}
        	//Se devuelve el document
        	return docCuestionariosSMAnuFirmar;
        }
        catch (Exception ex) 
        {
	            error = true;
	            java.io.StringWriter sw = new java.io.StringWriter();
	            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	            ex.printStackTrace(pw);
	            tr.trace(COMPONENTE, Q70TraceLevel.ERROR,
	                TRACE_METODO + ": " + sw.getBuffer().toString());
	            throw ex;
        } 
    }
    */
    /**
     * Funcin que inserta la firma del grupo de cuestionarios de Ayuntamientos Mensual pasada como parmetro
     * 
     * @param niGrupoCuesSMAnu - Ni del grupo de cuestionarios
     * @param xmlFirmaGrupoCuestionariosSMAnu - Firma del grupo de cuestionarios
     * 
     * @throws Exception  Exception
     */
    public void guardarFirmaGrupoCuestionariosSMAnu(String niGrupoCuesSMAnu,String xmlFirmaGrupoCuestionariosSMAnu) 
    throws Exception {   	 
    	boolean error = false;
    	try{
    		if (tr.isTraceActive()){
      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosSMAnu: entrando");
      		}
  		//se abre la conexin
		abrirConexion();
		//se instancia el dao pasandole la conexin			
		daoCuestionariosSMAnu = new Q02aCuestionariosSMDataBaseDAO(this.getConn());
//		se pasan los parmetros de usuario e idioma
		//daoCuestionariosSMAnu.setUser(this.autenticador.getUser());
		//daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());
		//se llamaa la metodo del DAO que realiza las modificaciones en la base de datos
		daoCuestionariosSMAnu.guardarFirmaGrupoCuestionariosSMAnu(niGrupoCuesSMAnu,xmlFirmaGrupoCuestionariosSMAnu);
    	}catch(Exception ex){
	 	 error= true;
		 java.io.StringWriter sw = new java.io.StringWriter();
		 java.io.PrintWriter pw = new java.io.PrintWriter(sw);
		 ex.printStackTrace(pw);
		 tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosSMAnu: " + sw.getBuffer ().toString());
		  throw ex;                     
 	  }finally{
 		    try{
 		    	daoCuestionariosSMAnu.freeResourcesNotConnection();
 		    }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosSMAnu: error liberando recursos");
	   	   	   }  
 		    }  		 
 		  	
 		  //se cierra la conexin  
 		 cerrarConexion(error);	       	
	        	if (tr.isTraceActive())
	        	{
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":guardarFirmaGrupoCuestionariosSMAnu: saliendo.");
	   	}
 	  }
    }//fin guardarFirmaGrupoCuestionariosSMAnu
    
    /**
     * 
     * @param codProv codProv
     * @param codMuni codMuni
     * @param ano ano
     * @param mes mes
     * @param tipoCuestionario tipoCuestionario
     * @return daoCuestionariosSMAnu.obtenerNumCuestionarios
     * @throws Exception Exception
     */
    public boolean obtenerNumCuestionarios(String codProv,String codMuni,String ano,String mes, String tipoCuestionario) 
    throws Exception {   	 
    	boolean error = false;
        	
        	try{
        		if (tr.isTraceActive())
        		{
          			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNumCuestionarios: entrando");
          		}
    	  		//se abre la conexin
    			abrirConexion();
    			//se instancia el dao pasandole la conexin			
    			daoCuestionariosSMAnu = new Q02aCuestionariosSMDataBaseDAO(this.getConn());
    			//se pasan los parmetros de usuario e idioma
    			//daoCuestionariosAyunMen.setUser(this.autenticador.getUser());
    			//daoCuestionariosAyunMen.setIdioma(this.autenticador.getIdioma());
    			//se llamaa la metodo del DAO que realiza la insert
    			return daoCuestionariosSMAnu.obtenerNumCuestionarios(codProv,codMuni,ano,mes,tipoCuestionario);
    			
    			
        	}catch(Exception ex){
    	 		error= true;
    	        		java.io.StringWriter sw = new java.io.StringWriter();
    	        		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
    	        		ex.printStackTrace(pw);
    	        		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerNumCuestionarios: " + sw.getBuffer ().toString());
    	        		throw ex;                     
     	  }finally{
     		    try{
     		    	daoCuestionariosSMAnu.freeResourcesNotConnection();
     		    }catch(Exception ex){
    			   if (tr.isTraceActive()){
    				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerNumCuestionarios: error liberando recursos");
    	   	   	   }  
     		    }  		 
     		    //se cierra la conexin  
     		    cerrarConexion(error);	       	
    	        	   if (tr.isTraceActive())
    	        	   {
    	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNumCuestionarios: saliendo.");
    	   	  }
     	  }
        }//fin obtenerNumCuestionarios
    
    /**
     * Funcin que actualiza el nmero de cuestionarios rellenados de Suelo Municipal 
     * 
     * @param niGrupoCuesSMAnu niGrupoCuesSMAnu
     * 
     * @throws Exception Exception
     * @return numCuestionarios
     */
      public int actualizarNumCuestionariosRellenados(String niGrupoCuesSMAnu) throws Exception {   	 
    	//se crean objetos necesarios.
    	int numCuestionarios = 0;
    	boolean error = false;
    	try{
    		if (tr.isTraceActive()){
      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":actualizarNumCuestionariosRellenados: entrando");
      		}
	  		//se abre la conexin
			abrirConexion();
			//se instancia el dao pasandole la conexin			
			daoCuestionariosSMAnu = new Q02aCuestionariosSMDataBaseDAO(this.getConn());
//			se pasan los parmetros de usuario e idioma
			//daoCuestionariosSMAnu.setUser(this.autenticador.getUser());
			//daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());
			//se llamaa la metodo del DAO que realiza la insert
			numCuestionarios = daoCuestionariosSMAnu.actualizarNumCuestionariosRellenados(niGrupoCuesSMAnu);
			return numCuestionarios;
    	}catch(Exception ex){
	 		error= true;
	        java.io.StringWriter sw = new java.io.StringWriter();
	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	        ex.printStackTrace(pw);
	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":actualizarNumCuestionariosRellenados: " + sw.getBuffer ().toString());
	        throw ex;                     
 	  }finally{
 		    try{
 		    	daoCuestionariosSMAnu.freeResourcesNotConnection();
 		    }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":actualizarNumCuestionariosRellenados: error liberando recursos");
	   	   	   }  
 		    }  		 
 		  	//se cierra la conexin  
 		    cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":actualizarNumCuestionariosRellenados: saliendo.");
	   		}
 	  }
    }//fin actualizarNumCuestionariosRellenados 
     
      
      /**
       * Funcin que modifica el campo Q22CT00_REALIZA_ACTUACION  
       * 
       * @param niGrupoCuesSM  - el ni del grupo a modificar
       * @param valorPrevSuelo - nuevo valor del campo
       * @param mes - mes del grupo de cuestionarios
       * @param obs obs  
       * 
       * @throws Exception Exception
       */
        public void modificarGrupoCuestionariosSM(String niGrupoCuesSM, String valorPrevSuelo, String mes, String obs) throws Exception {   	 
        	boolean error = false;
        	try{
      		if (tr.isTraceActive()){
        			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarGrupoCuestionariosSM: entrando");
        		}
  	  		//se abre la conexin
  			abrirConexion();
  			//se instancia el dao pasandole la conexin			
  			daoCuestionariosSMAnu = new Q02aCuestionariosSMDataBaseDAO(this.getConn());
//  			se pasan los parmetros de usuario e idioma
  			//daoCuestionariosSMAnu.setUser(this.autenticador.getUser());
  			//daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());
  			//se llamaa la metodo del DAO que realiza la insert
  			daoCuestionariosSMAnu.modificarGrupoCuestionariosSM(niGrupoCuesSM,valorPrevSuelo,mes,obs);
  	  	}catch(Exception ex){
  	 		error= true;
  	        java.io.StringWriter sw = new java.io.StringWriter();
  	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
  	        ex.printStackTrace(pw);
  	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarGrupoCuestionariosSM: " + sw.getBuffer ().toString());
  	        throw ex;                     
   	  }finally{
   		    try{
   		    	daoCuestionariosSMAnu.freeResourcesNotConnection();
   		    }catch(Exception ex){
  			   if (tr.isTraceActive()){
  				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarGrupoCuestionariosSM: error liberando recursos");
  	   	   	   }  
   		    }  		 
   		  	//se cierra la conexin  
   		    cerrarConexion(error);	       	
  	        if (tr.isTraceActive()){
  	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarGrupoCuestionariosSM: saliendo.");
  	   		}
   	  }
      }//fin modificarGrupoCuestionariosSM 
        
        /**
         * Funcin que recupera el nmero de cuestionarios de SM 
         * 
         * @param territorio - territorio
         * @param municipio - municipio
         * @param anyoReferencia - anyoReferencia
         * @param mesReferencia - mesReferencia
         * 
         * @throws Exception Exception
         * @return numCuestionariosSM
         */
          public int getNumCuestionariosPortada(String territorio, String municipio, String anyoReferencia,String mesReferencia) throws Exception {   	 
        	//se crean objetos necesarios.
        	int numCuestionariosSM = 0;	        	         
        	boolean error = false;
        	
        	try{
        		 
        		if (tr.isTraceActive()){
          			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortada: entrando");
          		}
    	  		//se abre la conexin
    			abrirConexion();
    			//se instancia el dao pasandole la conexin			
    			daoCuestionariosSMAnu = new Q02aCuestionariosSMDataBaseDAO(this.getConn());
    			
    			numCuestionariosSM = daoCuestionariosSMAnu.getNumCuestionariosSM(territorio, municipio, anyoReferencia, mesReferencia);
    			    			   			
    			return numCuestionariosSM;
        	}catch(Exception ex){
    	 		error= true;
    	        java.io.StringWriter sw = new java.io.StringWriter();
    	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
    	        ex.printStackTrace(pw);
    	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: " + sw.getBuffer ().toString());
    	        throw ex;                     
     	  }finally{
     		    try{
     		    	daoCuestionariosSMAnu.freeResourcesNotConnection();
     		    }catch(Exception ex){
    			   if (tr.isTraceActive()){
    				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: error liberando recursos");
    	   	   	   }  
     		    }  		 
     		  	//se cierra la conexin  
     		    cerrarConexion(error);	       	
    	        if (tr.isTraceActive()){
    	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortada: saliendo.");
    	   		}
     	  }
        }//fin getNumCuestionariosPortada 
        
          /**
           * Funcin que recupera las observacionesSM 
           * 
           * @param territorio - territorio
           * @param municipio - municipio
           * @param anyoReferencia - anyoReferencia
           * @param mesReferencia - mesReferencia
           * 
           * @throws Exception Exception
           * @return observacionesSM
           */
            public String getObservacionesPortadaSM(String territorio, String municipio, String anyoReferencia,String mesReferencia) throws Exception {        
            
            String observacionesSM = "";                      
            boolean error = false;
            
                try{
                     
                    if (tr.isTraceActive()){
                            tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getObservacionesPortadaSM: entrando");
                        }
                    //se abre la conexin
                    abrirConexion();
                    //se instancia el dao pasandole la conexin         
                    daoCuestionariosSMAnu = new Q02aCuestionariosSMDataBaseDAO(this.getConn());
                    
                    observacionesSM = daoCuestionariosSMAnu.getObservacionesCuesSM(territorio, municipio, anyoReferencia, mesReferencia);
                                                
                    return observacionesSM;
                }catch(Exception ex){
                    error= true;
                    java.io.StringWriter sw = new java.io.StringWriter();
                    java.io.PrintWriter pw = new java.io.PrintWriter(sw);
                    ex.printStackTrace(pw);
                    tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getObservacionesPortadaSM: " + sw.getBuffer ().toString());
                    throw ex;                     
              }finally{
                    try{
                        daoCuestionariosSMAnu.freeResourcesNotConnection();
                    }catch(Exception ex){
                       if (tr.isTraceActive()){
                           tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getObservacionesPortadaSM: error liberando recursos");
                       }  
                    }        
                    //se cierra la conexin  
                    cerrarConexion(error);          
                    if (tr.isTraceActive()){
                        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getObservacionesPortadaSM: saliendo.");
                    }
              }
          }//fin getObservacionesPortadaSM 
          
          /**
           * 
           * @param territorio territorio
           * @param municipio municipio
           * @param anyoReferencia anyoReferencia
           * @param mesReferencia mesReferencia
           * @return prevSueloInicial
           * @throws Exception Exception
           */
          public String getPrevisionGrupoCuesSM(String territorio, String municipio, String anyoReferencia,String mesReferencia) throws Exception {   	 
          	//se crean objetos necesarios.
          	String prevSueloInicial="";	        	         
          	boolean error = false;
          	
          	try{
          		 
          		if (tr.isTraceActive()){
            			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortada: entrando");
            		}
      	  		//se abre la conexin
      			abrirConexion();
      			//se instancia el dao pasandole la conexin			
      			daoCuestionariosSMAnu = new Q02aCuestionariosSMDataBaseDAO(this.getConn());
      			
      			prevSueloInicial = daoCuestionariosSMAnu.getPrevisionGrupoCuesSM(territorio, municipio, anyoReferencia, mesReferencia);
      			    			   			
      			return prevSueloInicial;
          	}catch(Exception ex){
      	 		error= true;
      	        java.io.StringWriter sw = new java.io.StringWriter();
      	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
      	        ex.printStackTrace(pw);
      	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: " + sw.getBuffer ().toString());
      	        throw ex;                     
       	  }finally{
       		    try{
       		    	daoCuestionariosSMAnu.freeResourcesNotConnection();
       		    }catch(Exception ex){
      			   if (tr.isTraceActive()){
      				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: error liberando recursos");
      	   	   	   }  
       		    }  		 
       		  	//se cierra la conexin  
       		    cerrarConexion(error);	       	
      	        if (tr.isTraceActive()){
      	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortada: saliendo.");
      	   		}
       	  }
          } 
          
          
          /**
           * Funcin que eliminar grupo y cuestionarios de suelo de las tabla Q022CT00 y Q022ET00   
           * 
           * @param ano  - ano (que ser 2008)
           * @param codProvincia - provincia
           * @param codMunicipio - municipio 
           * 
           * @throws Exception Exception
           */
            public void eliminarCuestionariosSM(String ano, String codProvincia, String codMunicipio) throws Exception {   	 
            	boolean error = false;
            	try{
          		if (tr.isTraceActive()){
            			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":eliminarCuestionariosSM: entrando");
            		}
      	  		//se abre la conexin
      			abrirConexion();
      			//se instancia el dao pasandole la conexin			
      			daoCuestionariosSMAnu = new Q02aCuestionariosSMDataBaseDAO(this.getConn());
//      			se pasan los parmetros de usuario e idioma
      			//daoCuestionariosSMAnu.setUser(this.autenticador.getUser());
      			//daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());
      			//se llamaa la metodo del DAO que realiza la insert
      			daoCuestionariosSMAnu.eliminarCuestionariosSM(ano, codProvincia, codMunicipio);
      	  	}catch(Exception ex){
      	 		error= true;
      	        java.io.StringWriter sw = new java.io.StringWriter();
      	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
      	        ex.printStackTrace(pw);
      	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":eliminarCuestionariosSM: " + sw.getBuffer ().toString());
      	        throw ex;                     
       	  }finally{
       		    try{
       		    	daoCuestionariosSMAnu.freeResourcesNotConnection();
       		    }catch(Exception ex){
      			   if (tr.isTraceActive()){
      				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":eliminarCuestionariosSM: error liberando recursos");
      	   	   	   }  
       		    }  		 
       		  	//se cierra la conexin  
       		    cerrarConexion(error);	       	
      	        if (tr.isTraceActive()){
      	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarGrupoCuestionariosSM: saliendo.");
      	   		}
       	  }
          }//fin eliminarCuestionariosSM 
          
            /**
             * 
             * @param territorio territorio
             * @param municipio municipio
             * @param anyoReferencia anyoReferencia
             * @param mesReferencia mesReferencia
             * @return niGrupoCuesSMAnu
             * @throws Exception Exception
             */
        public String getNiGrupoCuesSM(String territorio, String municipio, String anyoReferencia, String mesReferencia) throws Exception
        {
        	String niGrupoCuesSMAnu = "";
        	boolean error = false;
            {          	              	
          	try{
          		 
          		if (tr.isTraceActive()){
            			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNiGrupoCuesSM: entrando");
            		}
      	  		//se abre la conexin
      			abrirConexion();
      			//se instancia el dao pasandole la conexin			
      			daoCuestionariosSMAnu = new Q02aCuestionariosSMDataBaseDAO(this.getConn());
      			
      			niGrupoCuesSMAnu = daoCuestionariosSMAnu.getNiGrupoCuesSM(territorio, municipio, anyoReferencia, mesReferencia);
      			    			   			
      			return niGrupoCuesSMAnu;
          	}catch(Exception ex){
      	 		error= true;
      	        java.io.StringWriter sw = new java.io.StringWriter();
      	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
      	        ex.printStackTrace(pw);
      	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNiGrupoCuesSM: " + sw.getBuffer ().toString());
      	        throw ex;                     
       	    }finally{
       		    try{
       		    	daoCuestionariosSMAnu.freeResourcesNotConnection();
       		    }catch(Exception ex){
      			   if (tr.isTraceActive()){
      				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNiGrupoCuesSM: error liberando recursos");
      	   	   	   }  
       		    }  		 
       		  	//se cierra la conexin  
       		    cerrarConexion(error);	       	
      	        if (tr.isTraceActive()){
      	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNiGrupoCuesSM: saliendo.");
      	   		}
       	    }  	
            }
        }//fin getNiGRupoCuesSM
        
        /**
         * 
       	 * Insertar/Modifica en bbdd un  nuevo grupo de cuestionarios con los datos pasados como parmetro 
         * en la HashMap de filtro
         * 
         * @param mapaCuestionarioSMAnuFiltro mapaCuestionarioSMAnuFiltro
         * @throws Exception Exception
         * @return niGrupoCuesSMAnu
    	 */
    	public String altaModifGrupoCuestionariosSMAnu(HashMap mapaCuestionarioSMAnuFiltro) throws Exception 
    	{
    		Q02aCuestionarioSMFiltro cuestionarioSMFiltro = null;
    		String niGrupoCuesSMAnu=null;	
    		boolean es2008=false;
    		String anoPortada2008=null;
    		try {
    			if (tr.isTraceActive()){
    				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: entrando");
    			}
    			//se pasa el hashmap de entrada a un objeto de tipo Q02aCuestionarioSMAnu	  		
    			cuestionarioSMFiltro = (Q02aCuestionarioSMFiltro) Q02aVoUtils.getValueObject(mapaCuestionarioSMAnuFiltro,"q02a.exe.cuestionariosSMAnu.valueobjects.Q02aCuestionarioSMFiltro");
    			//se instancia el bean de negocio
    	  		anoPortada2008 = q02a.exe.utils.Q02aConstantes.getString("ano.portada.2008");

    	  		//Antes de todo, vamos a comprobar el siguiente caso: se han rellenado cuestionarios de suelo del 2008
    		    //y ahora, el usuario, ha seleccionado que NO en la portada (donde no tenemos ell mes) y ha pulsado a Finalizar Cuestionario
    		    //es decir, despues de haber rellenado cuestionarios para uno o varios meses, ahora dice que no se ha concedido ninguna licencia
    		    //En este caso, deberemos borrar todos los cuestionarios (y sus grupos) y crear despus un grupo con prevSuelo==0 y sin mes
    	  		if(cuestionarioSMFiltro!= null && cuestionarioSMFiltro.getAno().equals(anoPortada2008) && Q02aFormatData.esNullSinCero(cuestionarioSMFiltro.getModificarPrevSuelo()).equals("1") && cuestionarioSMFiltro.getPrevSuelo().equals("0")){
    	  			es2008=true;	
    	  			this.eliminarCuestionariosSM(cuestionarioSMFiltro.getAno(),cuestionarioSMFiltro.getCodProv(), cuestionarioSMFiltro.getCodMuni());
    	  		}
    	  		niGrupoCuesSMAnu=this.altaModifGrupoCuestionariosSMAnu(cuestionarioSMFiltro);
   	  		
    	  		if(cuestionarioSMFiltro!= null && Q02aFormatData.esNullSinCero(cuestionarioSMFiltro.getModificarPrevSuelo()).equals("1")){
    	  			this.modificarGrupoCuestionariosSM(niGrupoCuesSMAnu,cuestionarioSMFiltro.getPrevSuelo(),cuestionarioSMFiltro.getMes(), cuestionarioSMFiltro.getObsSuelo());
    	  		}
    	  		
    	  		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: niGrupoCuestionarioSMAnu="+ niGrupoCuesSMAnu);
    			return niGrupoCuesSMAnu;			
    	     }catch(Exception ex){
                java.io.StringWriter sw = new java.io.StringWriter();
                java.io.PrintWriter pw = new java.io.PrintWriter(sw);
                ex.printStackTrace(pw); 
                if (tr.isTraceActive()){  
    				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: " + sw.getBuffer ().toString());
    			}
                throw ex;
    		 }finally{
    			 if (tr.isTraceActive()){
    					tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosSMAnu: saliendo");
    			}			
    		}
    	} // fin altaModifGrupoCuestionariosSMAnu
    	
    	/**
         * 
         * @throws Exception Exception
    	 */
    	 public void insertarContactoSM() throws Exception{
         	if (tr.isTraceActive()){
     			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarContactoSM: entrando");
     		}
         	 boolean error = false;
         	 try{
         		 //se abre la conexin
        			abrirConexion();
        			
        			//se obtiene el dni del usuario	
        			Q02aUsuarioInformanteDataBaseDAO daoUsuarioInformante = new Q02aUsuarioInformanteDataBaseDAO(this.getConn());
        			daoUsuarioInformante.setUser(this.getAutenticador().getUser());
        			String niUsuario = daoUsuarioInformante.getUser();
        			String niInformante = daoUsuarioInformante.obtenerNiInformante(niUsuario);
        			   			
        			if (niInformante!=""){
        				//obtener los datos del informante
        				Q02aInformantesDataBaseDAO daoInformante = new Q02aInformantesDataBaseDAO(this.getConn());
        				Q02aInformante informante = new Q02aInformante();
        				informante = daoInformante.getInformante(niInformante);
        				
        				//insertar el contacto
        				Q02aContactos contacto = new Q02aContactos();
        				Q02aContactosDataBaseDAO daoContactos = new Q02aContactosDataBaseDAO(this.getConn());
        				contacto.setCodProvincia(informante.getDescProvincia());
        				contacto.setCodMunicipio(informante.getDescMunicipio());
        				contacto.setIdInformante(informante.getIdInformante());
        				contacto.setIdOficina(informante.getIdOficina());
        				String codigoOnline =Q70ListenerUtils.getApplicationProperty("COD_TIPO_CONTACTO_ONLINE");
           				String codigoTabla = Q70ListenerUtils.getApplicationProperty("COD_TABLA_TIPO_CONTACTO");
           				//se instancia el dao pasandole la conexin			
           				daoTablas = new Q02aTablasDataBaseDAO(this.getConn());
           				String niOnline = daoTablas.getNiCuestionarioOnline(codigoOnline, codigoTabla);
           				contacto.setTipoContacto(niOnline);//Cuestionario On-line
        				contacto.setFechaProxContacto("");
        				contacto.setObservaciones("Informante "+informante.getNombre()+ " " + informante.getApellido1() + " " + informante.getApellido2() 
        						+" ha grabado el cuestionario de Estadstica de Obtencin de Suelo para Vivienda de Promocin Pblica" );
        				int idContacto = daoContactos.insertarContactoCuestionario(contacto);
        				if (tr.isTraceActive()){
        		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarContactoSM: contacto dado de alta --> idInformante=" 
        		   					+ niInformante + " niUsuario= " + niUsuario + "idContacto= " + idContacto);
        		   		}
        			}
        			else {
        				if (tr.isTraceActive()){
        		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarContactoSM: contacto NO dado de alta --> idInformante " +
        		   					"no existe para el niUsuario= " + niUsuario);
        		   		}
        			}
       		 	
         	 }catch(Exception ex){
     		  error= true;
               java.io.StringWriter sw = new java.io.StringWriter();
               java.io.PrintWriter pw = new java.io.PrintWriter(sw);
               ex.printStackTrace(pw);
               tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarContactoSM: " + sw.getBuffer ().toString());
               throw ex;                     
      	  }finally{
      		  	//se cierra la conexin  
      		  	cerrarConexion(error);	       	
     	        if (tr.isTraceActive()){
     	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarContactoSM: saliendo.");
     	   		}
      	  }
       	}//fin insertarContactoSM
 	 
    	 /**
          * 
          * @param cuestionarioSMAnu cuestionarioSMAnu
          * @return solicitud
          * @throws Exception Exception
    	  */
    	 public Q02aSolicitudNora rellenarSolicitudNora(Q02aCuestionarioSM cuestionarioSMAnu)throws Exception{
         	Q02aSolicitudNora solicitud=null;
         	try{
         		if (tr.isTraceActive()){
         			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenarSolicitudNora: entrando");
         		}
         		solicitud = new Q02aSolicitudNora();
         		solicitud.setCodigo(Q02aConstantes.getString("tipo.suelo.municipal"));
         		solicitud.setNiGrupoCuestionario(cuestionarioSMAnu.getNiGrupoCuesSMAnu());
         		solicitud.setNiCuestionario(cuestionarioSMAnu.getNiCuesSMAnu());
         		solicitud.setDireccion(cuestionarioSMAnu.getDirNueva());
         		solicitud.setEstadoSolicitud(Q02aConstantes.getString("estado.sol.nora.pdte"));
     		}catch(Exception ex){   	   
          		java.io.StringWriter sw = new java.io.StringWriter();
          		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
          		ex.printStackTrace(pw);
          		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenarSolicitudNora: " + sw.getBuffer ().toString());
          		throw ex;
          	}finally{    		
      			if (tr.isTraceActive()){
      				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenarSolicitudNora: saliendo");                
                 }  
      			return solicitud;
          	}	
          }
         
         /** Mtodo que obtiene el hashmap.
          * @return hashMap HashMap
          */
         private HashMap obtenerHashMap() {
             return new HashMap();
         }
}