package q02a.exe.cuestionarioVAPM.dataobjects;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

import q02a.exe.arquitectura.dataobjects.Q02aDAOException;
import q02a.exe.arquitectura.dataobjects.Q02aDataBaseDAO;
import q02a.exe.cuestionarioVAPM.valueobjects.Q02aCuestionarioVAPM;
import q02a.exe.cuestionarioVAPM.valueobjects.Q02aCuestionarioVAPMFiltro;
import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022GS00;
import q02a.exe.utils.Q02aAplicationUtils;
import q02a.exe.utils.Q02aFormatData;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;


/**
 * 
 * @author GADIMAAR
 *
 */
public class Q02aCuestionarioVAPMDataBaseDAO extends Q02aDataBaseDAO{
	private static final long serialVersionUID = -8520551641771839103L;
	private static Q70Traza tr = Q70Traza.getSingleton();
	private static final String COMPONENTE = "DAO_ACCESO_DATOS";
	private static final String RECURSOS_CUES_VAPM = "q02arecursosCuestionarios";

    /**
     * 
     *
     */
	public Q02aCuestionarioVAPMDataBaseDAO() {
        super();                
    }

    /**
     * 
     * @param conn conn
     */
    public Q02aCuestionarioVAPMDataBaseDAO(Connection conn) {
    	super(conn);     
    }
    
    /**
     * 
     * @param dato dato
     * @return aux
     */
    public String cambiarComa(String dato)
    {
    	boolean fin = false;
    	
	    String aux = new String();
	    
		
		while ( (dato.length() > 0) && !fin) {
				if (dato.indexOf(',') != -1 ) {	
					int indice2 = dato.indexOf( ',');
					aux = aux.concat( dato.substring( 0, indice2));
					aux = aux.concat(".");
					aux = aux.concat(dato.substring( indice2 + 1, dato.length()));
					fin = true;
				}else{
					aux = dato;
					fin=true;
				}
		}
		return aux;
		
    }
    
    /**
     * 
     * @param dato dato
     * @return aux
     */
    public String cambiarPunto(String dato)
    {
    	
    	boolean fin = false;
    		
	    String aux = new String();
	    
	   
		
    	while ((dato.length() > 0) && !fin) 
    	{
    		if (dato.indexOf('.') != -1) 
    		{	
    			int indice2 = dato.indexOf('.');
    			aux = aux.concat(dato.substring(0, indice2));
    			aux = aux.concat(",");
    			aux = aux.concat(dato.substring(indice2 + 1, dato.length()));
    			fin = true;
    		}else{
    			aux = dato;
    			fin=true;
    		}
    	}
    	return aux;	
    	
    }
    /*public void formatearNumero (Q02aCuestionarioVAPM cuestionarioVAPM, String cero)
    {
    	//valor = trim (valor);
    	String valor = cuestionarioAyunMen.getPpto();
    	String numero  = valor.trim();
    	String aux     = new String();
    	String entera  = new String();
    	String decimal = new String();
    	String finales = new String();
    	String final1  = new String();
    	boolean fin     = false;    	
    	boolean esCero  = true;
    	String resto   = new String();
    	//quita los ceros por delante:
    	
    	if (numero.equals("")){
    	    if (cero.equals("S")){ 
    		    numero = "0";
    		} else{ 
    		    numero="";
    		}
    	} else {	
    		
    		while(esCero) {
    			if (numero.charAt( 0) == '0') {
    			    if (numero.length() == 1){
    			        numero = "0";
    			        esCero = false;
    			    } else {
    				    numero = numero.substring(1, numero.length());
    				}
    			} else {
    			    if (numero.charAt( 0) == ',') {
    			        numero = "0" + numero;
    			    }
    				esCero = false;
    			}		
    		}    		
    		//le quita los puntos que ya tenga puestos
    		while ( numero.length() > 0 && fin == false) {
    			if ( numero.indexOf( '.') != -1) {	
    				int indice = numero.indexOf('.');
    				aux = aux.concat( numero.substring( 0, indice));								
    				numero = numero.substring( indice + 1, numero.length());
    			} else {
    				aux = aux.concat( numero);
    				fin = true;
    			}	
    		}
    		//guardamos los decimales:
    		int indice = aux.indexOf(',');
    		if ( indice!=-1) {
    			entera = aux.substring( 0, indice);
    			decimal = aux.substring( indice, aux.length());	
    		} else {
    			entera  = aux;
    			decimal = "";
    		}
    		
    		//ponemos los puntos de los miles:
    		while( entera.length() > 3){
    			int longitud = entera.length();
    			resto   = entera.substring( longitud-3, longitud);
    			entera  = entera.substring( 0, entera.lastIndexOf( resto));
    			finales = "." + resto + finales;
    		}
    	   
    		final1 = final1.concat(entera).concat(finales).concat(decimal);
    		numero = final1;
        }
    	cuestionarioAyunMen.setPpto(numero);
    	
    }*/
       
      /**
      * Funcin que devuelve el campo Prevision Suelo para un municipio y ao determinados por los parmetros de entrada
      * 
      * @param codProv - Cdigo de la provincia
      * @param codMuni - Cdigo del municipio
      * @param ano - Ao  
      * @throws Exception Exception
      * @return concedeLicen
      */
     public String obtenerCampoConcedeLicenDeGrupoConMuniAno(String codProv,String codMuni,String ano) throws Exception {
    	//se definen objetos necesarios.
    	 
    	ResultSet rs = null;
    	String concedeLicen = null;
       	Q02aTablaBDQ022GS00 tablaBDGrupoCuestionarioVAPM = null;
       	
       	try{
	    	if (tr.isTraceActive())
	    	{
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoConcedeLicenDeGrupoConMuniAno: entrando");
	   	}
	    	
	    	tablaBDGrupoCuestionarioVAPM = new Q02aTablaBDQ022GS00(this.getConnection());
	    	rs = this.dameRsGrupoCues(codProv,codMuni,ano,tablaBDGrupoCuestionarioVAPM);
	         	if (rs.next())
	         	{
	         		
	         		concedeLicen = rs.getString(tablaBDGrupoCuestionarioVAPM.NOMCOLUMN_Q022GT00_CONCEDIDO_LICEN);
	         		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoConcedeLicenDeGrupoConMuniAno: entrando");
	        	}
	         	
	         		
      		return Q02aFormatData.esNullSinCero(concedeLicen);
     	}
     	catch(Exception ex)
     	{   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoConcedeLicenDeGrupoConMuniAno: " + sw.getBuffer ().toString());
     		throw ex;
     	}
     	finally
     	{
     		try
     		{
     			tablaBDGrupoCuestionarioVAPM.freeResourcesNotConnection();	
     		}
     		catch(Exception ex)
     		{
     			if (tr.isTraceActive())
     			{
     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoConcedeLicenDeGrupoConMuniAno: error liberando recursos");
 		   	   }  
 		}  		
		if (tr.isTraceActive())
		{
			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoConcedeLicenDeGrupoConMuniAno: saliendo");                
    		}       	
     	}
     }
     
     /**
      * 
      * @param codProv codProv
      * @param codMuni codMuni
      * @param ano ano
      * @param tablaBDGrupoCuestionarioVAPM tablaBDGrupoCuestionarioVAPM
      * @return rs
      * @throws Exception Exception
      */
     private ResultSet dameRsGrupoCues(String codProv,String codMuni,String ano,Q02aTablaBDQ022GS00 tablaBDGrupoCuestionarioVAPM) throws Exception 
     {
    	
     	ResultSet rs = null;	
     	try{
	    	if (tr.isTraceActive())
	    	{
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameRsGrupoCues: entrando");
	   	}
	   	
	         	//tablaBDGrupoCuestionarioVAPM.setFCA02T00_CODPROVINC_WHERE(new Integer(codProv));
	         	//tablaBDGrupoCuestionarioVAPM.setFCA02T00_CODMUNICIP_WHERE(new Integer(codMuni));
	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_MUN_PROV_WHERE(codProv);
	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_MUN_MUNI_WHERE(codMuni);
	         	tablaBDGrupoCuestionarioVAPM.setQ022GT00_ANO_WHERE(new Integer(ano));   
	         	
	         	rs = tablaBDGrupoCuestionarioVAPM.select();
	         	tablaBDGrupoCuestionarioVAPM.addResultSet(rs);     	
	         	return rs;
	        }
	        catch(Exception ex)
     	        {   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameRsGrupoCues: " + sw.getBuffer ().toString());
     		throw ex;
     	      }
     	      finally
     	      {
     	      	if (tr.isTraceActive())
	    	{
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameRsGrupoCues: saliendo");
	   	}
     	      }
     }
     
     /**
      * Funcin que devuelve un string con los meses que le quedan por introducir para un municipio y ao determinados por los parmetros de entrada
      * 
      * @param codProv - Cdigo de la provincia
      * @param codMuni - Cdigo del municipio
      * @param ano - Ao
      * @param idioma - Idioma
      * @return msgAnos
      * @throws Exception Exception
      */
     public String obtenerAnosPendientesParaMuni(String codProv,String codMuni,String ano,String idioma) throws Exception {
    	//se definen objetos necesarios.
    	
    	String msgAnos = "";
    	ResultSet rs = null;
    	java.util.Hashtable hashAnos = new java.util.Hashtable();
    	String [] arrNombresAnos = {};
       	Q02aTablaBDQ022GS00 tablaBDGrupoCuestionarioVAPM = null;
       	
       	try{
	    	if (tr.isTraceActive())
	    	{
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientesParaMuni: entrando");
	   	}
	   	
	   	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientesParaMuni: idioma="+ idioma);
	   	if(Q70ListenerUtils.getApplicationProperty("IDIOMA_ES").equals(idioma))
	   	{
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientesParaMuni: idioma ES");
	   		arrNombresAnos = Q02aAplicationUtils.dameArrayAnosCuesVAPM();
	   	}
	   	else if(Q70ListenerUtils.getApplicationProperty("IDIOMA_EU").equals(idioma))
	   	{
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientesParaMuni: idioma EU");
	   		arrNombresAnos = Q02aAplicationUtils.dameArrayAnosCuesVAPM();
	   	}
	   	//Se carga el hashtable con los aos
	   	for (int i=1;i<=arrNombresAnos.length;i++)
	   	{
	   		hashAnos.put(Integer.toString(i),arrNombresAnos[i-1]);
		}
	   	tablaBDGrupoCuestionarioVAPM = new Q02aTablaBDQ022GS00(this.getConnection());
	   	int aux = hashAnos.size();
	    	rs = this.dameAnosPendientes(codProv,codMuni,ano,tablaBDGrupoCuestionarioVAPM);
	         	while (rs.next())
	         	{
	         		
	         		boolean encon = true;
	         		int key = 1;
	         		int cont = aux;
	         		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientesParaMuni: Hay cuestionarios SM Anu en el ao ****"+ rs.getString(1));
	         		
	         		while (cont > 0 && encon)
	         		{
	         			
	         			if (hashAnos.containsKey(Integer.toString(key)))
	         			{
	         				String obj = (String)hashAnos.get(Integer.toString(key));
	         				if (obj.equals(rs.getString(1)))
	         				{
	         					
	         					hashAnos.remove(Integer.toString(key));
	         					encon = false;
	         				}else {key++;}
	         			}else{
	         				key++;
                        }
	         				cont--;
	         			
	         		}
	         		   		
	         		
	        	}
	         	
	        	if(!hashAnos.isEmpty())
	        	{
	        		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientesParaMuni:Faltan cuestionarios de meter, xq el array hastable no est vacio ****");
	        		String anosP = "";
	        		for (int i=0;i<arrNombresAnos.length;i++)
	        		{
	        			//Si el array de meses contiene el mes, es que falta de introducir datos, 
	        			if(hashAnos.containsKey(Integer.toString(i+1)))
	        			{
	        				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientesParaMuni:Falta de introducir el ao  ******* ="+ i);
	        				if(!anosP.equals("")){
	        					anosP += ", ";
                            }
	        				anosP += hashAnos.get(Integer.toString(i+1));
	        			}
	        		}
	        		
	        		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientesParaMuni:Aos sin meter ******* ="+ anosP);
	        		msgAnos = Q70GestorMensajesi18n.getSingleton().getMessage(RECURSOS_CUES_VAPM,"cuestionarios.vAPM.anosFaltanDos",idioma) + anosP + ".";
	        		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientesParaMuni:MSG = ****" + msgAnos);
	
	        	}

      		return msgAnos;
     	}
     	catch(Exception ex)
     	{   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAnosPendientesParaMuni: " + sw.getBuffer ().toString());
     		throw ex;
     	}
     	finally
     	{
     		try
     		{
     			tablaBDGrupoCuestionarioVAPM.freeResourcesNotConnection();	
     		}
     		catch(Exception ex)
     		{
     			if (tr.isTraceActive())
     			{
     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAnosPendientesParaMuni: error liberando recursos");
 		   	   }  
 		}  		
		if (tr.isTraceActive())
		{
			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientesParaMuni: saliendo");                
    		}       	
     	}
     }
     
     
     /**
      * 
      * @param codProv codProv
      * @param codMuni codMuni
      * @param ano ano
      * @param tablaBDGrupoCuestionarioVAPM tablaBDGrupoCuestionarioVAPM
      * @return rs
      * @throws Exception Exception
      */
     private ResultSet dameAnosPendientes(String codProv,String codMuni,String ano ,Q02aTablaBDQ022GS00 tablaBDGrupoCuestionarioVAPM) throws Exception 
     {
    	
     	ResultSet rs = null;	
     	try{
	    	if (tr.isTraceActive())
	    	{
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameAnosPendientes: entrando");
	   	}
	   	
	    	tablaBDGrupoCuestionarioVAPM.setDistinct(tablaBDGrupoCuestionarioVAPM.NOMCOLUMN_Q022GT00_ANO);
	    	//tablaBDGrupoCuestionarioVAPM.setFCA02T00_CODPROVINC_WHERE(new Integer(codProv));
	    	//tablaBDGrupoCuestionarioVAPM.setFCA02T00_CODMUNICIP_WHERE(new Integer(codMuni));
	    	tablaBDGrupoCuestionarioVAPM.setQ022GT00_MUN_PROV_WHERE(codProv);
	    	tablaBDGrupoCuestionarioVAPM.setQ022GT00_MUN_MUNI_WHERE(codMuni);
	        //tablaBDGrupoCuestionarioVAPM.setQ022GT00_FEC_BAJA_WHERE(null);
	        rs = tablaBDGrupoCuestionarioVAPM.selectDistinct();
	        tablaBDGrupoCuestionarioVAPM.addResultSet(rs);     	
	        return rs;
	        }
	        catch(Exception ex)
     	        {   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameAnosPendientes: " + sw.getBuffer ().toString());
     		throw ex;
     	      }
     	      finally
     	      {
     	      	if (tr.isTraceActive())
	    	{
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameAnosPendientes: saliendo");
	   	}
     	      }
     }
     
     
     
     /**
      * Funcin que comprueba si para el municipio, ao hay algn registro en la tabla de Grupos de 
      * 
      * @param niCuesVAPM - Datos de la cuestionario a insertar
      * @param cuestionarioVAPMFiltro - Datos de la cuestionario a insertar
      * @throws Exception Exception
      * @return cuestionarioVAPM
      */
     public Q02aCuestionarioVAPM altaModifCuestionarioVAPM(String niCuesVAPM,Q02aCuestionarioVAPMFiltro cuestionarioVAPMFiltro ) throws Exception {
    	//se definen objetos necesarios.
    	 
       	Q02aTablaBDQ022GS00 tablaBDGrupoCuestionarioVAPM = null;
       	Q02aCuestionarioVAPM cuestionarioVAPM= new Q02aCuestionarioVAPM();
       	String ano= null;
       	String concedidoLicen= null;
       	String codMunicip=null;
       	
       	try{
 	    	if (tr.isTraceActive()){
 	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifCuestionarioVAPM: entrando");
 	    	}
    		//se crea el objeto de tablasBD
 	    	tablaBDGrupoCuestionarioVAPM = new Q02aTablaBDQ022GS00(this.getConnection());
      		//this.obtenerGrupoCuestionarioVAPM(cuestionarioVAPMFiltro,tablaBDGrupoCuestionarioVAPM);
      		
      		this.obtenerGrupoCuestionarioVAPM(cuestionarioVAPMFiltro,tablaBDGrupoCuestionarioVAPM);
      		
      		
      		cuestionarioVAPM = this.obtenerCuestionarioVAPM(niCuesVAPM);
      		
      		return cuestionarioVAPM;
     	}
     	catch(Exception ex)
     	{   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifCuestionarioVAPM: " + sw.getBuffer ().toString());
     		throw ex;
     	}finally{
     		try	{
     			tablaBDGrupoCuestionarioVAPM.freeResourcesNotConnection();	
     		}catch(Exception ex){
     			if (tr.isTraceActive())	{
     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifCuestionarioVAPM: error liberando recursos");
 		   	     }  
     		}  		
 		if (tr.isTraceActive())
 		{
 			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifCuestionarioVAPM: saliendo");                
    		}       	
     	}
     }
     
     /**
      * 
      * @param cuestionarioVAPMFiltro cuestionarioVAPMFiltro
      * @param tablaBDGrupoCuestionarioVAPM tablaBDGrupoCuestionarioVAPM
      * @throws Exception Exception
      */
     private void obtenerGrupoCuestionarioVAPM(Q02aCuestionarioVAPMFiltro cuestionarioVAPMFiltro,Q02aTablaBDQ022GS00 tablaBDGrupoCuestionarioVAPM) throws Exception 
     {
    	ResultSet rs = null;
    	String niCuestionariosVAPM=null;    	
     	String concedeLicenBD=null;
     	String concedeLicenFiltro=null;
     	Q02aCuestionarioVAPM cuestionarioVAPM= new Q02aCuestionarioVAPM();
     	
     	try{
 	    	if (tr.isTraceActive()){
 	    	    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerGrupoCuestionarioVAPM: entrando");
 	    	}
 	    	
     	    tablaBDGrupoCuestionarioVAPM.setQ022GT00_MUN_PROV_WHERE(Q02aFormatData.checkStringNull(cuestionarioVAPMFiltro.getCodProv()));
     	    tablaBDGrupoCuestionarioVAPM.setQ022GT00_MUN_MUNI_WHERE(Q02aFormatData.checkStringNull(cuestionarioVAPMFiltro.getCodMuni()));
     	    tablaBDGrupoCuestionarioVAPM.setQ022GT00_ANO_WHERE(Q02aFormatData.checkIntegerNull(cuestionarioVAPMFiltro.getAno()));
	   	
     	    rs=tablaBDGrupoCuestionarioVAPM.select();
     	    tablaBDGrupoCuestionarioVAPM.addResultSet(rs);
 	  
     	   	if(rs.next()){
     	   		
     	   		niCuestionariosVAPM =rs.getString(tablaBDGrupoCuestionarioVAPM.NOMCOLUMN_Q022GT00_ID_CUES);
     	   		cuestionarioVAPMFiltro.setNiCuesVAPM(niCuestionariosVAPM);
     	   		concedeLicenBD= Q02aFormatData.esNull(rs.getString(tablaBDGrupoCuestionarioVAPM.NOMCOLUMN_Q022GT00_CONCEDIDO_LICEN));
     	   		concedeLicenFiltro = Q02aFormatData.esNull(cuestionarioVAPMFiltro.getConcedidoLicen());
                
     	   		tablaBDGrupoCuestionarioVAPM.setQ022GT00_OBSSU(Q02aFormatData.checkStringNull(cuestionarioVAPMFiltro.getObservacionesVA()));
                if ( cuestionarioVAPMFiltro.getUsuModif() != null && !"".equals(cuestionarioVAPMFiltro.getUsuModif()) ){
     	   		    tablaBDGrupoCuestionarioVAPM.setQ022GT00_USU_MODIF(Q02aFormatData.checkStringNull(cuestionarioVAPMFiltro.getUsuModif()));
                }else if ( cuestionarioVAPMFiltro.getDniUsuario() != null && !"".equals(cuestionarioVAPMFiltro.getUsuModif())){
                    tablaBDGrupoCuestionarioVAPM.setQ022GT00_USU_MODIF(Q02aFormatData.checkStringNull(cuestionarioVAPMFiltro.getDniUsuario()));
                }
    	   		//hayCuestionarios = this.obtenerNumCuestionarios(cuestionarioVAPMFiltro.getCodProv(),cuestionarioVAPMFiltro.getCodMuni(),cuestionarioVAPMFiltro.getAno());
    			if(!concedeLicenBD.equals(concedeLicenFiltro)){
    	   			//Si en el Filtro se ha puesto que se realizan actuaciones, significaba que antes no, con lo que hay que modificar el registro en BD
    	   			//Si antes si se realizaban y ahora no, se modifica tb el registro, y se anulan los cuestionarios de ese grupo mediante un trigger
    	   			this.modificarPrevGrupoCuestionarioVAPM(cuestionarioVAPMFiltro,tablaBDGrupoCuestionarioVAPM);
    	   		}
    			tablaBDGrupoCuestionarioVAPM.update();
     	   		 	   		
     		}else{
     	   		//Si no existe el grupo se da de alta
     	   		niCuestionariosVAPM = this.insertarGrupoCuestionarioVAPM(cuestionarioVAPMFiltro,tablaBDGrupoCuestionarioVAPM);
    			cuestionarioVAPMFiltro.setNiCuesVAPM(niCuestionariosVAPM);
     	   	} 	   
 	    }catch(Exception ex){   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerGrupoCuestionarioVAPM: " + sw.getBuffer ().toString());
     		throw ex;
     	}
 	    //return cuestionarioVAPM;
     }
     
     /**
      * 
      * @param cuestionarioVAPMFiltro cuestionarioVAPMFiltro
      * @param tablaBDGrupoCuestionarioVAPM tablaBDGrupoCuestionarioVAPMs
      * @throws Exception Exception
      */
     public void  modificarPrevGrupoCuestionarioVAPM(Q02aCuestionarioVAPMFiltro cuestionarioVAPMFiltro,Q02aTablaBDQ022GS00 tablaBDGrupoCuestionarioVAPM) throws Exception {
    	
    	 try{
 	    	if (tr.isTraceActive()){
 	    	    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarLicenciaGrupoCuestionarioVAPM: entrando");
 	    	}
 	    	
 	   		//realizaActuacion = cuestionarioVTMAnuFiltro.getRealizaActuacion();
 	    	tablaBDGrupoCuestionarioVAPM.setQ022GT00_ID_CUES_WHERE(Q02aFormatData.checkIntegerNull(cuestionarioVAPMFiltro.getNiCuesVAPM()));
 	    	tablaBDGrupoCuestionarioVAPM.setQ022GT00_CONCEDIDO_LICEN(Q02aFormatData.checkIntegerNull(cuestionarioVAPMFiltro.getConcedidoLicen()));
 	    	//tablaBDGrupoCuestionarioVAPM.setQ022GT00_OBSSU(Q02aFormatData.checkStringNull(cuestionarioVAPMFiltro.getObservacionesVA()));
 			
 	    	if (cuestionarioVAPMFiltro.getConcedidoLicen().equals("0")){
 				tablaBDGrupoCuestionarioVAPM.setQ022GT00_PRV1A(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_ADQVI1(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NADQ1(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_PROVI1(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NPRO1(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_OTRVI1(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_OTRLT1(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NOTR1(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NTOT1(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_PRV4A(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_ADQVI4(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NADQ4(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_PROVI4(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NPRO4(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_OTRVI4(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_OTRLT4(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NOTR4(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NTOT4(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_TALQ(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NALQ(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NEXCL(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NEMER(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NOTRO(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_DESVOTR(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NPROP(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NSP45(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NSP75(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NSP90(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NSP90M(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NSPT(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NRSP45(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NRSP75(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NRSP90(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NRSP90M(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NRSPT(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NOCUP(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NDESA(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NDESO(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NDESOT(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_DESOTR(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NOCUT(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NVPOG(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NVPOE(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NVPOT(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NALOD(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NREAL(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NLIBRE(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NVTMG(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NVTME(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NVTOT(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NANT60M(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NANT30(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NANT10(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NANT10M(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NANTT(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_OBSAL(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_FUERA_PLAZO(null);
 			}
 	    	
      	}catch(Exception ex){   	   
      		java.io.StringWriter sw = new java.io.StringWriter();
      		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
      		ex.printStackTrace(pw);
      		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarLicenciaGrupoCuestionarioVAPM: " + sw.getBuffer ().toString());
      		throw ex;
      	}
     
    	 /*	String concedeLicen = null;
        	try{
 	    	if (tr.isTraceActive())
 	    	{
 	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarPrevGrupoCuestionarioVAPM: entrando");
 	   	}
 	    	concedeLicen = cuestionarioVAPMFiltro.getConcedeLicen();
 	    	if (concedeLicen.equals("1"))
 	    	{
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_ID_CUES_WHERE(Q02aFormatData.checkIntegerNull(niCuesVAPM));
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_CONCEDIDO_LICEN(Q02aFormatData.checkIntegerNull(concedeLicen));
 	    		tablaBDGrupoCuestionarioVAPM.update();
 	    	}
 	    	else
 	    	{
 	    		
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_ID_CUES_WHERE(Q02aFormatData.checkIntegerNull(niCuesVAPM));
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_CONCEDIDO_LICEN(Q02aFormatData.checkIntegerNull(concedeLicen));
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_PRV1A(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_ADQVI1(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NADQ1(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_PROVI1(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NPRO1(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_OTRVI1(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_OTRLT1(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NOTR1(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NTOT1(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_PRV4A(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_ADQVI4(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NADQ4(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_PROVI4(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NPRO4(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_OTRVI4(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_OTRLT4(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NOTR4(null); 	 	    	
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NTOT4(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_TALQ(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NALQ(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NSP45(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NSP75(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NSP90(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NSP90M(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NSPT(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NRSP45(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NRSP75(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NRSP90(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NRSP90M(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NRSPT(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NOCUP(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NDESA(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NDESO(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NDESOT(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_DESOTR(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NOCUT(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NVPOG(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NVPOE(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NVPOT(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NALOD(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NREAL(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NLIBRE(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NVTMG(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NVTME(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NVTOT(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NANT60M(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NANT30(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NANT10(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NANT10M(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_NANTT(null);
 	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_OBSAL(null); 	    		
 	    		tablaBDGrupoCuestionarioVAPM.update();
 	    		//tablaBDGrupoCuestionarioVAPM.delete();
 	    	}

      	}
      	catch(Exception ex)
      	{   	   
      		java.io.StringWriter sw = new java.io.StringWriter();
      		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
      		ex.printStackTrace(pw);
      		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarPrevGrupoCuestionarioVAPM: " + sw.getBuffer ().toString());
      		throw ex;
      	}*/
    
      }
     
     /**
      * 
      * @param cuestionarioVAPMFiltro cuestionarioVAPMFiltro
      * @param tablaBDGrupoCuestionarioVAPM tablaBDGrupoCuestionarioVAPM
      * @return cuestionarioVAPMFiltro.getNiCuesVAPM()
      * @throws Exception Exception
      */
     public String insertarGrupoCuestionarioVAPM(Q02aCuestionarioVAPMFiltro cuestionarioVAPMFiltro,Q02aTablaBDQ022GS00 tablaBDGrupoCuestionarioVAPM) throws Exception {
      	   	 
     	//se definen objetos necesarios.
     	int niCuesVAPM=1;     	
        	try{
 	    	if (tr.isTraceActive())
 	    	{
 	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarGrupoCuestionarioVAPM: entrando");
 	   	}
 	    	niCuesVAPM = this.dameSeqNiDeGrupo(tablaBDGrupoCuestionarioVAPM);
 	    	cuestionarioVAPMFiltro.setNiCuesVAPM(Integer.toString(niCuesVAPM));   
         	//tablaBDGrupoCuestionariosVTMAnu.reset();	         
         	//----------------------------------------------------------------------         	
         	//se aaden los datos a insertar
     		this.rellenaDatosFiltroCuestionarioVAPM(cuestionarioVAPMFiltro, tablaBDGrupoCuestionarioVAPM);         	         
     		//se realiza la insert
     		tablaBDGrupoCuestionarioVAPM.insert();
     		//pediente de recuperar el numContacto
     		return cuestionarioVAPMFiltro.getNiCuesVAPM();
 	    	
 	    	
       		
      	}
      	catch(Exception ex)
      	{   	   
      		java.io.StringWriter sw = new java.io.StringWriter();
      		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
      		ex.printStackTrace(pw);
      		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarGrupoCuestionarioVAPM: " + sw.getBuffer ().toString());
      		throw ex;
      	}
    
      }
     
     /**
      * 
      * @param cuestionarioVAPMFiltro cuestionarioVAPMFiltro
      * @param tablaBDGrupoCuestionarioVAPM tablaBDGrupoCuestionarioVAPM
      * @throws Exception Exception
      */
     public void rellenaDatosFiltroCuestionarioVAPM(Q02aCuestionarioVAPMFiltro cuestionarioVAPMFiltro,Q02aTablaBDQ022GS00 tablaBDGrupoCuestionarioVAPM) throws Exception {
      	//se definen objetos necesarios.
    	
      	try{
  	    	if (tr.isTraceActive())
  	    	{
  	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosFiltroCuestionarioVAPM: entrando");
  	   	}         	         
       		//se aaden los datos
  	    	tablaBDGrupoCuestionarioVAPM.setQ022GT00_ID_CUES(Q02aFormatData.checkIntegerNull(cuestionarioVAPMFiltro.getNiCuesVAPM()));
  	    	tablaBDGrupoCuestionarioVAPM.setQ022GT00_ANO(Q02aFormatData.checkIntegerNull(cuestionarioVAPMFiltro.getAno()));  	    	
  	    	tablaBDGrupoCuestionarioVAPM.setQ022GT00_CONCEDIDO_LICEN(Q02aFormatData.checkIntegerNull(cuestionarioVAPMFiltro.getConcedidoLicen()));
  	    	tablaBDGrupoCuestionarioVAPM.setQ022GT00_OBSSU(Q02aFormatData.checkStringNull(cuestionarioVAPMFiltro.getObservacionesVA()));
  	    	//tablaBDGrupoCuestionarioVAPM.setFCA02T00_CODPROVINC(Q02aFormatData.checkIntegerNull(cuestionarioVAPMFiltro.getCodProv()));
  	    	//tablaBDGrupoCuestionarioVAPM.setFCA02T00_CODMUNICIP(Q02aFormatData.checkIntegerNull(cuestionarioVAPMFiltro.getCodMuni()));
  	    	if(!(Q02aFormatData.esNullSinCero(cuestionarioVAPMFiltro.getCodProv())).equals("")){
  	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_MUN_PROV(cuestionarioVAPMFiltro.getCodProv());
            }
  	    	if(!(Q02aFormatData.esNullSinCero(cuestionarioVAPMFiltro.getCodMuni())).equals("")){
  	    		tablaBDGrupoCuestionarioVAPM.setQ022GT00_MUN_MUNI(cuestionarioVAPMFiltro.getCodMuni());
            }
            if ( cuestionarioVAPMFiltro.getUsuAlta() != null && !"".equals(cuestionarioVAPMFiltro.getUsuAlta()) ){
                tablaBDGrupoCuestionarioVAPM.setQ022GT00_USU_ALTA( Q02aFormatData.checkStringNull(cuestionarioVAPMFiltro.getUsuAlta()) );
            }else if ( cuestionarioVAPMFiltro.getDniUsuario() != null && !"".equals(cuestionarioVAPMFiltro.getDniUsuario()) ){
                tablaBDGrupoCuestionarioVAPM.setQ022GT00_USU_ALTA( Q02aFormatData.checkStringNull(cuestionarioVAPMFiltro.getDniUsuario()) );
            }
            if ( cuestionarioVAPMFiltro.getUsuModif() != null && !"".equals(cuestionarioVAPMFiltro.getUsuModif()) ){
                tablaBDGrupoCuestionarioVAPM.setQ022GT00_USU_MODIF( Q02aFormatData.checkStringNull(cuestionarioVAPMFiltro.getUsuModif()) );
            }

      	}catch(Exception ex){   	   
      		java.io.StringWriter sw = new java.io.StringWriter();
      		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
      		ex.printStackTrace(pw);
      		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaDatosFiltroCuestionarioVAPM: " + sw.getBuffer ().toString());
      		throw ex;
      	}finally{    		
  			if (tr.isTraceActive()){
  				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosFiltroCuestionarioVAPM: saliendo");                
             }       	
      	}	
      }  
      
     /**
      * 
      * @param cuestionarioVAPMFiltro cuestionarioVAPMFiltro
      * @return niCuesVAPM
      * @throws Exception Exception
      */
     public String obtenerNiCuesVAPM(Q02aCuestionarioVAPMFiltro cuestionarioVAPMFiltro) throws Exception
     {
    	
    	 int niCuesVAPMInt=1;
    	 String niCuesVAPM = null;
    	 String ano = null;
    	 String codMuni = null;
    	 String codProv = null;
    	 ResultSet rs = null;
    	 Q02aTablaBDQ022GS00 tablaBDGrupoCuestionarioVAPM = null;
    	 try{
             
  	    	if (tr.isTraceActive())	{
  	    	    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNiCuesVAPM: entrando");
  	    	}
            
  	    	tablaBDGrupoCuestionarioVAPM = new Q02aTablaBDQ022GS00(this.getConnection());
  	    	ano = cuestionarioVAPMFiltro.getAno();
  	    	codMuni = cuestionarioVAPMFiltro.getCodMuni();
  	    	codProv = cuestionarioVAPMFiltro.getCodProv();
  	    	tablaBDGrupoCuestionarioVAPM.setQ022GT00_ANO_WHERE(new Integer(ano));
  	    	//tablaBDGrupoCuestionarioVAPM.setFCA02T00_CODMUNICIP_WHERE(new Integer(codMuni));
  	    	//tablaBDGrupoCuestionarioVAPM.setFCA02T00_CODPROVINC_WHERE(new Integer(codProv));
  	    	tablaBDGrupoCuestionarioVAPM.setQ022GT00_MUN_PROV_WHERE(codProv);
  	    	tablaBDGrupoCuestionarioVAPM.setQ022GT00_MUN_MUNI_WHERE(codMuni);
           	rs = tablaBDGrupoCuestionarioVAPM.select();
  	    	
            if (rs.next()){
  	    		niCuesVAPM = rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_ID_CUES);
  	    	}else{
	  	    	niCuesVAPMInt = this.dameSeqNiDeGrupo(tablaBDGrupoCuestionarioVAPM);
	  	    	niCuesVAPM = Integer.toString(niCuesVAPMInt);
	  	    	
  	    	}
        	return niCuesVAPM;	
       	}
       	catch(Exception ex)
       	{   	   
       		java.io.StringWriter sw = new java.io.StringWriter();
       		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
       		ex.printStackTrace(pw);
       		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerNiCuesVAPM: " + sw.getBuffer ().toString());
       		throw ex;
       	}
     
    	 
    	 
     }
     
     /**
      * 
      * @param tablaBDGrupoCuestionarioVAPM tablaBDGrupoCuestionarioVAPM
      * @return niGrupoCuestionarioVAPM
      * @throws Exception Exception
      */
     private int dameSeqNiDeGrupo(Q02aTablaBDQ022GS00 tablaBDGrupoCuestionarioVAPM) throws Exception 
     {
    	 
    	int niGrupoCuestionarioVAPM=1;
     	ResultSet rs = null;
       	PreparedStatement prepStmt =null;	
     	try{
	    	if (tr.isTraceActive())
	    	{
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameSeqNiDeGrupo: entrando");
	   	}
	    		StringBuffer query = new StringBuffer(" SELECT Q022GQ00.NEXTVAL FROM DUAL ");
	         	prepStmt = this.getConnection().prepareStatement(query.toString());         	
	         	rs = prepStmt.executeQuery();
	         	tablaBDGrupoCuestionarioVAPM.addResultSet(rs);
	         	tablaBDGrupoCuestionarioVAPM.addStatement(prepStmt);        	
	         	if (rs.next()){
	         		niGrupoCuestionarioVAPM = rs.getInt(1);
	         		
	         	}	         	
	         	return niGrupoCuestionarioVAPM;
	        }
	        catch(Exception ex)
     	        {   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameSeqNiDeGrupo: " + sw.getBuffer ().toString());
     		throw ex;
     	      }
	        
     }

     
     /**
      * Mtodo que dado el nmero interno del cuestionarioVAPM recuperar de la BBDD
      * los datos de dicho cuestionarioVAPM.
      * @param niCuesVAPM niCuesVAPM
      * @return cuestionarioVAPM
      */
     public Q02aCuestionarioVAPM obtenerCuestionarioVAPM(String niCuesVAPM)throws Exception
     {
    	 
   	  if (tr.isTraceActive()){
  		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVAPM : entrando");            
         	}
   	  
   	  //se crean los objetos necesarios para ralizar la select.

   	  Q02aTablaBDQ022GS00 Q02aTablaBDQ022GS00obj = null;
   	  Q02aCuestionarioVAPM cuestionarioVAPM = null;
   	  ResultSet rs = null;  
   	  String dato=null;
         try{ 
          
        	   
           	Q02aTablaBDQ022GS00obj = new Q02aTablaBDQ022GS00(this.getConnection());
           	//se pone el filtro    
           	Q02aTablaBDQ022GS00obj.setQ022GT00_ID_CUES_WHERE(new Integer(niCuesVAPM));
           	
           	rs = Q02aTablaBDQ022GS00obj.select();
           
           	Q02aTablaBDQ022GS00obj.addResultSet(rs);
          
           	cuestionarioVAPM = tratarRs(rs);           	
           	
       /*    	if (cuestionarioVAPM.getRtaMedDes() != null)
           	{
           		dato = cambiarPunto(cuestionarioVAPM.getRtaMedDes());
           		cuestionarioVAPM.setRtaMedDes(dato);
           	}
           	if (cuestionarioVAPM.getRtaMed50() != null)
           	{
           		dato = cambiarPunto(cuestionarioVAPM.getRtaMed50());
           		cuestionarioVAPM.setRtaMed50(dato);
           	}
           	if (cuestionarioVAPM.getRtaMed76() != null)
           	{
           		dato = cambiarPunto(cuestionarioVAPM.getRtaMed76());
           		cuestionarioVAPM.setRtaMed76(dato);
           	}
           	if (cuestionarioVAPM.getRtaMed91() != null)
           	{
           		dato = cambiarPunto(cuestionarioVAPM.getRtaMed91());
           		cuestionarioVAPM.setRtaMed91(dato);
           	}
           	if (cuestionarioVAPM.getRtaMedTot() != null)
           	{
           		dato = cambiarPunto(cuestionarioVAPM.getRtaMedTot());
           		cuestionarioVAPM.setRtaMedTot(dato);
           	}*/
            
           return cuestionarioVAPM;
           
           }catch(Exception ex){           	   
                  java.io.StringWriter sw = new java.io.StringWriter();
                  java.io.PrintWriter pw = new java.io.PrintWriter(sw);
                  ex.printStackTrace(pw);
                  tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioVAPM: " + sw.getBuffer ().toString());
                  throw ex;
           }finally{
        	   try{
   	   			 Q02aTablaBDQ022GS00obj.freeResourcesNotConnection();	
   				}catch(Exception ex){
   	   			if (tr.isTraceActive()){
   	   				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioVAPM: error liberando recursos");
   	   		   	   }  
   				}  	
            	  if (tr.isTraceActive()){
            		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVAPM: saliendo");                
                 }            	 
           }	  
           
     }//fin obtenerCuestionarioVAPM
     
     /**
      * 
      * @param rs rs
      * @return cuestionarioVAPM
      * @throws Exception Exception
      */
     private Q02aCuestionarioVAPM  tratarRs (ResultSet rs) throws Exception
     {
    	 
    	  tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":tratarRs: entrando");           
    	  Q02aCuestionarioVAPM cuestionarioVAPM = new Q02aCuestionarioVAPM();
    	  
       	  if (rs.next())
       	  {	 
       		 tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":tratarRs: Hay registro");                
       		 try{
            		 	
       			 rellenarVOCuestionarioVAPM(cuestionarioVAPM,rs);
             	}catch (Exception e) {
    	    		if (tr.isTraceActive()){
    	   	   		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":tratarRs: error "+ e.getMessage());
    	   	   	}  
             		}  	
    	}
       	return cuestionarioVAPM;
     }
     
     /**
      * 
      * @param cuestionarioVAPM cuestionarioVAPM
      * @param rs rs
      * @throws Exception Exception
      */
     private void rellenarVOCuestionarioVAPM (Q02aCuestionarioVAPM cuestionarioVAPM, ResultSet rs) 
     throws Exception {
    	 
     	try{
		    tr.trace(COMPONENTE, Q70TraceLevel.DEBUG, this.getClass().getName() + ":rellenarVOCuestionarioVAPM: Hay Datos");            
		    
		    cuestionarioVAPM.setNiCuesVAPM(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_ID_CUES));
		    cuestionarioVAPM.setAno(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_ANO));
		    cuestionarioVAPM.setConcedidoLicen(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_CONCEDIDO_LICEN));
		    //cuestionarioVAPM.setCodProvinc(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_FCA02T00_CODPROVINC));
		    //cuestionarioVAPM.setCodMunicip(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_FCA02T00_CODMUNICIP));
		    cuestionarioVAPM.setMunProv(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_MUN_PROV));
		    cuestionarioVAPM.setMunMuni(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_MUN_MUNI));
		    cuestionarioVAPM.setPrv1a(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_PRV1A));
		    cuestionarioVAPM.setAdqvi1(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_ADQVI1));
		    cuestionarioVAPM.setNadq1(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NADQ1));
		    cuestionarioVAPM.setProvi1(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_PROVI1));
		    cuestionarioVAPM.setNpro1(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NPRO1));
		    cuestionarioVAPM.setOtrvi1(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_OTRVI1));
		    cuestionarioVAPM.setOtrlt1(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_OTRLT1));
		    cuestionarioVAPM.setNotr1(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NOTR1));
		    cuestionarioVAPM.setNtot1(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NTOT1));
		    cuestionarioVAPM.setPrv4a(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_PRV4A));
		    cuestionarioVAPM.setAdqvi4(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_ADQVI4));
		    cuestionarioVAPM.setNadq4(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NADQ4));
		    cuestionarioVAPM.setProvi4(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_PROVI4));
		    cuestionarioVAPM.setNpro4(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NPRO4));
		    cuestionarioVAPM.setOtrvi4(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_OTRVI4));
		    cuestionarioVAPM.setOtrlt4(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_OTRLT4));
		    cuestionarioVAPM.setNotr4(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NOTR4));
		    cuestionarioVAPM.setNtot4(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NTOT4));
		    cuestionarioVAPM.setTalq(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_TALQ));
		    cuestionarioVAPM.setNalq(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NALQ));
		    cuestionarioVAPM.setNexcl(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NEXCL));
		    cuestionarioVAPM.setNemer(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NEMER));
		    cuestionarioVAPM.setNotro(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NOTRO));
		    cuestionarioVAPM.setDesvotr(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_DESVOTR));
		    cuestionarioVAPM.setNprop(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NPROP));		    
		    cuestionarioVAPM.setNsp45(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NSP45));
		    cuestionarioVAPM.setNsp75(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NSP75));
		    cuestionarioVAPM.setNsp90(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NSP90));
		    cuestionarioVAPM.setNsp90m(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NSP90M));
		    cuestionarioVAPM.setNspt(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NSPT));
		    cuestionarioVAPM.setNsp90m(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NSP90M));
		    cuestionarioVAPM.setNrsp45(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NRSP45));
		    cuestionarioVAPM.setNrsp75(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NRSP75));
		    cuestionarioVAPM.setNrsp90(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NRSP90));
		    cuestionarioVAPM.setNrsp90m(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NRSP90M));
		    cuestionarioVAPM.setNrspt(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NRSPT));
		    cuestionarioVAPM.setNocup(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NOCUP));
		    cuestionarioVAPM.setNdesa(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NDESA));
		    cuestionarioVAPM.setNdeso(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NDESO));
		    cuestionarioVAPM.setNdesot(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NDESOT));
		    cuestionarioVAPM.setDesotr(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_DESOTR));
		    cuestionarioVAPM.setNocut(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NOCUT));
		    cuestionarioVAPM.setNvpog(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NVPOG));
		    cuestionarioVAPM.setNvpoe(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NVPOE));
		    cuestionarioVAPM.setNvpot(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NVPOT));
		    cuestionarioVAPM.setNalod(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NALOD));
		    cuestionarioVAPM.setNreal(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NREAL));
		    cuestionarioVAPM.setNlibre(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NLIBRE));
		    cuestionarioVAPM.setNvtmg(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NVTMG));
		    cuestionarioVAPM.setNvtme(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NVTME));
		    cuestionarioVAPM.setNvtot(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NVTOT));
		    cuestionarioVAPM.setNant60m(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NANT60M));
		    cuestionarioVAPM.setNant30(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NANT30));
		    cuestionarioVAPM.setNant10(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NANT10));
		    cuestionarioVAPM.setNant10m(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NANT10M));
		    cuestionarioVAPM.setNantt(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_NANTT));
		    cuestionarioVAPM.setObsal(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_OBSAL));		    
		    cuestionarioVAPM.setFueraPlazo(rs.getString(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_FUERA_PLAZO));    
		    
     	}catch (Exception e){
	    	if (tr.isTraceActive()){
	   	   	    tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenarVOCuestionarioVAPM: error "+ e.getMessage());
	    	}  
        }  	
     }
     
     /**
      * Funcin que modifica los datos del cuestionarioVAPM pasado como parmetro en la BBDD
      * 
      * @param cuestionarioVAPM - Datos de cuestionarioVAPM a modificar
      * @param ano ano
      * @param codMunicip codMunicip
      * @param concedeLicen concedeLicen
      * @param codProvinc codProvinc
      * @param niCuesVAPM niCuesVAPM
      * 
      * @throws Exception Exception
      */
     public void modificarCuestionarioVAPM(Q02aCuestionarioVAPM cuestionarioVAPM, String ano, String codMunicip, String concedeLicen, String codProvinc, String niCuesVAPM) throws Exception {
    	//int niCuesVAPM=1;
    	 
    	String dato=null;
    	String num = null;
    	ResultSet rs = null;
      	if (tr.isTraceActive()){
      	    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVAPM: entrando");
      	}
      	//Se isntancian los objetos necesarios.
      	Q02aTablaBDQ022GS00 Q02aTablaBDQ022GS00obj = null;    
        
      	try{     
         	 	//se crea el objeto de tablasBD
        		Q02aTablaBDQ022GS00obj = new Q02aTablaBDQ022GS00(this.getConnection());
        		//segmento tecnico
             		//Q02aTablaBDQ022AS00obj.setUser(this.getUser());
        		/*if (cuestionarioVAPM.getRtaMedDes() != null)
        		{
        			dato = this.cambiarComa(cuestionarioVAPM.getRtaMedDes());
        			cuestionarioVAPM.setRtaMedDes(dato);
        		}
        		if (cuestionarioVAPM.getRtaMed50() != null)
        		{
        			dato = this.cambiarComa(cuestionarioVAPM.getRtaMed50());
        			cuestionarioVAPM.setRtaMed50(dato);
        		}
        		if (cuestionarioVAPM.getRtaMed76() != null)
        		{
        			dato = this.cambiarComa(cuestionarioVAPM.getRtaMed76());
        			cuestionarioVAPM.setRtaMed76(dato);
        		}
        		if (cuestionarioVAPM.getRtaMed91() != null)
        		{
        			dato = this.cambiarComa(cuestionarioVAPM.getRtaMed91());
        			cuestionarioVAPM.setRtaMed91(dato);
        		}
        		if (cuestionarioVAPM.getRtaMedTot() != null)
        		{
        			dato = this.cambiarComa(cuestionarioVAPM.getRtaMedTot());
        			cuestionarioVAPM.setRtaMedTot(dato);
        		}*/
        	
        	Q02aTablaBDQ022GS00obj.setQ022GT00_ID_CUES_WHERE(new Integer(niCuesVAPM));           	
           	rs = Q02aTablaBDQ022GS00obj.select();
  	    	if (rs.next()){
            	rellenaDatosCuestionarioVAPM(cuestionarioVAPM,ano,codMunicip,concedeLicen,codProvinc,niCuesVAPM,Q02aTablaBDQ022GS00obj);
           		Q02aTablaBDQ022GS00obj.setQ022GT00_ID_CUES_WHERE(new Integer(niCuesVAPM));
           		
           		//se realiza la update
           		Q02aTablaBDQ022GS00obj.update();
          		
  	    	}
        	
        }catch(Exception ex){
              java.io.StringWriter sw = new java.io.StringWriter();
              java.io.PrintWriter pw = new java.io.PrintWriter(sw);
              ex.printStackTrace(pw);
              tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVAPM: " + sw.getBuffer ().toString());
              throw ex;
        }finally{     
         	try{
         	    Q02aTablaBDQ022GS00obj.freeResourcesNotConnection();	
         	}catch(Exception ex){
    		   if (tr.isTraceActive()){
    			   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVAPM: error liberando recursos");
       	   	   }  
         	}  		  
          	if (tr.isTraceActive()){
          		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVAPM: saliendo");                
            }             
        }     
     } // fin modificarCuestionarioVAPM
     
     /**
      * 
      * @param ano ano
      * @param codMuni codMuni
      * @param tablaBDCuestionarioVAPM tablaBDCuestionarioVAPM
      * @return niCuesVAPM
      * @throws Exception Exception
      */
     private int dameMaxNiCues(String ano, String codMuni, Q02aTablaBDQ022GS00 tablaBDCuestionarioVAPM) throws Exception 
     {
    	 
     	int niCuesVAPM=1;
     	ResultSet rs = null;	
     	try{
	    	if (tr.isTraceActive())
	    	{
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameMaxNiCues: entrando");
	   	}
	    		
	    		tablaBDCuestionarioVAPM.setMax(tablaBDCuestionarioVAPM.NOMCOLUMN_Q022GT00_ID_CUES);
	         	//tablaBDCuestionarioVAPM.setQ022GT00_ANO_WHERE(new Integer(ano));
	         	//tablaBDCuestionarioVAPM.setFCA02T00_CODMUNICIP_WHERE(new Integer(codMuni));
	         	rs = tablaBDCuestionarioVAPM.selectMax();
	         	tablaBDCuestionarioVAPM.addResultSet(rs);     	
	         	if (rs.next()){
	         		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":dameMaxNiCues: max Cuestionario para ano y codmunicipio " + ano+ " "+ codMuni +" ="+ rs.getInt(1));
	         		niCuesVAPM = rs.getInt(1) + 1;
	         	}
	         	return niCuesVAPM;
	        }
	        catch(Exception ex)
     	        {   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":dameMaxNiCues: " + sw.getBuffer ().toString());
     		throw ex;
     	      }
     }
     
     /**
      * Funcin que inserta los datos del cuestionarioVAPM pasada como parmetro en la BBDD
      * 
      * @param cuestionarioVAPM - Datos de la cuestionarioVAPM a insertar
      * @param ano ano
      * @param codMunicip codMunicip
      * @param concedeLicen concedeLicen
      * @param codProvinc codProvinc
      * @param niCuesVAPM niCuesVAPM
      * @param tablaBDCuestionarioVAPM tablaBDCuestionarioVAPM
      * 
      * @throws Exception Exception
      */
     public void rellenaDatosCuestionarioVAPM( Q02aCuestionarioVAPM cuestionarioVAPM, String ano, String codMunicip, String concedeLicen, String codProvinc, String niCuesVAPM, Q02aTablaBDQ022GS00 tablaBDCuestionarioVAPM) throws Exception {
     	//se definen objetos necesarios.
    	
     	try{
 	    	if (tr.isTraceActive())
 	    	{
 	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosCuestionarioVAPM: entrando");
 	   	}         	         
      		//se aaden los datos
 	    	
 	    	tablaBDCuestionarioVAPM.setQ022GT00_PRV1A(Q02aFormatData.checkStringNull(cuestionarioVAPM.getPrv1a()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_ADQVI1(Q02aFormatData.checkStringNull(cuestionarioVAPM.getAdqvi1()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NADQ1(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNadq1()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_PROVI1(Q02aFormatData.checkStringNull(cuestionarioVAPM.getProvi1()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NPRO1(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNpro1()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_OTRVI1(Q02aFormatData.checkStringNull(cuestionarioVAPM.getOtrvi1()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_OTRLT1(Q02aFormatData.checkStringNull(cuestionarioVAPM.getOtrlt1()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NOTR1(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNotr1()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NTOT1(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNtot1()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_PRV4A(Q02aFormatData.checkStringNull(cuestionarioVAPM.getPrv4a()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_ADQVI4(Q02aFormatData.checkStringNull(cuestionarioVAPM.getAdqvi4()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NADQ4(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNadq4()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_PROVI4(Q02aFormatData.checkStringNull(cuestionarioVAPM.getProvi4()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NPRO4(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNpro4()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_OTRVI4(Q02aFormatData.checkStringNull(cuestionarioVAPM.getOtrvi4()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_OTRLT4(Q02aFormatData.checkStringNull(cuestionarioVAPM.getOtrlt4()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NOTR4(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNotr4()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NTOT4(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNtot4()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_TALQ(Q02aFormatData.checkStringNull(cuestionarioVAPM.getTalq()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NALQ(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNalq()));
 	    	
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NEXCL(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNexcl()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NEMER(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNemer()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NOTRO(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNotro()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_DESVOTR(Q02aFormatData.checkStringNull(cuestionarioVAPM.getDesvotr()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NPROP(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNprop()));
 	    	
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NSP45(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNsp45()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NSP75(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNsp75()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NSP90(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNsp90()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NSP90M(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNsp90m()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NSPT(Q02aFormatData.checkDoubleNull(cuestionarioVAPM.getNspt()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NRSP45(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNrsp45()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NRSP75(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNrsp75()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NRSP90(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNrsp90()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NRSP90M(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNrsp90m()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NRSPT(Q02aFormatData.checkDoubleNull(cuestionarioVAPM.getNrspt()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NOCUP(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNocup()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NDESA(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNdesa()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NDESO(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNdeso()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NDESOT(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNdesot()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_DESOTR(Q02aFormatData.checkStringNull(cuestionarioVAPM.getDesotr()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NOCUT(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNocut()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NVPOG(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNvpog()));	    		
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NVPOE(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNvpoe()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NVPOT(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNvpot()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NALOD(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNalod()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NREAL(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNreal()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NLIBRE(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNlibre()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NVTMG(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNvtmg()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NVTME(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNvtme()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NVTOT(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNvtot()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NANT60M(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNant60m()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NANT30(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNant30()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NANT10(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNant10()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NANT10M(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNant10m()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_NANTT(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNantt()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_OBSAL(Q02aFormatData.checkStringNull(cuestionarioVAPM.getObsal()));
 	    	tablaBDCuestionarioVAPM.setQ022GT00_FUERA_PLAZO(Q02aFormatData.checkStringNull(cuestionarioVAPM.getFueraPlazo()));
 	    	
            if ( cuestionarioVAPM.getUsuAlta() != null && !"".equals(cuestionarioVAPM.getUsuAlta()) ){
                tablaBDCuestionarioVAPM.setQ022GT00_USU_ALTA( Q02aFormatData.checkStringNull(cuestionarioVAPM.getUsuAlta()) );
            }
            if ( cuestionarioVAPM.getUsuModif() != null && !"".equals(cuestionarioVAPM.getUsuModif()) ){
                tablaBDCuestionarioVAPM.setQ022GT00_USU_MODIF( Q02aFormatData.checkStringNull(cuestionarioVAPM.getUsuModif()) );
            }
            
     	}catch(Exception ex){   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaDatosCuestionarioVAPM: " + sw.getBuffer ().toString());
     		throw ex;
     	}finally{    		
 			if (tr.isTraceActive()){
 				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosCuestionarioVAPM: saliendo");                
            }       	
     	}	
     }
     
     /**
      * Funcin que comprueba si para el municipio y ao hay algn registro en la tabla de Grupos de 
      * 
      * @param cuestionarioVAPMFiltro cuestionarioVAPMFiltro
      * @return niCuesVAPM
      * @throws Exception Exception
      */
     public String altaModifGrupoCuestionariosVAPM(Q02aCuestionarioVAPMFiltro cuestionarioVAPMFiltro) throws Exception {
    	//se definen objetos necesarios. 	
    	 Q02aTablaBDQ022GS00 tablaBDGrupoCuestionariosVAPM = null;
       	//Q02aCuestionarioVTMAnuFiltro grupoCuestionarioVTMAnuBD = null;
       	String niCuesVAPM= null;
       	try{
	    	if (tr.isTraceActive()){
	    	    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVAPM: entrando");
	    	}
    		//se crea el objeto de tablasBD
	    	tablaBDGrupoCuestionariosVAPM = new Q02aTablaBDQ022GS00(this.getConnection());
      		this.obtenerGrupoCuestionarioVAPM(cuestionarioVAPMFiltro,tablaBDGrupoCuestionariosVAPM);
      		niCuesVAPM =cuestionarioVAPMFiltro.getNiCuesVAPM();
      		return niCuesVAPM;
     	}catch(Exception ex){   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosVAPM: " + sw.getBuffer ().toString());
     		throw ex;
     	}finally{
     		try{
     			tablaBDGrupoCuestionariosVAPM.freeResourcesNotConnection();	
     		}catch(Exception ex){
     			 if (tr.isTraceActive()){
     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosVAPM: error liberando recursos");
 		   	     }  
     		}  		
    		if (tr.isTraceActive()){
    			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVAPM: saliendo");                
    		}       	
     	}
     }
     
     /**
      * Funcin que devuelve el campo Concede Licencias para un municipio,ao y mes determinados por los parmetros de entrada
      * 
      * @param codProv- Cdigo de la provincia
      * @param codMuni- Cdigo del municipio
      * @param ano- Ao
      * @param mes- Mes
      * @throws Exception
      */
   /*  public boolean obtenerNumCuestionarios(String codProv,String codMuni,String ano) throws Exception {
    	//se definen objetos necesarios.
    	boolean hayCuestionarios = false;
    	ResultSet rs = null;
       	Q02aTablaBDQ022GS00 tablaBDGrupoCuestionariosVAPM = null;       	
       	int numero = -1;
       	try{
	    	if (tr.isTraceActive())
	    	{
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNumCuestionarios: entrando");
	   	}
	   	
	    	tablaBDGrupoCuestionariosVAPM = new Q02aTablaBDQ022GS00(this.getConnection());
	    	
	    	
	    	//hacer un metodo nuevo
	    	rs = this.dameRsNumCues(codProv,codMuni,ano,tablaBDGrupoCuestionariosVAPM);
	        if (rs.next())
	        {
	        	numero = rs.getInt(1);
	        	if (numero > 0)
	        	{
	        		hayCuestionarios = true;
	        	}
	        	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNumCuestionarios: entrando");
	        }
	        	
      		return hayCuestionarios;
     	}
     	catch(Exception ex)
     	{   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerNumCuestionarios: " + sw.getBuffer ().toString());
     		throw ex;
     	}
     	finally
     	{
     		try
     		{
     			tablaBDGrupoCuestionariosVAPM.freeResourcesNotConnection();	
     		}
     		catch(Exception ex)
     		{
     			if (tr.isTraceActive())
     			{
     				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoConcedeLicenDeGrupoConMuniAnoYMes: error liberando recursos");
 		   	   }  
 		}  		
		if (tr.isTraceActive())
		{
			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoConcedeLicenDeGrupoConMuniAnoYMes: saliendo");                
    		}       	
     	}
     }*/
     
     /**
      * @param territorio territorio
      * @param municipio municipio
      * @param anyoReferencia anyoReferencia
      * @param mesReferencia mesReferencia
      * 
      * @throws  Exception Exception
      * @return numCuestionariosVA 
      */
     public int getNumCuestionariosVA(String territorio, String  municipio, String  anyoReferencia, String  mesReferencia) throws Exception 
     {
    	int numCuestionariosVA=0;
    	ResultSet rs = null;
       	PreparedStatement prepStmt =null;	
       	StringBuffer query = null;
     	try{
	    	if (tr.isTraceActive()){
	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosVA: entrando");
	    	}
	    	query = new StringBuffer("SELECT COUNT(*) FROM Q022GS00 WHERE");
        	query.append(" Q022GT00_ANO=").append(anyoReferencia);
        	query.append(" AND Q022GT00_MUN_PROV='").append(territorio).append("'");
        	query.append(" AND Q022GT00_MUN_MUNI='").append(municipio).append("'");
        	query.append(" AND Q022GT00_CONCEDIDO_LICEN=1");
        	prepStmt = this.getConnection().prepareStatement(query.toString());
        	
   	 		rs = prepStmt.executeQuery(); 
   	 		if(rs.next()){
   	 		numCuestionariosVA = rs.getInt(1);
   	 		}
	        if (tr.isTraceActive()){
		    	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosVA: saliendo");
		    }
	        return numCuestionariosVA;
	       }catch(Exception ex){   	   
	     		java.io.StringWriter sw = new java.io.StringWriter();
	     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	     		ex.printStackTrace(pw);
	     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosVA: " + sw.getBuffer ().toString());
	     		throw ex;
     	    }finally{ 
	    	   try{
	    		   if (rs!=null){
	    			   rs.close();
                   }
	       		   if (prepStmt!=null){
	       			   prepStmt.close();
                   }
	          }catch(Exception ex){
	        	  java.io.StringWriter sw = new java.io.StringWriter();
		          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
		          ex.printStackTrace(pw);
		          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: " + sw.getBuffer ().toString());
		          throw new Q02aDAOException(ex);
	          }
     	    }
     }

     /**
      * 
      * @param territorio territorio
      * @param municipio municipio
      * @param anyoReferencia anyoReferencia
      * @param mesReferencia mesReferencia
      * @return concedidoLicenVAPM
      * @throws Exception Exception
      */
     public String getConcedidoLicenGrupoCuesVAPM(String territorio, String  municipio, String  anyoReferencia, String  mesReferencia) throws Exception 
     {
    	String concedidoLicenVAPM="";
    	ResultSet rs = null;
       	PreparedStatement prepStmt =null;	
       	StringBuffer query = null;
     	try{
	    	if (tr.isTraceActive()){
	    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getConcedidoLicenGrupoCuesVAPM: entrando");
	    	}
	    	query = new StringBuffer("SELECT Q022GT00_CONCEDIDO_LICEN FROM Q022GS00 WHERE");
        	query.append(" Q022GT00_ANO=").append(anyoReferencia);
        	query.append(" AND Q022GT00_MUN_PROV='").append(territorio).append("'");
        	query.append(" AND Q022GT00_MUN_MUNI='").append(municipio).append("'");	  
        	
        	prepStmt = this.getConnection().prepareStatement(query.toString());
        	
   	 		rs = prepStmt.executeQuery(); 
   	 		if(rs.next()){
   	 		concedidoLicenVAPM = rs.getString(1);
   	 		}
	        if (tr.isTraceActive()){
		    	tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getConcedidoLicenGrupoCuesVAPM: saliendo");
		    }
	        return concedidoLicenVAPM;
	       }catch(Exception ex){   	   
	     		java.io.StringWriter sw = new java.io.StringWriter();
	     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	     		ex.printStackTrace(pw);
	     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getConcedidoLicenGrupoCuesVAPM: " + sw.getBuffer ().toString());
	     		throw ex;
     	    }finally{ 
	    	   try{
	    		   if (rs!=null){
	    			   rs.close();
                   }
	       		   if (prepStmt!=null){
	       			   prepStmt.close();
                   }
	          }catch(Exception ex){
	        	  java.io.StringWriter sw = new java.io.StringWriter();
		          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
		          ex.printStackTrace(pw);
		          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getConcedidoLicenGrupoCuesVAPM: " + sw.getBuffer ().toString());
		          throw new Q02aDAOException(ex);
	          }
     	    }
     }
     
     /**
      * 
      * @param territorio territorio
      * @param municipio municipio
      * @param anyoReferencia anyoReferencia
      * @param mesReferencia mesReferencia
      * @return observacionesVAPM
      * @throws Exception Exception
      */
     public Q02aCuestionarioVAPM getObservacionesVAPM(String territorio, String  municipio, String  anyoReferencia, String  mesReferencia) 
     throws Exception {
        ResultSet rs = null;
        PreparedStatement prepStmt =null;   
        StringBuffer query = null;
        
        Q02aCuestionarioVAPM miQ02aCuestionarioVAPM = new Q02aCuestionarioVAPM();
        
        try{
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getObservacionesVAPM: entrando");
            }
            query = new StringBuffer("SELECT Q022GT00_ID_CUES, Q022GT00_CONCEDIDO_LICEN, Q022GT00_OBSSU FROM Q022GS00 WHERE");
            query.append(" Q022GT00_ANO=").append(anyoReferencia);
            query.append(" AND Q022GT00_MUN_PROV='").append(territorio).append("'");
            query.append(" AND Q022GT00_MUN_MUNI='").append(municipio).append("'");   
            
            prepStmt = this.getConnection().prepareStatement(query.toString());
            
            rs = prepStmt.executeQuery(); 
            if (rs.next()) {
                 
                miQ02aCuestionarioVAPM.setNiCuesVAPM( rs.getString("Q022GT00_ID_CUES")== null? "":( rs.getString("Q022GT00_ID_CUES") ) );
                miQ02aCuestionarioVAPM.setConcedidoLicen( rs.getString("Q022GT00_CONCEDIDO_LICEN")== null? "":( rs.getString("Q022GT00_CONCEDIDO_LICEN") ) );
                miQ02aCuestionarioVAPM.setObsal( rs.getString("Q022GT00_OBSSU")== null? "":( rs.getString("Q022GT00_OBSSU") ) );
                
            }
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getObservacionesVAPM: saliendo");
            }
            return miQ02aCuestionarioVAPM;
            
        }catch(Exception ex){       
                java.io.StringWriter sw = new java.io.StringWriter();
                java.io.PrintWriter pw = new java.io.PrintWriter(sw);
                ex.printStackTrace(pw);
                tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getObservacionesVAPM: " + sw.getBuffer ().toString());
                throw ex;
        }finally{ 
              try{
                   if (rs!=null){
                       rs.close();
                   }
                   if (prepStmt!=null){
                       prepStmt.close();
                   }
              }catch(Exception ex){
                  java.io.StringWriter sw = new java.io.StringWriter();
                  java.io.PrintWriter pw = new java.io.PrintWriter(sw);
                  ex.printStackTrace(pw);
                  tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getObservacionesVAPM: " + sw.getBuffer ().toString());
                  throw new Q02aDAOException(ex);
              }
            }
     }
     
     /**
      * 
      * @param cuestionarioVAPMFiltroPortada cuestionarioVAPMFiltroPortada
      * @return Exception
      * @throws Exception Exception
      */
     public String obtenerIdGrupoCuestionariosVAPM(Q02aCuestionarioVAPMFiltro cuestionarioVAPMFiltroPortada) throws Exception 
     {
     	ResultSet rs = null;
     	String idCues=null;
     	Q02aTablaBDQ022GS00 tablaBDGrupoCuestionariosVAPM = null;
     	try{
 		    	if (tr.isTraceActive()){
 		    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerIdGrupoCuestionariosVAPM: entrando");
 		    	}
 		    	tablaBDGrupoCuestionariosVAPM = new Q02aTablaBDQ022GS00(this.getConnection());
 		    	tablaBDGrupoCuestionariosVAPM.addColumnSelect(Q02aTablaBDQ022GS00.NOMCOLUMN_Q022GT00_ID_CUES);
 		    	tablaBDGrupoCuestionariosVAPM.setQ022GT00_ANO_WHERE(Q02aFormatData.checkIntegerNull(cuestionarioVAPMFiltroPortada.getAno()));
 		    	tablaBDGrupoCuestionariosVAPM.setQ022GT00_MUN_PROV_WHERE(Q02aFormatData.checkStringNull(cuestionarioVAPMFiltroPortada.getCodProv()));
 		    	tablaBDGrupoCuestionariosVAPM.setQ022GT00_MUN_MUNI_WHERE(Q02aFormatData.checkStringNull(cuestionarioVAPMFiltroPortada.getCodMuni()));
 		    	tablaBDGrupoCuestionariosVAPM.setQ022GT00_CONCEDIDO_LICEN_WHERE(1);
 			   	 			   	
 			   	rs=tablaBDGrupoCuestionariosVAPM.select();
 			   	tablaBDGrupoCuestionariosVAPM.addResultSet(rs);
 			   	if(rs.next()){
 			   		idCues =rs.getString(tablaBDGrupoCuestionariosVAPM.NOMCOLUMN_Q022GT00_ID_CUES);
 			   	}
 			   	if (tr.isTraceActive()){
 		    		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerIdGrupoCuestionariosVAPM: saliendo");
 		    	}
 			   	return idCues;
 		 } catch(Exception ex){   	   
     		java.io.StringWriter sw = new java.io.StringWriter();
     		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
     		ex.printStackTrace(pw);
     		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerIdGrupoCuestionariosVAPM: " + sw.getBuffer ().toString());
     		throw ex;
     	  }finally{
       		try{
       			tablaBDGrupoCuestionariosVAPM.freeResourcesNotConnection();	
       		}
       		catch(Exception ex){
       			if (tr.isTraceActive()){
       				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerIdGrupoCuestionariosVAPM: error liberando recursos");
   		   	 }  
       		}
     	 }
     }   
     
     /**
      * 
      * @param idCues idCues
      * @return listaCuestionariosVAPM
      * @throws Exception Exception
      */
     public ArrayList getSelectCuestionariosVAPM(String idCues) throws Exception {		
  		//se instancian los objetos necesarios para realizar la consulta.			
    	Q02aTablaBDQ022GS00 tablaBDGrupoCuestionariosVAPM=null;
  		ResultSet rs = null;
  		ArrayList listaCuestionariosVAPM = new ArrayList();
  		Q02aCuestionarioVAPM cuestionarioVAPM;
  		try{
  	    	if (tr.isTraceActive()){
  				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getSelectCuestionariosVAPM: entrando");
  			}
  	    	//se instancia la clase del tablas bd a llamar pasandole la conexion	    	
  	    	tablaBDGrupoCuestionariosVAPM = new Q02aTablaBDQ022GS00(this.getConnection());
  	    	//rellenamos la where con los datos del filtro de usuarioTODO
  	    	this.rellenaFiltroCuestionarioVAPM(idCues, tablaBDGrupoCuestionariosVAPM);	    	    	
  	    	//se realiza la select
  	    	rs = tablaBDGrupoCuestionariosVAPM.select();
  	    	//aadimos el cursos para luego poder liberarlo ( en el freeResources)
  	    	tablaBDGrupoCuestionariosVAPM.addResultSet(rs); 
  	    	//se trata el resultado obtenido aadiendolo a la lista de salida
  	    	listaCuestionariosVAPM = this.rellenaVOsCuestionariosVAPM(rs);
  	    	
  	    	for (int i=0; i < listaCuestionariosVAPM.size(); i++){
  	    		cuestionarioVAPM = (Q02aCuestionarioVAPM)listaCuestionariosVAPM.get(i); 	    		
 	    	}
 	    	
  	    	return listaCuestionariosVAPM;    	
  		}catch(Exception ex){ 	   
      		java.io.StringWriter sw = new java.io.StringWriter();
      		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
      		ex.printStackTrace(pw);
      		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getSelectCuestionariosVAPM: " + sw.getBuffer ().toString());
      		throw ex;
  		}finally{
  		 	try{
  		 		//liberamos los recursos OJO! LOS QUE SE HAN AADIDO CON addResultSet
  		 		tablaBDGrupoCuestionariosVAPM.freeResourcesNotConnection();	
  			 }catch(Exception ex)
  			 {
  			    if (tr.isTraceActive())
  			    {
  				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getSelectCuestionariosVAPM: error liberando recursos.");
  	   	   	    }  
  			 }  		 			
  			 if (tr.isTraceActive()){
  				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getSelectCuestionariosVAPM: saliendo.");                
  	         }   
  		}	
  	}
     
     /**
      * Mtodo que rellena el tablasBD con los datos del filtro de objeto que contiene
      * el ni del objeto y el tipo de objeto
      * 
      * @param idCues idCues
      * @param tablaBD tablaBD
      * 
      * @throws Exception Exception
      */
    public void rellenaFiltroCuestionarioVAPM(String idCues,Q02aTablaBDQ022GS00 tablaBD)throws Exception
    {
     //Definicin de variables que no se van a modificar
     final String TRACE_METODO = ":rellenaFiltroCuestionarioVAPM:";
    	try{
    		if (tr.isTraceActive())
    		{
		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + TRACE_METODO + " entrando");                
		} 
	    	/*if(cuestionarioSMAnuFiltro!=null)
	    	{
	    		if (!Q02aFormatData.esVacio(cuestionarioSMAnuFiltro.getCodProv())){
	    			tablaBD.setFCA02T00_CODPROVINC_WHERE(new Integer(cuestionarioSMAnuFiltro.getCodProv()));
	    		}
	    		if (!Q02aFormatData.esVacio(cuestionarioSMAnuFiltro.getCodMuni())){
	    			tablaBD.setFCA02T00_CODMUNICIP_WHERE(new Integer(cuestionarioSMAnuFiltro.getCodMuni()));
	    		}
	    		if (!Q02aFormatData.esVacio(cuestionarioSMAnuFiltro.getAno())){
	    			tablaBD.setQ022BT00_ANO_WHERE(new Integer(cuestionarioSMAnuFiltro.getAno()));
	    		}
	    		if (!Q02aFormatData.esVacio(cuestionarioSMAnuFiltro.getMes())){
	    			tablaBD.setQ022BT00_MES_WHERE(new Integer(cuestionarioSMAnuFiltro.getMes()));
	    		}
	    		if (!Q02aFormatData.esVacio(cuestionarioSMAnuFiltro.getLicenciasMes())){
	    			tablaBD.setQ022BT00_CONCEDIDO_LICEN_WHERE(new Integer(cuestionarioSMAnuFiltro.getLicenciasMes()));
	    		}*/
	    		if (!Q02aFormatData.esVacio(idCues)){
	    			tablaBD.setQ022GT00_ID_CUES_WHERE(new Integer(idCues));
	    		}	    		
	    	//}	    	
    	}catch(Exception ex)
    	{    	 	   
	       java.io.StringWriter sw = new java.io.StringWriter();
	       java.io.PrintWriter 	pw = new java.io.PrintWriter(sw);
	       ex.printStackTrace(pw);
	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() 		+ TRACE_METODO + sw.getBuffer ().toString());
	       throw ex;
	}finally
	{			 	
		if (tr.isTraceActive())
		{
		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() 	+ TRACE_METODO + " saliendo");                
		 }    				
	}
    }//fin rellenaFiltroCuestionarioVAPM()
     
    /**
     * 
     * @param rs rs
     * @return listaCuestionariosVAPM
     * @throws Exception Exception
     */
    private ArrayList rellenaVOsCuestionariosVAPM ( ResultSet rs ) throws Exception{
     	Q02aCuestionarioVAPM cuestionarioVAPM;
     	ArrayList listaCuestionariosVAPM = new ArrayList();
     	try{
     		if (tr.isTraceActive()){
 		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOCuestionariosVAPMBD: entrando");                
 		    } 
     		while (rs.next()){	 
 	        	//se cargan en el objeto cuestionario los datos recuperados
     			cuestionarioVAPM = new Q02aCuestionarioVAPM();
     			rellenarVOCuestionarioVAPM(cuestionarioVAPM,rs);
     			listaCuestionariosVAPM.add(cuestionarioVAPM);
   			}  	  
     		return listaCuestionariosVAPM;
     	}catch(Exception ex){    	 	   
  	       java.io.StringWriter sw = new java.io.StringWriter();
  	       java.io.PrintWriter pw = new java.io.PrintWriter(sw);
  	       ex.printStackTrace(pw);
  	       tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenaVOCuestionariosVAPMBD: " + sw.getBuffer ().toString());
  	       throw ex;
  		}finally{			 	
  			if (tr.isTraceActive()){
  		        tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaVOCuestionariosVAPMBD: saliendo");                
  		    }    				
  		}
     }
    
    /**
     * Funcin que modifica los datos del cuestionarioVAPM pasado como parmetro en la BBDD
     * 
     * @param niCuesVAPM niCuesVAPM
     * @param cuestionarioVAPM cuestionarioVAPM
     * 
     * @throws Exception Exception
     */
    public void modificarCuestionarioVAPM(String niCuesVAPM, Q02aCuestionarioVAPM cuestionarioVAPM) throws Exception {

     	if (tr.isTraceActive()){
     	    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVAPM: entrando");
     	}
     	//Se isntancian los objetos necesarios.
     	Q02aTablaBDQ022GS00 Q02aTablaBDQ022GS00obj = null;    
        	 
     	try {     
        	 	//se crea el objeto de tablasBD
       		Q02aTablaBDQ022GS00obj = new Q02aTablaBDQ022GS00(this.getConnection());
       		//segmento tecnico
            		//Q02aTablaBDQ022AS00obj.setUser(this.getUser());
       		 		
       		rellenarDatosCuestionarioVAPM(cuestionarioVAPM,Q02aTablaBDQ022GS00obj);
      		Q02aTablaBDQ022GS00obj.setQ022GT00_ID_CUES_WHERE(Integer.parseInt(niCuesVAPM));      		
      		//se realiza la update
      		Q02aTablaBDQ022GS00obj.update();
      		
        }
        catch(Exception ex)
        {
             java.io.StringWriter sw = new java.io.StringWriter();
             java.io.PrintWriter pw = new java.io.PrintWriter(sw);
             ex.printStackTrace(pw);
             tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVAPM: " + sw.getBuffer ().toString());
             throw ex;
        }
        finally
        {     
        	try
        	{
   		Q02aTablaBDQ022GS00obj.freeResourcesNotConnection();	
   	}
   	catch(Exception ex)
   	{
		   if (tr.isTraceActive())
		   {
			   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVAPM: error liberando recursos");
  	   	   }  
   	}  		  
     	if (tr.isTraceActive())
     	{
     		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVAPM: saliendo");                
                     }             
        }     
    } // fin modificarCuestionarioVAPM
    
    /**
     * Funcin que inserta los datos del cuestionarioVAPM pasada como parmetro en la BBDD
     * 
     * @param cuestionarioVAPM - Datos de la cuestionarioVAPM a insertar
     * @param tablaBDCuestionarioVAPM tablaBDCuestionarioVAPM
     * 
     * @throws Exception Exception
     */
    public void rellenarDatosCuestionarioVAPM(Q02aCuestionarioVAPM cuestionarioVAPM, Q02aTablaBDQ022GS00 tablaBDCuestionarioVAPM) throws Exception {
    	//se definen objetos necesarios.
   	
    	try{
	    	if (tr.isTraceActive()){
	    	    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenaDatosCuestionarioVAPM: entrando");
	    	}         	         
     		//se aaden los datos
	    	
	    	tablaBDCuestionarioVAPM.setQ022GT00_PRV1A(Q02aFormatData.checkStringNull(cuestionarioVAPM.getPrv1a()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_ADQVI1(Q02aFormatData.checkStringNull(cuestionarioVAPM.getAdqvi1()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NADQ1(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNadq1()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_PROVI1(Q02aFormatData.checkStringNull(cuestionarioVAPM.getProvi1()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NPRO1(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNpro1()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_OTRVI1(Q02aFormatData.checkStringNull(cuestionarioVAPM.getOtrvi1()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_OTRLT1(Q02aFormatData.checkStringNull(cuestionarioVAPM.getOtrlt1()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NOTR1(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNotr1()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NTOT1(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNtot1()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_PRV4A(Q02aFormatData.checkStringNull(cuestionarioVAPM.getPrv4a()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_ADQVI4(Q02aFormatData.checkStringNull(cuestionarioVAPM.getAdqvi4()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NADQ4(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNadq4()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_PROVI4(Q02aFormatData.checkStringNull(cuestionarioVAPM.getProvi4()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NPRO4(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNpro4()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_OTRVI4(Q02aFormatData.checkStringNull(cuestionarioVAPM.getOtrvi4()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_OTRLT4(Q02aFormatData.checkStringNull(cuestionarioVAPM.getOtrlt4()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NOTR4(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNotr4()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NTOT4(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNtot4()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_TALQ(Q02aFormatData.checkStringNull(cuestionarioVAPM.getTalq()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NALQ(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNalq()));
	    	
	    	tablaBDCuestionarioVAPM.setQ022GT00_NEXCL(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNexcl()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NEMER(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNemer()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NOTRO(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNotro()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_DESVOTR(Q02aFormatData.checkStringNull(cuestionarioVAPM.getDesvotr()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NPROP(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNprop()));
	    	
	    	tablaBDCuestionarioVAPM.setQ022GT00_NSP45(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNsp45()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NSP75(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNsp75()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NSP90(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNsp90()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NSP90M(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNsp90m()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NSPT(Q02aFormatData.checkDoubleNull(cuestionarioVAPM.getNspt()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NRSP45(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNrsp45()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NRSP75(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNrsp75()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NRSP90(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNrsp90()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NRSP90M(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNrsp90m()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NRSPT(Q02aFormatData.checkDoubleNull(cuestionarioVAPM.getNrspt()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NOCUP(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNocup()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NDESA(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNdesa()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NDESO(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNdeso()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NDESOT(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNdesot()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_DESOTR(Q02aFormatData.checkStringNull(cuestionarioVAPM.getDesotr()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NOCUT(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNocut()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NVPOG(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNvpog()));	    		
	    	tablaBDCuestionarioVAPM.setQ022GT00_NVPOE(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNvpoe()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NVPOT(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNvpot()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NALOD(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNalod()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NREAL(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNreal()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NLIBRE(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNlibre()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NVTMG(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNvtmg()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NVTME(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNvtme()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NVTOT(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNvtot()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NANT60M(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNant60m()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NANT30(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNant30()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NANT10(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNant10()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NANT10M(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNant10m()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_NANTT(Q02aFormatData.checkIntegerNull(cuestionarioVAPM.getNantt()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_OBSAL(Q02aFormatData.checkStringNull(cuestionarioVAPM.getObsal()));
	    	tablaBDCuestionarioVAPM.setQ022GT00_FUERA_PLAZO(Q02aFormatData.checkStringNull(cuestionarioVAPM.getFueraPlazo()));
	    	if ( cuestionarioVAPM.getUsuModif() != null && !"".equals(cuestionarioVAPM.getUsuModif()) ){
                tablaBDCuestionarioVAPM.setQ022GT00_USU_MODIF(Q02aFormatData.checkStringNull( cuestionarioVAPM.getUsuModif()) );
            }

    	}catch(Exception ex){   	   
    		java.io.StringWriter sw = new java.io.StringWriter();
    		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
    		ex.printStackTrace(pw);
    		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":rellenarDatosCuestionarioVAPM: " + sw.getBuffer ().toString());
    		throw ex;
    	}finally{    		
			if (tr.isTraceActive()){
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":rellenarDatosCuestionarioVAPM: saliendo");                
           }       	
    	}	
    }
    
    /**
     * Mtodo que dado el nmero interno del cuestionarioVAPM recuperar de la BBDD
     * los datos de dicho cuestionarioVAPM.
     * @param niCuestionarioVAPM niCuestionarioVAPM
     * @throws Exception Exception
     * @return cuestionarioVAPMBD
     */
    public Q02aCuestionarioVAPM obtenerCuestionarioSeleccionadoVAPM(String niCuestionarioVAPM)throws Exception
    {
  	  if (tr.isTraceActive()){
 		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioSeleccionadoVAPM , ** dao niCuestionarioVAPM= "+  niCuestionarioVAPM + "  ** entrando");            
        	}
  	  
  	  //se crean los objetos necesarios para ralizar la select.
  	  Q02aTablaBDQ022GS00 Q02aTablaBDQ022GS00obj = null;
  	  Q02aCuestionarioVAPM cuestionarioVAPMBD = null;
  	  ResultSet rs = null;   	  
        try{ 
          if (niCuestionarioVAPM!=null){           
          	Q02aTablaBDQ022GS00obj = new Q02aTablaBDQ022GS00(this.getConnection());
          	//se pone el filtro
          	
          	Q02aTablaBDQ022GS00obj.setQ022GT00_ID_CUES_WHERE(new Integer(niCuestionarioVAPM));          	
        
          	rs = Q02aTablaBDQ022GS00obj.select();
          	Q02aTablaBDQ022GS00obj.addResultSet(rs); 
          	cuestionarioVAPMBD = tratarRs(rs);
       
          	
          }  
          return cuestionarioVAPMBD;
          
          }catch(Exception ex){           	   
                 java.io.StringWriter sw = new java.io.StringWriter();
                 java.io.PrintWriter pw = new java.io.PrintWriter(sw);
                 ex.printStackTrace(pw);
                 tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioSeleccionadoVAPM: " + sw.getBuffer ().toString());
                 throw ex;
          }finally{
       	   try{
  	   			 Q02aTablaBDQ022GS00obj.freeResourcesNotConnection();	
  				}catch(Exception ex){
  	   			if (tr.isTraceActive()){
  	   				tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioSeleccionadoVAPM: error liberando recursos");
  	   		   	   }  
  				}  	
           	  if (tr.isTraceActive()){
           		    tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioSeleccionadoVAPM: saliendo");                
                }            	 
          }	  
          
    }//fin obtenerCuestionarioSeleccionadoVAPM

    /**
     * Funcin que borra el cuestionarioVAPM pasado como parmetro de la BBDD
     * 
     * @param niCuestionarioVAPM - nmero interno del cuestionarioVAPM a borrar
     * 
     * @throws Exception Exception
     */
    public void borrarCuestionarioVAPM(String niCuestionarioVAPM) throws Exception {

   	if (tr.isTraceActive())
     	{
 		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVAPM: entrando");
     	}
       	
     	//se crean los objetos necesarios
    	Q02aTablaBDQ022GS00 Q02aTablaBDQ022GS00obj = null;       
         try{       	
        	 //se crea el objeto de tablasBD
        	 Q02aTablaBDQ022GS00obj = new Q02aTablaBDQ022GS00(this.getConnection());
        
        	// segmento tecnico
           //Q02aTablaBDQ022AS00obj.setUser(this.getUser());    	
        	
        	 //se pone el filtro para la delete
        	Q02aTablaBDQ022GS00obj.setQ022GT00_ID_CUES_WHERE(Integer.parseInt(niCuestionarioVAPM));        	
         	
        	//se lanza al delete
         	Q02aTablaBDQ022GS00obj.delete();         	
        }
        catch(Exception ex)
        {
             java.io.StringWriter sw = new java.io.StringWriter();
             java.io.PrintWriter pw = new java.io.PrintWriter(sw);
             ex.printStackTrace(pw);
             tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioVAPM: " + sw.getBuffer ().toString());
             throw ex;
        }finally
        {
        	try	{
        		Q02aTablaBDQ022GS00obj.freeResourcesNotConnection();	
        		}
        	catch(Exception ex)
        		{
        			if (tr.isTraceActive())
        				{
        					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioVAPM: error liberando recursos");
        				}  
        		}  		
        	if (tr.isTraceActive())
        		{
        			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVAPM: saliendo");                
        		}     	   
        }
    }//fin borrarCuestionarioVAPM
    
}
