package q02a.exe.cuestionarioVAPM.beans;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

import javax.ejb.EJBException;
import javax.naming.NamingException;

import q02a.exe.arquitectura.beans.Q02aBaseBean;
import q02a.exe.comun.Q02aUsuarioInformanteDataBaseDAO;
import q02a.exe.comun.dataobjects.Q02aTablasDataBaseDAO;
import q02a.exe.contactos.dataobjects.Q02aContactosDataBaseDAO;
import q02a.exe.contactos.valueobjects.Q02aContactos;
import q02a.exe.cuestionarioVAPM.dataobjects.Q02aCuestionarioVAPMDataBaseDAO;
import q02a.exe.cuestionarioVAPM.valueobjects.Q02aCuestionarioVAPM;
import q02a.exe.cuestionarioVAPM.valueobjects.Q02aCuestionarioVAPMFiltro;
import q02a.exe.informantes.dataobjects.Q02aInformantesDataBaseDAO;
import q02a.exe.informantes.valueobjects.Q02aInformante;
import q02a.exe.utils.Q02aVoUtils;
import es.ejie.frmk.conectores.conectorJDBC.Q70ConectorJDBC;
import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;

/**
 * 
 * @author GADIMAAR
 *
 */   
public class Q02aCuestionarioVAPMBean extends Q02aBaseBean{
	private static final long serialVersionUID = 5474311672836163390L;
	protected Q02aCuestionarioVAPMDataBaseDAO daoCuestionarioVAPM = null;
	protected Q02aTablasDataBaseDAO daoTablas = null;
	final static String	CUESTIONARIO_VAPM = "cuestionarioVAPM";
	//Q70ContextoEJIE q70contextoejie = (Q70ContextoEJIE)request.getSession().getAttribute("contexto");
	//ArrayList listaCues= (ArrayList)q70contextoejie.get("listaCuestionariosSMAnu");
	 /** Constructor vacio */
    public Q02aCuestionarioVAPMBean() {
        super();
    }

    
    /**
     * Funcin que obtiene el campo Prevision Suelo  para el municipio y ano seleccionados
     * 
     * @param codProv codProv
     * @param codMuni  codMuni
     * @param ano ano
     * 
     * @throws Exception Exception
     * @return daoCuestionarioVAPM
     */
    public String obtenerCampoConcedeLicenDeGrupoConMuniAno(String codProv,String codMuni,String ano) throws Exception {   	 
	boolean error = false;
    	
    	try{
    		if (tr.isTraceActive())
    		{
      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoConcedeLicenDeGrupoConMuniAno: entrando");
      		}
	  		//se abre la conexin
			abrirConexion();
			//se instancia el dao pasandole la conexin			
			daoCuestionarioVAPM = new Q02aCuestionarioVAPMDataBaseDAO(this.getConn());
//			se pasan los parmetros de usuario e idioma
			//daoCuestionariosSMAnu.setUser(this.autenticador.getUser());
			//daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());
			//se llamaa la metodo del DAO que realiza la insert
			return daoCuestionarioVAPM.obtenerCampoConcedeLicenDeGrupoConMuniAno(codProv,codMuni,ano);
			
			
    	}catch(Exception ex){
	 		error= true;
	        		java.io.StringWriter sw = new java.io.StringWriter();
	        		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	        		ex.printStackTrace(pw);
	        		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoConcedeLicenDeGrupoConMuniAno: " + sw.getBuffer ().toString());
	        		throw ex;                     
 	  }finally{
 		    try{
 		    	daoCuestionarioVAPM.freeResourcesNotConnection();
 		    }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCampoConcedeLicenDeGrupoConMuniAno: error liberando recursos");
	   	   	   }  
 		    }  		 
 		    //se cierra la conexin  
 		    cerrarConexion(error);	       	
	        
            if (tr.isTraceActive())  {
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCampoConcedeLicenDeGrupoConMuniAno: saliendo.");
	   	  }
 	  }
    }//fin obtenerCampoConcedeLicenDeGrupoConMuniAno
    
    
    /**
     * Funcin que obtiene los  aos para el municipio y ano seleccionados, en los que no se han introducido cuestionarios
     * 
     * @param codProv codProv
     * @param codMuni  codMuni
     * @param ano ano
     * @param idioma idioma
     * @throws Exception Exception
     * @return msgAnos
     */
    public String obtenerAnosPendientes(String codProv,String codMuni,String ano,String idioma) throws Exception {   	 
	boolean error = false;
    	String msgAnos = null;
    	
    	try{
    		if (tr.isTraceActive()){
      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientes: entrando");
      		}
	  		//se abre la conexin
			abrirConexion();
			//se instancia el dao pasandole la conexin			
			daoCuestionarioVAPM = new Q02aCuestionarioVAPMDataBaseDAO(this.getConn());
//			se pasan los parmetros de usuario e idioma
			//daoCuestionariosSMAnu.setUser(this.autenticador.getUser());
			//daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());
			//se llamaa la metodo del DAO que realiza la insert
			msgAnos =daoCuestionarioVAPM.obtenerAnosPendientesParaMuni(codProv,codMuni,ano,idioma);
			return msgAnos;
			
    	}catch(Exception ex){
	 		error= true;
	        		java.io.StringWriter sw = new java.io.StringWriter();
	        		java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	        		ex.printStackTrace(pw);
	        		tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAnosPendientes: " + sw.getBuffer ().toString());
	        		throw ex;                     
 	  }finally{
 		    try{
 		    	daoCuestionarioVAPM.freeResourcesNotConnection();
 		    }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerAnosPendientes: error liberando recursos");
	   	   	   }  
 		    }  		 
 		    //se cierra la conexin  
 		    cerrarConexion(error);	       	
	        	   if (tr.isTraceActive())
	        	   {
	   		tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerAnosPendientes: saliendo.");
	   	  }
 	  }
    }//fin obtenerAnosPendientes
    
    
    
    /**
     * Funcin que inserta/modifica los datos del grupo de cuestionarios de Suelo Municipal a partir de los Datos Contenidos en el filtro
     * 
     * @param niCuesVAPM niCuesVAPM
     * @param cuesVAPMFiltro cuesVAPMFiltro
     * @throws Exception Exception
     * @return cuestionarioVAPM
     */
    public Q02aCuestionarioVAPM altaModifCuestionarioVAPM(String niCuesVAPM,Q02aCuestionarioVAPMFiltro cuesVAPMFiltro ) throws Exception {   	 
    	//se crean objetos necesarios.
    	
    	Q02aCuestionarioVAPM cuestionarioVAPM= new Q02aCuestionarioVAPM();
    	
    	boolean error = false;
    	try{
    		if (tr.isTraceActive()){
      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifCuestionarioVAPM: entrando");
      		}
	  		//se abre la conexin
			abrirConexion();
			//se instancia el dao pasandole la conexin			
			daoCuestionarioVAPM = new Q02aCuestionarioVAPMDataBaseDAO(this.getConn());
			
			//se pasan los parmetros de usuario e idioma
			//daoCuestionariosSMAnu.setUser(this.autenticador.getUser());
			//daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());
			//se llamaa la metodo del DAO que realiza la insert
			cuestionarioVAPM =daoCuestionarioVAPM.altaModifCuestionarioVAPM(niCuesVAPM,cuesVAPMFiltro);
			return cuestionarioVAPM;
			
    	}catch(Exception ex){
	 		error= true;
	        java.io.StringWriter sw = new java.io.StringWriter();
	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	        ex.printStackTrace(pw);
	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifCuestionarioVAPM: " + sw.getBuffer ().toString());
	        throw ex;                     
 	  }finally{
 		    try{
 		    	daoCuestionarioVAPM.freeResourcesNotConnection();
 		    }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifCuestionarioVAPM: error liberando recursos");
	   	   	   }  
 		    }  		 
 		  	//se cierra la conexin  
 		    cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifCuestionarioVAPM: saliendo.");
	   		}
 	  }
    }//fin altaModifCuestionarioVAPM
    
    /**
     * Funcin que modifica los datos del cuestionario pasado como parmetro en la BBDD
     * 
     * @param cuestionarioVAPM - Datos del cuestionario a modificar
     * @param ano ano
     * @param codMunicip codMunicip
     * @param concedeLicen concedeLicen
     * @param codProv codProv
     * @param niCuesVAPM niCuesVAPM
     * 
     * @throws Exception Exception
     */
   public void modificarCuestionarioVAPM(Q02aCuestionarioVAPM cuestionarioVAPM, String ano, String codMunicip, String concedeLicen, String codProv, String niCuesVAPM) throws Exception {
   	 if (tr.isTraceActive()){
  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVAPM: entrando");
  		}
   	 boolean error = false;
   	try{
   		//se abre la conexin
   		abrirConexion();
   		//se instancia el dao pasandole la conexin			
   		daoCuestionarioVAPM = new Q02aCuestionarioVAPMDataBaseDAO(this.getConn());
			// Segmento tecnico 
			//daoCuestionariosSMAnu.setUser(this.getAutenticador().getUser());
			//daoCuestionariosSMAnu.setIdioma(this.getAutenticador().getIdioma()); 

   		//se llamaa la metodo del DAO que realiza la update
   		daoCuestionarioVAPM.modificarCuestionarioVAPM(cuestionarioVAPM, ano, codMunicip, concedeLicen, codProv, niCuesVAPM);
   	}catch(Exception ex){
		  error= true;
         java.io.StringWriter sw = new java.io.StringWriter();
         java.io.PrintWriter pw = new java.io.PrintWriter(sw);
         ex.printStackTrace(pw);
         tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVAPM: " + sw.getBuffer ().toString());
         throw ex;                     
	  }finally{
		 try{
			daoCuestionarioVAPM.freeResourcesNotConnection();
		   }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVAPM: error liberando recursos");
	   	   	   }  
		   }  		 
		  	//se cierra la conexin  
		  	cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVAPM: saliendo.");
	   		}
	  }
   }
   
   /**
    * Funcin que devuelve el niCuesVAPM a partir de los datos  en el filtro
    * 
    * @param cuesVAPMFiltro cuesVAPMFiltro
    * 
    * @throws Exception Exception
    * @return niCuesVAPM
    */
   public String obtenerNiCuesVAPM(Q02aCuestionarioVAPMFiltro cuesVAPMFiltro) throws Exception {   	 
   	//se crean objetos necesarios.
   	//Q02aCuestionarioSMAnuFiltro grupoCuestionarioSMAnuConNi = null;
   	String niCuesVAPM= null;
   	
   	boolean error = false;
   	try{
   		    if (tr.isTraceActive()){
     			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNiCuesVAPM: entrando");
     		}
	  		//se abre la conexin
			abrirConexion();
			//se instancia el dao pasandole la conexin			
			daoCuestionarioVAPM = new Q02aCuestionarioVAPMDataBaseDAO(this.getConn());
			//se pasan los parmetros de usuario e idioma
			//daoCuestionariosSMAnu.setUser(this.autenticador.getUser());
			//daoCuestionariosSMAnu.setIdioma(this.autenticador.getIdioma());
			//se llamaa la metodo del DAO que realiza la insert
			niCuesVAPM =daoCuestionarioVAPM.obtenerNiCuesVAPM(cuesVAPMFiltro);
			return niCuesVAPM;
			
   	}catch(Exception ex){
	 		error= true;
	        java.io.StringWriter sw = new java.io.StringWriter();
	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	        ex.printStackTrace(pw);
	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerNiCuesVAPM: " + sw.getBuffer ().toString());
	        throw ex;                     
	  }finally{
		    try{
		    	daoCuestionarioVAPM.freeResourcesNotConnection();
		    }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerNiCuesVAPM: error liberando recursos");
	   	   	   }  
		    }  		 
		  	//se cierra la conexin  
		    cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerNiCuesVAPM: saliendo.");
	   		}
	  }
   }//fin obtenerNiCuesVAPM
   
  /** Funcin que inserta/modifica los datos del grupo de cuestionarios de Ayuntamientos Mensual a partir de los Datos Contenidos en el filtro
   * 
   * @param cuesVAPMFiltro - Datos del grupo de cuestionarios a insertar
   * 
   * @throws Exception Exception
   * @return niCuesVAPM
   */

  public String altaModifGrupoCuestionariosVAPM(Q02aCuestionarioVAPMFiltro cuesVAPMFiltro) throws Exception {   	 
  	//se crean objetos necesarios.
  	//Q02aCuestionarioVTMAnuFiltro grupoCuestionarioVTMAnuConNi = null;
  	String niCuesVAPM = null;
  	boolean error = false;
  	try{
  		if (tr.isTraceActive()){
    			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVAPM: entrando");
    		}
	  		//se abre la conexin
			abrirConexion();
			//se instancia el dao pasandole la conexin			
			daoCuestionarioVAPM = new Q02aCuestionarioVAPMDataBaseDAO(this.getConn());
//			se pasan los parmetros de usuario e idioma
			//daoCuestionariosVTMAnu.setUser(this.autenticador.getUser());
			//daoCuestionariosVTMAnu.setIdioma(this.autenticador.getIdioma());
            
			//se llamaa la metodo del DAO que realiza la insert
			niCuesVAPM =daoCuestionarioVAPM.altaModifGrupoCuestionariosVAPM(cuesVAPMFiltro);
			return niCuesVAPM;
			
  	}catch(Exception ex){
	 		error= true;
	        java.io.StringWriter sw = new java.io.StringWriter();
	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	        ex.printStackTrace(pw);
	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosVAPM: " + sw.getBuffer ().toString());
	        throw ex;                     
	  }finally{
		    try{
		    	daoCuestionarioVAPM.freeResourcesNotConnection();
		    }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":altaModifGrupoCuestionariosVAPM: error liberando recursos");
	   	   	   }  
		    }  		 
		  	//se cierra la conexin  
		    cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":altaModifGrupoCuestionariosVAPM: saliendo.");
	   		}
	  }
  }//fin altaModifGrupoCuestionariosVAPM
   
  /**
   * Funcin que recupera el nmero de cuestionarios de SM 
   * 
   * @param territorio territorio
   * @param municipio municipio
   * @param anyoReferencia anyoReferencia
   * @param mesReferencia mesReferencia
   * 
   * @throws Exception Exception
   * @return numCuestionariosVA
   */
    public int getNumCuestionariosPortada(String territorio, String municipio, String anyoReferencia,String mesReferencia) throws Exception {   	 
  	//se crean objetos necesarios.
  	int numCuestionariosVA=0;	        	         
  	boolean error = false;
  	
  	try{
  		 
  		if (tr.isTraceActive()){
    			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortada: entrando");
    		}
	  		//se abre la conexin
			abrirConexion();
			//se instancia el dao pasandole la conexin			
			daoCuestionarioVAPM = new Q02aCuestionarioVAPMDataBaseDAO(this.getConn());
			
			numCuestionariosVA = daoCuestionarioVAPM.getNumCuestionariosVA(territorio, municipio, anyoReferencia, mesReferencia);
			    			   			
			return numCuestionariosVA;
  	}catch(Exception ex){
	 		error= true;
	        java.io.StringWriter sw = new java.io.StringWriter();
	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	        ex.printStackTrace(pw);
	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: " + sw.getBuffer ().toString());
	        throw ex;                     
	  }finally{
		    try{
		    	daoCuestionarioVAPM.freeResourcesNotConnection();
		    }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNumCuestionariosPortada: error liberando recursos");
	   	   	   }  
		    }  		 
		  	//se cierra la conexin  
		    cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNumCuestionariosPortada: saliendo.");
	   		}
	  }
  }//fin getNumCuestionariosPortada 
  
    /**
     * Funcin que recupera las observacionesVA 
     * 
     * @param territorio territorio
     * @param municipio municipio
     * @param anyoReferencia anyoReferencia
     * @param mesReferencia mesReferencia
     * 
     * @throws Exception Exception
     * @return numCuestionariosVA
     */
      public Q02aCuestionarioVAPM getObservacionesPortadaVA(String territorio, String municipio, String anyoReferencia,String mesReferencia) throws Exception {      
        
        boolean error = false;
        Q02aCuestionarioVAPM miQ02aCuestionarioVAPM = new Q02aCuestionarioVAPM();
        
        try{
             
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getObservacionesPortadaVA: entrando");
            }
            //se abre la conexin
            abrirConexion();
            //se instancia el dao pasandole la conexin         
            daoCuestionarioVAPM = new Q02aCuestionarioVAPMDataBaseDAO(this.getConn());
            
            miQ02aCuestionarioVAPM = daoCuestionarioVAPM.getObservacionesVAPM(territorio, municipio, anyoReferencia, mesReferencia);
                                        
            return miQ02aCuestionarioVAPM;
        }catch(Exception ex){
            error= true;
            java.io.StringWriter sw = new java.io.StringWriter();
            java.io.PrintWriter pw = new java.io.PrintWriter(sw);
            ex.printStackTrace(pw);
            tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getObservacionesPortadaVA: " + sw.getBuffer ().toString());
            throw ex;                     
      }finally{
            try{
                daoCuestionarioVAPM.freeResourcesNotConnection();
            }catch(Exception ex){
               if (tr.isTraceActive()){
                   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getObservacionesPortadaVA: error liberando recursos");
               }  
            }        
            //se cierra la conexin  
            cerrarConexion(error);          
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getObservacionesPortadaVA: saliendo.");
            }
      }
    }//fin getObservacionesPortadaVA 
    
    /**
     * 
     * @param territorio territorio
     * @param municipio municipio
     * @param anyoReferencia anyoReferencia
     * @param mesReferencia mesReferencia
     * @return concedidoLicenVAPM
     * @throws Exception Exception
     */
    public String getConcedidoLicenGrupoCuesVAPM(String territorio, String municipio, String anyoReferencia,String mesReferencia) throws Exception {   	 
    	//se crean objetos necesarios.
    	String concedidoLicenVAPM="";	        	         
    	boolean error = false;
    	
    	try{
    		 
    		if (tr.isTraceActive()){
      			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getConcedidoLicenGrupoCuesVAPM: entrando");
      		}
	  		//se abre la conexin
			abrirConexion();
			//se instancia el dao pasandole la conexin			
			daoCuestionarioVAPM = new Q02aCuestionarioVAPMDataBaseDAO(this.getConn());
			
			concedidoLicenVAPM = daoCuestionarioVAPM.getConcedidoLicenGrupoCuesVAPM(territorio, municipio, anyoReferencia, mesReferencia);
			    			   			
			return concedidoLicenVAPM;
    	}catch(Exception ex){
	 		error= true;
	        java.io.StringWriter sw = new java.io.StringWriter();
	        java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	        ex.printStackTrace(pw);
	        tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getConcedidoLicenGrupoCuesVAPM: " + sw.getBuffer ().toString());
	        throw ex;                     
 	  }finally{
 		    try{
 		    	daoCuestionarioVAPM.freeResourcesNotConnection();
 		    }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getConcedidoLicenGrupoCuesVAPM: error liberando recursos");
	   	   	   }  
 		    }  		 
 		  	//se cierra la conexin  
 		    cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getConcedidoLicenGrupoCuesVAPM: saliendo.");
	   		}
 	  }
    } 
    
    /**
     * Funcin que recupera los cuestionarios de vivienda en alquiler con los datos introducidos en el filtro (pgina de portada)
     * 
     * @param mapaFiltroPortadaCuestionarioVAPM - Datos de los cuestionarios a consultar
     * @return listaCuestionariosVAPM  -  Listado de cuestionarios obtenidos
     * @throws Exception Exception
     */
	public ArrayList getCuestionariosVAPM(HashMap mapaFiltroPortadaCuestionarioVAPM) throws Exception 
	{
		 if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCuestionariosVAPM: entrando.");
	   		}  	  
		String idCues = null;		
		String noRegRecuperados = "NoHayCuestionariosVAPM";
		ArrayList listaCuestionariosVAPM = new ArrayList();
		Q02aCuestionarioVAPMFiltro cuestionarioVAPMFiltroPortada = null;
		boolean error = false;
		
		try{
			cuestionarioVAPMFiltroPortada = (Q02aCuestionarioVAPMFiltro) Q02aVoUtils.getValueObject(mapaFiltroPortadaCuestionarioVAPM,"q02a.exe.cuestionarioVAPM.valueobjects.Q02aCuestionarioVAPMFiltro");
			//cuestionarioVAPMFiltroPortada.setConcedidoLicen("1");
			//se abre la conexin
			abrirConexion();
			//se instancia el dao pasandole la conexin			
			daoCuestionarioVAPM = new Q02aCuestionarioVAPMDataBaseDAO(this.getConn());
			//se llamamara al dao para obtener el nmero de cuestionarios
			idCues = daoCuestionarioVAPM.obtenerIdGrupoCuestionariosVAPM(cuestionarioVAPMFiltroPortada);
			if(idCues!=null && !idCues.equals("")){
				listaCuestionariosVAPM = daoCuestionarioVAPM.getSelectCuestionariosVAPM(idCues);
            }            
            return listaCuestionariosVAPM;              
	  } catch(Exception ex){
 		  error= true;
          java.io.StringWriter sw = new java.io.StringWriter();
          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
          ex.printStackTrace(pw);
          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCuestionariosVAPM: " + sw.getBuffer ().toString());
          throw ex;                     
 	  }finally{
 		 try{
 			daoCuestionarioVAPM.freeResourcesNotConnection();
		   }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getCuestionariosVAPM: error liberando recursos");
	   	   	   }  
		   }  		 
 		  	//se cierra la conexin  
 		  	cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCuestionariosVAPM: saliendo.");
	   		}
 	  	}
 	  } //fin getCuestionariosVAPM 
	
    /**
     * 
     * @param cuestionariosVAPMFiltro cuestionariosVAPMFiltro
     * @return listaCuestionariosVTM
     * @throws Exception Exception
     */
    public ArrayList getCuestionariosSinGrabarVAPM(Q02aCuestionarioVAPMFiltro cuestionariosVAPMFiltro) throws Exception {
        if (tr.isTraceActive()){
               tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCuestionariosSinGrabarVAPM: entrando.");
        }    
        
        int anyo=2010;
//      Saco el ao --> solo se hace en enero este cuestionario--> la bd no tiene campo mes
        
        if ( cuestionariosVAPMFiltro.getAno() != null ){
            anyo = Integer.parseInt( cuestionariosVAPMFiltro.getAno().toString() );
        }
        ////////////////////////////--  SQL -- ///////////////////////////////////////
        final StringBuffer sql = new StringBuffer();
                sql.append("select * from Q022GT00 ");
        final StringBuffer where = new StringBuffer();
                where.append(" where Q022GT00_MUN_PROV =").append( cuestionariosVAPMFiltro.getCodProv() ).append(
                        " and Q022GT00_MUN_MUNI = ").append( cuestionariosVAPMFiltro.getCodMuni()).append( 
                        " and Q022GT00_ANO =").append( anyo );
                                
        final StringBuffer order = new StringBuffer();
                order.append(" order by Q022GT00_ANO");

        ////////// FIN SQL ////////////////////////////////////////
        sql.append(where).append(order);
        
       ArrayList listaCuestionariosVTM = new ArrayList();
       boolean error = false;
       
       try{
           final Connection connection = Q70ConectorJDBC.getSingleton().getConnection(Q02_JNDI_DATASOURCE);
           try{
                   PreparedStatement ps = connection.prepareStatement(sql.toString()); 
                       try {
                           int i = 0;
                           ps.execute();
                           ResultSet rs = ps.getResultSet();
                           HashMap mesesHashMap;
                           
                               try {
                                       while (rs.next()){
                                           mesesHashMap = this.obtenerHashMap();
                                           mesesHashMap.put("mes", new Long ( 1 ).toString() );//Solo se graba en enero
                                           mesesHashMap.put("ano", new Long ( rs.getLong("Q022GT00_ANO") ).toString() );
                                           listaCuestionariosVTM.add(mesesHashMap);
                                           i++;
                                       }
                               } finally {
                                   try { rs.close(); } catch (SQLException e) { }
                               }
                           
                       } finally {
                           try { ps.close(); } catch (SQLException e) { }
                       }
           }finally {
               try { connection.close(); } catch (SQLException sqle) {}
           }
           
           return listaCuestionariosVTM;              
     
     }catch (SQLException e) {
         if (tr.isTraceActive()){
             tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCuestionariosSinGrabarVAPM: saliendo.");
         }
         throw new EJBException("getCuestionariosSinGrabarVAPM",e);
     } catch (NamingException e) {
         if (tr.isTraceActive()){
             tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getCuestionariosSinGrabarVAPM: saliendo.");
         }
         throw new EJBException("getCuestionariosSinGrabarVAPM",e);
     }
     
     } //fin getCuestionariosSinGrabarVAPM 
    
    
    
	/**
     * Funcin que modifica los datos del cuestionario pasado como parmetro en la BBDD
     * 
     * @param cuestionarioVAPM - Datos del cuestionario a modificar
     * 
     * @throws Exception
     */
   public void modificarCuestionarioVAPM(String niCuesVAPM, Q02aCuestionarioVAPM cuestionarioVAPM) throws Exception {
   	 if (tr.isTraceActive()){
  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVAPM: entrando");
  		}
   	 boolean error = false;
   	try{
   		//se abre la conexin
   		abrirConexion();
   		//se instancia el dao pasandole la conexin			
   		daoCuestionarioVAPM = new Q02aCuestionarioVAPMDataBaseDAO(this.getConn());
			// Segmento tecnico 
		daoCuestionarioVAPM.setUser(this.getAutenticador().getUser());
		daoCuestionarioVAPM.setIdioma(this.getAutenticador().getIdioma()); 

   		//se llamaa la metodo del DAO que realiza la update
   		daoCuestionarioVAPM.modificarCuestionarioVAPM(niCuesVAPM, cuestionarioVAPM);
   	}catch(Exception ex){
		  error= true;
         java.io.StringWriter sw = new java.io.StringWriter();
         java.io.PrintWriter pw = new java.io.PrintWriter(sw);
         ex.printStackTrace(pw);
         tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVAPM: " + sw.getBuffer ().toString());
         throw ex;                     
	  }finally{
		 try{
			daoCuestionarioVAPM.freeResourcesNotConnection();
		   }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":modificarCuestionarioVAPM: error liberando recursos");
	   	   	   }  
		   }  		 
		  	//se cierra la conexin  
		  	cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":modificarCuestionarioVAPM: saliendo.");
	   		}
	  }
   }

   /**
    * Mtodo que dado el nmero interno del cuestionario recuperar de la BBDD
    * los datos de dicho cuestionario.
    * @param niCuestionarioVAPM
    * @return
    */
	public Q02aCuestionarioVAPM obtenerCuestionarioSeleccionadoVAPM(String niCuestionarioVAPM)throws Exception{  	 
	    	boolean error = false;
	    	Q02aCuestionarioVAPM cuestionarioVAPM = null;
	  	  	try  	  {
	  	  		if (tr.isTraceActive()){
	  	  			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioSeleccionadoVAPM, ** niCuestionarioVAPM bean=" + niCuestionarioVAPM + " *** entrando");                
	  	  		}
	  	  		//se abre la conexin
	  	  		abrirConexion();
	  	  		//se instancia el dao pasandole la conexin			
	  	  		daoCuestionarioVAPM = new Q02aCuestionarioVAPMDataBaseDAO(this.getConn());
	  	  		//Segmento tecnico 
	  			daoCuestionarioVAPM.setUser(this.getAutenticador().getUser());
	  			daoCuestionarioVAPM.setIdioma(this.getAutenticador().getIdioma()); 
	  	  		//se llama al mtodo del dao recupera el cuestionario
	  	  		cuestionarioVAPM = daoCuestionarioVAPM.obtenerCuestionarioSeleccionadoVAPM(niCuestionarioVAPM);
	  	  		//se devuelve el cuestionario recuperado
	  	  		return cuestionarioVAPM;
	  	  }catch(Exception ex){
	  		  	error= true;
	  		  	java.io.StringWriter sw = new java.io.StringWriter();
	          	java.io.PrintWriter pw = new java.io.PrintWriter(sw);
	          	ex.printStackTrace(pw);
	          	tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioVAPM: " + sw.getBuffer ().toString());
	          	throw ex;                     
	 	  }finally{
	 		  	try{
	 		  		daoCuestionarioVAPM.freeResourcesNotConnection();
	 		  	}catch(Exception ex){
				   if (tr.isTraceActive()){
					   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":obtenerCuestionarioVAPM: error liberando recursos");
		   	   	   }  
	 		  	}  		 
	 		  	//se cierra la conexin  
	 		  	cerrarConexion(error);	       	
		        if (tr.isTraceActive()){
		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":obtenerCuestionarioVAPM: saliendo.");
		   		}
	 	  }
	    }//fin obtenerCuestionarioVAPM
	
	/**
     * Funcin que borra el cuestionario pasado como parmetro de la BBDD
     * 
     * @param niCuestionarioVAPM - nmero interno del cuestionario a borrar
     * 
     * @throws Exception
     */
  public void borrarCuestionarioVAPM(String niCuestionarioVAPM) throws Exception {
         
    	if (tr.isTraceActive()){
			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVAPM: entrando");
		}
    	 boolean error = false;
    	 try{
    		 //se abre la conexin
   			abrirConexion();
   			//se instancia el dao pasandole la conexin			
   			daoCuestionarioVAPM = new Q02aCuestionarioVAPMDataBaseDAO(this.getConn());
			// Segmento tecnico 
   			daoCuestionarioVAPM.setUser(this.getAutenticador().getUser());
   			daoCuestionarioVAPM.setIdioma(this.getAutenticador().getIdioma()); 

   			//se comprueba el numero de cuestionarios que tiene el grupo de cuestionarios
   			daoCuestionarioVAPM.borrarCuestionarioVAPM(niCuestionarioVAPM);
   			
    	 }catch(Exception ex){
		  error= true;
          java.io.StringWriter sw = new java.io.StringWriter();
          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
          ex.printStackTrace(pw);
          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioVAPM: " + sw.getBuffer ().toString());
          throw ex;                     
 	  }finally{
 		 try{
 			daoCuestionarioVAPM.freeResourcesNotConnection();
		   }catch(Exception ex){
			   if (tr.isTraceActive()){
				   tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":borrarCuestionarioVAPM: error liberando recursos");
	   	   	   }  
		   }  		 
 		  	//se cierra la conexin  
 		  	cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":borrarCuestionarioVAPM: saliendo.");
	   		}
 	  }
    }//fin borrarCuestionarioVAPM
  
  /**
   * Funcin que borra todos los cuestionarios que hay en un mes
   * en este caso solo uno (por ahora) pasado como parmetro de la BBDD
   * 
   * @param niCuestionarioVAPM - datos para el borrado
   * 
   * @throws Exception
   */
      public void resetearCuestionarioVAPM(HashMap mapaFiltroPortadaCuestionarioVAPM) throws Exception {
       
          if (tr.isTraceActive()){
              tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":resetearCuestionarioVAPM: entrando.");
           }    
           
          try{
              Q02aCuestionarioVAPMFiltro miCuestionarioVAPMFiltro = (Q02aCuestionarioVAPMFiltro) Q02aVoUtils.getValueObject(mapaFiltroPortadaCuestionarioVAPM,"q02a.exe.cuestionarioVAPM.valueobjects.Q02aCuestionarioVAPMFiltro");
            
              int anyo=2010;
              // Saco el ao --> solo se hace en enero este cuestionario --> la bd no tiene campo mes
           
               if ( miCuestionarioVAPMFiltro.getAno() != null ){
                   anyo = Integer.parseInt( miCuestionarioVAPMFiltro.getAno().toString() );
               }
               ////////////////////////////--  SQL -- ///////////////////////////////////////
               final StringBuffer sql = new StringBuffer();
                       
                       sql.append("DELETE from Q022GS00 ");
                       sql.append( " where Q022GT00_ANO =").append( anyo );
                       
                       if ( miCuestionarioVAPMFiltro.getCodProv() != null){
                           sql.append(" and Q022GT00_MUN_PROV =").append( miCuestionarioVAPMFiltro.getCodProv() );
                       }
                       if ( miCuestionarioVAPMFiltro.getCodProv() != null){
                           sql.append( " and Q022GT00_MUN_MUNI = ").append( miCuestionarioVAPMFiltro.getCodMuni() );
                       }
                       
        
               ////////// FIN SQL ////////////////////////////////////////
          
              final Connection connection = Q70ConectorJDBC.getSingleton().getConnection(Q02_JNDI_DATASOURCE);
              try{
                      PreparedStatement ps = connection.prepareStatement(sql.toString()); 
                      ps.execute();
              }finally {
                  try { connection.close(); } catch (SQLException sqle) {}
              }
                        
    
        }catch (SQLException e) {
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":resetearCuestionarioVAPM: saliendo.");
            }
            throw new EJBException("resetearCuestionarioVAPM",e);
        } catch (NamingException e) {
            if (tr.isTraceActive()){
                tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":resetearCuestionarioVAPM: saliendo.");
            }
            throw new EJBException("resetearCuestionarioVAPM",e);
        }
  }//fin resetearCuestionarioVAPM
 
  	public void insertarContactoVAPM(String anyo) throws Exception{
    	if (tr.isTraceActive()){
			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarContactoVAPM: entrando");
		}
    	 boolean error = false;
    	 try{
    		 //se abre la conexin
   			abrirConexion();
  			
   			//se obtiene el dni del usuario	
   			Q02aUsuarioInformanteDataBaseDAO daoUsuarioInformante = new Q02aUsuarioInformanteDataBaseDAO(this.getConn());
   			daoUsuarioInformante.setUser(this.getAutenticador().getUser());
   			String niUsuario = daoUsuarioInformante.getUser();
   			String niInformante = daoUsuarioInformante.obtenerNiInformante(niUsuario);
   			   			
   			if (niInformante!=""){
   				//obtener los datos del informante
   				Q02aInformantesDataBaseDAO daoInformante = new Q02aInformantesDataBaseDAO(this.getConn());
   				Q02aInformante informante = new Q02aInformante();
   				informante = daoInformante.getInformante(niInformante);
   				
   				//insertar el contacto
   				Q02aContactos contacto = new Q02aContactos();
   				Q02aContactosDataBaseDAO daoContactos = new Q02aContactosDataBaseDAO(this.getConn());
   				contacto.setCodProvincia(informante.getDescProvincia());
   				contacto.setCodMunicipio(informante.getDescMunicipio());
   				contacto.setIdInformante(informante.getIdInformante());
   				contacto.setIdOficina(informante.getIdOficina());
   				String codigoOnline =Q70ListenerUtils.getApplicationProperty("COD_TIPO_CONTACTO_ONLINE");
   				String codigoTabla = Q70ListenerUtils.getApplicationProperty("COD_TABLA_TIPO_CONTACTO");
   				//se instancia el dao pasandole la conexin			
   				daoTablas = new Q02aTablasDataBaseDAO(this.getConn());
   				String niOnline = daoTablas.getNiCuestionarioOnline(codigoOnline, codigoTabla);
   				contacto.setTipoContacto(niOnline);//Cuestionario On-line
   				contacto.setFechaProxContacto("");
   				contacto.setObservaciones("Informante "+informante.getNombre()+ " " + informante.getApellido1() + " " + informante.getApellido2() 
   						+" ha grabado el cuestionario de Estadstica de Vivienda en Alquiler de Propiedad Municipal" );
   				int idContacto = daoContactos.insertarContactoCuestionario(contacto);
   				if (tr.isTraceActive()){
   		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarContactoVAPM: contacto dado de alta --> idInformante=" 
   		   					+ niInformante + " niUsuario= " + niUsuario + "idContacto= " + idContacto);
   		   		}
   			}
   			else {
   				if (tr.isTraceActive()){
   		   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarContactoVAPM: contacto NO dado de alta --> idInformante " +
   		   					"no existe para el niUsuario= " + niUsuario);
   		   		}
   			}
   		 	
    	 }catch(Exception ex){
		  error= true;
          java.io.StringWriter sw = new java.io.StringWriter();
          java.io.PrintWriter pw = new java.io.PrintWriter(sw);
          ex.printStackTrace(pw);
          tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":insertarContactoVAPM: " + sw.getBuffer ().toString());
          throw ex;                     
 	  }finally{		 
 		  	//se cierra la conexin  
 		  	cerrarConexion(error);	       	
	        if (tr.isTraceActive()){
	   			tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":insertarContactoVAPM: saliendo.");
	   		}
 	  }
  	}//fin insertarContactoVAPM

    /** Mtodo que obtiene el hashmap.
     * @return hashMap HashMap
     */
    private HashMap obtenerHashMap() {
        return new HashMap();
    }
}