package q02a.exe.contactos.dataobjects;



import java.sql.Connection;

import java.sql.PreparedStatement;

import java.sql.ResultSet;



import q02a.exe.arquitectura.dataobjects.Q02aDataBaseDAO;

import q02a.exe.contactos.valueobjects.Q02aContactos;

import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022KS00;

import q02a.exe.utils.Q02aFormatData;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import es.ejie.frmk.infraestructura.traza.Q70Traza;


/**
 * 
 * @author GADIMAAR
 *
 */
public class Q02aContactosDataBaseDAO extends Q02aDataBaseDAO {

	private static final long serialVersionUID = -8520551641771839103L;

	private static Q70Traza tr = Q70Traza.getSingleton();

	private static final String COMPONENTE = "DAO_ACCESO_DATOS";


/**
 * 
 *
 */
	public Q02aContactosDataBaseDAO() {

		super();

	}


/**
 * 
 * @param conn conn
 */
	public Q02aContactosDataBaseDAO(Connection conn) {

		super(conn);

	}


/**
 * 
 * @param tablaContactos tablaContactos
 * @return idContactos
 * @throws Exception Exception
 */
	private int dameSeqNiContactos(Q02aTablaBDQ022KS00 tablaContactos) throws Exception {

		int idContactos = 1;

		ResultSet rs = null;

		PreparedStatement prepStmt = null;

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":dameSeqNiContactos: entrando");

			}

			StringBuffer query = new StringBuffer(" SELECT Q022KQ00.NEXTVAL FROM DUAL ");

			prepStmt = this.getConnection().prepareStatement(query.toString());

			rs = prepStmt.executeQuery();

			tablaContactos.addResultSet(rs);

			tablaContactos.addStatement(prepStmt);

			if (rs.next()) {

				idContactos = rs.getInt(1);

			}

			return idContactos;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":dameSeqNiContactos: " + sw.getBuffer().toString());

			throw ex;

		}

	}// dameSegNiContactos


/**
 * 
 * @param contacto contacto
 * @param tablaContactos tablaContactos
 * @throws Exception Exception
 */
	public void rellenaDatosContactos(Q02aContactos contacto, Q02aTablaBDQ022KS00 tablaContactos) throws Exception {

		// se definen objetos necesarios.

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()	+ ":rellenaDatosContactos: entrando");

			}

			// se aaden los datos

			tablaContactos.setQ022KT00_ID_CONT(Q02aFormatData.checkIntegerNull(contacto.getIdContacto()));

			tablaContactos.setQ022KT00_PROV(Q02aFormatData.checkStringNull(contacto.getCodProvincia()));

			tablaContactos.setQ022KT00_MUNI(Q02aFormatData.checkStringNull(contacto.getCodMunicipio()));

			tablaContactos.setQ022HT00_ID_OFI(Q02aFormatData.checkIntegerNull(contacto.getIdOficina()));

			tablaContactos.setQ022KT00_FECC(new java.util.Date(System.currentTimeMillis()));

			tablaContactos.setQ022KT00_FECR(Q02aFormatData.parseDate(contacto.getFechaProxContacto()));

			tablaContactos.setQ022KT00_ID_AGEN(Q02aFormatData.checkIntegerNull(contacto.getIdAgente()));

			tablaContactos.setQ022KT00_ID_INF(Q02aFormatData.checkIntegerNull(contacto.getIdInformante()));

			tablaContactos.setQ022KT00_OBSHR(Q02aFormatData.checkStringNull(contacto.getObservaciones()));

			tablaContactos.setQ022KT00_RCON(Q02aFormatData.checkStringNull(contacto.getRazonContacto()));

			tablaContactos.setQ022YT00_NI_TIPO_CON(Q02aFormatData.checkLongNull(contacto.getTipoContacto()));

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":rellenaDatosContactos: "+ sw.getBuffer().toString());

			throw ex;

		} finally {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":rellenaDatosContactos: saliendo = "+ tablaContactos.getQ022KT00_ID_CONT());

			}

		}

	}// rellenaDatosContactos



	/**

	 * Funcin que inserta los datos del contacto pasado como parmetro en la BBDD

	 * @param contacto - Datos del contacto a insertar

	 * @throws Exception Exception
    * @return idContactos
	 */

	public int insertarContactoCuestionario(Q02aContactos contacto) throws Exception {

		int idContactos = 0;

		Q02aTablaBDQ022KS00 tablaContactos = null;

		try {

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":insertarContactos: entrando");

			}

			// se crea el objeto de tablasBD

			tablaContactos = new Q02aTablaBDQ022KS00(this.getConnection());

			// primero recuperamos el nmero interno que le corresponde

			idContactos = dameSeqNiContactos(tablaContactos);

			contacto.setIdContacto(Integer.toString(idContactos));

			// se aaden los datos a insertar

			this.rellenaDatosContactos(contacto, tablaContactos);

			// se realiza la insert

			tablaContactos.insert();

			return idContactos;

		} catch (Exception ex) {

			java.io.StringWriter sw = new java.io.StringWriter();

			java.io.PrintWriter pw = new java.io.PrintWriter(sw);

			ex.printStackTrace(pw);

			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()+ ":insertarContactos: " + sw.getBuffer().toString());

			throw ex;

		} finally {

			try {

				tablaContactos.freeResourcesNotConnection();

			} catch (Exception ex) {

				if (tr.isTraceActive()) {

					tr.trace(COMPONENTE,Q70TraceLevel.ERROR,this.getClass().getName()+ ":insertarContactos: error liberando recursos");

				}

			}

			if (tr.isTraceActive()) {

				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName()+ ":insertarContactos: saliendo");

			}

		}

	} // insertarContactosCuestionario

}

