package q02a.exe.comun.dataobjects;

import java.sql.Connection;
import java.sql.ResultSet;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;

import q02a.exe.arquitectura.dataobjects.Q02aDataBaseDAO;
import q02a.exe.tablasBD.jdbc.oracle.Q02aTablaBDQ022YS00;

/**
 * 
 * @author GADIMAAR
 *
 */
public class Q02aTablasDataBaseDAO extends Q02aDataBaseDAO {
	private static final long serialVersionUID = -8520551641771839103L;

    /**
     * 
     *
     */
	public Q02aTablasDataBaseDAO() {
		super();
	}

    /**
     * 
     * @param conn conn
     */
	public Q02aTablasDataBaseDAO(Connection conn) {
		super(conn);
	}

    /**
     * 
     * @param codigo codigo
     * @param tabla tabla
     * @return niCuestionarioOnline
     * @throws Exception Exception
     */
	public String getNiCuestionarioOnline(String codigo, String tabla) throws Exception {
		// se definen objetos necesarios.
		Q02aTablaBDQ022YS00 tablaBD = null;
		String niCuestionarioOnline = null;
		ResultSet rs = null;
		try {
			if (tr.isTraceActive()) {
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNiCuestionarioOnline: entrando");
			}
			// se crea el objeto de tablasBD
			tablaBD = new Q02aTablaBDQ022YS00(this.getConnection());
			tablaBD.setQ022XT00_NI_WHERE(Long.parseLong(tabla));
			tablaBD.setQ022YT00_COD_WHERE(codigo);
			rs=tablaBD.select();
		   	tablaBD.addResultSet(rs);
		   	if(rs.next()){
		   		niCuestionarioOnline =rs.getString(Q02aTablaBDQ022YS00.NOMCOLUMN_Q022YT00_NI);
		   	}
			return niCuestionarioOnline;
		} catch (Exception ex) {
			java.io.StringWriter sw = new java.io.StringWriter();
			java.io.PrintWriter pw = new java.io.PrintWriter(sw);
			ex.printStackTrace(pw);
			tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName()	+ ":getNiCuestionarioOnline: " + sw.getBuffer().toString());
			throw ex;
		} finally {
			try {
				tablaBD.freeResourcesNotConnection();
			} catch (Exception ex) {
				if (tr.isTraceActive()) {
					tr.trace(COMPONENTE, Q70TraceLevel.ERROR, this.getClass().getName() + ":getNiCuestionarioOnline: error liberando recursos");
				}
			}
			if (tr.isTraceActive()) {
				tr.trace(COMPONENTE, Q70TraceLevel.INFO, this.getClass().getName() + ":getNiCuestionarioOnline: saliendo");
			}
		}
	}
}
